; $	HT	QT(IUK)		AF(S)		P(EZ)
; $	AT	QT(IU)		AF(K)		P(E)
; $ AE	V(-)			H(-)		R(-)

(defun load-modules ()
   (load "mod-endinit-uz-stzsteg")
   (load "mod-multiconnect-stz-steg")
   (load "mod-lochbild")
)

(defun init-connection ()
   (if (= (Connect.get CastaData amHtSteg) 0) (progn
       (alertBox "Es liegt hier kein Steganschluss vor (!)" "NoWebConnection_Possible")
       (setq IsInside 0)
      )
      (progn
	(print "*clear*")
	(print "ERSTELLE ANSCHLUSS")
	(connect.showattributes CastaData)

	(setq LB_DEBUG 0)
	
        ; berprft zunchst ob der AT innerhalb hc des AT liegt
	(checkPosition)
  ))
  
  (if (= IsInside 1)
  	(progn
  		(init-traegerenden 0)				
			(setConnection)
		)
		(progn
			(alertBox "Anschluss nicht mglich!" "Connection_Not_Possible")
		)
	)						
														
)


(defun setConnection ()
	(if (= 1 1) (progn
  	
  ; berprfung der Umgebung auf Anbauteile
	;(checkForSteifen)
	;(if (= STEIFE_VORHANDEN 1)
	;	(print "Es ist bereits ein Anschluss mit Anbauteilen am HT-Steg vorhanden. Die Anschlsse knnten sich berschneiden." "WRN_WebConnection_Overlapping_AP")
	;)
	
	; berprfung auf weitere Anschlsse
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			; berprfung der Umgebung auf Anbauteile
			(setq anzAnschl (Connect.get CastaData anz_weitere_anschl))
		  (print anzAnschl)
		  (if (> anzAnschl 0)
				(checkEnv)
			)
		)
	)
	
  
  (setq blKpl (blech.create))	
	(Connect.storeAnschlObjs CastaData blKpl)
	
	(if (= (Connect.get CastaData exist_steglchb) 1)
  	(progn
			(print "Lochbild wurde bernommen.")
  		(setq lchbKpl (Connect.get CastaData steglchb_gegen))
  	)
		(progn
			(print "Lochbild wurde neu generiert.")
			(setq lchbKpl (lochbild.create))
		)
	)
	(Connect.storeAnschlObjs CastaData lchbKpl)
  
  
  (if (= (connect.get CastaData RechtesEnde) 1) 
  	(progn
  		(print "Anschluss rechts am Anschlusstrger")
  		; Kopfplatte
			
			(calcAndSetBlechdaten blKpl TrRechts)
			(traeger.addabtl tr_id blKpl 0.0 0.0 _kopfplatterechts_)

						
			(if (= (Connect.get CastaData exist_steglchb) 0)	(calcAndSetLochbildDaten lchbKpl TrRechts blKpl))
			(traeger.addabtl tr_id lchbKpl 0.0 0.0 _kpllochbildrechts_)
	
  	)
  )
  (if (= (connect.get CastaData LinkesEnde) 1) 
  	(progn
  		(print "Anschluss links am Anschlusstrger")
			
			(calcAndSetBlechdaten blKpl TrLinks)
			(traeger.addabtl tr_id blKpl 0.0 0.0 _kopfplattelinks_)

			
			(if (= (Connect.get CastaData exist_steglchb) 0)	(calcAndSetLochbildDaten lchbKpl TrLinks blKpl))
			(traeger.addabtl tr_id lchbKpl 0.0 0.0 _kpllochbildlinks_)
			
  	)
  )
  
  
  (if (= (Connect.get CastaData exist_steglchb) 1)
		(progn
			(print "hole existierendes Lochbild")
  		(getExistingLochbild)	
  	)
		(progn
  		;(createStegLochb lchbKpl)
			(if (= (connect.get CastaData LinkesEnde) 1) 	(setq AtEnde (Traeger.get Tr_ID links)))
			(if (= (connect.get CastaData RechtesEnde) 1) (setq AtEnde (Traeger.get Tr_ID rechts)))
			(createLochbildAbtl AtEnde blKpl)
			(Anpassung_Z_Profil)
  	)
  )  

  (if (= 2 3) (progn
	;; Testen - AF-20090513
	(Lochbild.set lchbKpl (LB_Art   2))			; AF-20090512
	(Lochbild.set lchbKpl (delta_w  25))		; AF-20090512
	(Lochbild.set lchbKpl (e    "0 30 100 0 0 0"))	; AF-20090512
	(Lochbild.set lchbKpl (w    "25 0"))		; AF-20090512

  ))
	
	(setq dp (Blech.get blKpl dp))
			
  
  ; Callbacks
  (Blech.set blKpl (formFkt "cb_blKpl"))
  
))
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr die Kopfplatte
; ----------------------------------------------------------------------------------------
(defun cb_blKpl (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;(print "in Callback-Funktion cb_KplBlech (normaler Stz-Anschluss)")

	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get blKpl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get blKpl dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml 	(Lochbild.get lchbKpl Klemml))
	       (setq altesDxSKopf (Lochbild.get lchbKpl dxSKopf))
	       
	      (if (= (Connect.get CastaData amHtStegLinks) 1)
	       (Lochbild.set lchbKpl 	(Klemml  (+ alteKlemml dpDiff))
	       												(dxSKopf (+ altesDxSKopf dpDiff))	       	
	       )
	      )
	      (if (= (Connect.get CastaData amHtStegRechts) 1)
	       (Lochbild.set lchbKpl 	(Klemml  (+ alteKlemml dpDiff)))
	      )
				
				(cbDeltaLR lchbKpl dpDiff)
	    ))
	))
)



; ---------------------------------------------------------------------
; Korrigiert die delta_lr Verschiebung des LB-ABTL bei einem Aufruf
; der Callbackfunktion (Dickennderung des Bleches)
; ---------------------------------------------------------------------
(defun cbDeltaLR (KPL_LB DP_DIFF)
	;(print "*clear*")
	(print ">------------------------------------------------------------------------------")
	(print "Anbauteil Korrektur wegen Callback-Funktion")
	
	; Anbauteil des HT-LB
	(setq ht_lb_abtl (Traeger.get Htrg Abteil KPL_LB))
				 
	; delta_lr Verschiebung des Anbauteils
	(setq delta_lr_abtl_alt (Anbauteil.get ht_lb_abtl delta_lr))
	(print delta_lr_abtl_alt)
	
	; Wert, um den das Anbauteil korrigiert wird (erstmal auf 0.0) 
	(setq delta_lr_abtl_neu 0.0)
	
	; Winkel des AT zum HT in horizontaler Richtung
	(setq h_wnkl_steg_at (Connect.get CastaData h-atrgewnkl_steg))
	(print h_wnkl_steg_at)
	
	(setq tanHW (tan (/ (* PI h_wnkl_steg_at) 180.0)))
	(print tanHW)
	
	(if (/= tanHW 0.0)
		(setq delta_lr_abtl_korr (/ DP_DIFF tanHW))
	)
	(print delta_lr_abtl_korr)
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq delta_lr_abtl_neu (- delta_lr_abtl_alt delta_lr_abtl_korr)))
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq delta_lr_abtl_neu (+ delta_lr_abtl_alt delta_lr_abtl_korr)))
	
	; Anbauteil korrigieren
	(print delta_lr_abtl_neu)
	(Anbauteil.set ht_lb_abtl (delta_lr delta_lr_abtl_neu))
	
	(print "<------------------------------------------------------------------------------")
)


; ---------------------------------------------------------------------- */
; Hilfsfunktionen
; ---------------------------------------------------------------------- */

; ##################################################################################################################
(defun createLochbildAbtl (TrgEnde BlechID)
	
	
	(print "--------------------------------------------------------------------------------")
	(print "ERZEUGE LOCHBILD")
	(setq delta_V  			(Traeger.get hTrg delta_v)
				hProf    			(Traeger.get hTrg h)
				delta_lr_ht		(Traeger.get hTrg delta_lr)
				qsform_ht			(Traeger.get Htrg qsform)
	)
	
	(setq delta_V2 			(Traeger.get Tr_ID delta_v)
				hProf2   			(Traeger.get Tr_ID h)
				delta_lr_trg 	(Traeger.get Tr_ID delta_lr)	
				rwinkel_at		(Traeger.get Tr_ID r_winkel)
	)
	
	
	(setq xPos_HT 			(Connect.get CastaData xPos_ht)
				vwinkel_uz		(Connect.get CastaData hpttrg_vwinkel)
				r_winkel_steg	(Connect.get CastaData r-atrgewnkl_steg)
				v_winkel_steg	(Connect.get CastaData v-atrgewnkl_steg)
	)
	(print xPos_HT)
	
	(setq abteil_winkel 0.0)
	
	(setq xPos xPos_HT)
	
	(if (= TrgEnde TrLinks)
		(progn 
			
			(traeger.addabtl hTrg lchbKpl xPos abteil_winkel _steglochbild_system_)
			
		)
	)
	(if (= TrgEnde TrRechts)
		(progn 
	
			(traeger.addabtl hTrg lchbKpl xPos abteil_winkel _steglochbild_system_)
			
		)
	)

	
	; Berechnet die Lochbilddaten der Verbindung zum HT-Steg
	(calcAndSetLochbildDaten lchbKpl TrgEnde BlechID)


	(setq e0_lb (Lochbild.get lchbKpl e0)
				e1_lb	(Lochbild.get lchbKpl e1)
	)
	
	(print e0_lb)
	
	(setq e_diff (- (+ e0_lb e1_lb) (- hProf2 e0_lb)))
	
	
	(if (= (Connect.get CastaData vatr-vhtr) -1)
		(setq delta_v_lb_ht (+ (- diff_oben) e_diff))
		(setq delta_v_lb_ht	(- diff_oben))
	)
	
	(setq ht_lochbild_abtl (Traeger.get Htrg Abteil lchbKpl))
	(setq at_lochbild_abtl (Traeger.get Tr_ID Abteil lchbKpl))
	
	; Differnzwinkel zwischen HT-Neigung und AT-Rotation berechnen
	; ---------------------------------------------
	(print vwinkel_uz)
	(print rwinkel_at)
	(print r_winkel_steg)
	
	(setq diffWinkel 0.0)
		
	(setq TestWinkel (Connect.get CastaData r-atrgewnkl_steg))
	
	(setq KorrWinkel 0.0)
	(if (= (Connect.get CastaData amhtstegLinks) 1) (progn
		(if (= (Connect.get CastaData linkesEnde)  1) (setq KorrWinkel 180.0))
		(if (= (Connect.get CastaData rechtesEnde) 1) (setq KorrWinkel 360.0))
	))
	(if (= (Connect.get CastaData amhtstegRechts) 1) (progn
		(if (= (Connect.get CastaData linkesEnde)  1) (setq KorrWinkel 360.0))
		(if (= (Connect.get CastaData rechtesEnde) 1) (setq KorrWinkel 180.0))
	))
	(setq diffWinkel (- KorrWinkel TestWinkel))
	(if (= (Connect.get CastaData satr-lhtr-ex) -1) (setq diffWinkel (- KorrWinkel TestWinkel)))
	(if (= (Connect.get CastaData satr-lhtr-ex)  1) (setq diffWinkel (+ KorrWinkel TestWinkel)))
	(print diffWinkel)
	
	(setq sinW (sin (/ (* PI diffWinkel) 180.0)))
	(setq cosW (cos (/ (* PI diffWinkel) 180.0)))
	(setq tanW (tan (/ (* PI diffWinkel) 180.0)))
	
	; Positionierung des Anbauteil-Lochbildes am HT
	; ----------------------------------------------
	(setq verschiebung_delta_lr 0.0)
	(setq verschiebung_delta_v 0.0)
	
	; Winkel des Anbauteils
	; ----------------------------------------------
	(setq abtl_winkel 0.0)
	
	(setq abtl_winkel diffWinkel)
		
	(print abtl_winkel)
	
	
	; Grundausrichtung des HT-LB
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
	(if (= (Connect.get CastaData rechtesEnde) 1) (setq At_Ende (Traeger.get Tr_ID rechts)))
	(if (= (Connect.get CastaData linkesEnde) 1) 	(setq At_Ende (Traeger.get Tr_ID links)))
	
	(setq vscherl_at (TrEnde.get At_Ende vscherl))
	(setq s_ht (Traeger.get Htrg s))
	(setq s_ht_halb (* 0.5 s_ht))
	
	(setq h_ht_halb (* 0.5 vscherl_at))
	(setq verschiebung_delta_v (- verschiebung_delta_v h_ht_halb))
	
	; Anteil halbe Stegdicke
	(print v_winkel_steg)
	(setq tanVSTEG (tan (/ (* PI v_winkel_steg) 180.0)))
	
	(setq anteil_s_at_halb (/ s_ht_halb tanVSTEG))
	;(if (< anteil_s_at_halb 0.0)
	;	(setq anteil_s_at_halb (- anteil_s_at_halb))
	;)
	(print anteil_s_at_halb)
	

	(if (= (Connect.get CastaData LinkesEnde)  1)	(setq verschiebung_delta_v (- verschiebung_delta_v anteil_s_at_halb)))
	(if (= (Connect.get CastaData RechtesEnde)  1)	(setq verschiebung_delta_v (+ verschiebung_delta_v anteil_s_at_halb)))
	
	
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	; HT-Verschiebungen
	; ++++++++++++++++++++++++++++++++++++++++++++++
	
	; Anteil delta_v / delta_lr Anbauteil bei delta_v Verschiebung HT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(setq delta_v_ht (Traeger.get Htrg delta_v))
		(print delta_v_ht)
		
		; Anteil delta_v
		(setq verschiebung_delta_v (+ verschiebung_delta_v (* (* 1.0 delta_v_ht) sinW)))
		(print verschiebung_delta_v)
		
		; Anteil delta_lr
		(setq verschiebung_delta_lr (+ verschiebung_delta_lr (* (* 1.0 delta_v_ht) cosW)))
		(print verschiebung_delta_lr)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	
	; AT-Verschiebungen
	; ++++++++++++++++++++++++++++++++++++++++++++++
	
	; Verschiebung delta_v des Anbauteils
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------	
		(setq verschiebung_delta_v (+ verschiebung_delta_v delta_V2))
		(print verschiebung_delta_v)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	; Anteil delta_lr Verschiebung AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		
		(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
		
		(if (= (Connect.get CastaData amHtStegLinks)  1)	
			(progn
				(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_delta_lr (- verschiebung_delta_lr delta_lr_at)))
				(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_lr (+ verschiebung_delta_lr delta_lr_at)))
			)
		)
		(if (= (Connect.get CastaData amHtStegRechts) 1)
			(progn
				(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_delta_lr (+ verschiebung_delta_lr delta_lr_at)))
				(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_lr (- verschiebung_delta_lr delta_lr_at)))
			)
		)
		
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	; Horizontale Neigung des AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(setq at_h_winkel_steg (Connect.get CastaData h-atrgewnkl_steg))
		
		(setq dp_kpl (Blech.get BlechID dp))
		
		(setq s_ht (Traeger.get Htrg s))
		
		(print at_h_winkel_steg)
		(print dp_kpl)
		
		(setq s_ht_halb_plus_dp_kpl (+ (* 0.5 s_ht) dp_kpl))
		(print s_ht_halb_plus_dp_kpl)
		
		(setq tanAFW (tan (/ (* PI at_h_winkel_steg) 180.0)))
		(print tanAFW)
		
		(setq anteil_h_neig_at (/ s_ht_halb_plus_dp_kpl tanAFW))
		(print anteil_h_neig_at)
		
		(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_h_neig_at)))
		(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_h_neig_at)))
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	; Besonderheiten Profile
	; ++++++++++++++++++++++++++++++++++++++++++++++
	(setq s_at			(Traeger.get Tr_ID s)
				qsform_at	(Traeger.get Tr_ID qsform)
	)
	
	; U-Profil
	; ----------------------------------------------
	; LB in die Mitte setzen
	(if (= qsform_at "U")
		(progn
			; delta_lr Verschiebung berechnet bzgl. AT
			; ------------------------------------------
			(setq uProf_anpassung (- (* 0.5 s_at)))
			(setq uProf_anpassung 0.0)			; gendert Mrz-2014
			
			(setq anteil_delta_lr_am_ht (* uProf_anpassung cosW))
			
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_delta_lr_am_ht))
					)
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_delta_lr_am_ht))
					)
				)
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_delta_lr_am_ht))
					)	
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_delta_lr_am_ht))
					)
				)
			)
			
			(setq anteil_delta_v_am (* uProf_anpassung sinW))
			
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(setq verschiebung_delta_v (+ verschiebung_delta_v anteil_delta_v_am))
					)
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(setq verschiebung_delta_v (- verschiebung_delta_v anteil_delta_v_am))
					)
				)
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(setq verschiebung_delta_v (- verschiebung_delta_v anteil_delta_v_am))
					)
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(setq verschiebung_delta_v (+ verschiebung_delta_v anteil_delta_v_am))
					)
				)
			)
			
		)
	)
	
	
	; Korregiert das Lochbild und die Kopfplatte bei schrgem Anschluss, damit die Schrauben
 	; eingesetzt werden knnen
 	; --> Asymmetrie
 	;(korrBlech lchbBlech BlechID)
 	;(korrLochbild lchbBlech BlechID)
 	; <-------------------------
	
	
	; Werte setzen
	; ----------------------------------------------
	(print verschiebung_delta_v)
	(print verschiebung_delta_lr)
	(Anbauteil.set ht_lochbild_abtl (delta_v 	verschiebung_delta_v)
					(delta_lr 	verschiebung_delta_lr)
					(winkel		abtl_winkel)
	)
	
	(if (= qsform_at "U")
		(Anbauteil.set at_lochbild_abtl (delta_lr uProf_anpassung))
	)

	; Master setzen
	; ----------------------------------------------
	(Anbauteil.set ht_lochbild_abtl (Master 1))
	(Anbauteil.set at_lochbild_abtl (Master 0))
	
	
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(Anbauteil.set ht_lochbild_abtl 	(SeitRicht -1))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(Anbauteil.set ht_lochbild_abtl 	(SeitRicht -1))
			)
		)
	)
	
	; LOCHBILD-TEST
	;===================================================================
	(if (= LB_DEBUG 1)
		(progn
		
			(Anbauteil.ShowDialog ht_lochbild_abtl)
			
			(setq dummy (Lochbild.create))
			(Lochbild.copy dummy lchbKpl)
						
			(if (= (connect.get CastaData LinkesEnde) 1) 
				(traeger.addabtl Tr_ID dummy 0.0 0.0 _kpllochbildlinks_)
    	)
	    (if (= (connect.get CastaData RechtesEnde) 1) 
				(traeger.addabtl Tr_ID dummy 0.0 0.0 _kpllochbildrechts_)
	    )
			
			(setq dummy_abtl (Traeger.get Tr_ID Abteil dummy))
			(Anbauteil.set dummy_abtl (Master 1))
			
			(if (= qsform_at "U")	
				(Anbauteil.set dummy_abtl (delta_lr uProf_anpassung))
			)
		)
	)
	;===================================================================
	(print "------------------------------------------------------------")
)





; ----------------------------------------------------------------------------------------
; BERECHNUNG DER KOPFPLATTENDATEN
; ----------------------------------------------------------------------------------------
(defun calcAndSetBlechdaten (blKopfplatte TrgEnde)
	(print "------------------------------------------------------------")
	(print "BERECHNE KOPFPLATTE")

;	(print bflansch)
  (setq	h_at 	(Traeger.get Tr_ID h)
  	b_at	(Traeger.get Tr_ID b)
  	t_at	(Traeger.get Tr_ID t)
  	s_at	(Traeger.get Tr_ID s)
  	r_at	(Traeger.get Tr_ID r)
  	hc_at	(Traeger.get Tr_ID hc)
  )
  (setq bflansch (Traeger.get HTrg b))				;; neu eingesetzt Mrz 2010

  (setq s_ht	(Traeger.get Htrg s))
	 
  (setq hp	h_at)		; erstmal so voreinstellen
  (setq dOK  	   5)

  (setq yAkl		(TrEnde.get TrgEnde yAkl)
        bflansch	(TrEnde.get TrgEnde bFlansch)
  )

	; Blechdicke
	; ----------------------------------------------
	(setq t_at_rund (runde t_at auf 5))
	(setq dp t_at_rund)
  (print dp)


	; Schraubenbezeichnung aus min. Blechdicke ("mod-lochbild")
	(if (< dp s_ht)
		(setq min_bl dp)
		(setq min_bl s_ht)
	)
	(calcSchraube min_bl) 	; -> S_Bez
	(print s_bez)
	; Schraubenbezeichnung den Lochbildern zuweisen
	(Lochbild.set lchbKpl (S_Bez S_Bez))
	
	
	; default Rand- und Lochabstnde aus Schraubendurchmesser bestimmen
	(calcMinRandLochAbst lchbKpl)	; -> e_min_rund, e1_min_rund, min_h
	
	(setq	diffSeitV	0.0)
	(setq	dv_HT		(Traeger.get HTrg  delta_V))
	(setq	dlr_AT		(Traeger.get Tr_ID delta_LR))
	(if (= (Connect.get CastaData satr-vhtr)  1) (setq diffSeitV (- dv_HT dlr_AT)))
	(if (= (Connect.get CastaData satr-vhtr) -1) (setq diffSeitV (+ dv_HT dlr_AT)))
	
	
	; Blechbreite
	; ----------------------------------------------
	(setq bp (+ b_at 5.0 5.0))
	(print bp)
	(setq s_at_rund (runde s_at auf 5))
	(setq min_bp (+ s_at_rund e1_min_rund (* 2 e_min_rund)))
	
	(if (< bp min_bp)
		(setq bp min_bp)
	)
	(print bp)
	
	
	
  (setq EWinkel (TrEnde.get TrgEnde V_Winkel))
  (print EWinkel)
  
	(setq sinW (sin (* PI (/ EWinkel 180.0))))
	(if (/= sinW 0) (setq hp (/ hp sinW)))

  (setq hp (- hp dOK 5))	; wir erzeugen eine bndige Kopfplatte
	(setq hp (runde hp auf 5))      
	
	;Blechbreite
	(setq delta_lr_blech 0)
	(print bflansch)
	(print yakl)
	(setq yakl2 (- b_at bflansch yakl))
	(print yakl2)
	
	(if (/= bflansch 0.0)
		(progn
			(print "bflansch /= 0")
			(if (/= yakl 0.0)
				(progn
					(print "yakl /= 0")
					(setq bp bflansch)
					
					(if (== yakl yakl2)
						(progn	(setq delta_lr_blech 0.0))
						(progn
							(setq ausgl_versch (- yakl yakl2))
							(print ausgl_versch)
							(setq delta_lr_blech (- (* 0.5 ausgl_versch)))
						)
					)
					
				)
				(progn
					(print "yakl == 0")
					(setq bp bflansch)
					(setq delta_lr_blech (* 0.5 (- b_at bflansch)))
					; (setq delta_lr_blech  0.0)
				)
			)
		)
		(progn
			(print "bflansch == 0")
			(if (/= yakl 0.0)
				(progn
					(print "yakl /= 0")
					(setq bp (- b_at yakl))
					(setq delta_lr_blech (- (* 0.5 yakl)))
				)
				(progn
					(print "yakl == 0")
					(setq bp bp)
				)
			)
		)
	)
	(print delta_lr_blech)
	(print bp)
	(print hc_ht)
	
	(if (>= bp hc_ht)
		(setq bp hc_ht)
	)
	
	
	; Blechhhe
	(setq hp_soll hp)
	
	
	(if hsteg
		(progn
			(print hsteg)
			; Blechhhe und dok aus Ausklinkung
			(if (/= hsteg 0.0)							
				(progn
					(print "hsteg /= 0")
					(if (/= zakl 0.0)						; unten und oben
						(progn
							(print "zakl /= 0")
							(setq hp_soll hsteg)
							(setq doK zakl)
						)													; nur unten
						(progn
							(print "zakl = 0")
							;(setq hp_soll (- h_at t_at r_at (- h_at hsteg)))
							(setq hp_soll (- hsteg dok))
							
						)
					)
				)
				(progn
					(print "hsteg = 0")
					(if (/= zakl 0.0)						; nur oben
						(progn
							(print "zakl /= 0")
							(setq hp_soll (- h_at zakl dok))
							(setq dok zakl)
						)													; keine
						(progn
							(print "zakl = 0")
							(setq doK dok)
						)
					)
				)
			)
		)
	)
	
	
  	(setq qsform_ht (Traeger.get Htrg qsform))
	(if (= qsform_ht "U") (progn
	    ; Wenn am U-Rcken, dann braucht nichts ausgeklinkt zu werden.
	    (if (= (connect.get CastaData LinkesEnde) 1) (progn
		    (if (= (connect.get CastaData at-von-rechts) 1) (progn
;		    	 (print "LinkesEnde und at-von-rechts")
		         (setq h_HT (Traeger.get HTrg  h))
		         (setq b_AT (Traeger.get Tr_ID b))
		         (if (< h_HT b_AT) (setq bp h_HT))
		    	 (if (= (connect.get CastaData satr-vhtr) -1) (setq delta_lr_blech    diffSeitV))
		    	 (if (= (connect.get CastaData satr-vhtr)  1) (setq delta_lr_blech (- diffSeitV)))
		    ))
	    ))
	    (if (= (connect.get CastaData RechtesEnde) 1) (progn
		    (if (= (connect.get CastaData at-von-links) 1) (progn
;		    	 (print "RechtesEnde und at-von-links")
		         (setq h_HT (Traeger.get HTrg  h))
		         (setq b_AT (Traeger.get Tr_ID b))
		         (if (< h_HT b_AT) (setq bp h_HT))
		    	 (if (= (connect.get CastaData satr-vhtr) -1) (setq delta_lr_blech    diffSeitV))
		    	 (if (= (connect.get CastaData satr-vhtr)  1) (setq delta_lr_blech (- diffSeitV)))
		    ))
	    ))
	))
	
	(print delta_lr_blech)
	
	(Blech.set blKopfplatte		(dp dp) 
					(hp hp_soll) 
					(bp bp) 
					(dOK dOK)
					(delta_lr (- delta_lr_blech))
	)

  (setq htDeltaV (Traeger.get hTrg delta_V))

  (setq delta_L dp)
  (if (> vwnkl_aflch 180) (setq delta_L (- delta_L)))
  (print delta_L)
    		
  
  (TrEnde.pTrim TrgEnde dp)
  

	(print "------------------------------------------------------------")
)
; ----------------------------------------------------------------------------------------
; BERECHNET DIE LOCHBILDDATEN
; ----------------------------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lchb_ID TrgEnde BlechID)
	(print "------------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID 
		(Guete   "4.6")
		(e       "60 60 0 0 0 0")
		(w       "80  0")
	)
	
	(setq h_trg 		(Traeger.get Tr_ID h)
				s_trg 		(Traeger.get Tr_ID s)
				b_trg			(Traeger.get Tr_ID b)
				r_trg			(Traeger.get Tr_ID r)
				qsform_at	(Traeger.get Tr_ID qsform)
	)
	
	(setq t_htrg 			(Traeger.get Htrg t)
				s_htrg			(Traeger.get Htrg s)
				r_htrg			(Traeger.get Htrg r)
				delta_l_ht	(Traeger.get Htrg delta_l)
	)
	
	
	(setq h_trg_halb	(* h_trg 0.5))
	
	
	; Den entsprechenden Durchmesser holen
	(setq d_schr (Lochbild.get Lchb_ID sdurchm))
	
	(setq e_blech (* d_schr 2.0))				; Randabstand
	(setq e1_blech (* d_schr 4.0))			; Lochabstand
	
	(setq e_blech_rund (runde e_blech auf 5))
	(setq e1_blech_rund (runde e1_blech auf 5))
	
	(setq min_hp (+ e1_blech_rund (* e_blech_rund 2.0))) ; min. Winkelhhe aus Lochbild
	
	
	(setq akt_hp 		(Blech.get BlechID hp)
				akt_dok		(Blech.get BlechID dok)
				dp_blech	(Blech.get BlechID dp)
				akt_bp		(Blech.get BlechID bp)
	)
	
	; Anteil dok_kpl auf e0
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	(setq tanA (tan (/ (* PI at_winkel) 180.0)))
	(setq anteil_kpl (/ dp_blech tanA))
	
	(if (= (Connect.get CastaData vatr-lhtr)  1)	
		(progn
			(setq anteil_kpl (- anteil_kpl))
			
		)
	)
	(print anteil_kpl)
	(print akt_dok)
	
	(setq e0 0)
	
	(if (> akt_hp min_hp)
		(progn
			(setq e0 (+ (* 0.25 akt_hp) akt_dok (- anteil_kpl)) )
			(print e0)
			(setq e0rund (runde e0 auf 5))
			(print e0rund)
			(setq e1 (* 0.5 akt_hp))
			(setq e1rund (runde e1 ab 5))
			
			(Lochbild.set Lchb_ID (e0 e0rund)
														(e1 e1rund)
														
			)
		)
		(progn
			(Lochbild.set Lchb_ID (Anz_S 2))
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq e0 (+ (* 0.5 akt_hp) akt_dok (- anteil_kpl)) ))
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq e0 (- (* 0.5 akt_hp) akt_dok (+ anteil_kpl)) ))
			
			(print e0)
			(setq e0rund (runde e0 auf 5))
			(print e0rund)
			
			(Lochbild.set Lchb_ID (e0 e0rund)
														(e1 0)
			)
		)		
	)
	(print e0)
	
	(if (= LB_DEBUG 1)
		(progn
			(if (> akt_hp min_hp)
				(Lochbild.set Lchb_ID (e2 300))
				(Lochbild.set Lchb_ID (e1 300))
			)
		)
	)
	
	
	; Prfe hier, ob der Mindestrandabstand von 1.5 d vorhanden ist.
	; wenn kja, wird ein normales Lochbild eingesetzt, ansonsten ein 
	; halbes.
	
	(setq lbart 0)
   (if (= 1 2) (progn
	(if (/= b_at akt_bp)
		(progn
			(setq rest (- akt_bp (* 2.0 e_blech)))
			(setq minAbst (* 1.5 e_blech))

			
			(if (< rest minAbst)
				(progn
					(if (/= bflansch 0)
						(progn
							(if (/= yakl 0)	
								(progn
									(setq lbart 2)
								)
								(progn
									(setq lbart -2)
								)
							)
						)
						(progn
							(if (/= yakl 0)	
								(progn
									(setq lbart 2)
								)
								(progn
									(setq lbart 0)
								)
							)
						)
					)					
				)
			)
		)
	)
   ))
	(print lbart)
	
	(setq helpVar (- akt_bp s_trg))
	(setq w0 (- akt_bp (* 0.5 helpVar)))
	
	(setq w0 (runde w0 auf 5))
	
	(if (/= lbart 0)
		(setq w0 (* 0.5 w0))
	)
	
	;(Lochbild.set Lchb_ID (w0 e1_blech_rund))
	(Lochbild.set Lchb_ID (w0 w0))
	
	
	
	; DxSKopf
	(calcDxSKopf s_htrg dp_blech)
	
	(calcUnterschied)
	
	(Lochbild.set Lchb_ID (klemml 	(+ s_htrg dp_blech))
			      		(dxSKopf  dxS)
			      		(lb_art lbart)
			      						
	)
	(print lbart)
	;(Blech.set BlechID (bp (+ (* 2 e_blech_rund) w0)))
	
	(print "ENDE LOCHBILDDATEN")
	(print "------------------------------------------------------------")
)

; ----------------------------------------------------------------------------------------
; Berechnet dxskopf
; ----------------------------------------------------------------------------------------
(defun calcDxSKopf (s_htrg dp_blech)
	
	(if (= qsform_ht "I")
		(progn
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(setq dxS (+ (* 0.5 s_htrg) dp_blech))
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(setq dxS (* 0.5 s_htrg))
			)
		)
	)
	
	(if (= qsform_ht "U")
		(progn
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(setq dxS dp_blech)
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(setq dxS 0)
			)
		)
	)
)

; ----------------------------------------------------------------------------------------
; Prft, ob der Steg des AT in den HC-Berech des HT liegt
; ----------------------------------------------------------------------------------------
(defun checkPosition ()
	(print "------------------------------------------------------------")
	(print "BERPRFE AT POSITION")
	(print "------------------------------------------------------------")
	
	(setq hc_ht 			(Traeger.get Htrg hc)
				delta_v_ht	(Traeger.get Htrg delta_v)
	)
	
	(setq delta_lr_at	(Traeger.get Tr_ID delta_lr)
				s_at				(Traeger.get Tr_ID s)
	)
	
	; obere und untere Ausrundung des HT
	(setq ausrO_ht (- delta_v_ht (* 0.5 hc_ht)))
	(setq ausrU_ht (+ ausrO_ht hc_ht))
	(print ausrO_ht)
	(print ausrU_ht)
	(print delta_lr_at)
		
	(setq isInside 1)
	
	(if (= (Connect.get CastaData satr-vhtr) 1)
		(progn
			(if (> delta_lr_at ausrU_ht)
				(progn
					(setq isInside 0)
				)
				(progn
					(if (< delta_lr_at ausrO_ht)
						(setq isInside 0)
						(setq isInside 1)
					)
				)
			)
		)
	)
	(if (= (Connect.get CastaData satr-vhtr) -1)
		(progn
			(if (> delta_lr_at (- ausrO_ht))
				(progn
					(setq isInside 0)
				)
				(progn
					(if (< delta_lr_at (- ausrU_ht))
						(setq isInside 0)
						(setq isInside 1)
					)
				)
			)
		)
	)
	
	(if (= isInside 0)
		(print "AUSSERHALB")
		(print "INNERHALB")
	)
)


(defun getExistingLochbild ()
	(alertBox "Auf der gegenberliegenden Seite ist bereits ein Anschluss vorhanden. Nehmen Sie nderungen ggf. manuell vor." "OppositeSideConnection_Found")
				
	(setq dp_kpl (Blech.get blKpl dp))
	(print dp_kpl)
			
	(setq klemml_alt 	(Lochbild.get lchbKpl klemml))
	(setq dxskopf_alt	(Lochbild.get lchbKpl dxsKopf))
	(print klemml_alt)
	(print dxskopf_alt)
			
	(setq klemml_neu 	(+ klemml_alt dp_kpl))
	(setq dxskopf_neu (+ dxskopf_alt dp_kpl))
	(print klemml_neu)
	(print dxskopf_neu)
			
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(Lochbild.set lchbKpl (klemml klemml_neu)
													;(dxsKopf dxskopf_neu)
		)
	)									
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(Lochbild.set lchbKpl (klemml klemml_neu)
													(dxsKopf dxskopf_neu)
		)
	)
	
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(traeger.addabtl tr_id lchbKpl 0.0 0.0 _kpllochbildrechts_)
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
		(traeger.addabtl tr_id lchbKpl 0.0 0.0 _kpllochbildlinks_)
	)
			
	(setq delta_v_at 	(Traeger.get Tr_ID delta_v)
				delta_lt_at	(traeger.get Tr_ID delta_lr)
	)
			
	(setq loch_at_abtl (Traeger.get Tr_ID Abteil lchbKpl))
		  
	(Anbauteil.set loch_at_abtl (Master 	0)
		  												;(delta_v 	(- delta_v_at))
		  												;(delta_lr 40); ??? funktioniert nicht
	)							
)

(defun calcUnterschied ()
	
	(setq h_ht				(Traeger.get Htrg h)
				delta_v_ht	(Traeger.get Htrg delta_v)
	)
	(setq h_at				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	
	(setq h_ht_halb	(* 0.5 h_ht))
	(setq h_at_halb	(* 0.5 h_at))
	
	; Ober- / Unterkante der Trger
	(setq oKante_ht (- delta_v_ht h_ht_halb))				(print oKante_ht)
	(setq uKante_ht (+ oKante_ht h_ht))							(print uKante_ht)
	(setq oKante_at	(- delta_v_at h_at_halb))				(print oKante_at)
	(setq uKante_at (+ oKante_at h_at))							(print uKante_at)
	
	(if (= (Connect.get CastaData vatr-vhtr) -1)
		(progn
			(setq oKante_at_tmp oKante_at)
			(setq uKante_at_tmp uKante_at)
			
			(setq oKante_at (- uKante_at_tmp))
			(setq uKante_at (- oKante_at_tmp))
		)
	)
		
	(setq diff_oben (- oKante_at oKante_ht))
	
	
	
	(print diff_oben)
	
)

(defun Anpassung_Z_Profil ()

	(setq qsType (Traeger.get Tr_ID qsForm))
	(if (= qsType "C") (progn
		(setq b_AT (Traeger.get Tr_ID b)
				 h_AT (Traeger.get Tr_ID h)
		)
	
		(Blech.set blKpl (bp b_AT) (hp h_AT) (dOK 0))
		(Blech.set  blKpl (xAsym (* 0.5 b_AT)))

		(Lochbild.set lchbKpl (LB_Art 2))
		(Lochbild.set lchbKpl (w0 (* 0.5 b_AT)))
	
	
	
	))


)