; $	G(1) 	HT	 QT(IU)	 	AF(S)		P(EZ)
; $	G(1)	AT	 QT(IU) 	AF(K)		P(E)
; $	G(1)	AE	 V(-)		H(-)		R(46-90)
; $	G(31) HT	 QT(IU)	 	AF(S)		P(EZ)
; $	G(31)	AT	 QT(IU) 	AF(K)		P(E)
; $	G(31)	AE	 V(-)		H(-)		R(-)
; $	HT	QT(IU)	 AF(S)		P(EZ)
; $	AT	QT(IU) 	 AF(K)		P(E)
; $	AE	V(-)	 H(-)		R(-)

(defun load-modules ()
   (load "mod-lochbild")
	 (load "mod-utils")
	 (load "uz_an_uzCoupBlech")
)

(defun init-connection ()

  (print "in init-connection uz_an_uzCoupBlech");
	; (connect.showattributes CastaData)
	(setq LB_DEBUG 0)
	(setq COUPON_TYPE 3) ; 1 = ohne Gurtplatte
											 ; 2 = mit Gurtplatte
											 ; 3 = nur Kontaktplatte
	
	; spitzester Anschlusswinkel zwischen HT und AT
	; -----------------------------------------------------------------
	(setq grenzwinkel 15.0)
	
	(setq h_winkel_atht (Connect.get CastaData h-atrgewnkl_steg))
	
	(if (> h_winkel_atht grenzwinkel)
		(progn
			(print h_winkel_atht)
			(setq max (- 180.0 grenzwinkel))
			(print max)
			(if (> max h_winkel_atht)
				(progn
					(print "Winkel ok")
					(setq qsform_ht (Traeger.get Htrg qsform))
					(print qsform_ht)
					(if (= qsform_ht "U")
						(progn
							(print "QUERSCHNITT: U")
							(if (= (Connect.get CastaData amHtStegLinks) 0)	
								(progn
									(print "STEG LINKS")
									(setConnection)
									(calcHTrgEndeAblaengung_UZ)
								)
							)
						)
						(progn
							(setConnection)
							(calcHTrgEndeAblaengung_UZ)
						)
					)
				)
			)
		)
	)
	
	
)


;########################################################################################
;# CALLBACKS
;########################################################################################

; ----------------------------------------------------------------------------------------
; Kontaktplatte des Coupons wird verndert
; ----------------------------------------------------------------------------------------
(defun cb_cpFrontBlech (zp)
	(print "CALLBACK: cb_cpFrontBlech <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
	(print zp)

	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dp_alt (Blech.get cpFrontBlech dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dp_neu (Blech.get cpFrontBlech dp))
	    
	    (print dp_alt) (print dp_neu)
	    
	    (if (/= dp_alt dp_neu) 
				(progn
					(setq dpDiff (- dp_neu dp_alt))
					(setq alteKlemml  (Lochbild.get cplchb Klemml))
					(setq altesDxS		(Lochbild.get cplchb dxsKopf))
	       
					(Lochbild.set cplchb 	(Klemml (+ alteKlemml dpDiff))
								; (DxSKopf (+ altesDxS dpDiff))
								(callbackfl 1)
					)
					
					(print dpDiff)
					(if (= (Connect.get CastaData linkesEnde)  1)	(setq At_Ende (Traeger.get Tr_ID links)))
					(if (= (Connect.get CastaData rechtesEnde) 1)	(setq At_Ende (Traeger.get Tr_ID rechts)))
					(print At_Ende)
					(TrEnde.ptrim At_Ende dpDiff)
					
					
				)
			)
	))
)

; ----------------------------------------------------------------------------------------
; Stegplatte des Coupons wird verndert
; ----------------------------------------------------------------------------------------
(defun cb_cpStegBlech (zp)
	(print "CALLBACK: cb_cpFrontBlech <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
	(print zp)

	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq bp_alt (Blech.get cpStegBlech bp))
			
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq bp_neu (Blech.get cpStegBlech dp))
	    
	    (print bp_alt) (print bp_neu)
	    
	    (if (/= bp_alt bp_neu) 
				(progn
					(setq dpDiff (- bp_neu bp_alt))
					
					
	       
					
					
					(print dpDiff)
					(if (= (Connect.get CastaData linkesEnde)  1)	(setq At_Ende (Traeger.get Tr_ID links)))
					(if (= (Connect.get CastaData rechtesEnde) 1)	(setq At_Ende (Traeger.get Tr_ID rechts)))
					(print At_Ende)
					(TrEnde.ptrim At_Ende dpDiff)
					
					
				)
			)
	))
)

; ----------------------------------------------------------------------------------------
; Kopfplatte wird verndert
; ----------------------------------------------------------------------------------------
(defun cb_atKpl (zp)
	(print "CALLBACK: cb_blKopfplatte <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
	(print zp)

	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dp_alt (Blech.get atKpl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dp_neu (Blech.get atKpl dp))
	    
	    (print dp_alt) (print dp_neu)
	    
	    (if (/= dp_alt dp_neu) 
				(progn
					(setq dpDiff (- dp_neu dp_alt))
					(setq alteKlemml (Lochbild.get cplchb Klemml))
					(setq altesDxS		(Lochbild.get cplchb dxsKopf))
	       
					(Lochbild.set cplchb 	(Klemml (+ alteKlemml dpDiff))
								; (DxSKopf (+ altesDxS dpDiff))
								(callbackfl 1)
					)
					
					(cbDeltaLR cplchb cpFrontBlech dpDiff)
				)
			)
	))
)


; ---------------------------------------------------------------------
; Korrigiert die delta_lr Verschiebung des LB-ABTL bei einem Aufruf
; der Callbackfunktion (Dickennderung des Bleches)
; ---------------------------------------------------------------------
(defun cbDeltaLR (KPL_LB FRONT DP_DIFF)
	;(print "*clear*")
	(print ">------------------------------------------------------------------------------")
	(print "Anbauteil Korrektur wegen Callback-Funktion")
	
	; Anbauteil des HT-LB
	(setq ht_lb_abtl 	(Traeger.get Htrg Abteil KPL_LB))
	
	(setq fp_delta_lr_alt (Blech.get FRONT delta_lr))
	
	; delta_lr Verschiebung des Anbauteils
	(setq delta_lr_abtl_alt (Anbauteil.get ht_lb_abtl delta_lr))
	(print delta_lr_abtl_alt)
	
	; Wert, um den das Anbauteil korrigiert wird (erstmal auf 0.0) 
	(setq delta_lr_abtl_neu 0.0)
	
	; Winkel des AT zum HT in horizontaler Richtung
	(setq h_wnkl_steg_at (Connect.get CastaData h-atrgewnkl_steg))
	(print h_wnkl_steg_at)
	
	(setq tanHW (tan (/ (* PI h_wnkl_steg_at) 180.0)))
	(print tanHW)
	
	(if (/= tanHW 0.0)
		(setq delta_lr_abtl_korr (/ DP_DIFF tanHW))
	)
	(print delta_lr_abtl_korr)
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq delta_lr_abtl_neu (- delta_lr_abtl_alt delta_lr_abtl_korr)))
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq delta_lr_abtl_neu (+ delta_lr_abtl_alt delta_lr_abtl_korr)))
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq fp_delta_lr_neu (- fp_delta_lr_alt delta_lr_abtl_korr)))
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq fp_delta_lr_neu (+ fp_delta_lr_alt delta_lr_abtl_korr)))
	
	; Anbauteil korrigieren
	(print delta_lr_abtl_neu)
	(Anbauteil.set ht_lb_abtl (delta_lr delta_lr_abtl_neu))
	
	(Blech.set FRONT (delta_lr fp_delta_lr_neu))
	(print "<------------------------------------------------------------------------------")
)