; $	HT	QT(IU)		AF(S)		P(EZ)
; $ 	AT	QT(KRS)	AF(K)		P(E)
; $	AE	V(90)		H(90)		R(-)

; ------------------------------------------------
; externe Module einbinden
; ------------------------------------------------
(defun load-modules ()
   (load "mod-endinit-uz-uzsteg")
   (load "mod-lochbild")
)
; ------------------------------------------------

(defun init-connection ()

   (print "*clear*")
;   (print "Druckrohr mit Fahne am Steg anschlieen")
  (if (= (Connect.get CastaData amHTOberflansch ) 1) (progn
       (if (= (Connect.get CastaData linkesEnde)  1) (print "am HT Oberflansch - linkes  Ende"))
       (if (= (Connect.get CastaData rechtesEnde) 1) (print "am HT Oberflansch - rechtes Ende"))
  ))
  (if (= (Connect.get CastaData amHTUnterflansch ) 1) (progn
       (if (= (Connect.get CastaData linkesEnde)  1) (print "am HT Unterflansch - linkes  Ende"))
       (if (= (Connect.get CastaData rechtesEnde) 1) (print "am HT Unterflansch - rechtes Ende"))
  ))
  (print "------------------------------------------------")

  (Connect.showAttributes CastaData)

  (setq runMakro 0)
  (setq vWinkel_Flansch (Connect.get CastaData  v-atrgewnkl_flansch))
  (setq hWinkel_Flansch (Connect.get CastaData  h-atrgewnkl_flansch))
  (if (= vWinkel_Flansch 90.0) (if (= hWinkel_Flansch 90.0) (setq runMakro 1)))
  
  (if (= runMakro 1) (progn
  
	;     (trimmeAtr)
		 (calc_Schr_Abstand)	; muss direkt nach dem Trgertrimmen folgen, weil die Funktion 
					; delta_l abfragt, dass darin berechnet wird. Darf also nicht in 
					; der Zwischenzeit verndert worden sein.

		(makeConnection)		; Objekte erzeugen und mit Defaultwerten belegen
					; belegt globale Variable 
					; -  AbtlFahnenBl   AbtlFahnenLchb

	   (calcPositionFahne)  ; Trgerverschiebungen Tr_ID delta_V, delta_LR und HTrg delta_V einbauen

		 (init_FahnenBl_Versatz)		; Fahnenblech neben das Augenblech schieben

		 (calcSchrLaengeUndVersatz)	; Schraube - Lnge und Lngsversatz einsetzen
	 ;    (versetze_CpnLchb)		; Augenblech-Lochbild dem Fahnenblechlochbild angleichen

		(AT_TrgEnde_Anpassen)

		(Lochb_EndAnpassung)
		; nur zum Testen ...
		; (Lochbild.set  lchbAtrgSteg   (w0 	    30))
		; (Lochbild.set lchbAtrgSteg (e 		"0 10 50 0 0 0"))

		(print "Ende Makro .....................")

	;	(Lochbild.set lchbAtrgSteg (e "0 25 75 0 0 0")
	;								(w "0 45 0 0")
	;	)
	;	(Lochbild.set lchbAtrgSteg 	(dxSKopf -50))

		(setq dsSKopf_vorh (Lochbild.get lchbAtrgSteg dxSKopf))
		(setq AT_delta_SX (Anbauteil.get AbtlCouponLchb delta_SX))
		(setq HT_delta_SX (Anbauteil.get AbtlFahnenLchb delta_SX))
		;;; (AlertBox AT_delta_SX) (AlertBox HT_delta_SX) (AlertBox dsSKopf_vorh)
	))
)


(defun Lochb_EndAnpassung ()
  (Anbauteil.set AbtlFahnenLchb  (Master 1))
  (Anbauteil.set AbtlCouponLchb  (Master 0))
  
  (setq		HT_deltaV  (Traeger.get HTrg  delta_V)
  		AT_deltaLR (Traeger.get Tr_ID delta_LR)
  )
  
;  (setq dv_Diff 0.0)
  
  (if (= (Connect.get CastaData satr-vhtr) 1) (progn
    (setq dv_Diff (- AT_deltaLR HT_deltaV))
    (Anbauteil.set AbtlCouponLchb  (delta_V (+ Lchb_Delta_V dv_Diff)))
    (Anbauteil.set AbtlFahnenLchb (delta_V   dv_Diff))
  ))
  (if (= (Connect.get CastaData satr-vhtr) -1) (progn
;    (print "Lochb_EndAnpassung --> hier rechnen")
    (setq dv_Diff (- AT_deltaLR HT_deltaV))
    (print dv_Diff)
    (Anbauteil.set AbtlCouponLchb  (delta_V (+ dv_Diff Lchb_Delta_V)))
    (setq dv_Diff_Fbl (+ AT_deltaLR HT_deltaV))
    (print dv_Diff_Fbl)
    (Anbauteil.set AbtlFahnenLchb (delta_V  (- dv_Diff_Fbl)))
  ))
  
   (setq delta_V_FahLochb 0.0)
  
  ; (seitliche) Horizontalverschiebung des AT bercksichtigen
   (print "------------------------------------")
   (print "Fahnen-Lochbild - Bercksichtigung seitliche Verschiebung AT")
   (setq AbtlAugenLchb (Traeger.get HTrg ABTeil lchbAtrgSteg))
   (setq delta_LR_AT (Traeger.get Tr_ID delta_LR))
   
    (setq delta_V_FahLochb (-  delta_V_FahLochb delta_LR_AT))
   
;   (Anbauteil.set AbtlAugenLchb  (delta_V  (- delta_LR_AT)))

  
  ; Vertikalverschiebung des HT bercksichtigen
   (print "------------------------------------")
   (print "Fahnen-Lochbild - Bercksichtigung Vertikalverschiebung HT")
    (setq delta_LR_HT (Traeger.get HTrg delta_LR))
    (setq abtlFahnBl_HT (Traeger.get HTrg ABTeil bFahnenbl))
    (setq FahnenWnkl    (Anbauteil.get abtlFahnBl_HT Winkel))

	(print 	FahnenWnkl)
	(setq wAlfa (- 180.0 FahnenWnkl))
	(setq sinWnk (sin (/ (* PI wAlfa) 180.0)))
	(setq cosWnk (cos (/ (* PI wAlfa) 180.0)))
	
	(setq dv_Anteil_HT  (* cosWnk  delta_LR_HT))
	(setq dlr_Anteil_HT (* sinWnk  delta_LR_HT))

	(print dv_Anteil_HT)
	(print dlr_Anteil_HT)

        (setq dvVorh (Anbauteil.get AbtlFahnenLchb delta_V))
	(print dvVorh)
	(setq dv_Lochb_Neu (- dvVorh dlr_Anteil_HT))

        (setq delta_V_FahLochb (-  delta_V_FahLochb dlr_Anteil_HT))

        (Anbauteil.set AbtlFahnenLchb (delta_V  delta_V_FahLochb))


  ; Horizonalverschiebung des HT bercksichtigen
   (print "------------------------------------")
   (print "Fahnen-Lochbild - Bercksichtigung Vertikalverschiebung HT")
   (setq	h_HT 	(Traeger.get HTrg h)
			dv_HT	(Traeger.get HTrg delta_V)
   )
   (setq delta_V_HT dv_HT)
;   (if (/= delta_LR_HT 0.0) (progn
		(setq Abtl_ZugstabLchb (Traeger.get Tr_ID ABTeil lchbAtrgSteg))
		(setq dlr_Vorh (Anbauteil.get Abtl_ZugstabLchb delta_LR))
	 
		(setq dlr_Vorh (* 0.5 h_HT))
		(setq dlr_Neu 0.0)
		(if (= (Connect.get CastaData amHtUnterFlansch)  1) (progn
				(if (= (Connect.get CastaData LinkesEnde)  1) (setq dlr_Neu (- (+ dlr_Vorh delta_V_HT))))
				(if (= (Connect.get CastaData RechtesEnde) 1) (setq dlr_Neu    (+ dlr_Vorh delta_V_HT)))
		))
		(if (= (Connect.get CastaData amHtOberFlansch)  1) (progn
				(if (= (Connect.get CastaData LinkesEnde)  1) (setq dlr_Neu (- (-    dlr_Vorh  delta_V_HT))))
				(if (= (Connect.get CastaData RechtesEnde) 1) (setq dlr_Neu    (-    dlr_Vorh  delta_V_HT)))
		))

		(Anbauteil.set Abtl_ZugstabLchb (delta_LR dlr_Neu))
;   ))



)

   
(defun AT_TrgEnde_Anpassen ()
   
   (setq trimLng 0.0)
   (print trimLng)
   (setq hCoupon	(Traeger.get CouponTrg h)
   	 h_HT   	(Traeger.get HTrg      h)
   	 s_HT   	(Traeger.get HTrg      s)
   	 r_HT		(Traeger.get HTrg      r)
   	 Spalte 	(runde (+ (* 0.5 s_HT) r_HT) auf 5)
   	 trimLng	(+ Spalte  hCoupon 5.0)
   )
   
   (setq trimLng (+ (* 0.5 h_HT) hCoupon 5.0))	;; Spalt ist au 5mm festgelegt
   
   (setq dv_HT (Traeger.get HTrg delta_V))

   (if (= (Connect.get CastaData LinkesEnde)  1) (progn
        (setq TrgEnde (Traeger.get Tr_ID links))
		(if (= (Connect.get CastaData amHtUnterFlansch)    1) (TrEnde.set TrgEnde (delta_L dv_HT)))
        (if (= (Connect.get CastaData amHtOberFlansch)   1) (TrEnde.set TrgEnde (delta_L (- dv_HT))))
   ))
   (if (= (Connect.get CastaData RechtesEnde) 1) (progn
        (setq TrgEnde (Traeger.get Tr_ID rechts))
		(if (= (Connect.get CastaData amHtOberFlansch)    1) (TrEnde.set TrgEnde (delta_L (- dv_HT))))
        (if (= (Connect.get CastaData amHtUnterFlansch)   1) (TrEnde.set TrgEnde (delta_L dv_HT)))
   ))

   
   (if (= (Connect.get CastaData LinkesEnde)  1) (progn
       (setq TrgEnde (Traeger.get Tr_ID links))
       (TrEnde.ptrim TrgEnde trimLng)
   ))
   (if (= (Connect.get CastaData RechtesEnde) 1) (progn
       (setq TrgEnde (Traeger.get Tr_ID rechts))
       (TrEnde.ptrim TrgEnde trimLng)
   ))

 
)

(defun makeConnection ()
  (setq bFahnenbl	(blech.create))
  (setq lchbAtrgSteg	(Lochbild.create))
  (setq augenBlech	(Blech.create))
  (setq CouponTrg	(Traeger.create))
  (Connect.storeAnschlObjs CastaData bFahnenbl lchbAtrgSteg CouponTrg)

  (setq XPos (Connect.get CastaData XPos_HT))
  (print XPos)
  
  (print "Fahnenblech erzeugt - Default Blechdaten eingesetzt")
  (Blech.set bFahnenbl (dp 10) (hp 200) (bp 100) (dOK 0))

  (print "Augenblech erzeugt - Default Blechdaten eingesetzt")
  (Blech.set augenBlech (dp 12) (hp 200) (bp 80) (dOK 0))

  (print "Lochbild erzeugt - Default Lochbilddaten eingesetzt")
  (Lochbild.set lchbAtrgSteg 
  		(S_Bez 		"M16")	(Guete 		"4.6")
  		(w 		"60 0")	(e 		"-30 10 50 0 0 0")
  		(LB_Art 	2)	(KlemmL 	25)
  )


  (calcFahnenblechDaten)

  ; Winkel der Fahne berechnen - diese richtet sich nach dem Winkel zwischen
  ; Druckrohr und HT-Steg.
   (setq RWinkel_AT_HT (Connect.get CastaData  r-atrgewnkl_flansch))
   (if (= (Connect.get CastaData satr-lhtr-ex) -1) (setq RWinkel_AT_HT (- 360.0 RWinkel_AT_HT)))
   (setq RWinkel (- RWinkel_AT_HT 90.0))
  ; Winkel des Anbauteils
   (setq abtl_fahne_winkel RWinkel)


  (if (= (Connect.get CastaData amHtOberflansch) 1) (progn
  		(print "Anschluss am Steg links")
  		(traeger.addabtl hTrg bFahnenbl XPos abtl_fahne_winkel _fahnenblech_of_)
  ))
  (if (= (Connect.get CastaData amHtUnterFlansch) 1) (progn
  		(print "Anschluss am Steg rechts")
			(traeger.addabtl hTrg bFahnenbl XPos abtl_fahne_winkel _fahnenblech_uf_)
  ))

  ; Lochbild HT
  (setq AbtlFahnenBl	(Traeger.get Htrg AbTeil bFahnenbl))
  
  ; Winkel wird durch das Fahnenblech bestimmt und angepasst
  (Traeger.addabtl Htrg lchbAtrgSteg XPos 0.0 _fahnblLochbild_ AbtlFahnenBl)

  (setq AbtlFahnenLchb	(Traeger.get Htrg AbTeil lchbAtrgSteg))

;  (createAugenBlech augenBlech)
  (createCouponTrg)

  (calcFahnenblechLochbild)

  
  (if (= (Connect.get CastaData linkesEnde) 1)   (setq WINDVERBAND_LB _windvblchb_flansch_links_))
  (if (= (Connect.get CastaData rechtesEnde) 1)  (setq WINDVERBAND_LB _windvblchb_flansch_rechts_))

  (Traeger.addabtl Tr_ID lchbAtrgSteg 0.0 0.0 WINDVERBAND_LB)
  (setq AbtlCouponLchb	(Traeger.get Tr_ID AbTeil lchbAtrgSteg))
  (Anbauteil.set AbtlCouponLchb (Winkel -90.0))
  
  (if (= (Connect.get CastaData linkesEnde) 1)  (Anbauteil.set AbtlCouponLchb (Winkel 90.0)))
  (if (= (Connect.get CastaData rechtesEnde) 1) (Anbauteil.set AbtlCouponLchb (Winkel -90.0)))
  
  (Blech.set bFahnenbl  (FormFkt "cb_Fahnenblech"))
  (Traeger.set CouponTrg (FormFkt "cb_CouponTrg"))


)

; ----------------------------------------------------------------------------------------
; Erzeugt und setzt die Anbauteile der Verbindung
; ----------------------------------------------------------------------------------------



; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Fahne am HT
; ----------------------------------------------------------------------------------------
(defun cb_Fahnenblech (zp)
	(print "*clear*")
	(print "in Callback-Funktion cb_bFahnenbl")
	(print zp)

;	(if _CopyAction_ (print "CopyAction - Kopieren wird ausgefhrt!"))

	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt		(Blech.get bFahnenbl dp))
	    (setq dxs_Alt	(Lochbild.get lchbAtrgSteg dxSKopf))
	    (print dxs_Alt)
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get bFahnenbl dp))
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       ; Anbauteil wird in der folgenden Routine gebraucht
	       ; (setq AbtlFahnenLchb	(Traeger.get Htrg AbTeil lchbAtrgSteg))
	       ; (calcSchrLaengeUndVersatz)
	       (versetze_FahnenBl)
	    ))
	))
)
; ====================================================================== 
(defun cb_CouponTrg (zp)
	(print "*clear*")
	(print "in Callback-Funktion cb_CouponTrg")
	(print zp)

;	(if _CopyAction_ (print "CopyAction - Kopieren wird ausgefhrt!"))

	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq s_Cpn_Alt	(Traeger.get CouponTrg s))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq s_Cpn_Neu	(Traeger.get CouponTrg s))
	    
	    (if (/= s_Cpn_Alt s_Cpn_Neu) (progn
	       ; Anbauteil wird in der folgenden Routine gebraucht
	       (setq AbtlFahnenLchb	(Traeger.get Htrg AbTeil lchbAtrgSteg))
	       (calcSchrLaengeUndVersatz)
	       (versetze_FahnenBl)
	    ))
	))
)



; ----------------------------------------------------------------------------
; Berechnet die Lochbild Daten (wird hier dem AT hinzugefgt)
; ----------------------------------------------------------------------------
; ------------------------------------------------------------------------
; Passt die Lochbild-Anbauteile an.
; ------------------------------------------------------------------------
(defun calcRotationFahne ()
	(AlertBox "calcRotationFahne wird derzeit nicht verwendet")
;	(print "*clear*")
;	(Connect.showAttributes CastaData)
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE DIE ROTATION DES FAHNENBLECHES")

;	Lsung DM
;	funktionierte nicht bei HT auf dem Kopf liegend (Rotation 180.0)	
;	   (setq rwinkel_at	(Traeger.get Tr_ID r_winkel))
;	ersetzt durch Lsung AF 062009
	(setq rwk_vfl		(Connect.get CastaData v-atrgewnkl_flansch))
	(setq rwk_rst		(Connect.get CastaData r-atrgewnkl_steg))
	(setq rwk_kpf		(Connect.get CastaData r-atrgewnkl_kopf))

	(setq rwinkel_at        (+ (- 180.0 rwk_vfl) (- rwk_rst 90.0)))
	(if (= (Connect.get CastaData vatr-vhtr) -1)		(setq rwinkel_at        (- (- 180.0 rwk_vfl) (- rwk_rst 90.0))))
;	Ende neuer Lsung

	(print rwinkel_at)
	
	(setq vwinkel_ht	(Connect.get CastaData hpttrg_vwinkel))
	(print vwinkel_ht)
	
	; Winkel des Anbauteils
	(setq abtl_fahne_winkel 90.0)
	
	; Anteil HT Schrgstellung
	(setq abtl_fahne_winkel (- abtl_fahne_winkel vWinkel_ht))
	
	(print rwinkel_at)
	(print abtl_fahne_winkel)
	
	; Anteil Rotation des AT
(if (= 1 2)	(progn
	(if (= (Connect.get CastaData satr-lhtr)  1)	(setq abtl_fahne_winkel (- abtl_fahne_winkel rwinkel_at)))
	(if (= (Connect.get CastaData satr-lhtr) -1)	(setq abtl_fahne_winkel (- abtl_fahne_winkel rwinkel_at)))
	(if (= (Connect.get CastaData satr-lhtr)  0)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq abtl_fahne_winkel (- abtl_fahne_winkel rwinkel_at)))
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq abtl_fahne_winkel (- abtl_fahne_winkel rwinkel_at)))
		)
	)
))

	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq abtl_fahne_winkel (- abtl_fahne_winkel rwinkel_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq abtl_fahne_winkel (+ abtl_fahne_winkel rwinkel_at))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq abtl_fahne_winkel (+ abtl_fahne_winkel rwinkel_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq abtl_fahne_winkel (- abtl_fahne_winkel rwinkel_at))
			)
		)
	)
	
	; Korrektur passend zur einleitende Passage
	; 062009 AF
	(if (= (Connect.get CastaData linkesEnde) 1) (setq abtl_fahne_winkel (- abtl_fahne_winkel 180.0)))
	
	(print abtl_fahne_winkel)
	
	
	(print "<-------------------------------------------------------------------------------")
)







(defun calcPositionFahne ()
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE DIE POSITION DES FAHNENBLECHES")
	
  (setq abtlFahnBl_HT (Traeger.get HTrg ABTeil bFahnenbl))
  (setq abtlLochb_HT  (Traeger.get HTrg ABTeil lchbAtrgSteg))
  (setq abtl_fahne_winkel_Ende (Anbauteil.get abtlFahnBl_HT Winkel))
  (setq abtl_fahne_winkel_Ende (+ abtl_fahne_winkel_Ende 90.0))

	(setq abtl_Delta_LR 0.0)
	(setq abtl_Delta_V  0.0)


	(setq	delta_V_AT	(Traeger.get Tr_ID delta_v)
			delta_LR_AT	(Traeger.get Tr_ID delta_LR)
	)
	
;	(if (= (Connect.get CastaData satr-lhtr-ex) -1) (setq delta_V_AT (- delta_V_AT)))
	(if (/= (Connect.get CastaData satr-lhtr-ex)  0) (progn
	    (if (= (Connect.get CastaData amHtOberflansch) 1)  
			(if (= (Connect.get CastaData rechtesEnde) 1) (setq delta_V_AT (- delta_V_AT)))
	    )
	    (if (= (Connect.get CastaData amHtUnterflansch) 1)  
			(if (= (Connect.get CastaData linkesEnde) 1) (setq delta_V_AT (- delta_V_AT)))
	    )
	))

	(if (= (Connect.get CastaData satr-lhtr-ex)  0) (progn
	   (if (= (Connect.get CastaData vatr-lhtr)  1)
	   	(if (< abtl_fahne_winkel_Ende 0.0) (setq delta_V_AT (- delta_V_AT)))
	   )
	   (if (= (Connect.get CastaData vatr-lhtr) -1)
	   	(if (> abtl_fahne_winkel_Ende 0.0) (setq delta_V_AT (- delta_V_AT)))
	   )
	))
	
	(setq abtl_Delta_LR (+ abtl_Delta_LR delta_V_AT))

	
	; seitliche Verschiebung des AT
	(setq delta_LR_AT (- delta_LR_AT))
	(setq abtl_Delta_V (+ abtl_Delta_V delta_LR_AT))

	; seitliche Verschiebung des HT
	(setq delta_LR_HT (Traeger.get HTrg delta_LR))
	(print "------------------------------------")
	(print 	abtl_fahne_winkel_Ende)
	(setq wAlfa (- 180.0 abtl_fahne_winkel_Ende))
	(setq sinWnk (sin (/ (* PI wAlfa) 180.0)))
	(setq cosWnk (cos (/ (* PI wAlfa) 180.0)))
	
	(setq dv_Anteil_HT (* cosWnk delta_LR_HT))
	(print dv_Anteil_HT)

	(setq dlr_Anteil_HT (* sinWnk delta_LR_HT))

	(setq abtl_Delta_LR (+ abtl_Delta_LR  dv_Anteil_HT))	; aufaddieren
	(setq abtl_Delta_V  (- abtl_Delta_V   dlr_Anteil_HT))	; aufaddieren
	; ------------------------------------------------

	; Werte jetzt hier einsetzen
;	(Blech.set bFahnenbl (delta_LR abtl_Delta_LR))
	(Anbauteil.set abtlFahnBl_HT (delta_V abtl_Delta_V))

;	(Anbauteil.set abtlLochb_HT (delta_SX abtl_Delta_LR))
	


   ; 000000000000000000000000000000000000000000 kann weg 0000000000000000000000000000000000
   (if (= 2 5) (progn	
	(setq delta_V_HT (Traeger.get HTrg delta_V))
	(setq delta_v_ht	(Traeger.get Htrg delta_v))
	
	(setq vwinkel_uz (Connect.get CastaData hpttrg_vwinkel))
	
	(setq rwinkel_at	(Traeger.get Tr_ID r_winkel)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	
	
	
	; Differnzwinkel zwischen HT-Neigung und AT-Rotation berechnen
	; ---------------------------------------------
	(print vwinkel_uz)
	(print rwinkel_at)
	(setq diffWinkel 0.0)
	(if (= (Connect.get CastaData amHtOberFlansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (+ vwinkel_ht rwinkel_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (- vwinkel_ht rwinkel_at ))
			)
		)
	)
	(if (= (Connect.get CastaData amHtUnterFlansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (- vwinkel_ht rwinkel_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (+ vwinkel_ht rwinkel_at ))
			)
		)
	)
	(print diffWinkel)
	
	(setq sinW (sin (/ (* PI diffWinkel) 180.0)))
	(setq cosW (cos (/ (* PI diffWinkel) 180.0)))
	(setq tanW (tan (/ (* PI diffWinkel) 180.0)))
	
	
	(setq verschiebung_delta_v 0.0)
	(setq verschiebung_delta_lr 0.0)
	
	; HT-Verschiebungen
	; ++++++++++++++++++++++++++++++++++++++++++++++
	
	; Anteil delta_v Verschiebung HT
	; ----------------------------------------------
	(if (= 1 2)	(progn
	; ----------------------------------------------
		(setq verschiebung_delta_v (+ verschiebung_delta_v (* delta_v_ht cosW)))
		
		(print verschiebung_delta_v)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	; AT-Verschiebungen
	; ++++++++++++++++++++++++++++++++++++++++++++++
	
	; Anteil delta_lr Verschiebung AT
	; ----------------------------------------------
	(if (= 1 2)	(progn
	; ----------------------------------------------
		(setq verschiebung_delta_v (+ verschiebung_delta_v (* delta_v_ht cosW)))
		
		(print verschiebung_delta_v)
	; ----------------------------------------------
	))
	
	
	
	; ----------------------------------------------
	; Kontrollen
	; ----------------------------------------------
	(print verschiebung_delta_v)
	
	(AlertBox verschiebung_delta_v)
	; Anbauteil Fahne Werte setzen
	(Anbauteil.set ABTL (delta_v 	verschiebung_delta_v))	
	(print "<-------------------------------------------------------------------------------")
   ))
   
)





; -------------------------- in zentrales Mod aufnehmen
;		wird derzeit verwendet in stz_Windverb_TGTechnik
;		und hier ...
(defun trimmeAtr ()
  (setq lng_Trim 0.0)

  (if (= (Connect.get CastaData vAtr-vHtr) 0) (progn
;     (print "Behandlung ATR-Trgerende wenn Vertikalverschiebung ATr 90 zur V HTr")
     (setq WnklAlfa (Connect.get CastaData V-AtrGewnkl_Steg))
     (setq	sinAWnkl (sin (/ (* PI WnklAlfa) 180.0))
  		cosAWnkl (cos (/ (* PI WnklAlfa) 180.0))
  		tanAWnkl (tan (/ (* PI WnklAlfa) 180.0))
     )
     (setq dlr_HTr (Traeger.get HTrg  delta_LR)
     	   dv_ATr  (Traeger.get Tr_ID delta_V)
     )
     (setq tmpTrim 0.0)
     (if (/= sinAWnkl 0.0) (setq tmpTrim	 (/ dlr_HTr sinAWnkl)))
     (if (= (Connect.get CastaData amhtsteglinks)  1)  (setq lng_Trim (- lng_Trim tmpTrim)))
     (if (= (Connect.get CastaData amhtstegrechts) 1)  (setq lng_Trim (+ lng_Trim tmpTrim)))

     (setq tmpTrim 0.0)
     (if (/= tanAWnkl 0.0) (setq tmpTrim	 (/ dv_ATr  tanAWnkl)))

     (if (= (Connect.get CastaData LinkesEnde)  1) (setq lng_Trim (- lng_Trim tmpTrim)))
     (if (= (Connect.get CastaData RechtesEnde) 1) (setq lng_Trim (+ lng_Trim tmpTrim)))

  ))
  (if (= (Connect.get CastaData vAtr-lHtr) 0) (progn
;    (print "Behandlung ATR-Trgerende wenn Vertikalverschiebung ATr lngs zur Lngsachse HTr")
     (setq WnklAlfa (Connect.get CastaData H-AtrGewnkl_Steg))
     (setq	sinAWnkl (sin (/ (* PI WnklAlfa) 180.0))
  		cosAWnkl (cos (/ (* PI WnklAlfa) 180.0))
  		tanAWnkl (tan (/ (* PI WnklAlfa) 180.0))
     )
     (setq dlr_HTr (Traeger.get HTrg  delta_LR)
     	   dlr_ATr (Traeger.get Tr_ID delta_LR)
     )


     (setq tmpTrim 0.0)
     (if (/= sinAWnkl 0.0) (setq tmpTrim	 (/ dlr_HTr sinAWnkl)))
     (if (= (Connect.get CastaData amhtsteglinks)  1)  (setq lng_Trim (- lng_Trim tmpTrim)))
     (if (= (Connect.get CastaData amhtstegrechts) 1)  (setq lng_Trim (+ lng_Trim tmpTrim)))

     (setq tmpTrim 0.0)
     (if (/= tanAWnkl 0.0) (setq tmpTrim	 (/ dlr_ATr  tanAWnkl)))
    
     (if (= (Connect.get CastaData LinkesEnde)  1) (setq lng_Trim (- lng_Trim tmpTrim)))
     (if (= (Connect.get CastaData RechtesEnde) 1) (setq lng_Trim (+ lng_Trim tmpTrim)))
    
   ))

  (if (= (Connect.get CastaData linkesEnde) 1) (progn
      (setq TrgEnde (Traeger.get Tr_ID links))
      (TrEnde.set TrgEnde (Delta_L lng_Trim))
  ))
  (if (= (Connect.get CastaData rechtesEnde) 1) (progn
      (setq TrgEnde (Traeger.get Tr_ID rechts))
      (TrEnde.set TrgEnde (Delta_L lng_Trim))
  ))
  
)

(defun createCouponTrg ()
  (if (= (Connect.get CastaData linkesEnde) 1) (progn
     (traeger.addabtl tr_id CouponTrg 0.0 0.0 _kopfcouponprofil_links_)
  ))
  (if (= (Connect.get CastaData rechtesEnde) 1) (progn
     (traeger.addabtl tr_id CouponTrg 0.0 0.0 _kopfcouponprofil_rechts_)
  ))
    (setq b_AT 		(Traeger.get Tr_ID b)
    	  LngCoupon 	(runde (+ b_AT 4) auf 5)
    )
    
    (Traeger.set CouponTrg (Profil "IPE200") (syslng LngCoupon) (dOK 0.0) (h 120))
)

(defun createAugenBlech (Blech_ID)
	
  (setq h_at (Traeger.get Tr_ID h))
  (setq e_min_rund 40)
	

  (if (= (Connect.get CastaData linkesEnde) 1)
  	(traeger.addabtl tr_id Blech_ID 0.0 0.0 _augenblech_links_)
  )
  (if (= (Connect.get CastaData rechtesEnde) 1)
  	(traeger.addabtl tr_id Blech_ID 0.0 0.0 _augenblech_rechts_)
  )
  
  ; Schlitzlaenge der Augenlasche
  (setq lSchlitz (Blech.get Blech_ID lSchlitz)) 
  (print lSchlitz)
  
  ; Breite der Augenlasche
  (setq bp_al (+ h_at 20.0))
  (print bp_al)
  (setq min_bp_al (* 2.0 e_min_rund))	; erstmal nicht bercksichtigen
  (setq min_bp_al bp_al)
  
  (if (>= bp_al min_bp_al)
  	(setq bp_al bp_al)
  	(setq bp_al min_bp_al)
  )
  
  ; Lnge der Augenlasche
  (setq KONTAKTLAENGE 100.0)
  (setq hp_al (+ lSchlitz (* KONTAKTLAENGE 1.25)))
  ;; (setq hp_al (+ lSchlitz anteil_rand_abst MIN_ABST_AUGENLCHB_BLECHENDE h_at))
  
;  (calcAndSetAugenBlechDicke augenBlech)	; -> dp_al
  
  (Blech.set Blech_ID	(bp bp_al)
			(hp hp_al)
  )
  
  
)

(defun calc_Schr_Abstand ()

  (print "calc_Schr_Abstand ------------ ")
  (setq Lchb_Delta_LR 0)
  (if (= (Connect.get CastaData linkesEnde) 1)  (setq TrgEnde (Traeger.get Tr_ID links)))
  (if (= (Connect.get CastaData rechtesEnde) 1) (setq TrgEnde (Traeger.get Tr_ID rechts)))
  (setq Lchb_Delta_LR (TrEnde.get TrgEnde Delta_L))
  (print Lchb_Delta_LR)

  (setq h_HT (Traeger.get HTrg h))
  (setq Lchb_Delta_LR (+ Lchb_Delta_LR (* 0.5 h_HT)))

  (print "nach Flanschbercksichtigung")
  (print Lchb_Delta_LR)
  
  ; vertikale Verschiebung berechnen
  (setq		HT_deltaLR (Traeger.get HTrg  delta_LR)
			AT_deltaLR  (Traeger.get Tr_ID delta_LR)
  )
  (setq Lchb_Delta_V (- HT_deltaLR AT_deltaLR))
  (print Lchb_Delta_V)
  
  

)
(defun init_FahnenBl_Versatz ()
	(setq	dp_FahnBl	(Blech.get bFahnenbl dp)
   		s_Coupon	(Traeger.get CouponTrg s)
   		AT_dv		(Traeger.get Tr_ID delta_V)
   		FahnBl_dLR	(* 0.5 (+ dp_FahnBl s_Coupon))
	)
   
	(setq RWinkel_AT (Connect.get CastaData r-atrgewnkl_flansch))
	
	(setq sin_RW (sin (/ (* PI RWinkel_AT) 180.0)))
	(setq cos_RW (cos (/ (* PI RWinkel_AT) 180.0)))
;	(if (= (Connect.get CastaData at-von-links) 1) (setq sin_RW (- sin_RW)))
;	(if (= (Connect.get CastaData vAtr-vHtr) -1)   (setq sin_RW (- sin_RW)))

;	(if (= (Connect.get CastaData at-von-links) 1)   (progn 
;		(setq AT_dv (- AT_dv))
;	))
	
	(setq dlr_Blech_erf  (* 0.5 (+ dp_FahnBl s_Coupon)))

	; Vertikalverschiebungen der Profile zueinander
	(setq dv_Profile (- AT_dv))
	
	; Vertikalverschiebung des Trgerprofils noch bercksichtigen
	(setq dlr_Blech_erf (- dlr_Blech_erf dv_Profile))

	(if (>= RWinkel_AT 175.0) (if (<= RWinkel_AT 185.0) (progn
		(setq  dlr_Blech_erf (- dlr_Blech_erf))
	)))
	
	(Blech.set bFahnenbl (delta_LR dlr_Blech_erf))
   
)
; ---------------------------------------------------------------------------
(defun versetze_FahnenBl ()
	(print "versetze_FahnenBl")
	(setq	dp_FahnBl	0.0)
	

	(if (objExist bFahnenbl) (progn
		(init_FahnenBl_Versatz)

		(setq	dp_FahnBl	(Blech.get bFahnenbl dp))
		(setq	s_Coupon	(Traeger.get CouponTrg s))

		(setq dlr_Blech_ges (Blech.get bFahnenbl delta_LR))
	))

	
	(if (objExist  lchbAtrgSteg) (progn
		(setq abtlLochb_HT  (Traeger.get HTrg ABTeil lchbAtrgSteg))
		(Anbauteil.set abtlLochb_HT (delta_SX dlr_Blech_ges))


		(setq 	currKlemmL 		(Lochbild.get  lchbAtrgSteg KlemmL)
				currDxsKopf 	(Lochbild.get  lchbAtrgSteg dxSKopf)
		)
		(setq newDxsKopf (+ (* 1.0 s_Coupon) (* 0.5  dp_FahnBl)))
		(setq newKlemmL (+ (* 1.0 s_Coupon) (* 1.0  dp_FahnBl)))
		
		(Lochbild.set lchbAtrgSteg 	(dxSKopf newDxsKopf)
									(KlemmL  newKlemmL)
		)
		
	))

)

(defun	calcSchrLaengeUndVersatz ()
	(print "calcSchrLaengeUndVersatz")
   (setq	dp_FahnBl	0.0)
   (if (objExist bFahnenbl) (setq	dp_FahnBl	(Blech.get bFahnenbl dp)))

   (setq 
   		s_Coupon	(Traeger.get CouponTrg s)
   		AT_dv		(Traeger.get Tr_ID delta_V)
   		dxs_Versatz	(* 0.5 s_Coupon)
   )
   
   (setq dxSKopf 0.0)
   
   (if (= (Connect.get CastaData vatr-lhtr) 1) (progn
   	(setq dxs_Versatz (- dxs_Versatz AT_dv))
   	(setq delta_SX   (+ AT_dv (* 0.5 s_Coupon)))
   	(setq dxSKopf     s_Coupon)
   ))
   (if (= (Connect.get CastaData vatr-lhtr) -1) (progn
   	(setq dxs_Versatz (+ dxs_Versatz AT_dv))
   	(setq delta_SX  (- (* 0.5 s_Coupon) AT_dv))
   	(setq dxSKopf     s_Coupon)
   ))

   ; gilt vorerst immer - also in jedem Fall.
   (setq dxSKopf     (* 0.5 s_Coupon))

   (Lochbild.set lchbAtrgSteg 	(dxSKopf dxSKopf)
   				(KlemmL  (+ dp_FahnBl s_Coupon))
   )
   
    (setq FWinkel (Anbauteil.get AbtlFahnenLchb Winkel))
   
	(setq dv_AT (Traeger.get Tr_ID delta_V))
    (if (> FWinkel 85.0) (if (< FWinkel 95.0) (setq dv_AT (- dv_AT))))
	(Anbauteil.set AbtlFahnenLchb (delta_SX dv_AT))

   
   (print "in Fkt <calcSchrLaengeUndVersatz>")
   (print  dxSKopf)
   (print dxs_Versatz)
   (print dp_FahnBl)
   (print s_Coupon)
)
; ---------------------------------------------------------------------------
(defun versetze_CpnLchb ()
 (if (= 1 1) (progn
   (setq AbtlCouponLchb	(Traeger.get Tr_ID AbTeil lchbAtrgSteg))
  
   (if (= (Connect.get CastaData satr-vhtr) 1) (progn
    (if (= (Connect.get CastaData linkesEnde) 1) (progn
;        (Anbauteil.set AbtlCouponLchb (Winkel -90.0))
        (Anbauteil.set AbtlCouponLchb  (delta_LR Lchb_Delta_LR))
    ))
 
    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
    ; - am rechten Ende - je nach Lage, diese Kombination
;        (Anbauteil.set AbtlCouponLchb  (seitricht -1))
;        (Anbauteil.set AbtlCouponLchb  (Winkel  90.0))
        (Anbauteil.set AbtlCouponLchb  (delta_LR (- Lchb_Delta_LR)))
    ;
    ))
   ))
   (if (= (Connect.get CastaData satr-vhtr) -1) (progn
    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
;        (Anbauteil.set AbtlCouponLchb (Winkel -90.0))
        (Anbauteil.set AbtlCouponLchb  (delta_LR   Lchb_Delta_LR))
    ))
 
    (if (= (Connect.get CastaData linkesEnde) 1) (progn
    ; - am rechten Ende - je nach Lage, diese Kombination
;        (Anbauteil.set AbtlCouponLchb  (seitricht -1))
;       (Anbauteil.set AbtlCouponLchb  (Winkel  90.0))
        (Anbauteil.set AbtlCouponLchb  (delta_LR (- Lchb_Delta_LR)))
    ;
    ))
   ))
 )); Kann entfernt werden, wenn geprft
 
  (setq Augbl_Lochb_Winkel (Anbauteil.get AbtlCouponLchb  Winkel))
  (if (= (Connect.get CastaData linkesEnde) 1) (Anbauteil.set AbtlCouponLchb  (Winkel  90.0)))

 
)
(defun calcFahnenblechDaten ()
    (setq	h_HTrg (Traeger.get HTrg h)
    		b_HTrg (Traeger.get HTrg b)
    		s_HTrg (Traeger.get HTrg s)
    		r_HTrg (Traeger.get HTrg r)
    		t_HTrg (Traeger.get HTrg t)
    )

    (setq hp_fbl (- h_HTrg (* 2.0 (+ t_HTrg r_HTrg))))
    (setq bp_fbl (- (* 0.5 b_HTrg) (* 0.5 s_HTrg)))
    (setq bp_fbl (runde bp_fbl ab 5))
    (setq hp_fbl (runde hp_fbl ab 5))
    
    (if (< bp_fbl 70) (setq bp_fbl 70))		; Mindestbreite

    (Blech.set bFahnenbl 
	(bp bp_fbl) (hp hp_fbl) 
	; (x2 20) (y2 20)			; Ausrundung unten abziehbar
	; (x3 20) (y3 20)			; Ausrundung oben abziehbar
    )

)
(defun calcFahnenblechLochbild ()
    (setq	
    		b_HTrg (Traeger.get HTrg b)
    		s_HTrg (Traeger.get HTrg s)
    )
    ; fuer I-Traeger vorerst geeignet
    (setq w0_soll (* 0.25 (- b_HTrg s_HTrg)))
    (setq w0_soll (runde w0_soll auf 5))
    
    (setq sd (Lochbild.get lchbAtrgSteg sdurchm))

    (if (<  w0_soll  (* 2 sd)) (progn
    	(setq  w0_soll (* 2 sd))
	(setq w0_soll (runde w0_soll auf 5))
    ))
    
    (setq	; bp_Aug (Blech.get augenBlech bp)
    		bp_Aug  (Traeger.get CouponTrg Laenge)
    		bpNetto (- bp_Aug (* 3.0 sd))
    		bpNetto  (runde bpNetto ab 5)
    )

    (setq e1 bpNetto
    	  e0 (- (* 0.5 bpNetto))
    )

    (Lochbild.set lchbAtrgSteg 
   		(e 		"-30 10 0 0 0 0")
   		(w0 w0_soll)
    		(e0 e0)
    		(e1 e1)
    )

)