; $	HT	QT(IU)		AF(S)		P(EZ)
; $ 	AT	QT(RS)		AF(K)		P(E)
; $	AE	V(90)		H(90)		R(-)

; ------------------------------------------------
; externe Module einbinden
; ------------------------------------------------
(defun load-modules ()
   (load "mod-endinit-uz-uzsteg")
   (load "mod-lochbild")
)
; ------------------------------------------------


(defun init-connection ()

   (print "*clear*")
;   (print "Druckrohr mit Fahne am Steg anschlieen")
  (if (= (Connect.get CastaData amHtStegLinks) 1) (progn
       (if (= (Connect.get CastaData linkesEnde)  1) (print "am HT Steg links - linkes  Ende"))
       (if (= (Connect.get CastaData rechtesEnde) 1) (print "am HT Steg links - rechtes Ende"))
  ))
  (if (= (Connect.get CastaData amHtStegRechts) 1) (progn
       (if (= (Connect.get CastaData linkesEnde)  1) (print "am HT Steg rechts - linkes  Ende"))
       (if (= (Connect.get CastaData rechtesEnde) 1) (print "am HT Steg rechts - rechtes Ende"))
  ))
  (print "------------------------------------------------")

;   (Connect.showAttributes CastaData)

   (calc_Schr_Abstand)	; muss direkt nach dem Trgertrimmen folgen, weil die Funktion 
   			; delta_l abfragt, dass darin berechnet wird. Darf also nicht in 
   			; der Zwischenzeit verndert worden sein.
   (makeConnection)	; Objekte erzeugen und mit Defaultwerten belegen
   			; belegt globale Variable 
   			; -  AbtlFahnenBl   AbtlFahnenLchb

   (calcPositionFahne)  ; Trgerverschiebungen Tr_ID delta_V, delta_LR und HTrg delta_V einbauen

   (versetze_FahnenBl)	; Fahnenblech neben das Augenblech schieben
   (versetze_AugLchb)	; Augenblech-Lochbild dem Fahnenblechlochbild angleichen


   (AT_TrgEnde_Anpassen)


   (Lochb_EndAnpassung)
  ; nur zum Testen ...
  ; (Lochbild.set  lchbAtrgSteg   (w0 	    30))

  (setq abtlFahnBl_HT (Traeger.get HTrg ABTeil bFahnenbl))
  (setq abtl_fahne_winkel_Ende (Anbauteil.get abtlFahnBl_HT Winkel))

)


(defun Lochb_EndAnpassung ()
  (Anbauteil.set AbtlFahnenLchb (Master 1))
  (Anbauteil.set AbtlAugenLchb  (Master 0))
  
  (setq		HT_deltaV  (Traeger.get HTrg  delta_V)
  		AT_deltaLR (Traeger.get Tr_ID delta_LR)
  )
  
;  (setq dv_Diff 0.0)
  
  (if (= (Connect.get CastaData satr-vhtr) 1) (progn
    (setq dv_Diff (- AT_deltaLR HT_deltaV))
    (Anbauteil.set AbtlAugenLchb  (delta_V (+ Lchb_Delta_V dv_Diff)))
    (Anbauteil.set AbtlFahnenLchb (delta_V   dv_Diff))
  ))
  (if (= (Connect.get CastaData satr-vhtr) -1) (progn
;    (print "Lochb_EndAnpassung --> hier rechnen")
    (setq dv_Diff (- AT_deltaLR HT_deltaV))
    (print dv_Diff)
    (Anbauteil.set AbtlAugenLchb  (delta_V (+ dv_Diff Lchb_Delta_V)))
    (setq dv_Diff_Fbl (+ AT_deltaLR HT_deltaV))
    (print dv_Diff_Fbl)
    (Anbauteil.set AbtlFahnenLchb (delta_V  (- dv_Diff_Fbl)))
  ))
  
   (setq delta_V_FahLochb 0.0)
  
  ; (seitliche) Horizontalverschiebung des AT bercksichtigen
   (print "------------------------------------")
   (print "Fahnen-Lochbild - Bercksichtigung seitliche Verschiebung AT")
   (setq AbtlAugenLchb (Traeger.get HTrg ABTeil lchbAtrgSteg))
   (setq delta_LR_AT (Traeger.get Tr_ID delta_LR))
   
    (setq delta_V_FahLochb (-  delta_V_FahLochb delta_LR_AT))
   
;   (Anbauteil.set AbtlAugenLchb  (delta_V  (- delta_LR_AT)))

  
  ; Vertikalverschiebung des HT bercksichtigen
   (print "------------------------------------")
   (print "Fahnen-Lochbild - Bercksichtigung Vertikalverschiebung HT")
    (setq delta_V_HT (Traeger.get HTrg delta_V))
    (setq abtlFahnBl_HT (Traeger.get HTrg ABTeil bFahnenbl))
    (setq FahnenWnkl    (Anbauteil.get abtlFahnBl_HT Winkel))

	(print 	FahnenWnkl)
	(setq wAlfa (- 180.0 FahnenWnkl))
	(setq sinWnk (sin (/ (* PI wAlfa) 180.0)))
	(setq cosWnk (cos (/ (* PI wAlfa) 180.0)))
	
	(setq dv_Anteil_HT  (* cosWnk  delta_V_HT))
	(setq dlr_Anteil_HT (* sinWnk  delta_V_HT))

	(print dv_Anteil_HT)
	(print dlr_Anteil_HT)

        (setq dvVorh (Anbauteil.get AbtlFahnenLchb delta_V))
	(print dvVorh)
	(setq dv_Lochb_Neu (- dvVorh dlr_Anteil_HT))

        (setq delta_V_FahLochb (-  delta_V_FahLochb dlr_Anteil_HT))

        (Anbauteil.set AbtlFahnenLchb (delta_V  delta_V_FahLochb))
;        (Anbauteil.set AbtlFahnenLchb (delta_V  dv_Lochb_Neu))

  ; Horizonalverschiebung des HT bercksichtigen
   (print "------------------------------------")
   (print "Fahnen-Lochbild - Bercksichtigung Horizonalverschiebung HT")
   (setq delta_LR_HT (Traeger.get HTrg delta_LR))
;   (if (/= delta_LR_HT 0.0) (progn
	(setq Abtl_ZugstabLchb (Traeger.get Tr_ID ABTeil lchbAtrgSteg))
	(setq dlr_Vorh (Anbauteil.get Abtl_ZugstabLchb delta_LR))
 
	(setq s_HT (Traeger.get HTrg s))
	(setq dlr_Vorh (* 0.5 s_HT))
	(setq dlr_Neu 0.0)
	(if (= (Connect.get CastaData amHtStegLinks)  1) (progn
       		(if (= (Connect.get CastaData LinkesEnde)  1) (setq dlr_Neu    (+ (- dlr_Vorh) delta_LR_HT)))
       		(if (= (Connect.get CastaData RechtesEnde) 1) (setq dlr_Neu (- (+ (- dlr_Vorh) delta_LR_HT))))
	))
	(if (= (Connect.get CastaData amHtStegRechts)  1) (progn
       		(if (= (Connect.get CastaData LinkesEnde)  1) (setq dlr_Neu (- (+    dlr_Vorh  delta_LR_HT))))
       		(if (= (Connect.get CastaData RechtesEnde) 1) (setq dlr_Neu    (+    dlr_Vorh  delta_LR_HT)))
	))

	(Anbauteil.set Abtl_ZugstabLchb (delta_LR dlr_Neu))
;   ))

  
)

   
(defun AT_TrgEnde_Anpassen ()
   (setq hp (Blech.get Augenblech hp)
         ls (Blech.get Augenblech LSchlitz)
   )
   (setq dlr_HT (Traeger.get HTrg delta_LR))

   (if (= (Connect.get CastaData LinkesEnde)  1) (progn
        (setq TrgEnde (Traeger.get Tr_ID links))
	(if (= (Connect.get CastaData amHtStegLinks)    1) (TrEnde.set TrgEnde (delta_L (- dlr_HT))))
        (if (= (Connect.get CastaData amHtStegRechts)   1) (TrEnde.set TrgEnde (delta_L dlr_HT)))
   ))
   (if (= (Connect.get CastaData RechtesEnde) 1) (progn
        (setq TrgEnde (Traeger.get Tr_ID rechts))
	(if (= (Connect.get CastaData amHtStegLinks)    1) (TrEnde.set TrgEnde (delta_L (- dlr_HT))))
        (if (= (Connect.get CastaData amHtStegRechts)   1) (TrEnde.set TrgEnde (delta_L dlr_HT)))
   ))


   
   (setq trimLng (+ (- hp ls) 20.0))
   (print trimLng)
   
   (if (= (Connect.get CastaData LinkesEnde)  1) (progn
       (setq TrgEnde (Traeger.get Tr_ID links))
       (TrEnde.ptrim TrgEnde trimLng)
   ))
   (if (= (Connect.get CastaData RechtesEnde) 1) (progn
       (setq TrgEnde (Traeger.get Tr_ID rechts))
       (TrEnde.ptrim TrgEnde trimLng)
   ))

 
)

(defun makeConnection ()
  (setq bFahnenbl	(blech.create))
  (setq lchbAtrgSteg	(Lochbild.create))
  (setq augenBlech	(Blech.create))
  (Connect.storeAnschlObjs CastaData bFahnenbl lchbAtrgSteg augenBlech)

  (setq XPos (Connect.get CastaData XPos_HT))
  (print XPos)
  
  (print "Fahnenblech erzeugt - Default Blechdaten eingesetzt")
  (Blech.set bFahnenbl (dp 10) (hp 200) (bp 100) (dOK 0))

  (print "Augenblech erzeugt - Default Blechdaten eingesetzt")
  (Blech.set augenBlech (dp 12) (hp 200) (bp 80) (dOK 0))

  (print "Lochbild erzeugt - Default Lochbilddaten eingesetzt")
  (Lochbild.set lchbAtrgSteg 
  		(S_Bez 		"M16")	(Guete 		"4.6")
  		(w 		"60 0")	(e 		"-30 10 50 0 0 0")
  		(LB_Art 	2)	(KlemmL 	25)
  )


  (calcFahnenblechDaten)

  ; Winkel der Fahne berechnen - diese richtet sich nach dem Winkel zwischen
  ; Druckrohr und HT-Steg.
   (setq RWinkel_AT_HT (Connect.get CastaData r-atrgewnkl_steg))
   (if (= (Connect.get CastaData satr-lhtr-ex) -1) (setq RWinkel_AT_HT (- 360.0 RWinkel_AT_HT)))
   (setq RWinkel (- RWinkel_AT_HT 90.0))
  ; Winkel des Anbauteils
   (setq abtl_fahne_winkel RWinkel)


  (if (= (Connect.get CastaData amHtStegLinks) 1) (progn
  		(print "Anschluss am Steg links")
  		(traeger.addabtl hTrg bFahnenbl XPos abtl_fahne_winkel _fahnenblech_steg_li_)
  ))
  (if (= (Connect.get CastaData amHtStegRechts) 1) (progn
  		(print "Anschluss am Steg rechts")
			(traeger.addabtl hTrg bFahnenbl XPos abtl_fahne_winkel _fahnenblech_steg_re_)
  ))

  ; Lochbild HT
  (setq AbtlFahnenBl	(Traeger.get Htrg AbTeil bFahnenbl))
  (Traeger.addabtl Htrg lchbAtrgSteg XPos 180.0 _fahnblLochbild_ AbtlFahnenBl)



  (setq AbtlFahnenLchb	(Traeger.get Htrg AbTeil lchbAtrgSteg))

  (createAugenBlech augenBlech)

  (calcFahnenblechLochbild)

  
  (if (= (Connect.get CastaData linkesEnde) 1)   (setq WINDVERBAND_LB _windvblchb_flansch_links_))
  (if (= (Connect.get CastaData rechtesEnde) 1)  (setq WINDVERBAND_LB _windvblchb_flansch_rechts_))

  (Traeger.addabtl Tr_ID lchbAtrgSteg 0.0 0.0 WINDVERBAND_LB)
  (setq AbtlAugenLchb	(Traeger.get Tr_ID AbTeil lchbAtrgSteg))
  (Anbauteil.set AbtlAugenLchb (Winkel -90.0))
  
  (Blech.set bFahnenbl  (FormFkt "cb_Fahnenblech"))
  (Blech.set augenBlech (FormFkt "cb_Augenblech"))

)

; ----------------------------------------------------------------------------------------
; Erzeugt und setzt die Anbauteile der Verbindung
; ----------------------------------------------------------------------------------------



; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Fahne am HT
; ----------------------------------------------------------------------------------------
(defun cb_Fahnenblech (zp)
	(print "in Callback-Funktion cb_bFahnenbl")
	(print zp)
	;(print "in Callback-Funktion cb_bFahnenbl")

;	(if _CopyAction_ (print "CopyAction - Kopieren wird ausgefhrt!"))

	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get bFahnenbl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get bFahnenbl dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff 		(- dpNeu dpAlt))
	       (setq alteKlemml 	(Lochbild.get lchbAtrgSteg Klemml))
	       (setq dxsKopf_alt	(Lochbild.get lchbAtrgSteg dxskopf))
	       (setq klemml_neu		(+ alteKlemml dpDiff))
	     
		(print alteKlemml)
		(print klemml_neu)
	       
;		(if (= (Connect.get CastaData satr-lhtr)  1)
;	      		(setq dxsKopf_neu dxsKopf_alt)
;		)
;		(if (= (Connect.get CastaData satr-lhtr) -1)
;	      		(setq dxsKopf_neu (+ dxsKopf_alt dpDiff))
;		)
	       
	       
	        (Lochbild.set lchbAtrgSteg 	(klemml klemml_neu)
	       					;(dxskopf dxskopf_neu)
		)

	        (setq dpAuge (Blech.get Augenblech dp))

	        (setq dxskopf_neu (+ dpAuge (* 0.5 dpNeu)))

	        (Lochbild.set lchbAtrgSteg (KlemmL (+ dpNeu dpAuge)) (dxskopf dxskopf_neu))
	        
	        (BLech.set bFahnenbl (Delta_LR (* 0.5 (+ dpAuge dpNeu))))

	       
	    ))
	))
)
; ====================================================================== 
(defun cb_Augenblech (zp)
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get Augenblech dp))
	))
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get Augenblech dp))
	    
	    (if (/= dpNeu dpAlt) (progn
	        (print "cb_Augenblech: hier nderungen eintragen")
	        (setq dpFahne (Blech.get bFahnenbl dp))

	        (setq dxskopf_neu (+ dpNeu (* 0.5 dpFahne)))
	        (setq dxskopf_neu  (* 0.5 dpNeu))
	        (setq dxskopf_neu  0.0)

	        (Lochbild.set lchbAtrgSteg (KlemmL (+ dpNeu dpFahne)) (dxskopf dxskopf_neu))
	        
	        (BLech.set bFahnenbl (Delta_LR (* 0.5 (+ dpFahne dpNeu))))
	    ))
	))


)



; ----------------------------------------------------------------------------
; Berechnet die Lochbild Daten (wird hier dem AT hinzugefgt)
; ----------------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lchb_ID BlechID TrgEnde LbArt)
	(print "------------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID	;(lb_art  LbArt)
			(Anz_S    2)
			(Guete   "4.6")
	)
	
	(setq	h_trg 		(Traeger.get Tr_ID h)
		delta_v_at	(Traeger.get Tr_ID delta_v)
		t_at		(Traeger.get Tr_ID t)
		r_at		(Traeger.get Tr_ID r)
	)
	
	(setq	s_htrg		(Traeger.get Htrg s)
		delta_lr_htrg	(Traeger.get Htrg delta_lr)
		delta_v_ht	(Traeger.get Htrg delta_v)
		qsform_ht	(Traeger.get Htrg	qsform)
	)
	
	(setq trg_delta_l (TrEnde.get TrgEnde delta_l)
				trg_zakl		(TrEnde.get TrgEnde zakl)
	)
		
	; Schraubenbezeichnung
	(set_S_Bez Tr_ID Lchb_ID)
	
	; min. Loch- u. Randabstnde
	(calcMinRandLochAbst Lchb_ID)
	
	
	(print e_min)
	(print abstZumSteg)
	(print s_htrg)
	(setq abst_lchb_steg (+ abstZumSteg  e_min (* 0.5 s_htrg)))
	(print abst_lchb_steg)
	(print delta_lr_htrg)
	
	;(if (= (Connect.get CastaData amHtStegLinks) 1)
	;	(progn
	;		(setq w0 (- abst_lchb_steg delta_lr_htrg))
	;		(if (< delta_lr_htrg abst_lchb_steg)
	;			(setq w0_rund (runde w0 auf 5))
	;			(setq w0_rund (runde w0 ab 5))
	;		)
	;	)
	;)
	;(if (= (Connect.get CastaData amHtStegRechts) 1)
	;	(progn
	;		(setq w0 (+ abst_lchb_steg delta_lr_htrg))
	;		(if (< delta_lr_htrg abst_lchb_steg)
	;			(setq w0_rund (runde w0 ab 5))
	;			(setq w0_rund (runde w0 auf 5))
	;		)
	;	)
	;)
	(setq w0 abst_lchb_steg)
	(setq w0_rund (runde w0 auf 5))
	(print w0)
	(print w0_rund)
	
	(if (= qsform_ht "U")
		(progn
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(setq w0_rund (- w0_rund (* 0.5 s_htrg)))
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(setq w0_rund (+ w0_rund (* 0.5 s_htrg)))
			)
		)
	)
	;(setq w0_rund (runde w0 auf 5))
	
	(setq hp_blech 	(Blech.get BlechID hp)
				dok_blech	(Blech.get BlechID dok)
	)
	(print hp_blech)
	(print dok_blech)
	
	(calcUnterschied)
		
	(print hsteg)
	(print zakl)
	(print diff_oben)
	; e0 berechnen
	
	(if (<= min_h hp_blech)
		(progn	
			(if (> zakl 0.0)
				(progn
					(setq e0 (+ (* 0.25 hp_blech) zakl))
				)
				(progn
					(setq e0 (+ (* 0.25 hp_blech) r_at t_at))
				)
			)	
			
			(print e0)
			(setq e1 (* 0.5 hp_blech))
			
			; Klemmlnge
			(setq dp_blech 	(Blech.get BlechID dp))
			(setq s_trg			(Traeger.get Tr_ID s))
			
			; Schraubenkopf
			(calcDxSKopf dp_blech s_trg)
			
			(print w0_rund)
			(Lochbild.set Lchb_ID (e0 		e0)
														(e1 		e1)
														(w0 		w0_rund)
														(klemml (+ dp_blech s_trg))
														(dxSKopf dxSKopf)
			)
			(setq testW0 (Lochbild.get Lchb_ID w0))
			(print testw0)
		)
		(progn
			(if (> zakl 0.0)
				(progn
					(setq e0 (+ (* 0.5 hp_blech) zakl))
				)
				(progn
					(setq e0 (+ (* 0.5 hp_blech) r_at t_at))
				)
			)	
			
			(print e0)
			
			
			; Klemmlnge
			(setq dp_blech 	(Blech.get BlechID dp))
			(setq s_trg			(Traeger.get Tr_ID s))
			
			; Schraubenkopf
			(calcDxSKopf dp_blech s_trg)
			
			(print w0_rund)
			(Lochbild.set Lchb_ID
				(e0 		e0)
				(e1 		0)
				(w0 		w0_rund)
				(klemml (+ dp_blech s_trg))
				(dxSKopf dxSKopf)
			)
			
			(setq testW0 (Lochbild.get Lchb_ID w0))
			(print testw0)
		)
	) 
	
	(print e_min)
	(print w0_rund)
	
	(if (= LB_DEBUG 1)
		(Lochbild.set Lchb_ID (e2 300))
	)
	; Korregiere Fahnenblech
	(Blech.set BlechID (bp (+ (* 2.0 e_min_rund) abstZumSteg))) 
)








; ------------------------------------------------------------------------
; Passt die Lochbild-Anbauteile an.
; ------------------------------------------------------------------------
(defun setLochbild (LOCHB_ID)
	
	(setq h_ht				(Traeger.get Htrg h)
				s_ht				(Traeger.get Htrg s)
				b_ht				(Traeger.get Htrg b)
				delta_v_ht 	(Traeger.get Htrg delta_v)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
				qsform_ht		(Traeger.get Htrg qsform)
	)
	
	(setq delta_v_at	(Traeger.get Tr_ID delta_v)
				h_at				(Traeger.get Tr_ID h)
				r_winkel_at	(Traeger.get Tr_ID r_winkel)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	
	(setq xPos_ht 		(Connect.get CastaData xPos_ht)
				vwinkel_ht	(connect.get CastaData hpttrg_vwinkel)
	)
	
	(setq lb_ht_abtl (Traeger.get Htrg Abteil LOCHB_ID))
	(setq lb_at_abtl (Traeger.get Tr_ID Abteil LOCHB_ID))
	

	
	; s_ht bei Rund- und Kastenprofilen ndern!!!
	(if (= qsform_ht "K")
		(setq s_ht b_ht)
	)
	
	; Differnzwinkel zwischen HT-Neigung und AT-Rotation berechnen
	; ---------------------------------------------
	(print vwinkel_ht)
	(print r_winkel_at)
	(setq diffWinkel 0.0)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (+ vwinkel_ht rwinkel_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (- vwinkel_ht rwinkel_at ))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (- vwinkel_ht rwinkel_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (+ vwinkel_ht rwinkel_at ))
			)
		)
	)
	(print diffWinkel)
	
	(setq sinW (sin (/ (* PI diffWinkel) 180.0)))
	(setq cosW (cos (/ (* PI diffWinkel) 180.0)))
	(setq tanW (tan (/ (* PI diffWinkel) 180.0)))
	
	
	; Anbauteil AT
	; ----------------------------------------------
	(setq e_diff (- (* 0.5 h_trg) (* 0.5 hp_blech)))
	
	(if (= (Connect.get CastaData amHtUnterFlansch) 1) 	(setq delta_lr_abtl_at (+ (* 0.5 h_ht) delta_v_ht)))
	(if (= (Connect.get CastaData amHtOberFlansch) 1) 	(setq delta_lr_abtl_at (- (* 0.5 h_ht) delta_v_ht)))
	
	(if (= (Connect.get CastaData amHtStegLinks) 1) 	(setq delta_lr_abtl_at (- (* 0.5 s_ht) delta_lr_ht)))
	(if (= (Connect.get CastaData amHtStegRechts) 1) 	(setq delta_lr_abtl_at (+ (* 0.5 s_ht) delta_lr_ht)))
	
	(setq qsform_Ht (Traeger.get HTrg qsform))
	(if (= qsform_Ht "U") (progn
		(if (= (Connect.get CastaData amHtStegLinks)  1) 	(setq delta_lr_abtl_at (- (* 0.0 s_ht) delta_lr_ht)))
		(if (= (Connect.get CastaData amHtStegRechts) 1) 	(setq delta_lr_abtl_at (+ (* 1.0 s_ht) delta_lr_ht)))
	))
	
	(Anbauteil.set lb_at_abtl (delta_lr 	delta_lr_abtl_at))
	
	
	; Anbauteil HT
	; ----------------------------------------------
	(setq delta_v_abtl_ht 0.0)
	
	; Anteil delta_v AT 
	(setq anteil_delta_v_at delta_v_at)
	(print anteil_delta_v_at)
	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_at))
	(setq delta_v_abtl_ht (- delta_v_abtl_ht (* 0.5 h_at)))
	
	
	; Anteil delta_v HT
	(if (/= cosW  0.0)
		(setq anteil_dvHT_an_dv	(* (* 1.0 delta_v_ht) cosW))
		(setq anteil_dvHT_an_dv delta_v_ht)
	)
	
	(if (/= (Connect.get CastaData satr-lhtr) 0)
		(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_dvHT_an_dv))
	)
	
	
	
	(Anbauteil.set lb_ht_abtl (delta_v 	delta_v_abtl_ht))
	
	
	
	; Master setzen
	; ----------------------------------------------
	(Anbauteil.set lb_ht_abtl (Master 0))
	(Anbauteil.set lb_at_abtl (Master 1))
	
	
	
	; LOCHBILD-TEST
	;===================================================================
	(if (= LB_DEBUG 1)
		(progn
			(setq dummy (Lochbild.create))
			(Lochbild.copy dummy LOCHB_ID)
						
	
	
			(if (= (connect.get CastaData amHtStegLinks) 1) 
				(Traeger.addabtl Htrg dummy XPos 180.0 _fahnblLochbild_ AbtlFahnenBl)
    	)
	    (if (= (connect.get CastaData amHtStegRechts) 1) 
				(Traeger.addabtl Htrg dummy XPos 180.0 _fahnblLochbild_ AbtlFahnenBl)
	    )
			
			(setq dummy_abtl (Traeger.get Htrg Abteil dummy))
			(Anbauteil.set dummy_abtl (Master 1)
				;(delta_lr delta_lr_abtl_ht)
				(delta_v 	delta_v_abtl_ht)
			)
		)
	)
	;===================================================================
	
)

(defun calcRotationFahne ()

;	(print "*clear*")
;	(Connect.showAttributes CastaData)
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE DIE ROTATION DES FAHNENBLECHES")

;	Lsung DM
;	funktionierte nicht bei HT auf dem Kopf liegend (Rotation 180.0)	
;	   (setq rwinkel_at	(Traeger.get Tr_ID r_winkel))
;	ersetzt durch Lsung AF 062009
	(setq rwk_vfl		(Connect.get CastaData v-atrgewnkl_flansch))
	(setq rwk_rst		(Connect.get CastaData r-atrgewnkl_steg))
	(setq rwk_kpf		(Connect.get CastaData r-atrgewnkl_kopf))

	(setq rwinkel_at        (+ (- 180.0 rwk_vfl) (- rwk_rst 90.0)))
	(if (= (Connect.get CastaData vatr-vhtr) -1)		(setq rwinkel_at        (- (- 180.0 rwk_vfl) (- rwk_rst 90.0))))
;	Ende neuer Lsung

	(print rwinkel_at)
	
	(setq vwinkel_ht	(Connect.get CastaData hpttrg_vwinkel))
	(print vwinkel_ht)
	
	; Winkel des Anbauteils
	(setq abtl_fahne_winkel 90.0)
	
	; Anteil HT Schrgstellung
	(setq abtl_fahne_winkel (- abtl_fahne_winkel vWinkel_ht))
	
	(print rwinkel_at)
	(print abtl_fahne_winkel)
	
	; Anteil Rotation des AT
(if (= 1 2)	(progn
	(if (= (Connect.get CastaData satr-lhtr)  1)	(setq abtl_fahne_winkel (- abtl_fahne_winkel rwinkel_at)))
	(if (= (Connect.get CastaData satr-lhtr) -1)	(setq abtl_fahne_winkel (- abtl_fahne_winkel rwinkel_at)))
	(if (= (Connect.get CastaData satr-lhtr)  0)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq abtl_fahne_winkel (- abtl_fahne_winkel rwinkel_at)))
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq abtl_fahne_winkel (- abtl_fahne_winkel rwinkel_at)))
		)
	)
))

	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq abtl_fahne_winkel (- abtl_fahne_winkel rwinkel_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq abtl_fahne_winkel (+ abtl_fahne_winkel rwinkel_at))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq abtl_fahne_winkel (+ abtl_fahne_winkel rwinkel_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq abtl_fahne_winkel (- abtl_fahne_winkel rwinkel_at))
			)
		)
	)
	
	; Korrektur passend zur einleitende Passage
	; 062009 AF
	(if (= (Connect.get CastaData linkesEnde) 1) (setq abtl_fahne_winkel (- abtl_fahne_winkel 180.0)))
	
	(print abtl_fahne_winkel)
	
	
	(print "<-------------------------------------------------------------------------------")
)







(defun calcPositionFahne ()
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE DIE POSITION DES FAHNENBLECHES")

  (setq abtlFahnBl_HT (Traeger.get HTrg ABTeil bFahnenbl))
  (setq abtlLochb_HT  (Traeger.get HTrg ABTeil lchbAtrgSteg))
  (setq abtl_fahne_winkel_Ende (Anbauteil.get abtlFahnBl_HT Winkel))

	(setq abtl_Delta_LR 0.0)
	(setq abtl_Delta_V  0.0)


	(setq	delta_V_AT	(Traeger.get Tr_ID delta_v)
		delta_LR_AT	(Traeger.get Tr_ID delta_LR)
	)
;	(if (= (Connect.get CastaData satr-lhtr-ex) -1) (setq delta_V_AT (- delta_V_AT)))
	(if (/= (Connect.get CastaData satr-lhtr-ex)  0) (progn
	    (if (= (Connect.get CastaData amHtStegLinks) 1)  
		(if (= (Connect.get CastaData rechtesEnde) 1) (setq delta_V_AT (- delta_V_AT)))
	    )
	    (if (= (Connect.get CastaData amHtStegRechts) 1)  
		(if (= (Connect.get CastaData linkesEnde) 1) (setq delta_V_AT (- delta_V_AT)))
	    )
	))

	(if (= (Connect.get CastaData satr-lhtr-ex)  0) (progn
	   (if (= (Connect.get CastaData vatr-lhtr)  1)
	   	(if (< abtl_fahne_winkel_Ende 0.0) (setq delta_V_AT (- delta_V_AT)))
	   )
	   (if (= (Connect.get CastaData vatr-lhtr) -1)
	   	(if (> abtl_fahne_winkel_Ende 0.0) (setq delta_V_AT (- delta_V_AT)))
	   )
	))
	
	(setq abtl_Delta_LR (+ abtl_Delta_LR delta_V_AT))

	
	; seitliche Verschiebung des AT
	(setq delta_LR_AT (- delta_LR_AT))
	(setq abtl_Delta_V (+ abtl_Delta_V delta_LR_AT))

	; vertikale Verschiebung des HT
	(setq delta_V_HT (Traeger.get HTrg delta_V))
	(print "------------------------------------")
	(print 	abtl_fahne_winkel_Ende)
	(setq wAlfa (- 180.0 abtl_fahne_winkel_Ende))
	(setq sinWnk (sin (/ (* PI wAlfa) 180.0)))
	(setq cosWnk (cos (/ (* PI wAlfa) 180.0)))
	
	(setq dv_Anteil_HT (* cosWnk delta_V_HT))
	(print dv_Anteil_HT)

	(setq dlr_Anteil_HT (* sinWnk delta_V_HT))

	(setq abtl_Delta_LR (+ abtl_Delta_LR  dv_Anteil_HT))	; aufaddieren
	(setq abtl_Delta_V  (- abtl_Delta_V   dlr_Anteil_HT))	; aufaddieren
	; ------------------------------------------------

	; Werte jetzt hier einsetzen
	(Blech.set bFahnenbl (delta_LR abtl_Delta_LR))

	(Anbauteil.set abtlFahnBl_HT (delta_V abtl_Delta_V))


	(Anbauteil.set abtlLochb_HT (delta_SX abtl_Delta_LR))
	


   ; 000000000000000000000000000000000000000000 kann weg 0000000000000000000000000000000000
   (if (= 2 5) (progn	
	(setq delta_v_ht	(Traeger.get Htrg delta_v))
	
	(setq vwinkel_uz (Connect.get CastaData hpttrg_vwinkel))
	
	(setq rwinkel_at	(Traeger.get Tr_ID r_winkel)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	
	
	; Differnzwinkel zwischen HT-Neigung und AT-Rotation berechnen
	; ---------------------------------------------
	(print vwinkel_uz)
	(print rwinkel_at)
	(setq diffWinkel 0.0)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (+ vwinkel_ht rwinkel_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (- vwinkel_ht rwinkel_at ))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (- vwinkel_ht rwinkel_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (+ vwinkel_ht rwinkel_at ))
			)
		)
	)
	(print diffWinkel)
	
	(setq sinW (sin (/ (* PI diffWinkel) 180.0)))
	(setq cosW (cos (/ (* PI diffWinkel) 180.0)))
	(setq tanW (tan (/ (* PI diffWinkel) 180.0)))
	
	
	(setq verschiebung_delta_v 0.0)
	(setq verschiebung_delta_lr 0.0)
	
	; HT-Verschiebungen
	; ++++++++++++++++++++++++++++++++++++++++++++++
	
	; Anteil delta_v Verschiebung HT
	; ----------------------------------------------
	(if (= 1 2)	(progn
	; ----------------------------------------------
		(setq verschiebung_delta_v (+ verschiebung_delta_v (* delta_v_ht cosW)))
		
		(print verschiebung_delta_v)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	; AT-Verschiebungen
	; ++++++++++++++++++++++++++++++++++++++++++++++
	
	; Anteil delta_lr Verschiebung AT
	; ----------------------------------------------
	(if (= 1 2)	(progn
	; ----------------------------------------------
		(setq verschiebung_delta_v (+ verschiebung_delta_v (* delta_v_ht cosW)))
		
		(print verschiebung_delta_v)
	; ----------------------------------------------
	))
	
	
	
	; ----------------------------------------------
	; Kontrollen
	; ----------------------------------------------
	(print verschiebung_delta_v)
	
	
	; Anbauteil Fahne Werte setzen
	(Anbauteil.set ABTL (delta_v 	verschiebung_delta_v))	
	(print "<-------------------------------------------------------------------------------")
  ))
)


(defun createAugenBlech (Blech_ID)
	
  (setq h_at (Traeger.get Tr_ID h))
  (setq e_min_rund 40)
	

  (if (= (Connect.get CastaData linkesEnde) 1)
  	(traeger.addabtl tr_id Blech_ID 0.0 0.0 _augenblech_links_)
  )
  (if (= (Connect.get CastaData rechtesEnde) 1)
  	(traeger.addabtl tr_id Blech_ID 0.0 0.0 _augenblech_rechts_)
  )
  
  ; Schlitzlaenge der Augenlasche
  (setq lSchlitz (Blech.get Blech_ID lSchlitz)) 
  (print lSchlitz)
  
  ; Breite der Augenlasche
  (setq bp_al (+ h_at 20.0))
  (print bp_al)
  (setq min_bp_al (* 2.0 e_min_rund))	; erstmal nicht bercksichtigen
  (setq min_bp_al bp_al)
  
  (if (>= bp_al min_bp_al)
  	(setq bp_al bp_al)
  	(setq bp_al min_bp_al)
  )
  
  ; Lnge der Augenlasche
  (setq KONTAKTLAENGE 100.0)
  (setq hp_al (+ lSchlitz (* KONTAKTLAENGE 1.25)))
  ;; (setq hp_al (+ lSchlitz anteil_rand_abst MIN_ABST_AUGENLCHB_BLECHENDE h_at))
  
;  (calcAndSetAugenBlechDicke augenBlech)	; -> dp_al
  
  (Blech.set Blech_ID	(bp bp_al)
			(hp hp_al)
  )
  
  
)

(defun calc_Schr_Abstand ()

  (print "calc_Schr_Abstand ------------ ")
  (setq Lchb_Delta_LR 0)
  (if (= (Connect.get CastaData linkesEnde) 1)  (setq TrgEnde (Traeger.get Tr_ID links)))
  (if (= (Connect.get CastaData rechtesEnde) 1) (setq TrgEnde (Traeger.get Tr_ID rechts)))
  (setq Lchb_Delta_LR (TrEnde.get TrgEnde Delta_L))
  (print Lchb_Delta_LR)

  (setq s_HT (Traeger.get HTrg s))
  (setq b_HT (Traeger.get HTrg b))
   (setq qsform_Ht (Traeger.get HTrg qsform))
   (if (= qsform_Ht "U") (progn					; U-Profile
	(print "U-Profil untersuchen")
        (if (= (Connect.get CastaData amHTstegRechts) 1) (progn ; am U-Steg - s vollstndig bercksichtigen
           (setq Lchb_Delta_LR (+ Lchb_Delta_LR s_HT))
        ))
   ))
   (if (= qsform_Ht "K") (setq Lchb_Delta_LR (+ Lchb_Delta_LR (* 0.5 b_HT))))	; K-Profile
   (if (= qsform_Ht "I") (setq Lchb_Delta_LR (+ Lchb_Delta_LR (* 0.5 s_HT))))	; I-Profile

  (print "nach Stegbercksichtigung")
  (print Lchb_Delta_LR)
  
  ; vertikale Verschiebung berechnen
  (setq		HT_deltaV (Traeger.get HTrg  delta_V)
  		AT_deltaV (Traeger.get Tr_ID delta_LR)
  )
  (setq Lchb_Delta_V (- HT_deltaV AT_deltaV))
  (print Lchb_Delta_V)
  
  

)
; ---------------------------------------------------------------------------
(defun versetze_FahnenBl ()
   (setq	dp_FahnBl	(Blech.get bFahnenbl dp)
   		dp_AugenBl	(Blech.get Augenblech dp)
   		curr_XAsym	(Blech.get bFahnenbl delta_LR)
   )
   (Blech.set bFahnenbl (delta_LR (+ curr_XAsym (* 0.5 (+ dp_FahnBl dp_AugenBl)))))
   
)
; ---------------------------------------------------------------------------
(defun versetze_AugLchb ()
   (setq	dp_FahnBl	(Blech.get bFahnenbl dp)
   		dp_AugenBl	(Blech.get Augenblech dp)
   )
   (Lochbild.set lchbAtrgSteg 	(dxSKopf (* 0.5 dp_AugenBl))
   				(KlemmL  (+ dp_FahnBl dp_AugenBl))
   )

  (setq AbtlAugenLchb	(Traeger.get Tr_ID AbTeil lchbAtrgSteg))

  
  (if (= (Connect.get CastaData satr-vhtr) 1) (progn
    (if (= (Connect.get CastaData linkesEnde) 1) (progn
;       (Anbauteil.set AbtlAugenLchb (Winkel -90.0))
        (Anbauteil.set AbtlAugenLchb  (delta_LR Lchb_Delta_LR))
    ))
 
    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
    ; - am rechten Ende - je nach Lage, diese Kombination
;        (Anbauteil.set AbtlAugenLchb  (seitricht -1))
;        (Anbauteil.set AbtlAugenLchb  (Winkel  90.0))
        (Anbauteil.set AbtlAugenLchb  (delta_LR (- Lchb_Delta_LR)))
    ;
    ))
  ))
  (if (= (Connect.get CastaData satr-vhtr) -1) (progn
    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
;        (Anbauteil.set AbtlAugenLchb (Winkel -90.0))
        (Anbauteil.set AbtlAugenLchb  (delta_LR   Lchb_Delta_LR))
    ))
 
    (if (= (Connect.get CastaData linkesEnde) 1) (progn
    ; - am rechten Ende - je nach Lage, diese Kombination
;        (Anbauteil.set AbtlAugenLchb  (seitricht -1))
;        (Anbauteil.set AbtlAugenLchb  (Winkel  90.0))
        (Anbauteil.set AbtlAugenLchb  (delta_LR (- Lchb_Delta_LR)))
    ;
    ))
  ))
	
	(setq Augbl_Lochb_Winkel (Anbauteil.get AbtlAugenLchb  Winkel))
	(if (= (Connect.get CastaData linkesEnde) 1) (Anbauteil.set AbtlAugenLchb  (Winkel  90.0)))
	
;	(Lochbild.set lchbAtrgSteg (e "0 15 60 0 0 0"))

;	(setq delta_LR_AT (Traeger.get Tr_ID delta_LR))
;	(Anbauteil.set AbtlAugenLchb  (delta_V  delta_LR_AT))
   
)
(defun calcFahnenblechDaten ()
    (setq	h_HTrg (Traeger.get HTrg h)
    		b_HTrg (Traeger.get HTrg b)
    		s_HTrg (Traeger.get HTrg s)
    		r_HTrg (Traeger.get HTrg r)
    		t_HTrg (Traeger.get HTrg t)
    )
    (setq sd (Lochbild.get lchbAtrgSteg sdurchm))

    (setq hp_fbl (- h_HTrg (* 2.0 (+ t_HTrg r_HTrg))))
    (setq bp_fbl (- (* 0.5 b_HTrg) (* 0.5 s_HTrg)))

    (setq bp_fbl (* 5.0 sd))
    (setq bp_fbl (runde bp_fbl auf 5))
    (setq hp_fbl (runde hp_fbl ab  5))

    (setq bp_fbl 80)

    (Blech.set bFahnenbl 
	(bp bp_fbl) (hp hp_fbl) 
	; (x2 20) (y2 20)			; Ausrundung unten abziehbar
	; (x3 20) (y3 20)			; Ausrundung oben abziehbar
    )

)
(defun calcFahnenblechLochbild ()
    (setq	
    		b_HTrg (Traeger.get HTrg b)
    		s_HTrg (Traeger.get HTrg s)
    )
    (setq sd (Lochbild.get lchbAtrgSteg sdurchm))

    ; fuer I-Traeger vorerst geeignet
    (setq w0_soll (* 0.25 (- b_HTrg s_HTrg)))
    (setq w0_soll (* 3.0 sd))
    (setq w0_soll (runde w0_soll auf 5))
    (print w0_soll)
    
    
    
    (setq	bp_Aug (Blech.get augenBlech bp)
    		bpNetto (- bp_Aug (* 3.0 sd))
    		bpNetto  (runde bpNetto ab 5)
    )

    (setq e1 bpNetto
    	  e0 (- (* 0.5 bpNetto))
    )

    (Lochbild.set lchbAtrgSteg 
   		(e 		"-30 10 0 0 0 0")
   		(w0 w0_soll)
    		(e0 e0)
    		(e1 e1)
    )

)