; $	HT	QT(F)		AF(F)		P(EZ)
; $ 	AT	QT(F)		AF(S)		P(E)
; $	AE	V(-)		H(-)		R(-)

(defun load-modules ()

        (print "*clear*")

	(print "Anschluss:")
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(print "am HT-Oberflansch")
			(load "mod-endinit-uz-an-flachstahl.lsp")
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(print "am HT-Unterflansch")
			(load "mod-endinit-uz-an-flachstahl.lsp")
		) 
	)
        (load "mod-lochbild")
)




(defun init-connection ()

	(setq LB_DEBUG 0)
	
	(connect.showattributes CastaData)
	(checkPosition)		; berechnet isInside

	(if (= isInside 1)
	    (progn
		(print "in init-connection uz_an_Flachstahl mit Fahne .........................")
		(if (= (Connect.get CastaData amHtSteg) 1)
			(alertBox "Anschluss an der schmalen Kante ist nicht mglich!"  "ERR_SlimRimConnection")
		)
;		(if (= (Connect.get CastaData amHtFlansch) 1)
			; (init-traegerenden)	; hier werden die Traegerenden gestutzt
;		)
  		(setConnection)	
  
  		(print bFahnenbl)

		(setq dOK_Blech (Blech.get bFahnenbl dOK))
		(print " ......... am Ende der Makro-Ausfhrung...")
		(print dOK_Blech)
		
;		(setq abtl_Lchb_Htrg (Traeger.get HTrg ABTeil lchbAtrgSteg))
;		(Anbauteil.set abtl_Lchb_Htrg (delta_V 0))

;		(print "Anbauteil-Delta_V")
;		(setq abtl_DV (Anbauteil.get abtl_Fahne delta_v))
;		(print abtl_DV)

  	    )
  	    (progn
  		(alertBox "Anschluss ist nicht mglich!"  "Connection_Not_Possible")
  	    )
	)

	; (connect.showattributes CastaData)
  
    
)


(defun setConnection ()
	
	(setq S_Bez "M16")

	; Berechnung x-Position aufgrund schrgen HT und seitlicher Verschiebung
	(calcXPosFahnenBlech)
	(sucheFahnenBlech)
	(if (= Doppelverbindung 0) (progn
		(setq bFahnenbl    (Blech.create))
		(setq lchbAtrgSteg (Lochbild.create))
		(Connect.storeAnschlObjs CastaData bFahnenbl lchbAtrgSteg)
		(print "Fahnenblech erzeugt")
	  
		(Blech.set bFahnenbl (dp 10) (hp 200) (bp 110) (dOK 0)) (print "Default Blechdaten")
	  
		(setq	XPos 	(Connect.get CastaData XPos_HT)
	  		xPos_at	(Connect.get CastaData xPos_AT)
	  	)
	  	(print XPos)
	  
	  	(setq abstzumSteg 10)

	
	  ; Fahnenblechdaten Berechnen
	  	(calcBlechUndSchraubenGroesse)
	  ; Fahnenblech hinzufgen
		(setFahnenBlechAnbauteil bFahnenbl)
	  ; Lochbildposition berechnen	
		(calcLochbildPosition)


	))
	(if (> Doppelverbindung 0) (progn
		; Das muss noch akurater ...
		; dxSKopf und Klemmlnge anpassen
		; lokale Lage des Lochbild im AT einsetzen
		; Fehlermeldung darf nicht erscheinen.
		(calc_doppV_Schrauben)
		(calcLochbildPosition)
	))
	
  ; AT-Trgerende anpassen
	(calc_AT_EndLaenge)
	
	
)

(defun showBlechDaten (Bl_ID)
    (setq hp (Blech.get Bl_ID hp))
    (setq bp (Blech.get Bl_ID bp))
    (setq dp (Blech.get Bl_ID dp))
 
    (print "Blechdaten-Anzeige -------------------------")   
    (print hp)
    (print bp)
    (print dp)
)


(defun	calcLochbildPosition ()

    (if (= Doppelverbindung 0) (progn
	; Lochbild HT
	(print "ADDABTL - Fahnenblechlochbild in HT")
	(setq AbtlFahnenBl	(Traeger.get Htrg AbTeil bFahnenbl))
	(Traeger.addabtl Htrg lchbAtrgSteg XPos 0.0 _fahnblLochbild_ AbtlFahnenBl)


	; Lochbild AT
	(if (= (Connect.get CastaData amHtUnterflansch) 1) 	(setq Flansch_LB _flanschlochbild_uf_))
	(if (= (Connect.get CastaData amHtOberflansch)  1) 	(setq Flansch_LB _flanschlochbild_of_))
	(Traeger.addabtl Tr_ID lchbAtrgSteg xPos_at 0.0 Flansch_LB)

	(setq Abtl_LB_HT (Traeger.get HTrg  ABTeil lchbAtrgSteg))
	(setq Abtl_LB_AT (Traeger.get Tr_ID ABTeil lchbAtrgSteg))
	(Anbauteil.set Abtl_LB_HT (Master 1))
	(Anbauteil.set Abtl_LB_AT (Master 0))
    ))
	
    (if (> Doppelverbindung 0) (progn
	(setq Abtl_LB_AT (Traeger.get Tr_ID ABTeil lchbAtrgSteg))
    ))
	
    	; Horizontalverschiebung Anbauteil Lochbild
	(setq	dlr_AT (Traeger.get Tr_ID delta_LR)
		b_AT   (Traeger.get Tr_ID b)
		dv_HT  (Traeger.get HTrg delta_V)
	)
	(setq lb_Delta_LR    dlr_AT)
	
	(if (= (Connect.get CastaData vAtr-lHtr) 1) (progn
		(if (= (Connect.get CastaData at-von-links) 1) (Anbauteil.set Abtl_LB_AT (SeitRicht -1)))
	))
	(if (= (Connect.get CastaData vAtr-lHtr) -1) (progn
		(if (= (Connect.get CastaData at-von-rechts) 1) (Anbauteil.set Abtl_LB_AT (SeitRicht -1)))
	))

	(if (= (Connect.get CastaData at-von-rechts)  1) (setq dv_HT (- dv_HT)))
	(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
		(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq lb_Delta_LR (- lb_Delta_LR dv_HT)))
		(if (= (Connect.get CastaData vAtr-lHtr) -1) (setq lb_Delta_LR (+ lb_Delta_LR dv_HT)))
	))
	(if (= (Connect.get CastaData amHtOberflansch) 1) (progn
		(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq lb_Delta_LR (- lb_Delta_LR dv_HT)))
		(if (= (Connect.get CastaData vAtr-lHtr) -1) (setq lb_Delta_LR (+ lb_Delta_LR dv_HT)))
	))
	(Anbauteil.set Abtl_LB_AT (delta_LR lb_Delta_LR))

    ; Lochbilddaten - Abmessungen - nur bei erstem Durchlauf festlegen
    (if (= Doppelverbindung 0) (progn
	(setq  w0_LB lb_Delta_LR)
	(if (< w0_LB 0.0) (setq w0_LB (- w0_LB)))

	(setq	dv_AT	(Traeger.get 	Tr_ID 		delta_V))
	(if (< dv_AT 0.0) 
		(setq val_dxSKopf (+ (* 0.5  dp) t_AT))
		(setq val_dxSKopf (+ (* 0.5  dp) 0))
	)
  	(if (= (Connect.get CastaData vatr-lhtr)  -1)	(progn
		(setq val_dxSKopf (+ (* 0.5  dp) 0))
		(setq val_dxSKopf (+ (* 0.5  dp) t_AT))
  	))

	(Lochbild.set lchbAtrgSteg (KlemmL (+ t_AT dp)))	; Klemmlnge der Schraube
	(Lochbild.set lchbAtrgSteg (dxSKopf val_dxSKopf))	; Schrauben-Lngsverschiebung
	(if (= (Connect.get CastaData amHtUnterflansch) 1) (Lochbild.set lchbAtrgSteg (LB_Art  2) (w0 w0_LB)))
	(if (= (Connect.get CastaData amHtOberflansch)  1) (Lochbild.set lchbAtrgSteg (LB_Art -2) (w0 w0_LB)))

	; (Lochbild.set lchbAtrgSteg (w0 0) (e "0 15 60 0 0 0"))	; zum Testen - wieder entfernen
	; (Lochbild.set lchbAtrgSteg (w1 100)) 				; zum Testen - wieder entfernen
    ))
    	
    	; Vertikalverschiebung Anbauteil Lochbild
	(setq abtl_bl_Ht (Traeger.get HTrg AbTeil bFahnenbl))
	(setq blWinkel (Anbauteil.get abtl_bl_Ht Winkel))
	(setq cosBeta (cos (/ (* PI (- blWinkel 90.0)) 180.0)))

	(setq 	dlr_HT	(Traeger.get HTrg delta_LR))
	(setq	dlr_HT	(/ dlr_HT cosBeta))
	(if (= (Connect.get CastaData LinkesEnde) 1) (progn
	    (setq dv_Lb 0.0)
	    (if (= (Connect.get CastaData at-von-links)  1) (setq dv_Lb (+ dv_Lb dlr_HT)))
	    (if (= (Connect.get CastaData at-von-rechts) 1) (setq dv_Lb (- dv_Lb dlr_HT)))
	    (Anbauteil.set Abtl_LB_AT (delta_V dv_Lb))
	))
	(if (= (Connect.get CastaData RechtesEnde) 1) (progn
	    (setq dv_Lb 0.0)
	    (if (= (Connect.get CastaData at-von-links)  1) (setq dv_Lb (+ dv_Lb dlr_HT)))
	    (if (= (Connect.get CastaData at-von-rechts) 1) (setq dv_Lb (- dv_Lb dlr_HT)))
	    (Anbauteil.set Abtl_LB_AT (delta_V dv_Lb))
	))


)
(defun calc_AT_EndLaenge ()

 	(setq abtl_lb_Ht (Traeger.get HTrg AbTeil lchbAtrgSteg))
 	(setq abtl_bl_Ht (Traeger.get HTrg AbTeil bFahnenbl))
 	(setq blWinkel (Anbauteil.get abtl_bl_Ht Winkel))
 	(setq cosBeta (cos (/ (* PI (- blWinkel 90.0)) 180.0)))


	(setq 	hp 	(Blech.get bFahnenbl hp))
	(setq 	dlr_HT	(Traeger.get HTrg delta_LR))
	(setq   dlr_HT  (/ dlr_HT cosBeta))

	(if (= (Connect.get CastaData LinkesEnde) 1) (progn
	    (setq TrgEnde (Traeger.get Tr_ID links))
	    (setq dl_Neu (* -0.5 hp))
	    (if (= (Connect.get CastaData at-von-links)  1) (setq dl_Neu (+ dl_Neu dlr_HT)))
	    (if (= (Connect.get CastaData at-von-rechts) 1) (setq dl_Neu (- dl_Neu dlr_HT)))
	    (TrEnde.set TrgEnde (delta_L dl_Neu))
	))
	(if (= (Connect.get CastaData RechtesEnde) 1) (progn
	    (setq TrgEnde (Traeger.get Tr_ID rechts))
	    (setq dl_Neu (* -0.5 hp))
	    (if (= (Connect.get CastaData at-von-links)  1) (setq dl_Neu (- dl_Neu dlr_HT)))
	    (if (= (Connect.get CastaData at-von-rechts) 1) (setq dl_Neu (+ dl_Neu dlr_HT)))
	    (TrEnde.set TrgEnde (delta_L dl_Neu))
	))

)

; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Fahne am HT
; ----------------------------------------------------------------------------------------
(defun cb_bFahnenbl (zp)
	(print "in Callback-Funktion cb_bFahnenbl")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt 	(Blech.get bFahnenbl dp))
	    (setq hpAlt 	(Blech.get bFahnenbl hp))
	    (setq dokAlt 	(Blech.get bFahnenbl dok))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
		(setq dpNeu (Blech.get bFahnenbl dp))
		(setq hpNeu (Blech.get bFahnenbl hp))
		(setq dokNeu (Blech.get bFahnenbl dok))
		
		(print dpAlt) (print dpNeu)
		(print hpAlt) (print hpNeu)
		(print dokAlt) (print dokNeu)
		(print "--------------------------------------")
		
		; nderung der Blechdicke
		(if (/= dpAlt dpNeu) (progn
			(setq dpDiff (- dpNeu dpAlt))
			
			(setq qsform_at	(Traeger.get Tr_ID qsform))
			
			(setq alteKlemml 	(Lochbild.get lchbAtrgSteg Klemml)
						dxs_alt			(Lochbild.get lchbAtrgSteg dxskopf)
			)
			
			(setq delta_lr_blech_alt (Blech.get bFahnenbl delta_lr))
			(print delta_lr_blech_alt)
			
			(setq klemml_neu	(+ alteKlemml dpDiff))
			
			(setq dxs_neu (+ dxs_alt (* 0.5 dpDiff)))
			
			(if (= qsform_at "I")
				(setq delta_lr_blech_neu (+ delta_lr_blech_alt (* 0.5 dpDiff)))
			)
			(if (= qsform_at "U")
				(progn
					
					(if (= (Connect.get CastaData amHtSteg) 1)
						(progn
							(if (= (Connect.get CastaData satr-vhtr)  1)	
								(setq delta_lr_blech_neu (+ delta_lr_blech_alt (* 0.5 dpDiff)))
							)
							(if (= (Connect.get CastaData satr-vhtr) -1)	
								(setq delta_lr_blech_neu (- delta_lr_blech_alt (* 0.5 dpDiff)))
							)
						)
					)
						(if (= (Connect.get CastaData amHtFlansch) 1)
						(progn
							(if (= (Connect.get CastaData satr-shtr)  1)	
								(setq delta_lr_blech_neu (+ delta_lr_blech_alt (* 0.5 dpDiff)))
							)
							(if (= (Connect.get CastaData satr-shtr) -1)	
								(setq delta_lr_blech_neu (- delta_lr_blech_alt (* 0.5 dpDiff)))
							)
						)
					)
					
				)
			)
			
			(print delta_lr_blech_neu)		  	
			
			(Blech.set bFahnenbl (delta_lr delta_lr_blech_neu))
			              
			(Lochbild.set lchbAtrgSteg 	(klemml klemml_neu)
																	(dxskopf dxs_neu)
			)    
			
			
			(setq abtl_lb_ht (Traeger.get Htrg AbTeil lchbAtrgSteg))
		  
		  (setq delta_sx_abtl_ht_neu delta_lr_blech_neu )
						
			(Anbauteil.set abtl_lb_ht (delta_sx delta_sx_abtl_ht_neu))
			
			
		))
		    
				
		(if (= 1 2)	(progn		
		; nderung der Blechhhe
		(if (/= hpAlt hpNeu) (progn
		  (setq hpDiff (- hpNeu hpAlt))
		  
		  (setq abtl_lb_at (Traeger.get Tr_ID AbTeil lchbAtrgSteg))
		  (setq delta_v_abtl_at_alt (Anbauteil.get abtl_lb_at delta_v))
		  (print delta_v_abtl_at_alt)
		  
			(if (= (Connect.get CastaData vatr-lhtr) -1) (setq delta_v_abtl_at_neu (- delta_v_abtl_at_alt (* 0.5 hpDiff))))
			(if (= (Connect.get CastaData vatr-lhtr)  1) (setq delta_v_abtl_at_neu (+ delta_v_abtl_at_alt (* 0.5 hpDiff))))
			(print delta_v_abtl_at_neu)
			
			(Anbauteil.set abtl_lb_at (delta_v delta_v_abtl_at_neu))
		))
		
		; Verschiebung des Bleches in HT-Lngsrichtung
		(if (/= dokAlt dokNeu) (progn
		  (setq dokDiff (- dokNeu dokAlt))
		  (print dokDiff)
		  
		  (setq abtl_lb_at (Traeger.get Tr_ID AbTeil lchbAtrgSteg))
		  (setq delta_v_abtl_at_alt (Anbauteil.get abtl_lb_at delta_v))
		  (print delta_v_abtl_at_alt)
		  
		  (if (= (Connect.get CastaData vatr-lhtr) -1) (setq delta_v_abtl_at_neu (+ delta_v_abtl_at_alt dokDiff)))
		  (if (= (Connect.get CastaData vatr-lhtr)  1) (setq delta_v_abtl_at_neu (- delta_v_abtl_at_alt dokDiff)))
		  (print delta_v_abtl_at_neu)

		  (Anbauteil.set abtl_lb_at (delta_v delta_v_abtl_at_neu))
		))
	))
	))
)



; ------------------------------------------------------------------------
; Setzt das Fahnenblech-Anbauteil
; ------------------------------------------------------------------------
(defun setFahnenBlechAnbauteil (Blech_ID)
	
  (setq XPos 		(Connect.get CastaData XPos_HT))
  (setq XPos xPos_Blech)	; bei schrgem HT und Vertikalverschiebung (seitlich HT)
	
  (setq delta_v_at (Traeger.get Tr_ID delta_v))
	
  (setq AT_WnklSteg (Connect.get CastaData v-atrgewnkl_steg))
		
	; Anschlsse am Flansch des Haupttrgers
  (if (= (Connect.get CastaData amHtOberflansch) 1) 	(progn
	(print "ADDABTL - Fahnenblech an HT (amHtOberflansch)")
	(setq rWinkel AT_WnklSteg)
  	(if (= (Connect.get CastaData amAtStegLinks) 1) (setq rWinkel (- 180.0 AT_WnklSteg)))
  	(traeger.addabtl hTrg Blech_ID XPos rWinkel _fahnenblech_of_)
  ))
  (if (= (Connect.get CastaData amHtUnterflansch) 1) 	(progn
	(print "ADDABTL - Fahnenblech an HT (amHtUnterflansch)")
	(setq rWinkel AT_WnklSteg)
  	(if (= (Connect.get CastaData amAtStegRechts) 1) (setq rWinkel (- 180.0 AT_WnklSteg)))
  	(traeger.addabtl hTrg Blech_ID XPos rWinkel _fahnenblech_uf_)
  ))
  
  
  ; Anteil delta_v AT
  (setq delta_v_abtl_fb 0)
  
  (if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_abtl_fb (- delta_v_abtl_fb delta_v_at)))
  (if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_abtl_fb (+ delta_v_abtl_fb delta_v_at)))
	
  
  (setq abtl_fahne (Traeger.get Htrg AbTeil Blech_ID))
  
  (Anbauteil.set abtl_fahne (delta_v delta_v_abtl_fb))
  ;; wird jetzt einfach 0 eingesetzt ...
  (Anbauteil.set abtl_fahne (delta_v 0.0))
  
  (setq	t_AT	(Traeger.get 	Tr_ID 		t)
  	dv_AT	(Traeger.get 	Tr_ID 		delta_V)
	dp	(Blech.get 	Blech_ID	dp)
  )
  (setq	t_AT	(Traeger.get 	Tr_ID 		t)
  	dv_AT	(Traeger.get 	Tr_ID 		delta_V)
	dp	(Blech.get 	Blech_ID	dp)
  )
  
  (if (>= dv_AT 0.0) (progn
    (BLech.set Blech_ID (xASym (+ (* -0.5 (+ t_AT dp)) dv_AT)))
  ))
  (if (< dv_AT 0.0) (progn
    (BLech.set Blech_ID (xASym (+ (* 0.5 (+ t_AT dp)) dv_AT)))
  ))
  (if (= (Connect.get CastaData vatr-lhtr)  -1)	(progn
	  (if (>= dv_AT 0.0) (progn
	    (BLech.set Blech_ID (xASym (- (+ (* -0.5 (+ t_AT dp)) dv_AT))))
	  ))
	  (if (< dv_AT 0.0) (progn
	    (BLech.set Blech_ID (xASym (- (+ (* 0.5 (+ t_AT dp)) dv_AT))))
	  ))
  ))

)
(defun calcBlechUndSchraubenGroesse ()
  (setq b_HT (Traeger.get HTrg b))
  (if (< b_HT (* 8 16)) 
    (progn	; Schraubengre M12
	(Lochbild.set lchbAtrgSteg (S_Bez "M12") (S_Guete "4.6") (e "0 0 0 0 0 0"))
	(Lochbild.set lchbAtrgSteg (e0 -35) (e1 50))
	(Blech.set bFahnenbl (hp (* 8 12)))
    )
    (progn	; Schraubengre M16
	(Lochbild.set lchbAtrgSteg (S_Bez "M16") (S_Guete "4.6") (e "0 0 0 0 0 0"))
	(Lochbild.set lchbAtrgSteg (e0 -30) (e1 60))
	(Blech.set bFahnenbl (hp (* 8 16)))
    )
  )

  (setq	dlr_AT (Traeger.get Tr_ID delta_LR)
	b_AT   (Traeger.get Tr_ID b)
	dv_HT  (Traeger.get HTrg delta_V)
  )

  (setq lb_Delta_LR    dlr_AT)
	(if (= (Connect.get CastaData at-von-rechts)  1) (setq dv_HT (- dv_HT)))
	(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
		(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq lb_Delta_LR (- lb_Delta_LR dv_HT)))
		(if (= (Connect.get CastaData vAtr-lHtr) -1) (setq lb_Delta_LR (+ lb_Delta_LR dv_HT)))
	))
	(if (= (Connect.get CastaData amHtOberflansch) 1) (progn
		(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq lb_Delta_LR (- lb_Delta_LR dv_HT)))
		(if (= (Connect.get CastaData vAtr-lHtr) -1) (setq lb_Delta_LR (+ lb_Delta_LR dv_HT)))
	))
  
  (if (< lb_Delta_LR 0) (setq lb_Delta_LR (- lb_Delta_LR)))
  (setq b_Blech (+ lb_Delta_LR (* 0.5 b_AT)))
  (Blech.set bFahnenbl (bp b_Blech))
  
  	   (showBlechDaten bFahnenbl)

  
(debug on)
  (if (= Doppelverbindung 0) (progn
  	(setq dv_AT  (Traeger.get Tr_ID delta_V)
  	      t_AT   (Traeger.get Tr_ID t)
  	)
  	(if (< dv_AT 0.0) (setq dv_AT (- dv_AT)))
  	(setq dp_Calc (* 2.0 (- dv_AT (* 0.5 t_AT))))
  	(if (<= dp_Calc 0) (setq dp_Calc 10))
  	(Blech.set bFahnenbl (dp dp_Calc))
;  	(Blech.set bFahnenbl (dp 10))
  ))
(debug off)

)

; ----------------------------------------------------------------------------------------
; Prft, die Position des AT in Bezug auf den HT
; ----------------------------------------------------------------------------------------
(defun checkPosition ()
	(print "------------------------------------------------------------")
	(print "BERPRFE AT POSITION")
	(print "------------------------------------------------------------")
	
	(setq	hc_ht		(Traeger.get Htrg hc)
		b_ht		(Traeger.get Htrg b)
		delta_v_ht	(Traeger.get Htrg delta_v)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(setq delta_lr_at	(Traeger.get Tr_ID delta_lr)
				s_at				(Traeger.get Tr_ID s)
	)
	
	; Standardmig wird angenommen, dass der AT angeschlossen werden kann.
	(setq isInside 1)
	
	; Wenn der Anschluss am HT-Steg erfolgt, wird geprft, ob sich der AT-Steg im HC-Bereich des HT befindet.
	(if (= (connect.get CastaData amHtSteg) 1) (setq isInside 1))
	
	; Wenn der Anschluss am HT-Flansch erfolgt, wird geprft, ob der AT-Steg noch am Flansch 
	; angeschlossen werden kann.
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			; linke und rechte Seite des HT-Fansches
			(setq flansch_ht_l (- delta_lr_ht (* 0.5 b_ht)))
			(setq flansch_ht_r (+ flansch_ht_l b_ht))
			(print flansch_ht_l)
			(print flansch_ht_r)
			(print delta_lr_at)
			
			(if (= (Connect.get CastaData satr-shtr) 1)
				(progn
					(if (> delta_lr_at flansch_ht_r)
						(progn
							(setq isInside 0)
						)
						(progn
							(if (< delta_lr_at flansch_ht_l)
								(setq isInside 0)
								(setq isInside 1)
							)
						)
					)
				)
			)
			(if (= (Connect.get CastaData satr-shtr) -1)
				(progn
					(if (> delta_lr_at (- flansch_ht_l))
						(progn
							(setq isInside 0)
						)
						(progn
							(if (< delta_lr_at (- flansch_ht_r))
								(setq isInside 0)
								(setq isInside 1)
							)
						)
					)
				)
			)
			
			(if (= isInside 0)
				(print "AUSSERHALB FLANSCH")
				(print "INNERHALB FLANSCH")
			)
		)
	)
)

; -------------------------------------------------------------------
(defun sucheFahnenBlech ()

  (setq DoppelVerbindung 0)

  (setq xPos_HT (Connect.get CastaData xPos_HT))
  (setq xPos_HT xPos_Blech)

  (setq gesFahBlTyp 0) ; auf unknown setzen
  (if (= (connect.get CastaData amHtOberFlansch)  1)  (setq gesFahBlTyp _fahnenblech_of_))
  (if (= (connect.get CastaData amHtUnterFlansch) 1)  (setq gesFahBlTyp _fahnenblech_uf_))
  (if (= (connect.get CastaData amHtStegLinks)    1)  (setq gesFahBlTyp _fahnenblech_steg_li_))
  (if (= (connect.get CastaData amHtStegRechts)   1)  (setq gesFahBlTyp _fahnenblech_steg_re_))

  (setq abtl_FahnBl (Traeger.get Htrg firstAbtl fahnenblech (- xPos_HT 0.5) (+ xPos_HT 0.5)))
  (while abtl_FahnBl
  	(setq sType     (Anbauteil.get abtl_FahnBl is_type gesFahBlTyp))
  	(if (= sType 1) (progn
	    (print "Fahnenblech gefunden -----------------------------------------------------")
	    (print sType)

	    (showAbtlDaten abtl_FahnBl)	;; nur zu Entwicklungszwecken

	    (setq abtl_FahnBl_Vorhanden abtl_FahnBl)
	    (setq bFahnenbl (Anbauteil.get abtl_FahnBl Objekt Blech))
	    (setq xPosVorh (Anbauteil.get abtl_FahnBl xPos))
	    (setq DoppelVerbindung 1)
	))
  	(setq abtl_FahnBl (Traeger.get Htrg nextAbtl fahnenblech))
  )
  (setq abtl_FahnBl_T (Traeger.get Htrg firstAbtl fahnenblech (- xPos_HT 0.1) (+ xPos_HT 0.1)))
  (if (existObj FahnenBlech) (progn
	  (if (existObj abtl_FahnBl_T)
	      (print  "OK - Objekt gefunden und passt");
	      (alertBox "Das Blech wurde mit einer greren Toleranz eingesetzt!\nBitte die Schraubenlngen nach nderung der Blechdicke berprfen!" "NOTE_PlateThickness_BoltLength");
	  )
  ))

  (if (= (connect.get CastaData amHtOberFlansch)  1)  (setq gesFahLbTyp (+ _fahnbllochbild_ _oberflansch_)))
  (if (= (connect.get CastaData amHtUnterFlansch) 1)  (setq gesFahLbTyp (+ _fahnbllochbild_ _unterflansch_)))
  (setq TestTyp (+ _fahnbllochbild_ _unterflansch_))
  (setq abtl_FahnBlLchb (Traeger.get Htrg firstAbtl lochbild (- xPos_HT 0.5) (+ xPos_HT 0.5)))
  (while abtl_FahnBlLchb
  	(setq sType     (Anbauteil.get abtl_FahnBlLchb is_type gesFahLbTyp))
  	(if (= sType 1) (progn
  	    (setq abtl_FahnBlLchb_Vorhanden abtl_FahnBlLchb)
	    (setq lchbAtrgSteg (Anbauteil.get abtl_FahnBlLchb Objekt Lochbild))
  	))
  	(setq abtl_FahnBlLchb (Traeger.get Htrg nextAbtl lochbild))
  )
)

; ----------------------------------------------------------
(defun calcXPosFahnenBlech ()
  (setq AT_WnklSteg (Connect.get CastaData v-atrgewnkl_steg))
		
	; Anschlsse am Flansch des Haupttrgers
  (if (= (Connect.get CastaData amHtOberflansch) 1) 	(progn
	(print "ADDABTL - Fahnenblech an HT (amHtOberflansch)")
	(setq rWinkel AT_WnklSteg)
  	(if (= (Connect.get CastaData amAtStegLinks) 1) (setq rWinkel (- 180.0 AT_WnklSteg)))
  ))
  (if (= (Connect.get CastaData amHtUnterflansch) 1) 	(progn
	(print "ADDABTL - Fahnenblech an HT (amHtUnterflansch)")
	(setq rWinkel AT_WnklSteg)
  	(if (= (Connect.get CastaData amAtStegRechts) 1) (setq rWinkel (- 180.0 AT_WnklSteg)))
  ))

  (setq	XPos_HT	(Connect.get CastaData XPos_HT))
  (setq tanBeta (tan (/ (* PI (- rWinkel 90.0)) 180.0)))
  (setq dlr_HT (Traeger.get HTrg delta_LR))
  (setq dl_Hor (* tanBeta dlr_HT))
  (setq xPos_Blech (+ XPos_HT dl_Hor))

)

(defun calc_doppV_Schrauben ()
	(setq	xPos_at	(Connect.get CastaData xPos_AT))
	(if (= (Connect.get CastaData amHtUnterflansch) 1) 	(setq Flansch_LB _flanschlochbild_uf_))
	(if (= (Connect.get CastaData amHtOberflansch)  1) 	(setq Flansch_LB _flanschlochbild_of_))
	(Traeger.addabtl Tr_ID lchbAtrgSteg xPos_at 0.0 Flansch_LB)
	(setq abtl_Lchb (Traeger.get Tr_ID ABTeil lchbAtrgSteg))
	(Anbauteil.set abtl_Lchb (Master 0))
	
	(setq	t_AT 	(Traeger.get Tr_ID t)
		dv_AT	(Traeger.get Tr_ID delta_V)
	)
	(setq	dxSKopf_vorh (Lochbild.get lchbAtrgSteg dxSKopf)
		KlemmL_vorh  (Lochbild.get lchbAtrgSteg KlemmL)
	)
	(setq dxSKopf_Neu     dxSKopf_vorh)
	(if (< dv_AT 0.0) (setq dxSKopf_Neu  (+ dxSKopf_vorh t_AT)))
	(Lochbild.set lchbAtrgSteg 	(dxSKopf dxSKopf_Neu)
					(KlemmL  (+ KlemmL_vorh t_AT))
	)

)
