; $	HT	QT(IUL)		AF(FS)		P(EZ)
; $ 	AT	QT(F)		AF(SK)		P(E)
; $	AE	V(-)		H(-)		R(-)

(defun load-modules ()

;        (print "*clear*")

	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			; (print "am HT-Oberflansch")
			(load "mod-endinit-uz-an-flachstahl.lsp")
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			; (print "am HT-Unterflansch")
			(load "mod-endinit-uz-an-flachstahl.lsp")
		) 
	)
        (load "mod-lochbild")
)




(defun init-connection_1 ()
	(print "*clear*")
	(print_Parameter)
)

(defun init-connection ()

	(print "*clear*")
	(print_Parameter)
	
	(setq LB_DEBUG 0)
	
	
	(checkPosition)		; berechnet MakeConnection

	(if (= (Connect.get CastaData amHtOberflansch) 0) (progn
		(AlertBox "von dieser Seite ist der Anschluss derzeit nicht mglich." "ERR_WrongSideConnect")
		(setq MakeConnection 0)
	))


	(if (= MakeConnection 1)
	    (progn
		(print "in init-connection uz_an_Flachstahl mit Fahne .........................")
		(if (= (Connect.get CastaData amHtSteg) 1)
			(alertBox "Anschluss an der schmalen Kante ist nicht mglich!"  "ERR_SlimRimConnection")
		)
;		(if (= (Connect.get CastaData amHtFlansch) 1)
			; (init-traegerenden)	; hier werden die Traegerenden gestutzt
;		)
  		(setConnection)	
  
  		(print bFahnenbl)

		(setq dOK_Blech (Blech.get bFahnenbl dOK))
		(print " ......... am Ende der Makro-Ausfhrung...")
		(print dOK_Blech)
		
;		(setq abtl_Lchb_Htrg (Traeger.get HTrg ABTeil lchbAtrgSteg))
;		(Anbauteil.set abtl_Lchb_Htrg (delta_V 0))

;		(print "Anbauteil-Delta_V")
;		(setq abtl_DV (Anbauteil.get abtl_Fahne delta_v))
;		(print abtl_DV)
		; (Lochbild.set lchbAtrgSteg (e "0 15 75   0 0 0"))
		; (setq w0 (Lochbild.get lchbAtrgSteg w0))
		; (Lochbild.set lchbAtrgSteg (w1 (+ w0 20)))

  	    )
  	    (progn
			(alertBox "Anschluss ist nicht mglich!" "Connection_Not_Possible")
  	    )
	)

;	(connect.showattributes CastaData)
  
    
)


(defun setConnection ()
	
	(setq S_Bez "M16")
	
	(setq bFahnenbl		(Blech.create))
	(setq lchbAtrgSteg	(Lochbild.create))
	(Connect.storeAnschlObjs CastaData bFahnenbl lchbAtrgSteg)
	(print "Fahnenblech erzeugt")
  
	(Blech.set bFahnenbl (dp 10) (hp 200) (bp 110) (dOK 0))
	(print "Default Blechdaten")
  
	(setq	XPos 	(Connect.get CastaData XPos_HT)
  		xPos_at	(Connect.get CastaData xPos_AT)
  	)
  	(print XPos)
  
  	(setq abstzumSteg 10)

  ; Fahnenblechdaten Berechnen
  	(calcBlechUndSchraubenGroesse)
  ; Fahnenblech hinzufgen
	(setFahnenBlechAnbauteil bFahnenbl)
  ; Lochbildposition berechnen	
	(calcLochbildPosition)
  ; AT-Trgerende anpassen
	(calc_AT_EndLaenge)
  ; Blech bei schrgem Anschluss schieben
  	(schiebeBlech)
	
	(Blech.set bFahnenbl (FormFkt "cb_bFahnenbl"))
)

(defun	calcLochbildPosition ()
	; Lochbild HT
	(print "ADDABTL - Fahnenblechlochbild in HT")
	(setq AbtlFahnenBl	(Traeger.get Htrg AbTeil bFahnenbl))
	(Traeger.addabtl Htrg lchbAtrgSteg XPos 0.0 _fahnblLochbild_ AbtlFahnenBl)


	; Lochbild AT
	(if (= (Connect.get CastaData amHtUnterflansch) 1) 	(setq Flansch_LB _flanschlochbild_uf_))
	(if (= (Connect.get CastaData amHtOberflansch)  1) 	(setq Flansch_LB _flanschlochbild_of_))
	(Traeger.addabtl Tr_ID lchbAtrgSteg xPos_at 0.0 Flansch_LB)

	(setq Abtl_LB_HT (Traeger.get HTrg  ABTeil lchbAtrgSteg))
	(setq Abtl_LB_AT (Traeger.get Tr_ID ABTeil lchbAtrgSteg))
	(Anbauteil.set Abtl_LB_HT (Master 1))
	(Anbauteil.set Abtl_LB_AT (Master 0))
	
	(setq	dlr_AT (Traeger.get Tr_ID delta_LR)
		b_AT   (Traeger.get Tr_ID b)
		dv_HT  (Traeger.get HTrg delta_V)
	)

	; Schraubenabstand wird aus Blechgre berechnet, also, zuerst die Blechgre
	; berechnen. Dadurch werden die Fallunterscheidungen vermieden.
	(setq  w0_LB 0)
	(setq	b_AT		(Traeger.get	Tr_ID b)
		s_HT		(Traeger.get	HTrg  s)
		q_Typ_HT	(Traeger.get	HTrg  qsForm)
		bp		(Blech.get	bFahnenbl bp)
		dp		(Blech.get	bFahnenbl dp)
	)
	(setq  w0_LB (- bp (* 0.5 b_AT)))

	(setq  wFaktor 0.5)
	(if (= q_Typ_HT "U") (setq  wFaktor 1.0))
	(if (= q_Typ_HT "L") (setq  wFaktor 1.0))
	
	(if (= linke_HT_Seite 1) (progn
		(if (= q_Typ_HT "U") (setq  wFaktor 0.0))
		(if (= q_Typ_HT "L") (setq  wFaktor 0.0))
	))
	(setq  w0_LB (- w0_LB (* wFaktor s_HT)))
	

	; lokale Lochbildverschieben im AT  ............. seitlich
	(Anbauteil.set Abtl_LB_AT (delta_LR w0_LB))

	(setq SRicht 1)
	(if (= rechte_HT_Seite 1) (if (= (Connect.get CastaData satr-shtr)  1) (setq SRicht -1)))
	(if (= linke_HT_Seite  1) (if (= (Connect.get CastaData satr-shtr) -1) (setq SRicht -1)))
;	(if (= (Connect.get CastaData at-von-hinten)  1) (setq SRicht (- SRicht)))
	(if (= (Connect.get CastaData at-von-oben)  1) (progn
		(setq SRicht (- SRicht))
	))
	(if (= (Connect.get CastaData at-von-unten)  1) (progn
		(if (= (Connect.get CastaData at-von-vorne)  1) (progn
			(setq SRicht (- SRicht))
		))
	))
	(if (= SRicht -1) (progn
		(Anbauteil.set Abtl_LB_AT (SeitRicht -1))
		(Anbauteil.set Abtl_LB_AT (delta_LR (- w0_LB)))
	))

	; Schraubenanordnung lngs
	(setze_DXSKopf)
	
	(Lochbild.set lchbAtrgSteg (KlemmL (+ t_AT dp)))
	(if (= (Connect.get CastaData amHtUnterflansch) 1) (Lochbild.set lchbAtrgSteg (LB_Art -2) (w0 w0_LB)))
	(if (= (Connect.get CastaData amHtOberflansch)  1) (Lochbild.set lchbAtrgSteg (LB_Art -2) (w0 w0_LB)))

	; (Lochbild.set lchbAtrgSteg (w0 0) (e "0 15 60 0 0 0"))	; zum Testen - wieder entfernen
	; (Lochbild.set lchbAtrgSteg (w1 100)) 				; zum Testen - wieder entfernen

	(setq abtl_bl_Ht (Traeger.get HTrg AbTeil bFahnenbl))
	(setq blWinkel (Anbauteil.get abtl_bl_Ht Winkel))
	(setq cosBeta (cos (/ (* PI (- blWinkel 90.0)) 180.0)))

	(setq 	dv_HT	(Traeger.get HTrg delta_V))
	
	  (if (= (Connect.get CastaData amhtunterflansch )  1) (progn
		(setq 	dv_HT	(- dv_HT))
;	      (setq rWnk_Lchb (Anbauteil.get Abtl_LB_AT Winkel))
;	      (setq rWnk_Lchb (+ rWnk_Lchb 180.0))
;	      (Anbauteil.set Abtl_LB_AT (Winkel rWnk_Lchb))
	  ))

	
	(setq	dv_HT	(/ dv_HT cosBeta))
	(if (= (Connect.get CastaData LinkesEnde) 1) (progn
	    (setq dv_Lb 0.0)
	    (if (= (Connect.get CastaData at-von-unten)  1) (setq dv_Lb  (+ dv_Lb dv_HT)))
	    (if (= (Connect.get CastaData at-von-oben)   1) (setq dv_Lb  (- dv_Lb dv_HT)))
	    (Anbauteil.set Abtl_LB_AT (delta_V dv_Lb))
	))
	(if (= (Connect.get CastaData RechtesEnde) 1) (progn
	    (setq dv_Lb 0.0)
	    (if (= (Connect.get CastaData at-von-unten)  1) (setq dv_Lb (+ dv_Lb dv_HT)))
	    (if (= (Connect.get CastaData at-von-oben)   1) (setq dv_Lb (- dv_Lb dv_HT)))

	    (Anbauteil.set Abtl_LB_AT (delta_V (- dv_Lb)))
	))

; - satr-shtr = 1
; - vatr-lhtr = 1
; - at-von-unten = 1
; - at-von-vorne = 1
	(if (= (Connect.get CastaData at-von-vorne) 0) (progn
	  (if (= (Connect.get CastaData at-von-hinten) 0) (progn
	    (if (= (Connect.get CastaData at-von-unten) 1) (progn
	      (setq rWnk_Lchb (Anbauteil.get Abtl_LB_AT Winkel))
	      (setq rWnk_Lchb (+ rWnk_Lchb 180.0))
	      (Anbauteil.set Abtl_LB_AT (Winkel rWnk_Lchb))
	    ))
	  ))
	))

   (if (= 1 2) (progn
	(if (= (Connect.get CastaData at-von-oben) 1) (progn
	  (if (= (Connect.get CastaData at-von-vorne) 1) (progn
;	    (if (= (Connect.get CastaData at-von-unten) 1) (progn
	      (setq rWnk_Lchb (Anbauteil.get Abtl_LB_AT Winkel))
	      (setq rWnk_Lchb (+ rWnk_Lchb 180.0))
	      (Anbauteil.set Abtl_LB_AT (Winkel rWnk_Lchb))
;	    ))
	  ))
	))
    ))




)
(defun calc_AT_EndLaenge ()

 	 (setq abtl_lb_Ht (Traeger.get HTrg AbTeil lchbAtrgSteg))
 	 (setq abtl_bl_Ht (Traeger.get HTrg AbTeil bFahnenbl))
 	 (setq blWinkel (Anbauteil.get abtl_bl_Ht Winkel))
 	 (setq cosBeta (cos (/ (* PI (- blWinkel 90.0)) 180.0)))

	(setq 	hp 		(Blech.get bFahnenbl hp))
	(setq 	dv_HT		(Traeger.get HTrg delta_V))
	(setq	qsform_HT	(Traeger.get HTrg qsform))

	(setq   dv_HT  (/ dv_HT cosBeta))

	(if (= (Connect.get CastaData LinkesEnde) 1) (progn
	    (setq TrgEnde (Traeger.get Tr_ID links))
	    (setq dl_Neu (* -0.5 hp))
	    (if (= qsform_HT "L") (setq dl_Neu 0.0))
	    (if (= (Connect.get CastaData at-von-oben) 1) (setq dl_Neu (- dl_Neu dv_HT)))
	    (if (= (Connect.get CastaData at-von-unten)  1) (setq dl_Neu (+ dl_Neu dv_HT)))
	    (TrEnde.set TrgEnde (delta_L dl_Neu))
	))
	(if (= (Connect.get CastaData RechtesEnde) 1) (progn
	    (setq TrgEnde (Traeger.get Tr_ID rechts))
	    (setq dl_Neu (* -0.5 hp))
	    (if (= qsform_HT "L") (setq dl_Neu 0.0))
	    (if (= (Connect.get CastaData at-von-unten) 1) (setq dl_Neu (+ dl_Neu dv_HT)))
	    (if (= (Connect.get CastaData at-von-oben)  1) (setq dl_Neu (- dl_Neu dv_HT)))
	    (TrEnde.set TrgEnde (delta_L dl_Neu))
	))

)

; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Fahne am HT
; ----------------------------------------------------------------------------------------
(defun cb_bFahnenbl (zp)
	(print "in Callback-Funktion cb_bFahnenbl")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt 	(Blech.get bFahnenbl dp))
	    (setq hpAlt 	(Blech.get bFahnenbl hp))
	    (setq dokAlt 	(Blech.get bFahnenbl dok))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
		(setq dpNeu (Blech.get bFahnenbl dp))
		(setq hpNeu (Blech.get bFahnenbl hp))
		(setq dokNeu (Blech.get bFahnenbl dok))
		
		(print dpAlt) (print dpNeu)
		(print hpAlt) (print hpNeu)
		(print dokAlt) (print dokNeu)
		(print "--------------------------------------")
		
		; nderung der Blechdicke
		(if (/= dpAlt dpNeu) (progn
			(setq dpDiff (- dpNeu dpAlt))
(if (= 1 2) (progn
			
			(setq qsform_at	(Traeger.get Tr_ID qsform))
			
			(setq alteKlemml 	(Lochbild.get lchbAtrgSteg Klemml)
						dxs_alt			(Lochbild.get lchbAtrgSteg dxskopf)
			)
			
			(setq delta_lr_blech_alt (Blech.get bFahnenbl delta_lr))
			(print delta_lr_blech_alt)
			
			(setq klemml_neu	(+ alteKlemml dpDiff))
			
			(setq dxs_neu (+ dxs_alt (* 0.5 dpDiff)))
			
			(if (= qsform_at "I")
				(setq delta_lr_blech_neu (+ delta_lr_blech_alt (* 0.5 dpDiff)))
			)
			(setq U_oder_L 0)
			(if (= qsform_at "U") (setq U_oder_L 1))
			(if (= qsform_at "L") (setq U_oder_L 1))
			
			(if (=  U_oder_L  1)
				(progn
					
					(if (= (Connect.get CastaData amHtSteg) 1)
						(progn
							(if (= (Connect.get CastaData satr-vhtr)  1)	
								(setq delta_lr_blech_neu (+ delta_lr_blech_alt (* 0.5 dpDiff)))
							)
							(if (= (Connect.get CastaData satr-vhtr) -1)	
								(setq delta_lr_blech_neu (- delta_lr_blech_alt (* 0.5 dpDiff)))
							)
						)
					)
						(if (= (Connect.get CastaData amHtFlansch) 1)
						(progn
							(if (= (Connect.get CastaData satr-shtr)  1)	
								(setq delta_lr_blech_neu (+ delta_lr_blech_alt (* 0.5 dpDiff)))
							)
							(if (= (Connect.get CastaData satr-shtr) -1)	
								(setq delta_lr_blech_neu (- delta_lr_blech_alt (* 0.5 dpDiff)))
							)
						)
					)
					
				)
			)
			
			(print delta_lr_blech_neu)		  	
			
			(Blech.set bFahnenbl (delta_lr delta_lr_blech_neu))
			              
			(Lochbild.set lchbAtrgSteg 	(klemml klemml_neu))    
			
			
			(setq abtl_lb_ht (Traeger.get Htrg AbTeil lchbAtrgSteg))
		  
		  (setq delta_sx_abtl_ht_neu delta_lr_blech_neu )
						
			(Anbauteil.set abtl_lb_ht (delta_sx delta_sx_abtl_ht_neu))
			
))			

			(setq xAsym_vorh (Blech.get  bFahnenbl	xAsym))
			(setq xAsym_neu  (+ xAsym_vorh (* 0.5 dpDiff)))
		  	(if (= (Connect.get CastaData     vatr-lhtr)     1) (progn
		  	  (if (= (Connect.get CastaData   at-von-oben)   1) (progn
		  	    (if (= (Connect.get CastaData at-von-hinten) 1) (setq xAsym_neu  (- xAsym_vorh (* 0.5 dpDiff))))
		  	  ))
		  	  (if (= (Connect.get CastaData   at-von-unten)  1) (progn
		  	    (if (= (Connect.get CastaData at-von-vorne)  1) (setq xAsym_neu  (- xAsym_vorh (* 0.5 dpDiff))))
		  	  ))
		  	))
		  	(if (= (Connect.get CastaData     vatr-lhtr)    -1) (progn
		  	  (if (= (Connect.get CastaData   at-von-oben)   1) (progn
		  	    (if (= (Connect.get CastaData at-von-vorne)  1) (setq xAsym_neu  (- xAsym_vorh (* 0.5 dpDiff))))
		  	  ))
		  	  (if (= (Connect.get CastaData   at-von-unten)  1) (progn
		  	    (if (= (Connect.get CastaData at-von-hinten) 1) (setq xAsym_neu  (- xAsym_vorh (* 0.5 dpDiff))))
		  	  ))
		  	))
			
			(setq	t_at 	(Traeger.get Tr_ID t)
				dp	(Blech.get bFahnenbl dp)
				klemml_neu (+ t_at dp)
			)
			(Lochbild.set lchbAtrgSteg 	(klemml klemml_neu))    

			
			(Blech.set  bFahnenbl	(xAsym xAsym_neu))
;			(schiebeBlech)
			(setze_DXSKopf)
			(setq dxS (Lochbild.get lchbAtrgSteg dxSKopf))
			(Lochbild.set lchbAtrgSteg (dxSKopf (+ dxS (- xAsym_vorh xAsym_neu ))))

		))
		    
				
		(if (= 1 2)	(progn		
		; nderung der Blechhhe
		(if (/= hpAlt hpNeu) (progn
		  (setq hpDiff (- hpNeu hpAlt))
		  
		  (setq abtl_lb_at (Traeger.get Tr_ID AbTeil lchbAtrgSteg))
		  (setq delta_v_abtl_at_alt (Anbauteil.get abtl_lb_at delta_v))
		  (print delta_v_abtl_at_alt)
		  
			(if (= (Connect.get CastaData vatr-lhtr) -1) (setq delta_v_abtl_at_neu (- delta_v_abtl_at_alt (* 0.5 hpDiff))))
			(if (= (Connect.get CastaData vatr-lhtr)  1) (setq delta_v_abtl_at_neu (+ delta_v_abtl_at_alt (* 0.5 hpDiff))))
			(print delta_v_abtl_at_neu)
			
			(Anbauteil.set abtl_lb_at (delta_v delta_v_abtl_at_neu))
		))
		
		; Verschiebung des Bleches in HT-Lngsrichtung
		(if (/= dokAlt dokNeu) (progn
		  (setq dokDiff (- dokNeu dokAlt))
		  (print dokDiff)
		  
		  (setq abtl_lb_at (Traeger.get Tr_ID AbTeil lchbAtrgSteg))
		  (setq delta_v_abtl_at_alt (Anbauteil.get abtl_lb_at delta_v))
		  (print delta_v_abtl_at_alt)
		  
		  (if (= (Connect.get CastaData vatr-lhtr) -1) (setq delta_v_abtl_at_neu (+ delta_v_abtl_at_alt dokDiff)))
		  (if (= (Connect.get CastaData vatr-lhtr)  1) (setq delta_v_abtl_at_neu (- delta_v_abtl_at_alt dokDiff)))
		  (print delta_v_abtl_at_neu)

		  (Anbauteil.set abtl_lb_at (delta_v delta_v_abtl_at_neu))
		))
	))
	))
)



; ------------------------------------------------------------------------
; Setzt das Fahnenblech-Anbauteil
; ------------------------------------------------------------------------
(defun setFahnenBlechAnbauteil (Blech_ID)
	
  (setq XPos 		(Connect.get CastaData XPos_HT))
	
  (setq delta_v_at (Traeger.get Tr_ID delta_v))

;(debug on)	
  (setq rWinkel 90.0)						; Initialisieren ....
;  (if (= (Connect.get CastaData at-von-vorne) 0) (progn
;  (if (= (Connect.get CastaData at-von-hinten) 0) (progn
;      (if (= (Connect.get CastaData at-von-unten) 1) (setq rWinkel -90.0))
;  ))
;  ))

  (setq AT_WnklZu_HT (Connect.get CastaData v-atrgewnkl_kopf))
  
  (connect.showAttributes CastaData)
  (if (= (Connect.get CastaData amhtunterflansch )  1) (progn
  	(setq AT_WnklZu_HT (- AT_WnklZu_HT))
  ))
  
   (if (= (Connect.get CastaData at-von-unten)  1) (progn
     (if (= (Connect.get CastaData at-von-vorne) 1) (progn
	   (if (= (Connect.get CastaData satr-shtr) -1)  (setq rWinkel (- 90.0 AT_WnklZu_HT)))
	   (if (= (Connect.get CastaData satr-shtr)  1)  (setq rWinkel (- AT_WnklZu_HT 90.0)))
	   (setq rWinkel (+ rWinkel 180.0))
     ))
     (if (= (Connect.get CastaData at-von-hinten) 1) (progn
	   (if (= (Connect.get CastaData satr-shtr)  1)  (setq rWinkel (- 90.0 AT_WnklZu_HT)))
	   (if (= (Connect.get CastaData satr-shtr) -1)  (setq rWinkel (- AT_WnklZu_HT 90.0)))
     ))
   ))

   (if (= (Connect.get CastaData at-von-oben)  1) (progn
     (if (= (Connect.get CastaData at-von-hinten) 1) (progn
	   (if (= (Connect.get CastaData satr-shtr) -1)  (setq rWinkel (- 90.0 AT_WnklZu_HT)))
	   (if (= (Connect.get CastaData satr-shtr)  1)  (setq rWinkel (- AT_WnklZu_HT 90.0)))
     ))
     (if (= (Connect.get CastaData at-von-vorne) 1) (progn
	   (if (= (Connect.get CastaData satr-shtr)  1)  (setq rWinkel (- 90.0 AT_WnklZu_HT)))
	   (if (= (Connect.get CastaData satr-shtr) -1)  (setq rWinkel (- AT_WnklZu_HT 90.0)))
	   (setq rWinkel (+ rWinkel 180.0))
     ))
   ))
   
;(debug off)
	; Anschlsse am Steg des Haupttrgers
  (if (= linke_HT_Seite 1) (progn
	(print "ADDABTL - Fahnenblech an HT linke Seite")
;  	(if (= (Connect.get CastaData amAtStegLinks) 1) (setq rWinkel (- 180.0 AT_WnklSteg)))
  	(traeger.addabtl hTrg Blech_ID XPos rWinkel _fahnenblech_steg_li_)
  ))
  (if (= rechte_HT_Seite 1) (progn
	(print "ADDABTL - Fahnenblech an HT rechte Seite")
;  	(if (= (Connect.get CastaData amAtStegRechts) 1) (setq rWinkel (- 180.0 AT_WnklSteg)))
  	(traeger.addabtl hTrg Blech_ID XPos rWinkel _fahnenblech_steg_re_)
  ))
  
  ; Anteil delta_v AT
  (setq delta_v_abtl_fb 0)
  
  (if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_abtl_fb (- delta_v_abtl_fb delta_v_at)))
  (if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_abtl_fb (+ delta_v_abtl_fb delta_v_at)))
	
  
  (setq abtl_fahne (Traeger.get Htrg AbTeil Blech_ID))
  
  (Anbauteil.set abtl_fahne (delta_v delta_v_abtl_fb))
  ;; wird jetzt einfach 0 eingesetzt ...
  (Anbauteil.set abtl_fahne (delta_v 0.0))
  
  (setq	t_AT	(Traeger.get 	Tr_ID 		t)
  	dv_AT	(Traeger.get 	Tr_ID 		delta_V)
	dp	(Blech.get 	Blech_ID	dp)
  )
  (if (= rechte_HT_Seite 1) (if (= (Connect.get CastaData at-von-oben)  1) (setq dv_AT (- dv_AT))))
  (if (= linke_HT_Seite  1) (if (= (Connect.get CastaData at-von-oben)   1) (setq dv_AT (- dv_AT))))

  (if (>= dv_AT 0.0) (progn
    (BLech.set Blech_ID (xASym (+ (* -0.5 (+ t_AT dp)) dv_AT)))
  ))
  (if (< dv_AT 0.0) (progn
    (BLech.set Blech_ID (xASym (+ (* 0.5 (+ t_AT dp)) dv_AT)))
  ))
  (if (= (Connect.get CastaData vatr-lhtr)  -1)	(progn
	  (if (>= dv_AT 0.0) (progn
	    (BLech.set Blech_ID (xASym (- (+ (* -0.5 (+ t_AT dp)) dv_AT))))
	  ))
	  (if (< dv_AT 0.0) (progn
	    (BLech.set Blech_ID (xASym (- (+ (* 0.5 (+ t_AT dp)) dv_AT))))
	  ))
  ))
  (if (= (Connect.get CastaData at-von-hinten)  1) (progn
  	(setq bl_XAsym (Blech.get Blech_ID xASym))
	(Blech.set Blech_ID (xASym (- bl_XAsym)))
  ))
  (if (= (Connect.get CastaData at-von-oben)  1) (progn
  	(setq bl_XAsym (Blech.get Blech_ID xASym))
	(Blech.set Blech_ID (xASym (- bl_XAsym)))
  ))

  (setq qsForm_HT (Traeger.get HTrg qsForm))
  (if (= qsForm_HT "L") (progn
     (setq hp 	(Blech.get bFahnenbl hp)
           dOK  (Blech.get bFahnenbl dOK)
           h_HT (Traeger.get HTrg h)
           t_HT (Traeger.get HTrg t)
     )

     (if (= rechte_HT_Seite 1) (progn
        (setq dOK (- (- (* 0.5 h_HT)) t_HT))
        (setq dOK_neu dOK)
        (if (= (Connect.get CastaData at-von-unten)  1) (setq dOK_neu (- dOK)))
     ))

     (if (= linke_HT_Seite 1) (progn
        (setq dOK_neu (- dOK (* 0.5 h_HT)))
        (if (= (Connect.get CastaData at-von-unten)  1)      (setq dOK_neu (+ dOK (* 0.5 h_HT))))
     ))

     (Blech.set  bFahnenbl (dOK dOK_neu))
     (Lochbild.set lchbAtrgSteg (dOK dOK_neu))
  ))

)
; ------------------------------------------------------------------------------------
(defun calcBlechUndSchraubenGroesse ()
  (setq b_HT (Traeger.get HTrg b))
  (if (< b_HT (* 8 16)) 
    (progn	; Schraubengre M12
	(Lochbild.set lchbAtrgSteg (S_Bez "M12") (S_Guete "4.6") (e "0 0 0 0 0 0"))
	(Lochbild.set lchbAtrgSteg (e0 -35) (e1 50))
	(Blech.set bFahnenbl (hp (* 8 12)))
    )
    (progn	; Schraubengre M16
	(Lochbild.set lchbAtrgSteg (S_Bez "M16") (S_Guete "4.6") (e "0 0 0 0 0 0"))
	(Lochbild.set lchbAtrgSteg (e0 -30) (e1 60))
	(Blech.set bFahnenbl (hp (* 8 16)))
    )
  )

  (setq	dlr_AT	(Traeger.get Tr_ID delta_LR)
	b_AT	(Traeger.get Tr_ID b)
	dv_HT	(Traeger.get HTrg delta_V)
	h_HT	(Traeger.get HTrg h)
	t_HT	(Traeger.get HTrg t)
  )

  (setq		b_ht		(Traeger.get Htrg b)
		qsForm_HT	(Traeger.get HTrg qsForm)
  )
  (setq		b_AT		(Traeger.get Tr_ID b))
  
  (setq b_Blech (* 0.5 b_ht))		; Erst einmal vom I-Trger ausgehen
  
  (setq U_oder_L 0)
  (if (= qsForm_HT "U") (setq U_oder_L 1))
  (if (= qsForm_HT "L") (setq U_oder_L 1))
			
  (if (=  U_oder_L  1) (progn		; dann schauen, ob es ein U- oder L-Profil ist
  	(if (= rechte_HT_Seite 1) (setq b_Blech (* 1.0 b_ht)))
  	(if (= linke_HT_Seite  1) (setq b_Blech 0))

  	(if (= rechte_HT_Seite 1) (progn
  		(Blech.set bFahnenbl (hp (- h_HT (* 2.0 t_HT) 10)))
  		(setq 	e0	(Lochbild.get lchbAtrgSteg e0)
  			e1	(Lochbild.get lchbAtrgSteg e1)
  		)
		(Lochbild.set lchbAtrgSteg (e0 (+ e0 t_HT)) (e1 (- e1 t_HT t_HT)))
  	))
  ))

  (if (= qsForm_HT "I") (progn
		(Blech.set bFahnenbl (hp (- h_HT (* 2.0 t_HT) 10)))
  		(setq 	e0	(Lochbild.get lchbAtrgSteg e0)
  			e1	(Lochbild.get lchbAtrgSteg e1)
  		)
		(Lochbild.set lchbAtrgSteg (e0 (+ e0 t_HT)) (e1 (- e1 t_HT t_HT)))
  ))

  
  (setq b_Blech (+ b_Blech b_AT LichterAbstand))
  

  (Blech.set bFahnenbl (bp b_Blech))
  
  (setq	sd	(Lochbild.get lchbAtrgSteg sdurchm))
  (setq hp	(Blech.get bFahnenbl hp))
  
  (if (> hp (* 10 sd)) (progn
  	(setq hp (* 10 sd))
  	(Blech.set bFahnenbl (hp hp))
  ))
  
  (setq		e0	(- (* 0.5 hp))
  		e1	hp
  )
  (Lochbild.set lchbAtrgSteg (e0 (+ e0 (* 2 sd))) (e1 (- e1 (* 4 sd))))

)

; ----------------------------------------------------------------------------------------
; Prft, die Position des AT in Bezug auf den HT
; ----------------------------------------------------------------------------------------
(defun checkPosition ()
	(print "------------------------------------------------------------")
	(print "BERPRFE AT POSITION")
	(print "------------------------------------------------------------")
	
	; global initialisieren - damit es nicht in einen Fehler hineinluft, falls kein Fall zutrifft.
	(setq LichterAbstand   0.0)
	(setq SchraubenAbstand 0.0)
	(setq rechte_HT_Seite  0)
	(setq linke_HT_Seite   0)
	; Standardmig wird angenommen, dass der AT nicht angeschlossen werden kann.

	
	(setq	hc_ht		(Traeger.get Htrg hc)
		b_ht		(Traeger.get Htrg b)
		delta_v_ht	(Traeger.get Htrg delta_v)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
		qsForm_HT	(Traeger.get HTrg qsForm)
	)
	
	(setq	delta_lr_at	(Traeger.get Tr_ID delta_lr)
		s_at		(Traeger.get Tr_ID s)
		b_at		(Traeger.get Tr_ID b)
	)
	

	(setq 	MakeConnection  0)


	; Wenn der Anschluss am HT-Steg erfolgt, wird geprft, ob sich der AT-Steg im HC-Bereich des HT befindet.
	; Wenn der Anschluss am HT-Flansch erfolgt, wird geprft, ob der AT-Steg noch am Flansch 
	; angeschlossen werden kann.
	(if (= (Connect.get CastaData amHtFlansch) 1) (progn
		; linke und rechte Seite des HT-Fansches
		(setq flansch_ht_l (* -0.5 b_ht))
		(if (= qsForm_HT "U") (setq flansch_ht_l 0.0))
		(if (= qsForm_HT "L") (setq flansch_ht_l 0.0))
		(setq flansch_ht_l (+ flansch_ht_l delta_lr_ht))
		
		(setq flansch_ht_r (+ flansch_ht_l b_ht))   ; delta_LR schon bercksichtigt in erstem Wert
		(print flansch_ht_l)
		(print flansch_ht_r)
		(print delta_lr_at)

		(if (= (Connect.get CastaData satr-shtr) 1) (progn
			(setq flansch_AT_l (- delta_lr_at (* 0.5 b_AT)))
			(setq flansch_AT_r (+ flansch_AT_l b_AT))
			

			(if (>=   flansch_AT_l  flansch_HT_r) (setq LichterAbstand 
					(- flansch_AT_l flansch_HT_r)
					MakeConnection  1
					rechte_HT_Seite 1
			))
			(if (<=   flansch_AT_r  flansch_HT_l) (setq 
					LichterAbstand (- flansch_HT_l flansch_AT_r)
					MakeConnection  1
					linke_HT_Seite  1
			))

		))
		(if (= (Connect.get CastaData satr-shtr) -1) (progn
			(setq flansch_AT_l (- (+ delta_lr_at (* 0.5 b_AT))))
			(setq flansch_AT_r    (+ flansch_AT_l b_AT))


			(if (>=  flansch_AT_l flansch_HT_r) (setq 
					LichterAbstand (- flansch_AT_l flansch_HT_r)
					MakeConnection  1
					rechte_HT_Seite 1
			))
			(if (<=  flansch_AT_r flansch_HT_l) (setq 
					LichterAbstand (- flansch_HT_l flansch_AT_r)
					MakeConnection  1
					linke_HT_Seite  1
			))
			
		))

	)) ; progn - if


)

; -------------------------------------------------------------------
(defun schiebeBlech ()
	; bFahnenbl
	; lchbAtrgSteg
;	(Blech.set bFahnenbl (delta_LR -60.0))

 	 (setq abtl_lb_Ht (Traeger.get HTrg AbTeil lchbAtrgSteg))
 	 (setq abtl_bl_Ht (Traeger.get HTrg AbTeil bFahnenbl))

 	 (setq blWinkel (Anbauteil.get abtl_bl_Ht Winkel))
 	 (setq tanBeta (tan (/ (* PI (- blWinkel 90.0)) 180.0)))
 	 (setq dv_HT (Traeger.get HTrg delta_V))
 	 (setq dl_Hor (* tanBeta dv_HT))

 	 (setq cosBeta (cos (/ (* PI (- 90.0 blWinkel)) 180.0)))
	 (setq dv_AT (Traeger.get Tr_ID delta_V))

	 (if (= (Connect.get CastaData vatr-lhtr) -1) (progn
	     (setq xPos_dv_AT (- (/ dv_AT cosBeta)))
	 ))
	 (if (= (Connect.get CastaData vatr-lhtr)  1) (progn
	     (setq xPos_dv_AT    (/ dv_AT cosBeta))
	 ))
	 (setq xPos_dv_AT 0.0)

;	 (if (= (Connect.get CastaData at-von-oben) 1) (progn
;	     (if (= linke_HT_Seite 1) (setq xPos_dv_AT (- xPos_dv_AT)))
;	 ))
;	 (if (= (Connect.get CastaData at-von-unten) 1) (progn
;	     (if (= linke_HT_Seite 1) (setq xPos_dv_AT (- xPos_dv_AT)))
;	 ))
;	 (if (= (Connect.get CastaData at-von-hinten) 1) (setq xPos_dv_AT (- xPos_dv_AT)))
 	 
 	 (setq xPos (Anbauteil.get abtl_bl_Ht xPos))
 	 
 	 (setq xPos_Neu (+ xPos dl_Hor xPos_dv_AT))
 	 
 	 
 	 (Anbauteil.set abtl_lb_Ht (xPos xPos_Neu))
	 (Anbauteil.set abtl_bl_Ht (xPos xPos_Neu))


  	 (setq bAsym (Blech.get bFahnenbl xAsym))
;	 (setq dv_AT (Traeger.get Tr_ID delta_V))
;	 (setq bAsym  (+ bAsym  dv_AT))
;	 (Blech.set bFahnenbl (xAsym bAsym))
	 
;	 (setq dv_AT 0.0)

;	(Anbauteil.set abtl_bl_Ht (delta_LR 0.0))
;	(setq dv_AT (Traeger.get Tr_ID delta_V))
;	(setq dlr_Blech (- dv_AT))
;	(Blech.set bFahnenbl (xAsym 0.0))

)
(defun setze_DXSKopf ()
	(setq	t_AT    (Traeger.get 	Tr_ID 		t)
		dv_AT	(Traeger.get 	Tr_ID 		delta_V))
	(setq	dp	(Blech.get	bFahnenbl 	dp))
	(setq   xAsym	(Blech.get 	bFahnenbl	xAsym))
;	(if (< dv_AT 0.0) 
;		(setq val_dxSKopf (+ (* 0.5  dp) t_AT))
;		(setq val_dxSKopf (+ (* 0.5  dp) 0))
;	)
	; Default-Wert
	(setq val_dxSKopf (+ (* 0.5  dp) t_at))
  	(if (= (Connect.get CastaData   at-von-unten)  1) (progn
  		(if (= (Connect.get CastaData     vatr-lhtr)    -1) (progn
  			(setq val_dxSKopf (+ (* 0.5  dp) 0))
  		))
  	))
  	(if (= (Connect.get CastaData   at-von-oben)  1) (progn
  		(if (= (Connect.get CastaData     vatr-lhtr)     1) (progn
  			(setq val_dxSKopf (+ (* 0.5  dp) 0))
  		))
  	))

(if (= 1 2) (progn
  	(if (= (Connect.get CastaData     vatr-lhtr)     1) (progn
  	  (if (= (Connect.get CastaData   at-von-oben)   1) (progn
  	    (if (= (Connect.get CastaData at-von-hinten) 1) (setq val_dxSKopf (+ (* 0.5  dp) 0))) ;check Fall
  	  ))
  	  (if (= (Connect.get CastaData   at-von-unten)  1) (progn
  	    (if (= (Connect.get CastaData at-von-vorne)  1) (setq val_dxSKopf (+ (* 0.5  dp) 0)))
  	  ))
  	))
  	(if (= (Connect.get CastaData     vatr-lhtr)    -1) (progn
  	  (if (= (Connect.get CastaData   at-von-oben)   1) (progn
  	    (if (= (Connect.get CastaData at-von-vorne)  1) (setq val_dxSKopf (+ (* 0.5  dp) 0)))
  	  ))
  	  (if (= (Connect.get CastaData   at-von-unten)  1) (progn
  	    (if (= (Connect.get CastaData at-von-hinten) 1) (setq val_dxSKopf (+ (* 0.5  dp) 0)))
  	  ))
  	))
))
	(Lochbild.set lchbAtrgSteg (dxSKopf val_dxSKopf))
;	(Lochbild.set lchbAtrgSteg (dxSKopf 0.0))
)

; ----------------------------------------------------------
(defun print_Parameter ()
	(setq  satr-shtr (Connect.get CastaData satr-shtr))
	(setq  vatr-lhtr (Connect.get CastaData vatr-lhtr))

	(setq  at-von-oben (Connect.get CastaData at-von-oben))
	(setq  at-von-unten (Connect.get CastaData at-von-unten))
	(setq  at-von-vorne (Connect.get CastaData at-von-vorne))
	(setq  at-von-hinten (Connect.get CastaData at-von-hinten))

	(print "------------------")
	(print satr-shtr)
	(print vatr-lhtr)
	(print at-von-oben)
	(print at-von-unten)
	(print at-von-vorne)
	(print at-von-hinten)
	(print "------------------")

;	(Connect.showAttributes CastaData)

)
