; $	HT	QT(IU)		AF(S)		P(EZ)
; $ 	AT	QT(F)		AF(S)		P(E)
; $	AE	V(-)		H(-)		R(-)

(defun load-modules ()

        (print "*clear*")

	(print "Anschluss:")
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(print "am HT-Oberflansch")
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(print "am HT-Unterflansch")
		) 
	)
	(load "mod-endinit-uz-an-flachstahl.lsp")
        (load "mod-lochbild")
)




(defun init-connection ()

	(print "*clear*")
	(setq LB_DEBUG 0)
	
	(connect.showattributes CastaData)
	(checkPosition)		; berechnet isInside
				; und als Werte: LichterAbstand
				; und Anschluss_Seite   (-1 links ... +1 rechts)
				
	(if (= Anschluss_Seite 0) (progn
	    (if (= isInside 1) (progn
	    	(AlertBox "Anschuss-Seite konnte nicht ermittelt werden!")
	    	(setq isInside 0)
	    ))
	))
	



	(if (= isInside 1)
	    (progn
		(print "in init-connection uz_an_Flachstahl mit Fahne .........................")
;		(if (= (Connect.get CastaData amHtSteg) 1)
;			(alertBox "Anschluss an der schmalen Kante ist nicht mglich!")
;		)
;		(if (= (Connect.get CastaData amHtFlansch) 1)
			; (init-traegerenden)	; hier werden die Traegerenden gestutzt
;		)
  		(setConnection)	
  
  		(print bFahnenbl)

		(setq dOK_Blech (Blech.get bFahnenbl dOK))
		(print " ......... am Ende der Makro-Ausfhrung...")
		(print dOK_Blech)
		
;		(setq abtl_Lchb_Htrg (Traeger.get HTrg ABTeil lchbAtrgSteg))
;		(Anbauteil.set abtl_Lchb_Htrg (delta_V 0))

;		(print "Anbauteil-Delta_V")
;		(setq abtl_DV (Anbauteil.get abtl_Fahne delta_v))
;		(print abtl_DV)

  	    )
  	    (progn
  		(alertBox "Anschluss ist nicht mglich!")
  	    )
	)

	(connect.showattributes CastaData)
  
    
)


(defun setConnection ()
	
	(setq S_Bez "M16")
	
	(sucheFahnenBlech)

	(if (= Doppelverbindung 0) (progn

		(setq bFahnenbl		(Blech.create))
		(setq lchbAtrgSteg	(Lochbild.create))
		(Connect.storeAnschlObjs CastaData bFahnenbl lchbAtrgSteg)
		(print "Fahnenblech erzeugt")
	  
		(Blech.set bFahnenbl (dp 10) (hp 200) (bp 110) (dOK 0))
		(print "Default Blechdaten")
	  
		(setq	XPos 	(Connect.get CastaData XPos_HT)
	  		xPos_at	(Connect.get CastaData xPos_AT)
	  	)
	  	(print XPos)
	  
	  	(setq abstzumSteg 10)
	
	  ; Fahnenblechdaten Berechnen
	  	(calcBlechUndSchraubenGroesse)
	  ; Fahnenblech hinzufgen
		(setFahnenBlechAnbauteil bFahnenbl)
	  ; Lochbildposition berechnen	
		(calcLochbildPosition)
	  ; AT-Trgerende anpassen
		(calc_AT_EndLaenge)
	  ; Blech bei schrgem Anschluss schieben
	  	(schiebeBlech)
	))
	(if (> Doppelverbindung 0) (progn
		(calc_doppV_Schrauben)
	))

	(if (= 1 1) (progn  	
	  	(Lochbild.set lchbAtrgSteg (w "0 0 0 0") (e "0 15 85 0 0 0"))
	  	(Blech.set bFahnenbl (dOK 10))
	
		(setq Abtl_LB_HT (Traeger.get HTrg  ABTeil lchbAtrgSteg))
		(setq dv_Abtl_LB  (Anbauteil.get Abtl_LB_HT delta_V))
		(setq dlr_Abtl_LB_HT (Anbauteil.get Abtl_LB_HT delta_LR))
		
;		(AlertBox dv_Abtl_LB)
		(AlertBox dlr_Abtl_LB_HT)


		(setq Abtl_LB_AT (Traeger.get Tr_ID  ABTeil lchbAtrgSteg))
		(setq dv_Abtl_LB_AT  (Anbauteil.get Abtl_LB_AT delta_V))
		(setq dlr_Abtl_LB_AT (Anbauteil.get Abtl_LB_AT delta_LR))
		(setq wnk_Abtl_LB_AT (Anbauteil.get Abtl_LB_AT Winkel))
		(setq SeitRicht_LB_AT (Anbauteil.get Abtl_LB_AT SeitRicht))
		
;		(AlertBox dv_Abtl_LB_AT)
		(AlertBox dlr_Abtl_LB_AT)
;		(AlertBox wnk_Abtl_LB_AT)
;		(AlertBox SeitRicht_LB_AT)
	))

)

(defun	calcLochbildPosition ()
	; Lochbild HT
	(print "ADDABTL - Fahnenblechlochbild in HT")
	(setq AbtlFahnenBl	(Traeger.get Htrg AbTeil bFahnenbl))
	(Traeger.addabtl Htrg lchbAtrgSteg XPos 0.0 _fahnblLochbild_ AbtlFahnenBl)


	(aetq LB_Wnkl 0.0)
	(if (= (Connect.get CastaData linkesEnde)  1) (setq LB_Wnkl    0.0))
	(if (= (Connect.get CastaData rechtesEnde) 1) (setq LB_Wnkl 180.0))

	; Lochbild AT
	(setq Flansch_LB 0)
	(if (= (Connect.get CastaData amHtUnterflansch) 1) 	(setq Flansch_LB _flanschlochbild_uf_))
	(if (= (Connect.get CastaData amHtOberflansch)  1) 	(setq Flansch_LB _flanschlochbild_of_))
	(if (= Flansch_LB 0) (progn
	    (if (= (Connect.get CastaData at-von-unten) 1) 	(progn
	    	(if (= (Connect.get CastaData linkesEnde) 1) (setq Flansch_LB _flanschlochbild_of_))
	    ))
	    (if (= (Connect.get CastaData at-von-oben) 1) 	(progn
	    	(if (= (Connect.get CastaData rechtesEnde) 1) (setq Flansch_LB _flanschlochbild_of_))
	    ))
	    (if (= Flansch_LB 0) (progn
		(AlertBox "Die Art des Flanschlochbilds konnte nicht ermittelt werden.\nOberflansch wird angenommen!")
	    	(setq Flansch_LB _flanschlochbild_of_)
	    ))
	))
	; Anbauteil eintragen ...
	(Traeger.addabtl Tr_ID lchbAtrgSteg xPos_at LB_Wnkl Flansch_LB)

	(setq Abtl_LB_HT (Traeger.get HTrg  ABTeil lchbAtrgSteg))
	(setq Abtl_LB_AT (Traeger.get Tr_ID ABTeil lchbAtrgSteg))
	(Anbauteil.set Abtl_LB_HT (Master 1))
	(Anbauteil.set Abtl_LB_AT (Master 0))
	
	(setq	dlr_AT		(Traeger.get Tr_ID delta_LR)
		b_AT		(Traeger.get Tr_ID b)
		dlr_HT  	(Traeger.get HTrg delta_LR)
		s_HTrg		(Traeger.get HTrg s)
		b_HTrg		(Traeger.get HTrg b)
		QSForm_HT  	(Traeger.get HTrg qsform)
	)
	
	(setq s_rel_HT (* 0.5 s_HTrg))
	(if (= QSForm_HT "U") (progn
		(if (= Anschluss_Seite  1) (setq s_rel_HT s_HTrg))
		(if (= Anschluss_Seite -1) (setq s_rel_HT 0.0))
	))
	(if (= QSForm_HT "K") (progn
		(setq s_rel_HT (* 0.5 QSForm_HT))
	))

	(setq lb_Delta_LR    dlr_AT)

	(if (= (Connect.get CastaData sAtr-sHtr) 1) (progn
		(if (= (Connect.get CastaData at-von-unten) 1) (Anbauteil.set Abtl_LB_AT (SeitRicht -1)))
	))
	(if (= (Connect.get CastaData sAtr-sHtr) -1) (progn
		(if (= (Connect.get CastaData at-von-oben) 1) (Anbauteil.set Abtl_LB_AT (SeitRicht -1)))
	))

	(if (= (Connect.get CastaData at-von-oben)  1) (setq lb_Delta_LR (- lb_Delta_LR)))
	(if (= Anschluss_Seite -1) (progn
		(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq lb_Delta_LR (- lb_Delta_LR dlr_HT s_rel_HT)))
		(if (= (Connect.get CastaData vAtr-lHtr) -1) (setq lb_Delta_LR (+ lb_Delta_LR dlr_HT s_rel_HT)))
	))
	(if (= Anschluss_Seite  1) (progn
		(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq lb_Delta_LR (- lb_Delta_LR dlr_HT s_rel_HT)))
		(if (= (Connect.get CastaData vAtr-lHtr) -1) (setq lb_Delta_LR (+ lb_Delta_LR dlr_HT s_rel_HT)))
	))

	; Hier wird seitlich Abstand des Lochbilds auf den HT bertragen. Damit muss bei einem Gegenanschluss 
	; dieser Wert nicht ermittelt werden - Das Lochbild des Flachstahls liegt also fix bei 0.0 seitlicher Verschiebung
	; Dann kann man beim Gegenanschluss aus dem HT den Abstand abfragen und die seitliche Verschiebung lokal
	; an das aktuelle Flachstahl anpassen.
	; (Anbauteil.set Abtl_LB_AT (delta_LR lb_Delta_LR))
	(Anbauteil.set Abtl_LB_HT (delta_LR (* 0.5 lb_Delta_LR)))
	
	; Lochbild-Wurzelma entspricht genau dieser Verschiebung, damit es wieder in der Mitte des
	; Flachstahls zu liegen kommt.
	; (Lochbild.set lchbAtrgSteg (w0 lb_Delta_LR))
	; (Lochbild.set lchbAtrgSteg (w0 50))

	(setq  w0_LB lb_Delta_LR)
	(if (< w0_LB 0.0) (setq w0_LB (- w0_LB)))


	(setq	dv_AT	(Traeger.get 	Tr_ID 		delta_V))
	(if (< dv_AT 0.0) 
		(setq val_dxSKopf (+ (* 0.5  dp) t_AT))
		(setq val_dxSKopf (+ (* 0.5  dp) 0))
	)
  	(if (= (Connect.get CastaData vatr-lhtr)  -1)	(progn
		(setq val_dxSKopf (+ (* 0.5  dp) 0))
		(setq val_dxSKopf (+ (* 0.5  dp) t_AT))
  	))
	
	(Lochbild.set lchbAtrgSteg (KlemmL (+ t_AT dp)))
	(Lochbild.set lchbAtrgSteg (dxSKopf val_dxSKopf))
	; (if (= (Connect.get CastaData amHtUnterflansch) 1) (Lochbild.set lchbAtrgSteg (LB_Art  2) (w0 w0_LB)))
	; (if (= (Connect.get CastaData amHtOberflansch)  1) (Lochbild.set lchbAtrgSteg (LB_Art -2) (w0 w0_LB)))

	; (Lochbild.set lchbAtrgSteg (w0 0) (e "0 15 60 0 0 0"))	; zum Testen - wieder entfernen
	; (Lochbild.set lchbAtrgSteg (w1 100)) 				; zum Testen - wieder entfernen

	(setq abtl_bl_Ht (Traeger.get HTrg AbTeil bFahnenbl))
	(if abtl_bl_Ht (progn
		(setq blWinkel (Anbauteil.get abtl_bl_Ht Winkel))
		(setq cosBeta (cos (/ (* PI (- blWinkel 90.0)) 180.0)))
	    ); progn
	    (progn
		(AlertBox "Das Fahnenblech wurde nicht an den HT angeschlossen!")
		(setq cosBeta 1.0)
	))


	(setq 	dlr_HT	(Traeger.get HTrg delta_LR))
	(setq	dlr_HT	(/ dlr_HT cosBeta))
	(if (= (Connect.get CastaData LinkesEnde) 1) (progn
	    (setq dv_Lb 0.0)
	    (if (= (Connect.get CastaData at-von-links)  1) (setq dv_Lb (+ dv_Lb dlr_HT)))
	    (if (= (Connect.get CastaData at-von-rechts) 1) (setq dv_Lb (- dv_Lb dlr_HT)))
	    (Anbauteil.set Abtl_LB_AT (delta_V dv_Lb))
	))
	(if (= (Connect.get CastaData RechtesEnde) 1) (progn
	    (setq dv_Lb 0.0)
	    (if (= (Connect.get CastaData at-von-links)  1) (setq dv_Lb (+ dv_Lb dlr_HT)))
	    (if (= (Connect.get CastaData at-von-rechts) 1) (setq dv_Lb (- dv_Lb dlr_HT)))
	    (Anbauteil.set Abtl_LB_AT (delta_V dv_Lb))
	))


)
(defun calc_AT_EndLaenge ()

	(setq abtl_lb_Ht (Traeger.get HTrg AbTeil lchbAtrgSteg))
	(setq abtl_bl_Ht (Traeger.get HTrg AbTeil bFahnenbl))
	(if abtl_bl_Ht (progn
		(setq blWinkel (Anbauteil.get abtl_bl_Ht Winkel))
		(setq cosBeta (cos (/ (* PI (- blWinkel 90.0)) 180.0)))
	    ); progn
	    (progn
		(AlertBox "Das Fahnenblech wurde nicht an den HT angeschlossen!")
		(setq cosBeta 1.0)
	))

	(setq 	hp 	(Blech.get bFahnenbl hp))
	(setq 	dlr_HT	(Traeger.get HTrg delta_LR))
	(setq   dlr_HT  (/ dlr_HT cosBeta))
	
	(if (= (Connect.get CastaData LinkesEnde) 1) (progn
	    (setq TrgEnde (Traeger.get Tr_ID links))
	    (setq dl_Neu (* -0.5 hp))
	    (if (= (Connect.get CastaData at-von-links)  1) (setq dl_Neu (+ dl_Neu dlr_HT)))
	    (if (= (Connect.get CastaData at-von-rechts) 1) (setq dl_Neu (- dl_Neu dlr_HT)))
	    (TrEnde.set TrgEnde (delta_L dl_Neu))
	))
	(if (= (Connect.get CastaData RechtesEnde) 1) (progn
	    (setq TrgEnde (Traeger.get Tr_ID rechts))
	    (setq dl_Neu (* -0.5 hp))
	    (if (= (Connect.get CastaData at-von-links)  1) (setq dl_Neu (- dl_Neu dlr_HT)))
	    (if (= (Connect.get CastaData at-von-rechts) 1) (setq dl_Neu (+ dl_Neu dlr_HT)))
	    (TrEnde.set TrgEnde (delta_L dl_Neu))
	))

)

; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Fahne am HT
; ----------------------------------------------------------------------------------------
(defun cb_bFahnenbl (zp)
	(print "in Callback-Funktion cb_bFahnenbl")
	(print zp)
	;(alertBox "in Callback-Funktion cb_bFahnenbl")

	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt 	(Blech.get bFahnenbl dp))
	    (setq hpAlt 	(Blech.get bFahnenbl hp))
	    (setq dokAlt 	(Blech.get bFahnenbl dok))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
		(setq dpNeu (Blech.get bFahnenbl dp))
		(setq hpNeu (Blech.get bFahnenbl hp))
		(setq dokNeu (Blech.get bFahnenbl dok))
		
		(print dpAlt) (print dpNeu)
		(print hpAlt) (print hpNeu)
		(print dokAlt) (print dokNeu)
		(print "--------------------------------------")
		
		; nderung der Blechdicke
		(if (/= dpAlt dpNeu) (progn
			(setq dpDiff (- dpNeu dpAlt))
			
			(setq qsform_at	(Traeger.get Tr_ID qsform))
			
			(setq alteKlemml 	(Lochbild.get lchbAtrgSteg Klemml)
						dxs_alt			(Lochbild.get lchbAtrgSteg dxskopf)
			)
			
			(setq delta_lr_blech_alt (Blech.get bFahnenbl delta_lr))
			(print delta_lr_blech_alt)
			
			(setq klemml_neu	(+ alteKlemml dpDiff))
			
			(setq dxs_neu (+ dxs_alt (* 0.5 dpDiff)))
			
			(if (= qsform_at "I")
				(setq delta_lr_blech_neu (+ delta_lr_blech_alt (* 0.5 dpDiff)))
			)
			(if (= qsform_at "U")
				(progn
					
					(if (= (Connect.get CastaData amHtSteg) 1)
						(progn
							(if (= (Connect.get CastaData satr-vhtr)  1)	
								(setq delta_lr_blech_neu (+ delta_lr_blech_alt (* 0.5 dpDiff)))
							)
							(if (= (Connect.get CastaData satr-vhtr) -1)	
								(setq delta_lr_blech_neu (- delta_lr_blech_alt (* 0.5 dpDiff)))
							)
						)
					)
						(if (= (Connect.get CastaData amHtFlansch) 1)
						(progn
							(if (= (Connect.get CastaData satr-shtr)  1)	
								(setq delta_lr_blech_neu (+ delta_lr_blech_alt (* 0.5 dpDiff)))
							)
							(if (= (Connect.get CastaData satr-shtr) -1)	
								(setq delta_lr_blech_neu (- delta_lr_blech_alt (* 0.5 dpDiff)))
							)
						)
					)
					
				)
			)
			
			(print delta_lr_blech_neu)		  	
			
			(Blech.set bFahnenbl (delta_lr delta_lr_blech_neu))
			              
			(Lochbild.set lchbAtrgSteg 	(klemml klemml_neu)
																	(dxskopf dxs_neu)
			)    
			
			
			(setq abtl_lb_ht (Traeger.get Htrg AbTeil lchbAtrgSteg))
		  
		  (setq delta_sx_abtl_ht_neu delta_lr_blech_neu )
						
			(Anbauteil.set abtl_lb_ht (delta_sx delta_sx_abtl_ht_neu))
			
			
		))
		    
				
		(if (= 1 2)	(progn		
		; nderung der Blechhhe
		(if (/= hpAlt hpNeu) (progn
		  (setq hpDiff (- hpNeu hpAlt))
		  
		  (setq abtl_lb_at (Traeger.get Tr_ID AbTeil lchbAtrgSteg))
		  (setq delta_v_abtl_at_alt (Anbauteil.get abtl_lb_at delta_v))
		  (print delta_v_abtl_at_alt)
		  
			(if (= (Connect.get CastaData vatr-lhtr) -1) (setq delta_v_abtl_at_neu (- delta_v_abtl_at_alt (* 0.5 hpDiff))))
			(if (= (Connect.get CastaData vatr-lhtr)  1) (setq delta_v_abtl_at_neu (+ delta_v_abtl_at_alt (* 0.5 hpDiff))))
			(print delta_v_abtl_at_neu)
			
			(Anbauteil.set abtl_lb_at (delta_v delta_v_abtl_at_neu))
		))
		
		; Verschiebung des Bleches in HT-Lngsrichtung
		(if (/= dokAlt dokNeu) (progn
		  (setq dokDiff (- dokNeu dokAlt))
		  (print dokDiff)
		  
		  (setq abtl_lb_at (Traeger.get Tr_ID AbTeil lchbAtrgSteg))
		  (setq delta_v_abtl_at_alt (Anbauteil.get abtl_lb_at delta_v))
		  (print delta_v_abtl_at_alt)
		  
		  (if (= (Connect.get CastaData vatr-lhtr) -1) (setq delta_v_abtl_at_neu (+ delta_v_abtl_at_alt dokDiff)))
		  (if (= (Connect.get CastaData vatr-lhtr)  1) (setq delta_v_abtl_at_neu (- delta_v_abtl_at_alt dokDiff)))
		  (print delta_v_abtl_at_neu)

		  (Anbauteil.set abtl_lb_at (delta_v delta_v_abtl_at_neu))
		))
	))
	))
)



; ------------------------------------------------------------------------
; Setzt das Fahnenblech-Anbauteil
; ------------------------------------------------------------------------
(defun setFahnenBlechAnbauteil (Blech_ID)
	
  (setq XPos 		(Connect.get CastaData XPos_HT))
	
  (setq delta_v_at (Traeger.get Tr_ID delta_v))
	
  (setq AT_WnklSteg (Connect.get CastaData v-atrgewnkl_steg))

  ;; _fahnenblech_steg_li_
  ;; _fahnenblech_steg_re_

  (setq KopfWinkel (Connect.get CastaData v-atrgewnkl_kopf ))
  (if (= (Connect.get CastaData at-von-hinten) 1) (setq KopfWinkel (- (- 90 KopfWinkel) 90.0)))
;  (if (= (Connect.get CastaData at-von-vorne) 1) (progn
	  (if (= (Connect.get CastaData linkesEnde) 1) (progn
	  	(print "hier - linkes Ende")
		  (if (= (Connect.get CastaData vAtr-lHtr)  1) (progn
		  	(setq rWinkel (+ KopfWinkel 90.0))
		  ))
		  (if (= (Connect.get CastaData vAtr-lHtr) -1) (progn
		  	(setq rWinkel (- 90.0 KopfWinkel))
		  	(setq rWinkel (+ rWinkel 180.0))
		))
	  ))
	  (if (= (Connect.get CastaData rechtesEnde) 1) (progn
		  (if (= (Connect.get CastaData vAtr-lHtr) -1) (progn
		  	(setq rWinkel (- (- KopfWinkel 90.0)))
		  ))
		  (if (= (Connect.get CastaData vAtr-lHtr)  1) (progn
		  	(setq rWinkel (+ 90.0 KopfWinkel))
		  	(setq rWinkel (+ rWinkel 180.0))
		))
	  ))
;   ))
   (setq Element_Added 0)
   (if (= (Connect.get CastaData at-von-hinten) 0) (progn
      (if (= (Connect.get CastaData at-von-vorne) 0) (progn
      	 (setq rWinkel -90.0)
         (if (= Anschluss_Seite  1) (traeger.addabtl hTrg Blech_ID XPos rWinkel _fahnenblech_steg_re_))
         (if (= Anschluss_Seite -1) (traeger.addabtl hTrg Blech_ID XPos rWinkel _fahnenblech_steg_li_))
         (setq Element_Added 1)
      ))
   ))

   ; Anschlsse am Flansch des Haupttrgers
   (if (= Element_Added 0) (progn
      (if (= Anschluss_Seite  1) 	(progn
	(print "ADDABTL - Fahnenblech an HT (Steg rechts)")
  	(if (= (Connect.get CastaData amAtStegLinks) 1) (setq rWinkel (- 180.0 AT_WnklSteg)))
  	(traeger.addabtl hTrg Blech_ID XPos rWinkel _fahnenblech_steg_re_)
      ))
      (if (= Anschluss_Seite -1) 	(progn
	(print "ADDABTL - Fahnenblech an HT (Steg links)")
  	(if (= (Connect.get CastaData amAtStegRechts) 1) (setq rWinkel (- 180.0 AT_WnklSteg)))
  	(traeger.addabtl hTrg Blech_ID XPos rWinkel _fahnenblech_steg_li_)
      ))
   ))


  (setq	t_AT	(Traeger.get 	Tr_ID 		t)
  	dv_AT	(Traeger.get 	Tr_ID 		delta_V)
	dp	(Blech.get 	Blech_ID	dp)
  )

	; ---- Starte Ausklammerung
    (if (= 2 2) (progn  
	  ; Anteil delta_v AT
	(setq delta_v_abtl_fb 0)
	  
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_fb (- delta_v_abtl_fb delta_v_at)))
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_fb (+ delta_v_abtl_fb delta_v_at)))
		
	  
	(setq abtl_fahne (Traeger.get Htrg AbTeil Blech_ID))
	(if abtl_fahne (progn
		(Anbauteil.set abtl_fahne (delta_v delta_v_abtl_fb))
		;; wird jetzt einfach 0 eingesetzt ...
		(Anbauteil.set abtl_fahne (delta_v 0.0))
	    ); progn
	    (progn
		(AlertBox "Achtung - Hinweis: Abtl_Fahne ist nicht definiert!")
	))
	  
	  (setq	t_AT	(Traeger.get 	Tr_ID 		t)
	  	dv_AT	(Traeger.get 	Tr_ID 		delta_V)
		dp	(Blech.get 	Blech_ID	dp)
	  )
	  

	  (if (= (Connect.get CastaData vatr-lhtr)  1)	(progn
		  (if (>= dv_AT 0.0) (progn
		    (BLech.set Blech_ID (xASym (- (- dv_AT (* 0.5 (+ t_AT dp))))))
		  ))
		  (if (< dv_AT 0.0) (progn
		    (BLech.set Blech_ID (xASym (- (+ (* 0.5 (+ t_AT dp)) dv_AT))))
		  ))
	  ))
	  (if (= (Connect.get CastaData vatr-lhtr)  -1)	(progn
		  (if (>= dv_AT 0.0) (progn
		    (BLech.set Blech_ID (xASym (+ (* -0.5 (+ t_AT dp)) dv_AT)))
		  ))
		  (if (< dv_AT 0.0) (progn
		    (BLech.set Blech_ID (xASym (+ (* 0.5 (+ t_AT dp)) dv_AT)))
		  ))
	  ))

	  ; (BLech.set Blech_ID (xASym (- (+ (* -0.5 (+ t_AT dp)) dv_AT))))
    	  ; (BLech.set Blech_ID (xASym (- (+ (* 0.5 (+ t_AT dp)) dv_AT))))
	  
     ))
     ; --- ende ausklammerung
)
(defun calcBlechUndSchraubenGroesse ()
  (setq b_HT (Traeger.get HTrg b))
  (if (< b_HT (* 8 16)) 
    (progn	; Schraubengre M12
	(Lochbild.set lchbAtrgSteg (S_Bez "M12") (S_Guete "4.6") (e "0 0 0 0 0 0"))
	(Lochbild.set lchbAtrgSteg (e0 -35) (e1 50))
	(Blech.set bFahnenbl (hp (* 8 12)))
    )
    (progn	; Schraubengre M16
	(Lochbild.set lchbAtrgSteg (S_Bez "M16") (S_Guete "4.6") (e "0 0 0 0 0 0"))
	(Lochbild.set lchbAtrgSteg (e0 -30) (e1 60))
	(Blech.set bFahnenbl (hp (* 8 16)))
    )
  )

  (setq	dlr_AT (Traeger.get Tr_ID delta_LR)
	b_AT   (Traeger.get Tr_ID b)
	dv_HT  (Traeger.get HTrg delta_V)
  )

  (setq lb_Delta_LR    dlr_AT)
	(if (= (Connect.get CastaData at-von-rechts)  1) (setq dv_HT (- dv_HT)))
	(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
		(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq lb_Delta_LR (- lb_Delta_LR dv_HT)))
		(if (= (Connect.get CastaData vAtr-lHtr) -1) (setq lb_Delta_LR (+ lb_Delta_LR dv_HT)))
	))
	(if (= (Connect.get CastaData amHtOberflansch) 1) (progn
		(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq lb_Delta_LR (- lb_Delta_LR dv_HT)))
		(if (= (Connect.get CastaData vAtr-lHtr) -1) (setq lb_Delta_LR (+ lb_Delta_LR dv_HT)))
	))
  
  (if (< lb_Delta_LR 0) (setq lb_Delta_LR (- lb_Delta_LR)))
  (setq b_Blech (+ lb_Delta_LR (* 0.5 b_AT)))
  (Blech.set bFahnenbl (bp b_Blech))
  
  (setq b_Blech (+ LichterAbstand b_AT))
  (setq	QSTyp	(Traeger.get HTrg qsform)
  	b_HT	(Traeger.get HTrg b)
  	s_HT	(Traeger.get HTrg s)
  )
  (if (= QSTyp "U") (progn
  	(if (= Anschluss_Seite 1) (setq b_Blech (+ b_Blech (- b_HT s_HT))))
    )
    (progn
	(setq b_Blech (+ b_Blech (* 0.5 b_HT)))
  ))
  
  (setq b_Blech (runde (+ b_Blech 2) auf 5))
  
  
  (Blech.set bFahnenbl (bp b_Blech))
  
  (Lochbild.set lchbAtrgSteg (w0 50))

)

; ----------------------------------------------------------------------------------------
; Prft, die Position des AT in Bezug auf den HT
; ----------------------------------------------------------------------------------------
(defun checkPosition ()
	(print "------------------------------------------------------------")
	(print "BERPRFE AT POSITION")
	(print "------------------------------------------------------------")
	
	(setq	hc_ht		(Traeger.get Htrg hc)
		b_ht		(Traeger.get Htrg b)
		delta_v_ht	(Traeger.get Htrg delta_v)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(setq delta_lr_at	(Traeger.get Tr_ID delta_lr)
				s_at				(Traeger.get Tr_ID s)
	)

	(setq Berechne_LichtenAbstand 0)
	; Standardmig wird angenommen, dass der AT angeschlossen werden kann.
	(setq isInside 1)
	
	; Wenn der Anschluss am HT-Steg erfolgt, wird geprft, ob sich der AT-Steg im HC-Bereich des HT befindet.
	(if (= (connect.get CastaData amHtSteg) 1) (progn
		(if (= (connect.get CastaData AnschlussTyp) 20) (setq Berechne_LichtenAbstand 1))
	))
	(if (= (Connect.get CastaData amHtFlansch) 1) (progn
		(setq Berechne_LichtenAbstand 1)
	))
	; Wenn der Anschluss am HT-Flansch erfolgt, wird geprft, ob der AT-Steg noch am Flansch 
	; angeschlossen werden kann.
	(if (= Berechne_LichtenAbstand 1) (progn
	
	    (setq	QSTyp	(Traeger.get HTrg qsform)
	    		dlr_HT	(Traeger.get HTrg delta_LR)
	    		b_HT	(Traeger.get HTrg b)
	    )
	    (setq	dlr_AT	(Traeger.get Tr_ID delta_LR)
	    		b_AT	(Traeger.get Tr_ID b)	
	    )
	    (setq QSTyp (Traeger.get HTrg qsform))
	    
	    (setq b_HT_Links (* 0.5 b_HT) b_HT_Rechts (* 0.5 b_HT))
	    (if (= QSTyp "U") (progn
	    	(setq b_HT_Links (* 0.0 b_HT) b_HT_Rechts (* 1.0 b_HT))
	    ))

	    (setq LichterAbstand 0.0)
	    (setq Anschluss_Seite 0)	;	-1 bedeutet links - +1 bedeutet rechts

	    ; ===========================================================
		(if (= (Connect.get CastaData satr-shtr) -1) (progn
		    (if (= (Connect.get CastaData vatr-lhtr)  1) (progn
			(setq LichterAbstand (- (- dlr_AT) dlr_HT))
			(print "Platzierung: Fall -1-")
			(if (< LichterAbstand 0.0) (progn
				(setq LichterAbstand (- LichterAbstand))
				(setq LichterAbstand (- LichterAbstand b_HT_Links (* 0.5 b_AT)))
				(setq Anschluss_Seite -1)
			    ) ; progn
			    (progn
				(setq LichterAbstand (- LichterAbstand b_HT_Rechts (* 0.5 b_AT)))
				(setq Anschluss_Seite  1)
			)) 
		    ))
		    (if (= (Connect.get CastaData vatr-lhtr) -1) (progn
			(print "Platzierung: Fall -2-")
			(setq LichterAbstand (- dlr_AT (- dlr_HT)))
			(if (< LichterAbstand 0.0) (progn
				(setq LichterAbstand (- LichterAbstand))
				(setq LichterAbstand (- LichterAbstand b_HT_Rechts (* 0.5 b_AT)))
				(setq Anschluss_Seite  1)
			    ); progn
			    (progn
				(setq LichterAbstand (- LichterAbstand b_HT_Links (* 0.5 b_AT)))
				(setq Anschluss_Seite -1)
			))
		    ))
		))
		; ===========================================================
		(if (= (Connect.get CastaData satr-shtr)  1) (progn
		    (if (= (Connect.get CastaData vatr-lhtr) -1) (progn
			(print "Platzierung: Fall -3-")
			(setq LichterAbstand (+ (- dlr_AT) dlr_HT))
			(if (< LichterAbstand 0.0) (progn
				(setq LichterAbstand (- LichterAbstand))
				(setq LichterAbstand (- LichterAbstand b_HT_Rechts (* 0.5 b_AT)))
				(setq Anschluss_Seite  1)
			    ); progn
			    (progn
				(setq LichterAbstand (- LichterAbstand b_HT_Links (* 0.5 b_AT)))
				(setq Anschluss_Seite -1)
			))
			(print LichterAbstand)
		    ))
		    ; -------------------------------------------
		    (if (= (Connect.get CastaData vatr-lhtr)  1) (progn
			(print "Platzierung: Fall -4-")
			(setq LichterAbstand (-  dlr_AT dlr_HT ))

			(if (< LichterAbstand 0.0) (progn
				(setq LichterAbstand (- LichterAbstand))
				(setq LichterAbstand (- LichterAbstand b_HT_Links (* 0.5 b_AT)))
				(setq Anschluss_Seite -1)
			    ); progn
			    (progn
				(setq LichterAbstand (- LichterAbstand b_HT_Rechts (* 0.5 b_AT)))
				(setq Anschluss_Seite  1)
			))
		    ))
		))
	    ; ===========================================================
	    (if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
	    	(setq Anschluss_Seite 0)	;	ist noch nicht entwickelt, verursacht Fehler beim Anschluss
	    ))
	    (if (= (Connect.get CastaData amHtSteg) 1) (progn
	    	(if (/= (Connect.get CastaData anschlusstyp )  20) (progn
	    	    (setq Anschluss_Seite 0)	;	ist noch nicht entwickelt, verursacht Fehler beim Anschluss
	    	))
	    ))

	    (if (< LichterAbstand 0.0) (setq isInside 0))

	    (if (= isInside 0)
		(print "AUSSERHALB FLANSCH")
		(print "INNERHALB FLANSCH")
	    )
	))
)

; -------------------------------------------------------------------
(defun schiebeBlech ()
	; bFahnenbl
	; lchbAtrgSteg
;	(Blech.set bFahnenbl (delta_LR -60.0))
   (if (= 1 2) (progn
 	 (setq abtl_lb_Ht (Traeger.get HTrg AbTeil lchbAtrgSteg))
 	 (setq abtl_bl_Ht (Traeger.get HTrg AbTeil bFahnenbl))
(debug off)	 
 	 (setq blWinkel (Anbauteil.get abtl_bl_Ht Winkel))
 	 (setq tanBeta (tan (/ (* PI (- blWinkel 90.0)) 180.0)))
 	 (setq dV_HT (Traeger.get HTrg delta_V))
 	 (setq dl_Hor (* tanBeta dV_HT))
(debug off)
 	 (setq xPos (Anbauteil.get abtl_bl_Ht xPos))
 	 (setq xPos_Neu (+ xPos dl_Hor))
 	 
 	 (Anbauteil.set abtl_lb_Ht (xPos xPos_Neu))
 	 (Anbauteil.set abtl_bl_Ht (xPos xPos_Neu))

;	(Anbauteil.set abtl_bl_Ht (delta_LR 0.0))
;	(setq dv_AT (Traeger.get Tr_ID delta_V))
;	(setq dlr_Blech (- dv_AT))
;	(Blech.set bFahnenbl (xAsym 0.0))

    ))

)

; ----------------------------------------------------------

(defun sucheFahnenBlech ()

  (setq DoppelVerbindung 0)

  (setq xPos_HT (Connect.get CastaData xPos_HT))
;  (setq xPos_HT xPos_Blech)



  (setq gesFahBlTyp 0) ; auf unknown setzen
;  (if (= (connect.get CastaData amHtOberFlansch)  1)  (setq gesFahBlTyp _fahnenblech_of_))
;  (if (= (connect.get CastaData amHtUnterFlansch) 1)  (setq gesFahBlTyp _fahnenblech_uf_))
;  (if (= (connect.get CastaData amHtStegLinks)    1)  (setq gesFahBlTyp _fahnenblech_steg_li_))
;  (if (= (connect.get CastaData amHtStegRechts)   1)  (setq gesFahBlTyp _fahnenblech_steg_re_))
  
  (if (= Anschluss_Seite -1) (setq gesFahBlTyp _fahnenblech_steg_li_))
  (if (= Anschluss_Seite  1) (setq gesFahBlTyp _fahnenblech_steg_re_))


  (setq abtl_FahnBl (Traeger.get Htrg firstAbtl fahnenblech (- xPos_HT 0.5) (+ xPos_HT 0.5)))
  (while abtl_FahnBl
  	(setq sType     (Anbauteil.get abtl_FahnBl is_type gesFahBlTyp))
  	(if (= sType 1) (progn
	    (print "Fahnenblech gefunden -----------------------------------------------------")
	    (print sType)

	    (showAbtlDaten abtl_FahnBl)	;; nur zu Entwicklungszwecken

	    (setq abtl_FahnBl_Vorhanden abtl_FahnBl)
	    (setq bFahnenbl (Anbauteil.get abtl_FahnBl Objekt Blech))
	    (setq xPosVorh (Anbauteil.get abtl_FahnBl xPos))
	    (setq DoppelVerbindung 1)
	))
  	(setq abtl_FahnBl (Traeger.get Htrg nextAbtl fahnenblech))
  )
  (setq abtl_FahnBl_T (Traeger.get Htrg firstAbtl fahnenblech (- xPos_HT 0.1) (+ xPos_HT 0.1)))
  (if (existObj FahnenBlech) (progn
	  (if (existObj abtl_FahnBl_T)
	      (print  "OK - Objekt gefunden und passt");
	      (alertBox "Das Blech wurde mit einer greren Toleranz eingesetzt!\nBitte die Schraubenlngen nach nderung der Blechdicke berprfen!");
	  )
  ))

  (if (= (connect.get CastaData amHtOberFlansch)  1)  (setq gesFahLbTyp (+ _fahnbllochbild_ _oberflansch_)))
  (if (= (connect.get CastaData amHtUnterFlansch) 1)  (setq gesFahLbTyp (+ _fahnbllochbild_ _unterflansch_)))
  (setq TestTyp (+ _fahnbllochbild_ _unterflansch_))
  (setq abtl_FahnBlLchb (Traeger.get Htrg firstAbtl lochbild (- xPos_HT 0.5) (+ xPos_HT 0.5)))
  (while abtl_FahnBlLchb
  	(setq sType     (Anbauteil.get abtl_FahnBlLchb is_type gesFahLbTyp))
  	(if (= sType 1) (progn
  	    (setq abtl_FahnBlLchb_Vorhanden abtl_FahnBlLchb)
	    (setq lchbAtrgSteg (Anbauteil.get abtl_FahnBlLchb Objekt Lochbild))
  	))
  	(setq abtl_FahnBlLchb (Traeger.get Htrg nextAbtl lochbild))
  )
)
; ------------------------------------------------------------
; Doppelt vorhandene Schrauben anschlieen
(defun calc_doppV_Schrauben ()

	(AlertBox "calc_doppV_Schrauben")
	(setq Flansch_Lb_Typ 0)
;	(if (= Anschluss_Seite -1) (setq Flansch_Lb_Typ _fahnenblech_steg_li_))
;	(if (= Anschluss_Seite  1) (setq Flansch_Lb_Typ _fahnenblech_steg_re_))

  (if (= (connect.get CastaData amHtOberFlansch)  1)  (setq Flansch_Lb_Typ _flanschlochbild_of_))
  (if (= (connect.get CastaData amHtUnterFlansch) 1)  (setq Flansch_Lb_Typ _flanschlochbild_uf_))


	(if (/= Flansch_Lb_Typ 0) (progn

	(AlertBox Flansch_Lb_Typ)
	(AlertBox lchbAtrgSteg)

		(setq	xPos_at	(Connect.get CastaData xPos_AT))

		(Traeger.addabtl Tr_ID lchbAtrgSteg xPos_at 0.0 Flansch_Lb_Typ)
		(setq abtl_Lchb (Traeger.get Tr_ID ABTeil lchbAtrgSteg))
		(Anbauteil.set abtl_Lchb (Master 0))
	))
;	(setq	t_AT 	(Traeger.get Tr_ID t)
;		dv_AT	(Traeger.get Tr_ID delta_V)
;	)
;	(setq	dxSKopf_vorh (Lochbild.get lchbAtrgSteg dxSKopf)
;		KlemmL_vorh  (Lochbild.get lchbAtrgSteg KlemmL)
;	)
;	(setq dxSKopf_Neu     dxSKopf_vorh)
;	(if (< dv_AT 0.0) (setq dxSKopf_Neu  (+ dxSKopf_vorh t_AT)))
;	(Lochbild.set lchbAtrgSteg 	(dxSKopf dxSKopf_Neu)
;					(KlemmL  (+ KlemmL_vorh t_AT))
;	)

)
