; $	HT	QT(IU)		AF(FK)		P(ZE)
; $	AT	QT(F)		AF(FK)		P(ZE)
; $ 	AE	V(0)		H(-)		R(-)

(defun load-modules ()
	(load "mod-endinit-trg-auf-trg")
)

(defun init-connection ()
	(print "*clear*")
	(connect.showattributes CastaData)
	(setq LB_DEBUG 0)
	
	;(init-traegerenden)
	;(setConnection)
				
	(if (= 1 1)	(progn
		(if (/= (Connect.get CastaData vatr-shtr) 0) 
			(progn
				; Abstand zwischen den Trgern berechnen
				; ---------------------------------------------
				(calcLichtenAbst) ; -> lichterAbst
				(if (> lichterAbst 2.0) (progn
					; (init-traegerenden)
					(setConnection)
					; (showDevelopValues)
				  )
				  (AlertBox "Der Abstand ist zu gering, um ein Blech dazwischen zu setzen!"  "GapWidth_Not_Allowed")
				)
			)
			(progn
				(alertbox "Der Anschluss ist z.Z. in dieser Kombination nicht mglich.\n\nBitte rotieren Sie die Trger so, dass die hellen bzw. dunklen Flanschseiten\nin eine Richtung zeigen und tauschen Sie, falls ntig, die Orientierung eines Trgers." "ERR_BeamRoation_Not_Functional")
			)
		)
	))
	
)

(defun showDevelopValues ()
 	
	(setq Anb_Lochb_AT (Traeger.get Tr_ID AbTeil fllochbild))
	(setq Anb_Lochb_HT (Traeger.get HTrg  AbTeil fllochbild))
; (debug on)
	(setq lchb_dv_AT 	(Anbauteil.get Anb_Lochb_AT delta_V))
	(setq lchb_dlr_AT 	(Anbauteil.get Anb_Lochb_AT delta_LR))
	(setq lchb_dv_HT 	(Anbauteil.get Anb_Lochb_HT delta_V))
	(setq lchb_dlr_HT 	(Anbauteil.get Anb_Lochb_HT delta_LR))
; (debug off)
;	(Anbauteil.set Anb_Lochb_HT (delta_LR -14.0))

)

(defun setConnection ()
	
	
	(setq CouponBlech (Blech.create))
	(Connect.storeAnschlObjs CastaData CouponBlech)
	(print "CouponBlech-Objekt wurde erzeugt!")
	(createCouponBlech CouponBlech lichterAbst)
	
	(setq fllochbild (Lochbild.create))
	(Connect.storeAnschlObjs CastaData fllochbild)
	
	(createCouponLochbild fllochbild CouponBlech lichterAbst)
	
	
	; TEST
	; ******************************************************************
(if (= LB_DEBUG 1) (progn
	(setq lbdummy (Lochbild.create))
	(Lochbild.copy lbdummy fllochbild)
	
	; Anbauteil dem At hinzufgen
	(if (= (Connect.get CastaData amAtOberflansch) 1)
		(traeger.addabtl Tr_ID lbdummy xPos_at 0.0 _flanschlochbild_of_)	
	)
	(if (= (Connect.get CastaData amAtUnterflansch) 1)
		(traeger.addabtl Tr_ID lbdummy xPos_at 0.0 _flanschlochbild_uf_)
	)
	
	
	(setq AT_ABTeil_dummy (Traeger.get Tr_ID AbTeil lbdummy))
	(Anbauteil.set AT_ABTeil_dummy 	(winkel   winkel_abteil_at)
					(delta_lr		delta_lr_abtl_at)
					(Master    1)
	)
	
	(Connect.storeAnschlObjs CastaData lbdummy)
))
	; ******************************************************************

)



(defun calcAndSetLochbildDaten (Lchb_ID Blech_ID ABST)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID (S_Bez 		"M12")
				(Guete   	"4.6")
				(e       	"0 0 0 0 0 0")
				(w       	"80  0")
	)
	
	(setq t_at 	(Traeger.get Tr_ID t)
				b_at	(Traeger.get Tr_ID b)
				s_at	(Traeger.get Tr_ID s)
				r_at	(Traeger.get Tr_ID r)
	)
	
	(setq t_ht	(Traeger.get Htrg t)
				b_ht	(Traeger.get Htrg b)
				s_ht	(Traeger.get Htrg s)
				r_ht	(Traeger.get Htrg r)
	)
	(setq dp_Bl (Blech.get Blech_ID dp))
	
	; dxSKopf
	(setq dxSKopf 0)
	(setq dxSKopf (+ (* 0.5 b_HT) t_AT dp_Bl))
;	(if (= (Connect.get CastaData amHtStegLinks) 1)  (setq dxSKopf (+ (* 0.5 b_HT) t_AT)))
;	(if (= (Connect.get CastaData amHtStegRechts) 1) (setq dxSKopf (+ (* 0.5 b_HT) t_AT)))
	
	(setq abzug_at (+ s_at (* 2 r_at)))
	(setq rest_at (- b_at abzug_at))
	
	(setq abzug_ht (+ s_ht (* 2 r_ht)))
	(setq rest_ht (- b_ht abzug_ht))
		
	(setq e1 (+ (* 0.5 rest_at) abzug_at))
	(print e1)
	(setq e1rund (runde e1 auf 5))
	(print e1rund)
	(setq e0 (- (* 0.5 e1)))
	(print e0)
	(setq e0rund (runde e0 auf 5))
	(print e0rund)
	(setq w0 (+ (* 0.5 rest_ht) abzug_ht))
	(print w0)
	(setq w0rund (runde w0 auf 5))
	(print w0rund)
	
	(Lochbild.set Lchb_ID	(e0				e0)
				(e1				e1)
				(w0				w0) 	
				(klemml 	(+ dp_Bl t_at))
				(dxSKopf 	 dxSKopf)
	)

	(if (= LB_DEBUG 1)
		(Lochbild.set Lchb_ID	(e2 200))
	)

;	Falls mal halbe Lochbilder eingebaut werden sollen	
;	(setq lb_art (Lochbild.get Lchb_ID Lb_Art))
;	(print lb_art)
	
	(print "<-----------------------------------------------------------")
)




(defun createCouponLochbild (Lchb_ID Blech_ID ABST)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE CouponLOCHBILD")
	
	(calcAndSetLochbildDaten Lchb_ID Blech_ID ABST)
	
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	
	(setq xPos_at (Connect.get CastaData xPos_at))
	(print xPos_at)

	(setq h_HT 	(Traeger.get HTrg h)
	      dv_HT	(Traeger.get HTrg delta_V)
	)

	(calc_XPos_HT);		setzt die Variable xPos_HT

		
	(if (= (Connect.get CastaData amHtStegLinks) 1)  (Traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _couponlochbild_links_))
	(if (= (Connect.get CastaData amHtStegRechts) 1) (Traeger.addabtl HTrg Lchb_ID xPos_ht 0.0 _couponlochbild_rechts_)) 

	
	(if (= (Connect.get CastaData amAtOberflansch) 1)  (traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _flanschlochbild_of_))
	(if (= (Connect.get CastaData amAtUnterflansch) 1) (traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _flanschlochbild_uf_))



	; Winkel Anbauteil AT
	; --------------------------
	(setq winkel_abteil_at 0.0)
	(if (= (Connect.get CastaData AT-von-unten) 1) (setq winkel_abteil_at 180.0))

	; vertikale Verschiebung Anbauteil AT
	; --------------------------
	(setq delta_v_abtl_AT (* -0.5 h_HT))
	(if (= (Connect.get CastaData AT-von-unten) 1) (setq delta_v_abtl_AT (+ delta_v_abtl_AT dv_HT)))

	(if (= (Connect.get CastaData AT-von-oben) 1) (setq delta_v_abtl_AT (+ delta_v_abtl_AT dv_HT)))

	; Winkel Anbauteil HT
	; --------------------------
	(setq winkel_abteil_ht 0.0)
	(setq GlobalWinkel (Connect.get CastaData h-atrgewnkl_flansch))
	(setq WnklDiff (- GlobalWinkel 90.0))
	(if (= (Connect.get CastaData sAtr-lHtr) -1)
		(setq WnklDiff (- WnklDiff))
	)
	(setq winkel_abteil_ht (+ winkel_abteil_ht WnklDiff))
	
	; seitliche Verschiebung des AT
	; --------------------------
	(setq delta_v_abtl_ht 0.0)
	(if (/= (* 1 WnklDiff) 90) (progn
		(setq tan_RWnkl (tan (/ (* PI WnklDiff) 180.0)))
		(if (= (Connect.get CastaData sAtr-lHtr)  1) (setq delta_v_abtl_ht (- (* tan_RWnkl delta_lr_at))))
		(if (= (Connect.get CastaData sAtr-lHtr) -1) (setq delta_v_abtl_ht    (* tan_RWnkl delta_lr_at)))
	))

	; vertikale Verschiebung des HT	
	; --------------------------
	(setq delta_lr_abtl_at 0.0)
	

	; delta_LR_HT aus Rotation der Profile zueinander
	(setq sin_RWnkl (sin (/ (* PI WnklDiff) 180.0)))
	(setq delta_LR_HT (* sin_RWnkl delta_v_abtl_AT))
; (debug on)
	(print delta_LR_HT)
; (debug off)

	
	; HT-Anbauteil Werte setzen
	(setq HT_ABTeil (Traeger.get Htrg AbTeil Lchb_ID))
	(Anbauteil.set HT_ABTeil 	(winkel   winkel_abteil_ht)
				 	(Master   1)
				 	(delta_v  delta_v_abtl_ht)
				 	(delta_lr  delta_LR_HT)
	)
	
	
	
	; AT-Anbauteil Werte setzen
	(setq AT_ABTeil (Traeger.get Tr_ID AbTeil Lchb_ID))
	(Anbauteil.set AT_ABTeil 	(winkel  	winkel_abteil_at)
					(delta_lr	delta_lr_abtl_at)
					(delta_V	delta_v_abtl_AT) 
				 	(Master  	0)
	)

	(if (= (Connect.get CastaData AT-von-oben) 1) (print "AT-von-oben"))
	(LOchbild.set Lchb_ID (LB_Art 2))
	(if (= (Connect.get CastaData sAtr-lHtr) 1)
	  (if (= (Connect.get CastaData AT-von-oben) 1)	   (Anbauteil.set AT_ABTeil 	(SeitRicht  -1)))
	)
	(if (= (Connect.get CastaData sAtr-lHtr) -1)
	  (if (= (Connect.get CastaData AT-von-unten) 1)   (Anbauteil.set AT_ABTeil 	(SeitRicht  -1)))
	)
	
	(print "<-----------------------------------------------------------")
;	...........................................................
)


(defun calcLichtenAbst ()
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "BERECHNE LICHTEN ABSTAND DER TRGER")
	(setq	delta_v_at 	(Traeger.get Tr_ID delta_v)
		h_at		(Traeger.get Tr_ID h)
		t_at		(Traeger.get Tr_ID t)
		QsTyp_AT	(Traeger.get Tr_ID QsForm)
	)
	
	(setq	delta_lr_ht	(Traeger.get Htrg delta_LR)
		b_ht		(Traeger.get Htrg b)
	)
	(if (= QsTyp_AT "F")	(setq h_at t_at))	; Da das Makro speziell fr Flachstahl ist, eigentlich berflssig
	
	
	(setq h_at_halb	(* 0.5 h_at))
	(setq b_ht_halb	(* 0.5 b_ht))
	
	(print delta_lr_ht)
	(print b_ht_halb)
	(print delta_v_at)
	(print h_at_halb)
	
	(setq pos_ht 0.0)
	(setq pos_at 0.0)
	
	(if (= (Connect.get CastaData amHtSteglinks ) 1)	(setq pos_ht (- delta_lr_ht b_ht_halb)))
	(if (= (Connect.get CastaData amHtStegrechts ) 1)	(setq pos_ht (+ delta_lr_ht b_ht_halb)))
	
	(if (= (Connect.get CastaData amHtSteglinks ) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1)	(setq pos_at	(- (- delta_v_at h_at_halb)))	)
			(if (= (Connect.get CastaData amAtUnterflansch) 1)	(setq pos_at	(+ delta_v_at h_at_halb))	)
		)
	)
	(if (= (Connect.get CastaData amHtStegrechts ) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1)	(setq pos_at	(- delta_v_at h_at_halb))	)
			(if (= (Connect.get CastaData amAtUnterflansch) 1)	(setq pos_at	(- (- delta_v_at) h_at_halb))	)
		)
	)
	
	
	(print pos_ht)
	(print pos_at)
	
	(setq lichterAbst 0.0)
	
	(if (/= pos_at pos_ht)
		(setq lichterAbst (- pos_at pos_ht))
	)
	
	(print lichterAbst)
	
	(if (< lichterAbst 0.0)
		(setq lichterAbst (- lichterAbst))
	)
	(print lichterAbst)
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)




(defun calcCouponBlech (BLECH_ID ABST)
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "BERECHNE CouponBlechDATEN")
	(setq b_at		(Traeger.get Tr_ID b))
	
	(setq h_ht		(Traeger.get Htrg h)
	      s_ht		(Traeger.get Htrg s)
	)

	; Abstand von der Trger-OK
	(setq dOK_Bl 5)		; const eingestellt

	; CouponBlechdicke
	(setq dp_futter ABST)
	
	; Breite
	(setq bp_futter b_at)
	
	; Hhe	
	(setq hp_futter h_ht)

	(setq hp_Futter (- hp_Futter dOK_Bl dOK_Bl))
	(Blech.set BLECH_ID	(hp hp_futter)
				(bp bp_futter)
				(dp dp_futter)
				(dOK dOK_Bl)
	)
	
	
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)



(defun createCouponBlech (BLECH_ID ABST)
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "ERZEUGE CouponBlech")
	(calcCouponBlech BLECH_ID ABST)
	
	(calc_XPos_HT)	; setzt die Variable xPos_HT
	(if (= (Connect.get CastaData amHtStegLinks)  1)	(Traeger.addabtl Htrg BLECH_ID xPos_HT 0.0 _blechcoupon_links_))
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(Traeger.addabtl Htrg BLECH_ID xPos_HT 0.0 _blechcoupon_rechts_))

	
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)





(defun calc_XPos_HT ()
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	(setq dlr_AT (Traeger.get Tr_ID delta_LR))
	(if (= (Connect.get CastaData sAtr-lHtr)  1)  (setq xPos_ht (+ xPos_ht dlr_AT)))
	(if (= (Connect.get CastaData sAtr-lHtr) -1)  (setq xPos_ht (- xPos_ht dlr_AT)))
)
