; $	G(61)	HT	 QT(FL)	 	AF(F)		P(EZ)
; $	G(61)	AT	 QT(FL) 	AF(F)		P(EZ)
; $	G(61)	AE	 V(-)		H(-)		R(-)
; $			HT	QT(FL)		AF(FS)		P(ZE)
; $			AT	QT(FL)		AF(F)		P(ZE)
; $			AE	V(0)		H(75-105)		R(-)

(defun load-modules ()
	(load "mod-endinit-trg-auf-trg")
)

(defun init-connection ()
	(print "*clear*")
	(print "Anschluss fr kreuzende Profile")
	(connect.showattributes CastaData)
	(print "---------------------- +++ ------------------------------ +++ --------------------")

	(setq HT_UFlansch_an_AT_Flansch 0)
	(if (= (Connect.get CastaData amhtunterflansch  ) 1) (progn
		(if (= (Connect.get CastaData amatunterflansch ) 1) (setq HT_UFlansch_an_AT_Flansch 1))
		(if (= (Connect.get CastaData amatoberflansch ) 1)  (setq HT_UFlansch_an_AT_Flansch 1))
	))
	(setq HT_StegLinks_an_AT_Flansch 0)
	(if (= (Connect.get CastaData amhtStegLinks) 1) (progn
		(if (= (Connect.get CastaData amatunterflansch ) 1) (setq HT_StegLinks_an_AT_Flansch 1))
		(if (= (Connect.get CastaData amatoberflansch ) 1)  (setq HT_StegLinks_an_AT_Flansch 1))
	))

	(setq Makro_ausgefuehrt 0)
	(if (= HT_UFlansch_an_AT_Flansch 1) (progn
		(setq Makro_ausgefuehrt 1)
		(createConn_Flansch_an_Flansch)
	))
	(if (= HT_StegLinks_an_AT_Flansch 1) (progn
		(setq Makro_ausgefuehrt 1)
		(createConn_Steg_an_Flansch)
	))
	
	(if (= Makro_ausgefuehrt 0) (AlertBox "Makro wurde nicht ausgefhrt"))
)

(defun setConnection ()
	(print "Anschluss durchfhren")
)

; -----------------------------------------------------------------------------------------------
(defun initLochbild_FlV (Lchb_ID KlemmLaenge)
	(setq AT_LchbWinkel (Connect.get CastaData h-atrgewnkl_steg))
	(setq AT_LchbWinkel (- AT_LchbWinkel 90.0))
	(setq sin_AW (sin (/ (* PI AT_LchbWinkel) 180.0)))
	(setq cos_AW (cos (/ (* PI AT_LchbWinkel) 180.0)))
	(setq tan_AW (tan (/ (* PI AT_LchbWinkel) 180.0)))
	(if (< tan_AW 0.0) (setq tan_AW (- tan_AW)))
	
	(Lochbild.set Lchb_ID
		(S_Bez "M16")
		(Guete "4.6")
		(e "0 0 0 0 0 0")
		(w "0 0 0 0")
		(LB_Art 2)
		(KlemmL KlemmLaenge)
	)

	(setq b_HT 0)
	(if (=	HT_UFlansch_an_AT_Flansch  1)  (setq b_HT (Traeger.get HTrg b)))
	(if (=	HT_StegLinks_an_AT_Flansch 1)  (setq b_HT (Traeger.get HTrg h)))
	
	(setq b_AT (Traeger.get Tr_ID b))
	(setq b4 (/ b_AT 4))
	(Lochbild.set Lchb_ID
		(w "0 0 0 0")
		(w0 (/ b_HT 2))
		(e "0 0 0  0 0 0")
		(e0 (- b4))
		(e1 (* 2 b4))
	)
	
	; (Lochbild.set Lchb_ID (e "0 25 65 0 0 0") (w "0 35"))
	
)

(defun createConn_Flansch_an_Flansch ()
	(print "Anschluss Flansch-an-Flansch -----------------------------------------------------------------")
	(print "----------------------------------------------------------------------------------------------")
	(setq xPos_AT (Connect.get CastaData xPos_AT))
	(setq xPos_HT (Connect.get CastaData xPos_HT))

	; -----------------------------
	(setq s_HT (Traeger.get HTrg  t)
		  s_AT (Traeger.get Tr_ID t)
		  KlemmLaenge (+ s_HT s_AT)
	)
	
	(setq Lchb_ID (lochbild.create))
	(initLochbild_FlV Lchb_ID KlemmLaenge)
	(Connect.storeAnschlObjs CastaData Lchb_ID)

	(setq dlr_HT (Traeger.get HTrg  delta_LR))
	(setq dlr_AT (Traeger.get Tr_ID delta_LR))
	(setq dlv_Lchb_AT 0.0)
	(setq dlr_Lchb_AT 0.0)
	
	(setq SR_AT 0)
	(setq SR_HT 0)
	(setq HT_LchbWinkel 0.0)
	(setq AT_LchbWinkel (Connect.get CastaData h-atrgewnkl_steg))
	
	(setq Fall 0)
	(if (= (Connect.get CastaData at-von-rechts) 1) (progn
		; (if (>= AT_LchbWinkel 90.0) (setq AT_LchbWinkel (-  AT_LchbWinkel 180.0)))
		(setq HT_LchbWinkel 180.0)
		(print "at-von-rechts") (print HT_LchbWinkel) (print AT_LchbWinkel) 

		(if (= (Connect.get CastaData satr-lhtr) 1) (progn
			(setq Fall 1)
			; (setq HT_LchbWinkel 180.0)
			(setq SR_AT -1)
			(setq SR_HT -1)
			(setq dlv_Lchb_AT (- dlr_AT))	; vertikale Verschiebung der Fuleiste (lokal seitlich)
			(setq dlr_Lchb_AT dlr_HT)		; seitliche Verschiebung des HT
		))
		(if (= (Connect.get CastaData satr-lhtr) -1) (progn
			(setq Fall 2)
			(setq AT_LchbWinkel (- AT_LchbWinkel 180.0))
			(setq SR_AT  1)
			(setq SR_HT -1)
			(setq dlv_Lchb_AT dlr_AT)		; vertikale Verschiebung der Fuleiste (lokal seitlich)
			(setq dlr_Lchb_AT (- dlr_HT))	; seitliche Verschiebung des HT
		))

	))
	(if (= (Connect.get CastaData at-von-links) 1) (progn
		; (setq AT_LchbWinkel (+  AT_LchbWinkel 180.0))
		; (if (>= AT_LchbWinkel 360.0) (setq AT_LchbWinkel (-  AT_LchbWinkel 360.0)))
		(setq HT_LchbWinkel 180.0)
		
		(if (= (Connect.get CastaData satr-lhtr) 1) (progn
			(setq Fall 3)
			(setq SR_AT 1)
			(setq SR_HT -1)
			(setq dlv_Lchb_AT (- dlr_AT))	; seitliche Verschiebung des HT
			(setq dlr_Lchb_AT (- dlr_HT))	; seitliche Verschiebung des HT
		))
		(if (= (Connect.get CastaData satr-lhtr) -1) (progn
			(setq Fall 4)
			(setq AT_LchbWinkel (- AT_LchbWinkel 180.0))
			(setq SR_AT -1)
			(setq SR_HT -1)
			(setq dlv_Lchb_AT dlr_AT)
			(setq dlr_Lchb_AT dlr_HT)		; seitliche Verschiebung des HT
		))
		
		(print "at-von-links") (print HT_LchbWinkel) (print AT_LchbWinkel) 
	))
	
	(print Fall)
	
	(traeger.addabtl Tr_ID Lchb_ID xPos_AT AT_LchbWinkel	 _flanschlochbild_uf_)
	(traeger.addabtl HTrg Lchb_ID  xPos_HT HT_LchbWinkel     _flanschlochbild_uf_)
	
	(setq Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil Lchb_ID))
	(setq Abtl_Lchb_HT (Traeger.get HTrg  ABTeil Lchb_ID))
	
	(print SR_AT) (print SR_HT)

	(Anbauteil.set Abtl_Lchb_AT (Master 0) (SeitRicht  SR_AT))
	(Anbauteil.set Abtl_Lchb_HT (Master 1) (SeitRicht  SR_HT))
	
	; -------------------------------
	(setq sinW (sin (/ (* PI AT_LchbWinkel) 180.0)))
	(setq cosW (cos (/ (* PI AT_LchbWinkel) 180.0)))
	(setq tanW (tan (/ (* PI AT_LchbWinkel) 180.0)))

	(Anbauteil.set Abtl_Lchb_HT (delta_V   dlv_Lchb_AT)	(delta_LR   0.0))
	(Anbauteil.set Abtl_Lchb_AT (delta_V   0.0) 		(delta_LR   dlr_Lchb_AT))

	
)


(defun createConn_Steg_an_Flansch ()
	(print "Anschluss Steg-an-Fuleiste -----------------------------------------------------------------")
	(print "----------------------------------------------------------------------------------------------")
	(setq xPos_AT (Connect.get CastaData xPos_AT))
	(setq xPos_HT (Connect.get CastaData xPos_HT))

	; -----------------------------
	(setq s_HT (Traeger.get HTrg  t)
		  s_AT (Traeger.get Tr_ID t)
		  KlemmLaenge (+ s_HT s_AT)
	)
	
	(setq Lchb_ID (lochbild.create))
	(initLochbild_FlV Lchb_ID KlemmLaenge)
	(Connect.storeAnschlObjs CastaData Lchb_ID)

	(setq dlr_AT (Traeger.get Tr_ID delta_LR))
	(setq dv_HT  (Traeger.get HTrg  delta_V))
	(setq dlv_Lchb_AT 0.0)
	(setq dlr_Lchb_AT 0.0)
	
	(setq SR_AT 0)
	(setq SR_HT 0)
	(setq HT_LchbWinkel 0.0)
	(setq AT_LchbWinkel (Connect.get CastaData r-atrgewnkl_steg))
	
	(setq Fall 0)
	(if (= (Connect.get CastaData at-von-oben) 1) (progn
		; (if (>= AT_LchbWinkel 90.0) (setq AT_LchbWinkel (-  AT_LchbWinkel 180.0)))
		(setq HT_LchbWinkel 180.0)
		(print "at-von-rechts") (print HT_LchbWinkel) (print AT_LchbWinkel) 

		(if (= (Connect.get CastaData satr-lhtr) 1) (progn
			(setq Fall 1)
			; (setq HT_LchbWinkel 180.0)
			(setq SR_AT  1)
			(setq SR_HT -1)
			(setq dlv_Lchb_AT (- dlr_AT))
			(setq dlr_Lchb_AT (- dv_HT))	; Vertikalverschiebung des Pfostens
		))
		(if (= (Connect.get CastaData satr-lhtr) -1) (progn
			(setq Fall 2)
			(setq AT_LchbWinkel (- AT_LchbWinkel 180.0))
			(setq SR_AT -1)
			(setq SR_HT -1)
			(setq dlv_Lchb_AT dlr_AT)
			(setq dlr_Lchb_AT dv_HT)	; Vertikalverschiebung des Pfostens
		))

	))
	(if (= (Connect.get CastaData at-von-unten) 1) (progn
		; (setq AT_LchbWinkel (+  AT_LchbWinkel 180.0))
		; (if (>= AT_LchbWinkel 360.0) (setq AT_LchbWinkel (-  AT_LchbWinkel 360.0)))
		(setq HT_LchbWinkel 180.0)
		
		(if (= (Connect.get CastaData satr-lhtr) 1) (progn
			(setq Fall 3)
			(setq SR_AT -1)
			(setq SR_HT -1)
			(setq dlv_Lchb_AT (- dlr_AT))
			(setq dlr_Lchb_AT dv_HT)	; Vertikalverschiebung des Pfostens
		))
		(if (= (Connect.get CastaData satr-lhtr) -1) (progn
			(setq Fall 4)
			(setq AT_LchbWinkel (- AT_LchbWinkel 180.0))
			(setq SR_AT  1)
			(setq SR_HT -1)
			(setq dlv_Lchb_AT dlr_AT)		; Vertikalverschiebung der Fuleiste (rechts-links)
			(setq dlr_Lchb_AT (- dv_HT))	; Vertikalverschiebung des Pfostens
		))
		
		(print "at-von-links") (print HT_LchbWinkel) (print AT_LchbWinkel) 
	))
	
	(print Fall)

	(traeger.addabtl Tr_ID Lchb_ID xPos_AT AT_LchbWinkel	 _flanschlochbild_uf_)
	(traeger.addabtl HTrg Lchb_ID  xPos_HT HT_LchbWinkel     _steglochbild_system_)
	
	(setq Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil Lchb_ID))
	(setq Abtl_Lchb_HT (Traeger.get HTrg  ABTeil Lchb_ID))
	
	(print SR_AT) (print SR_HT)

	(Anbauteil.set Abtl_Lchb_AT (Master 1) (SeitRicht  SR_AT))
	(Anbauteil.set Abtl_Lchb_HT (Master 0) (SeitRicht  SR_HT))
	
	; -------------------------------
	(setq sinW (sin (/ (* PI AT_LchbWinkel) 180.0)))
	(setq cosW (cos (/ (* PI AT_LchbWinkel) 180.0)))
	(setq tanW (tan (/ (* PI AT_LchbWinkel) 180.0)))

	(Anbauteil.set Abtl_Lchb_HT (delta_V   dlv_Lchb_AT)	(delta_LR   0.0))
	(Anbauteil.set Abtl_Lchb_AT (delta_V   0.0) 		(delta_LR   dlr_Lchb_AT))
	
)
