; $	HT	QT(RK)		AF(FS)		P(EZ)
; $	AT	QT(F)		AF(K)		P(E)
; $	AE	V(-)		H(-)		R(-)

(defun load-modules ()
	; Profil prfen
	(setq qsform_at (Traeger.get Tr_ID qsform))
  (print qsform_at)
  
  (if (= qsform_at "L")	(load "mod-calc-windverband_L"))
  (if (= qsform_at "F")	(load "mod-calc-windverband_F"))
  (if (= qsform_at "U") (alertBox "Anschluss noch nicht mglich." "Connection_Not_Possible_Yet"));
  (if (= qsform_at "I") (alertBox "Anschluss noch nicht mglich."  "Connection_Not_Possible_Yet"));
  (if (= qsform_at "R") (load "mod-calc-windverband_R"));
  (if (= qsform_at "K") (alertBox "Anschluss noch nicht mglich."  "Connection_Not_Possible_Yet"));
  
  (load "mod-lochbild")
)

(defun init-connection ()
	(print "********************************************************************")
  (print "in init-connection - stz_Windverb_1");
   
  (connect.ShowAttributes CastaData)

  ; neu eingebaut - Sept 2011 
  (setq AnschlussAusfuehren 1)
  (setq qsform_Ht (Traeger.get HTrg qsform))
  (if (= qsform_Ht "R") (Untersuchung_AnschlMoegl))
 
  (setq K-Verband 0)
    
  (setq l_schr 200)
  (setq parallel_abstand_stz 30)
  (setq rand_abst 10)

	
	(setq STD 0)
  (if (= AnschlussAusfuehren 1) (progn
	
	(if (= qsform_at "R")
		(rProf)
	)
	(if (= qsform_at "F")
		(fProf)
	)
	(if (= qsform_at "L")
		(progn
			(init-windverband)
		
			; CALLBACKS
			(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
		)
	)

	(if (= qsform_Ht "R") (Untersuchung_Knbl_Aussmitte))


	; ------------- Test-Szenario
	(if (= 1 2) (progn
		(print "*clear*")
	  	(setq AbtlKnoBlLchbAT    (Traeger.get Tr_ID AbTeil knblLochbild))
	  	(setq AbtlKnoBlLchbHT    (Traeger.get HTrg  AbTeil knblLochbild))
	  	
	  	(Anbauteil.set AbtlKnoBlLchbAT (Master 0))
	  	(Anbauteil.set AbtlKnoBlLchbHT (Master 1))
	 	
	  	(Lochbild.set knblLochbild (delta_w    20))
	 	(Lochbild.set knblLochbild (w0         10))
	 	(Lochbild.set knblLochbild (e1         100) (e2 20))
	  	; (Lochbild.set knblLochbild (lb_art 0))
	
		(print "Check-Seitenrichtungen")  	
	  	(setq SeitRichtung_AT (Anbauteil.get AbtlKnoBlLchbAT SeitRicht))
	  	(print SeitRichtung_AT)
	  	(setq SeitRichtung_HT (Anbauteil.get AbtlKnoBlLchbHT SeitRicht))
	  	(print SeitRichtung_HT)
	  	
	 ; 	(Anbauteil.set AbtlKnoBlLchbHT (SeitRicht  -1))
	
		(setq LB_Art (Lochbild.get knblLochbild LB_Art))
		(print LB_Art)
		
	))
  ))
	
)
; --- ergnzt Sept. 2011 fr Anschlsse an Rohre als Haupttrger
(defun Untersuchung_AnschlMoegl ()
    (if (= (Connect.get CastaData amHtSteg) 1) (progn
	(setq EbenenWinkel (Connect.get CastaData afl_VWinkel))
	(if (/= EbenenWinkel 90.0) (setq AnschlussAusfuehren 0))
	(if (= AnschlussAusfuehren 0) (progn
	    (if (> EbenenWinkel 85.5) (if (< EbenenWinkel 90.5) (setq AnschlussAusfuehren 1)))
	))
    ))
    (if (= (Connect.get CastaData amHtFlansch) 1) (progn
	(setq EbenenWinkel (Connect.get CastaData afl_HWinkel))
	(if (/= EbenenWinkel 0.0) (setq AnschlussAusfuehren 0))
	(if (= AnschlussAusfuehren 0) (progn
	    (if (> EbenenWinkel -0.5) (if (< EbenenWinkel 0.5) (setq AnschlussAusfuehren 1)))
	))
    ))
    (if (= AnschlussAusfuehren 0) (AlertBox "Anschluss wird nicht erstellt!\nDer Winkel in der Windverbandsebene ist unpassend."  "ERR_AngleInPlaneProblem"))
)
(defun Untersuchung_Knbl_Aussmitte ()
   (if (objExist knotenBlech) (progn
      (setq	h_HT	(Traeger.get HTrg h)
		r	(/ h_HT 2.0)
		a	(Blech.get knotenBlech delta_LR)
		dp	(Blech.get knotenBlech dp)
		a1	(- a (* 0.5 dp))
		a2	(+ a (* 0.5 dp))
      )
      (setq	x1	(- r (sqrt (- (* r r) (* a1 a1)))))
      (setq	x2	(- r (sqrt (- (* r r) (* a2 a2)))))
      
      (if (< x1 x2) (progn
          (if (>= x1 1.0) (WarnMeldung_Ausmitte x2))
      ))
      (if (< x2 x1) (progn
          (if (>= x2 1.0) (WarnMeldung_Ausmitte x1))
      ))
   ))
)
(defun WarnMeldung_Ausmitte (klaffende_Fuge)
  (alertBox "Achtung!!\n\nDurch die ausmittige Lage des Knotenblechs ist ein Spalt von 1mm der nahen Kante zu verzeichnen!\nBitte beachten Sie die klaffende Fuge - durch Schweinaht zu verschlieen." "NOTE_GapToClose")
  (alertBox klaffende_Fuge)
)


; ----------------------------------------------------------------------------------------
(defun rProf ()
	
	(setq delta_v_at 	(Traeger.get Tr_ID delta_v))
	(setq delta_lr_at	(Traeger.get Tr_ID delta_lr))
	
	(if (= (Connect.get CastaData satr-lhtr) 0)
		(progn
			(Traeger.set Tr_ID (r_winkel 90.0))
			(alertBox "Die Orientierung des Anschlusstrgers wird durch das Programm angepasst. Bitte wiederholen Sie nun Ihre Eingabe." "NOTE_BracingBeamRotationCorrection")
		)
		(progn
			(if (= (Connect.get CastaData amHtFlansch) 1)
				(progn
					(if (/= (Connect.get CastaData satr-vhtr) 0)
						(progn
							(if (/= (Connect.get CastaData vatr-shtr) 0)
								(progn 
									(init-windverband)
									; CALLBACKS
									(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
									(Blech.set augenBlech 	(formFkt "cb_augenBlech"))
								)
								(alertBox "Bitte passen Sie die rel. Lage des Anschlusstrgers dem Haupttrger an."  "WRN_SetReltaiveDispl")
							)
						)
						(progn
							(if (/= (Connect.get CastaData vatr-shtr) 0)
								(progn 
									(init-windverband)
									; CALLBACKS
									(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
									(Blech.set augenBlech 	(formFkt "cb_augenBlech"))
								)
								(alertBox "Bitte passen Sie die rel. Lage des Anschlusstrgers dem Haupttrger an." "WRN_SetReltaiveDispl")
							)
						)
					)
				)
			)
			(if (= (Connect.get CastaData amHtSteg) 1)
				(progn
					(if (/= (Connect.get CastaData vatr-vhtr) 0)
						(progn
							(init-windverband)
							; CALLBACKS
							(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
							(Blech.set augenBlech 	(formFkt "cb_augenBlech"))
						)		
					)
				)
			)
		)
	)
	
	
)


; ----------------------------------------------------------------------------------------
(defun fProf ()
	
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (/= (Connect.get CastaData satr-shtr) 0)
				(progn
					(alertBox "Anschluss nicht mglich! Bitte rotieren Sie den Anschlusstrger um 90."  "ERR_Rotate_AT_90")
				)
				(progn
					(init-windverband)
					
					; CALLBACKS
					(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
				)
			)
		)
	)
			
	(if (= (Connect.get CastaData amHtSteg) 1) (progn
		(if (/= (Connect.get CastaData satr-vhtr) 0) (progn
				(alertBox "Anschluss nicht mglich! Bitte rotieren Sie den Anschlusstrger um 90."  "ERR_Rotate_AT_90")
			)
			(progn
				(init-windverband)
				; CALLBACKS
				(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
			)
		)
	))
	
	; speziell fr Anforderung - Blech- und Schraubengren
	(setq dpBlech 8)
	
	(Blech.set knotenBlech (bp 50) (hp 50) (dp dpBlech))
	(Blech.set knotenBlech (x1 0) (x2 0) (x3 0) (x4 0))
	(Blech.set knotenBlech (y1 0) (y2 0) (y3 0) (y4 0))
	
	(setq h_HT (Traeger.get HTrg h))
	(setq t_AT (Traeger.get Tr_ID t))
	(setq Klemmlaenge 0)			; Schrauben als nicht zu zhlen eintragen
	(setq e0_Fix 35)
	(if (>= h_HT 40) (progn
		(setq Klemmlaenge (+ t_AT dpBlech))
		(setq e0_Fix 35)
	))
	(Lochbild.set knblLochbild (S_Bez "M12") (e0 35) (e1 0) (e2 0) (KlemmL Klemmlaenge))
	
	
	(setq Dl_Flach (* 0.5 h_HT))	; Da Rohr als HT ist es egal, ob B oder H verwendet werden msste
	(if (Connect.get CastaData linkesEnde) (progn
		(setq TEnde (Traeger.get Tr_ID links))
		(TrEnde.set TEnde (delta_L Dl_Flach))
	))
	(if (Connect.get CastaData rechtesEnde) (progn
		(setq TEnde (Traeger.get Tr_ID rechts))
		(TrEnde.set TEnde (delta_L Dl_Flach))
	))
			
)



; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Knotenblech am HT
; ----------------------------------------------------------------------------------------
(defun cb_knotenBlech (zp)
	(print "in Callback-Funktion cb_knotenBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt 				(Blech.get knotenBlech dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get knotenBlech dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
					(setq dpDiff (- dpNeu dpAlt))
					(setq alteKlemml 		(Lochbild.get knblLochbild Klemml)
								altesDxSKopf	(Lochbild.get knblLochbild dxSKopf)
					)
					
					(setq delta_lr_Alt 	(Blech.get knotenBlech delta_lr))
					
					(setq qsform_at (Traeger.get Tr_ID qsform))
					
					; Flachstahl
					; --------------------------------------
					(if (= qsform_at "F")
						(progn
							(print "Flachstahl-Profil")
							(Lochbild.set knblLochbild 	(Klemml 	(+ alteKlemml dpDiff)))
							
							(if (= (Connect.get CastaData satr-lhtr)  1)
								(progn
									(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
								)
							)
							(if (= (Connect.get CastaData satr-lhtr) -1)	
								(progn
									(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
									(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
								)
							)
						)
					)
					
					
					; Winkelprofil
					; --------------------------------------
					(if (= qsform_at "L")
						(progn
							(print "Winkel-Profil")
							(Lochbild.set knblLochbild 	(Klemml 	(+ alteKlemml dpDiff))
																					;(dxsKopf	(+ altesDxSKopf (* 0.5 dpDiff)))
							)
							
							(Connect.showAttributes CastaData)
							
							; HT STEG
							; ----------------------------------
							(if (= (Connect.get CastaData amHtSteg) 1)
								(progn
									(if (= (Connect.get CastaData vatr-vhtr)  1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
											(if (= (Connect.get CastaData satr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
										)
									)
									(if (= (Connect.get CastaData vatr-vhtr) -1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr) -1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
											(if (= (Connect.get CastaData satr-lhtr)  1)
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
										)
									)
									(if (= (Connect.get CastaData satr-vhtr)  1)
										(progn
											(if (= (Connect.get CastaData vatr-lhtr) -1)
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
											(if (= (Connect.get CastaData vatr-lhtr)  1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
										)
									)
									(if (= (Connect.get CastaData satr-vhtr) -1)
										(progn
											(if (= (Connect.get CastaData vatr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
											(if (= (Connect.get CastaData vatr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
										)
									)
								)
							)
			
							
							; HT FLANSCH
							; ----------------------------------
							(if (= (Connect.get CastaData amHtFlansch) 1)
								(progn
									(if (= (Connect.get CastaData vatr-shtr)  1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
											(if (= (Connect.get CastaData satr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
										)
									)
									(if (= (Connect.get CastaData vatr-shtr) -1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr) -1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
											(if (= (Connect.get CastaData satr-lhtr)  1)
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
										)
									)
									(if (= (Connect.get CastaData satr-shtr)  1)
										(progn
											(if (= (Connect.get CastaData vatr-lhtr) -1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
											(if (= (Connect.get CastaData vatr-lhtr)  1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
										)
									)
									(if (= (Connect.get CastaData satr-shtr) -1)
										(progn
											(if (= (Connect.get CastaData vatr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
											(if (= (Connect.get CastaData vatr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
										)
									)
								)
							)
							
						)
					)
							
					; Rundstahl
					; --------------------------------------
					(if (= qsform_at "R")
						(progn
							(print "Rundstahl-Profil")
							(Lochbild.set knblLochbild 	(Klemml 	(+ alteKlemml dpDiff))
																					;(dxsKopf	(+ altesDxSKopf (* 0.5 dpDiff)))
							)
							
							(if (= (Connect.get CastaData satr-lhtr)  1)
								(progn
									(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
								)
							)
							(if (= (Connect.get CastaData satr-lhtr) -1)	
								(progn
									(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
									(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
								)
							)
						)
					)	
					
					
	    ))
	))
)


; ----------------------------------------------------------------------------------------
; Callback fr die Augenlasche bei Rundprofilen
; ----------------------------------------------------------------------------------------
(defun cb_augenBlech (zp)
	(print "in Callback-Funktion cb_augenBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get augenBlech dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get augenBlech dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
					(setq dpDiff (- dpNeu dpAlt))
					(setq alteKlemml 		(Lochbild.get knblLochbild Klemml)
								altesDxSKopf	(Lochbild.get knblLochbild dxSKopf)
					)
					(print altesDxSKopf)
					
					(setq delta_lr_Alt 	(Blech.get knotenBlech delta_lr))
					
					(setq qsform_at (Traeger.get Tr_ID qsform))
					
					
					(Lochbild.set knblLochbild 	(Klemml 	(+ alteKlemml dpDiff))
																			(dxsKopf	(+ altesDxSKopf (* 0.5 dpDiff)))
					)
						
					
					(if (= (Connect.get CastaData satr-lhtr)  1)
						(progn
							(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
						)
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)	
						(progn
							(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
						)
					)
	    ))
	))
)






