; $ HT		QT(Rd)	AF(K)		P(E)
; $ AT		QT(Rd)	AF(K)		P(E)
; $ AE		V(-)			H(-)		R(-)

(defun load-modules ()
;	(load "mod-endinit-uz_auf_stzKopf")
)


(defun init-connection ()

    (print "*clear*")
	(print "Start ... horizontal liegendes Gelnder ................................................................................")
	(Connect.showAttributes CastaData)

	(setq OK_For_Makro 1)
    (setq VarConfigFile "GelaenderRohrbogenSettings.lsp")
    
    (setq biegeRadius 120.00)		; Bogenradius - Default
    (loadConfig VarConfigFile)		; Letzte Werte einladen

    (setq CopyMode (Connect.get CastaData CopyMode))
	; (AlertBox CopyMode)
	
	; ----------------- Develop-Modus Start
	; (if (= CopyMode 0) (progn
	;	(setq CopyMode 1)																; damit Dialog ausbleibt
	;	(setq biegeRadius 200.00)														; Bogenradius - Default
	;	(setq OK_For_Makro 1)															; Makro durchlaufen
	; ))
	; ----------------- Develop-Modus Ende
	; (setq CopyMode 1)
	
    (if (= CopyMode 0) (progn
	    (Connect.createDialog    CastaData)
	    (Connect.storedialogctrl CastaData   "Radius Rohrbogen", "d", "biegeRadius", biegeRadius)
	    (Connect.OpenDialog      CastaData  "RohrbogenRadius.bmp")

		(setq sysLng (Traeger.get HTrg Laenge))
		
		(if (> biegeRadius sysLng) (setq OK_For_Makro 0))
		(setq sysLng (Traeger.get Tr_ID Laenge))
		(if (> biegeRadius sysLng) (setq OK_For_Makro 0))
	))

	(set_VerbindungsTyp)																	; Handlauf-Handlauf, oder Pfosten an Handlauf, oder allgemein
	(set_HT_VertikalFlag)
;	(if (= HT_Ist_vertikal 0) (progn
;		(print "hier war vorher ein Ausschlusskriterium")
;	))

	; Wenn Profile sich nicht treffen - durch Seitversatz aneinander vorbeilaufen
	; (if (= CopyMode 1) (setq OK_For_Makro 3)) 								; nichts tun, auch keine Meldung - Anschluss kann nicht kopiert werden.
	
	; -- eventuell hier Makro-Ausstieg, auer, wenn die Trger sich zentrisch treffen
	(if (= (Connect.get CastaData amatflansch) 0) (progn
		(if (= (Connect.get CastaData amatsteg) 0) (setq  OK_For_Makro 4))
	))

	; Zentrisch kann immer angeschlossen werden
	(setq dlr_AT (Traeger.get Tr_ID delta_LR))
	(setq dv_AT (Traeger.get Tr_ID delta_V))
	(setq dlr_HT (Traeger.get HTrg delta_LR))
	(setq dv_HT (Traeger.get HTrg delta_V))
	(if (= dlr_AT 0) (if (= dv_AT 0) (if (= dlr_HT 0) (if (= dv_HT 0) (setq OK_For_Makro 1)))))
	
	
    (if (= OK_For_Makro 1) (progn
    
		(init_TrgEnden)
	
	    (setq RohrBogen (Traeger.create))
	    (setq  ATr_Profil (Traeger.get Tr_ID Profil))
	    (Traeger.set RohrBogen (Profil ATr_Profil))
	    
	    (calc_Bogenstich)

	    (setq RohrProfil_Laenge (Traeger.get RohrBogen Laenge))
	    (setq RohrProfil_SysLng (Traeger.get RohrBogen SysLng))
	    (print RohrProfil_Laenge)
	    (print RohrProfil_SysLng)

		(CreateBogenProfil)

		(print  RWinkel)
		(print f_stich)
		(print dlr_Bogen)

		
    ))
    (if (= OK_For_Makro 0) (progn
		(if (= CopyMode 0) (progn
			(AlertBox "Bogenradius ist zu gro - Makro gestoppt!"  "ERR_ArcRadius")
		))
	))
    (if (= OK_For_Makro 4) (progn
		(if (= CopyMode 0) (progn
			(AlertBox  "Profile treffen sich nicht!\n\nBeams do not intersect!")
		))
	))

	(if (= OK_For_Makro 1) (progn
		(writeConfig VarConfigFile biegeRadius)

		(print_AnalyseValues)
	))
)
; ------------------------------------------------------------------------------------------------------- Bogenstich berechnen
; gehen wir erst einmal von einer 90-Verbindunge aus ...
(defun	calc_Bogenstich ()
    (setq beta 0.0)  			; ffnungswinkel
	(setq  oeffWinkel 0.0)
	(setq kopfWinkel 0.0)
	
; (debug on)

	; hier jetzt zentral ohne groe Umrechnung
	(setq OeffnungsWinkel (Connect.get CastaData OeffnungsWinkel))
	(setq bStichFaktor -1)
	(if (< OeffnungsWinkel 0.0) (progn
		(AlertBox "fnungswinkel < 0")
		(setq bStichFaktor 1)
		(setq OeffnungsWinkel (- OeffnungsWinkel))
	))


		(print "--------------------------------")
		(print   OeffnungsWinkel)
    	(print "----------------------------------------------")

    ; fr die Bogenstichberechnung verwende ich jetzt OeffnungsWinkel
    (setq radWnk (* (/ PI 180.0) (- 90.0 (/ OeffnungsWinkel 2.0))))
    (setq lng (* 2.0 biegeRadius (sin radWnk)))
    (setq f_stich (- biegeRadius (* biegeRadius (cos radWnk))))
	(if (= bStichFaktor -1) (setq f_stich (- f_stich)))
	
	; ------------------ wei nicht warum - mal zum Testen generell negativ setzen
	; (if (= (Connect.get CastaData amAtUnterflansch) 1) (setq f_stich (- f_stich)))

	
	(calc_EndeVerbindung)		; ermittelt  EndeVerbindung = "LL" / ""RR" / "LR" / "RL" in der Reihenfolhe HT AT

	; Initialisieren des Rotationswinkels des Rohrbogens
    (setq RWinkel 0.0)

	(setq Fall_Behandlung 0)
	; Anschluss am Steg des Haupttrgers -----------------


	(print f_stich)
	(print   RWinkel)
	(print "++++++++++++++++++++++++++++++++++++++++++++++++++++")
	; (Connect.showAttributes CastaData)
	; (setq RWinkel 180.0)
	(setq RWinkel (Connect.get CastaData Join_Rotation))
	(print "- neu - direkt abgefragter Rotationswinkel ----") (print RWinkel)
	
 
    (Traeger.set  RohrBogen 
    				(SysLng		lng)
    				(Laenge		lng)
    				(BogenStich_V f_stich)
    				(R_Winkel       RWinkel)
    )

	
	
(print "--------------------------")
    (setq RohrProfil_Laenge (Traeger.get RohrBogen Laenge))
    (setq RohrProfil_SysLng (Traeger.get RohrBogen SysLng))
    (print RohrProfil_Laenge)
    (print RohrProfil_SysLng)
(print "--------------------------")


	(setq xPos (* 0.5 lng))	; nur um nicht auf einen Fehler hinauszulaufen
	(if (/= (cos radWnk) 0.0)    (setq xPos (/ lng (* 2.0 (cos radWnk)))))

	(setq l_HTrg (Traeger.get HTrg SysLng))
	(if (= (Connect.get CastaData anhtlinkesende) 1) 
		(progn
			(setq tEnde (Traeger.get HTrg links))
			(TrEnde.set tEnde (Delta_L xPos) (V_Winkel 90.0))
			(setq xPos_HTrg xPos)
		)
		(progn
			(setq tEnde (Traeger.get HTrg rechts))
			(TrEnde.set tEnde (Delta_L xPos) (V_Winkel 90.0))
			(setq xPos_HTrg (- l_HTrg xPos))
		)
	)
		(setq l_ATrg (Traeger.get Tr_ID SysLng))
		(if (= (Connect.get CastaData linkesende) 1) 
			(progn
				(setq tEnde (Traeger.get Tr_ID links))
				(TrEnde.set tEnde (Delta_L xPos) (V_Winkel 90.0))
				(setq xPos_ATrg xPos)
			)
			(progn
				(setq tEnde (Traeger.get Tr_ID rechts))
				(TrEnde.set tEnde (Delta_L xPos) (V_Winkel 90.0))
				(setq xPos_ATrg (- l_ATrg xPos))
			)
		)
		(print "Trger-XPos-Berechnung ............................")
		(print l_HTrg)
		(print xPos_HTrg)
		(print l_ATrg)
		(print xPos_ATrg)


;    (setLokalVerschiebungen_90 radWnk)	; 90  Winkel
    (if (= (Connect.get CastaData amHtSteg) 1) (progn
		(print  "seitliche Verschiebung")
    	(setLokalVerschiebungen_Steg radWnk)
		(set_Seitl_Verschiebung_Steg)
    ))
    (if (= (Connect.get CastaData amHtFlansch) 1) (progn
		(print  "vertkale Verschiebung")
    	(setLokalVerschiebungen_Flansch radWnk)
		(set_Seitl_Verschiebung_Flansch)
    ))
	
; (debug off)
	
)

(defun set_SeitlVerschiebung_Generell ()
	(print " in set_Seitl_Verschiebung_Generell")
	(setq dSeitlich_HT (Traeger.get HTrg delta_LR))
	(setq dVertikal_HT (Traeger.get HTrg delta_V))
	
	(setq dSeitlich 0.0)
	(if (= (Connect.get CastaData amHtFlansch) 1) (setq dSeitlich    dSeitlich_HT))
	(if (= (Connect.get CastaData amHtSteg) 1)    (setq dSeitlich (- dVertikal_HT)))
	
	(if (/= HT_Ist_vertikal 0) (progn
		(print "HT ist vertikal")
		; (if (= (Connect.get CastaData anHtLinkesEnde) 1) (setq dSeitlich (- dSeitlich)))
	))
	(if (= (Connect.get CastaData amhtUnterflansch) 1) (progn
		(if (= (Connect.get CastaData anHtLinkesEnde) 1) (setq dSeitlich (- dSeitlich)))
	))
	(if (= (Connect.get CastaData amhtOberflansch) 1) (progn
		(if (= (Connect.get CastaData anHtRechtesEnde) 1) (setq dSeitlich (- dSeitlich)))
	))
	(if (= (Connect.get CastaData amhtStegRechts) 1) (progn
		(if (= (Connect.get CastaData anHtLinkesEnde) 1) (setq dSeitlich (- dSeitlich)))
	))
	(if (= (Connect.get CastaData amhtStegLinks) 1) (progn
		(if (= (Connect.get CastaData anHtRechtesEnde) 1) (setq dSeitlich (- dSeitlich)))
	))
	
	(Traeger.set RohrBogen (delta_LR dSeitlich))
	
)

;							-	-	-	-	-	-	-	-	-

(defun calc_VersionsLage ()
    (setq Versions_Lage 0)
    (if (= (Connect.get CastaData amHtOberFlansch) 1) (progn
    	(if (= (Connect.get CastaData amAtUnterFlansch) 1) (setq Versions_Lage 1))
    ))
    (if (= (Connect.get CastaData amHtUnterFlansch) 1) (progn
    	(if (= (Connect.get CastaData amAtOberFlansch) 1) (setq Versions_Lage 1))
    ))
)

;							-	-	-	-	-	-	-	-	-

(defun CreateBogenProfil ()    

	(calc_VersionsLage)
	(setq  Versions_Lage 0)

    (if (= Versions_Lage 0) (progn
		(print  "hier  Versions_Lage = 0")
		(Traeger.addJoinProfil Tr_ID RohrBogen xPos_ATrg 0.0 _EndeRechts_);		; Dummy-Test
		(Traeger.addJoinProfil HTrg  RohrBogen xPos_HTrg 0.0 _EndeLinks_);		; Dummy-Test
    ))

    (if (= Versions_Lage 1) (progn
		(print  "hier  Versions_Lage = 1")
        ; (Traeger.set  RohrBogen 	(BogenStich_V (- f_stich)))
		(Traeger.addJoinProfil Tr_ID RohrBogen xPos_ATrg 0.0 _EndeLinks_ );		; Dummy-Test
		(Traeger.addJoinProfil HTrg  RohrBogen xPos_HTrg 0.0 _EndeRechts_);		; Dummy-Test
    ))
	
	(set_SeitlVerschiebung_Generell)
)

;							-	-	-	-	-	-	-	-	-

(defun setLokalVerschiebungen_90 (radWnk)
    ; Testen - erstmal mit konstand angenommenn Werten
	(print "hier in setLokalVerschiebungen_90")
	
    (setq dlr_HT (Traeger.get HTrg delta_LR))
    (setq dV_HT  (* dlr_HT (cos radWnk)))
    (setq dlv_HT (* dlr_HT (sin radWnk)))

    (setq dlr_AT (Traeger.get Tr_ID delta_LR))
    (setq dV_AT  (* dlr_AT (cos radWnk)))
    (setq dlv_AT (* dlr_AT (sin radWnk)))


    (setq dV  (- dv_HT  dv_AT))
    (setq dlv (+ dlv_HT dlv_AT))

    (Traeger.set RohrBogen 
    		(delta_V	 dV)
    		(delta_Lng_V	 (- dlv))
    )

)

(defun setLokalVerschiebungen_Steg (radWnk)

    (print  "Funktion setLokalVerschiebungen_Steg ..........")

    ; Initialisieren ...
    (setq dvRohrbg_seitlich 0.0)
    (setq dlr_HT            0.0)
    (setq dlr_AT            0.0)

    ;; Hier noch Unterscheidung finden. Diese hier passt wahrscheinlich nicht immer.

	(setq  Alfa_HT (- (* 0.5  Oeffnungswinkel) 90.0))
	(setq  Beta_HT (- (* 0.5  Oeffnungswinkel) 90.0))


    
    (setq radAlfa_HT (* PI (/ Alfa_HT 180.0)))
    (setq radBeta_HT (* PI (/ Beta_HT 180.0)))
    (print Alfa_HT)
    (print Beta_HT)

    ; lokale Verschiebungen aufbereiten
    ; Fallabhngig, welche Orientierung die Trger zueinander haben.
    
    (if (= (Connect.get CastaData vatr-vhtr) 1) (progn
    	    (print "vatr-vhtr == 1")
	    (setq dlr_HT (Traeger.get HTrg delta_LR))
	    (setq dlr_HT (* 1.0 dlr_HT))
	    (if (= (Connect.get CastaData amHtStegRechts) 1) (setq dlr_HT (* -1.0 dlr_HT)))
	
	    (setq dlr_AT (Traeger.get Tr_ID delta_LR))
	    (setq dlr_AT (* 1.0 dlr_AT))
	    (if (= (Connect.get CastaData amAtStegRechts) 1) (setq dlr_AT (* -1.0 dlr_AT)))
	    
	    (setq dvRohrbg_seitlich (Traeger.get HTrg delta_V))
	    
	    (setq RWinkel (Traeger.get  RohrBogen R_Winkel))
	    (if (> RWinkel 45.0) (setq dvRohrbg_seitlich (- dvRohrbg_seitlich)))
	    (print dvRohrbg_seitlich)
    ))
    (if (= (Connect.get CastaData vatr-vhtr) -1) (progn
    	    (print "vatr-vhtr == -1")
	    (setq dlr_HT (Traeger.get HTrg delta_LR))
	    (if (= (Connect.get CastaData amHtStegRechts) 1) (setq dlr_HT (* -1.0 dlr_HT)))
	
	    (setq dlr_AT (Traeger.get Tr_ID delta_LR))
	    
	    (setq dvRohrbg_seitlich (Traeger.get HTrg delta_V))
	    (print dvRohrbg_seitlich)
    ))
    
	(setq dvRohrbg_seitlich (Traeger.get HTrg delta_LR))

	(setq Beta2 (+ 90.0 Beta_HT))
    (print Beta2)
    
    ; Hier Einbau fr spitze Winkel
    (if (< OeffnungsWinkel 90.0) (setq Beta2 (- 90.0 Beta2)))
    
    (setq dlHt_XPos 0.0
          dlHT_scv  0.0
          dlAt_XPos 0.0
          dlAT_scv  0.0
    )
	
    (if (/= (cos radAlfa_HT) 0.0) (progn
	    (setq dlHt_XPos (* dlr_HT (tan radAlfa_HT)))
	    (setq dlHT_scv  (/ dlr_HT (cos radAlfa_HT)))
	    (setq dlAt_XPos (* dlr_AT (tan radAlfa_HT)))
	    (setq dlAT_scv  (/ dlr_AT (cos radAlfa_HT)))
    ))

    (print ".................")
    (print dlr_HT)
    (print dlr_AT)
    (print dlHT_scv)
    (print dlAT_scv)


;    (if (< OeffnungsWinkel 90.0) (progn
;		(setq satr-shtr (Connect.get CastaData satr-shtr))
;		(setq satr-lhtr (Connect.get CastaData satr-lhtr))
;		(if (< (* satr-lhtr satr-shtr) 0) (progn
;			(setq dlHt_XPos (- dlHt_XPos))
;			(setq dlAt_XPos (- dlAt_XPos))
;		))
;   ))

    (print OeffnungsWinkel)
    (print Beta2)
    (print dlHT_scv)

    ; Berechnung der vertikalen und horizontalen Verschiebung
    (setq dv  (* dlHT_scv (sin (* (/ PI 180.0) Beta2))))
    (setq dlv (* dlHT_scv (cos (* (/ PI 180.0) Beta2))))

	
    (setq dv  (+ dv  (* dlAT_scv (sin (* (/ PI 180.0) Beta2)))))
    (setq dlv (- dlv (* dlAT_scv (cos (* (/ PI 180.0) Beta2)))))

	(print "Ergebnisse der seitlichen Verschiebung")
	(setq dlv 0)
	
    (Traeger.set RohrBogen 
;    		(delta_V	 dV)
    		(delta_Lng_V	 (- dlv))
;    		(delta_LR        dvRohrbg_seitlich)
    )

	(setq dlr_AT (Traeger.get Tr_ID delta_LR))
	
(if (= 2 2) (progn
    ; Krzungen der Trgerenden eintragen
    ; Erst der Haupttrger
    (if (= (Connect.get CastaData anhtlinkesende) 1) 
		(setq tEnde (Traeger.get HTrg links))
		(setq tEnde (Traeger.get HTrg rechts))
    )
;	(TrEnde.set tEnde (delta_L 0))
	
    (if (= (Connect.get CastaData satr-lhtr) -1) (progn
    	; (TrEnde.ptrim tEnde (- dlHt_XPos))
    	(TrEnde.ptrim tEnde  dlAt_XPos)
    	; (TrEnde.ptrim tEnde (- dlAT_scv))
    ))
    (if (= (Connect.get CastaData satr-lhtr) 1) (progn		; hier war 1
    	(TrEnde.ptrim tEnde  dlAt_XPos)
    	; (TrEnde.ptrim tEnde (- dlAT_scv))
    ))
	; -------------------------
    ; dann der Anschlusstrger
    (if (= (Connect.get CastaData linkesende) 1) 
    	(setq tEnde (Traeger.get Tr_ID links))
    	(setq tEnde (Traeger.get Tr_ID rechts))
    )
;	(TrEnde.set tEnde (delta_L 0))
    (if (= (Connect.get CastaData satr-lhtr) -1) (progn
		; (TrEnde.ptrim tEnde (- dlHT_scv))
		(TrEnde.ptrim tEnde  dlHt_XPos)
    ))
    (if (= (Connect.get CastaData satr-lhtr) 1) (progn		; hier war 1
		; (TrEnde.ptrim tEnde (- dlHT_scv))
		(TrEnde.ptrim tEnde  dlHt_XPos)
    ))
))
    (print "------------------------------------------")
    ; (Connect.showAttributes CastaData)

)


(defun set_Seitl_Verschiebung_Steg ()

	(print " set_Seitl_Verschiebung_Steg ")

	(calc_VersionsLage)
	
	; Variable der vertikalen Trgerverschiebung ermitteln, die seitlich ansetzt.
	(setq vAtr-vHtr (Connect.get CastaData vAtr-vHtr))
	(setq sAtr-vHtr (Connect.get CastaData sAtr-vHtr))
	(if (= vAtr-vHtr 0) 
		(setq HT_Delta_LR (Traeger.get HTrg delta_V))
		(setq HT_Delta_LR (Traeger.get HTrg delta_LR))
	)

  (if (= 2 3) (progn
;	 (if (= (Connect.get CastaData amHTOberFlansch) 1) (AlertBox "Am-HT-Oberflansch"))
;	 (if (= (Connect.get CastaData amHTUnterFlansch) 1) (AlertBox "Am-HT-Unterflansch"))
	 (if (= (Connect.get CastaData amHTStegLinks) 1) (AlertBox "Am-HT-Steg links"))
	 (if (= (Connect.get CastaData amHTStegRechts) 1) (AlertBox "Am-HT-Steg rechts"))
	 (AlertBox EndeVerbindung)
	 (AlertBox Versions_Lage)
	 (AlertBox sAtr-vHtr)
	 (AlertBox OeffnungsWinkel)
 ))

	(setq rechtwinklig 0)
 	(if (= OeffnungsWinkel 90.0) (setq rechtwinklig 1))
 
	(setq Alpha (- (/ OeffnungsWinkel 2.0) 90.0))
	(setq cosAlfa (cos (* PI (/ Alpha 180.0))))
	(print cosAlfa)
 
 
	(setq  dlr_Bogen  0.0)
	(setq  dV_Bogen  0.0)
 
	(if (=  VerbindungsTyp 1) (progn
		(if (= HT_ist_Vertikal 1) (progn
			(if (= (Connect.get CastaData  amHtStegRechts)  1) (progn
				(setq  dV_Bogen (- HT_Delta_LR))
			))
			(if (= (Connect.get CastaData  amHtStegLinks)  1) (progn
				(setq  dV_Bogen  HT_Delta_LR)
			))
		))
		(if (= HT_ist_Vertikal -1) (progn
			(if (= (Connect.get CastaData  amHtStegRechts)  1) (progn
				(setq  dV_Bogen  HT_Delta_LR)
			))
			(if (= (Connect.get CastaData  amHtStegLinks)  1) (progn
				(setq  dV_Bogen (- HT_Delta_LR))
			))
		))
		(if (= HT_ist_Vertikal  0) (progn
			; Hier muss eventuell noch eine genauere Untersuchung hin
			; (if (= vAtr-vHtr 0) (progn
				(if (= (Connect.get CastaData  amHtStegLinks)  1) (progn
					(setq  dV_Bogen   HT_Delta_LR)
				))
				(if (= (Connect.get CastaData  amHtStegRechts)  1) (progn
					(setq  dV_Bogen (- HT_Delta_LR))
				))
			; ))
		))
	 ))
	(if (=  VerbindungsTyp 2) (progn
		(if (= HT_ist_Vertikal 1) (progn
			(if (= (Connect.get CastaData  amHtStegRechts)  1) (progn
				(setq  dlr_Bogen (- HT_Delta_LR))
			))
			(if (= (Connect.get CastaData  amHtStegLinks)  1) (progn
				(setq  dlr_Bogen  HT_Delta_LR)
			))
		))
		(if (= HT_ist_Vertikal -1) (progn
			(if (= (Connect.get CastaData  amHtStegRechts)  1) (progn
				(setq  dlr_Bogen  HT_Delta_LR)
			))
			(if (= (Connect.get CastaData  amHtStegLinks)  1) (progn
				(setq  dlr_Bogen (- HT_Delta_LR))
			))
		))
		(if (= HT_ist_Vertikal  0) (progn
			; (if (= vAtr-vHtr 0) (progn
				(if (= (Connect.get CastaData  amHtStegLinks)  1) (progn
				))
				(if (= (Connect.get CastaData  amHtStegRechts)  1) (progn
				))
			; ))
		))
	 ))
	 (if (/= cosAlfa 0.0) (progn
		(setq  dV_Bogen (/ dV_Bogen cosAlfa))
	 ))
	 
	 (print  HT_Delta_LR)
	 (print  dlr_Bogen)
	 (print  dV_Bogen)
	 (setq dV_Bogen (- dV_Bogen))		;; Blind testen

	 (Traeger.set RohrBogen 
			(delta_V		 dV_Bogen)
    )

	
	
	
)

(defun 	set_HT_VertikalFlag ()

	(setq HT_ist_Vertikal 0)
	(if (= (Connect.get CastaData hpttrg_vwinkel) 90.0) 	(setq HT_ist_Vertikal  1))
	(if (= (Connect.get CastaData hpttrg_vwinkel) 270.0) (setq HT_ist_Vertikal  -1))

)

(defun calc_EndeVerbindung ()

	(setq EndeVerbindung "--")
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)  (progn
		(if (= (Connect.get CastaData linkesEnde) 1)      (setq  EndeVerbindung "LL"))
		(if (= (Connect.get CastaData rechtesEnde) 1)   (setq  EndeVerbindung "LR"))
	))
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)  (progn
		(if (= (Connect.get CastaData linkesEnde) 1)    (setq  EndeVerbindung "RL"))
		(if (= (Connect.get CastaData rechtesEnde) 1)   (setq  EndeVerbindung "RR"))
	))

)


(defun set_Seitl_Verschiebung_Flansch ()

	(print " set_Seitliche_Verschiebung ")

	(calc_VersionsLage)
	(calc_EndeVerbindung)
	
	; Variable der seitlichen Trgerverschiebung ermitteln, die auch seitlich ansetzt.
	(setq HT_Delta_LR (Traeger.get HTrg delta_LR))
	

	(setq sAtr-sHtr (Connect.get CastaData sAtr-sHtr))
	
 (if (= 2 3) (progn
	 (if (= (Connect.get CastaData amHTOberFlansch) 1) (AlertBox "Am-HT-Oberflansch"))
	 (if (= (Connect.get CastaData amHTUnterFlansch) 1) (AlertBox "Am-HT-Unterflansch"))
	 (AlertBox EndeVerbindung)
	 (AlertBox Versions_Lage)
	 (AlertBox sAtr-sHtr)
 ))

 
	(setq  dlr_Bogen  0.0)
	
	(if (= HT_ist_Vertikal 1) (progn
		(if (= (Connect.get CastaData  amHtOberflansch )  1) (progn
			(setq  dlr_Bogen (- HT_Delta_LR))
		))
		(if (= (Connect.get CastaData  amHtUnterflansch )  1) (progn
			(setq  dlr_Bogen  HT_Delta_LR)
		))
	))
	(if (= HT_ist_Vertikal -1) (progn
		(if (= (Connect.get CastaData  amHtOberflansch )  1) (progn
			(setq  dlr_Bogen  HT_Delta_LR)
		))
		(if (= (Connect.get CastaData  amHtUnterflansch )  1) (progn
			(setq  dlr_Bogen (- HT_Delta_LR))
		))
	))

	; HT liegt waagerecht oder in einem schrgen Winkel aus der Ebene
	(if (= HT_ist_Vertikal 0) (progn
		(if (= (Connect.get CastaData  anHtLinkesEnde)  1) (progn
			(if (= (Connect.get CastaData  at-von-oben)   1)  (setq  dlr_Bogen   HT_Delta_LR))			; OK
			(if (= (Connect.get CastaData  at-von-unten)  1)  (setq  dlr_Bogen  (- HT_Delta_LR)))		; OK
		))
		(if (= (Connect.get CastaData  anHtRechtesEnde)  1) (progn
			(if (= (Connect.get CastaData  at-von-oben)   1)  (setq  dlr_Bogen   (- HT_Delta_LR)))
			(if (= (Connect.get CastaData  at-von-unten)  1)  (setq  dlr_Bogen     HT_Delta_LR))			; OK
		))
	))

	
;    (Traeger.set RohrBogen 
;    		(delta_LR        dlr_Bogen)
;    )


)

(defun setLokalVerschiebungen_Flansch (radWnk)

   (print "Funktion setLokalVerschiebungen_Flansch ..........")

    ; Initialisieren ...
    (setq dvRohrbg_seitlich 0.0)
    (setq dlr_HT            0.0)
    (setq dlr_AT            0.0)
    
    ;; Hier noch Unterscheidung finden. Diese hier passt wahrscheinlich nicht immer.
    (print Oeffnungswinkel)
    (print "oeffWinkel-Original")
    (print oeffWinkel)
    (if (> oeffWinkel 90.0) (setq oeffWinkel (- 180.0 oeffWinkel)))
    (print oeffWinkel)
    (print f_stich)

    (setq AWnkl Oeffnungswinkel)

;    (setq AWnkl (Connect.get CastaData h-atrgewnkl_kopf))
;    (setq AWnkl (Connect.get CastaData h-atrgewnkl_steg))
;    (if (= (Connect.get CastaData amhtflansch) 1) (progn
;       (setq AWnkl (Connect.get CastaData v-atrgewnkl_flansch))
;    ))
    
    (setq Alfa_HT (- 90.0 AWnkl))
    
    (setq Alfa_HT (- (- 180.0 Beta) 90.0));
    
    
    (setq Beta_HT (* 0.5 (- 180.0 oeffWinkel)))
    (setq Beta_HT (* 0.5 Beta))
    (print Beta)
    (print Beta_HT)
    
    
;    (setq Alfa_HT (* 0.5 (- 180.0 AWnkl)))
    
    (setq radAlfa_HT (* PI (/ Alfa_HT 180.0)))
    (setq radBeta_HT (* PI (/ Beta_HT 180.0)))
    (print Alfa_HT)
    (print Beta_HT)
    (print AWnkl)

    ; lokale Verschiebungen aufbereiten
    ; Fallabhngig, welche Orientierung die Trger zueinander haben.
    
    (if (= (Connect.get CastaData vatr-vhtr) 1) (progn
    	    (print "vatr-vhtr == 1")
	    (setq dlr_HT (Traeger.get HTrg delta_V))
	    (setq dlr_AT (Traeger.get Tr_ID delta_V))
    ))
    (if (= (Connect.get CastaData vatr-vhtr) -1) (progn
    	    (print "vatr-vhtr == -1")
	    (setq dlr_HT (Traeger.get HTrg delta_V))
	    (if (= (Connect.get CastaData amHtStegRechts) 1) (setq dlr_HT (* -1.0 dlr_HT)))
	
	    (setq dlr_AT (Traeger.get Tr_ID delta_V))
    ))
    (setq dlr_HT (* 1.0 dlr_HT))
    (setq dlr_AT (* 1.0 dlr_AT))
    

    (setq Beta2 (/ AWnkl 2.0))
    (setq Beta2 (* 0.5  oeffWinkel))
    (print Beta2)
    
    ; Hier Einbau fr spitze Winkel
    (if (< OeffnungsWinkel 90.0) (setq Beta2 (- 90.0 Beta2)))
    
    (setq dlHt_XPos 0.0
          dlHT_scv  0.0
          dlAt_XPos 0.0
          dlAT_scv  0.0
    )
    (if (/= (cos radAlfa_HT) 0.0) (progn
	    (setq dlHt_XPos (* dlr_HT (tan radAlfa_HT)))
	    (setq dlHT_scv  (/ dlr_HT (cos radAlfa_HT)))
	    (setq dlAt_XPos (* dlr_AT (tan radAlfa_HT)))
	    (setq dlAT_scv  (/ dlr_AT (cos radAlfa_HT)))
    ))

    (print ".................")
    (print dlr_HT)
    (print dlr_AT)
    (print dlHT_scv)
    (print dlAT_scv)


    (setq vatr-vhtr (Connect.get CastaData vatr-vhtr))
    (setq vatr-lhtr (Connect.get CastaData vatr-lhtr))

    (if (< vatr-vhtr 0) (progn
	    (setq dlHt_XPos (- dlHt_XPos))
	    (setq dlHT_scv  (- dlHT_scv))
    ))
    (if (>= OeffnungsWinkel 90.0) (progn
      (if (< vatr-vhtr 0) (progn
    	    (if (= (Connect.get CastaData amhtUnterflansch) 1) (progn
		(setq dlHt_XPos (- dlHt_XPos))
		(setq dlAt_XPos (- dlAt_XPos))
		(setq dlHT_scv (- dlHT_scv))
		(setq dlAT_scv (- dlAT_scv))
	    ))
     ))
     (if (> vatr-vhtr 0) (progn
    	    (if (= (Connect.get CastaData amHtOberflansch) 1) (progn
				(setq dlHt_XPos (- dlHt_XPos))
				(setq dlAt_XPos (- dlAt_XPos))
				(setq dlHT_scv (- dlHT_scv))
				(setq dlAT_scv (- dlAT_scv))
    	    ))
     ))
   ))


    (if (< OeffnungsWinkel 90.0) (progn
    	(if (= (Connect.get CastaData anhtrechtesende) 1) (progn
		(if (= (Connect.get CastaData linkesende)  1) (setq dlHt_XPos (- dlHt_XPos)))
		(if (= (Connect.get CastaData rechtesende) 1) (setq dlAt_XPos (- dlAt_XPos)))
		(if (< vatr-lhtr 0) (setq dlHT_scv (- dlHT_scv)))
		(if (> vatr-lhtr 0) (setq dlAT_scv (- dlAT_scv)))
	))
    	(if (= (Connect.get CastaData anhtlinkesende) 1) (progn
		(if (= (Connect.get CastaData linkesende)  1) (setq dlHt_XPos (- dlHt_XPos)))
		(if (= (Connect.get CastaData rechtesende) 1) (setq dlAt_XPos (- dlAt_XPos)))
		(if (< vatr-lhtr 0) (setq dlAT_scv (- dlAT_scv)))
		(if (> vatr-lhtr 0) (setq dlHT_scv (- dlHT_scv)))
	))
   ))

    (print OeffnungsWinkel)
    (print Beta2)
    (print dlHT_scv)

    (if (>= OeffnungsWinkel 90.0) (progn
	    (setq dv1  (* dlHT_scv (sin (* (/ PI 180.0) Beta2))))
	    (setq dv2  (* dlAT_scv (sin (* (/ PI 180.0) Beta2))))

	    (setq dlv1 (* dlHT_scv (cos (* (/ PI 180.0) Beta2))))
	    (setq dlv2 (* dlAT_scv (cos (* (/ PI 180.0) Beta2))))

	    (print "............................. Oeffnungswinkel >= 90.0")
	    (print dv1) (print dv2)
	    (print dlv1) (print dlv2)

	    ; Berechnung der vertikalen und horizontalen Verschiebung
	    (setq dv  (* dlHT_scv (sin (* (/ PI 180.0) Beta2))))
	    (setq dlv (* dlHT_scv (cos (* (/ PI 180.0) Beta2))))
	
	    (setq dv  (+ dv  (* dlAT_scv (sin (* (/ PI 180.0) Beta2)))))
	    (setq dlv (- dlv (* dlAT_scv (cos (* (/ PI 180.0) Beta2)))))
	    
	    (setq dlv (-  dlv1 dlv2))
    ))
    (if (< OeffnungsWinkel 90.0) (progn
	    ; Berechnung der vertikalen und horizontalen Verschiebung
	    (setq dv1  (* dlHT_scv (sin (* (/ PI 180.0) Beta2))))
	    (setq dv2  (* dlAT_scv (sin (* (/ PI 180.0) Beta2))))

	    (setq dlv1 (* dlHT_scv (cos (* (/ PI 180.0) Beta2))))
	    (setq dlv2 (* dlAT_scv (cos (* (/ PI 180.0) Beta2))))
	    (print "............................. Oeffnungswinkel < 90.0")
	    (print dv1) (print dv2)
	    (print dlv1) (print dlv2)


	    (setq dv  (* dlHT_scv (sin (* (/ PI 180.0) Beta2))))
	    (setq dlv (- (* dlHT_scv (cos (* (/ PI 180.0) Beta2)))))
	
	    (setq dv  (+ dv  (* dlAT_scv (sin (* (/ PI 180.0) Beta2)))))
	    (setq dlv (+ dlv (* dlAT_scv (cos (* (/ PI 180.0) Beta2)))))
	    
	    (setq dlv (-  dlv1 dlv2))
    ))


    (print dlv)
    (print dv)

    (Traeger.set RohrBogen 
    		(delta_V	 dV)
    		(delta_Lng_V	 dlv)
 ;   		(delta_LR        dvRohrbg_seitlich)
    )


    ; Krzungen der Trgerenden eintragen
    ; Erst der Haupttrger
    (if (= (Connect.get CastaData anhtlinkesende) 1) 
	(setq tEnde (Traeger.get HTrg links))
	(setq tEnde (Traeger.get HTrg rechts))
    )

    (if (= (Connect.get CastaData vatr-lhtr) -1) (progn
    	(TrEnde.ptrim tEnde dlHt_XPos)
    	(TrEnde.ptrim tEnde dlAT_scv)
    ))
    (if (= (Connect.get CastaData vatr-lhtr) 1) (progn	
    	(TrEnde.ptrim tEnde dlHt_XPos)
    	(TrEnde.ptrim tEnde dlAT_scv)
    ))
    (if (= (Connect.get CastaData vatr-lhtr) 0) (progn	
    	(TrEnde.ptrim tEnde dlHt_XPos)
    	(TrEnde.ptrim tEnde dlAT_scv)
    ))
    ; dann der Anschlusstrger
    (if (= (Connect.get CastaData linkesende) 1) 
    	(setq tEnde (Traeger.get Tr_ID links))
    	(setq tEnde (Traeger.get Tr_ID rechts))
    )
    (if (= (Connect.get CastaData vatr-lhtr) -1) (progn
		(TrEnde.ptrim tEnde dlHT_scv)
		(TrEnde.ptrim tEnde dlAt_XPos)
    ))
    (if (= (Connect.get CastaData vatr-lhtr) 1) (progn
		(TrEnde.ptrim tEnde dlHT_scv)
		(TrEnde.ptrim tEnde dlAt_XPos)
    ))
    (if (= (Connect.get CastaData vatr-lhtr) 0) (progn	
		(TrEnde.ptrim tEnde dlHT_scv)
		(TrEnde.ptrim tEnde dlAt_XPos)
    ))


    (print "------------------------------------------")
    ; (Connect.showAttributes CastaData)

)



(defun set_VerbindungsTyp ()
    (setq AT_V_Winkel (Connect.get CastaData trg_vwinkel))
    (setq HT_V_Winkel (Connect.get CastaData hpttrg_vwinkel ))

	;  VerbindungsTyp 0  ----  unbekannt
	;  VerbindungsTyp 1  ----  Handlauf an Handlauf, oder Knieleiste an Knieleiste

	(setq VerbindungsTyp 0)		; unbekannt
	
	
	(if (= HT_V_Winkel 0.0) (progn
			(if (= AT_V_Winkel     0.0) (setq VerbindungsTyp 1))	; Handlauf an Handlauf, oder Knieleiste an Knieleiste
			(if (= AT_V_Winkel   90.0) (setq VerbindungsTyp 3))	; Handlauf an Pfosten - Sonderfall
			(if (= AT_V_Winkel 270.0) (setq VerbindungsTyp 3))		; Handlauf an Pfosten - Sonderfall
	))
	(if (= HT_V_Winkel 90.0) (progn
			(if (< AT_V_Winkel   45.0) (setq VerbindungsTyp 2))	; Pfosten an Handlauf
			(if (> AT_V_Winkel 315.0) (setq VerbindungsTyp 2))		; Pfosten an Handlauf
	))
	(if (= HT_V_Winkel 270.0) (progn
			(if (< AT_V_Winkel   45.0) (setq VerbindungsTyp 2))	; Pfosten an Handlauf
			(if (> AT_V_Winkel 315.0) (setq VerbindungsTyp 2))		; Pfosten an Handlauf
	))

)
; ---------- Mai 2018 --------- sicherheitshabler die Trgerenden initialisieren
; da es anscheinend sonst zu Fehlern fhren kann.
(defun init_TrgEnden ()
	(if (= (Connect.get CastaData linkesende) 1) (progn
		(setq TEnde (Traeger.get Tr_ID links))
		(TrEnde.set TEnde (delta_L 0.0) (V_Winkel 90.0)  (H_Winkel 90.0) )
	))
	(if (= (Connect.get CastaData rechtesende) 1) (progn
		(setq TEnde (Traeger.get Tr_ID rechts))
		(TrEnde.set TEnde (delta_L 0.0) (V_Winkel 90.0)  (H_Winkel 90.0) )
	))
    (if (= (Connect.get CastaData anhtlinkesende) 1) (progn
		(setq TEnde (Traeger.get HTrg links))
		(TrEnde.set TEnde (delta_L 0.0) (V_Winkel 90.0)  (H_Winkel 90.0) )
    ))
    (if (= (Connect.get CastaData anhtrechtesende) 1) (progn
		(setq TEnde (Traeger.get HTrg rechts))
		(TrEnde.set TEnde (delta_L 0.0) (V_Winkel 90.0)  (H_Winkel 90.0) )
    ))
)
; ---------- Mrz 2021 --------- 
(defun print_AnalyseValues ()
	(setq RohrProfil_Bogenstich (Traeger.get RohrBogen BogenStich_V))
	(setq RohrProfil_RWinkel    (Traeger.get RohrBogen R_Winkel))
	
	(print "--------------- AnalyseValues ---------------")
	(print RohrProfil_Bogenstich)
	(print RohrProfil_RWinkel)

)

; --- wird nicht verwendet - hier aber gelassen um einen Weg zu haben, manuell den ffnungswinkel
(defun calcOeffnungsWinkel ()

	
	(setq VKopfWinkel (Connect.get CastaData v-atrgewnkl_kopf))
	(setq StumpferWinkel 0)   
	(setq SpitzerWinkel 0)  

	(if (= (Connect.get CastaData amHtOberFlansch) 1) (progn
		(if (= (Connect.get CastaData at-von-hinten) 1) (progn
			(if (= (Connect.get CastaData at-von-unten) 1) (progn
				(if (= (Connect.get CastaData anHtLinkesende) 1) (setq desc "stumpfer Winkel 1 (OK)" StumpferWinkel 1))
				(if (= (Connect.get CastaData anHtRechtesende) 1) (setq desc "spitzer Winkel 2 (OK)" SpitzerWinkel 1))
			))
			(if (= (Connect.get CastaData at-von-oben) 1) (progn
				(if (= (Connect.get CastaData anHtLinkesende) 1) (setq desc "spitzer  Winkel 3 (OK)" SpitzerWinkel 1))
				(if (= (Connect.get CastaData anHtRechtesende) 1) (setq desc "stumpfer Winkel 4 (OK)" StumpferWinkel 1))
			))
		))
	))
	(if (= (Connect.get CastaData amHtUnterFlansch) 1) (progn
		(if (= (Connect.get CastaData at-von-hinten) 1) (progn
			(if (= (Connect.get CastaData at-von-unten) 1) (progn
				(if (= (Connect.get CastaData anHtLinkesende) 1) (setq desc "spitzer  Winkel 5 (OK)" SpitzerWinkel 1))
				(if (= (Connect.get CastaData anHtRechtesende) 1) (setq desc "stumpfer Winkel 6 (OK)" StumpferWinkel 1))
			))
			(if (= (Connect.get CastaData at-von-oben) 1) (progn
				(if (= (Connect.get CastaData anHtLinkesende) 1) (setq desc "stumpfer   Winkel 7 (OK)" StumpferWinkel 1))
				(if (= (Connect.get CastaData anHtRechtesende) 1) (setq desc "spitzer Winkel 8 (OK)" SpitzerWinkel 1))
			))
		))
	))


	(if (= (Connect.get CastaData amHtOberFlansch) 1) (progn
		(if (= (Connect.get CastaData at-von-vorne) 1) (progn
			(if (= (Connect.get CastaData at-von-unten) 1) (progn
				(if (= (Connect.get CastaData anHtLinkesende) 1) (setq desc "spitzer  Winkel  1 (OK)" SpitzerWinkel 1))
				(if (= (Connect.get CastaData anHtRechtesende) 1) (setq desc "stumpfer Winkel  2 (OK)" StumpferWinkel 1))
			))
			(if (= (Connect.get CastaData at-von-oben) 1) (progn
				(if (= (Connect.get CastaData anHtLinkesende) 1) (setq desc "stumpfer  Winkel  3 (OK)" StumpferWinkel 1))
				(if (= (Connect.get CastaData anHtRechtesende) 1) (setq desc "spitzer  Winkel  4 (OK)" SpitzerWinkel 1))
			))
		))
	))
	(if (= (Connect.get CastaData amHtUnterFlansch) 1) (progn
		(if (= (Connect.get CastaData at-von-vorne) 1) (progn
			(if (= (Connect.get CastaData at-von-unten) 1) (progn
				(if (= (Connect.get CastaData anHtLinkesende) 1) (setq desc "stumpfer   Winkel  5 (OK)" StumpferWinkel 1))
				(if (= (Connect.get CastaData anHtRechtesende) 1) (setq desc "spitzer Winkel  6 (OK)" SpitzerWinkel 1))
			))
			(if (= (Connect.get CastaData at-von-oben) 1) (progn
				(if (= (Connect.get CastaData anHtLinkesende) 1) (setq desc "spitzer   Winkel  7 (OK)" SpitzerWinkel 1))
				(if (= (Connect.get CastaData anHtRechtesende) 1) (setq desc "stumpfer  Winkel  8 (OK)" StumpferWinkel 1))
			))
		))
	))

	(print "-------------------------- zentral ffnungswinkel berechnen - am HT-Flansch")
	(print VKopfWinkel)
	(print desc)
	(if (= SpitzerWinkel 1) (progn
		(print "Spitzer Winkel")
		(if (< VKopfWinkel 90.0) 
			(setq OeffnungsWinkel (- 90.0 VKopfWinkel))
			(setq OeffnungsWinkel (- VKopfWinkel 90.0))
		)
	))
	(if (= StumpferWinkel 1) (progn
		(if (> VKopfWinkel 90.0) 
			(setq OeffnungsWinkel (- 180.0 (- VKopfWinkel 90.0)))
			(setq OeffnungsWinkel (- 180.0 (- 90.0 VKopfWinkel)))
		)
		(print "Stumpfer Winkel")
	))
	(print OeffnungsWinkel)
	(setq OeffWinkel_Connect (Connect.get CastaData OeffnungsWinkel))
	(AlertBox OeffnungsWinkel)
	(AlertBox OeffWinkel_Connect)
	
)

