; $	HT	QT(F)	 	AF(F)		P(EZ)
; $	AT	QT(FR) 		AF(FS)		P(EZ)
; $	AE	V(-)		H(-)			R(-)

;	Bedingngen: Rohrpfosten sollte nur seitlich verschoben sein, also nicht 90 zur Trgerachsel liegen.

(defun load-modules ()
	(print "Module einladen")
)

(defun init-connection ()
	(print "*clear*")
	(print "Connection erstellen")
	
	; (Connect.showAttributes CastaData)

	; Einstellungen ...
	(setq LB_Master_AT  0)
	(setq LB_Master_HT  1)
	
	(setq Anschluss_Erzeugen 1)
;	(if (/= (Connect.get CastaData satr-lhtr-ex) 0) (setq Anschluss_Erzeugen 0))
	
	; Ob das klappt - wohl eher nicht, weil es sich bei Flachstahl nicht um ein Steglochbild handelt.
    (if (= (Connect.get CastaData exist_steglchb) 1) (AlertBox "Achtung - gemeinsames Lochbild" "OppositeSideConnection_Found"))

	(calcVorabLichtenAbstand)
	(if (< LichterAbstand 30) (setq Anschluss_Erzeugen 0))
	
	(if (= Anschluss_Erzeugen 1) (progn
		(createConnection)
		; (testConnection)
	))
	
	(if (= Anschluss_Erzeugen 0) (progn
		; Abstand ist zu gro (oder zu gering) - Platte wrde zu dick (zu dnn) werden
		(alertBox "Anschluss nicht mglich."  "Connection_Not_Possible")
	))
	
	
)
(defun createConnection ()
	(init_Geometry)					; Geometrie initialisieren - Winkel und Winkelfunktionswerte

	(print "-----------------------------------------------------------")
	(print Achs_Abstand)
	(print links_vorbei)
	(print rechts_vorbei)

	(print an_AT_links)
	(print an_AT_rechts)
	(print AT_Winkel_K)

	; vorgegebene Werte
	(setq dp_KPlatte 10)

	(addFahnenBlech)		;; neu
	
	(createAP_an_Pfosten)
	(setOrCreateLochbild)
	(Lochbild_an_Pfosten)
	(Lochbild_an_Wange)
	(LochbildVerwaltung)

	(FahneAnpassen)
	(AT_EndLaenge)


	
	; (testConnection)
	
)
; -----------------------------
(defun testConnection ()

	(Lochbild.set Lb_Lochbild (e "0 30 70 0 0 0"))
;	(Lochbild.set Lb_Lochbild (w "80 0 0 0"))
	(Lochbild.set Lb_Lochbild (LB_Art 2))

	(Blech.set Bl_Kontaktplatte (x3 20) (y3 10))
	
	; (Connect.showAttributes CastaData)
	
	(setq w0 (Lochbild.get Lb_Lochbild w0))
	(Lochbild.set Lb_Lochbild  (LB_Art 2))
	

	(setq abtl_LB_HT (Traeger.get HTrg  ABTeil Lb_Lochbild))
	(setq abtl_LB_AT (Traeger.get Tr_ID ABTeil Lb_Lochbild))
	(Anbauteil.set abtl_LB_AT (Master 0))
	(Anbauteil.set abtl_LB_HT (Master 1))
	
	(setq Winkel_LB_HT (Anbauteil.get abtl_LB_HT Winkel))
	(setq Winkel_LB_AT (Anbauteil.get abtl_LB_AT Winkel))
	
	(print "...................... testConnection .................")
	(if (= (Connect.get CastaData at-von-links)  1) (print "Der AT kommt von links"))
	(if (= (Connect.get CastaData at-von-rechts) 1) (print "Der AT kommt von rechts"))
	(if (= links_vorbei  1) (print "am HT links  vorbei"))
	(if (= rechts_vorbei 1) (print "am HT rechts vorbei"))

	(if (= 1 2) (progn
		(if (= TreppeAufwaerts 1) (progn
			(if (= PfostenAufrecht 1) (AlertBox "Treppe aufwrts, Pfosten aufrecht"))
			(if (= PfostenAufKopf  1) (AlertBox "Treppe aufwrts, Pfosten auf Kopf"))
		))
		(if (= TreppeAbwaerts 1) (progn
			(if (= PfostenAufrecht 1) (AlertBox "Treppe abwrts, Pfosten aufrecht"))
			(if (= PfostenAufKopf  1) (AlertBox "Treppe abwrts, Pfosten auf Kopf"))
		))

		(print V_StegWinkel)
		(print ControlWnkl)
	))
	
)
; -----------------------------


(defun createAP_an_Pfosten ()
	(setq Bl_Kontaktplatte (Blech.create))
	
	(setq b_HT 	 (Traeger.get HTrg b))			; Breite, weil es ein Flachstahl ist (stehend auf der Kante)
	(setq dlr_HT (Traeger.get HTrg delta_LR))	; Rechts-/Links-Verschiebung, weil es ein Flachstahl ist (stehend auf der Kante)
	(setq hp_KP (runde (* 8 16) auf 10))
	(setq qsForm_AT (Traeger.get Tr_ID qsForm))

	(if (= qsForm_AT "F") (progn
		(setq t_AT (Traeger.get Tr_ID t))
		(setq bp_KP (runde (+ t_AT (* 8 16)) auf 10))	; S-Durchm 16 angenommen
	  )
	  (progn
		(setq h_AT (Traeger.get Tr_ID h))			; ist ja ein Rohr - ansonsten msste man unterscheiden
		(setq bp_KP (runde (+ h_AT (* 8 16)) auf 10))	; S-Durchm 16 angenommen
	))
	
	(Blech.set  Bl_Kontaktplatte (hp hp_KP) (bp bp_KP) (dp dp_KPlatte))

	(setq rWinkel 0.0)
	(if (= (Connect.get CastaData at-von-unten) 1) (setq  rWinkel 180.0))

	(setq xPos_AT (Connect.get CastaData xPos_AT))
	
	(if (= an_AT_links 1)  (traeger.addabtl Tr_ID Bl_Kontaktplatte xPos_AT rWinkel _lasche_steg_li_))
	(if (= an_AT_rechts 1) (traeger.addabtl Tr_ID Bl_Kontaktplatte xPos_AT rWinkel _lasche_steg_re_))

	(Connect.storeAnschlObjs CastaData Bl_Kontaktplatte)
	
	; max_Hp zulssig ausrechnen
	(setq Wnkl_relevant AT_Winkel_K)
	(if (< AT_Winkel_K 0.0) (setq Wnkl_relevant (- AT_Winkel_K)))
	
	(setq cos_Stw (cos (/ (* PI Wnkl_relevant) 180.0)))
	(setq tan_Stw (tan (/ (* PI Wnkl_relevant) 180.0)))
	
	(setq hp_Zul (- (/ b_HT cos_Stw) (* tan_Stw bp_KP)))
	(Blech.set  Bl_Kontaktplatte (hp hp_Zul))
	
	(setq Fall 0)
	(if (= (Connect.get CastaData at-von-links)  1) (setq Fall 1))
	(if (= (Connect.get CastaData at-von-rechts) 1) (setq Fall 2))
	(print Fall)

	(setq dOK_aus_DLR (/ (* 1.0 dlr_HT) cos_Stw))
	(if (= Fall 1) (setq dOK_aus_DLR (- dOK_aus_DLR)))

	(setq deltaLR_HT (Traeger.get HTrg delta_LR))
	(setq dOK_Bl deltaLR_HT)
	(setq dOK_Bl dOK_aus_DLR)
	
	(Blech.set Bl_Kontaktplatte (dOK (- dOK_Bl)))

	(setq	blAbstand	0.0)
	(if (objExist Bl_Fahne) (progn
		; Oberkante wird vom Fahnenblech bernommen.
		(setq	bp_Fahne	(Blech.get  Bl_Fahne bp))
		(setq	blAbstand	bp_Fahne)
	))
	(Blech.set Bl_Kontaktplatte (delta_y blAbstand))
	(Blech.set Bl_Kontaktplatte (formFkt "cb_KontPlatte"))

)

(defun Lochbild_an_Pfosten ()
	(setq rWinkel 0.0)
	(setq xPos_AT (Connect.get CastaData xPos_AT))

	(if (= an_AT_links 1)  (traeger.addabtl Tr_ID Lb_Lochbild xPos_AT rWinkel _steglochbild_system_))
	(if (= an_AT_rechts 1) (traeger.addabtl Tr_ID Lb_Lochbild xPos_AT rWinkel _steglochbild_system_))
)
(defun Lochbild_an_Wange ()
	(setq rWinkel 90.0)
	(setq SWinkel (Connect.get CastaData v-atrgewnkl_steg))
	(setq diffWnkl (- 90.0 SWinkel))

	; AT_Winkel_K wurde vorher berechnet
	(setq diffWnkl (Connect.get CastaData v-atrgewnkl_kopf))
	
		
	(if (= (Connect.get CastaData at-von-links)  1) (setq rWinkel  -90.0))
	(if (= (Connect.get CastaData at-von-rechts) 1) (setq rWinkel   90.0))
		
	(setq Fall 1)
	(if (= (Connect.get CastaData at-von-links)  1) (if (= (Connect.get CastaData at-von-hinten) 1) (setq Fall 2)))
	(if (= (Connect.get CastaData at-von-rechts) 1) (if (= (Connect.get CastaData at-von-vorne)  1) (setq Fall 2)))

	(if (= Fall 1) (setq rWinkel (+ rWinkel AT_Winkel_K)))
	(if (= Fall 2) (setq rWinkel (- rWinkel AT_Winkel_K)))
	
	(setq rWinkel (- 180.0 rWinkel))

	(setq am_AT_Ende 0)
	(if (= (Connect.get CastaData linkesEnde) 1)  (progn
		(setq am_AT_Ende 1)

		(if (= (Connect.get CastaData vAtr-lHtr) -1) (progn
			(if (= (Connect.get CastaData sAtr-vHtr) -1) (setq rWinkel (+ 90.0 AT_Winkel_K 180.0)))	; OK
			(if (= (Connect.get CastaData sAtr-vHtr)  1) (setq rWinkel (- 90.0 AT_Winkel_K)))		; OK
		))
		(if (= (Connect.get CastaData vAtr-lHtr)  1) (progn
			(if (= (Connect.get CastaData sAtr-vHtr) -1) (setq rWinkel (+ 90.0 AT_Winkel_K)))		; OK
			(if (= (Connect.get CastaData sAtr-vHtr)  1) (setq rWinkel (- 90.0 AT_Winkel_K 180.0)))	; OK
		))
			
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(setq am_AT_Ende 1)

		(if (= (Connect.get CastaData vAtr-lHtr) -1) (progn
			(if (= (Connect.get CastaData sAtr-vHtr) -1) (setq rWinkel (+ 90.0 AT_Winkel_K 180.0)))  ; OK 2.
			(if (= (Connect.get CastaData sAtr-vHtr)  1) (setq rWinkel (- 90.0 AT_Winkel_K)))		 ; OK 2.
		))
		(if (= (Connect.get CastaData vAtr-lHtr)  1) (progn
			(if (= (Connect.get CastaData sAtr-vHtr) -1) (setq rWinkel (+ 90.0 AT_Winkel_K)))		 ; OK 2.
			(if (= (Connect.get CastaData sAtr-vHtr)  1) (setq rWinkel (- 90.0 AT_Winkel_K 180.0)))  ; OK 2.
		))
	))

	(if (= am_AT_Ende 0) (progn
		(if (= (Connect.get CastaData vAtr-lHtr) -1) (progn
			(if (= (Connect.get CastaData sAtr-vHtr) -1) (setq rWinkel (+ 90.0 AT_Winkel_K 180.0)))  ; OK
			(if (= (Connect.get CastaData sAtr-vHtr)  1) (setq rWinkel (- 90.0 AT_Winkel_K)))		 ; OK
		))
		(if (= (Connect.get CastaData vAtr-lHtr)  1) (progn
			(if (= (Connect.get CastaData sAtr-vHtr) -1) (setq rWinkel (+ 90.0 AT_Winkel_K)))		 ; OK
			(if (= (Connect.get CastaData sAtr-vHtr)  1) (setq rWinkel (- 90.0 AT_Winkel_K 180.0)))  ; OK
		))
	))
	
	(if (< rWinkel 0.0) (setq rWinkel (+ rWinkel 360.0)))

	(setq xPos_HT (Connect.get CastaData xPos_HT))
	(traeger.addabtl HTrg Lb_Lochbild xPos_HT rWinkel _flanschlochbild_of_)
	
	
)
(defun setOrCreateLochbild ()
	(setq Lb_Lochbild (Lochbild.create))

	(setq b_HT	(Traeger.get HTrg b))  ; Flachstahl auf der Kante stehend
	(setq t_HT	(Traeger.get HTrg t))
	(setq h_AT	(Traeger.get Tr_ID h))  ; Rohrpfosten - h = b
	(setq hp_KP	(Blech.get Bl_Kontaktplatte hp))
	(setq dp_KP (Blech.get Bl_Kontaktplatte dp))
	
	(setq e_0 (/ hp_KP 4))
	(setq e_1 (* 2 e_0))
	
	(setq klLng (+ t_HT dp_KP))

	(setq w_0 (runde (+ h_AT (* 4 16)) auf 2))
	(Lochbild.set  Lb_Lochbild 
			(S_Bez		"M12")
			(Guete   "4.6")
			(w0 w_0)
			(e0 e_0)
			(e1 e_1)
			(KlemmL klLng)
	)
	
	(if (= links_vorbei 1) (progn
		(Lochbild.set  Lb_Lochbild 
			(dxSKopf dp_KP)
		)
	))
	
	(Connect.storeAnschlObjs CastaData Lb_Lochbild)

)
(defun LochbildVerwaltung ()
	(setq abtl_LB_AT (Traeger.get Tr_ID ABTeil Lb_Lochbild))
	(setq abtl_LB_HT (Traeger.get HTrg  ABTeil Lb_Lochbild))
	(Anbauteil.set abtl_LB_AT (Master 0))
	(Anbauteil.set abtl_LB_HT (Master 1))
	
	(setq LB_SeitRicht 1)
	(if (= (Connect.get CastaData sAtr-vHtr)  1) (setq LB_SeitRicht -1))
	(Anbauteil.set abtl_LB_AT (SeitRicht  LB_SeitRicht))

	(setq deltaLR_HT (Traeger.get HTrg delta_LR))
	(setq sinW (sin (/ (* PI AT_Winkel_K) 180.0)))
	(setq cosW (cos (/ (* PI AT_Winkel_K) 180.0)))
	(setq dv_Lchb  (* cosW deltaLR_HT))
	(setq dlr_Lchb (* sinW deltaLR_HT))
	
	; ---- hier jetzt noch Vorzeichen untersuchen
	; sAtr-vHtr hier untersuchen
	(if (< AT_Winkel_K 0.0) (setq dlr_Lchb (- dlr_Lchb)))
	
	(setq Fall 0)
	(if (= (Connect.get CastaData at-von-links)  1) (setq Fall 1))
	(if (= (Connect.get CastaData at-von-rechts) 1) (setq Fall 2))
	(print Fall)

	; Wenn am HT, dann ist das VZ genau umgekehrt - hier aber am AT
	(if (= Fall 1) (Anbauteil.set abtl_LB_AT (delta_V     dv_Lchb)))
	(if (= Fall 2) (Anbauteil.set abtl_LB_AT (delta_V  (- dv_Lchb))))
	
	(setq hp_Bl (Blech.get Bl_Kontaktplatte hp))
	(setq dOK_Bl (Blech.get Bl_Kontaktplatte dOK))

	(setq dv_Abtl_Lb_AT	(Anbauteil.get abtl_LB_AT delta_V))

	(setq dOK_Lb (+ (* 1.0 dOK_Bl) (* -0.5 hp_Bl) (- dv_Abtl_Lb_AT)))

	(print hp_Bl) (print dOK_Bl)
	(print dv_Abtl_Lb_AT)
	(print dOK_Lb)

	(Lochbild.set Lb_Lochbild (dOK dOK_Lb))
	
	; ---------- ....................... ----------------------
	(setq dv_AT (Traeger.get Tr_ID delta_V))
	(if (/= dv_AT 0) (progn
		(if (= TreppeAbwaerts  1) (if (= PfostenAufKopf  1) (setq dv_AT (- dv_AT))))
		(if (= TreppeAufwaerts 1) (if (= PfostenAufrecht 1) (setq dv_AT (- dv_AT))))
		(if (= oben_vorbei 1) (progn
			(if (= an_AT_links 1)  (setq dlr_Lchb (+ dlr_Lchb dv_AT)))
			(if (= an_AT_rechts 1) (setq dlr_Lchb (- dlr_Lchb dv_AT)))
		))
		(if (= unten_vorbei 1) (progn
			(if (= an_AT_links 1)  (setq dlr_Lchb (- dlr_Lchb dv_AT)))
			(if (= an_AT_rechts 1) (setq dlr_Lchb (+ dlr_Lchb dv_AT)))
		))
	))
	
	(if (= TreppeAufwaerts 1) (progn
		(if (= PfostenAufrecht 1) (Anbauteil.set abtl_LB_HT (delta_LR (+ dlr_Lchb))))
		(if (= PfostenAufKopf  1) (Anbauteil.set abtl_LB_HT (delta_LR (- dlr_Lchb))))
	))
	
	(if (= TreppeAbwaerts 1) (progn
		(if (= PfostenAufrecht 1) (Anbauteil.set abtl_LB_HT (delta_LR (- dlr_Lchb))))
		(if (= PfostenAufKopf  1) (Anbauteil.set abtl_LB_HT (delta_LR (+ dlr_Lchb))))
	))
	(if (= TreppeAufwaerts 0) (if (= TreppeAbwaerts 0) (progn
		(Anbauteil.set abtl_LB_HT (delta_LR (- dlr_Lchb)))
	)))
	
	(setq bp_Fahne (Blech.get Bl_Fahne bp))
	(setq  s_Abstand 0)
	(setq qsForm_AT (Traeger.get Tr_ID qsForm)
		  b_AT		(Traeger.get Tr_ID b)
	)
	(if (= qsForm_AT "F") (setq s_Abstand (* 0.5 b_AT)))
	
	(if (= an_AT_links  1) (setq  s_Abstand (- (+ s_Abstand bp_Fahne))))
	(if (= an_AT_rechts 1) (setq  s_Abstand (+ s_Abstand bp_Fahne)))
	
	
	(Anbauteil.set  abtl_LB_AT (Delta_SX  s_Abstand))
	
)
; -------------------------------------------------------------------------------------------------------
; ----- 
; -------------------------------------------------------------------------------------------------------
(defun calcVorabLichtenAbstand ()
	(setq 	dlr_AT	(Traeger.get Tr_ID delta_LR)
			b_AT	(Traeger.get Tr_ID b)
			t_HT	(Traeger.get HTrg t)
			h_AT	(Traeger.get Tr_ID h)
			r_AT 	(* 0.5 h_AT)
			dlr_AT	(* 1.0 dlr_AT)
			
			dv_HT	(Traeger.get HTrg delta_V)
			qsForm_AT (Traeger.get Tr_ID qsForm)
	)
	
	(setq  Achs_Abstand 0.0)

	(if (= (Connect.get CastaData satr-vhtr)  1) 	(setq Achs_Abstand (-  dlr_AT dv_HT)))
	(if (= (Connect.get CastaData satr-vhtr) -1) 	(setq Achs_Abstand (+  dlr_AT dv_HT)))
	(if (< Achs_Abstand 0) (setq Achs_Abstand (- Achs_Abstand)))

	(if (= qsForm_AT "R") (progn
		(setq LichterAbstand (- Achs_Abstand (* 0.5 t_HT) r_AT))
	  )
	  (progn
		(setq LichterAbstand (- Achs_Abstand (* 0.5 t_HT) (* 0.5 b_AT)))
	))
	(print  LichterAbstand)

)

(defun init_Geometry ()
	(print "------------------------ in init_Geometry -----------------")
	(setq Ht_Winkel (Connect.get CastaData  v-atrgewnkl_Steg))
	(print Ht_Winkel)
	
	(setq sinV (sin (* PI (/ Ht_Winkel 180.0))))
	(setq cosV (cos (* PI (/ Ht_Winkel 180.0))))
	(setq tanV (tan (* PI (/ Ht_Winkel 180.0))))

	(setq links_vorbei 0)
	(setq rechts_vorbei 0)
	(setq 	dv_HT	(Traeger.get HTrg delta_V)
			dlr_AT	(Traeger.get Tr_ID delta_LR)
			b_AT	(Traeger.get Tr_ID b)
			t_HT	(Traeger.get HTrg t)
	)
	(setq	dlr_AT (* 1.0 dlr_AT)
			dv_HT  (* 1.0 dv_HT)
	)
	
	(setq  Achs_Abstand 0.0)
	(if (= (Connect.get CastaData satr-vhtr)  1) 	(setq Achs_Abstand (-  dlr_AT dv_HT)))
	(if (= (Connect.get CastaData satr-vhtr) -1) 	(setq Achs_Abstand (+  dlr_AT dv_HT)))
	
	
	(if (> Achs_Abstand 0) (progn
		(if (= (Connect.get CastaData satr-vhtr)  1) 	(setq rechts_vorbei 1))
		(if (= (Connect.get CastaData satr-vhtr) -1) 	(setq links_vorbei 1))
	))
	(if (< Achs_Abstand 0) (progn
		(if (= (Connect.get CastaData satr-vhtr)  1) 	(setq links_vorbei 1))
		(if (= (Connect.get CastaData satr-vhtr) -1) 	(setq rechts_vorbei 1))
		; (setq Achs_Abstand (- Achs_Abstand))
	))

	
	(setq unten_vorbei 0)
	(setq oben_vorbei 0)
	(if (> Achs_Abstand 0) (progn
		(if (= (Connect.get CastaData satr-vhtr) -1) 	(setq oben_vorbei 1))
		(if (= (Connect.get CastaData satr-vhtr)  1) 	(setq unten_vorbei 1))
	))
	(if (< Achs_Abstand 0) (progn
		(if (= (Connect.get CastaData satr-vhtr) -1) 	(setq unten_vorbei 1))
		(if (= (Connect.get CastaData satr-vhtr)  1) 	(setq oben_vorbei 1))
		(setq Achs_Abstand (- Achs_Abstand))
	))

	(setq an_AT_links    0)
	(setq an_AT_rechts 0)
	(if (= links_vorbei 1) (progn
		(if (= (Connect.get CastaData satr-vhtr)  1) 	(setq an_AT_rechts    1))
		(if (= (Connect.get CastaData satr-vhtr) -1) 	(setq an_AT_links 1))
	))
	(if (= rechts_vorbei 1) (progn
		(if (= (Connect.get CastaData satr-vhtr)  1) 	(setq an_AT_links  1))
		(if (= (Connect.get CastaData satr-vhtr) -1) 	(setq an_AT_rechts     1))
	))
	
	(setq h_HT 	(Traeger.get HTrg h)
			 dv_HT 	(Traeger.get HTrg delta_V)
	)
	; Achsenlnge berechnen, von dieser relativ aus die brigen Werte
	(setq AchsenLaenge 	(+ (* 0.5 h_HT) dv_HT))
	(if (/= sinV 0.0) 	(setq AchsenLaenge 	(/ (* 1.0  AchsenLaenge) sinV)))

	; Lichten Abstand berechnen
	(setq t_HT (Traeger.get HTrg t))
	(setq qsForm_AT (Traeger.get Tr_ID qsForm)
		  h_AT (Traeger.get Tr_ID h)
		  b_AT (Traeger.get Tr_ID b)
		  r_AT (* 0.5 h_AT)
	)
	(if (= qsForm_AT "R") (progn
		(setq LichterAbstand (- Achs_Abstand (* 0.5 t_HT) r_AT))
	  )
	  (progn
		(setq LichterAbstand (- Achs_Abstand (* 0.5 t_HT) (* 0.5 b_AT)))
	))
	
	(setq V_KopfWinkel (Connect.get CastaData v-atrgewnkl_kopf))
	
	(if (= (Connect.get CastaData anHTlinkesEnde )  0) (progn
		(if (= (Connect.get CastaData anHTrechtesEnde )  0) (progn
			(if (= (Connect.get CastaData rechtesEnde)  1) (setq V_KopfWinkel (- 180.0 V_KopfWinkel)))
		))
	))
	; v-atrgewnkl_kopf wird am Profilende anders festgelegt als im Verlauf des Profils 
	(setq an_AT_Trg_Ende 0)
	(if (= (Connect.get CastaData linkesEnde)  1) (setq an_AT_Trg_Ende 1))
	(if (= (Connect.get CastaData rechtesEnde) 1) (setq an_AT_Trg_Ende 1))
	(if (= (Connect.get CastaData anHTlinkesEnde )  1) (progn
		(if (= an_AT_Trg_Ende 1) (setq V_KopfWinkel (- 180.0 V_KopfWinkel)))
	))
	(if (= (Connect.get CastaData anHTrechtesEnde )  1) (progn
		(if (= (Connect.get CastaData linkesEnde) 1) (setq V_KopfWinkel (- 180.0 V_KopfWinkel)))
	))

	(setq AT_Winkel_K V_KopfWinkel)
	
	
	(if (= (Connect.get CastaData at-von-links)  1) (progn
		(if (= (Connect.get CastaData satr-vhtr)  1) 	(setq AT_Winkel_K (- 180.0 V_KopfWinkel)))
	))
	(if (= (Connect.get CastaData at-von-rechts)  1) (progn
		(if (= (Connect.get CastaData satr-vhtr)  -1) 	(setq AT_Winkel_K (- 180.0 V_KopfWinkel)))
	))
	
	; Man knnte auch v-atrgewnkl_steg, muss dann aber noch 90 subtrahieren bzw addieren.
	(setq V_StegWinkel (Connect.get CastaData v-atrgewnkl_steg))
	(setq V_KopfWinkel (Connect.get CastaData v-atrgewnkl_kopf))
	(setq HT_TrpVWinkel    (Connect.get CastaData hpttrg_vwinkel ))
	(setq AT_TrpVWinkel    (Connect.get CastaData trg_vwinkel ))

	(print V_StegWinkel) (print V_KopfWinkel)
	(Connect.showAttributes CastaData)

	(setq ControlWnkl (- V_StegWinkel V_KopfWinkel))
	(if (< ControlWnkl   0) (setq ControlWnkl (- ControlWnkl)))
	(setq ControlWnkl (* 1 (+ ControlWnkl 0.25)))

	(setq V_StegWinkel (- V_StegWinkel 90.0))
	(if (= ControlWnkl 90) 
		(setq V_StegWinkel (- V_StegWinkel 90.0))
		(setq V_StegWinkel (- 90.0 V_StegWinkel))
	)

	(setq TreppeAufwaerts  0)
	(setq TreppeAbwaerts   0)
	(setq PfostenAufrecht  0)
	(setq PfostenAufKopf   0)

	(setq Sonderfall 0)
	(if (= (Connect.get CastaData linkesEnde) 0) 
		(if (= (Connect.get CastaData rechtesEnde) 0) (setq Sonderfall 1))
	)
	(if (< V_StegWinkel 0.0) (progn
		(if (= Sonderfall 0) (progn
			(if (>=  V_StegWinkel -90.0) (setq TreppeAbwaerts 1 PfostenAufrecht 1))
			(if (<   V_StegWinkel -90.0) (setq TreppeAbwaerts 1 PfostenAufKopf  1))
		))
	))
	(if (>= V_StegWinkel 0.0) (progn
		(if (= Sonderfall 0) (progn
			(if (<=  V_StegWinkel  90.0) (setq TreppeAufwaerts 1 PfostenAufrecht 1))
			(if (>   V_StegWinkel  90.0) (setq TreppeAufwaerts 1 PfostenAufKopf  1))
		))
	))
	(if (= Sonderfall 1) (progn 
		(if (< V_StegWinkel 0.0)  (progn 
			(if (<= V_StegWinkel -90.0) (setq TreppeAufwaerts 1 PfostenAufKopf  1))
			(if (>  V_StegWinkel -90.0) (setq TreppeAbwaerts  1 PfostenAufrecht 1))
		))
		(if (>= V_StegWinkel 0.0) (progn 
			(if (<= V_StegWinkel 90.0)  (setq TreppeAufwaerts 1 PfostenAufrecht 1))
			(if (>  V_StegWinkel 90.0)  (setq TreppeAbwaerts  1 PfostenAufKopf  1))
		))
	))

	(setq TreppeAufwaerts 0 TreppeAbwaerts 0)
	(if (>= HT_TrpVWinkel   0.0) (if (<=  HT_TrpVWinkel  90.0) (setq TreppeAufwaerts 1)))
	(if (>= HT_TrpVWinkel 270.0) (if (<=  HT_TrpVWinkel 360.0) (setq TreppeAbwaerts  1)))

	(setq PfostenAufrecht 0 PfostenAufKopf 0)
	(if (>= AT_TrpVWinkel   0.0) (if (<=  AT_TrpVWinkel  90.0) (setq PfostenAufrecht 1)))
	(if (>= AT_TrpVWinkel 270.0) (if (<=  AT_TrpVWinkel 360.0) (setq PfostenAufKopf  1)))


	; ---------------------------------------------------------------------------------
	; ---------------------------------------------------------------------------------
	; Man knnte auch v-atrgewnkl_steg, muss dann aber noch 90 subtrahieren bzw addieren.
	(setq V_StegWinkel (Connect.get CastaData v-atrgewnkl_steg))
	
	(setq HT_TrpVWinkel    (Connect.get CastaData hpttrg_vwinkel ))
	(setq AT_TrpVWinkel    (Connect.get CastaData trg_vwinkel ))
	(setq TreppeAufwaerts 0 TreppeAbwaerts 0)
	(if (> HT_TrpVWinkel   0.0) (if (<=  HT_TrpVWinkel  90.0) (setq TreppeAufwaerts 1)))
	(if (> HT_TrpVWinkel 270.0) (if (<=  HT_TrpVWinkel 360.0) (setq TreppeAbwaerts  1)))

	(setq PfostenAufrecht 0 PfostenAufKopf 0)
	(if (>= AT_TrpVWinkel   0.0) (if (<=  AT_TrpVWinkel  90.0) (setq PfostenAufrecht 1)))
	(if (>= AT_TrpVWinkel 270.0) (if (<=  AT_TrpVWinkel 360.0) (setq PfostenAufKopf  1)))

	(setq AT_Winkel_K (- 180.0 V_StegWinkel))
	
	; ---------------------------------------------------------------------------------

	(if (= (Connect.get CastaData at-von-links) 1)  (setq AT_Winkel_K V_StegWinkel))
	(if (= (Connect.get CastaData at-von-rechts) 1) (setq AT_Winkel_K (- 180.0 V_StegWinkel)))

	(if (= PfostenAufrecht 1) (progn
			(if (= (Connect.get CastaData AnschlzwAtEnden) 1) (progn
				(if (= (Connect.get CastaData at-von-links) 1) (progn
					(setq AT_Winkel_K (+ 180.0 V_StegWinkel))
				))
				(if (= (Connect.get CastaData at-von-rechts) 1) (progn
					(setq AT_Winkel_K (- 180.0 V_StegWinkel))
				))
			))
	))
	(if (= PfostenAufKopf 1) (progn
			(if (= (Connect.get CastaData AnschlzwAtEnden) 1) (progn
				(if (= (Connect.get CastaData at-von-links) 1) (progn
					(setq AT_Winkel_K (- 180.0 V_StegWinkel))
				))
				(if (= (Connect.get CastaData at-von-rechts) 1) (progn
					(setq AT_Winkel_K (+ 180.0 V_StegWinkel))
				))
			))
	))
	
	; neue Lsung ------------------
	(setq V_StegWinkel (Connect.get CastaData v-atrgewnkl_steg))
	(setq AT_Winkel_K (-  90.0 V_StegWinkel))


)
; -------------------------------------------------------------------------------------------------------







; -------------------------------------------------------------------------------------------------------
(defun AT_EndLaenge ()
	(setq hp_KP 	(Blech.get Bl_Kontaktplatte hp)
		  dOK_KP	(Blech.get Bl_Kontaktplatte dOK)
	)
	
	(setq abtl_FahnenBl (Traeger.get Tr_ID ABTeil Bl_Fahne))
	(setq Wnkl_Fahne (Anbauteil.get abtl_FahnenBl Winkel))
	
	(setq Fall 0)
	(setq dl_EndLaenge 0.0)

	(if (= (Connect.get CastaData at-von-links)  1) (setq Fall 1))
	(if (= (Connect.get CastaData at-von-rechts) 1) (setq Fall 2))

	(if (= Fall 1) 	(progn
		(if (= PfostenAufrecht 1) (setq dl_EndLaenge (- (* 0.5 hp_KP) dOK_KP)))
		(if (= PfostenAufKopf  1) (setq dl_EndLaenge (+ (* 0.5 hp_KP) dOK_KP)))
	))
	(if (= Fall 2) 	(progn
		(if (= PfostenAufrecht 1) (setq dl_EndLaenge (- (* 0.5 hp_KP) dOK_KP)))
		(if (= PfostenAufKopf  1) (setq dl_EndLaenge (+ (* 0.5 hp_KP) dOK_KP)))
	))


	(if (= (Connect.get CastaData linkesEnde) 1) (progn
			(setq dl_EndLaenge (- (* 0.5 hp_KP) dOK_KP))
			(setq tEnde (Traeger.get Tr_ID links))
			(TrEnde.set tEnde (delta_L (- dl_EndLaenge)))
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
			(setq dl_EndLaenge (+ (* 0.5 hp_KP) dOK_KP))
			(setq tEnde (Traeger.get Tr_ID rechts))
			(TrEnde.set tEnde (delta_L (- dl_EndLaenge)))
	))
	
	
)

(defun addFahnenBlech  ()

	(setq 	h_HT 			(Traeger.get HTrg h)
			dv_HT 			(Traeger.get HTrg delta_V)
			h_HT2_schraeg	(* 0.5 h_HT)
	)
	(calc_bpFahne)
	; Achsenlnge berechnen, von dieser relativ aus die brigen Werte
	(if (/= sinV 0.0) (setq h_HT2_schraeg (/  (* 0.5 h_HT) sinV)))

	; Blech mittig vertkal einsetzen
	(setq d_BlOK    		(- AchsenLaenge  h_HT2_schraeg))
	
	(print bp_Fahne)
	(if (> bp_Fahne 0) (progn
		(setq Bl_Fahne (Blech.create))
		(Blech.set  Bl_Fahne (hp 200) (bp 100) (dp 10))

		(Blech.set  Bl_Fahne	(bp bp_Fahne))

		(setq xPos_AT (Connect.get CastaData xPos_AT))
		
		(setq Winkel_FahnBl 0.0)
		(if (= (Connect.get CastaData at-von-oben) 1) (setq Winkel_FahnBl 180.0))
		
		(if (= an_AT_links  1) (traeger.addabtl Tr_ID Bl_Fahne xPos_AT Winkel_FahnBl _fahnenblech_steg_li_))
		(if (= an_AT_rechts 1) (traeger.addabtl Tr_ID Bl_Fahne xPos_AT Winkel_FahnBl _fahnenblech_steg_re_))

	    (Blech.set Bl_Fahne 	        (formFkt "cb_Fahne"))
		(Connect.storeAnschlObjs CastaData   Bl_Fahne)
	))

)
(defun cb_Fahne (zp)
	; hier noch die Reaktionen auf Fahnenblechnderungen hin
	; bp soll nicht nderbar sein.
	
	(if (= zp 0) (progn
		(setq bp_Alt (Blech.get Bl_Fahne bp))
	))
	(if (= zp 1) (progn
		(setq bp_Neu (Blech.get Bl_Fahne bp))
		(if (/= bp_Neu bp_Alt) (Blech.set Bl_Fahne (bp bp_Alt)))
	))
)
(defun 	cb_KontPlatte (zp)
	(if (= (Connect.get CastaData CopyMode) 1) (progn
		(if (= zp 0) (progn
			(setq curr_DY (Blech.get Bl_Kontaktplatte delta_y blAbstand))
		))
		(if (= zp 1) (progn
			(Blech.set Bl_Kontaktplatte (delta_y curr_DY))
		))
	))

	(if (= zp 0) (progn
		(setq dp_Alt (Blech.get Bl_Kontaktplatte dp))
	))
	(if (= zp 1) (progn
		(setq dp_Neu (Blech.get Bl_Kontaktplatte dp))
		(if (/= dp_Neu dp_Alt) (progn
			(setq dp_Diff (-  dp_Neu dp_Alt))
			(if (objExist Lb_Lochbild) (progn
				(setq curr_klemmL (Lochbild.get Lb_Lochbild KlemmL))
				(Lochbild.set Lb_Lochbild (KlemmL (+ curr_klemmL dp_Diff)))
			))
			(if (objExist Bl_Fahne) (progn
				(setq curr_bp (Blech.get Bl_Fahne bp))
				(Blech.set Bl_Fahne (bp (- curr_bp dp_Diff)))
			))
			(setq curr_DY (Blech.get Bl_Kontaktplatte delta_y blAbstand))
			(Blech.set Bl_Kontaktplatte (delta_y (- curr_DY dp_Diff)))
		))
	))

)


(defun calc_bpFahne ()
	; Breite berechnen - Abstand zwischen HT und AT
	(setq 	dlr_HT	(Traeger.get HTrg delta_LR)
			dlr_AT	(Traeger.get Tr_ID delta_LR)
			b_AT	(Traeger.get Tr_ID b)
			s_HT	(Traeger.get HTrg s)
			t_HT	(Traeger.get HTrg t)
			b_HT	(Traeger.get HTrg b)
	)
	(print links_vorbei)
	(print rechts_vorbei)

	(setq bp_Fahne (- Achs_Abstand (* 0.5 b_AT))) 

	(setq  qsForm_HT (Traeger.get HTrg qsForm))
	(if (= qsForm_HT "U") (progn
		(if  (= rechts_vorbei 1)  (setq bp_Fahne (- bp_Fahne s_HT)))
	))
	(if (= qsForm_HT "I") (progn
		(setq bp_Fahne (- bp_Fahne (* 0.5 s_HT)))
	))
	(if (= qsForm_HT "K") (progn
		(setq bp_Fahne (- bp_Fahne (* 0.5 b_HT)))
	))
	(if (= qsForm_HT "F") (progn
		(setq bp_Fahne (- bp_Fahne (* 0.5 t_HT)))
	))
	(setq  bp_Fahne (- bp_Fahne dp_KPLatte))

	)
; -------------------------------------------------------------------------------------------------------
(defun FahneAnpassen ()

	(if (objExist Bl_Fahne) (progn
		(setq dOK_Bl (Blech.get Bl_Kontaktplatte dOK)
			  hp_Bl  (Blech.get Bl_Kontaktplatte hp)
		)

		(setq  qsForm_AT (Traeger.get Tr_ID qsForm))
		(if (= qsForm_AT "F") (progn
			(setq t_AT (Traeger.get Tr_ID t))
			(Blech.set Bl_Fahne (dp t_AT))
		))
		
		(setq dOK_Bl (- dOK_Bl))
		(Blech.set Bl_Fahne 
				(hp hp_Bl)
				(dOK dOK_Bl)
		)
	))


)
