; $	HT	QT(F)	 	AF(F)		P(EZ)
; $	AT	QT(RK) 		AF(FS)		P(EZ)
; $	AE	V(-)		H(-)			R(-)

;	Bedingngen: Rohrpfosten sollte nur seitlich verschoben sein, also nicht 90 zur Trgerachsel liegen.

(defun load-modules ()
	(print "Module einladen")
)

(defun init-connection ()
	(print "*clear*")
	(print "Connection erstellen")
	
	(Connect.showAttributes CastaData)

	; Einstellungen ...
	(setq LB_Master_AT  0)
	(setq LB_Master_HT  1)
	
	(setq Anschluss_Erzeugen 1)

	(init_Geometry)					; Geometrie initialisieren - Winkel und Winkelfunktionswerte
									; Davon abhngig Anschluss_Erzeugen setzen
	
	(if (< LichterAbstand 30) (setq Anschluss_Erzeugen 0))
	(if (= Anschluss_Erzeugen 1) (progn
		(createConnection)
		; (testConnection)
	))
	
	(if (= Anschluss_Erzeugen 0) (progn
		(alertBox "Anschluss ist nicht mglich!"  "Connection_Not_Possible")
	))
	
)
(defun createConnection ()

	(print "-----------------------------------------------------------")
	(print Achs_Abstand)
	(print links_vorbei)
	(print rechts_vorbei)

	(print an_AT_links)
	(print an_AT_rechts)
	(print LichterAbstand)

	(setq GlobalFall 0)
	(if (= links_vorbei  1) (if (= an_AT_links  1) (setq GlobalFall 1)))
	(if (= rechts_vorbei 1) (if (= an_AT_rechts 1) (setq GlobalFall 1)))
	(if (= links_vorbei  1) (if (= an_AT_rechts 1) (setq GlobalFall 2)))
	(if (= rechts_vorbei 1) (if (= an_AT_links  1) (setq GlobalFall 2)))
	; (setq GlobalFall -1)
	
	(createFahne_an_Pfosten)
	(createFahne_an_Flach)
	(setOrCreateLochbild)
	(Lochbild_an_Pfosten)
	(Lochbild_an_Wange)
	(LochbildVerwaltung)
	(setFahnenVersatz_HTrg)
	
	(AT_EndLaenge)
	
)
; -----------------------------
(defun testConnection ()

	(Lochbild.set Lb_Lochbild (e "0 30 70 0 0 0"))
;	(Lochbild.set Lb_Lochbild (w "30 0 0 0"))

	(Blech.set Bl_Kontaktplatte (x4 20) (y4 10))
	
	(Connect.showAttributes CastaData)

	(setq abtl_LB_HT (Traeger.get HTrg  ABTeil Lb_Lochbild))
	(setq abtl_LB_AT (Traeger.get Tr_ID ABTeil Lb_Lochbild))
	(Anbauteil.set abtl_LB_AT (Master 1))
	(Anbauteil.set abtl_LB_HT (Master 0))
	
	(setq Winkel_LB_HT (Anbauteil.get abtl_LB_HT Winkel))
	(setq Winkel_LB_AT (Anbauteil.get abtl_LB_AT Winkel))
	
	(print "...................... testConnection .................")
	(if (= (Connect.get CastaData at-von-links)  1) (print "Der AT kommt von links"))
	(if (= (Connect.get CastaData at-von-rechts) 1) (print "Der AT kommt von rechts"))
	(if (= links_vorbei  1) (print "am HT links  vorbei"))
	(if (= rechts_vorbei 1) (print "am HT rechts vorbei"))


	(if (= 4 1) (progn
		(if (= links_vorbei 1) (progn
			(if (= (Connect.get CastaData at-von-rechts) 1) (AlertBox "links vorbei - am AT rechts"))
			(if (= (Connect.get CastaData at-von-links) 1)  (AlertBox "links vorbei - am AT links"))
		))
		(if (= rechts_vorbei 1) (progn
			(if (= (Connect.get CastaData at-von-rechts) 1) (AlertBox "rechts vorbei - am AT rechts"))
			(if (= (Connect.get CastaData at-von-links) 1)  (AlertBox "rechts vorbei - am AT links"))
		))
	))

	(if (= 4 1) (progn
		(if (= TreppeAufwaerts 1) (progn
			(if (= PfostenAufrecht 1) (AlertBox "Treppe aufwrts, Pfosten aufrecht"))
			(if (= PfostenAufKopf  1) (AlertBox "Treppe aufwrts, Pfosten auf Kopf"))
		))
		(if (= TreppeAbwaerts 1) (progn
			(if (= PfostenAufrecht 1) (AlertBox "Treppe abwrts, Pfosten aufrecht"))
			(if (= PfostenAufKopf  1) (AlertBox "Treppe abwrts, Pfosten auf Kopf"))
		))

		(AlertBox V_StegWinkel)
		(AlertBox ControlWnkl)
	))
	
	(if (= 1 2) (progn
		(setq DOK_Kontaktplatte (Blech.get Bl_Kontaktplatte dOK))
		(AlertBox DOK_Kontaktplatte)
		(Blech.set Bl_Kontaktplatte (dOK 0))
	))
	(if (= 1 2) (progn
		(setq abtl_Fahne (Traeger.get HTrg ABTeil Bl_Fahne))
		(setq wnkl_Fahne (Anbauteil.get abtl_Fahne Winkel))
		(AlertBox wnkl_Fahne)
	))

	
	
)


(defun createFahne_an_Pfosten ()
	(setq Bl_Kontaktplatte (Blech.create))
	
	; _fahnenblech_of_
	; _fahnenblech_uf_
	; _fahnenblech_steg_li_
	; _fahnenblech_steg_re_
	
	
	(setq b_HT (Traeger.get HTrg b))	; Breite, weil es ein Flachstahl ist (stehend auf der Kante)
	(setq h_AT (Traeger.get Tr_ID h))	; ist ja ein Rohr - ansonsten msste man unterscheiden
	(setq hp_KP b_HT)
	(setq bp_KP LichterAbstand)	; S-Durchm 16 angenommen

	; 	(Blech.set Bl_Kontaktplatte (dp LichterAbstand))
	(Blech.set  Bl_Kontaktplatte (hp hp_KP) (bp bp_KP) (dp 10))

	(Blech.set  Bl_Kontaktplatte (hp (- hp_KP 50)))

	(setq rWinkel   0.0)

	(if (= GlobalFall 1) (setq rWinkel   0.0))			; links vorbei and AT links bzw rechts vorbei an AT rechts
	(if (= GlobalFall 2) (setq rWinkel 180.0))			; links vorbei and AT rechts bzw rechts vorbei an AT links
	(setq rWinkel (- rWinkel 180.0))
	(if (= (Connect.get CastaData AnschlzwAtEnden) 1) (if (= (Connect.get CastaData at-von-links) 1) (setq rWinkel (+ rWinkel 180.0))))

	(setq xPos_AT (Connect.get CastaData xPos_AT))
	
	(if (= an_AT_links 1)  (traeger.addabtl Tr_ID Bl_Kontaktplatte xPos_AT rWinkel _fahnenblech_steg_li_))
	(if (= an_AT_rechts 1) (traeger.addabtl Tr_ID Bl_Kontaktplatte xPos_AT rWinkel _fahnenblech_steg_re_))

	(Connect.storeAnschlObjs CastaData Bl_Kontaktplatte)

	
)
(defun createFahne_an_Flach ()
	(setq Bl_Fahne (Blech.create))
	
	; _fahnenblech_of_
	; _fahnenblech_uf_
	; _fahnenblech_steg_li_
	; _fahnenblech_steg_re_
	
	
	(setq b_HT (Traeger.get HTrg b))	; Breite, weil es ein Flachstahl ist (stehend auf der Kante)
	(setq h_AT (Traeger.get Tr_ID h))	; ist ja ein Rohr - ansonsten msste man unterscheiden
	(setq hp_KP b_HT)
	(setq bp_KP LichterAbstand)	; S-Durchm 16 angenommen

	; 	(Blech.set Bl_Fahne (dp LichterAbstand))
	(Blech.set  Bl_Fahne (hp hp_KP) (bp bp_KP) (dp 6))
	(Blech.set  Bl_Fahne (hp (- hp_KP 50.0)))

	(setq rWinkel (- AT_Winkel_K))

	(print AT_Winkel_K)
	(print rWinkel)
	(setq sAtrVHtr (Connect.get CastaData sAtr-vHtr))
	(setq vAtrLHtr (Connect.get CastaData vAtr-lHtr))
	(print sAtrVHtr) (print vAtrLHtr)
	(print "--------------------------------------")

	(setq xPos_HT (Connect.get CastaData xPos_HT))

	(setq am_AT_Ende 1)
	(if (= (Connect.get CastaData linkesEnde) 0) (if (= (Connect.get CastaData rechtesEnde) 0) 	  (progn
		; zwischen den AT-Enden
		(setq am_AT_Ende 0)
		(if (= (Connect.get CastaData sAtr-vHtr)  -1) (setq rWinkel (- rWinkel)))
		(setq rWinkel (+ rWinkel 180.0))
	)))
	(if (= am_AT_Ende 1) (progn
		(setq V_StegWinkel (Connect.get CastaData v-atrgewnkl_steg))
		(if (= PfostenAufKopf 1) (setq V_StegWinkel (- 180.0 V_StegWinkel)))
		(if (= TreppeAbwaerts 1) (setq V_StegWinkel (- 180.0 V_StegWinkel)))
		(if (= (Connect.get CastaData vAtr-sHtr)  -1) (progn
			(if (> V_StegWinkel 90.0) 
				(setq rWinkel (- V_StegWinkel 180.0))
				(setq rWinkel V_StegWinkel)
			)
		))
		(if (= (Connect.get CastaData vAtr-sHtr)  1) (progn
			(if (> V_StegWinkel 90.0) 
				(setq rWinkel (- V_StegWinkel))
				(setq rWinkel (- (- V_StegWinkel 180.0)))
			)
		))
		(if (= (Connect.get CastaData vAtr-sHtr)  0) (progn
			(if (= (Connect.get CastaData vAtr-lHtr) -1) (setq rWinkel    V_StegWinkel))
			(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq rWinkel (- V_StegWinkel)))
		))
	))

	(if (= links_vorbei 1)  (traeger.addabtl HTrg Bl_Fahne xPos_HT rWinkel _fahnenblech_of_))
	(if (= rechts_vorbei 1) (traeger.addabtl HTrg Bl_Fahne xPos_HT rWinkel _fahnenblech_uf_))

	(Connect.storeAnschlObjs CastaData Bl_Fahne)
	

	(setq Fall 0)
	(if (= (Connect.get CastaData at-von-links)  1) (setq Fall 1))
	(if (= (Connect.get CastaData at-von-rechts) 1) (setq Fall 2))
	(print Fall)


	; delta_LR des HT hat Einfluss auf die seitliche Lage der Fahne bei schrgem HT
	(setq deltaLR_HT (Traeger.get HTrg delta_LR))

	(setq sinW (sin (* PI (/ rWinkel 180.0))))
	(setq cosW (cos (* PI (/ rWinkel 180.0))))
	
	(setq deltaV_Blech  (* 0.5  deltaLR_HT))
	(setq deltaLR_Blech (* cosW deltaLR_HT))

	(setq deltaV_Blech 0.0)

	(if (= Fall 1) (Blech.set Bl_Fahne (dOK (- deltaV_Blech))))
	(if (= Fall 2) (Blech.set Bl_Fahne (dOK    deltaV_Blech)))
	
	; seitlich verschieben, damit Bleche nicht kollidieren
	(setq dp_Fahne_1 (Blech.get Bl_Fahne dp))
	(setq dp_Fahne_2 (Blech.get Bl_Kontaktplatte dp))
	; man knnte noch die Richtung festlegen - oder ber dxSKopf
	(setq sVerschieb (* 0.5 (+ dp_Fahne_1 dp_Fahne_2)))

	(setq  sVerschieb (- sVerschieb deltaLR_Blech))

	(setq dv_AT (Traeger.get Tr_ID delta_v))
	
	(if (= (Connect.get CastaData vatr-lhtr) -1) (progn
		(if (= am_AT_Ende  0) (progn
			(if (= (Connect.get CastaData satr-vhtr) -1) (setq dv_AT (- dv_AT)))
		))
	))
	(if (= (Connect.get CastaData vatr-lhtr)  1) (progn
		(if (= am_AT_Ende  0) (progn
			(if (= (Connect.get CastaData satr-vhtr) 1) (setq dv_AT (- dv_AT)))
		))
	))
	(setq sVerschieb (- sVerschieb dv_AT))

	(Blech.set Bl_Fahne (xAsym sVerschieb))
	
)

(defun Lochbild_an_Pfosten ()
	(setq rWinkel 0.0)
	(setq xPos_AT (Connect.get CastaData xPos_AT))

	(setq AbtlFahnenBl_AT (Traeger.get Tr_ID ABTeil Bl_Kontaktplatte))
	(Traeger.addabtl Tr_ID Lb_Lochbild xPos_AT 0.0 _fahnblLochbild_ AbtlFahnenBl_AT)
	

)
(defun Lochbild_an_Wange ()
	(setq rWinkel 0.0)
	(setq SWinkel (Connect.get CastaData v-atrgewnkl_steg))
	(setq diffWnkl (- 90.0 SWinkel))

	; AT_Winkel_K wurde vorher berechnet
	(setq diffWnkl (Connect.get CastaData v-atrgewnkl_kopf))
	
		
	(setq Fall 0)
	(if (= (Connect.get CastaData at-von-links)  1) (setq Fall 1))
	(if (= (Connect.get CastaData at-von-rechts) 1) (setq Fall 2))
	(print Fall)

	(if (= Fall 1) (setq rWinkel 180.0))
	(if (= Fall 2) (setq rWinkel   0.0))
	
	(if (= GlobalFall 2) (progn
		(if (= Fall 1) (setq rWinkel    0.0))
		(if (= Fall 2) (setq rWinkel  180.0))
	))

	(setq xPos_HT (Connect.get CastaData xPos_HT))
	(setq AbtlFahnenBl_HT (Traeger.get HTrg ABTeil Bl_Fahne))

;	(setq AT_End_Connection 1)
;	(if (= (Connect.get CastaData linkesEnde) 1) (if (= (Connect.get CastaData rechtesEnde) 1) (setq AT_End_Connection 1)))
;	(if (= AT_End_Connection 1) (progn
;		(setq rWinkel   0.0)
;		(if (= (Connect.get CastaData at-von-rechts) 1) (setq rWinkel 150.0))
;	))
	(setq rWinkel 0.0)


	; Hier Testen, ob Blech um 180 gedreht sein msste
	; (setq abtlBl_Winkel (Anbauteil.get AbtlFahnenBl_HT Winkel))
	; (Anbauteil.set AbtlFahnenBl_HT (Winkel (- abtlBl_Winkel 180.0)))
	; (setq LB_an_HTrg_Winkel rWinkel) (AlertBox LB_an_HTrg_Winkel)

	(Traeger.addabtl Htrg Lb_Lochbild xPos_HT rWinkel _fahnblLochbild_ AbtlFahnenBl_HT)	
	
	; (setq abtl_Lochbild_HT (Traeger.get HTrg ABTeil Lb_Lochbild))
	; (setq lbTestWinkel (Anbauteil.get abtl_Lochbild_HT Winkel))
	; (AlertBox lbTestWinkel)
	
)
(defun setOrCreateLochbild ()
	(setq Lb_Lochbild (Lochbild.create))

	(setq b_HT	(Traeger.get HTrg b))  ; Flachstahl auf der Kante stehend
	(setq t_HT	(Traeger.get HTrg t))
	(setq h_AT	(Traeger.get Tr_ID h))  ; Rohrpfosten - h = b
	(setq hp_KP	(Blech.get Bl_Kontaktplatte hp))
	(setq dp_KP (Blech.get Bl_Kontaktplatte dp))
	(setq dp_fP (Blech.get Bl_Fahne dp))
	
	(setq e_0 (/ hp_KP 4))
	(setq e_1 (* 2 e_0))
	
	(setq klLng (+ dp_KP dp_fP))
	
	(setq w_0 (* 0.5 LichterAbstand))
	(Lochbild.set  Lb_Lochbild 
			(S_Bez		"M12")
			(Guete   "4.6")
			(w0 w_0)
			(e0 e_0)
			(e1 e_1)
			(KlemmL klLng)
	)
	
	(Connect.storeAnschlObjs CastaData Lb_Lochbild)

)
(defun LochbildVerwaltung ()
	(setq abtl_LB_AT (Traeger.get Tr_ID ABTeil Lb_Lochbild))
	(setq abtl_LB_HT (Traeger.get HTrg  ABTeil Lb_Lochbild))
	(Anbauteil.set abtl_LB_AT (Master 0))
	(Anbauteil.set abtl_LB_HT (Master 1))
	
	(setq LB_SeitRicht -1)
	(Anbauteil.set abtl_LB_AT 
			(SeitRicht  LB_SeitRicht)
			(delta_LR   LichterAbstand)
	)

	(setq dlr_HT		(Traeger.get HTrg delta_LR))
	(setq rWnkl_Lchb_HT (Anbauteil.get abtl_LB_HT Winkel))
	(setq rWnkl_Lchb_AT (Anbauteil.get abtl_LB_AT Winkel))
	(print rWnkl_Lchb_HT)

	(setq sinW (sin (/ (* PI rWnkl_Lchb_HT) 180.0)))
	(setq cosW (cos (/ (* PI rWnkl_Lchb_HT) 180.0)))
	(setq dv_Lchb (* sinW dlr_HT))
	
	(Anbauteil.set abtl_LB_HT (delta_V (- dv_Lchb)))


	(if (< rWnkl_Lchb_HT 0.0) (setq rWnkl_Lchb_HT (+ rWnkl_Lchb_HT 360.0)))
	(setq dv_LB_HT (Anbauteil.get abtl_LB_HT delta_V))
	(setq dv_LB_AT (Anbauteil.get abtl_LB_AT delta_V))

	(setq dv_Fall 0)
	(if (= dv_Fall 0) (progn
	
		(setq hp_KonPlatte  (Blech.get Bl_Kontaktplatte hp)
			  dOK_KonPlatte (Blech.get Bl_Kontaktplatte dOK)
			  dOK_Fahne     (Blech.get Bl_Fahne dOK)
		)
		(setq abtl_Fahne_AT (Traeger.get Tr_ID ABTeil Bl_Kontaktplatte))
		(setq Wnkl_AT_Fahne (Anbauteil.get abtl_Fahne_AT Winkel))
		(if (< Wnkl_AT_Fahne 0.0) (setq Wnkl_AT_Fahne (- Wnkl_AT_Fahne)))
		
		(setq am_AT_Ende 0)
		(setq dv_Versch 0.0)
		(if (= (Connect.get CastaData linkesEnde) 1) (progn
			(if (< Wnkl_AT_Fahne 1.0) (setq dv_Versch (- (* 0.5 hp_KonPlatte) (- dv_LB_HT))))
			(if (> Wnkl_AT_Fahne 179.0) (if (< Wnkl_AT_Fahne 181.0) (setq dv_Versch (+ (* 0.5 hp_KonPlatte) dv_LB_HT))))
			(setq am_AT_Ende 1)
		))
		(if (= (Connect.get CastaData rechtesEnde) 1) (progn
			(if (< Wnkl_AT_Fahne 1.0) (setq dv_Versch (+ (* 0.5 hp_KonPlatte) dv_LB_HT)))
			(if (> Wnkl_AT_Fahne 179.0) (if (< Wnkl_AT_Fahne 181.0) (setq dv_Versch (+ (* 0.5 hp_KonPlatte) dv_LB_HT))))
			(setq am_AT_Ende 1)
		))
		(if (= am_AT_Ende 0) (progn
			(if (< Wnkl_AT_Fahne 1.0) (setq dv_Versch (- (* 0.5 hp_KonPlatte) (- dv_LB_HT))))
			(if (> Wnkl_AT_Fahne 179.0) (if (< Wnkl_AT_Fahne 181.0) (setq dv_Versch (+ (* 0.5 hp_KonPlatte) dv_LB_HT))))
		))

		(setq dv_LB_HT (- dv_LB_HT dv_Versch))
		(setq dv_LB_AT (- dv_LB_AT dv_Versch))
		(Anbauteil.set abtl_LB_HT (delta_V dv_LB_HT))
		(Anbauteil.set abtl_LB_AT (delta_V dv_LB_AT))
	))

	; Lochbildausrichtung
	(setq dp_KP (Blech.get Bl_Kontaktplatte dp))
	(setq dp_fP (Blech.get Bl_Fahne dp))
	(Lochbild.set  Lb_Lochbild  	(dxSKopf (+ (* 0.5 dp_fP) dp_KP)))

	; Master ist das HT-Lochbild
	(Lochbild.set  Lb_Lochbild  	(dxSKopf (+ (* 1.0 dp_KP) (* 0.5 dp_fP))))

	
)
; -------------------------------------------------------------------------------------------------------
; ----- 
; -------------------------------------------------------------------------------------------------------
(defun init_Geometry ()
	(print "------------------------ in init_Geometry -----------------")
	(setq Ht_Winkel (Connect.get CastaData  v-atrgewnkl_Steg))
	(print Ht_Winkel)
	
	(setq sinV (sin (* PI (/ Ht_Winkel 180.0))))
	(setq cosV (cos (* PI (/ Ht_Winkel 180.0))))
	(setq tanV (tan (* PI (/ Ht_Winkel 180.0))))

	(setq links_vorbei 0)
	(setq rechts_vorbei 0)
	(setq 	dv_HT	(Traeger.get HTrg delta_V)
			dlr_AT	(Traeger.get Tr_ID delta_LR)
			b_AT	(Traeger.get Tr_ID b)
			t_HT	(Traeger.get HTrg t)
	)
	(setq	dlr_AT (* 1.0 dlr_AT)
			dv_HT  (* 1.0 dv_HT)
	)
	
	(setq  Achs_Abstand 0.0)
	(if (= (Connect.get CastaData satr-vhtr)  1) 	(setq Achs_Abstand (-  dlr_AT dv_HT)))
	(if (= (Connect.get CastaData satr-vhtr) -1) 	(setq Achs_Abstand (+  dlr_AT dv_HT)))
	
	
	(if (> Achs_Abstand 0) (progn
		(if (= (Connect.get CastaData satr-vhtr)  1) 	(setq rechts_vorbei 1))
		(if (= (Connect.get CastaData satr-vhtr) -1) 	(setq links_vorbei 1))
	))
	(if (< Achs_Abstand 0) (progn
		(if (= (Connect.get CastaData satr-vhtr)  1) 	(setq links_vorbei 1))
		(if (= (Connect.get CastaData satr-vhtr) -1) 	(setq rechts_vorbei 1))
		; (setq Achs_Abstand (- Achs_Abstand))
	))

	
	(setq unten_vorbei 0)
	(setq oben_vorbei 0)
	
	(if (> Achs_Abstand 0) (progn
		(if (= (Connect.get CastaData satr-vhtr) -1) 	(setq oben_vorbei 1))
		(if (= (Connect.get CastaData satr-vhtr)  1) 	(setq unten_vorbei 1))
	))
	(if (< Achs_Abstand 0) (progn
		(if (= (Connect.get CastaData satr-vhtr)  1) 	(setq unten_vorbei 1))
		(if (= (Connect.get CastaData satr-vhtr) -1) 	(setq oben_vorbei 1))
		(setq Achs_Abstand (- Achs_Abstand))
	))

	(setq an_AT_links    0)
	(setq an_AT_rechts 0)
	(if (= links_vorbei 1) (progn
		(if (= (Connect.get CastaData satr-vhtr)  1) 	(setq an_AT_rechts    1))
		(if (= (Connect.get CastaData satr-vhtr) -1) 	(setq an_AT_links 1))
	))
	(if (= rechts_vorbei 1) (progn
		(if (= (Connect.get CastaData satr-vhtr)  1) 	(setq an_AT_links  1))
		(if (= (Connect.get CastaData satr-vhtr) -1) 	(setq an_AT_rechts     1))
	))
	
	(setq h_HT 	(Traeger.get HTrg h)
			 dv_HT 	(Traeger.get HTrg delta_V)
	)
	; Achsenlnge berechnen, von dieser relativ aus die brigen Werte
	(setq AchsenLaenge 	(+ (* 0.5 h_HT) dv_HT))
	(if (/= sinV 0.0) 	(setq AchsenLaenge 	(/ (* 1.0  AchsenLaenge) sinV)))

	; Lichten Abstand berechnen
	(setq t_HT (Traeger.get HTrg t))
	(setq h_AT (Traeger.get Tr_ID h)
		  r_AT (* 0.5 h_AT)
	)
	(setq LichterAbstand (- Achs_Abstand (* 0.5 t_HT) r_AT))

	; Man knnte auch v-atrgewnkl_steg, muss dann aber noch 90 subtrahieren bzw addieren.
	(setq V_StegWinkel (Connect.get CastaData v-atrgewnkl_steg))
	(setq V_KopfWinkel (Connect.get CastaData v-atrgewnkl_kopf))
	
	(setq HT_TrpVWinkel    (Connect.get CastaData hpttrg_vwinkel ))
	(setq AT_TrpVWinkel    (Connect.get CastaData trg_vwinkel ))
	(setq TreppeAufwaerts 0 TreppeAbwaerts 0)
	(if (> HT_TrpVWinkel   0.0) (if (<=  HT_TrpVWinkel  90.0) (setq TreppeAufwaerts 1)))
	(if (> HT_TrpVWinkel 270.0) (if (<=  HT_TrpVWinkel 360.0) (setq TreppeAbwaerts  1)))

	(setq PfostenAufrecht 0 PfostenAufKopf 0)
	(if (>= AT_TrpVWinkel   0.0) (if (<=  AT_TrpVWinkel  90.0) (setq PfostenAufrecht 1)))
	(if (>= AT_TrpVWinkel 270.0) (if (<=  AT_TrpVWinkel 360.0) (setq PfostenAufKopf  1)))

	(setq AT_Winkel_K (- 180.0 V_StegWinkel))
	
	; ---------------------------------------------------------------------------------

	(if (= (Connect.get CastaData at-von-links) 1)  (setq AT_Winkel_K V_StegWinkel))
	(if (= (Connect.get CastaData at-von-rechts) 1) (setq AT_Winkel_K (- 180.0 V_StegWinkel)))

	(if (= PfostenAufrecht 1) (progn
			(if (= (Connect.get CastaData AnschlzwAtEnden) 1) (progn
				(if (= (Connect.get CastaData at-von-links) 1) (progn
					(setq AT_Winkel_K (+ 180.0 V_StegWinkel))
				))
				(if (= (Connect.get CastaData at-von-rechts) 1) (progn
					(setq AT_Winkel_K (- 180.0 V_StegWinkel))
				))
			))
	))
	(if (= PfostenAufKopf 1) (progn
			(if (= (Connect.get CastaData AnschlzwAtEnden) 1) (progn
				(if (= (Connect.get CastaData at-von-links) 1) (progn
					(setq AT_Winkel_K (- 180.0 V_StegWinkel))
				))
				(if (= (Connect.get CastaData at-von-rechts) 1) (progn
					(setq AT_Winkel_K (+ 180.0 V_StegWinkel))
				))
			))
	))
	
	(if (= 2 3) (progn
		(setq am_HT_Ende 0)
		(if (= (Connect.get CastaData anHTlinkesEnde)  1) (setq am_HT_Ende 1))
		(if (= (Connect.get CastaData anHTrechtesEnde) 1) (setq am_HT_Ende 1))
		(if (= am_HT_Ende 1) (progn
			(if (= TreppeAufwaerts 1) (if (= PfostenAufrecht 1) (progn
				(setq AT_Winkel_K (- 360.0 AT_Winkel_K))
			)))
		))

			(if (= TreppeAbwaerts 1) (if (= PfostenAufKopf 1) (progn
				(setq AT_Winkel_K (- 360.0 AT_Winkel_K))
			)))
		
		(if (= am_HT_Ende 0) (progn
			(if (= TreppeAufwaerts 1) (if (= PfostenAufKopf 1) (progn
				(setq AT_Winkel_K (- 360.0 AT_Winkel_K))
			)))
		))
	))
	; neue Lsung ------------------
	(setq AT_Winkel_K (- 180.0 V_StegWinkel))

)
; -------------------------------------------------------------------------------------------------------







; -------------------------------------------------------------------------------------------------------
(defun AT_EndLaenge ()
	(setq hp_KP 	(Blech.get Bl_Kontaktplatte hp)
		  dOK_KP	(Blech.get Bl_Kontaktplatte dOK)
	)
	; ................................................
	(setq abtl_Fahne_AT (Traeger.get Tr_ID ABTeil Bl_Kontaktplatte))
	(setq Wnkl_AT_Fahne (Anbauteil.get abtl_Fahne_AT Winkel))
	(if (< Wnkl_AT_Fahne 0.0) (setq Wnkl_AT_Fahne (- Wnkl_AT_Fahne)))
	
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
		(if (< Wnkl_AT_Fahne 1.0) (setq dl_EndLaenge (- (* 0.5 hp_KP) (- dOK_KP))))
		(if (> Wnkl_AT_Fahne 179.0) (if (< Wnkl_AT_Fahne 181.0) (setq dl_EndLaenge (- (* 0.5 hp_KP) dOK_KP))))
		(setq tEnde (Traeger.get Tr_ID links))
		(TrEnde.set tEnde (delta_L (- dl_EndLaenge)))
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(if (< Wnkl_AT_Fahne 1.0) (setq dl_EndLaenge (- (* 0.5 hp_KP) dOK_KP)))
		(if (> Wnkl_AT_Fahne 179.0) (if (< Wnkl_AT_Fahne 181.0) (setq dl_EndLaenge (- (* 0.5 hp_KP) (- dOK_KP)))))
		(setq tEnde (Traeger.get Tr_ID rechts))
		(TrEnde.set tEnde (delta_L (- dl_EndLaenge)))
	))
	
	
)

(defun setFahnenVersatz_HTrg ()

	(setq abtl_Fahne (Traeger.get HTrg ABTeil Bl_Fahne))
	(setq wnkl_Fahne (Anbauteil.get abtl_Fahne Winkel))

	; Schrgwinkel Pfosten zu Wange bercksichtigen
	(setq Pf_Winkel (- 90.0 wnkl_Fahne))

	(setq cosW (cos (* PI (/ Pf_Winkel 180.0))))

	(setq deltaLR_HT (Traeger.get HTrg delta_LR))
	(setq deltaV_KPl  (* cosW deltaLR_HT))

	(Blech.set Bl_Kontaktplatte (dOK       deltaV_KPl))

)