; $	HT	QT(F)	 	AF(F)		P(EZ)
; $	AT	QT(FR) 		AF(FS)		P(EZ)
; $	AE	V(-)		H(-)			R(-)

;	Bedingngen: Rohrpfosten sollte nur seitlich verschoben sein, also nicht 90 zur Trgerachsel liegen.

(defun load-modules ()
	(print "Module einladen")
)

(defun init-connection ()
	(print "*clear*")
	(print "Connection erstellen")
	
	; (Connect.showAttributes CastaData)

	; Einstellungen ...
	(setq LB_Master_AT  0)
	(setq LB_Master_HT  1)
	
	(setq Anschluss_Erzeugen 1)
;	(if (/= (Connect.get CastaData satr-lhtr-ex) 0) (setq Anschluss_Erzeugen 0))
	
	; Ob das klappt - wohl eher nicht, weil es sich bei Flachstahl nicht um ein Steglochbild handelt.
    (if (= (Connect.get CastaData exist_steglchb) 1) (AlertBox "Achtung - gemeinsames Lochbild" "OppositeSideConnection_Found"))

	(calcVorabLichtenAbstand)
	(if (> LichterAbstand 35) (setq Anschluss_Erzeugen 0))
	(if (< LichterAbstand  2) (setq Anschluss_Erzeugen 0))
	
	(if (= Anschluss_Erzeugen 1) (progn
		(createConnection)
		; (testConnection)
	))
	
	(if (= Anschluss_Erzeugen 0) (progn
		; Abstand ist zu gro (oder zu gering) - Platte wrde zu dick (zu dnn) werden
		(alertBox "Anschluss nicht mglich."  "Connection_Not_Possible")
	))
	
	
)
(defun createConnection ()
	(init_Geometry)					; Geometrie initialisieren - Winkel und Winkelfunktionswerte

	(print "-----------------------------------------------------------")
	(print Achs_Abstand)

	(print AT_Winkel_K)
	
	(createAP_an_Pfosten)
	(setOrCreateLochbild)
	(Lochbild_an_Pfosten)
	(Lochbild_an_Wange)
	(LochbildVerwaltung)
	
	(AT_EndLaenge)
	
;	(testConnection)
	
)
; -----------------------------
(defun testConnection ()

	(Lochbild.set Lb_Lochbild (e "0 30 70 0 0 0"))
;	(Lochbild.set Lb_Lochbild (w "80 0 0 0"))
	(Lochbild.set Lb_Lochbild (LB_Art 2))

	(Blech.set Bl_Kontaktplatte (x3 20) (y3 10))
	
	; (Connect.showAttributes CastaData)

	(setq abtl_LB_HT (Traeger.get HTrg  ABTeil Lb_Lochbild))
	(setq abtl_LB_AT (Traeger.get Tr_ID ABTeil Lb_Lochbild))
	(Anbauteil.set abtl_LB_AT (Master 1))
	(Anbauteil.set abtl_LB_HT (Master 0))
	
	(setq Winkel_LB_HT (Anbauteil.get abtl_LB_HT Winkel))
	(setq Winkel_LB_AT (Anbauteil.get abtl_LB_AT Winkel))
	
	(print "...................... testConnection .................")
	(if (= (Connect.get CastaData at-von-links)  1) (print "Der AT kommt von links"))
	(if (= (Connect.get CastaData at-von-rechts) 1) (print "Der AT kommt von rechts"))

	(if (= 1 2) (progn
		(if (= TreppeAufwaerts 1) (progn
			(if (= PfostenAufrecht 1) (AlertBox "Treppe aufwrts, Pfosten aufrecht"))
			(if (= PfostenAufKopf  1) (AlertBox "Treppe aufwrts, Pfosten auf Kopf"))
		))
		(if (= TreppeAbwaerts 1) (progn
			(if (= PfostenAufrecht 1) (AlertBox "Treppe abwrts, Pfosten aufrecht"))
			(if (= PfostenAufKopf  1) (AlertBox "Treppe abwrts, Pfosten auf Kopf"))
		))

		(print V_StegWinkel)
		(print ControlWnkl)
	))
	
)
; -----------------------------


(defun createAP_an_Pfosten ()
	(setq Bl_Kontaktplatte (Blech.create))
	
	(setq b_HT 	 (Traeger.get HTrg b))			; Breite, weil es ein Flachstahl ist (stehend auf der Kante)
	(setq dlr_HT (Traeger.get HTrg delta_LR))	; Rechts-/Links-Verschiebung, weil es ein Flachstahl ist (stehend auf der Kante)
	(setq hp_KP (runde (* 8 16) auf 10))
	(setq qsForm_AT (Traeger.get Tr_ID qsForm))

	(if (= qsForm_AT "F") (progn
		(setq t_AT (Traeger.get Tr_ID t))
		(setq bp_KP (runde (+ t_AT (* 8 16)) auf 10))	; S-Durchm 16 angenommen
	  )
	  (progn
		(setq h_AT (Traeger.get Tr_ID h))			; ist ja ein Rohr - ansonsten msste man unterscheiden
		(setq bp_KP (runde (+ h_AT (* 8 16)) auf 10))	; S-Durchm 16 angenommen
	))
	
	(Blech.set  Bl_Kontaktplatte (hp hp_KP) (bp bp_KP) (dp LichterAbstand))

	(setq rWinkel 0.0)
	(if (= (Connect.get CastaData at-von-unten) 1) (setq  rWinkel 180.0))

	(setq xPos_AT (Connect.get CastaData xPos_AT))
	
	(if (= an_AT_Oben  1) (traeger.addabtl Tr_ID Bl_Kontaktplatte xPos_AT rWinkel _lasche_of_))
	(if (= an_AT_Unten 1) (traeger.addabtl Tr_ID Bl_Kontaktplatte xPos_AT rWinkel _lasche_uf_))


	(Connect.storeAnschlObjs CastaData Bl_Kontaktplatte)
	
	(setq Wnkl_relevant AT_Winkel_K)
	(if (< Wnkl_relevant 0.0) (setq Wnkl_relevant (- Wnkl_relevant)))
	; max_Hp zulssign ausrechnen
	(setq cos_Stw (cos (/ (* PI Wnkl_relevant) 180.0)))
	(setq tan_Stw (tan (/ (* PI Wnkl_relevant) 180.0)))
	(setq hp_Zul (- (/ b_HT cos_Stw) (* tan_Stw bp_KP)))
	
	(Blech.set  Bl_Kontaktplatte (hp hp_Zul))
	
	(setq Fall 0)
	(if (= (Connect.get CastaData at-von-links)  1) (setq Fall 1))
	(if (= (Connect.get CastaData at-von-rechts) 1) (setq Fall 2))
	(print Fall)

	(setq dOK_aus_DLR (/ (* 1.0 dlr_HT) cos_Stw))
	; (if (= PfostenAufKopf 1) (setq dOK_aus_DLR (- dOK_aus_DLR)))
	(if (= Fall 1) (setq dOK_aus_DLR (- dOK_aus_DLR)))

	(setq deltaLR_HT (Traeger.get HTrg delta_LR))
	(setq dOK_Bl deltaLR_HT)
	(setq dOK_Bl dOK_aus_DLR)
	
	(Blech.set Bl_Kontaktplatte (dOK (- dOK_Bl)))
	; (if (= Fall 1) (Blech.set Bl_Kontaktplatte (dOK dOK_Bl)))
	; (if (= Fall 2) (Blech.set Bl_Kontaktplatte (dOK (- dOK_Bl))))
	(Blech.set Bl_Kontaktplatte 	(formFkt "cb_KontPlatte"))
)

(defun cb_KontPlatte (zp)
	(if (= zp 0) (progn
		(setq dp_Alt (Blech.get Bl_Kontaktplatte dp))
	))
	(if (= zp 1) (progn
		(setq dp_Neu (Blech.get Bl_Kontaktplatte dp))
		(if (/= dp_Alt dp_Neu) (progn
			(Blech.set Bl_Kontaktplatte (dp dp_Alt))
		))
	))
)

(defun Lochbild_an_Pfosten ()
	(setq rWinkel 0.0)
	(setq xPos_AT (Connect.get CastaData xPos_AT))

	(if (= an_AT_Oben  1) (traeger.addabtl Tr_ID Lb_Lochbild xPos_AT rWinkel _flanschlochbild_of_))
	(if (= an_AT_Unten 1) (traeger.addabtl Tr_ID Lb_Lochbild xPos_AT rWinkel _flanschlochbild_uf_))
)
(defun Lochbild_an_Wange ()
	(setq rWinkel 90.0)
	(setq SWinkel (Connect.get CastaData h-atrgewnkl_steg))
	(setq diffWnkl (- 90.0 SWinkel))

	; AT_Winkel_K wurde vorher berechnet
	(setq diffWnkl (Connect.get CastaData v-atrgewnkl_kopf))
	
		
	(if (= (Connect.get CastaData at-von-links)  1) (setq rWinkel  -90.0))
	(if (= (Connect.get CastaData at-von-rechts) 1) (setq rWinkel   90.0))
		
	(setq Fall 1)
	(if (= (Connect.get CastaData at-von-links)  1) (if (= (Connect.get CastaData at-von-hinten) 1) (setq Fall 2)))
	(if (= (Connect.get CastaData at-von-rechts) 1) (if (= (Connect.get CastaData at-von-vorne)  1) (setq Fall 2)))

	(if (= Fall 1) (setq rWinkel (+ rWinkel AT_Winkel_K)))
	(if (= Fall 2) (setq rWinkel (- rWinkel AT_Winkel_K)))

	(setq xPos_HT (Connect.get CastaData xPos_HT))

	(traeger.addabtl HTrg Lb_Lochbild xPos_HT rWinkel _flanschlochbild_of_)
	
	
)
(defun setOrCreateLochbild ()
	(setq Lb_Lochbild (Lochbild.create))

	(setq b_HT	(Traeger.get HTrg b))  ; Flachstahl auf der Kante stehend
	(setq t_HT	(Traeger.get HTrg t))
	(setq h_AT	(Traeger.get Tr_ID h))  ; Rohrpfosten - h = b
	(setq hp_KP	(Blech.get Bl_Kontaktplatte hp))
	(setq dp_KP (Blech.get Bl_Kontaktplatte dp))
	
	(setq e_0 (/ hp_KP 4))
	(setq e_1 (* 2 e_0))
	
	(setq klLng (+ t_HT LichterAbstand))
	(setq w_0 (runde (+ h_AT (* 4 16)) auf 2))
	
	(setq qsForm_AT (Traeger.get Tr_ID qsForm))
	(if (= qsForm_AT "F") (setq w_0 (+ w_0 32))) ; bei M12 mind 40 mm hinzu
	
	(Lochbild.set  Lb_Lochbild 
			(S_Bez		"M12")
			(Guete   "4.6")
			(w0 w_0)
			(e0 e_0)
			(e1 e_1)
			(KlemmL klLng)
	)
	
	(Connect.storeAnschlObjs CastaData Lb_Lochbild)

)
(defun LochbildVerwaltung ()
	(setq abtl_LB_AT (Traeger.get Tr_ID ABTeil Lb_Lochbild))
	(setq abtl_LB_HT (Traeger.get HTrg  ABTeil Lb_Lochbild))
	(Anbauteil.set abtl_LB_AT (Master 1))
	(Anbauteil.set abtl_LB_HT (Master 0))
	
	
	(setq LB_SeitRicht 1)
	(if (= (Connect.get CastaData vAtr-vHtr) -1) (setq LB_SeitRicht -1))
	(Anbauteil.set abtl_LB_AT (SeitRicht  LB_SeitRicht))

	(setq deltaLR_HT (Traeger.get HTrg delta_LR))
	(setq sinW (sin (/ (* PI AT_Winkel_K) 180.0)))
	(setq cosW (cos (/ (* PI AT_Winkel_K) 180.0)))
	(setq dv_Lchb  (* cosW deltaLR_HT))
	(setq dlr_Lchb (* sinW deltaLR_HT))
	
	; (Anbauteil.set abtl_LB_HT (delta_V  (- dv_Lchb)))
	(print dv_Lchb)
	
	(setq Fall 0)
	(if (= (Connect.get CastaData at-von-links)  1) (setq Fall 1))
	(if (= (Connect.get CastaData at-von-rechts) 1) (setq Fall 2))
	(print Fall)

	; Wenn am HT, dann ist das VZ genau umgekehrt - hier aber am AT
	(if (= Fall 1) (Anbauteil.set abtl_LB_AT (delta_V     dv_Lchb)))
	(if (= Fall 2) (Anbauteil.set abtl_LB_AT (delta_V  (- dv_Lchb))))
	
	(setq hp_Bl (Blech.get Bl_Kontaktplatte hp))
	(setq dOK_Bl (Blech.get Bl_Kontaktplatte dOK))

	(setq dv_Abtl_Lb_AT	(Anbauteil.get abtl_LB_AT delta_V))

	(setq dOK_Lb (+ (* 1.0 dOK_Bl) (* -0.5 hp_Bl) (- dv_Abtl_Lb_AT)))

	(print hp_Bl) (print dOK_Bl)
	(print dv_Abtl_Lb_AT)
	(print dOK_Lb)

	(Lochbild.set Lb_Lochbild (dOK dOK_Lb))
	
	(setq dlr_AT (Traeger.get Tr_ID delta_LR))
	(if (/= dlr_AT 0) (progn
		; (AlertBox "hier seitliche Verschiebung")
		; (if (= an_AT_Oben  1)  (AlertBox "an_AT_Oben"))
		; (if (= an_AT_Unten  1) (AlertBox "an_AT_Unten"))
		; (if (= oben_vorbei 1)  (AlertBox "oben_vorbei"))
		; (if (= unten_vorbei 1) (AlertBox "unten_vorbei"))
		
		(if (= TreppeAbwaerts  1) (if (= PfostenAufKopf  1) (setq dlr_AT (- dlr_AT))))
		(if (= TreppeAufwaerts 1) (if (= PfostenAufrecht 1) (setq dlr_AT (- dlr_AT))))
		(if (= oben_vorbei 1) (progn
			(if (= an_AT_Oben  1)  (setq dlr_Lchb (- dlr_Lchb dlr_AT)))
			(if (= an_AT_Unten 1) (setq dlr_Lchb  (+ dlr_Lchb dlr_AT)))
		))
		(if (= unten_vorbei 1) (progn
			(if (= an_AT_Oben  1) (setq dlr_Lchb (+ dlr_Lchb dlr_AT)))
			(if (= an_AT_Unten 1) (setq dlr_Lchb (- dlr_Lchb dlr_AT)))
		))
	))

	(if (= TreppeAufwaerts 1) (progn
		(if (= PfostenAufrecht 1) (Anbauteil.set abtl_LB_HT (delta_LR (+ dlr_Lchb))))
		(if (= PfostenAufKopf  1) (Anbauteil.set abtl_LB_HT (delta_LR (- dlr_Lchb))))
	))
	
	(if (= TreppeAbwaerts 1) (progn
		(if (= PfostenAufrecht 1) (Anbauteil.set abtl_LB_HT (delta_LR (- dlr_Lchb))))
		(if (= PfostenAufKopf  1) (Anbauteil.set abtl_LB_HT (delta_LR (+ dlr_Lchb))))
	))
	
	(setq  s_Abstand 0)
	(setq qsForm_AT (Traeger.get Tr_ID qsForm)
		  b_AT		(Traeger.get Tr_ID b)
	)
	(if (= qsForm_AT "F") (setq s_Abstand (* 0.5 b_AT)))
	(if (= qsForm_AT "R") (setq s_Abstand (* 0.5 b_AT)))
	
	; Achtung - Lochbild in Flach wird bei Blech am Unterflansch nicht dem Blech zugeordnet
	; Mrz 2024
	(if (= qsForm_AT "F") (progn
		(setq s_Abstand 0.0)						; immer auf 0 setzen
		(setq t_AT (Traeger.get Tr_ID t))
		(if (= an_AT_Unten  1) (setq s_Abstand t_AT))
		(if (= an_AT_Oben  1) (Lochbild.set Lb_Lochbild (Schr_Richt -1)))
	))
	(if (= qsForm_AT "R") (progn
		(setq s_Abstand 0.0)						; immer auf 0 setzen
		(Lochbild.set Lb_Lochbild (Schr_Richt -1))	; immer durchfhren
	))
	
	(Anbauteil.set  abtl_LB_AT (Delta_SX  s_Abstand))

)
; -------------------------------------------------------------------------------------------------------
; ----- 
; -------------------------------------------------------------------------------------------------------
(defun calcVorabLichtenAbstand ()
	(setq 	dlr_AT	(Traeger.get Tr_ID delta_LR)
			dv_AT   (Traeger.get Tr_ID delta_V)
			t_AT	(Traeger.get Tr_ID t)
			b_AT	(Traeger.get Tr_ID b)
			t_HT	(Traeger.get HTrg t)
			h_AT	(Traeger.get Tr_ID h)
			r_AT 	(* 0.5 h_AT)
			dlr_AT	(* 1.0 dlr_AT)
			
			dv_HT	(Traeger.get HTrg delta_V)
			qsForm_AT (Traeger.get Tr_ID qsForm)
	)
	
	(setq  Achs_Abstand 0.0)

	(if (= (Connect.get CastaData vatr-vhtr)  1) 	(setq Achs_Abstand (-  dv_AT dv_HT)))
	(if (= (Connect.get CastaData vatr-vhtr) -1) 	(setq Achs_Abstand (+  dv_AT dv_HT)))
	(if (< Achs_Abstand 0) (setq Achs_Abstand (- Achs_Abstand)))

	(if (= qsForm_AT "R") (progn
		(setq LichterAbstand (- Achs_Abstand (* 0.5 t_HT) r_AT))
	  )
	  (if (= qsForm_AT "F") (progn
		  (setq LichterAbstand (- Achs_Abstand (* 0.5 t_HT) (* 0.5 t_AT)))
	    )
	    (progn
		  (setq LichterAbstand (- Achs_Abstand (* 0.5 t_HT) (* 0.5 b_AT)))
		)
	))
	(print  LichterAbstand)

)
; -------------------------------------------------------------------------------------------------------
(defun init_Geometry ()
	(print "------------------------ in init_Geometry -----------------")
	(setq Ht_Winkel (Connect.get CastaData  h-atrgewnkl_Steg))
	(print Ht_Winkel)
	
	(setq sinV (sin (* PI (/ Ht_Winkel 180.0))))
	(setq cosV (cos (* PI (/ Ht_Winkel 180.0))))
	(setq tanV (tan (* PI (/ Ht_Winkel 180.0))))

	(setq 	dv_HT	(Traeger.get HTrg delta_V)
			dv_AT	(Traeger.get Tr_ID delta_V)
			b_AT	(Traeger.get Tr_ID b)
			t_HT	(Traeger.get HTrg t)
	)
	(setq	dv_AT  (* 1.0 dv_AT)
			dv_HT  (* 1.0 dv_HT)
	)
	
	(setq  Achs_Abstand 0.0)
	(if (= (Connect.get CastaData vatr-vhtr)  1) 	(setq Achs_Abstand (-  dv_AT dv_HT)))
	(if (= (Connect.get CastaData vatr-vhtr) -1) 	(setq Achs_Abstand (+  dv_AT dv_HT)))
	
	
	(setq unten_vorbei 0)
	(setq oben_vorbei 0)
	
	(if (> Achs_Abstand 0) (progn
		(if (= (Connect.get CastaData vatr-vhtr) -1) 	(setq oben_vorbei 1))
		(if (= (Connect.get CastaData vatr-vhtr)  1) 	(setq unten_vorbei 1))
	))
	(if (< Achs_Abstand 0) (progn
		(if (= (Connect.get CastaData vatr-vhtr) -1) 	(setq unten_vorbei 1))
		(if (= (Connect.get CastaData vatr-vhtr)  1) 	(setq oben_vorbei 1))
		(setq Achs_Abstand (- Achs_Abstand))
	))

	(setq an_AT_Oben 0) (setq an_AT_Unten 0)
	(if (= oben_vorbei 1) (progn
		(if (= (Connect.get CastaData vatr-vhtr) -1) 	(setq an_AT_Oben  1))
		(if (= (Connect.get CastaData vatr-vhtr)  1) 	(setq an_AT_Unten 1))
	))
	(if (= unten_vorbei 1) (progn
		(if (= (Connect.get CastaData vatr-vhtr)  1) 	(setq an_AT_Oben  1))
		(if (= (Connect.get CastaData vatr-vhtr) -1) 	(setq an_AT_Unten 1))
	))
	
;	(if (= an_AT_Oben 1)  (AlertBox "an_AT_Oben"))
;	(if (= an_AT_Unten 1) (AlertBox "an_AT_Unten"))
;	(if (= unten_vorbei 1) (AlertBox "unten vorbei"))
;	(if (= oben_vorbei  1) (AlertBox "oben vorbei"))
	(setq TreppeAufwaerts  0)
	(setq TreppeAbwaerts   0)
	(setq PfostenAufrecht  0)
	(setq PfostenAufKopf   0)


	(setq HT_TrpVWinkel    (Connect.get CastaData hpttrg_vwinkel ))
	(setq AT_TrpVWinkel    (Connect.get CastaData trg_vwinkel ))
	(setq TreppeAufwaerts 0 TreppeAbwaerts 0)
	(if (>= HT_TrpVWinkel   0.0) (if (<=  HT_TrpVWinkel  90.0) (setq TreppeAufwaerts 1)))
	(if (>= HT_TrpVWinkel 270.0) (if (<=  HT_TrpVWinkel 360.0) (setq TreppeAbwaerts  1)))

	(setq PfostenAufrecht 0 PfostenAufKopf 0)
	(if (>= AT_TrpVWinkel   0.0) (if (<=  AT_TrpVWinkel  90.0) (setq PfostenAufrecht 1)))
	(if (>= AT_TrpVWinkel 270.0) (if (<=  AT_TrpVWinkel 360.0) (setq PfostenAufKopf  1)))
	
	; neue Lsung ------------------
	(setq H_StegWinkel (Connect.get CastaData h-atrgewnkl_steg))

	(setq AT_Winkel_K 90.0)
	(if (= (Connect.get CastaData at-von-links)   1) (setq AT_Winkel_K (- H_StegWinkel 90.0)))
	(if (= (Connect.get CastaData at-von-rechts)  1) (setq AT_Winkel_K (+ H_StegWinkel 90.0)))
	(if (>= AT_Winkel_K 180.0) (setq AT_Winkel_K (- AT_Winkel_K 180.0)))
	(if (<  AT_Winkel_K 0.0) (setq AT_Winkel_K (- AT_Winkel_K)))
	
	(if (> AT_Winkel_K 90.0) (progn
		(setq AT_Winkel_K (- 180.0 AT_Winkel_K))
	))
	
)
; -------------------------------------------------------------------------------------------------------

; -------------------------------------------------------------------------------------------------------
(defun AT_EndLaenge ()
	(setq hp_KP 	(Blech.get Bl_Kontaktplatte hp)
		  dOK_KP	(Blech.get Bl_Kontaktplatte dOK)
	)
	
	(setq Fall 0)
	(setq dl_EndLaenge 0.0)

	(if (= (Connect.get CastaData at-von-links)  1) (setq Fall 1))
	(if (= (Connect.get CastaData at-von-rechts) 1) (setq Fall 2))

	(if (= Fall 1) 	(progn
		(if (= PfostenAufrecht 1) (setq dl_EndLaenge (- (* 0.5 hp_KP) dOK_KP)))
		(if (= PfostenAufKopf  1) (setq dl_EndLaenge (+ (* 0.5 hp_KP) dOK_KP)))
	))
	(if (= Fall 2) 	(progn
		(if (= PfostenAufrecht 1) (setq dl_EndLaenge (- (* 0.5 hp_KP) dOK_KP)))
		(if (= PfostenAufKopf  1) (setq dl_EndLaenge (+ (* 0.5 hp_KP) dOK_KP)))
	))

	(if (= (Connect.get CastaData linkesEnde) 1) (progn
			(setq dl_EndLaenge (- (* 0.5 hp_KP) dOK_KP))
			(setq tEnde (Traeger.get Tr_ID links))
			(TrEnde.set tEnde (delta_L (- dl_EndLaenge)))
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
			(setq dl_EndLaenge (+ (* 0.5 hp_KP) dOK_KP))
			(setq tEnde (Traeger.get Tr_ID rechts))
			(TrEnde.set tEnde (delta_L (- dl_EndLaenge)))
	))
	
	
)
