; $	HT	QT(IUKRSL)	AF(F)			P(EZ)
; $	AT	QT(IUT)			AF(K)			P(E)
; $ AE	V(-)				H(-)			R(89-91)

(defun load-modules ()
   (load "mod-lochbild")
)

(defun init-connection ()
	
	(setq LB_DEBUG 0)
	
	(if (/= (Connect.get CastaData vatr-shtr) 0)
		(progn
			(if (= (Connect.get CastaData hpttrg_vwinkel) 0.0)
				(setConnection)
				(setConnection)
			)
		)
		(progn
			(alertBox "Der Anschluss ist bei einem rotierten Anschlusstrger nicht mglich!"  "ERR_NotPossible_RotatedAT")
		)
	)
	(print "*clear*")
	(Connect.showAttributes CastaData)
)



(defun setConnection ()

	(setq minAbstand 40)
	(setq StzEndeLinks (Traeger.get Tr_ID links))
	(setq StzEndeRechts (Traeger.get Tr_ID rechts))
	
	(setq HtrgLinks 	(Traeger.get Htrg links))
	(setq HtrgRechts	(Traeger.get Htrg rechts))
	
	; Lasche erzeugen
	(setq lasche (blech.create))
	(setq lchbAtrgSteg (Lochbild.create))
	(Connect.storeAnschlObjs CastaData lasche lchbAtrgSteg)
	
	(print "Fahnenblech erzeugt")
  (Blech.set lasche (dp 10) (hp 200) (bp 110) (dOK 0))
  (setq XPos (Connect.get CastaData XPos_HT))
  (print XPos)
	
	; Anbauteil Blech
	(setAnbauteilBlech lasche)
	
	; Blechdaten berechnen
	(calcAndSetBlechdaten lasche)
	
		
	(if (= (Connect.get CastaData linkesende) 1)
		(progn
			(print "Sttze links")
			(berechneStuetzenEnde minAbstand StzEndeLinks)
			(calcAndSetLochbildDaten lchbAtrgSteg lasche StzEndeLinks 2)
			(traeger.addabtl tr_id lchbAtrgSteg 0.0 0.0 _WnklSteglochbildLinks_)
		)
	)
	(if (= (Connect.get CastaData rechtesende) 1)
		(progn
			(print "Sttze rechts")
			(berechneStuetzenEnde minAbstand StzEndeRechts)
			(calcAndSetLochbildDaten lchbAtrgSteg lasche StzEndeRechts -2)
			(setq trgLaenge (Traeger.get Tr_ID syslng))
			(traeger.addabtl tr_id lchbAtrgSteg trgLaenge 0.0 _WnklSteglochbildRechts_)
		)
	)
	
	; Setzt die Endgltige Hhe und Breite der Fahne
	(korrBlechdaten lasche)
		
	(setLochbildAnbauteil lchbAtrgSteg lasche)
	
	; falls der HT rotiert wurde, das Fahnenblech schrg anschlieen, so dass
	; das Blech lngs der Profilachse verluft.
	(korr_HT_Rotation)
	
	
	; ******************************************
	; TEST FR MEHRFACHANSCHLUSS (FLANSCHSEITE)
	; ******************************************
	(setq anzAnschl (Connect.get CastaData anz_weitere_anschl))
	(print anzAnschl)
	  
	(if (/= anzAnschl 0)
		(progn
			(alertBox "An dem Knoten ist bereits ein Anschluss vorhanden. Fgen Sie ggf. Anbauteile manuell ein oder nderen Sie die Reihenfolge der Anschlsse."   "ERR_OrderOfConnections")
		)
		(progn
			(setq qsform_ht (Traeger.get Htrg qsform))
			(if (/= qsform_ht "K") (progn
				(setq steife (blech.create))
				(Connect.storeAnschlObjs CastaData steife)
				(createSteifen lasche steife)
			))
		)
	)
	
	
	(if (= (Connect.get CastaData anschlzwhtenden) 0)
		(progn
			(if (= (Connect.get CastaData anHtLinkesEnde) 1)
				(berechneTraegerEnde HtrgLinks)
			)
			(if (= (Connect.get CastaData anHtRechtesEnde) 1)
				(berechneTraegerEnde HtrgRechts)
			)
		)
	)
	(if (= 1 2) (progn
	    (Lochbild.set lchbAtrgSteg (e0 40))
	))
	
	; CALLBACKS
	(Blech.set lasche (formFkt "cb_lasche"))
)



; ----------------------------------------------------------------------------------------
; CALLBACK-FUNKTIONEN
; ----------------------------------------------------------------------------------------
(defun cb_Lasche (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get lasche dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
		(setq dpNeu (Blech.get lasche dp))
		    
		(print dpAlt) (print dpNeu)
		    
		(if (/= dpAlt dpNeu) (progn
		  (setq dpDiff (- dpNeu dpAlt))

		  (setq qsform_ht (Traeger.get Htrg qsform))
		  ; Auswirkungen auf Lochbild
		  (setq alteKlemml 	(Lochbild.get lchbAtrgSteg Klemml))
		  (setq altesDxS		(Lochbild.get lchbAtrgSteg dxsKopf))
		  
		  (if (= (Connect.get CastaData vatr-shtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(setq dxsKopf_neu altesDxS)
					)
					(if (= (Connect.get CastaData satr-lhtr)  1)
						(setq dxsKopf_neu altesDxS)
					)
				)
			)
			
			(if (= (Connect.get CastaData vatr-shtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(setq dxsKopf_neu altesDxS)
					)
					(if (= (Connect.get CastaData satr-lhtr)  1)
						(setq dxsKopf_neu altesDxS)
					)
				)
			)
			
		  (Lochbild.set lchbAtrgSteg 	(Klemml (+ alteKlemml dpDiff))
		       												(DxSKopf dxsKopf_neu)
		  )
		       
		       
		  ; Auswirkungen auf die Lasche
		  (setq delta_lr_lasche_alt	(Blech.get lasche delta_lr))
		       
		  (setq delta_lr_lasche_neu 0)
		  (print delta_lr_lasche_neu)
		  		  
			(if (= (Connect.get CastaData vatr-shtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(setq delta_lr_lasche_neu (+ delta_lr_lasche_alt (* 0.5 dpDiff)))
					)
					(if (= (Connect.get CastaData satr-lhtr)  1)
						(setq delta_lr_lasche_neu (+ delta_lr_lasche_alt (* 0.5 dpDiff)))
					)
				)
			)
			
			(if (= (Connect.get CastaData vatr-shtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(setq delta_lr_lasche_neu (+ delta_lr_lasche_alt (* 0.5 dpDiff)))
					)
					(if (= (Connect.get CastaData satr-lhtr)  1)
						(setq delta_lr_lasche_neu (+ delta_lr_lasche_alt (* 0.5 dpDiff)))
					)
				)
			)

		  (Blech.set lasche (delta_lr delta_lr_lasche_neu))
		  
		  (if (/= qsform_ht "K")
		  	(progn
			      (if (objexist steife) (progn
					  ; Auswirkungen auf die Steife
					  (setq AbtlSteife_ht (Traeger.get Htrg ABTeil steife))
					  (if (objexist AbtlSteife_ht) (progn
						  (setq xPos_alt (Anbauteil.get AbtlSteife_ht xPos))
						  
						  (if (= (Connect.get CastaData satr-lhtr)  1) (setq xPos_neu (+ xPos_alt (* 0.5 dpDiff))))
						  (if (= (Connect.get CastaData satr-lhtr) -1) (setq xPos_neu (- xPos_alt (* 0.5 dpDiff))))
						  
						  (Anbauteil.set AbtlSteife_ht (xPos xPos_neu))
					  ))
				   ))
				)
			)
	  ))
	))
)


; -------------------------------------------------------------
; Krzt die Giebelsttze
; -------------------------------------------------------------
(defun berechneStuetzenEnde (minAbstand TrgEnde)
	(print "------------------- in berechneStuetzenEnde")
	(setq h_htrg 				(Traeger.get Htrg h)
				delta_v_htrg	(Traeger.get Htrg delta_v)
	)
	(setq h_trg 			(Traeger.get Tr_ID h)
				b_trg				(Traeger.get Tr_ID b)
				r_Wnkl			(Traeger.get Tr_ID r_winkel)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	(setq VWnkl		(Connect.get CastaData HptTrg_VWinkel)
				anschl_wnkl	(Connect.get CastaData at_laengswinkel)
	)
	
	(print h_htrg)
	(print h_trg)
	(print VWnkl)
	
	(if (< VWnkl 180.0) (setq HelpWnkl VWnkl))
	(if	(> VWnkl 180.0) (setq HelpWnkl (- VWnkl 360)))
	(print HelpWnkl)
	
	(setq cosW (cos (/ (* PI HelpWnkl) 180.0))
				tanW (tan (/ (* PI HelpWnkl) 180.0))
	)
	
	(print cosW)
	(print tanW)
	
	; Anteil HT (vom Systempunkt zur Flanschkante)
	; --------------------------	
	(setq anteil_h_htrg (/ (* 0.5 h_htrg) cosW))
	(print anteil_h_htrg)
		
	(setq delta_l (+ minAbstand anteil_h_htrg))
	
	
	; Anteil durch Neigung des HT
	; --------------------------
	(setq anteil_durch_neigung_ht (* (* 0.5 b_trg) tanW))
	(if (< anteil_durch_neigung_ht 0)
		(setq anteil_durch_neigung_ht (- anteil_durch_neigung_ht))
	)
	(print 	anteil_durch_neigung_ht)
	
	(setq delta_l (+ delta_l anteil_durch_neigung_ht))
	
	
	; Anteil delta_v des HT
	; --------------------------
	(setq anteil_delta_v_htrg (/ delta_v_htrg cosW))
	(print anteil_delta_v_htrg)
	
	(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq delta_l (+ delta_l anteil_delta_v_htrg)))
	(if (= (Connect.get CastaData amHtOberflansch) 1)		(setq delta_l (- delta_l anteil_delta_v_htrg)))
	
	(print delta_l)
	
	; Anteil delta_lr des AT
	; --------------------------
	(setq anteil_delta_lr_at (* delta_lr_at tanW))
	(print anteil_delta_lr_at)
	
	
	(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_l (- delta_l anteil_delta_lr_at)))
	(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_l (+ delta_l anteil_delta_lr_at)))
				
	
	
	(print delta_l)
	
	(TrEnde.set TrgEnde (delta_l delta_l))		
)

; -------------------------------------------------------------
; Erzeugt die Lasche
; -------------------------------------------------------------
(defun calcAndSetBlechDaten (lasche)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE BLECHDATEN")
	(setq 	hc_trg 		(Traeger.get Tr_ID hc)
		s_trg		(Traeger.get Tr_ID s)
		delta_v_trg	(Traeger.get Tr_ID delta_v)
		r_Wnkl_trg	(Traeger.get Tr_ID r_winkel)
		delta_lr_at	(Traeger.get Tr_ID delta_lr)
		qsform_at	(Traeger.get Tr_ID qsform)
	)
	(setq b_htrg				(Traeger.get Htrg b)
				delta_lr_htrg	(Traeger.get Htrg delta_lr)
	)
	
	(if (> hc_trg b_Htrg)
		(setq maxhp b_Htrg)
		(setq maxhp hc_trg)
	)
	
	(setq maxbp (+ minAbstand 150))
	(setq maxdp s_trg)
	
	
	; delta_lr des Bleches
	(setq delta_lr_soll (+ (* 0.5 maxdp) (* 0.5 s_trg)))
	
	(if (= qsform_at "U")
		(progn
		    (if (= (Connect.get CastaData at-von-unten) 1) (progn
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_soll (+ (* 0.5 maxdp) 0.0)))
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_soll (+ (* 0.5 maxdp) 0.0)))
		    ))
		    (if (= (Connect.get CastaData at-von-oben) 1) (progn
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_soll (+ (* 0.5 maxdp) s_trg)))
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_soll (+ (* 0.5 maxdp) s_trg)))
		    ))
		)
	)
	
		
	; Anteil delta_lr HT
	(setq delta_lr_ht (Traeger.get Htrg delta_lr))
	
	(setq r_w_at			(Traeger.get Tr_ID r_winkel))
	(setq h_w_ht			(Connect.get CastaData hpttrg_hwinkel))
	
	(setq r_w_b (- h_w_ht r_w_at))
	
	(setq cosAT	(cos (/ (* PI r_w_b) 180.0)))
	(setq sinAT	(sin (/ (* PI r_w_b) 180.0)))
	
	(setq anteil_delta_lr (* cosAT delta_lr_ht))
	(setq anteil_delta_v	(* sinAT delta_lr_ht))
	
	(setq delta_lr_soll (- delta_lr_soll anteil_delta_lr))
	
	; dok Lasche
	(setq dok_lasche 0)
	(if (= (Connect.get CastaData vatr-shtr)  1)	(setq dok_lasche (- dok_lasche delta_lr_ht)))
	(if (= (Connect.get CastaData vatr-shtr) -1)	(setq dok_lasche (+ dok_lasche delta_lr_ht)))
	(print dok_lasche)
	
	
	
	; Anteil aus delta_lr Verschiebung des AT
	(if (= (Connect.get CastaData satr-shtr)  1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1) 	(setq delta_lr_soll (+ delta_lr_soll delta_lr_at)) );ok
			(if (= (Connect.get CastaData vatr-lhtr) -1) 	(setq delta_lr_soll (+ delta_lr_soll delta_lr_at)) );ok
		)
	)
	(if (= (Connect.get CastaData satr-shtr) -1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1) 	(setq delta_lr_soll (+ delta_lr_soll delta_lr_at)) );ok
			(if (= (Connect.get CastaData vatr-lhtr) -1) 	(setq delta_lr_soll (+ delta_lr_soll delta_lr_at)) );ok
		)
	)
	(if (= (Connect.get CastaData satr-shtr)  0)
		(progn
			(if (= (Connect.get CastaData RechtesEnde) 1)	(setq delta_lr_soll (- delta_lr_soll delta_lr_at))	)
			(if (= (Connect.get CastaData LinkesEnde)  1)	(setq delta_lr_soll (+ delta_lr_soll delta_lr_at))	)
		)
	)

	(if (= (Connect.get CastaData amHtOberflansch) 1)	(setq delta_lr_soll (- delta_lr_soll)))
	
	
	
	(Blech.set lasche (hp 			(- maxhp 20)) 
			  (bp 			maxbp) 
			  (dp 			maxdp) 
			  (delta_lr delta_lr_soll)
			  ;(delta_v 20)
			  (dok 			dok_lasche)
	)
	
	(print "<-----------------------------------------------------------")
)

; -------------------------------------------------------------
; Erzeugt die Steifen
; -------------------------------------------------------------
(defun createSteifen (BLECH_ID STEIFE_ID)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE STEIFEN")
		
	(setq xPos_steife (Connect.get CastaData xPos_ht))
	(print xPos_steife)
		
	(setq delta_v_ht (Traeger.get Htrg delta_v))
	
	(setq delta_lr_at	(Traeger.get Tr_ID delta_lr))
	
	(setq vwinkel_ht (Connect.get CastaData hpttrg_vwinkel))
	(setq tanW (tan (/ (* PI vwinkel_ht) 180.0)))
	(setq cosW (cos (/ (* PI vwinkel_ht) 180.0)))
	
	; ANteil delta_v Riegel
	(setq anteil_delta_v_ht_xPos (* delta_v_ht tanW))
	(print anteil_delta_v_ht_xPos)
	
	(setq xPos_steife (- xPos_steife anteil_delta_v_ht_xPos))
	
	
	; Anteil Blechverschiebung
	(setq s_at (Traeger.get Tr_ID s))
	(setq dp_blech (Blech.get BLECH_ID dp))
	
	(setq anteil_blech_versch (* 0.5 (+ s_at dp_blech)))
	(print anteil_blech_versch)
	
	(if (/= cosW 0.0)
		(setq anteil_blech_versch_xPos (/ anteil_blech_versch cosW))
		(setq anteil_blech_versch_xPos 0.0)
	)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_steife (+ xPos_steife anteil_blech_versch_xPos)))
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_steife (- xPos_steife anteil_blech_versch_xPos)))
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_steife (- xPos_steife anteil_blech_versch_xPos)))
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_steife (+ xPos_steife anteil_blech_versch_xPos)))
		)
	)
	


	; Anteil delta_lr Sttze
	(if (/= cosW 0.0)
		(setq anteil_delta_lr_at_xPos (/ delta_lr_at cosW))
		(setq anteil_delta_lr_at_xPos 0.0)
	)
	(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_steife (+ xPos_steife anteil_delta_lr_at_xPos)))
	(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_steife (- xPos_steife anteil_delta_lr_at_xPos)))
	
	
	; Winkel
	; --------------------------
	(setq winkel_steife 0.0)
	(setq hwinkel_ht (Connect.get CastaData hpttrg_vwinkel))
	(print hwinkel_ht)
	
	(if (> hwinkel_ht 180.0)
		(progn
			(setq winkel_steife (- hwinkel_ht 360.0))
			(setq winkel_steife (- winkel_steife))
		)
		(progn
			(setq winkel_steife (- hwinkel_ht))
		)
	)

;	AF - Juli 2009 - kann jetzt wieder raus. wird vorher bereits bercksichtigt.	
;	(if (= (Connect.get CastaData amHtOberflansch) 1)	(setq winkel_steife (- winkel_steife)))
	
	(Traeger.addabtl Htrg STEIFE_ID xPos_steife winkel_steife _vollsteife_beids_)
	
	;(setq AbtlSteife (Traeger.get Htrg ABTeil blTrgSteife))
	;(Anbauteil.set  AbtlSteife (Winkel 0.0))

	(Traeger.updvollstf Htrg)
	(print "<-----------------------------------------------------------")
)

; ----------------------------------------------------------------------------
; Berechnet die Lochbild Daten
; ----------------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lchb_ID BlechID TrgEnde LbArt)
	(print "ERZEUGE LOCHBILD")
	(print "------------------------------------------------------------")
	(Lochbild.set Lchb_ID	;(lb_art  LbArt)
												(Anz_S    4)
												(S_Bez   "M20")
												(Guete   "4.6")
												(e       "0 0 0 0 0 0")
												(w       "100  400")
												
	)
	
	
	(setq dp_blech 		(Blech.get BlechID dp))
	
	(setq s_at				(Traeger.get Tr_ID s)
				h_at				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	(setq h_ht				(Traeger.get Htrg h)
				delta_v_ht	(Traeger.get Htrg delta_v)
	)
	
	(print delta_v_ht)
	(if (> delta_v_ht 0.0)
		(setq delta_v_ht (- delta_v_ht))
	)
	; min. Loch- u. Randabstnde
	(calcMinRandLochAbst Lchb_ID)
	
	; e0
	(setq e0 (* 0.5 h_at))
	; w0
	(setq w0 e_min_rund)
	; w1
	(setq w1 (+ w0 e1_min_rund))
	
	;dxsKopf
	(setq dxSKopf	(+ (* 0.5 dp_blech) s_at))
	
	(if (= qsform_at "U")
		(progn
			(if (= (Connect.get CastaData satr-shtr) -1) (setq dxSKopf	(* 0.5 dp_blech)))
			(if (= (Connect.get CastaData satr-shtr)  1) (setq dxSKopf	(+ (* 0.5 dp_blech) s_at)))
		)
	)
	
	(Lochbild.set Lchb_ID (klemml 	(+ dp_blech s_at))
												(dxSKopf	dxsKopf)
												(e0 			e0)
												(w0				w0)
												(w1				w1)
	)
	
	(if (= LB_DEBUG 1)
		(Lochbild.set Lchb_ID (e1 300))
	)
	; korregiere Blech
	(Blech.set BlechID 	(bp (+ minAbstand e1_min_rund (* e_min_rund 2.0)))
											(hp (* 2.0 e_min_rund))
	)
	(print "ENDE LOCHBILD")
)


; -------------------------------------------------------------
; Berechnet das Unterzugende
; -------------------------------------------------------------
(defun berechneTraegerEnde (TrgEnde)
	(setq b_Stz (Traeger.get Htrg b))
	
	(setq delta_v_stz (Traeger.get Tr_ID delta_v))
	
	(setq delta_l (- (* 0.5 b_Stz)))
	
	; delta_v Verschiebung der Stztze
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_l (- delta_l delta_v_stz)))
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_l (+ delta_l delta_v_stz)))
	
	(TrEnde.set TrgEnde (delta_l delta_l)) 
)





; -------------------------------------------------------------
; Berechnet die Lochbild-Anbauteile
; -------------------------------------------------------------
(defun setLochbildAnbauteil (LCHB_ID BLECH_ID)	
	(print ">-----------------------------------------------------------")
	(print "SETZE ANBAUTEIL LOCHBILD")
	
	
	(setq h_ht				(Traeger.get Htrg h)
				s_ht				(Traeger.get Htrg s)
				delta_v_ht 	(Traeger.get Htrg delta_v)
	)
	
	(setq delta_v_at	(Traeger.get Tr_ID delta_v)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	
	(setq xPos_ht 		(Connect.get CastaData xPos_ht))
	(setq xPos_at 		(Connect.get CastaData xPos_at))
	
	(setq hp_lasche		(Blech.get BLECH_ID hp))
	
	
	; Lochbild HT
	(setq AbtlFahnenBl	(Traeger.get Htrg AbTeil BLECH_ID))
	(Traeger.addabtl Htrg LCHB_ID xPos_ht 0.0 _fahnblLochbild_ AbtlFahnenBl)	
	

	(print "------------------------------")
	(setq lb_ht_abtl (Traeger.get Htrg Abteil LCHB_ID))
	(setq lb_at_abtl (Traeger.get Tr_ID Abteil LCHB_ID))
	
	
	
	; Neigungswinkel
	; --------------------------
	(setq nwinkel (Connect.get CastaData hpttrg_vwinkel))
	(print nwinkel)
	
	(if (= (Connect.get CastaData vatr-shtr)  1)	(setq nwinkel nwinkel))
	(if (= (Connect.get CastaData vatr-shtr) -1)	(setq nwinkel (- nwinkel)))
	
	
	
	
	(setq delta_lr_abtl_ht 	0.0)
	(setq delta_v_abtl_ht 	0.0)
	
	; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	; Anbauteil HT
	; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	
	; Positionierung (zum AT)
	(setq delta_v_abtl_ht (- delta_v_abtl_ht (* 0.5 h_at)))
	
	(print delta_v_abtl_ht)
	
	; Grundlegende Anpassungen
	; ============================================================================
	
	; Anteil HT-Hhe an delta_lr LB-Anbauteil HT
	; ----------------------------------------------
	(if (= 1 2)	(progn
	; ----------------------------------------------
		(setq ht_vwinkel (Connect.get CastaData hpttrg_vwinkel))
		(setq cosHTW (cos (/ (* PI ht_vwinkel) 180.0)))
		(setq h_ht_halb (* h_ht 0.5))
		
		(setq anteil_ht (/ h_ht_halb cosHTW))
		(setq anteil_ht (- anteil_ht h_ht_halb))	
		;(setq delta_lr_abtl (+ delta_v_ht anteil_ht))
		(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_ht))
		(print delta_lr_abtl_ht)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	; Anteil minAbstand und Riegelneigung an delta_lr des LB-Anbauteils
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht minAbstand)))
		(if (= (Connect.get CastaData amHtOberflansch) 1)		(setq delta_lr_abtl_ht (- delta_lr_abtl_ht minAbstand)))
		
		(setq ht_vwinkel (Connect.get CastaData hpttrg_vwinkel))
		(setq tanHTW (tan (/ (* PI ht_vwinkel) 180.0)))
		(setq h_at_halb (* 0.5 h_trg))
		(setq anteil_durch_neigung_ht (* h_at_halb tanHTW))
		(if (< anteil_durch_neigung_ht 0.0) (setq anteil_durch_neigung_ht (- anteil_durch_neigung_ht)))
		
		(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_durch_neigung_ht)))
		(if (= (Connect.get CastaData amHtOberflansch) 1)		(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_durch_neigung_ht))) 	
	; ----------------------------------------------
	))	
	; ----------------------------------------------
	
	
	
	
	
	
	
	; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	; Anbauteil HT
	; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	
	
	; HT Verschiebungen
	; ============================================================================
	

	; Anteil von delta_lr HT (Riegel) an delta_v LB-ABTL
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(setq delta_lr_ht (Traeger.get Htrg delta_lr))
		
		(if (= (Connect.get CastaData vatr-shtr)  1) (setq delta_v_abtl_ht (- delta_v_abtl_ht delta_lr_ht)))
		(if (= (Connect.get CastaData vatr-shtr) -1) (setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_lr_ht)))
	; ----------------------------------------------	
	))	
	; ----------------------------------------------
	
	
	; AT Verschiebungen
	; ============================================================================
	
	; Anteil von delta_lr AT (Sttze) an delta_lr LB-ABTL
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
		(print delta_lr_at)
		(setq VWnkl (Connect.get CastaData hpttrg_vwinkel))
		(print VWnkl)
		
		;(if (< VWnkl 180.0) (setq HelpWnkl VWnkl))
		;(if	(> VWnkl 180.0) (setq HelpWnkl (- VWnkl 360.0)))
		(setq HelpWnkl VWnkl)
		(print HelpWnkl)
		
		(setq tanW2 (tan (/ (* PI HelpWnkl) 180.0)))
		(print tanW2)
		
		(setq anteil_delta_lr_at (* delta_lr_at tanW2))
		(print anteil_delta_lr_at)
		
		
		(if (= (Connect.get CastaData LinkesEnde) 1)
			(progn
				(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_delta_lr_at)))
				(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_delta_lr_at)))
			)
		)
		(if (= (Connect.get CastaData RechtesEnde) 1)
			(progn
				(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_delta_lr_at)))
				(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_delta_lr_at)))
			)
		)
	; ----------------------------------------------
	))	
	; ----------------------------------------------
	
	
	
	; Anteil von delta_v AT (Sttze) an delta_v LB-ABTL
	; ----------------------------------------------
	(if (= 1 1)	(progn	
	; ----------------------------------------------
		(setq delta_v_at (Traeger.get Tr_ID delta_v))
		
		(if (= (Connect.get CastaData vatr-shtr)  1) (setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_v_at)))
		(if (= (Connect.get CastaData vatr-shtr) -1) (setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_v_at)))
	; ----------------------------------------------
	))	
	; ----------------------------------------------
	
	
	
	; --------------------------	
	; Anbauteil HT
	; --------------------------
	(Anbauteil.set lb_ht_abtl (delta_v 	delta_v_abtl_ht)
														(delta_lr delta_lr_abtl_ht)
														(neigwnkl_d nwinkel)
	)
	
	
	
	
	
	
	
	; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	; Anbauteil AT
	; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	(setq delta_lr_abtl 0.0)
	
	; Anteil HT-Hhe an delta_lr LB-Anbauteil AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(setq ht_vwinkel (Connect.get CastaData hpttrg_vwinkel))
		(setq cosHTW (cos (/ (* PI ht_vwinkel) 180.0)))
		(setq h_ht_halb (* h_ht 0.5))
		
		(setq anteil_ht (/ h_ht_halb cosHTW))
			
		;(setq delta_lr_abtl (+ delta_v_ht anteil_ht))
		(setq delta_lr_abtl anteil_ht)
		(print delta_lr_abtl)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	
	; Anteil minAbstand und Riegelneigung an delta_lr des LB-Anbauteils
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(setq delta_lr_abtl (+ delta_lr_abtl minAbstand))
		
		
		(setq ht_vwinkel (Connect.get CastaData hpttrg_vwinkel))
		(setq tanHTW (tan (/ (* PI ht_vwinkel) 180.0)))
		(setq h_at_halb (* 0.5 h_trg))
		(setq anteil_durch_neigung_ht (* h_at_halb tanHTW))
		(if (< anteil_durch_neigung_ht 0.0) (setq anteil_durch_neigung_ht (- anteil_durch_neigung_ht)))
		
		(setq delta_lr_abtl (+ delta_lr_abtl anteil_durch_neigung_ht)) 	
		
	; ----------------------------------------------
	))	
	
	
	; ----------------------------------------------
	; Anteil delta_lr des AT (Sttze) an delta_lr LB-Anbauteil AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ---------------------------------------------- 
		(setq ht_vwinkel (Connect.get CastaData hpttrg_vwinkel))
		(setq tanHTW (tan (/ (* PI ht_vwinkel) 180.0)))
		(setq anteil_delta_lr_at (* delta_lr_at tanHTW))
		(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_abtl (- delta_lr_abtl anteil_delta_lr_at)))
		(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_abtl (+ delta_lr_abtl anteil_delta_lr_at)))
	; ---------------------------------------------- 
	))
	; ---------------------------------------------- 
	
	
	; ------------------------------------------------------
	; Anteil delta_v des HT an delta_lr LB-Anbauteil AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ---------------------------------------------- 
		(setq ht_vwinkel (Connect.get CastaData hpttrg_vwinkel))
		(setq cosHTW (cos (/ (* PI ht_vwinkel) 180.0)))
		(setq anteil_delta_v_ht (/ delta_v_ht cosHTW))
		(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq delta_lr_abtl (+ delta_lr_abtl anteil_delta_v_ht)))
		(if (= (Connect.get CastaData amHtOberflansch) 1)		(setq delta_lr_abtl (- delta_lr_abtl anteil_delta_v_ht)))
	; ---------------------------------------------- 
	))
	; ---------------------------------------------- 
	
	
	
	; --------------------------	
	; Anbauteil AT
	; --------------------------
	(Anbauteil.set lb_at_abtl (delta_lr (+ delta_lr_abtl)))
	
	(Anbauteil.set lb_ht_abtl (Master 1)) ;1
	(Anbauteil.set lb_at_abtl (Master 0))	;0
	
	
	
	
	
	
	; LOCHBILD-TEST
	;===================================================================
	(if (= LB_DEBUG 1)
		(progn
			(setq XPos_at (Connect.get CastaData XPos_AT))
			
			(setq dummy (Lochbild.create))
			(Lochbild.copy dummy Lchb_ID)
						
			(if (= (Connect.get CastaData linkesende) 1)
				(Traeger.addabtl tr_id dummy XPos_at 0.0 _WnklSteglochbildLinks_)
			)
			(if (= (Connect.get CastaData rechtesende) 1)
				(Traeger.addabtl tr_id dummy XPos_at 0.0 _WnklSteglochbildRechts_)
			)
			
			(setq dummy_abtl (Traeger.get Tr_ID Abteil dummy))
			(Anbauteil.set dummy_abtl (Master 1)
																(delta_lr delta_lr_abtl)
			)
		)
	)
	;===================================================================
	
	
)


; -------------------------------------------------------------
; Setzt das Anbauteil fr das Blech
; -------------------------------------------------------------
(defun setAnbauteilBlech (BLECH_ID)
	(print ">-----------------------------------------------------------")
	(print "SETZE ANBAUTEIL BLECH")
	
	; xPos
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	
	; Anbauteil Winkel
	(setq r_winkel_at (Traeger.get Tr_ID r_winkel))
	(setq h_winkel_ht	(Connect.get CastaData hpttrg_hwinkel))
	(print h_winkel_ht)
	(print r_winkel_at)
	
	(setq r_winkel_blech (- h_winkel_ht r_winkel_at))
	
	
	(if (= (Connect.get CastaData vatr-shtr)  1)	(setq r_winkel_blech  90.0))
	(if (= (Connect.get CastaData vatr-shtr) -1)	(setq r_winkel_blech 270.0))
		
	
	(print r_winkel_blech)
	
	
	; xPos am HT berechnen
	; ----------------------------------------------
	
	; Anteil der delta_v Verschiebung des Riegels an xPos des Fahnenbleches
	; ----------------------------------------------
	(setq delta_v_ht (Traeger.get Htrg delta_v))
	(setq vwinkel_ht (Connect.get CastaData hpttrg_vwinkel))
	(setq tanW (tan (/ (* PI vwinkel_ht) 180.0)))
	
	(setq anteil_delta_v_ht_xPos (* delta_v_ht tanW))
	(print anteil_delta_v_ht_xPos)
	
	(setq xPos_ht (- xPos_ht anteil_delta_v_ht_xPos))
	
	
	
	; Anbauteil Lasche dem HT hinzufgen
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(Traeger.addabtl Htrg BLECH_ID xPos_ht r_winkel_blech _fahnenblech_of_)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(Traeger.addabtl Htrg BLECH_ID xPos_ht r_winkel_blech _fahnenblech_uf_)
	)
	
	
	; delta_v Lasche
	(setq delta_v_at (Traeger.get Tr_ID delta_v))
	(print delta_v_at)
	
	;(if (= (Connect.get CastaData vatr-shtr)  1)
	;	(progn
	;		(if (= (Connect.get CastaData satr-lhtr)  1) 	(setq delta_v_abtl_lasche (- delta_v_at) ))
	;		(if (= (Connect.get CastaData satr-lhtr) -1) 	(setq delta_v_abtl_lasche (- delta_v_at) ))
	;	)
	;)
	;(if (= (Connect.get CastaData vatr-shtr) -1)
	;	(progn
	;		(if (= (Connect.get CastaData satr-lhtr)  1) 	(setq delta_v_abtl_lasche (- delta_v_at) ))
	;		(if (= (Connect.get CastaData satr-lhtr) -1) 	(setq delta_v_abtl_lasche (- delta_v_at) ))
	;	)
	;)
	(if (= (Connect.get CastaData vatr-shtr)  0)
		(progn
			(if (= (Connect.get CastaData RechtesEnde) 1)	(setq delta_v_abtl_lasche (- delta_v_at))	)
			(if (= (Connect.get CastaData LinkesEnde)  1)	(setq delta_v_abtl_lasche delta_v_at)			)
		)
		(progn
			(setq delta_v_abtl_lasche delta_v_at)
		)
	)
	
	
	; Anteil delta_lr HT
	; --------------------------
	;(setq delta_lr_ht (Traeger.get Htrg delta_lr))
	
	;(setq delta_v_abtl_lasche (- delta_v_abtl_lasche delta_lr_ht))
	
	
	; Anteil delta_v AT
	; --------------------------
	;(setq delta_lr_abtl_lasche 0.0)
	;(setq delta_v_at (Traeger.get Tr_ID delta_v))
	
	;(if (= (Connect.get CastaData vatr-shtr)  1) (setq delta_lr_abtl_lasche (- delta_lr_abtl_lasche delta_v_at)))
	;(if (= (Connect.get CastaData vatr-shtr) -1) (setq delta_lr_abtl_lasche (+ delta_lr_abtl_lasche delta_v_at)))
	
	
	; Neigung des Fahnenblechs bestimmen
	; --------------------------
	(setq nwinkel (Connect.get CastaData hpttrg_vwinkel))
	(print nwinkel)
	
	(if (= (Connect.get CastaData vatr-shtr)  1)	(setq nwinkel nwinkel))
	(if (= (Connect.get CastaData vatr-shtr) -1)	(setq nwinkel (- nwinkel)))
	
	; Werte setzen
	; --------------------------
	(setq abtl_lasche (Traeger.get Htrg Abteil BLECH_ID))
	
	(Anbauteil.set abtl_lasche 	(delta_v 		delta_v_abtl_lasche)
					;(delta_lr		delta_lr_abtl_lasche)
					(neigwnkl_d	nwinkel)
	)
	(print "<-----------------------------------------------------------")
)
; ------------------------------------------------------------------------
; Setzt die endgltige Blechhhe und -breite
; ------------------------------------------------------------------------
(defun korrBlechdaten (BlechID)
	(print ">-----------------------------------------------------------")
	(print "KORRIGIERE BLECHDATEN")
	
	(setq b_at (Traeger.get Tr_ID b))
	(setq b_at_halb	(* 0.5 b_at))
	
	(setq anschl_wnkl (Connect.get CastaData at_laengswinkel))
	(print anschl_wnkl)
		
	(if (> anschl_wnkl 90.0)	(setq anschl_wnkl (- 180.0 anschl_wnkl)))
	(print anschl_wnkl)
	
	(setq tanAW (tan (/ (* PI anschl_wnkl) 180.0)))
	(setq sinAW (sin (/ (* PI anschl_wnkl) 180.0)))
	(setq anteil_ht_neigung (/ b_at_halb tanAW))
	
	(print anteil_ht_neigung)
	(print minAbstand)
	(print e1_min_rund)
	(print e_min_rund)
	
	; korregiere Blech
	(Blech.set BlechID 	;(bp (+ minAbstand anteil_bpBlech_halb anteil_ht_neigung e1_min_rund (* e_min_rund 2.0)))
											(bp (+ minAbstand anteil_ht_neigung e1_min_rund (* e_min_rund 2.0)))
											(hp (* 2.0 e_min_rund))
	)
	
	
	(setq bpbl (Blech.get BlechID bp))
	(print bpbl)
	(print "<-----------------------------------------------------------")
)
; ------------------------------------------------------------------------
; HT ist rotiert, so dass keine 90-Verbindung besteht.
; ------------------------------------------------------------------------
(defun korr_HT_Rotation ()
 	(setq HT_RWinkel (Traeger.get HTrg R_Winkel))
 	

	(setq cosW (cos (/ (* PI HT_RWinkel) 180.0)))
	(setq tanW (tan (/ (* PI HT_RWinkel) 180.0)))
	(setq h_HT 	(Traeger.get HTrg h))
	(setq dv_HT 	(Traeger.get HTrg delta_V))

	(setq dlr_Blech (* tanW (- dv_HT)))
;	(setq dlr_Blech 0.0)

	(setq abtl_lasche (Traeger.get Htrg Abteil lasche))
	(setq dv_Blch_Curr (Anbauteil.get abtl_lasche delta_v))

	(Anbauteil.set abtl_lasche 	
					(delta_v	(+ dv_Blch_Curr dlr_Blech))
					(neigwnkl_q	HT_RWinkel)
	)
	(setq lb_ht_abtl (Traeger.get Htrg Abteil lchbAtrgSteg))
	(setq dv_Lb_Curr  (Anbauteil.get lb_ht_abtl delta_v))
	(setq dlr_Lb_Curr (Anbauteil.get lb_ht_abtl delta_lr))
	
	(setq dlr_Korr_Lochb (* tanW dlr_Blech))
	
	(Anbauteil.set lb_ht_abtl 	
					(delta_v	(+  dv_Lb_Curr	dlr_Blech))
					(delta_lr	(-  dlr_Lb_Curr	dlr_Korr_Lochb))
					(neigwnkl_q	HT_RWinkel)
	)
	
)