; $	HT	QT(IK)			AF(FS)			P(ZE)
; $	AT	QT(RK)			AF(SK)			P(ZE)
; $ 	AE	V(-)			H(-)			R(-)

(defun load-modules ()
	(load "mod-endinit-trg-auf-trg")
)

(defun init-connection ()
	
	(print "*clear*")
	; (connect.showattributes CastaData)
	(setq LB_DEBUG 0)

	(if (= (Connect.get CastaData amATSteg)    0) (print "amATSteg == 0"))
	(if (= (Connect.get CastaData amATSteg)    1) (print "amATSteg == 1"))
	(if (= (Connect.get CastaData amHTFlansch) 1) (print "amHTFlansch == 1"))
	(if (= (Connect.get CastaData amHTSteg)    1) (print "amHTSteg == 1"))

	(setq am_HT_Flansch 0)
	(setq am_HT_Steg    0)
	(if (= (Connect.get CastaData at-von-unten)   1) (setq am_HT_Steg 1))
	(if (= (Connect.get CastaData at-von-oben)    1) (setq am_HT_Steg 1))
	(if (= (Connect.get CastaData at-von-links)   1) (setq am_HT_Flansch 1))
	(if (= (Connect.get CastaData at-von-rechts)  1) (setq am_HT_Flansch 1))

	(if (= (Connect.get CastaData amATFlansch) 1)
		(alertBox "Der Anschluss ist nicht mglich.\n\nBitte rotieren Sie die Trger so, dass die Rckseite des Profils zur Anschlussseite des Haupttrgers passt." "ERR_RotateToBackside")
	)
	(if (= (Connect.get CastaData amATSteg) 0)
		(AlertBox "Am_AT_Steg ist 0")
	)
	
	(if (= 1 1) (progn
		(if (= (Connect.get CastaData amATSteg) 1) (progn
			(if (= am_HT_Flansch 1)
				(setConnection_2)
			)
			(if (= am_HT_Steg 1)
				(setConnection_1)
			)
		))
	))

	
	
  (if (= 2 3) (progn
	

	(if (= (Connect.get CastaData amATSteg) 0)
	    (if (= (Connect.get CastaData amHTFlansch) 1)
		(setConnection_2)
	    )
	)

	(if (= (Connect.get CastaData amATSteg) 1)
		(setConnection_1)
	)

	(print "*clear*")
	(connect.showattributes CastaData)
	
  ))
)


(defun setConnection_2 ()
	(print ".... starte setConnection_2 ...")


	(init-traegerenden)
	(calcLichtenAbst) ; -> lichterAbst

	(if (> lichterAbst 2.0)
		(progn
			(setq KontaktPlatte (Blech.create))
			(Connect.storeAnschlObjs CastaData KontaktPlatte)
			(print "KontaktPlatte-Objekt wurde erzeugt!")
			
			(createKontaktplatte KontaktPlatte lichterAbst)

			(setq fllochbild (Lochbild.create))
			(Connect.storeAnschlObjs CastaData fllochbild)
			
			(createFlanschLochbild fllochbild lichterAbst)
			
			(LB_StegAnpassen  fllochbild)

			(BlechAnpassen fllochbild KontaktPlatte)

		)
	)

	(if (= (Connect.get CastaData Anz_weitere_Anschl) 0) (progn
		(stzEndeAnpassen)
	))

)
(defun setConnection_1 ()
	(print ".... starte setConnection_1 ...")

	(init-traegerenden)
	
	(calcLichtenAbst) ; -> lichterAbst
	
	
	(if (> lichterAbst 2.0)
		(progn
			(setq KontaktPlatte (Blech.create))
			(Connect.storeAnschlObjs CastaData KontaktPlatte)
			(print "KontaktPlatte-Objekt wurde erzeugt!")
			
			(createKontaktplatte KontaktPlatte lichterAbst)
		)
	)
	
	(setq fllochbild (Lochbild.create))
	(Connect.storeAnschlObjs CastaData fllochbild)
	
	(createFlanschLochbild fllochbild lichterAbst)
	
	(setq AT_ABTeil (Traeger.get Tr_ID AbTeil fllochbild))
	(setq Curr_DeltaLR (Anbauteil.get AT_ABTeil delta_lr))
	(print Curr_DeltaLR)
	
	(LB_StegAnpassen  fllochbild)

	(setq Curr_DeltaLR (Anbauteil.get AT_ABTeil delta_lr))
	(print Curr_DeltaLR)
	
	(if (> lichterAbst 2.0) (progn		; nur zur Sicherheit, dass das Blech erzeugt wurde.
		(BlechAnpassen fllochbild KontaktPlatte)
	))
	
	(if (= (Connect.get CastaData Anz_weitere_Anschl) 0) (progn
		(stzEndeAnpassen)
	))
	
	; TEST
	; ******************************************************************
(if (= LB_DEBUG 1) (progn
	(setq lbdummy (Lochbild.create))
	(Lochbild.copy lbdummy fllochbild)
	
	; Anbauteil dem At hinzufgen
	(if (= (Connect.get CastaData amAtOberflansch) 1)
		(traeger.addabtl Tr_ID lbdummy xPos_at 0.0 _flanschlochbild_of_)	
	)
	(if (= (Connect.get CastaData amAtUnterflansch) 1)
		(traeger.addabtl Tr_ID lbdummy xPos_at 0.0 _flanschlochbild_uf_)
	)
	(if (= (Connect.get CastaData amAtStegLinks) 1)
		(traeger.addabtl Tr_ID lbdummy xPos_at 0.0 _steglochbild_)
	)
	
	(setq AT_ABTeil_dummy (Traeger.get Tr_ID AbTeil lbdummy))
	(Anbauteil.set AT_ABTeil_dummy 	(winkel   winkel_abteil_at)
									(delta_lr		delta_lr_abteil_at)
				 					(Master    1)
	)
	
	(Connect.storeAnschlObjs CastaData lbdummy)
))
	; ******************************************************************
)



(defun calcAndSetLochbildDaten (Lchb_ID ABST)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID	(S_Bez 		"M12")
							(Guete   	"4.6")
	)
	
	(setq	t_at 	(Traeger.get Tr_ID t)
			b_at	(Traeger.get Tr_ID b)
			s_at	(Traeger.get Tr_ID s)
			r_at	(Traeger.get Tr_ID r)
			hc_at	(Traeger.get Tr_ID hc)
			h_at	(Traeger.get Tr_ID h)
	)
	
	(setq	t_ht	(Traeger.get Htrg t)
			b_ht	(Traeger.get Htrg b)
			s_ht	(Traeger.get Htrg s)
			r_ht	(Traeger.get Htrg r)
	)
	
	(setq VIER 0)
	
	; vorhandene Anschlusslnge an einer Flanschseite (AT-Ende Anschluss)
	(setq anschl (* 0.5 (- b_ht (+ (* 2 r_ht) s_ht))))
	(print anschl)
	
	; Schraubendurchmesser holen
	(setq dschr (Lochbild.get Lchb_ID sdurchm))
	; Rand- und Lochabstnde
	(setq mine0 (* 2 dschr))
	(setq mine1 (* 4 dschr))
	
	; minimal bentige Anschlusslnge fr zwei Schrauben (M12)
	(setq minAnschl (+ (* 2 mine0) mine1))
	(print minanschl)
	
	(if (= (Connect.get CastaData anschlzwAtEnden) 1) (progn
			(setq VIER 1)
			(if (<= minAnschl anschl) (setq VIER 0))
	))

;	(if (= (Connect.get CastaData amAtSteg) 1)
;		(progn
			; dxSKopf
;			(setq dxSKopf (+ s_at ABST))
			(setq dxSKopf ABST)
			
			(setq abzug_ht (+ s_ht (* 2 r_ht)))
			(setq rest_ht (- b_ht abzug_ht))
				
			(setq e1 (* 0.5 hc_at))
			(setq e1rund (runde e1 auf 5))
			
			(setq e0 (- (* 0.5 h_at) (* 0.5 e1rund)))
			(print e0)
			;(setq e0rund (runde e0 auf 5))
			;(print e0rund)
			(print VIER)
			
			(setq eAbst (runde (* 2 dschr) auf 5))
			
			(setq e0 	(- eAbst))
			(setq e1rund 	(+ h_at eAbst eAbst))

			; Eingebaut Sept 2015
			(if (< ABST 2.0) (progn
			    (setq sd (Lochbild.get Lchb_ID sdurchm))
			    (setq e0       (+ t_ht (* 0.5 (- h_at hc_at))  sd sd))
			    (setq e1rund   (- h_at e0 e0))
			))


			
			(if (= VIER 0)
				(progn
					(setq w0 (+ (* 0.5 rest_ht) abzug_ht))
					(print w0)
					(setq w0rund (runde w0 auf 5))
					(print w0rund)
					
					(Lochbild.set Lchb_ID
								(e0				e0)
								(e1				e1rund)
								;(e2				200)
								(w0				w0) 	
								(klemml 	(+ t_ht  ABST))
								(dxSKopf  dxSKopf)
					)


				)
			)
			(if (= VIER 1)
				(progn
					(setq w0 (+ (* 0.25 rest_ht) abzug_ht))
					(print w0)
					(setq w0rund (runde w0 auf 5))
					(print w0rund)
					(setq w1 (+ (* 0.75 rest_ht) abzug_ht))
					(print w1)
					(setq w1rund (runde w1 auf 5))
					(print w1rund)
					
					(Lochbild.set Lchb_ID	(e0				e0)
								(e1				e1rund)
								(w0				w0)
								(w1				0) 	
								(klemml 	(+ t_ht  ABST))
								(dxSKopf  	dxSKopf)
					)
				)
			)
			
			
			
;		)
;	)
	
	
	(if (= LB_DEBUG 1)
		(progn
			(if (= (Connect.get CastaData amAtSteg) 1)
				(Lochbild.set Lchb_ID	(e2				200))
				(Lochbild.set Lchb_ID	(e1				200))
			)
		)
	)
	
	; LOCHBILDART BESTIMMEN
	; ----------------------------------------------
	
	(print SCHRAUBENBILD)
	
	(if (= VIER 0)
		(progn
			; ---- an Trgerenden halbe Lochbilder einbauen mit LB_Art 2 - oder -2
;			(if (= (connect.get CastaData amAtSteg) 1)
;				(progn
					(if (= (Connect.get CastaData amHtOberflansch) 1)
						(progn
							(if (= (Connect.get CastaData linkesEnde) 1)	(Lochbild.set Lchb_ID (Lb_Art  2))	)
							(if (= (Connect.get CastaData rechtesEnde) 1)	(Lochbild.set Lchb_ID (Lb_Art -2))	)
						)
					)
					(if (= (Connect.get CastaData amHtUnterflansch) 1)
						(progn
							(if (= (Connect.get CastaData linkesEnde) 1)	(Lochbild.set Lchb_ID (Lb_Art  2))	)
							(if (= (Connect.get CastaData rechtesEnde) 1)	(Lochbild.set Lchb_ID (Lb_Art -2))	)
						)
					)
;				)
;			)
	
	
			(setq lb_art (Lochbild.get Lchb_ID Lb_Art))
			(print lb_art)
			
		)
	)
	(print "<-----------------------------------------------------------")
)



(defun createFlanschLochbild (Lchb_ID ABST)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE LOCHBILD")
	
	(calcAndSetLochbildDaten Lchb_ID ABST)
	
	(setq	delta_lr_at	(Traeger.get Tr_ID delta_lr)
			delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	
	(setq delta_lr_ht	(Traeger.get Htrg delta_lr))
	
	(setq xPos_ht		(Connect.get CastaData xPos_ht))
	(setq xPos_at		(Connect.get CastaData xPos_at))
	
	(print xPos_ht)
	(print xPos_at)
		
	; Anbauteil dem Ht hinzufgen
	(print am_HT_Flansch)(print am_HT_Steg)

	(if (= 1 1) (progn
		(if (= am_HT_Flansch 1) (progn
			; normaler Fall - Flanschlochbild
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _flanschlochbild_of_)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _flanschlochbild_uf_)
			)
		))
		(if (= am_HT_Steg 1) (progn
			; hier muss ein Steglochbild hinzugefgt werden
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				; (traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _couponlochbild_links_)
				(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _steglochbild_system_)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				; (traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _couponlochbild_rechts_)
				(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _steglochbild_system_)
			)
		))
	))
	(if (= 3 4) (progn
		(if (= (Connect.get CastaData amAtSteg) 1) (progn
			; normaler Fall - Flanschlochbild
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _flanschlochbild_of_)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _flanschlochbild_uf_)
			)
		))
		(if (= (Connect.get CastaData amAtSteg) 0) (progn
			; hier muss ein Steglochbild hinzugefgt werden
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				; (traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _couponlochbild_links_)
				(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _steglochbild_system_)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				; (traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _couponlochbild_rechts_)
				(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _steglochbild_system_)
			)
		))
	))
	
	; ---- Hier muss noch hin, dass am Steg des HT angeschlossen werden kann
	; der Abstand von der Systemachse - ermittelt der sich automatisch? Oder muss
	; der hier explizit berechnet werden in Abhngigkeit von links oder von rechts?
	
	; Anbauteil dem At hinzufgen
;;	(if (= (Connect.get CastaData amAtOberflansch) 1)
;;		(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _flanschlochbild_of_)	
;;	)
;;	(if (= (Connect.get CastaData amAtUnterflansch) 1)
;;		(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _flanschlochbild_uf_)
;;	)

;;	(if (= (Connect.get CastaData amAtStegLinks) 1)
		; (traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _steglochbild_)
		(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _steglochbild_system_)
		
;;	)
	

	; Anbauteil-Winkel AT
	; --------------------------
	; am AT Steg
	(setq winkel_abteil_at 0.0)
	
	; Anbauteil-Winkel HT
	; --------------------------
	; am AT Steg
;	(if (= (Connect.get CastaData amATSteg) 1)
;		(progn
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq winkel_abteil_ht 180.0)	)
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq winkel_abteil_ht 0.0)		)
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq winkel_abteil_ht 180.0)	)
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq winkel_abteil_ht 0.0)		)
				)
			)
;		)
;	)
	
	
	(setq delta_v_abteil_ht 0.0)
	(setq delta_lr_abteil_at 0.0)
	
	; Positionierung Anbauteil HT an AT (nur wenn am AT-Steg)
	; --------------------------
;	(if (= (Connect.get CastaData amATSteg) 1)
;		(progn
			(setq h_at (Traeger.get Tr_ID h))
			(setq delta_v_abteil_ht (- delta_v_abteil_ht (* 0.5 h_at)))
;		)
;	)
	
	
	; Anbauteil delta_v HT
	; --------------------------
;	(if (= (Connect.get CastaData amATSteg) 1)
;		(progn
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_v_at))	)
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_v_at))	)
;		)
;	)
	
	; Anbauteil delta_lr AT
	; --------------------------
;	(if (= (Connect.get CastaData amATSteg) 1)
;		(progn
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abteil_at (+ delta_lr_abteil_at delta_lr_ht))	)
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abteil_at (- delta_lr_abteil_at delta_lr_ht))	)
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abteil_at (- delta_lr_abteil_at delta_lr_ht))	)
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abteil_at (+ delta_lr_abteil_at delta_lr_ht))	)
				)
			)
;		)
;	)

	(setq winkel_abteil_at (+ winkel_abteil_at -90.0))	; Wenn StegLochbild-System verwendet wird
	(setq	h_AT	(Traeger.get Tr_ID h))
	(setq delta_V_abteil_AT (* -0.5 h_AT))


	
	
	(print delta_v_abteil_ht)
	(print delta_lr_abteil_at)
	
	(print winkel_abteil_ht)
	(print winkel_abteil_at)
	; HT-Anbauteil Werte setzen
	(setq HT_ABTeil (Traeger.get Htrg AbTeil Lchb_ID))
	
	(Anbauteil.set HT_ABTeil 	(winkel		winkel_abteil_ht)
					(Master		1)
					(delta_v	delta_v_abteil_ht)
	)
	


	; AT-Anbauteil Werte setzen
	(setq AT_ABTeil (Traeger.get Tr_ID AbTeil Lchb_ID))
	
	(Anbauteil.set AT_ABTeil 	(winkel  	winkel_abteil_at)
					(delta_lr	delta_lr_abteil_at)
					(delta_V	delta_V_abteil_AT)
					(Master		0)
	)

	; (if (= (Connect.get CastaData vatr-vhtr) -1)	(Anbauteil.set AT_ABTeil 	(SeitRicht  -1)))
	
	; Richtung des Lochbilds festlegen
	(Anbauteil.set AT_ABTeil 	(SeitRicht  1))
	; (if (= (Connect.get CastaData amHtUnterflansch) 1) (Anbauteil.set AT_ABTeil 	(SeitRicht  -1)))

)



(defun calcLichtenAbst ()
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "BERECHNE LICHTEN ABSTAND DER TRGER")
	(setq	delta_v_at 	(Traeger.get Tr_ID delta_v)
			delta_lr_at	(Traeger.get Tr_ID delta_lr)
			h_at		(Traeger.get Tr_ID h)
			b_at		(Traeger.get Tr_ID b)
	)
	
	(setq	delta_v_ht	(Traeger.get Htrg delta_v)
			delta_lr_Ht	(Traeger.get Htrg delta_lr)
			h_ht		(Traeger.get Htrg h)
			b_ht		(Traeger.get Htrg b)
	)
	
	(setq h_at_halb	(* 0.5 h_at))
	(setq h_ht_halb	(* 0.5 h_ht))
	(setq b_ht_halb	(* 0.5 b_ht))

	(setq lichterAbst 0.0)

	(if (= (Connect.get CastaData satr-vhtr) -1)  (setq delta_v_ht (- delta_v_ht)))

	
	(if (= (Connect.get CastaData amAtSteg) 1)  (progn
		(if (= (Connect.get CastaData amAtStegLinks) 1)  (progn
			(setq lichterAbst (- (- (-  h_ht_halb delta_lr_at)) delta_v_ht))
		))
		(if (= (Connect.get CastaData amAtStegRechts) 1)  (progn
			(setq lichterAbst (+ (- (+  h_ht_halb delta_lr_at)) delta_v_ht))
		))
		(setq lichterAbst (- lichterAbst (* 0.5 b_at))) ; bei U-Profilen und Winkel diesen Wert nicht bercksichtigen
	))

	(if (= (Connect.get CastaData amAtSteg) 0)  (progn
		(if (= (Connect.get CastaData satr-shtr) 1)  (progn
			(setq lichterAbst (- (- (-  b_ht_halb delta_lr_at)) delta_lr_ht))
		))
		(if (= (Connect.get CastaData satr-shtr) -1)  (progn
			(setq lichterAbst (+ (- (-  b_ht_halb delta_lr_at)) delta_lr_ht))
		))

	))

	(print lichterAbst)
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)




(defun calcKontaktPlatte (BLECH_ID ABST)
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "BERECHNE KontaktPlatteDATEN")
	(setq	b_at		(Traeger.get Tr_ID b)
		h_at		(Traeger.get Tr_ID h)
	)
	
	(setq	b_ht		(Traeger.get Htrg b)
		s_ht		(Traeger.get Htrg s)
	)
	
	; KontaktPlattedicke
	(setq dp_futter ABST)
	
	; Blechabmessung in Richtung Trgerhhe
	(setq bp_futter (* 2.0 h_at))
	
	; Hhe
	(if (= (Connect.get CastaData anschlZwAtEnden) 0)
		(progn
			(setq hp_futter (- (* 0.5 b_ht) (* 0.5 s_ht)))
		)
		(progn
			(setq hp_futter b_ht)
		)
	)
	(if (= (Connect.get CastaData amATSteg) 0) (progn
	    (if (= (Connect.get CastaData anschlZwAtEnden) 0)
		(setq hp_futter (- (* 0.5 h_ht) (* 0.5 s_ht)))
	    )
	))
	
	(Blech.set BLECH_ID	(hp hp_futter)
				(bp bp_futter)
				(dp dp_futter)
	)
	
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)



(defun createKontaktplatte (BLECH_ID ABST)
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "ERZEUGE Kontaktplatte")
	(calcKontaktPlatte BLECH_ID ABST)
	
	(setq	delta_lr_ht 	(Traeger.get Htrg delta_lr)
			s_ht			(Traeger.get Htrg s)
	)
	
	(setq xPos_at	(Connect.get CastaData xPos_at))
	
	(setq	hp_futter	(Blech.get BLECH_ID hp)
		bp_futter	(Blech.get BLECH_ID bp)
	)
	
	; Beim Anschluss mit AT-Enden
	(if (= (Connect.get CastaData anschlZwAtEnden) 0) (progn
		(if (= (Connect.get CastaData amATSteg) 1) (progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (+ xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (+ xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPos_at (+ xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPos_at (+ xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (- xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (- xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPos_at (- xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPos_at (- xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
				)
			)
		))
	))
	
	; Anteil delta_lr HT
;	(if (= (Connect.get CastaData amATSteg) 1)
;		(progn
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPos_at (- xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPos_at (- xPos_at delta_lr_ht)))
				)
			)
;		)
;	)
	(setq xPos_at	(Connect.get CastaData xPos_at))
	(if (= (Connect.get CastaData amAtStegLinks) 1) (Traeger.addabtl Tr_ID BLECH_ID xPos_at 0.0 _lasche_steg_li_))
	(if (= (Connect.get CastaData amAtStegRechts) 1) (Traeger.addabtl Tr_ID BLECH_ID xPos_at 0.0 _lasche_steg_re_))
	
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)
(defun BlechAnpassen (Lchb_ID Blech_ID)
	; Schraubendurchmesser holen
	
	(setq dschr	(Lochbild.get Lchb_ID sdurchm))
	(setq h_At	(Traeger.get Tr_ID  h))
	
	(setq Ueberstand (runde (* 4 dschr) auf 10))
	(Blech.set Blech_ID (bp (+ h_At Ueberstand Ueberstand)))


)


(defun	LB_StegAnpassen (Lchb_ID)

	; AT-Anbauteil Werte setzen
	(setq HT_ABTeil (Traeger.get HTrg  AbTeil Lchb_ID))
	(setq AT_ABTeil (Traeger.get Tr_ID AbTeil Lchb_ID))

	; fr Steganschluss
	(if (= (Connect.get CastaData amATSteg) 1) (progn
	
		(setq b_HT (Traeger.get HTrg b))
		(setq SeitRicht (Anbauteil.get HT_ABTeil SeitRicht))
		(if (= SeitRicht 0) (setq SeitRicht 1))
		 
		 
		(if (= (Connect.get CastaData amHtOberflansch) 1) (progn
		    (if (= (Connect.get CastaData satr-shtr) 1) (progn
				(Lochbild.set Lchb_ID 	(dlr_coupon	(/ b_HT 2)))

				; Weil das Lochbild anders herum gezeichnet wird
				(setq s_HT (Traeger.get HTrg s))
				(Lochbild.set Lchb_ID (dxsKopf s_HT))
		    ))
		    (if (= (Connect.get CastaData satr-shtr) -1) (progn
				(Lochbild.set Lchb_ID 	(dlr_coupon	(- (/ b_HT 2))))
		    ))
		))
		(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
		    (if (= (Connect.get CastaData satr-shtr) 1) (progn
				(Lochbild.set Lchb_ID 	(dlr_coupon	(/ b_HT 2)))
		    ))
		    (if (= (Connect.get CastaData satr-shtr) -1) (progn
				(Lochbild.set Lchb_ID 	(dlr_coupon	(- (/ b_HT 2))))
		    ))
		))
	))

	(setq delta_LR_HT (Traeger.get HTrg delta_LR))

	(if (= (Connect.get CastaData at-von-links) 1) (progn
		(Anbauteil.set AT_ABTeil (delta_LR delta_LR_HT))
	))
	
    (if (= (Connect.get CastaData at-von-rechts) 1) (progn
		(Anbauteil.set HT_ABTeil (SeitRicht -1))
		(Anbauteil.set AT_ABTeil (delta_LR (- delta_LR_HT)))
	))
	
	; Wenn Vertikal-Richtung des Handlaufs nach oben zeigt und Sttze ebenfalls von unten nach oben,
	; oder umgekehrter Fall, dann muss das Lochbild seitlich umgedreht werden.
	(if (= (Connect.get CastaData vAtr-lHtr) 1) (progn
		(setq currSeitRicht (Anbauteil.get HT_ABTeil SeitRicht))
		(if (>= currSeitRicht 0) 
			(setq currSeitRicht -1)
			(setq currSeitRicht  1)
		)
		(Anbauteil.set HT_ABTeil (SeitRicht currSeitRicht))
	))
	

	
;	xPos korrigieren
	(setq delta_v_HT (Traeger.get HTrg delta_V))
	(setq delta_LR_HT (Traeger.get HTrg delta_LR))
	(setq xPos_AT (Connect.get CastaData xPos_AT))

	(if (objExist KontaktPlatte) (progn
	   (setq ABTl_Blech (Traeger.get Tr_ID ABTeil KontaktPlatte))
	   (setq xPos_Bl (Anbauteil.get   ABTl_Blech xPos))
	   (setq xPos_Bl 0.0)
	   
	   (if (= (Connect.get CastaData at-von-links) 1)   (setq xPos_Bl (+ xPos_Bl delta_LR_HT)))
	   (if (= (Connect.get CastaData at-von-rechts) 1)  (setq xPos_Bl (- xPos_Bl delta_LR_HT)))

	   (if (= (Connect.get CastaData anschlZwAtEnden) 0) (progn
				(setq hp_Bl (Blech.get KontaktPlatte hp))
			(if (= (Connect.get CastaData linkesEnde) 1) (progn
				(setq xPos_Bl (+ xPos_Bl (* 0.5 hp_Bl)))
			))
			(if (= (Connect.get CastaData rechtesEnde) 1) (progn
				(setq xPos_Bl (- xPos_Bl (* 0.5 hp_Bl)))
			))
			(Lochbild.set Lchb_ID (w0 (* 0.5 hp_Bl)))
	   ))
		(Blech.set KontaktPlatte (dOK xPos_Bl))
	))


	
	(setq AT_ABTeil_Lb (Traeger.get Tr_ID AbTeil Lchb_ID))
	(setq xPos_Lb (Anbauteil.get   AT_ABTeil_Lb xPos))
	(setq xPos_Lb xPos_AT)

	(if (= (Connect.get CastaData at-von-unten) 1) (setq xPos_Lb (- xPos_Lb delta_v_HT)))
	(if (= (Connect.get CastaData at-von-oben) 1)  (setq xPos_Lb (+ xPos_Lb delta_v_HT)))
	       
	(setq dlr_coupon (Lochbild.get Lchb_ID 	dlr_coupon))
	(setq b_AT (Traeger.get Tr_ID b))
	
	(setq dlr_coupon 0.0)
	(if (= (Connect.get CastaData amAtStegLinks)  1) (setq dlr_coupon (*  0.5 b_AT)))
	(if (= (Connect.get CastaData amAtStegRechts) 1) (setq dlr_coupon (* -0.5 b_AT)))
	
	       
	(Anbauteil.set AT_ABTeil_Lb (xPos xPos_Lb))
	(Anbauteil.set AT_ABTeil_Lb (delta_SX (- dlr_coupon)))

)

(defun stzEndeAnpassen ()
	(setq 	h_AT 	(Traeger.get Tr_ID h)
			dv_AT	(Traeger.get Tr_ID delta_v)
	)
	(setq dl_ende 0.0)

	(if (= (Connect.get CastaData vAtr-lHtr) 1) (progn
		(setq dl_Ende (- (- (* 0.5 h_AT) dv_AT)))
	))
	(if (= (Connect.get CastaData vAtr-lHtr) -1) (progn
		(setq dl_Ende (+ (* -0.5 h_AT) dv_AT))
	))

	(if (= (Connect.get CastaData anhtlinkesende) 1) (progn
		(setq tEnde (Traeger.get HTrg links))
		(setq curr_DL (TrEnde.get tEnde delta_L))
		(if (= curr_DL 0.0) (TrEnde.set tEnde (delta_L dl_Ende)))
	))
	(if (= (Connect.get CastaData anhtrechtesende) 1) (progn
		(setq tEnde (Traeger.get HTrg rechts))
		(setq curr_DL (TrEnde.get tEnde delta_L))
		(if (= curr_DL 0.0) (TrEnde.set tEnde (delta_L dl_Ende)))
	))
)
