; $			HT	QT(U)		AF(S)		P(ZE)
; $			AT	QT(K)		AF(F)		P(ZE)
; $			AE	V(0)		H(75-105)		R(-)


(defun load-modules ()
	(print "Module laden ...")
	; (load "mod-endinit-trg-auf-trg")
)

(defun init-connection ()
	(print "*clear*")
	(Connect.showAttributes CastaData)
	(geometrieCheck)

	(setq hWnklFl (Connect.get CastaData h-atrgewnkl_flansch) hWnklFl (* 1 hWnklFl))

	(setq runMakro 1)
	(if (<= LichtAbstand 2) 	(setq runMakro 0))
	(if (= am_HT_LinksVorbei 0) (setq runMakro 0))
	(if (/= hWnklFl 90) 		(setq runMakro 0))
	
	(if (= runMakro 1) (progn
		(createConnection)
	))
	(if (= runMakro 0) (AlertBox "Anschluss nicht möglich!" "Connection_Not_Possible"))
	
)

(defun geometrieCheck ()
	(setq	qsForm_HT	(Traeger.get HTrg  qsForm)
			b_HT 		(Traeger.get HTrg  b)
			dlr_HT		(Traeger.get HTrg  delta_LR)
	)
	(setq	h_AT 		(Traeger.get Tr_ID h)
			dv_AT		(Traeger.get Tr_ID delta_V)
	)

	(setq am_HT_LinksVorbei  0)
	(setq am_HT_RechtsVorbei 0)
	(setq SysAbstand 0)
	(setq LichtAbstand 0)
	(if (= (Connect.get CastaData vAtr-sHtr) -1) (progn
		(setq SysAbstand (+ dlr_HT dv_AT))
		(if (< SysAbstand 0) (progn
			(setq LichtAbstand (+ SysAbstand (* 0.5 h_AT)))
		))
		(if (> SysAbstand 0) (progn
			(setq LichtAbstand (- SysAbstand (* 0.5 h_AT)))
		))
	))
	(if (= (Connect.get CastaData vAtr-sHtr) 1) (progn
		(setq SysAbstand (- dlr_HT dv_AT))

		(if (< SysAbstand 0) (progn
			(setq LichtAbstand (+ SysAbstand (* 0.5 h_AT)))
		))
		(if (> SysAbstand 0) (progn
			(setq LichtAbstand (- SysAbstand (* 0.5 h_AT)))
		))
	))
	
	(if (< SysAbstand 0) (setq am_HT_RechtsVorbei 1))
	(if (> SysAbstand 0) (setq am_HT_LinksVorbei 1))
	
	(if (= am_HT_LinksVorbei 1) (progn
		(print "am_HT_LinksVorbei")
		(setq b_Eff (* 0.5 b_HT))
		(if (= qsForm_HT "U") (setq b_Eff 0))
		(setq LichtAbstand (- LichtAbstand b_Eff))
	))
	(if (= am_HT_RechtsVorbei 1) (progn
		(print "am_HT_RechtsVorbei")
		(setq b_Eff (* 0.5 b_HT))
		(if (= qsForm_HT "U") (setq b_Eff b_HT))
		(setq LichtAbstand (- (- LichtAbstand) b_Eff))
	))
	
;	(AlertBox am_HT_LinksVorbei) (AlertBox am_HT_RechtsVorbei)
;	(AlertBox LichtAbstand)
	
)
(defun createConnection ()
	(addBlech_to_AT)
	(initLochbild)
	(AddLochbild_to_AT)
	(AddLochbild_to_HT)
	
	(AT_Ende_Anpassen)

	
	(Anbauteil.set Abtl_Lchb_AT (Master 0))
	(Anbauteil.set Abtl_Lchb_HT (Master 1))

	; Winkelrichtungscheck
	; (setq Wnkl_Lchb_HT (Anbauteil.get Abtl_Lchb_HT Winkel))
	; (Anbauteil.set  Abtl_Lchb_HT (Winkel (+ Wnkl_Lchb_HT 15)))
	; (setq Wnkl_Lchb_AT (Anbauteil.get Abtl_Lchb_AT Winkel))
	; (Anbauteil.set  Abtl_Lchb_AT (Winkel (+ Wnkl_Lchb_AT 15)))
	
)
(defun addBlech_to_AT ()
	(setq	h_HT 	(Traeger.get HTrg h)
			dv_HT	(Traeger.get HTrg delta_V)
	)
	(setq	b_AT	(Traeger.get Tr_ID b))

	(setq sd 16)	; Lochdurchmesser M16
	(setq bp_Apl (+ (* 8 sd) b_AT))

	(if (= (Connect.get CastaData at-von-unten) 1) (setq dv_HT (- dv_HT)))
	
	(setq APl (Blech.create))
	(Blech.set APl
		(dp		LichtAbstand)
		(hp		h_HT)
		(bp		bp_Apl)
		(dOK	dv_HT)
	)
	
	(Connect.storeAnschlObjs CastaData APl)
	
	(setq xPos_AT (Connect.get  CastaData xPos_AT))
	(if (= (Connect.get CastaData amAtOberflansch) 1) (Traeger.addAbtl	Tr_ID APl xPos_AT 0.0  _lasche_of_))
	(if (= (Connect.get CastaData amAtUnterflansch) 1) (Traeger.addAbtl	Tr_ID APl xPos_AT 0.0  _lasche_uf_))
	

)
(defun initLochbild ()
	(setq	s_HT (Traeger.get HTrg  s)
			h_HT (Traeger.get HTrg  h)
	)
	(setq	b_AT (Traeger.get Tr_ID b))
	(setq	KlemmLaenge (+ s_HT LichtAbstand))
	
	(setq sd 16)	; Lochdurchmesser M16
	
	(setq w_0 (+ (* 4 sd) b_AT))
	(setq e4  (/ h_HT 4.0))

	(setq Lchb_ID (Lochbild.create))
	
	(Lochbild.set Lchb_ID
		(S_Bez "M16")
		(Guete "4.6")
		(e "0 0 0 0 0 0")
		(w "0 0 0 0")
		(w0 w_0)
		(e0 (- e4))
		(e1 (* 2 e4))
		(LB_Art 0)
		(KlemmL KlemmLaenge)
		(dxSKopf LichtAbstand)
	)

	(Connect.storeAnschlObjs CastaData Lchb_ID)

)

(defun AddLochbild_to_AT ()
	(setq xPos_AT (Connect.get  CastaData xPos_AT))
	(if (= (Connect.get CastaData amAtOberflansch) 1) (Traeger.addAbtl	Tr_ID Lchb_ID xPos_AT 0.0  _flanschlochbild_of_))
	(if (= (Connect.get CastaData amAtUnterflansch) 1) (Traeger.addAbtl	Tr_ID Lchb_ID xPos_AT 0.0  _flanschlochbild_uf_))
	
	(setq Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil Lchb_ID))
	
	(setq	dv_HT	(Traeger.get HTrg delta_V))
	(if (= (Connect.get CastaData at-von-unten) 1) (setq dv_HT (- dv_HT)))
	(Anbauteil.set Abtl_Lchb_AT (delta_V dv_HT))

)	
(defun AddLochbild_to_HT ()
	(setq xPos_HT (Connect.get  CastaData xPos_HT))
	(if (= (Connect.get CastaData amhtStegLinks)  1) (Traeger.addAbtl	HTrg Lchb_ID xPos_HT 0.0  _steglochbild_system_ ))
	(if (= (Connect.get CastaData amhtStegRechts) 1) (Traeger.addAbtl	HTrg Lchb_ID xPos_HT 0.0  _steglochbild_system_ ))

	(setq Abtl_Lchb_HT (Traeger.get HTrg ABTeil Lchb_ID))

	(setq dlr_AT (Traeger.get Tr_ID delta_LR))
	(if (= (Connect.get CastaData sAtr-lHtr)  1) (setq dlr_AT (- dlr_AT)))
	
	
	(setq Wnkl_Lchb 90.0)
	(Anbauteil.set Abtl_Lchb_HT (Winkel Wnkl_Lchb)
								(delta_LR dlr_AT)
	)

)

(defun AT_Ende_Anpassen ()
	(setq 	h_HT 	(Traeger.get HTrg h)
			dv_HT	(Traeger.get HTrg delta_V)
	)
	
	
	(setq dl_ende 0.0)
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
		(if (= (Connect.get CastaData at-von-unten) 1) (progn
			(setq dl_ende (+ (* 0.5 h_HT) dv_HT))
		))
		(if (= (Connect.get CastaData at-von-oben) 1) (progn
			(setq dl_ende (- (* 0.5 h_HT) dv_HT))
		))
		(setq TrgEnde (Traeger.get Tr_ID links))
		(TrEnde.set TrgEnde (delta_l (- dl_ende)))
	))
		
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(if (= (Connect.get CastaData at-von-unten) 1) (progn
			(setq dl_ende (- (* 0.5 h_HT) dv_HT))
		))
		(if (= (Connect.get CastaData at-von-oben) 1) (progn
			(setq dl_ende (+ (* 0.5 h_HT) dv_HT))
		))
		(setq TrgEnde (Traeger.get Tr_ID rechts))
		(TrEnde.set TrgEnde (delta_l (- dl_ende)))
	
	))
	
	


)