; $	HT	QT(I)			AF(FS)			P(ZE)
; $	AT	QT(I)			AF(SFK)			P(ZE)
; $ 	AE	V(-)			H(-)			R(-)

(defun load-modules ()
	(load "mod-endinit-trg-auf-trg")
)

(defun init-connection ()
	
	(print "*clear*")
	(connect.showattributes CastaData)
	(setq LB_DEBUG 0)

	; Diese defines werden verwendet, damit es weniger nderungen braucht, um 
	; das Makro anzupassen, wenn CastaData umkonfiguriert wird
	; Es soll ein Bereich eingefhrt werden speziel fr sich kreuzende Profile
	(setq linke_Seite  1)
	(setq rechte_Seite 2)
	(setq OberFlansch  3)
	(setq Unterflansch 4)

	(ermittleSeite)


	(if (= (Connect.get CastaData amATSteg)    0) (print "amATSteg == 0"))
	(if (= (Connect.get CastaData amATSteg)    1) (print "amATSteg == 1"))
	(if (= (Connect.get CastaData amATFlansch) 1) (print "amATFlansch == 1"))
	(if (= (Connect.get CastaData amHTFlansch) 1) (print "amHTFlansch == 1"))
	(if (= (Connect.get CastaData amHTSteg)    1) (print "amHTSteg == 1"))

	(setq AT_AnschlFlaeche 0)
	(if (= (Connect.get CastaData amATFlansch) 1) (progn
	    (if (= (Connect.get CastaData amAtOberflansch )  1) (setq AT_AnschlFlaeche OberFlansch))
	    (if (= (Connect.get CastaData amAtUnterflansch ) 1) (setq AT_AnschlFlaeche Unterflansch))
	))

	(setq Anschluss_ausgefuehrt 0)
	(if (= (Connect.get CastaData amATSteg) 1)
	    (if (= (Connect.get CastaData amHTSteg) 1) (progn
		(AlertBox "Diese Anschlussform ist mit diesem Makro (noch) nicht mglich!" "ConnectionType_Not_Possible_Yet")
		(setq Anschluss_ausgefuehrt 1)	; Damit die folgende Meldung nicht erscheint ...
	    ))
	)

	(if (= (Connect.get CastaData amAtFlansch ) 1)
	    (if (= (Connect.get CastaData amHTSteg) 1)
		(Connect_IT)
	    )
	)

	; Meldung, wenn Makro nicht durchlaufen wurde.
	(if (= Anschluss_ausgefuehrt 0) (progn
	    (AlertBox "Hinweis: Anschluss wurde nicht erstellt!"  "NOTE_ConnectionNotCreated")
	))


)
; --------------------------------------------------------

(defun Connect_IT ()

	(print "beginne mit Anschluss - Connect_IT")
	(init-traegerenden)
	(calcLichtenAbst) ; -> lichterAbst
	(print lichterAbst)


	(setq AbstandOK 0)

	(if (> lichterAbst -0.5)
		(progn
			(setq AbstandOK 1)
			(setq CouponBlech_HT  (Blech.create))
			(setq CouponFahne_HT (Blech.create))
			
			(Connect.storeAnschlObjs CastaData CouponBlech_HT CouponFahne_HT)
			(print "CouponBlech_HT-Objekt wurde erzeugt!")
			
			(createFlanschKBlech CouponBlech_HT lichterAbst)

;			(createAndAdd_AT_Blech)

			(setq fllochbild (Lochbild.create))
			(Connect.storeAnschlObjs CastaData fllochbild)
			
			(createLochbild fllochbild lichterAbst)
		
			(Schiebe_HT_Elemente)

;			(Lochbild_HT_Dv_Anpassung)
			
			(if (= (Connect.get CastaData anschlzwAtEnden) 0) (TraegerEndeAnpassen))
			(Lochbild_Anpassen)
			
			(Blech_und_Lochbild_Anpassen)
			
			(Lochbild_AT_Dv_Anpassung)

			(setq Anschluss_ausgefuehrt 1)
			
			(Blech.set CouponBlech_HT (formFkt "cb_CouponBl"))
			(Blech.set CouponFahne_HT (formFkt "cb_CouponFahne"))
			
		)
		(progn
			(AlertBox "Der Abstand ist zu gering, um ein Blech dazwischen zu setzen!"  "GapWidth_Not_Allowed")
		)
	)

	(if (= Anschluss_ausgefuehrt 1) (progn
	    (if (= 1 2) (progn
		(Lochbild.set fllochbild (LB_Art 2)
					 ; (w "50 0")
					 (e "0 25 75 0 0 0")
		)
	    ))
	    (if (= 1 2) (progn
			(setq dxSKopf_aktuell (Lochbild.get fllochbild dxSKopf))
			(setq dlr_Copuon_aktuell (Lochbild.get fllochbild dlr_Coupon))

			(setq Abtl_HT_LB (Traeger.get HTrg  AbTeil fllochbild))
			(setq sr_aktuell (Anbauteil.get Abtl_HT_LB SeitRicht))
	    ))
	
	    (if (= 1 2) (progn
	      (if (= AbstandOK 1) (progn
				(Lochbild.set fllochbild (LB_Art 2)
							 (w "50 0")
							 (e "0 30 70 0 0 0")
				)

				(setq Abtl_HT_LB (Traeger.get HTrg  AbTeil fllochbild))
				(setq Abtl_AT_LB (Traeger.get Tr_ID AbTeil fllochbild))
				
				(Anbauteil.set Abtl_HT_LB (Master 1))
				(Anbauteil.set Abtl_AT_LB (Master 0))
				
				(setq dlr_HT_Lochb (Anbauteil.get Abtl_HT_LB delta_LR))
				(setq dv__HT_Lochb (Anbauteil.get Abtl_HT_LB delta_V))
				
				(print dlr_HT_Lochb)
				(print dv__HT_Lochb)
	      ))
	    ))
	))

)




(defun calcAndSetLochbildDaten (Lchb_ID ABST)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID	(S_Bez 		"M12")
				(Guete   	"4.6")
	)
	
	(setq	t_at 	(Traeger.get Tr_ID t)
		b_at	(Traeger.get Tr_ID b)
		s_at	(Traeger.get Tr_ID s)
		r_at	(Traeger.get Tr_ID r)
		hc_at	(Traeger.get Tr_ID hc)
		h_at	(Traeger.get Tr_ID h)
	)
	
	(setq	t_ht	(Traeger.get Htrg t)
		b_ht	(Traeger.get Htrg b)
		s_ht	(Traeger.get Htrg s)
		r_ht	(Traeger.get Htrg r)
	)
	
	(setq VIER 0)
	
	; vorhandene Anschlusslnge an einer Flanschseite (AT-Ende Anschluss)
	(setq anschl (* 0.5 (- b_ht (+ (* 2 r_ht) s_ht))))
	(print anschl)
	
	; Schraubendurchmesser holen
	(setq dschr (Lochbild.get Lchb_ID sdurchm))
	; Rand- und Lochabstnde
	(setq mine0 (* 2 dschr))
	(setq mine1 (* 4 dschr))
	
	; minimal bentige Anschlusslnge fr zwei Schrauben (M12)
	(setq minAnschl (+ (* 2 mine0) mine1))
	(print minanschl)
	
	(if (= (Connect.get CastaData anschlzwAtEnden) 0) (progn
		(if (<= minAnschl anschl) (setq VIER 1))
	))

	(setq abzug_ht (+ s_ht (* 2 r_ht)))
	(setq rest_ht (- h_ht t_HT t_HT))
	(setq SchrAbstand (- rest_ht (* 4 dschr)))
	(setq SchrAbstand (runde SchrAbstand ab 10))
	(print rest_ht)
	(print SchrAbstand)

;	(setq w0 SchrAbstand)
	(setq w0 (- b_AT (* 4 dSchr)))
	(setq e1 (* 0.5 hc_at))

;	(setq e1rund (runde e1 auf 5))
;	(setq e0 (- (* 0.5 h_at) (* 0.5 e1rund)))

	; Berechnen des e-Maes
	(setq rest_ht (- h_AT t_AT t_AT))
	(setq SchrAbstand (- rest_ht (* 4 dschr)))
	(setq SchrAbstand (runde SchrAbstand ab 10))
	(setq e0 (- (/ SchrAbstand 2)))
	(setq e1 SchrAbstand)

	(print e0)
	(print VIER)
;	(setq VIER 1)
			
;	(setq eAbst (runde (* 2 dschr) auf 5))
			
;	(setq e0 	(- eAbst))
;	(setq e1rund 	(+ h_at eAbst eAbst))
			
	(if (= VIER 0) (progn
		(setq w0 (/ w0 2))
				
		(Lochbild.set Lchb_ID	(e0		e0)
					(e1		e1)
					;(e2		200)
					(w0		w0) 	
					(klemml		(+ s_at  ABST))
		)
	))
	(if (= VIER 1) (progn
		(Lochbild.set Lchb_ID	(e0		e0)
					(e1		e1)
					(w0		w0)
					(w1		0) 	
					(klemml 	(+ s_at  ABST))
		)
	))
	(print "<-----------------------------------------------------------")
)



(defun createLochbild (Lchb_ID ABST)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE LOCHBILD")
	
	(calcAndSetLochbildDaten Lchb_ID ABST)
	
	(setq	delta_lr_at	(Traeger.get Tr_ID delta_lr)
		delta_v_at	(Traeger.get Tr_ID delta_v)
		h_AT		(Traeger.get Tr_ID h)
		t_AT			(Traeger.get Tr_ID t)
	)
	
	(setq	delta_lr_ht	(Traeger.get Htrg delta_lr)
		delta_v_HT	(Traeger.get Htrg delta_v)
		h_HT		(Traeger.get Htrg h)
		b_HT		(Traeger.get Htrg b)
	)
	(setq dp1  (Blech.get CouponBlech_HT dp))
	
	(setq xPos_ht		(Connect.get CastaData xPos_ht))
	(setq xPos_at		(Connect.get CastaData xPos_at))
	
	(print xPos_ht)
	(print xPos_at)

	; ----------------------------------------------------------------------    
    	(setq Delta_SX_CPLochb 0)
	; Anbauteil dem Ht hinzufgen
    	(if (= anHTrgSeite linke_Seite) (progn
			(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _couponlochbild_links_)
			(setq Delta_SX_CPLochb (* -0.5 b_HT))
			(Lochbild.set Lchb_ID (dxSKopf  (+ dp1 t_AT)))
    	))
		(if (= anHTrgSeite rechte_Seite) (progn
			(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _couponlochbild_rechts_)
			(setq Delta_SX_CPLochb (* 0.5 b_HT))
			(Lochbild.set Lchb_ID (dxSKopf  (+ dp1 t_AT)))
    	))

	(Lochbild.set Lchb_ID	(klemml	(+ dp1 t_AT)))

	; Anbauteil dem At hinzufgen
	(if (= AT_AnschlFlaeche OberFlansch) (progn
		(traeger.addabtl Tr_ID Lchb_ID xPos_AT 0.0 _flanschlochbild_of_)
	))
	(if (= AT_AnschlFlaeche Unterflansch) (progn
		(traeger.addabtl Tr_ID Lchb_ID xPos_AT 0.0 _flanschlochbild_uf_)
	))

	(setq HT_ABTeil (Traeger.get Htrg AbTeil Lchb_ID))
	(Anbauteil.set HT_ABTeil 	(Master		1))
	(Anbauteil.set HT_ABTeil 	(delta_SX	Delta_SX_CPLochb))
	(Anbauteil.set HT_ABTeil 	(delta_V	(- (* 0.5 h_HT) delta_v_HT)))


	(setq AT_ABTeil (Traeger.get Tr_ID AbTeil Lchb_ID))
	(Anbauteil.set AT_ABTeil 	(Master		0))
	
	(setq	Abtl_AP		(Traeger.get HTrg ABTeil 	CouponBlech_HT)
				s_HT			(Traeger.get HTrg   s)
	)
	(setq Abst_DX (Anbauteil.get Abtl_AP delta_LR))
	
	; Bei U-Profilen hier noch untersuchen, ob an der linken oder rechten Seite
	; angeschlossen wird
	(setq  Abst_DX (+ Abst_DX (* 0.5  s_HT)))

	
	; Lochbild-Richtung - und Ausrichtung
    (if (= anHTrgSeite linke_Seite) (progn
		(Anbauteil.set  HT_ABTeil (delta_SX (- Abst_DX)))
	    (if (= AT_AnschlFlaeche UnterFlansch) (progn
			(Anbauteil.set HT_ABTeil 	(seitricht -1))
	    ))
	))
    (if (= anHTrgSeite rechte_Seite) (progn
		(Anbauteil.set  HT_ABTeil (delta_SX Abst_DX))
	    (if (= AT_AnschlFlaeche OberFlansch) (progn
			(Anbauteil.set HT_ABTeil 	(seitricht -1))
	    ))
	))

	(if (= (Connect.get CastaData at-von-unten) 1) (progn
		(Anbauteil.set HT_ABTeil 	(Winkel	180.0))
	))

)



(defun calcLichtenAbst ()
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "BERECHNE LICHTEN ABSTAND DER TRGER")
	(setq	delta_v_at 	(Traeger.get Tr_ID delta_v)
		delta_lr_at	(Traeger.get Tr_ID delta_lr)
		h_at		(Traeger.get Tr_ID h)
		b_at		(Traeger.get Tr_ID b)
	)
	
	(setq	delta_v_ht	(Traeger.get Htrg delta_v)
		delta_lr_Ht	(Traeger.get Htrg delta_lr)
		h_ht		(Traeger.get Htrg h)
		b_ht		(Traeger.get Htrg b)
	)
	
	(setq h_at_halb	(* 0.5 h_at))
	(setq b_at_halb	(* 0.5 b_at))

	(setq h_ht_halb	(* 0.5 h_ht))
	(setq b_ht_halb	(* 0.5 b_ht))

	(setq lichterAbst 0.0)

	(if (= (Connect.get CastaData amHtSteg) 1)  (progn
	    (if (= (Connect.get CastaData amAtFlansch) 1)  (progn
	    	(if (= (Connect.get CastaData amAtOberFlansch) 1)  (progn
		    (if (= (Connect.get CastaData vatr-shtr) 1)  (progn
			(setq lichterAbst (- (- (-  b_ht_halb delta_v_at)) delta_lr_ht))
			(setq lichterAbst (- lichterAbst h_at_halb))
		    ))
		    (if (= (Connect.get CastaData vatr-shtr) -1)  (progn
			(setq lichterAbst (+ (- (-  b_ht_halb delta_v_at)) delta_lr_ht))
			(setq lichterAbst (- lichterAbst h_at_halb))
		    ))
		))
	    	(if (= (Connect.get CastaData amAtUnterFlansch) 1)  (progn
		    (if (= (Connect.get CastaData vatr-shtr) -1)  (progn
			(setq lichterAbst (- (- (-  b_ht_halb (- delta_v_at))) delta_lr_ht))
			(setq lichterAbst (- lichterAbst h_at_halb))
		    ))
		    (if (= (Connect.get CastaData vatr-shtr)  1)  (progn
			(setq lichterAbst (+ (- (-  b_ht_halb (- delta_v_at))) delta_lr_ht))
			(setq lichterAbst (- lichterAbst h_at_halb))
		    ))
		))
	    ))

	  ; vorerst ausklammern
	  ; ist aber geprft - 21.01.2015
	  (if (= 1 2) (progn
	    (if (= (Connect.get CastaData amAtSteg) 1)  (progn
		(if (= (Connect.get CastaData vatr-lhtr) -1)  (progn
		    (if (= (Connect.get CastaData satr-shtr)  1)  (progn
			(setq lichterAbst (- (- (+  b_ht_halb delta_lr_at)) (- delta_lr_ht) b_at_halb))
		    ))
		    (if (= (Connect.get CastaData satr-shtr) -1)  (progn
			(setq lichterAbst (+ (- (+  b_ht_halb delta_lr_at)) (- delta_lr_ht) (- b_at_halb)))
		    ))
		))
		(if (= (Connect.get CastaData vatr-lhtr)  1)  (progn
		    (if (= (Connect.get CastaData satr-shtr) -1)  (progn
			(setq lichterAbst (- (- (- (+  (- b_ht_halb) delta_lr_at)) delta_lr_ht (- b_at_halb))))
		    ))
		    (if (= (Connect.get CastaData satr-shtr)  1)  (progn
			(setq lichterAbst (- (+ (- (+  (- b_ht_halb) delta_lr_at)) delta_lr_ht b_at_halb)))
		    ))
		))
	    ))
	    (print lichterAbst)
	  ))

	))
	


	(print lichterAbst)
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)




(defun calcCouponBlech (BLECH_ID ABST)
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "BERECHNE CouponBlech_HTDATEN")
	(setq	b_at		(Traeger.get Tr_ID b)
		h_at		(Traeger.get Tr_ID h)
		dv_AT		(Traeger.get Tr_ID delta_V)
	)
	
	(setq	b_ht		(Traeger.get Htrg b)
		s_ht		(Traeger.get Htrg s)
		t_HT		(Traeger.get Htrg t)
		dv_HT		(Traeger.get Htrg delta_V)
	)
	
	; CouponBlech_HTdicke
	(setq dp_futter ABST)
	
	; Blechabmessung in Richtung Trgerhhe
	(setq bp_Coupon b_AT)
	
	; Hhe Coupon
	(setq hp_Coupon (- h_ht t_HT))
	
	(setq bpDiff 0)
	
;	Profilverschiebungen
;	----------------------------------------
	; ---------------------------------------------
	; Winkelberechnung fr HT und AT
	; Neigung des AT zum HT	
	(setq wnkl_Neigung (Connect.get CastaData afl_vwinkel))
	(if (<  wnkl_Neigung 90.0) 
		(setq kl90 1)
		(setq kl90 0)
	)

	(if (< wnkl_Neigung 90.0) 
		(setq wnkl_Neigung (- 90.0 wnkl_Neigung))	
		(setq wnkl_Neigung (- wnkl_Neigung 90.0))	
	)
	; (if (= (Connect.get CastaData at-von-unten)  1))
	; (if (= (Connect.get CastaData at-von-hinten)  1) (setq wnkl_LB_Neigung (- wnkl_LB_Neigung)))
	(setq sinWnk (sin (/ (* wnkl_Neigung PI) 180.0)))
	(setq cosWnk (cos (/ (* wnkl_Neigung PI) 180.0)))
	(setq tanWnk (tan (/ (* wnkl_Neigung PI) 180.0)))
	(if (> cosWnk 0.1) (setq bpDiff (- (/ b_AT cosWnk) bp_Coupon)))
	
	(print "---------------------------------- *** neu *** Starten ---------")
	(print sinWnk)
	(print cosWnk)
	(print tanWnk)
	(print bpDiff)

	(setq bpDiff (runde bpDiff auf 2))
	(setq bp_Coupon (+ bpDiff bp_Coupon))

	; AT - Delta_V bercksichtigen
	(if (= 1 2) (progn
		(setq cp_Asym 0.0)
		(if (> cosWnk 0.1) (setq cp_Asym (/ dv_AT cosWnk)))
		(if (= (Connect.get CastaData vatr-lhtr ) -1) (setq cp_Asym (- cp_Asym)))

		; Verschiebung lngs aus Vertikalversatz des HT
		(setq dv_Anteil_HT (* tanWnk dv_HT))
		; (if (= (Connect.get CastaData vatr-lhtr ) -1) (setq dv_Anteil_HT (- dv_Anteil_HT)))

		; und in der Gesamtverschiebung bercksichtigen ...	
		; kommt dabei drauf wenn, in welche Richtung der Winkel zeigt.
		(if (= kl90 0) (print "kl90 == 0"))
		(if (= kl90 1) (print "kl90 == 1"))


		(if (= kl90 1) 
			(setq cp_Asym (+ cp_Asym dv_Anteil_HT))
			(setq cp_Asym (+ cp_Asym dv_Anteil_HT))
		)
	))
;	---- abhngig davon wie der AT liegt ---------	
	(setq cp_Asym 0.0)
	
	(Blech.set BLECH_ID	(hp hp_Coupon)
				(bp bp_Coupon)
				(dp dp_futter)
				(dOK (* 0.5 t_HT))
				(xAsym cp_Asym)
	)

	(print "---------------------------------- *** neu *** Enden ---------")
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)

(defun		calc_Fahnenblech (iFlag)


	(setq	abtl_AP	(Traeger.get HTrg ABTeil CouponBlech_HT))
	(setq	Abst_AP  (Anbauteil.get 	abtl_AP  delta_lr))
	(setq	bp_Fahne	Abst_AP)

    (setq t_HT	(Traeger.get HTrg t)
			 r_HT	(Traeger.get HTrg r)
			 h_HT	(Traeger.get HTrg h)
			 dOK  (runde (+ t_HT r_HT) auf 5)
			 
			 hp_Fahne (runde h_HT ab 5)
			 hp_Fahne (- hp_Fahne dOK dOK)
	)
	
	(if (=  iFlag 0) (progn
		(Blech.set 	CouponFahne_HT
				(dOK dOK)
				(dp		12)
				(hp 		hp_Fahne)
				(bp		bp_Fahne)
				(x1 0) (y1 0)
				(x2 0) (y2 0)
		)
	))

	(if (=  iFlag 1) (progn
		(Blech.set 	CouponFahne_HT		(bp		bp_Fahne))
	))
	

)




(defun createFlanschKBlech (BLECH_ID ABST)
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "ERZEUGE CouponBlech_HT")
	(calcCouponBlech BLECH_ID ABST)
	
	(setq xPos_HT	(Connect.get CastaData xPos_HT))
	
    (if (= anHTrgSeite linke_Seite)  (print "anHTrgSeite linke_Seite"))
    (if (= anHTrgSeite rechte_Seite) (print "anHTrgSeite rechte_Seite"))


    (if (= anHTrgSeite linke_Seite)  (Traeger.addabtl HTrg  BLECH_ID xPos_HT 0.0 _blechcoupon_links_  CouponFahne_HT))
    (if (= anHTrgSeite rechte_Seite) (Traeger.addabtl HTrg  BLECH_ID xPos_HT 0.0 _blechcoupon_rechts_ CouponFahne_HT))
    
	(setq	abtl_AP 	(Traeger.get HTrg ABTeil BLECH_ID)
				Abst_AP 	(Anbauteil.get 	abtl_AP  delta_lr)
				dp_AP 		(Blech.get BLECH_ID dp)
				dp_Rest 	(- dp_AP 10)
				dp_AP 		10
				Abst_AP	(+ Abst_AP dp_Rest)
	)
	
	(Blech.set  BLECH_ID (dp dp_AP))
	(Anbauteil.set  abtl_AP (delta_lr  Abst_AP))
	
	(if (<= lichterAbst dp_AP) (progn
	    (setq		h_HT (Traeger.get HTrg h)
						t_HT (Traeger.get HTrg t)
						r_HT (Traeger.get HTrg r)
		)
	    (setq hp_AP  (runde (- h_HT (* 2.0 (+ t_HT r_HT))) ab 10))
		(setq dOK (* 0.5 (- h_HT hp_AP)))
	    (Blech.set  BLECH_ID (hp hp_AP) (dOK dOK))
		
		(setq  Abst_AP (- (+ Abst_AP  lichterAbst)  dp_AP))
	    (Anbauteil.set  abtl_AP (delta_lr  Abst_AP))
	))

	; Jetzt die Fahnengre errechnen
	(calc_Fahnenblech 0)

)	


(defun ermittleSeite ()
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "Seite des Haupttrgers ermitteln")
	; Definitionen dieser "Defines" ganz zu Beginn
	; linke_Seite  1,  rechte_Seite 2
        (setq anHTrgSeite  0) ; erhlt die DEFINES linke_Seite oder rechte_Seite

   ; Ist eigentlich obsolet
   (if (= 2 3) (progn
	(if (= (Connect.get CastaData amHtOberflansch) 1) (progn
	    (if (= (Connect.get CastaData satr-shtr)  1) (setq anHTrgSeite rechte_Seite))
	    (if (= (Connect.get CastaData satr-shtr) -1) (setq anHTrgSeite linke_Seite))
	))
	(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
	    (if (= (Connect.get CastaData satr-shtr)  1) (setq anHTrgSeite rechte_Seite))
	    (if (= (Connect.get CastaData satr-shtr) -1) (setq anHTrgSeite linke_Seite))
	))
   ))

    (if (= (Connect.get CastaData amAtOberflansch) 1) (progn
	(if (= (Connect.get CastaData amHtSteglinks) 1) (progn
	    (if (= (Connect.get CastaData vatr-shtr)  1) (setq anHTrgSeite rechte_Seite))
	    (if (= (Connect.get CastaData vatr-shtr) -1) (setq anHTrgSeite linke_Seite))
	))
	(if (= (Connect.get CastaData amHtStegrechts ) 1) (progn
	    (if (= (Connect.get CastaData vatr-shtr)  1) (setq anHTrgSeite rechte_Seite))
	    (if (= (Connect.get CastaData vatr-shtr) -1) (setq anHTrgSeite linke_Seite))
	))
    ))
    (if (= (Connect.get CastaData amAtUnterflansch) 1) (progn
	(if (= (Connect.get CastaData amHtSteglinks) 1) (progn
	    (if (= (Connect.get CastaData vatr-shtr) -1) (setq anHTrgSeite rechte_Seite))
	    (if (= (Connect.get CastaData vatr-shtr)  1) (setq anHTrgSeite linke_Seite))
	))
	(if (= (Connect.get CastaData amHtStegrechts ) 1) (progn
	    (if (= (Connect.get CastaData vatr-shtr) -1) (setq anHTrgSeite rechte_Seite))
	    (if (= (Connect.get CastaData vatr-shtr)  1) (setq anHTrgSeite linke_Seite))
	))
    ))

	(print anHTrgSeite)
	(if (= anHTrgSeite linke_Seite)  (print "an die linke Seite des HT"))
	(if (= anHTrgSeite rechte_Seite) (print "an die rechte Seite des HT"))
)	

(defun TraegerEndeAnpassen ()

    (print "*clear*")
    (print "------------ Traegerende anpassen")
	(Connect.showAttributes CastaData)
  
    (setq	dv_HT		(Traeger.get HTrg  delta_V))
    (setq	h_HT 		(Traeger.get HTrg  h))
    (setq	dv_AT		(Traeger.get Tr_ID delta_V))
	(setq 	dl_Ende		(+ (* 0.5 h_HT) dv_HT))

	(setq wnkl_Neigung (Connect.get CastaData afl_vwinkel))
	(if (<  wnkl_Neigung 90.0) 
		(setq kl90 1)
		(setq kl90 0)
	)

	(if (< wnkl_Neigung 90.0) 
		(setq wnkl_Neigung (- 90.0 wnkl_Neigung))	
		(setq wnkl_Neigung (- wnkl_Neigung 90.0))	
	)
	(setq sinWnk (sin (/ (* wnkl_Neigung PI)  180.0)))
	(setq cosWnk (cos (/ (* wnkl_Neigung PI)  180.0)))

    (if (= (Connect.get CastaData linkesende)  1) (progn
		(setq TEnde (Traeger.get Tr_ID links))
		(if (= (Connect.get CastaData at-von-unten) 1) (progn
			(if (< wnkl_Neigung 5.0) (progn
				(TrEnde.set TEnde (delta_L (- dl_Ende)))
				; (Lochbild.set fllochbild (LB_Art -2))
			))
			(if (>= wnkl_Neigung 5.0) (progn
				(setq dl_Neu (/ (- dv_HT (* 0.5 h_HT)) cosWnk))
				(TrEnde.set TEnde (delta_L dl_Neu))
			))
		))
		(if (= (Connect.get CastaData at-von-oben) 1) (progn
			(if (< wnkl_Neigung 5.0) (progn
				(setq 	dl_Ende		(-  dv_HT (* 0.5 h_HT)))
				(TrEnde.set TEnde (delta_L  dl_Ende))
				; (Lochbild.set fllochbild (LB_Art 2))
			))
			(if (>= wnkl_Neigung 5.0) (progn
				(setq dl_Neu (/ (+ dv_HT (* 0.5 h_HT)) cosWnk))
				(TrEnde.set TEnde (delta_L (- dl_Neu)))
			))
		))
    ))
    (if (= (Connect.get CastaData rechtesende)  1) (progn
		(setq TEnde (Traeger.get Tr_ID rechts))
		(if (= (Connect.get CastaData at-von-unten) 1) (progn
			(if (< wnkl_Neigung 5.0) (progn
				(setq 	dl_Ende		(-  dv_HT (* 0.5 h_HT)))
				(TrEnde.set TEnde (delta_L dl_Ende))
			))
			(if (>= wnkl_Neigung 5.0) (progn
				(setq dl_Neu (/ (- dv_HT (* 0.5 h_HT)) cosWnk))
				(TrEnde.set TEnde (delta_L (- dl_Neu)))
			))
		))
		(if (= (Connect.get CastaData at-von-oben) 1) (progn
			(if (< wnkl_Neigung 5.0) (progn
				(TrEnde.set TEnde (delta_L (- dl_Ende)))
			))
			(if (>= wnkl_Neigung 5.0) (progn
				(setq dl_Neu (/ (+ dv_HT (* 0.5 h_HT)) cosWnk))
				(TrEnde.set TEnde (delta_L (- dl_Neu)))
			))
		))
    ))
	
)

(defun Lochbild_Anpassen ()
	(if (/= dv_HT 0) (progn
		(setq e0 (Lochbild.get  fllochbild e0))
		(if (= (Connect.get CastaData at-von-unten) 1) (progn
			(Lochbild.set  fllochbild  (e0 (- e0  dv_HT)))
		))
		(if (= (Connect.get CastaData at-von-oben) 1) (progn
			(Lochbild.set  fllochbild  (e0 (+ e0  dv_HT)))
		))
	))
)

(defun	createAndAdd_AT_Blech ()
;    _lasche_of_
;    _lasche_uf_
	(setq bl_AT_Flansch (Blech.create))
	(Connect.storeAnschlObjs CastaData bl_AT_Flansch)
	
	(setq	bp 	(Blech.get CouponBlech_HT bp)
		hp 	(Blech.get CouponBlech_HT hp)
		dp	(Blech.get CouponBlech_HT dp)
		dOK	(Blech.get CouponBlech_HT dOK)
	)
	
	(setq dp_Halb (/ dp 2))
	(setq dp1     (- dp dp_Halb))
	(setq dp2     (- dp dp1))
	
	(Blech.set bl_AT_Flansch (dp dp2) (hp hp) (bp bp) (dOK 0))
	(Blech.set CouponBlech_HT   (dp dp1))
	
	(setq xPos_AT (Connect.get CastaData xPos_AT))
	
	(if (= AT_AnschlFlaeche OberFlansch)  (Traeger.addabtl Tr_ID bl_AT_Flansch xPos_AT 0.0 _lasche_of_))
	(if (= AT_AnschlFlaeche Unterflansch) (Traeger.addabtl Tr_ID bl_AT_Flansch xPos_AT 0.0 _lasche_uf_))
	
	; Blech verschieben, wenn HT Vertikalverschiebung aufweist
	; Wir nehmen dOK - delta_V des Anbauteils wird derzeit nicht verwendet
	(setq dv_HT (Traeger.get HTrg delta_V))
	(if (= (Connect.get CastaData at-von-oben)  1) (progn
	    (Blech.set bl_AT_Flansch (dOK dv_HT))
	))
	(if (= (Connect.get CastaData at-von-unten)  1) (progn
	    (Blech.set bl_AT_Flansch (dOK (- dv_HT)))
	))


)

(defun Schiebe_HT_Elemente ()
    ; dies alles hier ... -----------------------------------------------------------------
    ; vielleicht in eine eigene Funktion auslagern und zusammen mit dem Lochbild  schieben
    (setq dlr_AT (Traeger.get Tr_ID delta_LR))

    (setq Abtl_Lochb_HT (Traeger.get HTrg ABTeil fllochbild))

    (if (= (Connect.get CastaData amAtOberflansch)  1) (progn
	    (if (= (Connect.get CastaData satr-lhtr)  -1) (progn
			(Blech.set CouponBlech_HT (xAsym (- dlr_AT)))
			(Anbauteil.set Abtl_Lochb_HT (delta_LR (- dlr_AT)))
			(Blech.set CouponFahne_HT (xAsym (- dlr_AT)))
	    ))
	    (if (= (Connect.get CastaData satr-lhtr)   1) (progn
			(Blech.set CouponBlech_HT (xAsym dlr_AT))
			(Anbauteil.set Abtl_Lochb_HT (delta_LR dlr_AT))
			(Blech.set CouponFahne_HT (xAsym dlr_AT))
	    ))
     ))
    (if (= (Connect.get CastaData amAtUnterflansch)  1) (progn
	    (if (= (Connect.get CastaData satr-lhtr)  -1) (progn
			(Blech.set CouponBlech_HT (xAsym (- dlr_AT)))
			(Anbauteil.set Abtl_Lochb_HT (delta_LR (- dlr_AT)))
			(Blech.set CouponFahne_HT (xAsym (- dlr_AT)))
	    ))
	    (if (= (Connect.get CastaData satr-lhtr)   1) (progn
			(Blech.set CouponBlech_HT (xAsym dlr_AT))
			(Anbauteil.set Abtl_Lochb_HT (delta_LR dlr_AT))
			(Blech.set CouponFahne_HT (xAsym dlr_AT))
	    ))
     ))
	 
	 
)

(defun Lochbild_HT_Dv_Anpassung ()
    (setq dv_HT (Traeger.get HTrg delta_V))
    (if (/= dv_HT 0) (progn
 	(setq Abtl_HT_LB (Traeger.get HTrg  AbTeil fllochbild))
 	(setq lb_Winkel_HT (Anbauteil.get Abtl_HT_LB Winkel))
 	
 	(setq e0 (Lochbild.get fllochbild e0))
 	(if (= lb_Winkel_HT 180.0) (progn
 	    (setq e0 (- e0 dv_HT))
 	))
 	(if (= lb_Winkel_HT 0.0) (progn
 	    (setq e0 (+ e0 dv_HT))
 	))
 	(Lochbild.set  fllochbild (e0 e0))
    ))
	

)
(defun Lochbild_AT_Dv_Anpassung ()
	; ---- neu - vertikale Verschiebung des AT bercksichtigen
 	(setq Abtl_AT_LB (Traeger.get Tr_ID  AbTeil fllochbild))
 	(setq Abtl_HT_LB (Traeger.get HTrg  AbTeil fllochbild))

	(setq dv_HT (Traeger.get HTrg delta_V))
	
	(setq dvAbtl_AT (Anbauteil.get Abtl_AT_LB delta_V))
	(setq dvAbtl_HT (Anbauteil.get Abtl_HT_LB delta_V))
	
	(if (= (Connect.get CastaData at-von-unten) 1) (Anbauteil.set Abtl_AT_LB (delta_V (- dvAbtl_AT dv_HT))))
	(if (= (Connect.get CastaData at-von-oben)  1) (Anbauteil.set Abtl_AT_LB (delta_V (+ dvAbtl_AT dv_HT))))
	(Anbauteil.set Abtl_HT_LB (delta_V (+ dvAbtl_HT dv_HT)))

	; (Connect.showattributes CastaData)
)

; ------------------- Callbacks fr Bleche
;			(Blech.set CouponBlech_HT (formFkt "cb_CouponBl"))
;			(Blech.set bl_AT_Flansch  (formFkt "cb_LascheAT"))

(defun cb_CouponBl (zp)
	(if (= zp 0) (progn
	    (setq dp_Old (Blech.get CouponBlech_HT dp))
	))
	(if (= zp 1) (progn
	    (setq dp_New (Blech.get CouponBlech_HT dp))
	    (if (/= dp_Old dp_New) (progn
			(setq t_AT (Traeger.get Tr_ID t))
			(Lochbild.set  fllochbild (KlemmL (+   t_AT dp_New)))
			
			(setq abtl_AP (Traeger.get HTrg ABTeil  CouponBlech_HT))
			(setq Abst_AP (Anbauteil.get  abtl_AP  delta_LR))
			(setq dpDiff (- dp_New dp_Old))
			(setq Abst_AP (- Abst_AP  dpDiff))
			(Anbauteil.set abtl_AP (delta_LR  Abst_AP))
			
			(calc_Fahnenblech 1)
			
	    ))
	))
)

(defun cb_CouponFahne (zp)
	(if (= zp 0) (progn
		(setq hp_Alt  (Blech.get CouponFahne_HT hp))
		(setq dOK_Alt (Blech.get CouponFahne_HT dOK))
	))
	(if (= zp 1) (progn
		(setq hp_Neu  (Blech.get CouponFahne_HT hp))
		(setq dOK_Neu (Blech.get CouponFahne_HT dOK))
		(setq t_HT (Traeger.get HTrg t)
		      h_HT (Traeger.get HTrg h)
			  r_HT (Traeger.get HTrg r)
		)
		(if (/= dOK_Neu dOK_Alt) (progn
			(if (< dOK_Neu t_HT) (progn
				(setq dOK_Neu t_HT)
				(Blech.set CouponFahne_HT (dOK dOK_Neu))
			))
			(if (< dOK_Neu (+ t_HT r_HT)) (progn
				(Blech.set CouponFahne_HT (x1 r_HT) (y1 r_HT))
			))
		))
		(if (/= hp_Neu hp_Alt) (progn
			(if (> hp_Neu (- h_HT dOK_Neu t_HT)) (progn
				(setq hp_Neu (- h_HT dOK_Neu t_HT))
				(Blech.set CouponFahne_HT (hp hp_Neu))
			))
			(if (> hp_Neu (- h_HT dOK_Neu t_HT r_HT)) (progn
				(Blech.set CouponFahne_HT (x2 r_HT) (y2 r_HT))
			))
		))
	))

)

(defun Blech_und_Lochbild_Anpassen ()
	(setq	h_HT (Traeger.get HTrg h)
			t_HT (Traeger.get HTrg t)
			b_AT (Traeger.get Tr_ID b)
			s_AT (Traeger.get Tr_ID s)
			r_AT (Traeger.get Tr_ID r)
	)
	(setq 	e0 (Lochbild.get fllochbild e0)
			e1 (Lochbild.get fllochbild e1)
			sd (Lochbild.get fllochbild sDurchm)
	)
	(setq  hp (Blech.get CouponBlech_HT hp))
	
	(print "*clear*")
	(print e0) (print e1)
	(print h_HT) (print t_HT) (print (* 8 sd))
	
	(if (> (- h_HT t_HT t_HT) (* 8 sd)) (progn
			(set dOK (Blech.get CouponBlech_HT dOK))
			(setq e0_Neu (- (* 0.5 hp) dOK))
			(setq e1_Neu (* 2 e0_Neu))
			(setq wNeu (+ s_AT r_AT (* 4 sd)))
			(print e0_Neu) (print e1_Neu)
			(Lochbild.set fllochbild (e0 (- e0_Neu)) (e1 e1_Neu) (w0 wNeu))
		)
		(progn
			(if (< e0 0) (progn
				(if (> (- e0) (* 0.5 h_HT)) (progn
					(setq dOK_Neu (* 2.0 (- (- e0) (* 0.5 h_HT))))
					(setq hp_Neu  (+ h_HT dOK_Neu dOK_Neu))
					(print dOK_Neu)
					(Blech.set CouponBlech_HT (dOK (- dOK_Neu)) (hp hp_Neu))
				))
			))
		)
	)

)
