; $	HT	QT(F)	 	AF(FS)		P(EZ)
; $	AT	QT(FL) 		AF(FS)		P(EZ)
; $	AE	V(-)		H(-)			R(-)

(defun load-modules ()
	(print "Module einladen")
)

(defun init-connection ()
	(print "*clear*")
	(print "Connection erstellen - Gländernanschluss")
;	(AlertBox "Am Makro sind noch Feinarbeiten erforderlich! Lochbild-Vertikalverschiebungen")
	(Connect.showAttributes CastaData)

	(analysiere_Lage) ; liefer kurzer_Schenkel / langer_Schenkel als Variable (0/1)
	(initialisiere_Geometrie)		; Ht_Winkel, S_Verschiebung berechnen

	; Sicherheitshalber sind nur bestimmte Kombinationen
	(if (> AnschlussMoeglich 0) (progn

		(erzeugeFahne)
	
		(erzeugeLochbild)
	
		(AT_TrgEndeAnpassen)

		(if (= 1 2) (progn
			(Blech.set FahnenBlech (x4 40) (y4 15))
			(Lochbild.set Fahnenlochbild (e "0 20 80 0 0 0"))
		))
	
		(if (= 1 2) (progn
			(setq Abtl_LB_AT (Traeger.get Tr_ID ABTeil Fahnenlochbild))
			(setq Abtl_LB_HT (Traeger.get HTrg  ABTeil Fahnenlochbild))
			(setq dv_Abtl_Lb_AT (Anbauteil.get Abtl_LB_AT delta_V))
			(setq dv_Abtl_Lb_HT (Anbauteil.get Abtl_LB_HT delta_V))
			(AlertBox dv_Abtl_Lb_HT) (AlertBox dv_Abtl_Lb_AT)
		))
		
		(if (= 1 2) (progn
			(setq curr_dOK (Blech.get FahnenBlech dOK))
			(AlertBox curr_dOK)
		))
	))

)	
; ---------------------------------------

(defun cb_Fahnenblech (zp)
	(if (= zp 0) (progn
		(setq dpAlt (Blech.get Fahnenblech dp))
	))
	(if (= zp 1) (progn
		(setq dpNeu (Blech.get Fahnenblech dp))
		(if (/= dpAlt dpNeu) (progn
			(analysiere_Lage)
			(initialisiere_Geometrie)
			(FahnenPosition_seitlich)
			(SchraubenPosLnge)
		))
	))

)
(defun analysiere_Lage ()

   (setq AnschlussMoeglich 1)				; Anschluss erstmal für alle erlauben
   ; Kontaktflächen - langer-Schenkel des AT an der Fläche des HT
   ; oder kurzer Schenkel des AT  an der Fläche des HT
   (setq  kurzer_Schenkel 0  langer_Schenkel 0)
   (if (=  (Connect.get CastaData satr-vhtr)   1) (setq  langer_Schenkel 1))
   (if (=  (Connect.get CastaData satr-vhtr)  -1) (setq  langer_Schenkel 1))
   (if (=  (Connect.get CastaData vatr-vhtr)   1) (setq  kurzer_Schenkel 1))
   (if (=  (Connect.get CastaData vatr-vhtr)  -1) (setq  kurzer_Schenkel 1))

   ; Wenn langer_Schenkel = 1, dann bedeutet das, dass der lange Schenkel anliegt.
   ; Der lange Schenkel ist gleichbedeutend mit dem Steg eines I/U-Profils
   ; oder der Kante eines Flachstahls
   ; Flachstahl geht flächig somit nur bei kurzem Schenkel, weil der Flachstahl durch einen
   ; Flansch repräsentiert wird. Mit Fahne geht es nur bei langem Schenkel
	(print langer_Schenkel) (print kurzer_Schenkel)

   (if (=  (Connect.get CastaData at-von-oben)  1) (progn
		(print "Branch -1-   (at-von-oben)")	; ist derzeit nicht als Anschluss erlaubt
		(setq AnschlussMoeglich 0)				; nicht erlauben
   ))
   (if (=  (Connect.get CastaData at-von-unten)  1) (progn
		(print "Branch -2-   (at-von-unten)")
		(setq AnschlussMoeglich 1)				; nur bei AT von unten ist derzeit der Anschluss möglich
   ))

   ; rechts vorbei oder links vorbei
	(setq qsForm_HT (Traeger.get HTrg qsForm))
	(setq b_HT  (Traeger.get HTrg t))
	(setq h_HT  (Traeger.get HTrg h))
	(setq t_HT  (Traeger.get HTrg t))
	(setq dv_HT (Traeger.get HTrg delta_LR))
	
	(print h_HT) (print t_HT)
	
	; Wird hier für verschiedene Querschnitte bestimmt, obwohl nur Flachstahl 
	; im Makro erlaubt ist. Aber vielleicht wird es ja mal upgegraded
	(setq h_HT_eff 0.0)
	(if (= qsForm_HT "I") (setq h_HT_eff (* 0.5 h_HT)))
	(if (= qsForm_HT "K") (setq h_HT_eff (* 0.5 h_HT)))
	(if (= qsForm_HT "U") (setq h_HT_eff (* 0.5 h_HT)))
	(if (= qsForm_HT "F") (setq h_HT_eff (* 0.5 t_HT)))
	
	(setq amHT_oben_vorbei 0  amHT_unten_vorbei 0)
	(setq spaltBreite 0.0)
	(if (= langer_Schenkel 1) (progn
		(setq dlr_AT (Traeger.get Tr_ID delta_LR))
		(if (=  (Connect.get CastaData satr-vhtr)  -1) (progn
			(setq spaltBreite (- dlr_AT h_HT_eff dv_HT))
			(print "Spaltbreite bei satr-vhtr =  -1") (print spaltBreite)
			(if (> spaltBreite 0.0) (setq amHT_oben_vorbei 1))
			(if (< spaltBreite 0.0) (setq amHT_unten_vorbei 1))
		))
		(if (=  (Connect.get CastaData satr-vhtr)   1) (progn
			(setq spaltBreite (- dlr_AT h_HT_eff (- dv_HT)))
			(print "Spaltbreite bei satr-vhtr =   1") (print spaltBreite)
			(if (> spaltBreite 0.0) (setq amHT_unten_vorbei 1))
			(if (< spaltBreite 0.0) (setq amHT_oben_vorbei 1))
		))
	))
		
	(if (= kurzer_Schenkel 1) (progn
		(setq dv_AT (Traeger.get Tr_ID delta_V))
		(if (=  (Connect.get CastaData vatr-vhtr) -1) (progn
			(setq spaltBreite (- (- dv_AT) h_HT_eff dv_HT))
			(if (> spaltBreite 0.0) (setq amHT_oben_vorbei 1))
		))
		(if (=  (Connect.get CastaData vatr-vhtr) 1) (progn
			(setq spaltBreite (- (- dv_AT) h_HT_eff (- dv_HT)))
			(if (> spaltBreite 0.0) (setq amHT_unten_vorbei 1))
		))
	))

	(if (= kurzer_Schenkel 1) (progn
		(if (= amHT_unten_vorbei  1) (print "Kurzer Schenkel am HT links vorbei"))
		(if (= amHT_oben_vorbei 1) (print "Kurzer Schenkel am HT rechts vorbei"))
	))
	(if (= langer_Schenkel 1) (progn
		(if (= amHT_unten_vorbei  1) (print "Langer Schenkel am HT links vorbei"))
		(if (= amHT_oben_vorbei 1) (print "Langer Schenkel am HT rechts vorbei"))
	))
	(print spaltBreite)
	
	(if (= qsForm_HT "U") (progn
		(if (= kurzer_Schenkel 0) (if (= langer_Schenkel 0) (setq AnschlussMoeglich 0)))
		; (if (= amHT_unten_vorbei 1) (setq AnschlussMoeglich 0))
	))
   
)
(defun initialisiere_Geometrie ()
	(setq Ht_Winkel 0.0)
	(setq S_Verschiebung 0.0)
	(setq SchenkelBreite_anlieg 0.0)
	(setq WinkelSwitch 0)
	
	(if (=  langer_Schenkel 1) (progn
			(print "langer Schenkel")
			(setq Ht_Winkel (Connect.get CastaData  v-atrgewnkl_steg))
			(setq S_Verschiebung (Traeger.get Tr_ID delta_V))
			(print S_Verschiebung)
			(setq  SchenkelBreite_anlieg (Traeger.get Tr_ID h))
			
			(if (= (Connect.get CastaData sAtr-vHtr) -1) (setq Ht_Winkel (- 180.0 Ht_Winkel)))
			(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq Ht_Winkel (- Ht_Winkel 180.0)))
			
			(if (< Ht_Winkel 0.0) (setq WinkelSwitch 1))
			(if (< Ht_Winkel 0.0) (setq Ht_Winkel (+ Ht_Winkel 180.0)))
	))

	(if (=  kurzer_Schenkel  1) (progn
			(print "kurzer Schenkel")
			(setq Ht_Winkel (Connect.get CastaData  h-atrgewnkl_steg))
			(setq S_Verschiebung (Traeger.get Tr_ID delta_LR))
			(print S_Verschiebung)
			(setq  SchenkelBreite_anlieg (Traeger.get Tr_ID b))

			(if (= (Connect.get CastaData sAtr-lHtr)  1) (setq Ht_Winkel (- 180.0 Ht_Winkel)))
			(if (= (Connect.get CastaData sAtr-lHtr) -1) (setq Ht_Winkel (- Ht_Winkel 180.0)))

			; (if (< Ht_Winkel 0.0) (Alertbox "Ht_Winkel ist kleiner 0 - wird umgeswitcht"))
			(if (< Ht_Winkel 0.0) (setq WinkelSwitch 1))
			(if (< Ht_Winkel 0.0) (setq Ht_Winkel (+ Ht_Winkel 180.0)))

	))
	(setq  S_Verschiebung (* 1.0 S_Verschiebung))

	(setq sinV (sin (* PI (/ Ht_Winkel 180.0))))
	(setq cosV (cos (* PI (/ Ht_Winkel 180.0))))
	(setq tanV (tan (* PI (/ Ht_Winkel 180.0))))

	; Bestimmte Winkel führen zu Nulldivision - diese hier abfangen
	(if (= sinV 0.0) (setq AnschlussMoeglich 0))
	(if (= tanV 0.0) (setq AnschlussMoeglich 0))
	
    (print "Eingangswerte --------------------------- ")
	(print  S_Verschiebung)
	(print  SchenkelBreite_anlieg)

	; Bei U-Profilen muss die Ablängung und Schraubenlage korrigiert werden
	(setq HT_QsTyp (Traeger.get HTrg qsForm))
	
	; Systemlinienabstand - eigentlich Abstand zwischen den Mittellinien bze. Kantenlinien bei U-/L-Profilen
	(setq	dlr_AT (Traeger.get Tr_ID delta_LR)
			dv_AT (Traeger.get Tr_ID delta_V)
	)
	(setq	dlr_HT (Traeger.get HTrg delta_LR)
			dv_HT (Traeger.get HTrg delta_V)
	)
	
	(setq Dist_SysLines 0.0)
	; (if (=  (Connect.get CastaData vatr-shtr) -1) (setq Dist_SysLines (- (+ dv_AT  dlr_HT)))) ; --OK--
	; (if (=  (Connect.get CastaData vatr-shtr)  1) (setq Dist_SysLines (- (- dv_AT  dlr_HT)))) ; --OK--
	; (if (=  (Connect.get CastaData satr-shtr) -1) (setq Dist_SysLines    (+ dlr_AT dlr_HT)))  ; --OK--
	; (if (=  (Connect.get CastaData satr-shtr)  1) (setq Dist_SysLines    (- dlr_AT dlr_HT)))  ; --OK--
	(if (= langer_Schenkel 1) (progn
		(if (=  (Connect.get CastaData satr-vhtr) -1) (setq Dist_SysLines (+ dlr_AT  dv_HT))) ;	--OK--
		(if (=  (Connect.get CastaData satr-vhtr)  1) (setq Dist_SysLines (- dlr_AT  dv_HT))) ;	--OK--

		(if (=  (Connect.get CastaData satr-vhtr) -1) (print "satr-vhtr -1 --OK--")) ;
		(if (=  (Connect.get CastaData satr-vhtr)  1) (print "satr-vhtr  1 --OK--")) ;
	))
	(if (= kurzer_Schenkel 1) (progn
		(if (=  (Connect.get CastaData vatr-shtr) -1) (setq Dist_SysLines    (+ dv_AT dv_HT)))    ;
		(if (=  (Connect.get CastaData vatr-shtr)  1) (setq Dist_SysLines    (- dv_AT dv_HT)))    ;

		(if (=  (Connect.get CastaData vatr-shtr) -1) (print "vatr-shtr -1 not testet yet")) ;
		(if (=  (Connect.get CastaData vatr-shtr)  1) (print "vatr-shtr  1 not testet yet")) ;
	))
	
	(setq Dist_Offset 1)
	(if (< Dist_SysLines 0.0) (setq Dist_SysLines (- Dist_SysLines) Dist_Offset -1))
	(print Dist_SysLines)
	
	(setq LaufRichtung 0)
	(setq VWnkl_Flansch (Connect.get CastaData v-atrgewnkl_flansch))
	(setq HWnkl_Flansch (Connect.get CastaData h-atrgewnkl_flansch))
	(if (> VWnkl_Flansch 90.0) (setq LaufRichtung  1))
	(if (< VWnkl_Flansch 90.0) (setq LaufRichtung -1))
	(if (> HWnkl_Flansch 90.0) (setq LaufRichtung  2))
	(if (< HWnkl_Flansch 90.0) (setq LaufRichtung -2))
	
)
(defun erzeugeFahne ()
	(setq Fahnenblech (Blech.create))
	(Blech.set Fahnenblech 	(hp 150) (bp 100) (dp 10))
	(Connect.storeAnschlObjs CastaData Fahnenblech)
	
	(setq xPos_HT (Connect.get CastaData xPos_HT))
	
	(setq abtl_fahne_winkel Ht_Winkel)
	
	(if (= (Connect.get CastaData at-von-links ) 1) (print  "at-von-links"))
	(if (= (Connect.get CastaData at-von-rechts ) 1) (print "at-von-rechts"))
	
	(if (= kurzer_Schenkel 1) (progn
		(if (= (Connect.get CastaData at-von-links ) 1)  (setq abtl_fahne_winkel (- Ht_Winkel)))
	))
	
	(if (= (Connect.get CastaData amhtoberflansch ) 1) (traeger.addabtl hTrg Fahnenblech xPos_HT abtl_fahne_winkel _fahnenblech_of_))
	(if (= (Connect.get CastaData amhtunterflansch ) 1) (traeger.addabtl hTrg Fahnenblech xPos_HT abtl_fahne_winkel _fahnenblech_uf_))

	; Eingangswerte ermitteln
	(calc_netto_Distance)	; berechnet delta_LR_LB


	(FahnenAbmessungen)
	
	; seitliche Position der Fahne bestimmen
	(FahnenPosition_seitlich)
	
	(FahnenPosition_vertikal)
	
;	(Connect.showAttributes CastaData)
	
)

; Fahnengröße festlegen
(defun FahnenAbmessungen ()	
	(setq dp_Fahne 10)

	(setq qsForm_AT (Traeger.get TR_ID qsForm)
		  h_HT		(Traeger.get HTrg h)
		  t_HT		(Traeger.get HTrg t)
		  r_HT		(Traeger.get HTrg r)
	)
	(setq hp_Bl 150)
;	(setq hp_Bl (- h_HT t_HT t_HT r_HT r_HT))
	
	(setq bEff_Wnkl 0.0)
	(setq Fahnenbreite 0.0)
	
	(if (= qsForm_AT "L") (progn
		(if (= langer_Schenkel 1) (setq bEff_Wnkl (Traeger.get Tr_ID b)))
		(if (= kurzer_Schenkel 1) (setq bEff_Wnkl (Traeger.get Tr_ID h)))
		(setq Fahnenbreite (+ delta_LR_LB bEff_Wnkl))
	))

	(if (= qsForm_AT "F") (progn
		(setq b_AT (Traeger.get Tr_ID b))
		(setq Fahnenbreite (+ Dist_SysLines (- (* 0.5 b_AT) (* 0.5 t_HT))))
	))
	(Blech.set Fahnenblech 	
							(dp dp_Fahne)
						    (hp hp_Bl)
							(bp Fahnenbreite)
	)
)

; lokale Position der Fahne am Flachstahl berechnen
(defun FahnenPosition_seitlich ()
	(setq dp_Fahne (Blech.get Fahnenblech dp))
	
	(setq	dlr_AT	(Traeger.get Tr_ID delta_LR)
			dV_AT	(Traeger.get Tr_ID delta_V)
			t_AT	(Traeger.get Tr_ID t)
	)

	; Versatz des HT
	(setq dLR_HT (Traeger.get HTrg delta_LR))
	(setq hori_Versch (* cosV dLR_HT))

	; hier könnte man vorsehen, die Fahne auf die andere Seite zu schieben.
	(setq qsForm_AT (Traeger.get Tr_ID qsForm))
	(setq bl_Seitlich (* 0.5 (+ dp_Fahne t_AT)))

	(if (= kurzer_Schenkel 1) (progn
		(if (= qsForm_AT "L") (progn
			(if (= (Connect.get CastaData satr-lhtr)  1) (setq bl_Seitlich (*  0.5 dp_Fahne)))
			(if (= (Connect.get CastaData satr-lhtr) -1) (setq bl_Seitlich (* -0.5 dp_Fahne)))
		))
		(if (= (Connect.get CastaData satr-lhtr)  1) (progn
			(setq bl_Seitlich (+ bl_Seitlich dlr_AT))		; OK
		))

		(if (= (Connect.get CastaData satr-lhtr) -1) (progn
			(setq bl_Seitlich (- bl_Seitlich dlr_AT))		; OK
		))
	))
		
	(if (= langer_Schenkel 1) (progn
		(if (= qsForm_AT "L") (progn
			(if (= (Connect.get CastaData vatr-lhtr)  1) (setq bl_Seitlich (*  0.5 dp_Fahne)))
			(if (= (Connect.get CastaData vatr-lhtr) -1) (setq bl_Seitlich (* -0.5 dp_Fahne)))
		))

		; mit dieser Zeile wäre sie auf der anderen Seite
		; (setq bl_Seitlich (- bl_Seitlich))
		
		(if (= (Connect.get CastaData vatr-lhtr)  1) (progn
			(setq bl_Seitlich (+ bl_Seitlich dv_AT))		; OK
	;		(setq bl_Seitlich (- bl_Seitlich hori_Versch)) ; OK
		))

		(if (= (Connect.get CastaData vatr-lhtr) -1) (progn
			(setq bl_Seitlich (- bl_Seitlich dv_AT))		; OK
	;		(setq bl_Seitlich (+ bl_Seitlich hori_Versch)) ; OK
		))

		(if (= (Connect.get CastaData vatr-lhtr)  1) (progn
			(if (= (Connect.get CastaData satr-vhtr)  1) (setq bl_Seitlich (- bl_Seitlich hori_Versch))) ; OK
			(if (= (Connect.get CastaData satr-vhtr) -1) (setq bl_Seitlich (- bl_Seitlich hori_Versch))) ; OK
		))
		(if (= (Connect.get CastaData vatr-lhtr) -1) (progn
			(if (= (Connect.get CastaData satr-vhtr)  1) (setq bl_Seitlich (- bl_Seitlich hori_Versch))) ; OK
			(if (= (Connect.get CastaData satr-vhtr) -1) (setq bl_Seitlich (- bl_Seitlich hori_Versch))) ; OK
		))
	))

	(if (= kurzer_Schenkel 1) (progn
		(if (= qsForm_AT "L") (progn
			(if (= (Connect.get CastaData at-von-rechts) 1) (progn
				(if (= (Connect.get CastaData satr-lhtr) -1) (setq bl_Seitlich (*  0.5 dp_Fahne)))
				(if (= (Connect.get CastaData satr-lhtr)  1) (setq bl_Seitlich (* -0.5 dp_Fahne)))
			))
			(if (= (Connect.get CastaData at-von-links) 1) (progn
				(if (= (Connect.get CastaData satr-lhtr) -1) (setq bl_Seitlich (* -0.5 dp_Fahne)))
				(if (= (Connect.get CastaData satr-lhtr)  1) (setq bl_Seitlich (*  0.5 dp_Fahne)))
			))
		))
		
		(setq bl_Seitlich (- bl_Seitlich hori_Versch))

		(if (= (Connect.get CastaData at-von-rechts) 1) (progn
			(if (= (Connect.get CastaData satr-lhtr)  1) (setq bl_Seitlich (+ bl_Seitlich dlr_AT)))		; OK
			(if (= (Connect.get CastaData satr-lhtr) -1) (setq bl_Seitlich (- bl_Seitlich dlr_AT)))		; OK
		))
		(if (= (Connect.get CastaData at-von-links) 1) (progn
			(if (= (Connect.get CastaData satr-lhtr)  1) (setq bl_Seitlich (- bl_Seitlich dlr_AT)))		; OK
			(if (= (Connect.get CastaData satr-lhtr) -1) (setq bl_Seitlich (+ bl_Seitlich dlr_AT)))		; OK
		))

		
	))
	(Blech.set Fahnenblech (xAsym bl_Seitlich))

)

(defun FahnenPosition_vertikal ()
	; dOK ermitteln ---------------
	(setq dOK_FBl 0.0)
	
	(setq 	b_HT 		(Traeger.get HTrg b))
	(setq	dp_hp 	(Blech.get Fahnenblech dp)
			t_AT	(Traeger.get Tr_ID t)
			dv_AT	(Traeger.get Tr_ID delta_V)
			dv_Seit_eff (/ (* 0.5 (+ (* 1.0 t_AT) (* 1.0 dp_hp))) tanV)
			dv_AT_eff (/ (* 1.0 dv_AT) tanV)
	)

	(print WinkelSwitch)
	(print HT_Winkel)
	(if (= amHT_oben_vorbei 1) 					 	(print "--> oben vorbei"))
	(if (= amHT_unten_vorbei 1) 				 	(print "--> unten vorbei"))
	(if (= (Connect.get CastaData at-von-links) 1)	(print "--> at von links"))
	(if (= (Connect.get CastaData at-von-rechts) 1)	(print "--> at von rechts"))
	(if (= (Connect.get CastaData vAtr-lHtr)  1) 	(print "--> vAtr-lHtr ...  1"))
	(if (= (Connect.get CastaData vAtr-lHtr) -1) 	(print "--> vAtr-lHtr ... -1"))
	(if (= (Connect.get CastaData sAtr-vHtr)  1) 	(print "--> sAtr-vHtr ...  1"))
	(if (= (Connect.get CastaData sAtr-vHtr) -1) 	(print "--> sAtr-vHtr ... -1"))

	; Ab hier jetzt die Berechnung der Verschiebung in vertikaler Richtung

	; Einfluss der seitlichen Blechverschiebung relativ zur Fahne
	(setq dOK_FBl (- dv_Seit_eff))
	
	; Einfluss der vertikalen Verschiebung des AT
	(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq dOK_FBl (- dOK_FBl dv_AT_eff)))
	(if (= (Connect.get CastaData vAtr-lHtr) -1) (setq dOK_FBl (+ dOK_FBl dv_AT_eff)))
	
	; Blechgröße anpassen an Breite des Flachstahls
	(setq hp_Bl   (/ b_HT sinV))
	(if (> hp_Bl 160) (setq hp_Bl 160))

	(setq b_Seitlich	(Blech.get Fahnenblech xAsym))
	(setq dv_b_Seitl  (/ b_Seitlich tanV))

	; Einfluss der seitlichen Verschiebung des HT
	(if (= (Connect.get CastaData at-von-links) 1) (progn
		(setq dOK_FBl (+ 0.0 (- dv_b_Seitl) (* 0.5 (- (/ b_HT sinV) hp_Bl))))
	))
	(if (= (Connect.get CastaData at-von-rechts) 1) (progn
		(setq dOK_FBl (- 0.0 dv_b_Seitl (* 0.5 (- (/ b_HT sinV) hp_Bl))))
	))
	
	(Blech.set Fahnenblech 
							(dOK dOK_FBl)
						    (hp hp_Bl)
	)
	(Blech.set Fahnenblech (FormFkt "cb_Fahnenblech"))


)	

(defun calc_netto_Distance ()
	(setq delta_LR_LB Dist_SysLines)
	(setq qsForm_HT (Traeger.get HTrg qsForm)
		  h_HT		(Traeger.get HTrg h)
		  b_HT		(Traeger.get HTrg b)
		  s_HT		(Traeger.get HTrg s)
		  t_HT		(Traeger.get HTrg t)
	)
	; für alle Profile bis auf L und Fl gilt:
	(setq delta_LR_LB (- Dist_SysLines (* 0.5 h_HT)))
	; Hier sind derzeit nur Fl-Profile vorgesehen
	(if (= qsForm_HT "F") (setq delta_LR_LB (- Dist_SysLines (* 0.5 t_HT))))

)
(defun AT_TrgEndeAnpassen ()

	(setq	hp			(Blech.get Fahnenblech hp)
			dOK			(Blech.get Fahnenblech dOK)
	)
	(setq	h_Vorh		hp)
	(setq 	b_HT		(Traeger.get HTrg b)
			dlr_HT		(Traeger.get HTrg delta_LR)
	)
	(setq	hp_Bl 		(Blech.get FahnenBlech hp)
			b_HT		(Traeger.get HTrg b)
			b_HT_eff	(/ b_HT sinV)
	)

	(setq	diff_V 0.0)
	(setq	dl_AT 0.0)
	(setq	hp_eff (* 1.0 hp))
	
	(setq abtl_Fahne (Traeger.get HTrg ABTeil Fahnenblech))
	(setq wnkl_Fahne (Anbauteil.get abtl_Fahne Winkel))

	(setq sin_Faktor (/ 1.0 sinV))
	
	(if (= (Connect.get CastaData at-von-links) 1) (progn
		(print "Traegerende verlaengern - AT von links")

		(setq diff_V (/ (* 1.0 dlr_HT) sin_Faktor))

		(if (= (Connect.get CastaData linkesEnde)   1) (progn
			(if (= (Connect.get CastaData sAtr-vHtr)  1) (progn
				(if (= (Connect.get CastaData vAtr-lHtr) -1) (setq dl_AT (+ diff_V (+ (*  0.5 hp_eff) dOK))))
				(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq dl_AT (+ diff_V (+ (* -0.5 hp_eff) dOK))))
			))
			(if (= (Connect.get CastaData sAtr-vHtr) -1) (progn
				(if (= (Connect.get CastaData vAtr-lHtr) -1) (setq dl_AT (+ diff_V (+ (* -0.5 hp_eff) dOK))))
				(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq dl_AT (+ diff_V (+ (* -0.5 hp_eff) dOK))))
			))
		))
		(if (= (Connect.get CastaData rechtesEnde)   1) (progn
			(if (= (Connect.get CastaData sAtr-vHtr)  1) (progn
				(if (= (Connect.get CastaData vAtr-lHtr) -1) (setq dl_AT (+ diff_V (+ (*  0.5 hp_eff) dOK))))
				(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq dl_AT (+ (- diff_V) (+ (* -0.5 hp_eff) (- dOK)))))
			))
			(if (= (Connect.get CastaData sAtr-vHtr) -1) (progn
				(if (= (Connect.get CastaData vAtr-lHtr) -1) (setq dl_AT (+ (- diff_V) (+ (* -0.5 hp_eff) (- dOK)))))
				(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq dl_AT (+ diff_V (+ (* -0.5 hp_eff) dOK))))
			))
		))
	))
	(if (= (Connect.get CastaData at-von-rechts) 1) (progn
		(print "Traegerende verlaengern - AT von rechts")

		(setq diff_V (/ (* -1.0 dlr_HT) sin_Faktor))
		
		(if (= (Connect.get CastaData linkesEnde)   1) (progn
			(if (= (Connect.get CastaData sAtr-vHtr)  1) (progn
				(if (= (Connect.get CastaData vAtr-lHtr) -1) (setq dl_AT (+ diff_V (+ (* -0.5 hp_eff) (- dOK)))))
				(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq dl_AT (+ diff_V (+ (*  0.5 hp_eff)    dOK))))
			))
			(if (= (Connect.get CastaData sAtr-vHtr) -1) (progn
				(if (= (Connect.get CastaData vAtr-lHtr) -1) (setq dl_AT (+ diff_V (+ (*  0.5 hp_eff) (- dOK)))))
				(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq dl_AT (+ diff_V (+ (* -0.5 hp_eff) (- dOK)))))
			))
		))
		(if (= (Connect.get CastaData rechtesEnde)   1) (progn
			(if (= (Connect.get CastaData sAtr-vHtr)  1) (progn
				(if (= (Connect.get CastaData vAtr-lHtr) -1) (setq dl_AT (+ (- diff_V) (+ (* -0.5 hp_eff) dOK))))
				(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq dl_AT (+ diff_V (+ (*  0.5 hp_eff)    dOK))))
			))
			(if (= (Connect.get CastaData sAtr-vHtr) -1) (progn
				(if (= (Connect.get CastaData vAtr-lHtr) -1) (setq dl_AT (+ diff_V (+ (*  0.5 hp_eff) (- dOK)))))
				(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq dl_AT (+ (- diff_V) (+ (* -0.5 hp_eff) dOK))))
			))
		))
	))
	
	(if (= (Connect.get CastaData linkesEnde)  1) (progn
		(print "linkes Ende anpassen")
		(setq tEnde (Traeger.get Tr_ID links))
		(TrEnde.set tEnde (delta_L dl_AT))
	))
	(if (= (Connect.get CastaData rechtesEnde)  1) (progn
		(print "rechtes Ende anpassen")
		(setq tEnde (Traeger.get Tr_ID rechts))
		(TrEnde.set tEnde (delta_L dl_AT))
	))

)
(defun SchraubenPosLnge ()

	(setq	dp_Fahne 	(Blech.get Fahnenblech dp)
			bl_SeiteV	(Blech.get Fahnenblech xAsym)
	)
	(setq t_AT		(Traeger.get Tr_ID t))

	(setq dxs_Kopf  (* 0.5 dp_Fahne))

	
	(setq abtl_Lb_HT (Traeger.get HTrg ABTeil Fahnenlochbild))
	(setq delta_SX_LB (Anbauteil.get abtl_Lb_HT delta_SX))

	(Lochbild.set	Fahnenlochbild	
				(dxSKopf dxs_Kopf)
				(KlemmL	(+ dp_Fahne t_AT))
	)
	(Anbauteil.set abtl_Lb_HT (delta_SX bl_SeiteV))

	(setq	SRichtungAendern 0)
	(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq	SRichtungAendern 1))
	(if (= (Connect.get CastaData sAtr-lHtr) -1) (setq	SRichtungAendern 1))
	(if (= SRichtungAendern 1) (progn
		(Lochbild.set	Fahnenlochbild 
				(Schr_Richt 	-1)
				(dxSKopf 		(- dxs_Kopf))
		)
	))
	
	
)
(defun Lochbild_Vertikal_Ausrichten ()

	(setq b_HT (Traeger.get HTrg b))
	(setq b_HT_eff (/ (* 0.5 b_HT) sinV))
	(if (= (Connect.get CastaData at-von-links)  1) (setq b_HT_eff (- b_HT_eff)))

	(setq b_Seitlich	(Blech.get Fahnenblech xAsym))
	(setq dv_b_Seitl  (/ b_Seitlich tanV))

	(setq abtl_FLochbild_HT (Traeger.get HTrg ABTeil Fahnenlochbild))
	(setq abtl_FLochbild_AT (Traeger.get Tr_ID ABTeil Fahnenlochbild))
	
	(setq dv_Lchb_AT (Anbauteil.get abtl_FLochbild_AT delta_V))
	(setq dv_Lchb_HT (Anbauteil.get abtl_FLochbild_HT delta_V))

	(setq dv_Lchb_AT_Neu (- dv_Lchb_AT dv_b_Seitl b_HT_eff))
	(setq dv_Lchb_HT_Neu (- dv_Lchb_HT dv_b_Seitl b_HT_eff))

	(if (= (Connect.get CastaData at-von-links) 1) (progn
		(setq dv_Lchb_AT_Neu (+ dv_Lchb_AT_Neu  b_HT_eff b_HT_eff))
		(setq dv_Lchb_HT_Neu (+ dv_Lchb_HT_Neu  b_HT_eff b_HT_eff))
	))
	
	(Anbauteil.set abtl_FLochbild_AT (delta_V dv_Lchb_AT_Neu))
	(Anbauteil.set abtl_FLochbild_HT (delta_V dv_Lchb_HT_Neu))
	
)
(defun Lochbild_Seitlich_Ausrichten ()

	(setq abtl_FLochbild_HT (Traeger.get HTrg ABTeil Fahnenlochbild))
	(setq abtl_FLochbild_AT (Traeger.get Tr_ID ABTeil Fahnenlochbild))

	(setq SRicht_HT (Anbauteil.get abtl_FLochbild_HT Seitricht))
	(setq SRicht_AT (Anbauteil.get abtl_FLochbild_AT Seitricht))
	
	(setq qsForm_AT (Traeger.get Tr_ID qsForm))
	(if (= qsForm_AT "F") (progn
		(if (= (Connect.get CastaData vAtr-lHtr) 1) (progn
			(if (= (Connect.get CastaData sAtr-vHtr) -1) (progn
				(if (= (Connect.get CastaData at-von-rechts)  1) (progn
					(if (= (Connect.get CastaData amhtoberflansch ) 1) 
						(Anbauteil.set abtl_FLochbild_AT (SeitRicht -1))
					)
				))
			))
			(if (= (Connect.get CastaData sAtr-vHtr) 1) (progn
				(if (= (Connect.get CastaData at-von-links)  1) (progn
					(if (= (Connect.get CastaData amhtunterflansch ) 1)
						(Anbauteil.set abtl_FLochbild_AT (SeitRicht -1))
					)
				))
			))
		))
	))
	
	(print "------------------------------------------------------------------------- Lage-Check - starten")
	(if (= (Connect.get CastaData sAtr-vHtr) -1) (print "sAtr-vHtr = -1"))
	(if (= (Connect.get CastaData sAtr-vHtr)  1) (print "sAtr-vHtr =  1"))
	(if (= (Connect.get CastaData vAtr-lHtr) -1) (print "vAtr-lHtr = -1"))
	(if (= (Connect.get CastaData vAtr-lHtr)  1) (print "vAtr-lHtr =  1"))
	(if (= (Connect.get CastaData at-von-links)  1) (print "at-von-links =  1"))
	(if (= (Connect.get CastaData at-von-rechts)  1) (print "at-von-rechts =  1"))
	(if (= (Connect.get CastaData amhtoberflansch ) 1)  (print "am Oberflansch"))
	(if (= (Connect.get CastaData amhtunterflansch ) 1)  (print "am Unterflansch"))
	(print "------------------------------------------------------------------------- Lage-Check - endet")
	
	 
	
	
	

	
	(Anbauteil.set abtl_FLochbild_HT (Master 1))
	(Anbauteil.set abtl_FLochbild_AT (Master 0))
	
)

(defun erzeugeLochbild ()
	(setq Fahnenlochbild (Lochbild.create))
	(Lochbild.set Fahnenlochbild
			(LB_Art		2)
			(S_Bez		"M12")
			(Guete   "4.6")
			(w "0 0 0 0")
			(e "0 30 70 0 0 0")
	)
	(Connect.storeAnschlObjs CastaData Fahnenlochbild)
	
	(attach_Lochbild_an_Fahne)
	(attach_Lochbild_an_Pfosten)
	(Lochbild_Vertikal_Ausrichten)
	(Lochbild_Seitlich_Ausrichten)
	
	
	(setq hp_Bl 	(Blech.get Fahnenblech hp)
		  dOK_Bl	(Blech.get Fahnenblech dOK)
	)
	(setq e_Abschn (* 0.25 hp_Bl))
	(setq e_0 (- e_Abschn) e_1 (* 2 e_Abschn))
	
	; zum Testen - Blech-OK bis Blech-UK
	; derzeit fehlt noch der Einfluss des Seitversatzes
	(setq e_0 (- e_0 (* 0.5 hp_Bl)))
	(setq e_1 hp_Bl)
	
	(setq dv_AT  	(Traeger.get Tr_ID delta_V)
		  t_AT		(Traeger.get Tr_ID t)	
	)
	(setq dlr_HT 	(Traeger.get Tr_ID delta_LR))
	(setq dp_Bl		(Blech.get Fahnenblech dp))
	(setq v_dp_t    (/ (+ t_AT dv_AT) tanV))
	
	(setq e_0 (* 0.25 hp_Bl))
	(setq e_1 (* 0.5  hp_Bl))

	; Weil e von unten nach oben läuft, entgegengesetzt zur Blechverschiebung
	(if (= (Connect.get CastaData at-von-links) 1) (progn
		(setq hp_Bl 	(Blech.get FahnenBlech hp)
			  b_HT		(Traeger.get HTrg b)
			  b_HT_eff	(/ b_HT sinV)
		)
		(setq e_0 (- b_HT_eff (* 0.75 hp_Bl)))
	))
	(setq w_0 0)

	(setq qsForm_AT (Traeger.get Tr_ID qsForm))
	(if (= qsForm_AT "L") (progn
		(setq b_AT (Traeger.get Tr_ID b)
			  t_AT (Traeger.get Tr_ID t)
		)
		(setq w_0 (* 0.5 (- b_AT t_AT)))
		
		(if (= kurzer_Schenkel 1) (progn
			(setq dv_HT (Traeger.get HTrg delta_V))
			(setq h_AT (Traeger.get Tr_ID h))
			(setq w_0 (+ (* 0.5 h_AT) t_AT))
			; (if (= (Connect.get CastaData vAtr-vHtr) -1) (setq w_0 (- w_0 dv_HT)))
			; (if (= (Connect.get CastaData vAtr-vHtr)  1) (setq w_0 (+ w_0 dv_HT)))
		))
	))
	(if (= qsForm_AT "F") (progn
		(setq w_0 0)
	))
	
	(Lochbild.set Fahnenlochbild
			(w "0 0 0 0")
			(e "0 0 0 0 0 0")
			(e0 e_0)
			(e1 e_1)
			(w0 w_0)
	)
	
	(setq dp 	(Blech.get Fahnenblech dp)
		  t_AT	(Traeger.get Tr_ID t)
	)
	(setq dxSK (+ (* 0.5 dp_Bl) t_AT))
	
	(Lochbild.set Fahnenlochbild 
		(Klemml 	(+ dp t_AT))
		(dxSKopf 	dxSK)
	)

	; Lochbild in Bezug auf das Blech hin testen
	; (setq hp_Bl (Blech.get Fahnenblech hp))
	; (setq e_2 (- (* 0.5 hp_Bl) 25))
	; (Lochbild.set Fahnenlochbild
	; 		(e "0 25 70 0 0 0")
	;		(e2 e_2)
	; )
	

	
)

(defun attach_Lochbild_an_Fahne ()

	(print  "erzeugeLochbild_an_Fahne")
	(setq abtl_Fahne (Traeger.get HTrg ABTeil Fahnenblech))
	
	(setq xPos_HT (Connect.get CastaData xPos_HT))
	(setq LB_FahnenWinkel 180.0)
;	(if (= (Connect.get CastaData vatr-lhtr) -1) (setq LB_FahnenWinkel 180.0))
	
	(Traeger.addabtl Htrg Fahnenlochbild xPos_HT   LB_FahnenWinkel _fahnblLochbild_ abtl_Fahne)

	; berechnet delta_LR_LB
	(calc_netto_Distance)
	
	(setq abtl_FLochbild (Traeger.get HTrg ABTeil Fahnenlochbild))
	(Anbauteil.set abtl_FLochbild 	(Master 1)
									(delta_LR delta_LR_LB)
									(SeitRicht 1)
	)
	
	(Lochbild.set	Fahnenlochbild (dlr_Coupon 0.0))
	
	(setq b_Eff 0)
	(if (= langer_Schenkel 1) (setq b_Eff (Traeger.get Tr_ID b)))
	(if (= kurzer_Schenkel 1) (setq b_Eff (Traeger.get Tr_ID h)))

	(setq 	b_HT 	(Traeger.get HTrg b)
			dlr_HT 	(Traeger.get HTrg delta_LR)
	)

;	(setq d_Diff (- dlr_HT (* 0.5 b_HT)))
;	(setq d_Diff_eff (* d_Diff sinV))
	(Anbauteil.set abtl_FLochbild (delta_V 0.0))
	
;	(setq d_Diff (- (* 0.5 b_HT) dlr_HT))
;	(setq d_Diff_eff (* d_Diff sinV))
;	(Anbauteil.set abtl_FLochbild (delta_V (- d_Diff_eff)))

	
)
(defun attach_Lochbild_an_Pfosten ()

	(setq xPos_AT (Connect.get CastaData xPos_AT))
	(setq Lb_FlachWinkel 0.0)
	(if (= (Connect.get CastaData at-von-links)  1) (setq Lb_FlachWinkel   0.0))
	(if (= (Connect.get CastaData at-von-rechts) 1) (setq Lb_FlachWinkel 180.0))
	
	(if (= langer_Schenkel 1) (progn
		(Traeger.addabtl Tr_ID Fahnenlochbild xPos_AT   Lb_FlachWinkel _flanschlochbild_of_)

		(setq dlr_HT	(Traeger.get HTrg delta_LR)
			  dlr_Eff	(* sinV dlr_HT)
		)
		
		(setq abtl_FLochbild_AT (Traeger.get Tr_ID ABTeil Fahnenlochbild))
		(Anbauteil.set abtl_FLochbild_AT 	
			(Master 	0)
			(delta_V 	dlr_Eff)
		)
		
		(setq qsForm_AT (Traeger.get Tr_ID qsForm))
		(if (= qsForm_AT "F") (progn
			(if (= (Connect.get CastaData at-von-links)  1) (progn
				(print "at-von-links")
				(if (= amHT_oben_vorbei 1) (progn
					(if (= Dist_Offset -1) (Anbauteil.set abtl_FLochbild_AT 	(SeitRicht -1)))
					(if (= Dist_Offset  1) (Anbauteil.set abtl_FLochbild_AT 	(SeitRicht  1)))
				))
				(if (= amHT_unten_vorbei 1) (progn
					(if (= Dist_Offset -1) (Anbauteil.set abtl_FLochbild_AT 	(SeitRicht  1)))
					(if (= Dist_Offset  1) (Anbauteil.set abtl_FLochbild_AT 	(SeitRicht -1)))
				))
			))
			(if (= (Connect.get CastaData at-von-rechts)  1) (progn
				(print "at-von-rechts")
				(if (= amHT_oben_vorbei 1) (progn
					(if (= Dist_Offset -1) (Anbauteil.set abtl_FLochbild_AT 	(SeitRicht  1)))
					(if (= Dist_Offset  1) (Anbauteil.set abtl_FLochbild_AT 	(SeitRicht -1)))
				))
				(if (= amHT_unten_vorbei 1) (progn
					(if (= Dist_Offset -1) (Anbauteil.set abtl_FLochbild_AT 	(SeitRicht -1)))
					(if (= Dist_Offset  1) (Anbauteil.set abtl_FLochbild_AT 	(SeitRicht  1)))
				))
			))
		))
		(if (= qsForm_AT "L") (progn
			(if (= (Connect.get CastaData at-von-rechts)  1) (progn
				(Anbauteil.set abtl_FLochbild_AT 	(SeitRicht -1))
			))
		))

	))
	(if (= kurzer_Schenkel 1) (progn
		(setq Lb_FlachWinkel 180.0)
		(Traeger.addabtl Tr_ID Fahnenlochbild xPos_AT   Lb_FlachWinkel _steglochbild_system_)

		(setq dlr_HT	(Traeger.get HTrg delta_LR)
			  dlr_Eff	(* sinV dlr_HT)
		)
		
		(setq abtl_FLochbild_AT (Traeger.get Tr_ID ABTeil Fahnenlochbild))
		(Anbauteil.set abtl_FLochbild_AT 	
			(Master 	0)
			(delta_V 	dlr_Eff)
		)
		
		(if (= (Connect.get CastaData at-von-rechts)  1) (progn
			(print "at-von-rechts")
			(if (= (Connect.get CastaData vAtr-vHtr)  -1) (progn
				(if (= Dist_Offset  1) (Anbauteil.set abtl_FLochbild_AT 	(SeitRicht -1)))
			))
			
			(setq t_HT (Traeger.get HTrg t))
			(Anbauteil.set abtl_FLochbild_AT (delta_LR (* 0.5 t_HT)))
		))
		(if (= (Connect.get CastaData at-von-links)  1) (progn
			(print "at-von-links")
			(if (= (Connect.get CastaData vAtr-vHtr)  -1) (progn
				(if (= Dist_Offset 1) (Anbauteil.set abtl_FLochbild_AT 	(SeitRicht -1)))
			))
			(setq dv_Lochb (Anbauteil.get abtl_FLochbild_AT delta_V))
			(Anbauteil.set abtl_FLochbild_AT (delta_V (- dv_Lochb)))

			(setq t_HT (Traeger.get HTrg t))
			(Anbauteil.set abtl_FLochbild_AT (delta_LR (* 0.5 t_HT)))
		))

		
		
	))
	
	; Oben / Unten vorbei braucht man wohl nicht
	(if (= amHT_oben_vorbei 1) (progn
		(if (= (Connect.get CastaData at-von-links)  1) (print "oben vorbei von links"))
		(if (= (Connect.get CastaData at-von-rechts)  1) (print "oben vorbei von rechts"))
	))
	(if (= amHT_unten_vorbei 1) (progn
		(if (= (Connect.get CastaData at-von-links)  1) (print "unten vorbei von links"))
		(if (= (Connect.get CastaData at-von-rechts)  1) (print "unten vorbei von rechts"))
	))
	
	
)
