; $	HT	QT(IUKR)		AF(FS)			P(EZ)
; $ 	AT	QT(L)			AF(FS)			P(EZ)
; $	AE	V(-)			H(-)			R(-)

(defun load-modules ()
  ; Profil prfen
  (setq qsform_at (Traeger.get Tr_ID qsform))
  (print qsform_at)

)

(defun init-connection ()

  (print "*clear*")
  (print "********************************************************************")
  (print "in init-connection - LProf_Aufliegend");
  
  (setq lichterAbst 0.0)
   
  (connect.ShowAttributes CastaData)
  
  (setq AWnkl 0.0)
  (setq calc_OK 0)

  (if (= (Connect.get CastaData amATFlansch) 1) (progn
	(setq AWnkl (Connect.get CastaData h-atrgewnkl_steg))
  ))
  (if (= (Connect.get CastaData amATSteg) 1) (progn
	(setq AWnkl (Connect.get CastaData v-atrgewnkl_steg))
  ))
  (if (= (Connect.get CastaData anschlZwAtEnden) 1) (progn
	(setq v_KopfWnkl (Connect.get CastaData v-atrgewnkl_kopf))
	(setq h_KopfWnkl (Connect.get CastaData h-atrgewnkl_kopf))
	
	(if (= v_KopfWnkl   0.0) (if (= h_KopfWnkl   0.0) (setq calc_OK 2)))
	(if (= v_KopfWnkl 180.0) (if (= h_KopfWnkl   0.0) (setq calc_OK 2)))
  ))

  (if (> AWnkl 89.5) (if (< AWnkl 90.5) (setq calc_OK 1)))
  
  (if (= calc_OK 0) (progn
      (alertBox "Der Anschluss kann nur fr rechtwinklige Anschlusskonstellationen\neingesetzt werden!" "ERR_JustRectangularConn")
  ))

;  (setq calc_OK 0)

  (if (= calc_OK 1) (progn
	  (if (= (Connect.get CastaData amATFlansch) 1) (progn
		(setq fllochbild (Lochbild.create))
		(Connect.storeAnschlObjs CastaData fllochbild)
		(createFlansch_FlanschLochbild fllochbild lichterAbst)
	  ))
	  (if (= (Connect.get CastaData amATSteg) 1) (progn
		(setq fllochbild (Lochbild.create))
		(Connect.storeAnschlObjs CastaData fllochbild)
		(createFlansch_StegLochbild  fllochbild lichterAbst)
	  ))
	  (calcHT_SeitVerschiebung fllochbild)
  ))

  (if (= calc_OK 2) (progn
;	  (if (= (Connect.get CastaData amATFlansch) 1) (print "amATFlansch"))
;	  (if (= (Connect.get CastaData amATSteg) 1)    (print  "amATSteg"))

	  (if (= (Connect.get CastaData amATSteg) 1) (progn
		(setq fllochbild (Lochbild.create))
		(Connect.storeAnschlObjs CastaData fllochbild)
		(createFlansch_StegLochbild  fllochbild lichterAbst)
	  ))
	  (if (= (Connect.get CastaData amATFlansch) 1) (progn
;		(print "Anschluss am Winkelflansch")
		(setq fllochbild (Lochbild.create))
		(Connect.storeAnschlObjs CastaData fllochbild)
		(createFlansch_FlanschLochbild fllochbild lichterAbst)
	  ))
	  (calcHT_SeitVerschiebung fllochbild)

  ))


  (if (> calc_OK 2) (progn

	  (setq ablt_Lochb_HT (Traeger.get HTrg  ABTeil fllochbild))
	  (setq ablt_Lochb_AT (Traeger.get Tr_ID ABTeil fllochbild))
	  
	  (Anbauteil.set ablt_Lochb_HT (Master 1))
	  (Anbauteil.set ablt_Lochb_AT (Master 0))

;	  (Anbauteil.set ablt_Lochb_HT 	(SeitRicht  -1))
;	  (Anbauteil.set ablt_Lochb_HT 	(switch_on _unterflansch_))
	  
	  (Lochbild.set fllochbild (e0 0) (e1 20) (e2 40) (e3 80) (w 30) (delta_W  0))
	  
	  (setq LB_Delta_V_HT (Anbauteil.get ablt_Lochb_HT delta_V))
	  (setq LB_Delta_V_AT (Anbauteil.get ablt_Lochb_AT delta_V))

	  (setq LB_Winkel_HT (Anbauteil.get ablt_Lochb_HT Winkel))
	  (setq LB_Winkel_AT (Anbauteil.get ablt_Lochb_AT Winkel))

    ))


)

(defun createFlansch_StegLochbild (Lchb_ID ABST)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE FLANSCHLOCHBILD")
	
	(calcAndSetLochbildDaten Lchb_ID ABST)
	
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	(setq xPos_at (Connect.get CastaData xPos_at))
	
	(print xPos_ht)
	(print xPos_at)
		
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _flanschlochbild_of_)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _flanschlochbild_uf_)
	)

	(if (= (Connect.get CastaData amAtSteg) 1)
		(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _steglochbild_system_)
		; (traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _steglochbild_)
	)

	; Winkel Anbauteil AT
	; --------------------------
	(setq winkel_abteil_at 0.0)

	(setq delta_lr_ht (Traeger.get Htrg delta_lr))
	(setq delta_lr_abtl_at 0.0)

	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	(setq delta_v_abtl_ht 0.0)

	(setq HT_ABTeil (Traeger.get Htrg AbTeil Lchb_ID))
	(setq AT_ABTeil (Traeger.get Tr_ID AbTeil Lchb_ID))

	(Anbauteil.set AT_ABTeil 	(Master   1))
	(Anbauteil.set HT_ABTeil 	(Master   0))
;	(Lochbild.set Lchb_ID (dxSKopf 50))


	(setq delta_lr_abtl_HT 0.0)
	(if (= (Connect.get CastaData amHTOberflansch) 1) (progn
	    (if (= (Connect.get CastaData linkesEnde) 1) (progn
		(setq delta_lr_abtl_HT (- delta_lr_at))
	    ))
	    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(setq delta_lr_abtl_HT    delta_lr_at)
	    ))
	))
	(if (= (Connect.get CastaData amHTUnterflansch) 1) (progn
	    (if (= (Connect.get CastaData linkesEnde) 1) (progn
		(setq delta_lr_abtl_HT    delta_lr_at)
	    ))
	    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(setq delta_lr_abtl_HT (- delta_lr_at))
	    ))
	))


	(setq winkel_abteil_ht 90.0)
	(setq winkel_abteil_at 180.0)
;	(if (= (Connect.get CastaData linkesEnde) 1) (progn

	(if (= (Connect.get CastaData at-von-rechts) 1) (progn
		(AolertBox  "at-von-rechts")
		(setq winkel_abteil_at   0.0)
		(if (= (Connect.get CastaData amHTUnterflansch) 1) (progn
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq winkel_abteil_ht  90.0))
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq winkel_abteil_ht 270.0))
			(Anbauteil.set HT_ABTeil 	(SeitRicht  -1))
		))
		(if (= (Connect.get CastaData amHTOberflansch) 1) (progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq winkel_abteil_ht  90.0))
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq winkel_abteil_ht 270.0))
;			(Anbauteil.set HT_ABTeil 	(SeitRicht  -1))
		))
	))
;	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
	(if (= (Connect.get CastaData at-von-links) 1) (progn
		(print  "at-von-links")
		(setq winkel_abteil_at 180.0)
;		(if (= (Connect.get CastaData amHTOberflansch) 1) (progn
;		    (Lochbild.set Lchb_ID (LB_Art 2))
;		))
		(if (= (Connect.get CastaData amHTUnterflansch) 1) (progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq winkel_abteil_ht  90.0))
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq winkel_abteil_ht 270.0))
;			(Anbauteil.set AT_ABTeil 	(SeitRicht  -1))
		))
		(if (= (Connect.get CastaData amHTOberflansch) 1) (progn
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq winkel_abteil_ht  90.0))
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq winkel_abteil_ht 270.0))
			(Anbauteil.set HT_ABTeil 	(SeitRicht  -1))
		))
		(Anbauteil.set AT_ABTeil 	(SeitRicht  -1))
	))

	(setq delta_v_abtl_ht  0.0)
	(setq delta_lr_abtl_HT 0.0)
	
	(setq delta_v_at (Traeger.get Tr_ID delta_V))
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abtl_HT (- delta_v_at)))
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abtl_HT    delta_v_at))
	
	; HT-Anbauteil Werte setzen
	(Anbauteil.set HT_ABTeil 	(winkel   winkel_abteil_ht)
					(delta_lr delta_lr_abtl_HT)
	)
	
	; AT-Anbauteil Werte setzen
	(Anbauteil.set AT_ABTeil 	(winkel  	winkel_abteil_at)
					(delta_lr	delta_lr_abtl_at) 
	)

;	(if (= (Connect.get CastaData vatr-vhtr) -1)	(Anbauteil.set AT_ABTeil 	(SeitRicht  -1)))
	
	(print "<-----------------------------------------------------------")
;	...........................................................
)
; --------------------------------------------------------------------------------



(defun createFlansch_FlanschLochbild (Lchb_ID ABST)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE FLANSCHLOCHBILD")
	
	(calcAndSetLochbildDaten Lchb_ID ABST)
	
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	(setq xPos_at (Connect.get CastaData xPos_at))
	
	(print xPos_ht)
	(print xPos_at)
		
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _flanschlochbild_of_)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _flanschlochbild_uf_)
	)

	(if (= (Connect.get CastaData amAtOberflansch) 1)
		(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _flanschlochbild_of_)
	)
	(if (= (Connect.get CastaData amAtUnterflansch) 1)
		(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _flanschlochbild_of_)	; fr Winkel gibt es nur Oberflansch
	)

	; Winkel Anbauteil AT
	; --------------------------
	(setq winkel_abteil_at 0.0)

	(setq delta_lr_ht (Traeger.get Htrg delta_lr))
	(setq delta_lr_abtl_at 0.0)

	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	(setq delta_v_abtl_ht 0.0)

	(setq HT_ABTeil (Traeger.get Htrg AbTeil Lchb_ID))
	(setq AT_ABTeil (Traeger.get Tr_ID AbTeil Lchb_ID))

	(Anbauteil.set AT_ABTeil 	(Master   0))
	(Anbauteil.set HT_ABTeil 	(Master   1))
;	(Lochbild.set Lchb_ID (dxSKopf 50))
;	(Lochbild.set Lchb_ID (e1 20) (e2 50))

	(if (= (Connect.get CastaData linkesEnde) 0) (if (= (Connect.get CastaData rechtesEnde) 0) (progn
		(setq e_0 (Lochbild.get Lchb_ID e0))
		(Lochbild.set Lchb_ID (e0 (- e_0)) (e1 (* 2 e_0)))
	)))
	
	(setq delta_lr_abtl_HT 0.0)
	(setq winkel_abteil_ht 90.0)
	(setq winkel_abteil_at 180.0)
	(if (= (Connect.get CastaData at-von-rechts) 1) (progn
		(print  "Flansch-Flansch - at-von-rechts")
		(setq winkel_abteil_at   0.0)
		(if (= (Connect.get CastaData amHTUnterflansch) 1) (progn
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_ht  90.0))
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_ht 270.0))
			(Anbauteil.set HT_ABTeil 	(SeitRicht  -1))
		))
		(if (= (Connect.get CastaData amHTOberflansch) 1) (progn
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_ht  90.0))
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_ht 270.0))
		))

		; Juni 2022-06-21 - eingebaut 
	    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
			(setq winkel_abteil_ht (+ winkel_abteil_ht 180.0))
			(setq winkel_abteil_at (+ winkel_abteil_at 180.0))
			(if (> winkel_abteil_ht 360.0) (setq winkel_abteil_ht (- winkel_abteil_ht 360.0)))
			(if (> winkel_abteil_at 360.0) (setq winkel_abteil_at (- winkel_abteil_at 360.0)))
			
			(setq LB_Art (Lochbild.get Lchb_ID LB_Art))
			(setq LB_Art (- LB_Art))
			(Lochbild.set Lchb_ID (LB_Art LB_Art))

			(setq delta_lr_at (- delta_lr_at)) ; ++++++++++++++++++++++++++ OK
		))
	))
	(if (= (Connect.get CastaData at-von-links) 1) (progn
		(print  "Flansch-Flansch - at-von-links")
		(setq winkel_abteil_at 180.0)
		(if (= (Connect.get CastaData amHTUnterflansch) 1) (progn
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_ht  90.0))
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_ht 270.0))
		))
		(if (= (Connect.get CastaData amHTOberflansch) 1) (progn
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_ht  90.0))
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_ht 270.0))
			(Anbauteil.set HT_ABTeil 	(SeitRicht  -1))
		))
		(Anbauteil.set AT_ABTeil 	(SeitRicht  -1))

		; Juni 2022-06-21 - eingebaut 
	    (if (= (Connect.get CastaData linkesEnde) 1) (progn
			(setq winkel_abteil_ht (+ winkel_abteil_ht 180.0))
			(setq winkel_abteil_at (+ winkel_abteil_at 180.0))
			(if (> winkel_abteil_ht 360.0) (setq winkel_abteil_ht (- winkel_abteil_ht 360.0)))
			(if (> winkel_abteil_at 360.0) (setq winkel_abteil_at (- winkel_abteil_at 360.0)))
			
			(setq LB_Art (Lochbild.get Lchb_ID LB_Art))
			(setq LB_Art (- LB_Art))
			(Lochbild.set Lchb_ID (LB_Art LB_Art))

			(setq delta_lr_at (- delta_lr_at)) ; ++++++++++++++++++++++++++ OK
			
		))

	))

	(setq delta_v_abtl_ht  0.0)
	

        (if (= (Connect.get CastaData sAtr-lHtr) -1)  (setq delta_lr_abtl_HT    delta_lr_at))
        (if (= (Connect.get CastaData sAtr-lHtr)  1)  (setq delta_lr_abtl_HT (- delta_lr_at)))
			


	
	; HT-Anbauteil Werte setzen
	(Anbauteil.set HT_ABTeil 	(winkel   winkel_abteil_ht)
					(delta_lr delta_lr_abtl_HT)
	)

	
	; AT-Anbauteil Werte setzen
	(Anbauteil.set AT_ABTeil 	(winkel  	winkel_abteil_at)
					(delta_lr	delta_lr_abtl_at)
	)

;	(if (= (Connect.get CastaData vatr-vhtr) -1)	(Anbauteil.set AT_ABTeil 	(SeitRicht  -1)))

	
	(print "<-----------------------------------------------------------")
;	...........................................................
)
(defun calcAndSetLochbildDaten  (Lchb_ID ABST)
	
	(setq 	t_HT (Traeger.get HTrg  t)
		b_HT (Traeger.get HTrg  b)
		t_AT (Traeger.get Tr_ID t)
		b_AT (Traeger.get Tr_ID b)
		h_AT (Traeger.get Tr_ID h)
	)


	(setq 	e0 	(* 0.25 (- b_HT t_HT))
		e1 	0
		w0 	(/ b_AT 2.0)
	)

	(if (= (Connect.get CastaData amATFlansch) 1) (progn
		(if (= qsform_at "L") (Lochbild.set Lchb_ID (dxSKopf t_AT)))
	))

	
	(if (= (Connect.get CastaData amATSteg) 1) (progn
		(setq 	e0 	(* 0.25 (- b_HT t_HT))
			e1 	0
			w0 	(/ h_AT 2.0)
		)
		(Lochbild.set Lchb_ID (LB_Art 2))
		(Lochbild.set Lchb_ID (dxSKopf t_AT))

		(setq qsform_at (Traeger.get Tr_ID qsForm))
		(if (= qsform_at "L") (Lochbild.set Lchb_ID (dxSKopf 0)))
	))

	; vorbesetzen ...
	(Lochbild.set Lchb_ID
			(S_Bez 		"M12")
			(Guete   	"4.6")
			; (e       	"0 10 50 0 0 0")
			(w       	"0  0")
			(RWinkel	0.0)		; hat hier keinen Einfluss
	)

	(if (= (Connect.get CastaData anschlzwhtenden) 1) (progn
		(setq e1 (* 2 e0)
		      e0 (- e0)
		)
	))


	(Lochbild.set Lchb_ID
		(e0				e0)
		(e1				e1)
		;(e2				100)
		(w0				w0) 	
		(klemml 	(+ t_HT t_AT ABST))
	)


)
(defun calcHT_SeitVerschiebung (Lchb_ID)

   (setq delta_LR_HT (Traeger.get HTrg delta_lr))
   (setq delta_Lng 0.0)

   (setq Abtl_AT_Lchb (Traeger.get Tr_ID ABTeil Lchb_ID))
   (setq Abtl_HT_Lchb (Traeger.get HTrg  ABTeil Lchb_ID))

   (if (/= delta_LR_HT 0.0) (progn
	   (if (= (Connect.get CastaData at-von-rechts) 1) (progn
 
		(if (= (Connect.get CastaData amATSteg) 1) (progn
		    (if (= (Connect.get CastaData vAtr-lHtr)  1)  (setq delta_Lng (- delta_LR_HT)))
		    (if (= (Connect.get CastaData vAtr-lHtr) -1)  (setq delta_Lng    delta_LR_HT))
		))
		(if (= (Connect.get CastaData amATFlansch) 1) (progn
		    (if (= (Connect.get CastaData sAtr-lHtr)  1)  (setq delta_Lng (- delta_LR_HT)))
		    (if (= (Connect.get CastaData sAtr-lHtr) -1)  (setq delta_Lng    delta_LR_HT))
		))
		(if (= (Connect.get CastaData rechtesEnde) 1) (setq delta_LR_HT (- delta_LR_HT)))
		
		; Am Unterflansch geht die Verschiebung in die andere Richtung
		(if (= (Connect.get CastaData amHTUnterFlansch) 1) (setq delta_Lng (- delta_Lng)))

		(if (= (Connect.get CastaData linkesEnde) 1) (progn
			(setq TrgEnde (Traeger.get Tr_ID links))
			(TrEnde.set TrgEnde (delta_l 0))
			(TrEnde.ptrim TrgEnde delta_Lng)
		))
		(if (= (Connect.get CastaData rechtesEnde) 1) (progn
			(setq TrgEnde (Traeger.get Tr_ID rechts))
			(TrEnde.set TrgEnde (delta_l 0))
			(TrEnde.ptrim TrgEnde (- delta_Lng))
		))

	  ))
	  (if (= (Connect.get CastaData at-von-links) 1) (progn

		(if (= (Connect.get CastaData amATSteg) 1) (progn
		    (if (= (Connect.get CastaData vAtr-lHtr) -1)  (setq delta_Lng (- delta_LR_HT)))
		    (if (= (Connect.get CastaData vAtr-lHtr)  1)  (setq delta_Lng    delta_LR_HT))
		))
		(if (= (Connect.get CastaData amATFlansch) 1) (progn
		    (if (= (Connect.get CastaData sAtr-lHtr) -1)  (setq delta_Lng (- delta_LR_HT)))
		    (if (= (Connect.get CastaData sAtr-lHtr)  1)  (setq delta_Lng    delta_LR_HT))
		))
		(if (= (Connect.get CastaData linkesEnde) 1) (setq delta_LR_HT (- delta_LR_HT)))

		; Am Unterflansch geht die Verschiebung in die andere Richtung
		(if (= (Connect.get CastaData amHTUnterFlansch) 1) (setq delta_Lng (- delta_Lng)))

		(if (= (Connect.get CastaData linkesEnde) 1) (progn
			(setq TrgEnde (Traeger.get Tr_ID links))
			(TrEnde.set TrgEnde (delta_l 0))
			(TrEnde.ptrim TrgEnde  (- delta_Lng))
		))
		(if (= (Connect.get CastaData rechtesEnde) 1) (progn
			(setq TrgEnde (Traeger.get Tr_ID rechts))
			(TrEnde.set TrgEnde (delta_l 0))
			(TrEnde.ptrim TrgEnde delta_Lng)
		))

	  ))
	; jetzt noch das Lochbild verschieben - lngs der Vertikalachse
	(Anbauteil.set Abtl_AT_Lchb (delta_V (- delta_LR_HT)))
	
	
   ))
)

