; $	G(61)	HT	 QT(FL)	 	AF(F)		P(EZ)
; $	G(61)	AT	 QT(FL) 	AF(F)		P(EZ)
; $	G(61)	AE	 V(-)		H(-)		R(-)
; $			HT	QT(FL)		AF(FS)		P(ZE)
; $			AT	QT(FL)		AF(FS)		P(ZE)
; $			AE	V(0)		H(-)		R(-)

(defun load-modules ()
	(load "mod-endinit-trg-auf-trg")
)

(defun init-connection ()
	(print "*clear*")
	(print "Anschluss fr kreuzende Profile")
	(connect.showattributes CastaData)
	(print "---------------------- +++ ------------------------------ +++ --------------------")

	(setq HT_UFlansch_an_AT_Flansch 0)
	(if (= (Connect.get CastaData amhtunterflansch  ) 1) (progn
		(if (= (Connect.get CastaData amatunterflansch ) 1) (setq HT_UFlansch_an_AT_Flansch 1))
		(if (= (Connect.get CastaData amatoberflansch ) 1)  (setq HT_UFlansch_an_AT_Flansch 1))
	))
	(setq HT_OFlansch_an_AT_Flansch 0)
	(if (= (Connect.get CastaData amhtoberflansch  ) 1) (progn
		(if (= (Connect.get CastaData amatunterflansch ) 1) (setq HT_OFlansch_an_AT_Flansch 1))
		(if (= (Connect.get CastaData amatoberflansch ) 1)  (setq HT_OFlansch_an_AT_Flansch 1))
	))
	(setq AT_StegLinks_an_HT_Flansch 0)
	(if (= (Connect.get CastaData amatStegLinks) 1) (progn
		(if (= (Connect.get CastaData amhtunterflansch ) 1) (setq AT_StegLinks_an_HT_Flansch 1))
		(if (= (Connect.get CastaData amhtoberflansch ) 1)  (setq AT_StegLinks_an_HT_Flansch 1))
	))
	(setq AT_StegRechts_an_HT_Flansch 0)
	(if (= (Connect.get CastaData amatStegRechts) 1) (progn
		(if (= (Connect.get CastaData amhtunterflansch ) 1) (setq AT_StegRechts_an_HT_Flansch 1))
		(if (= (Connect.get CastaData amhtoberflansch ) 1)  (setq AT_StegRechts_an_HT_Flansch 1))
	))

	(print HT_UFlansch_an_AT_Flansch)
	(print HT_OFlansch_an_AT_Flansch)
	(print AT_StegLinks_an_HT_Flansch)
	(print AT_StegRechts_an_HT_Flansch)
	
	(setq Makro_ausgefuehrt 0)
	(if (= HT_OFlansch_an_AT_Flansch 1) (progn
		(setq Makro_ausgefuehrt 1)
		(createConn_Flansch_an_Flansch)
	))
	(if (= HT_UFlansch_an_AT_Flansch 1) (progn
		(setq Makro_ausgefuehrt 1)
		(createConn_Flansch_an_Flansch)
	))
	(if (= AT_StegLinks_an_HT_Flansch 1) (progn
		(setq Makro_ausgefuehrt 1)
		(createConn_Steg_an_Flansch)
	))
	(if (= AT_StegRechts_an_HT_Flansch 1) (progn
		(setq Makro_ausgefuehrt 1)
		(createConn_Steg_an_Flansch)
	))
	(if (= Makro_ausgefuehrt 0) (AlertBox "Makro wurde nicht ausgefhrt"))
)

(defun setConnection ()
	(print "Anschluss durchfhren")
)

; -----------------------------------------------------------------------------------------------
(defun initLochbild_FlV (Lchb_ID KlemmLaenge)

	(Lochbild.set Lchb_ID
		(S_Bez "M16")
		(Guete "4.6")
		(e "0 0 0 0 0 0")
		(w "0 0 0 0")
		(LB_Art 2)
		(KlemmL KlemmLaenge)
	)

	(setq b_HT (Traeger.get HTrg b))
	(setq t_AT (Traeger.get Tr_ID t))
	(if (= (Connect.get CastaData amAtSteg) 1) (progn
		(setq b_AT (Traeger.get Tr_ID h))
	))
	(if (= (Connect.get CastaData amAtFlansch) 1) (progn
		(setq b_AT (Traeger.get Tr_ID b))
	))
	(setq b4 (/ b_AT 4))
	(if (< b4 32) (setq b4 32))	; Mindestabstand festlegen
	(if (< b_AT 40) (Lochbild.set Lchb_ID (S_Bez "M12")))
	
	(setq e_0 (- b4))
	(if (= (Connect.get CastaData linkesEnde) 1)  (progn
		(setq TE (Traeger.get Tr_ID links))
		(setq deltaL (TrEnde.get TE delta_L))
		(setq e_0 (+ deltaL b4))
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(setq TE (Traeger.get Tr_ID rechts))
		(setq deltaL (TrEnde.get TE delta_L))
		(setq e_0 (+ deltaL b4))
	))
	
	(setq w_0 (+ (* 0.5 b_AT) t_AT))
	(Lochbild.set Lchb_ID
		(w "0 0 0 0")
		(w0 w_0)
		(e "0 0 0  0 0 0")
		(e0 e_0)
		(e1 (* 2 b4))
	)
	; (Lochbild.set Lchb_ID (e "0 25 65 0 0 0") (w "0 35"))
	
	
)

(defun createConn_Flansch_an_Flansch ()
	(print "Anschluss Flansch-an-Flansch -----------------------------------------------------------------")
	(print "----------------------------------------------------------------------------------------------")
	(setq xPos_AT (Connect.get CastaData xPos_AT))
	(setq xPos_HT (Connect.get CastaData xPos_HT))

	; -----------------------------
	(setq s_HT (Traeger.get HTrg  t)
		  s_AT (Traeger.get Tr_ID t)
		  KlemmLaenge (+ s_HT s_AT)
	)
	
	(setq Lchb_ID (lochbild.create))
	(initLochbild_FlV Lchb_ID KlemmLaenge)
	; (Lochbild.set Lchb_ID (w "30 0") (e "0 25 75 0 0 0"))
	(Connect.storeAnschlObjs CastaData Lchb_ID)

	(setq dlr_HT (Traeger.get HTrg  delta_LR))
	(setq dlr_AT (Traeger.get Tr_ID delta_LR))
	
	(setq SR_AT 0)
	(setq SR_HT 0)
	(setq HT_LchbWinkel 0.0)
	(setq HT_LchbWinkel (Connect.get CastaData h-atrgewnkl_steg))
	(if (= (Connect.get CastaData linkesEnde)  0) (if (= (Connect.get CastaData rechtesEnde)  0) (progn
		(setq HT_LchbWinkel (Connect.get CastaData r-atrgewnkl_flansch))
		(if (= (Connect.get CastaData at-von-rechts) 1) (progn
			(setq HT_LchbWinkel (- 180.0 HT_LchbWinkel))
		))
	)))
	
	
	(setq AT_LchbWinkel 0.0)
	
	(setq Fall 0)
	(if (= (Connect.get CastaData at-von-rechts) 1) (progn
		; (if (>= AT_LchbWinkel 90.0) (setq AT_LchbWinkel (-  AT_LchbWinkel 180.0)))
		(print "at-von-rechts") (print HT_LchbWinkel) (print AT_LchbWinkel) 

		(if (= (Connect.get CastaData satr-lhtr) 1) (progn
			(setq Fall 1)
			(setq HT_LchbWinkel (- 180 HT_LchbWinkel))
			(setq SR_AT -1)
			(setq SR_HT -1)
		))
		(if (= (Connect.get CastaData satr-lhtr) -1) (progn
			(setq Fall 2)
			(setq SR_AT  1)
			(setq SR_HT -1)
		))

	))
	(if (= (Connect.get CastaData at-von-links) 1) (progn
		; (setq AT_LchbWinkel (+  AT_LchbWinkel 180.0))
		; (if (>= AT_LchbWinkel 360.0) (setq AT_LchbWinkel (-  AT_LchbWinkel 360.0)))
		; (setq HT_LchbWinkel 180.0)
		
		(if (= (Connect.get CastaData satr-lhtr) 1) (progn
			(setq Fall 3)
			(setq SR_AT 1)
			(setq SR_HT -1)
			(setq HT_LchbWinkel (+ HT_LchbWinkel 180.0))
		))
		(if (= (Connect.get CastaData satr-lhtr) -1) (progn
			(setq Fall 4)
			(setq HT_LchbWinkel (- HT_LchbWinkel))
			(setq SR_AT -1)
			(setq SR_HT -1)
		))
		
		(print "at-von-links") (print HT_LchbWinkel) (print AT_LchbWinkel) 
	))

;	(AlertBox Fall)
;	(Lochbild.set Lchb_ID (e "0 25 75 0 0 0"))
	
	(if (= 3 3) (progn
		(if (= (Connect.get CastaData at-von-links) 1) (progn
			(print "AT-von-links")
			(setq AT_LchbWinkel 180.0)
			(setq HT_LchbWinkel (+ 180.0 HT_LchbWinkel))
			(if (>= HT_LchbWinkel 360.0) (setq HT_LchbWinkel (- HT_LchbWinkel 360.0)))
		))
	))

	
	(print Fall)
	(print AT_LchbWinkel) (print HT_LchbWinkel)

	(traeger.addabtl Tr_ID Lchb_ID xPos_AT AT_LchbWinkel	 _flanschlochbild_uf_)
	(traeger.addabtl HTrg Lchb_ID  xPos_HT HT_LchbWinkel     _flanschlochbild_uf_)
	
	(setq Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil Lchb_ID))
	(setq Abtl_Lchb_HT (Traeger.get HTrg  ABTeil Lchb_ID))
	
	(print SR_AT) (print SR_HT)

	(Anbauteil.set Abtl_Lchb_AT (Master 1) (SeitRicht  SR_AT))
	(Anbauteil.set Abtl_Lchb_HT (Master 0) (SeitRicht  SR_HT))
	
	; -------------------------------
	(setq sinW (sin (/ (* PI HT_LchbWinkel) 180.0)))
	(setq cosW (cos (/ (* PI HT_LchbWinkel) 180.0)))
	(setq tanW (tan (/ (* PI HT_LchbWinkel) 180.0)))

	(if (= (Connect.get CastaData vAtr-vHtr) 1) (progn
			(if (= AT_LchbWinkel   0.0) (Lochbild.set Lchb_ID (LB_Art  2)))
			(if (= AT_LchbWinkel 180.0) (Lochbild.set Lchb_ID (LB_Art -2)))
	))
	(if (= (Connect.get CastaData vAtr-vHtr) -1) (progn
			(if (= AT_LchbWinkel   0.0) (Lochbild.set Lchb_ID (LB_Art -2)))
			(if (= AT_LchbWinkel 180.0) (Lochbild.set Lchb_ID (LB_Art  2)))
	))

	; dlr_Coupon wird verwendet, um bei Winkeln das Lochbild an den Flansch/Steg zu schieben

	; seitliche Verschiebung des AT
	(if (= (Connect.get CastaData vAtr-vHtr)  1) (progn
		(if (= (Connect.get CastaData at-von-links)  1) (setq dlr_Lchb_HT dlr_AT))
		(if (= (Connect.get CastaData at-von-rechts) 1) (setq dlr_Lchb_HT (- dlr_AT)))
	))
	(if (= (Connect.get CastaData vAtr-vHtr) -1) (progn
		(if (= (Connect.get CastaData at-von-links)  1) (setq dlr_Lchb_HT (- dlr_AT)))
		(if (= (Connect.get CastaData at-von-rechts) 1) (setq dlr_Lchb_HT dlr_AT))
	))

	(if (= (Connect.get CastaData vAtr-vHtr)  1) (progn
			(if (= (Connect.get CastaData at-von-links)  1) (print "Fall A"))
			(if (= (Connect.get CastaData at-von-rechts) 1) (print "Fall B"))
	))
	(if (= (Connect.get CastaData vAtr-vHtr) -1) (progn
			(if (= (Connect.get CastaData at-von-links)  1) (print "Fall C"))
			(if (= (Connect.get CastaData at-von-rechts) 1) (print "Fall D"))
	))
		
	; seitliche Verschiebung des HT
	(setq dv_Lchb_HT (* sinW dlr_HT))
	(setq dlr_Lchb_HT_tmp (* cosW dlr_HT))
	(setq dlr_Lchb_HT (+ dlr_Lchb_HT dlr_Lchb_HT_tmp))
	
	(Anbauteil.set Abtl_Lchb_HT (delta_V   dv_Lchb_HT)	(delta_LR   dlr_Lchb_HT))
	(Anbauteil.set Abtl_Lchb_AT (delta_V   0.0) (delta_LR   0.0))
	
)


(defun createConn_Steg_an_Flansch ()
	(print "Anschluss Steg-an-Flansch -----------------------------------------------------------------")
	(print "----------------------------------------------------------------------------------------------")
	(setq xPos_AT (Connect.get CastaData xPos_AT))
	(setq xPos_HT (Connect.get CastaData xPos_HT))

	; -----------------------------
	(setq s_HT (Traeger.get HTrg  t)
		  s_AT (Traeger.get Tr_ID t)
		  KlemmLaenge (+ s_HT s_AT)
	)
	
	(setq Lchb_ID (lochbild.create))
	(initLochbild_FlV Lchb_ID KlemmLaenge)
;	(Lochbild.set Lchb_ID (w "0 0") (e "0 25 100 0 0 0"))
	(Connect.storeAnschlObjs CastaData Lchb_ID)

	(setq dv_AT   (Traeger.get Tr_ID delta_V))
	(setq dlr_HT  (Traeger.get HTrg delta_LR))

	(setq SR_AT 0)
	(setq SR_HT 0)
	(setq HT_LchbWinkel (Connect.get CastaData v-atrgewnkl_steg))

	(setq Fall 0)
	(if (= (Connect.get CastaData at-von-links) 1) (progn
		; (if (>= AT_LchbWinkel 90.0) (setq AT_LchbWinkel (-  AT_LchbWinkel 180.0)))
		(setq AT_LchbWinkel 0.0)
		(print "at-von-rechts") (print HT_LchbWinkel) (print AT_LchbWinkel) 

		(if (= (Connect.get CastaData satr-vhtr) 1) (progn
			(setq Fall 1)
			; (setq AT_LchbWinkel 180.0)
			(setq SR_AT  1)
			(setq SR_HT -1)
			(setq HT_LchbWinkel (- HT_LchbWinkel 180.0))
		))
		(if (= (Connect.get CastaData satr-vhtr) -1) (progn
			(setq Fall 2)
			(setq HT_LchbWinkel (- HT_LchbWinkel))
			(setq SR_AT -1)
			(setq SR_HT -1)
		))

	))
	(if (= (Connect.get CastaData at-von-rechts) 1) (progn
		; (setq AT_LchbWinkel (+  AT_LchbWinkel 180.0))
		; (if (>= AT_LchbWinkel 360.0) (setq AT_LchbWinkel (-  AT_LchbWinkel 360.0)))
		(setq AT_LchbWinkel 0.0)
		
		(if (= (Connect.get CastaData satr-vhtr) 1) (progn
			(setq Fall 3)
			(setq SR_AT  1)
			(setq SR_HT -1)
		))
		(if (= (Connect.get CastaData satr-vhtr) -1) (progn
			(setq Fall 4)
			(setq AT_LchbWinkel 0.0)
			(setq HT_LchbWinkel (- 180.0 HT_LchbWinkel))
			(setq SR_AT  1)
			(setq SR_HT  1)
		))
		
		(print "at-von-links") (print HT_LchbWinkel) (print AT_LchbWinkel) 
	))


	(if (= (Connect.get CastaData at-von-links) 1) (progn
		(print "At-von-links")
		(setq AT_LchbWinkel 180.0)
		(setq HT_LchbWinkel (+ HT_LchbWinkel 180.0))
		(if (>= HT_LchbWinkel 360.0) (setq HT_LchbWinkel (- HT_LchbWinkel 360.0)))
	))
	
	(print Fall)

	(traeger.addabtl Tr_ID Lchb_ID xPos_AT AT_LchbWinkel	 _steglochbild_system_)
	(traeger.addabtl HTrg Lchb_ID  xPos_HT HT_LchbWinkel     _flanschlochbild_of_)
	
	(setq Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil Lchb_ID))
	(setq Abtl_Lchb_HT (Traeger.get HTrg  ABTeil Lchb_ID))
	
	(print SR_AT) (print SR_HT)
	(if (= SR_AT SR_HT) (setq SR_AT 1 SR_HT 1))


	(Anbauteil.set Abtl_Lchb_AT (Master 1) (SeitRicht  SR_AT))
	(Anbauteil.set Abtl_Lchb_HT (Master 0) (SeitRicht  SR_HT))
	
	; -------------------------------
	(setq sinW (sin (/ (* PI HT_LchbWinkel) 180.0)))
	(setq cosW (cos (/ (* PI HT_LchbWinkel) 180.0)))
	(setq tanW (tan (/ (* PI HT_LchbWinkel) 180.0)))
	; (AlertBox HT_LchbWinkel) (AlertBox sinW) (ALertBox cosW)
	
	; Anteil vertikale Verschiebung des AT
	(setq dlr_Lchb_HT 0.0)
	(if (= (Connect.get CastaData sAtr-vHtr) -1) (progn
		(if (= (Connect.get CastaData at-von-rechts)  1) (setq dlr_Lchb_HT  (- dv_AT)))
		(if (= (Connect.get CastaData at-von-links) 1) (setq dlr_Lchb_HT       dv_AT))
	))
	(if (= (Connect.get CastaData sAtr-vHtr)  1) (progn
		(if (= (Connect.get CastaData at-von-links)  1) (setq dlr_Lchb_HT   (- dv_AT)))
		(if (= (Connect.get CastaData at-von-rechts) 1) (setq dlr_Lchb_HT    dv_AT))
	))

	(if (= (Connect.get CastaData sAtr-vHtr) -1) (progn
		(if (= (Connect.get CastaData at-von-rechts)  1) (print "Fall A"))
		(if (= (Connect.get CastaData at-von-links) 1)   (print "Fall B"))
	))
	(if (= (Connect.get CastaData sAtr-vHtr)  1) (progn
		(if (= (Connect.get CastaData at-von-links)  1)  (print "Fall C"))
		(if (= (Connect.get CastaData at-von-rechts) 1)  (print "Fall D"))
	))
;	(AlertBox dlr_Lchb_HT)
;	(setq dlr_Lchb_HT (- dlr_Lchb_HT))
;	(Lochbild.set Lchb_ID (e "0 25 75 0 0 0"))


	; Anteil seitliche Verschiebung des HT
	(setq dv_Lchb_HT (* sinW dlr_HT))
	(setq dlr_Lchb_HT_tmp (* cosW dlr_HT))
	(setq dlr_Lchb_HT (+ dlr_Lchb_HT dlr_Lchb_HT_tmp))

	(Anbauteil.set Abtl_Lchb_HT (delta_V   dv_Lchb_HT)	(delta_LR   dlr_Lchb_HT))
	(Anbauteil.set Abtl_Lchb_AT (delta_V   0.0) 		(delta_LR   0.0))
	
(if (= 2 3) (progn
	(if (= (Connect.get CastaData sAtr-vHtr) 1) (progn
			(if (= HT_LchbWinkel   0.0) (Lochbild.set Lchb_ID (LB_Art  2)))
			(if (= HT_LchbWinkel 180.0) (Lochbild.set Lchb_ID (LB_Art -2)))
	))
	(if (= (Connect.get CastaData sAtr-vHtr) -1) (progn
			(if (= HT_LchbWinkel   0.0) (Lochbild.set Lchb_ID (LB_Art -2)))
			(if (= HT_LchbWinkel 180.0) (Lochbild.set Lchb_ID (LB_Art  2)))
	))
))

	; (AlertBox AT_LchbWinkel)
	(if (= AT_LchbWinkel   0.0) (Lochbild.set Lchb_ID (LB_Art  2)))
	(if (= AT_LchbWinkel 180.0) (Lochbild.set Lchb_ID (LB_Art -2)))
	; (Lochbild.set Lchb_ID (LB_Art  2))
	
)
