; $	HT	QT(UI)	 	AF(FS)		P(EZ)
; $	AT	QT(L) 		AF(FS)		P(EZ)
; $	AE	V(-)		H(-)			R(-)

(defun load-modules ()
	(print "Module einladen")
)

(defun init-connection ()
	(print "*clear*")
	(print "Connection erstellen")
	(Connect.showAttributes CastaData)
	
	(analysiere_Lage) ; liefer kurzer_Schenkel / langer_Schenkel als Variable (0/1)
	(if (= AnschlussMoeglich 1) (progn
		
			; Kopfplatten-Objekt erzeugen und in Objektliste ablegen
	  (setq L_Lochb	(Lochbild.create))
	  (Connect.storeAnschlObjs CastaData L_Lochb)
	  
	  (initialisiere_Geometrie)		; Ht_Winkel, S_Verschiebung berechnen
	  (AT_TraegerEnde_anpassen)
	  (addCouponBlech)

	  (initialisiere_Lochbild)
	  (Lochbild_An_HT)
	  (Lochbild_An_AT)
	  (Lochbild_justieren)
	))
	(if (= AnschlussMoeglich 0) (progn
		(AlertBox "Anschluss nicht mglich"  "Connection_Not_Possible_Yet")
	))
  ; ------------------------------- Testbereich startet hier
	(if (= AnschlussMoeglich 1) (progn
		; Variablen prfen
		; (setq dlr_CP (Lochbild.get  L_Lochb  dlr_coupon))
		; (AlertBox dlr_CP)
		; (Lochbild.set L_Lochb (w0 0) (w1 40))
		; (Lochbild.set L_Lochb (e "0 25 75 0 0 0"))
		; (setq dv_Abtl_Lchb_AT		(Anbauteil.get  Abtl_Lchb_AT 	delta_V))
		; (Lochbild.set L_Lochb (dlr_Coupon 100))
		; (print dv_Abtl_Lchb_AT)
	))

)
(defun analysiere_Lage ()
   ; Kontakflchen - langer-Schenkel des AT an der Flche des HT
   ; oder kurzer Schenkel des AT  an der Flche des HT
	(setq  kurzer_Schenkel 0  langer_Schenkel 0)
   (if (=  (Connect.get CastaData satr-shtr)   1) (setq  langer_Schenkel 1))
   (if (=  (Connect.get CastaData satr-shtr)  -1) (setq  langer_Schenkel 1))
   (if (=  (Connect.get CastaData vatr-shtr)   1) (setq  kurzer_Schenkel 1))
   (if (=  (Connect.get CastaData vatr-shtr)  -1) (setq  kurzer_Schenkel 1))

	; (AlertBox langer_Schenkel) (AlertBox kurzer_Schenkel)

   (setq AnschlussMoeglich 0)
   (if (=  (Connect.get CastaData at-von-oben)  1) (progn
		(print "Branch -1-   (at-von-oben)")	; ist derzeit nicht als Anschluss erlaubt
   ))
   (if (=  (Connect.get CastaData at-von-unten)  1) (progn
		(print "Branch -2-   (at-von-unten)")
		(setq AnschlussMoeglich 1)				; nur bei AT von unten ist derzeit der Anschluss mglich
   ))

   ; rechts vorbei oder links vorbei
	(setq qsForm_HT (Traeger.get HTrg qsForm))
	(setq b_HT  (Traeger.get HTrg b))
	(setq dlr_HT (Traeger.get HTrg delta_LR))
	
	(setq b_HT_eff b_HT)
	(if (= qsForm_HT "I") (setq b_HT_eff (* 0.5 b_HT)))
	(if (= qsForm_HT "K") (setq b_HT_eff (* 0.5 b_HT)))
	(if (= qsForm_HT "U") (progn
		(if (=  (Connect.get CastaData vatr-shtr)  1) (setq b_HT_eff 0.0))
		(if (=  (Connect.get CastaData satr-shtr) -1) (setq b_HT_eff 0.0))
	))
	
	(setq amHT_rechts_vorbei 0  amHT_links_vorbei 0)
	(setq spaltBreite 0.0)
	(if (= langer_Schenkel 1) (progn
		(setq dlr_AT (Traeger.get Tr_ID delta_LR))
		(if (=  (Connect.get CastaData satr-shtr)  1) (progn
			(setq spaltBreite (- dlr_AT b_HT_eff dlr_HT))
			(if (> spaltBreite 0.0) (setq amHT_rechts_vorbei 1))
		))
		(if (=  (Connect.get CastaData satr-shtr)  -1) (progn
			(setq spaltBreite (- dlr_AT b_HT_eff (- dlr_HT)))
			(if (> spaltBreite 0.0) (setq amHT_links_vorbei 1))
		))
	))
		
	(if (= kurzer_Schenkel 1) (progn
		(setq dv_AT (Traeger.get Tr_ID delta_V))
		(if (=  (Connect.get CastaData vatr-shtr) -1) (progn
			(setq spaltBreite (- (- dv_AT) b_HT_eff dlr_HT))
			(if (> spaltBreite 0.0) (setq amHT_rechts_vorbei 1))
		))
		(if (=  (Connect.get CastaData vatr-shtr) 1) (progn
			(setq spaltBreite (- (- dv_AT) b_HT_eff (- dlr_HT)))
			(if (> spaltBreite 0.0) (setq amHT_links_vorbei 1))
		))
	))

	(if (= kurzer_Schenkel 1) (progn
		(if (= amHT_links_vorbei  1) (print "Kurzer Schenkel am HT links vorbei"))
		(if (= amHT_rechts_vorbei 1) (print "Kurzer Schenkel am HT rechts vorbei"))
	))
	(if (= langer_Schenkel 1) (progn
		(if (= amHT_links_vorbei  1) (print "Langer Schenkel am HT links vorbei"))
		(if (= amHT_rechts_vorbei 1) (print "Langer Schenkel am HT rechts vorbei"))
	))
	(print spaltBreite)
	
	(if (= qsForm_HT "U") (progn
		(if (= kurzer_Schenkel 0) (if (= langer_Schenkel 0) (setq AnschlussMoeglich 0)))
		(if (= amHT_links_vorbei 1) (setq AnschlussMoeglich 0))
	))
   
)
(defun initialisiere_Geometrie ()
	(setq Ht_Winkel 0.0)
	(setq S_Verschiebung 0.0)
	(setq SchenkelBreite_anlieg 0.0)
   
	(if (=  langer_Schenkel 1) (progn
			(print "langer Schenkel")
			(setq Ht_Winkel (Connect.get CastaData  v-atrgewnkl_flansch))
			(setq S_Verschiebung (Traeger.get Tr_ID delta_V))
			(print S_Verschiebung)
			(setq  SchenkelBreite_anlieg (Traeger.get Tr_ID h))
	))

	(if (=  kurzer_Schenkel  1) (progn
			(print "kurzer Schenkel")
			(setq Ht_Winkel (Connect.get CastaData  h-atrgewnkl_flansch))
			(setq S_Verschiebung (Traeger.get Tr_ID delta_LR))
			(print S_Verschiebung)
			(setq  SchenkelBreite_anlieg (Traeger.get Tr_ID b))
	))
	(setq  S_Verschiebung (* 1.0 S_Verschiebung))

	(setq sinV (sin (* PI (/ Ht_Winkel 180.0))))
	(setq cosV (cos (* PI (/ Ht_Winkel 180.0))))
	(setq tanV (tan (* PI (/ Ht_Winkel 180.0))))
	
    (print "Eingangswerte --------------------------- ")
	(print  S_Verschiebung)
	(print  SchenkelBreite_anlieg)

	; Bei U-Profilen muss die Ablngung und Schraubenlage korrigiert werden
	(setq HT_QsTyp (Traeger.get HTrg qsForm))
	
	
)
(defun initialisiere_Lochbild ()

	(Lochbild.set  L_Lochb
			(S_Bez	"M12")
			(Guete   "4.6")
			(LB_Art   2)
	)
)
; ----------------------------------------------------------------------------------------------------
(defun Lochbild_An_HT ()

	(setq SeitenRichtung  1)
	(setq S_Verschiebung_Lokal S_Verschiebung)	; S_Verschiebung wird zentral ausgerechnet
	(setq LB_HtWinkel (- HT_Winkel 90.0))		; HT_Winkel wird zentral ausgerechnet
  
	(setq d_L_Seitlich 0.0)
  	(if (= kurzer_Schenkel 1) (setq d_L_Seitlich (Traeger.get Tr_ID delta_V)))
	(if (= langer_Schenkel 1) (setq d_L_Seitlich (Traeger.get Tr_ID delta_V)))

   ; momentan ist nur von unten erlaubt - ist aber schon mal hier fr Erweiterung verankert
   (if (=  (Connect.get CastaData at-von-unten)  1) (progn
		(if (= amHT_rechts_vorbei 1) (progn 
			(print "at-von-unten - und amHT_rechts_vorbei")
			(setq SeitenRichtung  -1)
			(setq LB_HtWinkel (- LB_HtWinkel))
		))
		(if (= amHT_links_vorbei 1) (progn 
			(print "at-von-unten - und amHT_links_vorbei")
			(setq SeitenRichtung  1)
			(setq S_Verschiebung_Lokal (- S_Verschiebung_Lokal))
		))
   ))
   (print SeitenRichtung)

   
  (setq xPos_HT (Connect.get CastaData  xPos_HT))

  ; (traeger.addabtl hTrg L_Lochb xPos_HT 0.0 _steglochbild_system_)
	(if (= (Connect.get CastaData amHtStegLinks) 1)  (Traeger.addabtl Htrg L_Lochb xPos_HT 0.0 _couponlochbild_links_))
	(if (= (Connect.get CastaData amHtStegRechts) 1) (Traeger.addabtl HTrg L_Lochb xPos_HT 0.0 _couponlochbild_rechts_)) 

  
  
  (setq  Abtl_Lchb_HT (Traeger.get HTrg ABTeil  L_Lochb))
  
  ; seitliche/vertikale Verschiebung  des AT

	(setq dl_Kuerzen (/  SchenkelBreite_anlieg tanV))
	(if (< tanV 0.0) (setq  dl_Kuerzen (- dl_Kuerzen)))
	(if (> tanV 0.0)  (progn
		(if (= (Connect.get CastaData sAtr-lHtr)  -1) (setq dl_Kuerzen 0.0))
	))
	(if (< tanV 0.0)  (progn
		(if (= (Connect.get CastaData vAtr-lHtr)  -1) (setq dl_Kuerzen 0.0))
	))
  
	(setq dlv_HT	(Traeger.get HTrg delta_V))
	(setq h_HT		(Traeger.get HTrg h))
	(setq  dl_v_Versch (/  (- S_Verschiebung_Lokal) tanV))
		
	(if (= Ht_Winkel 90.0) (progn
				(setq dl_h_Lochb 0.0)
				(setq dl_V_Lochb 0.0)
				(setq  dl_h_Lochb (+ dl_h_Lochb  S_Verschiebung_Lokal))
		)
		(progn
				(setq dl_h_Lochb (* cosV  dlv_HT))
				(setq dl_h_Lochb 0.0)
				(setq Anteil_H_hor 0.0)

				(setq dl_h_Lochb (/ (* -1.0 dlv_HT) tanV))
				(setq Anteil_H_hor (/ (* 0.5 h_HT) tanV))
				(print "Zwischenkontrolle") (print dl_h_Lochb) (print Anteil_H_hor)
				 (print sinV) (print cosV) (print tanV)
				

				(if (= amHT_links_vorbei 1) (setq dl_h_Lochb  (+ dl_h_Lochb Anteil_H_hor)))
				(if (= amHT_rechts_vorbei 1) (setq dl_h_Lochb (- (+ Anteil_H_hor dl_h_Lochb))))
			
				(setq dl_V_Lochb 0.0)
				(setq  dl_h_Lochb (+ dl_h_Lochb  (/ S_Verschiebung_Lokal sinV)))
				
	))
		
		

	(setq dl_H_HT     0.0)
	(setq qs_ist_IU 0)
	(if (= HT_QsTyp "U") (setq qs_ist_IU 1))
	(if (= HT_QsTyp "I") (setq qs_ist_IU 1))
	(if (= qs_ist_IU 1) (progn
				(setq h_HT (Traeger.get HTrg h))
				(if (= Ht_Winkel 90.0) 
					(setq dl_H_HT     (* 0.5  h_HT))
					(setq dl_H_HT (/ (* 0.5  h_HT) cosV))
				)
	))

	(setq h_HT (Traeger.get HTrg h))
	(setq SeitenRichtung 1)

	(if (= (Connect.get CastaData at-von-unten) 1) (progn
		(if (= (Connect.get CastaData amHtStegRechts) 1) (setq SeitenRichtung (- SeitenRichtung)))
	))

		
	(print b_HT_eff)
		; b_HT_eff wird bei der Lagenanalyse berechnet
	(print "Seitenverschiebung am HT 2 -------------------") (print dl_h_Lochb) (print "_______________")
	(print  dl_h_Lochb) (print  dl_V_Lochb)
	(Anbauteil.set  Abtl_Lchb_HT 	(Master  0)
										(Winkel  LB_HtWinkel)
										(delta_LR  dl_h_Lochb)
										(delta_V   dl_V_Lochb)
										(delta_SX  b_HT_eff)
										(SeitRicht SeitenRichtung)
	)
	(if (= (Connect.get CastaData amhtsteglinks) 1)
			(Anbauteil.set  Abtl_Lchb_HT 	(delta_SX  (- b_HT_eff)))
	)
			
	(print "Zwischenwertausgabe - AT-Lochbildverschiebung ... --------------") (print  dl_V_Lochb)


	; Schraubenkopfposition und KlemmLaenge
	(setq t_AT	(Traeger.get	Tr_ID 			t))
	(setq dp_Bl	(Blech.get		cpFrontBlech 	dp))
	(setq KlemmLaenge  (+ t_AT dp_Bl))
	(setq dxSK			0)

	(Lochbild.set  L_Lochb
			(KlemmL  KlemmLaenge)
			(dxSKopf dxSK)
	)


 
)
(defun Lochbild_An_AT ()

	(setq At_Winkel  0.0)
	(setq SeitenRichtung  1)
	(setq dSX 0)
 
	(setq xPos_AT (Connect.get CastaData  xPos_AT))
  
	(setq sL_k 	(Traeger.get Tr_ID b)
           sL_l 		(Traeger.get Tr_ID h)
		   t_AT 		(Traeger.get Tr_ID t)
	)
	(setq dlv_HT	(Traeger.get HTrg delta_V))
	(setq dlv_HT	 (- dlv_HT))
  
	(if (=  (Connect.get CastaData amAtUnterflansch) 1) (progn
        (setq w0 (+ (* 0.5 (- sL_k t_AT))  t_AT) )
		(Lochbild.set  L_Lochb (w0 w0))
		(traeger.addabtl Tr_ID L_Lochb xPos_AT 0.0 _flanschlochbild_uf_)
		
		(setq dSX (Lochbild.get L_Lochb dlr_Coupon))
		; hier dlr_Coupon zurckstellen, da das ganze Lochbild verschoben wird und nicht nur
		; das Winkel-Lochbild ber das Anbauteil
		(Lochbild.set  L_Lochb (dlr_Coupon 0.0))
	))
	(if (=  (Connect.get CastaData amAtSteg)  1) (progn
        (setq w0 (+ (* 0.5 (- sL_l t_AT))  t_AT) )
		(Lochbild.set  L_Lochb (w0 w0))
		(traeger.addabtl Tr_ID L_Lochb xPos_AT 0.0 _steglochbild_system_)
	))

	(if (=  (Connect.get CastaData at-von-unten)  1) (progn
		(setq  At_Winkel 180.0)
		(setq SeitenRichtung  (- SeitenRichtung))
	))


	(setq  Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil  L_Lochb))
	
	(Anbauteil.set  Abtl_Lchb_AT 	
							(Winkel  At_Winkel)
							(Master 		1)
							(SeitRicht	SeitenRichtung)
							(Delta_SX 	dSX)
	)

	; Initialisieren, falls es nicht am Trgerende festgelegt wird.
	(setq  dlv_HT (Anbauteil.get  Abtl_Lchb_AT  delta_V))
	(setq  	h_HT	(Traeger.get  HTrg  h)
			dv_HT	(Traeger.get  HTrg  delta_V)
	)
	
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
			(setq TrgEnde (Traeger.get Tr_ID links))
			(setq  dlv_HT (TrEnde.get  TrgEnde delta_L))
	))
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
			(setq TrgEnde (Traeger.get Tr_ID links))
			(setq  dlv_HT (TrEnde.get  TrgEnde delta_L))
	))
	
	(setq dlv_HT  0.0)
	(if (=  (Connect.get CastaData at-von-unten)  1) (progn
		(if (=  Ht_Winkel 90.0) (progn
			(setq dlv_HT (+ (* -0.5 h_HT) dv_HT))
		))
		(if (/= HT_Winkel 90.0) (progn
			(setq dSeitlich 0.0)
			(if (= Langer_Schenkel 1) (setq dSeitlich (Traeger.get Tr_ID delta_V)))
			(if (= Kurzer_Schenkel 1) (setq dSeitlich (Traeger.get Tr_ID delta_LR)))

			(setq dlv_lr_AT (/ (* 1.0 dSeitlich) tanV))
			(setq dlv_HT (/ (+ (* -0.5 h_HT) dv_HT) sinV))
			(setq dlv_HT (+ dlv_HT dlv_lr_AT))
		))
	))

	
	; (setq dlv_HT (- dlv_HT h_HT))
;	(if (=  Ht_Winkel 90.0) (progn
		(Anbauteil.set  Abtl_Lchb_AT 	
							(delta_V	dlv_HT)
		)
;	))


	(print "Zwischenwertausgabe - AT-Lochbildverschiebung ... --------------") (print  dlv_HT)
)

(defun  AT_TraegerEnde_anpassen ()
	(setq h_HT (Traeger.get HTrg h))
	(setq dlv_HT	(Traeger.get HTrg delta_V))
	(setq dlv_HT	(* 1.0 dlv_HT))
	(setq dl_Laenge (- dlv_HT))
	
	(setq dl_AT_Breite 0.0)
	(if (= (Connect.get CastaData amhtsteglinks) 1)
		(if (= langer_Schenkel 1) (setq  dl_AT_Breite (Traeger.get Tr_ID h)))
	)
	(if (= (Connect.get CastaData amhtstegrechts) 1)
		(if (= kurzer_Schenkel 1) (setq  dl_AT_Breite (Traeger.get Tr_ID b)))
	)
	
	(print "Trgerende bearbeiten ----------------------------- ")
	(print  Ht_Winkel)
	(setq qs_ist_IU 0)
	(if (= HT_QsTyp "U") (setq qs_ist_IU 1))
	(if (= HT_QsTyp "I") (setq qs_ist_IU 1))

	(if (/=  Ht_Winkel 90.0) (progn
		(if (= qs_ist_IU 1) (progn
			(setq dl_H_HT (* 0.5  h_HT) )
			(setq dl_Laenge (- dl_Laenge dl_H_HT))
			(setq dl_Laenge (/ dl_Laenge sinV))
			
			(setq dSchraeg (* dl_AT_Breite cosV))
			(if (< dSchraeg 0.0) (setq dl_Laenge (- dl_Laenge dSchraeg)))
			(if (> dSchraeg 0.0) (setq dl_Laenge (+ dl_Laenge dSchraeg)))
		))
	))

	(if (=  Ht_Winkel 90.0) (progn
		(if (= qs_ist_IU 1) (progn
			(setq dl_H_HT (* 0.5  h_HT) )
			(setq dl_Laenge (- dl_Laenge dl_H_HT))
		))
	))

	
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
			(setq trgEnde (Traeger.get Tr_ID links))
			(TrEnde.set  trgEnde (delta_L dl_Laenge))
	
	))
	(if (= (Connect.get CastaData  rechtesEnde) 1) (progn
			(setq trgEnde (Traeger.get Tr_ID rechts))
			(TrEnde.set  trgEnde (delta_L dl_Laenge))
	))

	(print "-----------------------------------")
	; (Connect.showAttributes CastaData)
	
)

(defun Lochbild_justieren ()
	; verfgbarer Abstand ist die geschnittene HT-Hhe
	; abzglich des Dreiecks durch die Winkelbreite.
	; Auf der einen Seite ist diese bereits bercksichtigt, (sofern am AT-Ende angeschlossen wird
	(setq h_HT	(Traeger.get HTrg h))
	(setq dl_Dreieck 0.0)
	(if (/= HT_Winkel 90.0)   (setq dl_Dreieck (/ SchenkelBreite_anlieg tanV)))
	
	(setq h_Gesamt  h_HT)
	(if (<  sinV 0.0)  (setq h_Gesamt (/ (- h_HT) sinV)))
	(if (>  sinV 0.0) 	(setq h_Gesamt (/     h_HT  sinV)))
	(if (> tanV 0.0)  (progn
		(setq  h_Gesamt (- h_Gesamt dl_Dreieck))
	))
	(if (< tanV 0.0)  (progn
		(setq  h_Gesamt (+ h_Gesamt dl_Dreieck))
	))

	
	(setq e_Abstand (/  h_Gesamt 4))
	(setq e0_Neu  e_Abstand)
	(print  e_Abstand)

	(Lochbild.set  L_Lochb (e0  e_Abstand) (e1 (* 2 e_Abstand)) (e2 0))

;	(Lochbild.set  L_Lochb (e0  0) (e1 h_Gesamt))
;	(print  e0_Neu)
;	(Lochbild.set  L_Lochb (e0  0))
;	(Lochbild.set  L_Lochb (e1  20) (e2 80))
;	(Lochbild.set  L_Lochb (e1  h_Gesamt) (e2 0))


	; ---------------------- sollte weg knnen
	(if (= 1 2) (progn
		(setq  Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil  L_Lochb))

		(if (= (Connect.get CastaData linkesEnde) 1) (progn
				(setq trgEnde (Traeger.get Tr_ID links))
				(setq delta_L (TrEnde.get  trgEnde delta_L))
				(setq  e0_Neu (- delta_L))
		))
		(if (= (Connect.get CastaData  rechtesEnde) 1) (progn
				(setq trgEnde (Traeger.get Tr_ID rechts))
				(setq delta_L (TrEnde.get  trgEnde delta_L))
				(setq  e0_Neu delta_L)
		))

		(setq  Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil  L_Lochb))
		(setq xPos_Lchb (Anbauteil.get  Abtl_Lchb_AT xPos))
		(print  xPos_Lchb)
		(setq  Ht_Winkel (- 90.0 Ht_Winkel))
		(Anbauteil.set  Abtl_Lchb_AT 	
								(delta_V	delta_L)
		)
	))
	
)

(defun addCouponBlech ()

	(setq cpFrontBlech 	(Blech.Create))
	(setq h_HT (Traeger.get HTrg h))
	(setq sL_Laenge (Traeger.get Tr_ID h))
	(if (= kurzer_Schenkel 1) (setq sL_Laenge (Traeger.get Tr_ID b)))
	(setq sL_Laenge (+ sL_Laenge 10))
	(setq SeitVersch (- (* 0.5 sL_Laenge) 5))
	
	(setq d_L_Seitlich 0.0)
	(if (= kurzer_Schenkel 1) (progn
		(setq d_L_Seitlich (Traeger.get Tr_ID delta_LR))
		(if (= (Connect.get CastaData satr-lhtr) -1) (setq SeitVersch (* -0.5 sL_Laenge)))
		
		(if (= (Connect.get CastaData amhtstegLinks)  1) (setq SeitVersch (- SeitVersch d_L_Seitlich)))
		(if (= (Connect.get CastaData amhtstegRechts) 1) (setq SeitVersch (+ SeitVersch d_L_Seitlich)))
	))
	(if (= langer_Schenkel 1) (progn
		(setq d_L_Seitlich (Traeger.get Tr_ID delta_V))
		(if (= (Connect.get CastaData vatr-lhtr)  1) (setq SeitVersch (* -0.5 sL_Laenge)))

		(if (= (Connect.get CastaData amhtstegLinks)  1) (setq SeitVersch (- SeitVersch d_L_Seitlich)))
		(if (= (Connect.get CastaData amhtstegRechts) 1) (setq SeitVersch (+ SeitVersch d_L_Seitlich)))
	))
	
	; Seitverschiebung aufgrund seitlichem AT-Versatz
	
	
	(Blech.set cpFrontBlech (dp spaltBreite)
							(hp (- h_HT 10))
							(bp sL_Laenge)
							(dOK 5)
							(xAsym SeitVersch)
	)

	; Blech wird dann so breit gestaltet, dass es den schrgen Winkel komplett abdeckt.
	(if (/= HT_Winkel 90.0) (progn
		(setq bp_schraegBl (/ h_HT sinV))
		(Blech.set cpFrontBlech (bp (+ sL_Laenge (* 0.5 bp_schraegBl))))
	))
	
	
	(setq xPos_HT (Connect.get CastaData  xPos_HT))

	(if (= amHT_links_vorbei  1) (Traeger.addabtl Htrg cpFrontBlech xPos_HT 0.0 _blechcoupon_links_))
	(if (= amHT_rechts_vorbei 1) (Traeger.addabtl Htrg cpFrontBlech xPos_HT 0.0 _blechcoupon_rechts_))
	(Connect.storeAnschlObjs CastaData  cpFrontBlech)
	

)
