; $	HT	QT(UL)	 	AF(FS)		P(EZ)
; $	AT	QT(L) 		AF(FS)		P(EZ)
; $	AE	V(-)		H(-)			R(-)

(defun load-modules ()
	(print "Module einladen")
)

(defun init-connection ()
	(print "*clear*")
	(print "Connection erstellen")
	(Connect.showAttributes CastaData)
	(analysiere_Lage) ; liefer kurzer_Schenkel / langer_Schenkel als Variable (0/1)
	(initialisiere_Geometrie)		; Ht_Winkel, S_Verschiebung berechnen

	(if (= AnschlussMoeglich 1) (progn
		
			; Kopfplatten-Objekt erzeugen und in Objektliste ablegen
	  (setq L_Lochb	(Lochbild.create))
	  (Connect.storeAnschlObjs CastaData L_Lochb)
	  
;	  (initialisiere_Geometrie)		; Ht_Winkel, S_Verschiebung berechnen
	  (AT_TraegerEnde_anpassen)

	  (initlialisiere_Lochbild)
	  (Lochbild_An_HT)
	  (Lochbild_An_AT)
	  (Lochbild_justieren)
	))
	(if (= AnschlussMoeglich 0) (progn
		(AlertBox "Anschluss nicht mglich"  "Connection_Not_Possible_Yet")
	))
  ; ------------------------------- Testbereich startet hier
	(if (= AnschlussMoeglich 1) (progn
		; Variablen prfen
		; (setq dlr_CP (Lochbild.get  L_Lochb  dlr_coupon))
		; (AlertBox dlr_CP)
		; (Lochbild.set L_Lochb (w0 0))
		; (Lochbild.set L_Lochb (e "0 25 75 0 0 0"))
		(setq dv_Abtl_Lchb_AT		(Anbauteil.get  Abtl_Lchb_AT 	delta_V))
		(print dv_Abtl_Lchb_AT)
	))

)
(defun analysiere_Lage ()
   ; Kontakflchen - langer-Schenkel des AT an der Flche des HT
   ; oder kurzer Schenkel des AT  an der Flche des HT
	(setq  kurzer_Schenkel 0  langer_Schenkel 0)
   (if (=  (Connect.get CastaData satr-shtr)   1) (setq  langer_Schenkel 1))
   (if (=  (Connect.get CastaData satr-shtr)  -1) (setq  langer_Schenkel 1))
   (if (=  (Connect.get CastaData vatr-shtr)   1) (setq  kurzer_Schenkel 1))
   (if (=  (Connect.get CastaData vatr-shtr)  -1) (setq  kurzer_Schenkel 1))

	; (AlertBox langer_Schenkel) (AlertBox kurzer_Schenkel)

   (setq AnschlussMoeglich 0)
   (if (=  (Connect.get CastaData at-von-oben)  1) (progn
		(print "Branch -1-   (at-von-oben)")
   ))
   (if (=  (Connect.get CastaData at-von-unten)  1) (progn
		(print "Branch -2-   (at-von-unten)")
		(setq AnschlussMoeglich 1)			; nur bei AT von unten ist derzeit der Anschluss mglich
   ))

   ; rechts vorbei oder links vorbei
	(setq qsForm_HT (Traeger.get HTrg qsForm))
	(setq b_HT  (Traeger.get HTrg b))
	(setq dlr_HT (Traeger.get HTrg delta_LR))
	
	(setq b_HT_eff b_HT)
	(if (= qsForm_HT "I") (setq b_HT_eff (* 0.5 b_HT)))
	(if (= qsForm_HT "K") (setq b_HT_eff (* 0.5 b_HT)))
	(if (= qsForm_HT "U") (progn
		(if (=  (Connect.get CastaData vatr-shtr)  1) (setq b_HT_eff 0.0))
		(if (=  (Connect.get CastaData satr-shtr) -1) (setq b_HT_eff 0.0))
	))
	
	(setq amHT_rechts_vorbei 0  amHT_links_vorbei 0)
	(setq spaltBreite 0.0)
	(if (= langer_Schenkel 1) (progn
		(setq dlr_AT (Traeger.get Tr_ID delta_LR))
		(if (=  (Connect.get CastaData satr-shtr)  1) (progn
			(setq spaltBreite (- dlr_AT b_HT_eff dlr_HT))
			(if (> spaltBreite 0.0) (setq amHT_rechts_vorbei 1))
		))
		(if (=  (Connect.get CastaData satr-shtr)  -1) (progn
			(setq spaltBreite (- dlr_AT b_HT_eff (- dlr_HT)))
			(if (> spaltBreite 0.0) (setq amHT_links_vorbei 1))
		))
	))
		
	(if (= kurzer_Schenkel 1) (progn
		(setq dv_AT (Traeger.get Tr_ID delta_V))
		(if (=  (Connect.get CastaData vatr-shtr) -1) (progn
			(setq spaltBreite (- (- dv_AT) b_HT_eff dlr_HT))
			(if (> spaltBreite 0.0) (setq amHT_rechts_vorbei 1))
		))
		(if (=  (Connect.get CastaData vatr-shtr) 1) (progn
			(setq spaltBreite (- (- dv_AT) b_HT_eff (- dlr_HT)))
			(if (> spaltBreite 0.0) (setq amHT_links_vorbei 1))
		))
	))

	(if (= kurzer_Schenkel 1) (progn
		(if (= amHT_links_vorbei  1) (print "Kurzer Schenkel am HT links vorbei"))
		(if (= amHT_rechts_vorbei 1) (print "Kurzer Schenkel am HT rechts vorbei"))
	))
	(if (= langer_Schenkel 1) (progn
		(if (= amHT_links_vorbei  1) (print "Langer Schenkel am HT links vorbei"))
		(if (= amHT_rechts_vorbei 1) (print "Langer Schenkel am HT rechts vorbei"))
	))
	(print spaltBreite)
	
	(if (= qsForm_HT "U") (progn
		(if (= kurzer_Schenkel 0) (if (= langer_Schenkel 0) (setq AnschlussMoeglich 0)))
		(if (= amHT_rechts_vorbei 1) (setq AnschlussMoeglich 0))
	))
   
   ; Man knnte auch noch ein Futterblech vorsehen - dann bis Spaltbreite 20 erlauben
   (if (> spaltBreite 2) (setq AnschlussMoeglich 0))
   
)
(defun initialisiere_Geometrie ()
	(setq Ht_Winkel 0.0)
	(setq S_Verschiebung 0.0)
	(setq SchenkelBreite_anlieg 0.0)
   
	(if (=  langer_Schenkel 1) (progn
			(print "langer Schenkel")
			(setq Ht_Winkel (Connect.get CastaData  v-atrgewnkl_flansch))
			(setq S_Verschiebung (Traeger.get Tr_ID delta_V))
			(print S_Verschiebung)
			(setq  SchenkelBreite_anlieg (Traeger.get Tr_ID h))
	))

	(if (=  kurzer_Schenkel  1) (progn
			(print "kurzer Schenkel")
			(setq Ht_Winkel (Connect.get CastaData  h-atrgewnkl_flansch))
			(setq S_Verschiebung (Traeger.get Tr_ID delta_LR))
			(print S_Verschiebung)
			(setq  SchenkelBreite_anlieg (Traeger.get Tr_ID b))
	))
	(setq  S_Verschiebung (* 1.0 S_Verschiebung))

	(setq sinV (sin (* PI (/ Ht_Winkel 180.0))))
	(setq cosV (cos (* PI (/ Ht_Winkel 180.0))))
	(setq tanV (tan (* PI (/ Ht_Winkel 180.0))))
	
    (print "Eingangswerte --------------------------- ")
	(print  S_Verschiebung)
	(print  SchenkelBreite_anlieg)

	; Bei U-Profilen muss die Ablngung und Schraubenlage korrigiert werden
	(setq HT_QsTyp (Traeger.get HTrg qsForm))
	
	
)
(defun initlialisiere_Lochbild ()

	(setq t_HT (Traeger.get HTrg 	t))
	(setq t_AT (Traeger.get Tr_ID 	t))
	(setq KlemmLaenge  (+ t_HT t_AT))
	(setq dxSK			t_AT)

	(Lochbild.set  L_Lochb
			(S_Bez	"M12")
			(Guete   "4.6")
			(LB_Art   2)
;			(e    "0 20 100 0 0 0")
;			(w    "0 0")
			(KlemmL  KlemmLaenge)
			(dxSKopf dxSK)
	)
)
; ----------------------------------------------------------------------------------------------------
(defun Lochbild_An_HT ()

  (setq SeitenRichtung  -1)
   (if (=  (Connect.get CastaData at-von-oben)  1) (progn
		(setq  S_Verschiebung (- S_Verschiebung))
		(setq SeitenRichtung  0)
   ))


  (setq xPos_HT (Connect.get CastaData  xPos_HT))
  (traeger.addabtl hTrg L_Lochb xPos_HT 0.0 _steglochbild_system_)

  (setq  Abtl_Lchb_HT (Traeger.get HTrg ABTeil  L_Lochb))

  ; seitliche/vertikale Verschiebung  des AT
  
  
  (Anbauteil.set  Abtl_Lchb_HT 	(Winkel  Ht_Winkel)
												(Master  1)
												(SeitRicht SeitenRichtung)
												(delta_LR  S_Verschiebung)
  )

	(setq dl_Kuerzen (/  SchenkelBreite_anlieg tanV))
	(if (< tanV 0.0) (setq  dl_Kuerzen (- dl_Kuerzen)))
	(if (> tanV 0.0)  (progn
		(if (= (Connect.get CastaData sAtr-lHtr)  -1) (setq dl_Kuerzen 0.0))
	))
	(if (< tanV 0.0)  (progn
		(if (= (Connect.get CastaData vAtr-lHtr)  -1) (setq dl_Kuerzen 0.0))
	))
  
	(print  Ht_Winkel)
;	(if (/=  Ht_Winkel 90.0) (progn
		(setq dlv_HT	(Traeger.get HTrg delta_V))

;; ---->
		(setq  dl_v_Versch (/  (- S_Verschiebung) tanV))
		
		(if (= Ht_Winkel 90.0) (progn
				(setq dl_h_Lochb 0.0)
				(setq dl_V_Lochb (- dl_Kuerzen))
				(setq dl_V_Lochb (- dl_V_Lochb  dl_v_Versch))
		
			)
			(progn
				(setq dl_h_Lochb (* cosV  dlv_HT))
				(setq dl_V_Lochb (/  dl_h_Lochb tanV))
				(setq dl_V_Lochb (- dl_V_Lochb  dl_Kuerzen))
				(setq dl_V_Lochb (- dl_V_Lochb  dl_v_Versch))
		))
		
		
		(setq  dl_h_Lochb (+ dl_h_Lochb  S_Verschiebung))

		(if (= HT_QsTyp "U") (progn
				(setq h_HT (Traeger.get HTrg h))
				(setq dl_H_HT     0.0)
				(if (= Ht_Winkel 90.0) 
					(setq dl_H_HT     (* 0.5  h_HT))
					(setq dl_H_HT (/ (* 0.5  h_HT) cosV))
				)
				(setq dl_V_Lochb (+ dl_V_Lochb dl_H_HT))
		))

		
		
		(print  dl_h_Lochb) (print  dl_V_Lochb)
		(Anbauteil.set  Abtl_Lchb_HT 	
										(delta_LR  dl_h_Lochb)
										(delta_V  (- dl_V_Lochb))
		)
		(print "Zwischenwertausgabe - AT-Lochbildverschiebung ... --------------") (print  dl_V_Lochb)

;	))
	
  
)
(defun Lochbild_An_AT ()

	(setq At_Winkel  0)
   (setq SeitenRichtung  0)
 
	(setq xPos_AT (Connect.get CastaData  xPos_AT))
  
	(setq sL_k 	(Traeger.get Tr_ID b)
           sL_l 		(Traeger.get Tr_ID h)
		   t_AT 		(Traeger.get Tr_ID t)
	)
	(setq dlv_HT	(Traeger.get HTrg delta_V))
	(setq dlv_HT	 (- dlv_HT))
  
	(if (=  (Connect.get CastaData amAtUnterflansch) 1) (progn
        (setq w0 (+ (* 0.5 (- sL_k t_AT))  t_AT) )
		(Lochbild.set  L_Lochb (w0 w0))
		(traeger.addabtl Tr_ID L_Lochb xPos_AT 0.0 _flanschlochbild_uf_)
		; hier dlr_Coupon zurckstellen, da das ganze Lochbild verschoben wird und nicht nur
		; das Winkel-Lochbild ber das Anbauteil
		(Lochbild.set  L_Lochb (dlr_Coupon 0.0))
	))
	(if (=  (Connect.get CastaData amAtSteg)  1) (progn
        (setq w0 (+ (* 0.5 (- sL_l t_AT))  t_AT) )
		(Lochbild.set  L_Lochb (w0 w0))
		(traeger.addabtl Tr_ID L_Lochb xPos_AT 0.0 _steglochbild_system_)
	))
	(if (=  (Connect.get CastaData at-von-oben)  1) (progn
		(setq  At_Winkel (+ At_Winkel 180.0))
		(if (> At_Winkel 180.0) (setq At_Winkel (- At_Winkel 360.0)))
		(setq SeitenRichtung  -1)
	))

	(setq  Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil  L_Lochb))
	
;	(setq  Ht_Winkel (- 90.0 Ht_Winkel))
	(Anbauteil.set  Abtl_Lchb_AT 	
							(Winkel  At_Winkel)
							(Master 		0)
							(SeitRicht	SeitenRichtung)
	)

	; Initialisieren, falls es nicht am Trgerende festgelegt wird.
	(setq  dlv_HT (Anbauteil.get  Abtl_Lchb_AT  delta_V))
	(setq  h_HT  (Traeger.get  HTrg  h))
	
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
			(setq TrgEnde (Traeger.get Tr_ID links))
			(setq  dlv_HT (TrEnde.get  TrgEnde delta_L))
	))
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
			(setq TrgEnde (Traeger.get Tr_ID links))
			(setq  dlv_HT (TrEnde.get  TrgEnde delta_L))
	))
	
	; (setq dlv_HT (- dlv_HT h_HT))
;	(if (/=  Ht_Winkel 90.0) (progn
		(Anbauteil.set  Abtl_Lchb_AT 	
							(delta_V	dlv_HT)
		)
;	))

	(print "Zwischenwertausgabe - AT-Lochbildverschiebung ... --------------") (print  dlv_HT)
)

(defun  AT_TraegerEnde_anpassen ()
	(setq dlv_HT	(Traeger.get HTrg delta_V))
	(setq   dlv_HT (* 1.0 dlv_HT))
	(setq dl_Laenge (- dlv_HT))
	
	(setq dl_AT_Breite 0.0)
	(if (= langer_Schenkel 1) (setq  dl_AT_Breite (Traeger.get Tr_ID h)))
	(if (= kurzer_Schenkel 1) (setq  dl_AT_Breite (Traeger.get Tr_ID b)))
	
	(print "Trgerende bearbeiten ----------------------------- ")
	(print  Ht_Winkel)
	(if (/=  Ht_Winkel 90.0) (progn
			(setq dl_Laenge (* S_Verschiebung  tanV))
			; (if (> tanV 0.0) (setq  dl_Laenge (- dl_Laenge)))
			(setq dl_Kuerzen 0.0)
			(if (/= tanV 0.0) (setq dl_Kuerzen (/  (* 1.0 dl_AT_Breite) tanV)))
			(if (< tanV 0.0) (setq  dl_Kuerzen (- dl_Kuerzen)))
			(if (> tanV 0.0)  (progn
				(if (= (Connect.get CastaData sAtr-lHtr)  -1) (setq dl_Kuerzen 0.0))
			))
			(if (< tanV 0.0)  (progn
				(if (= (Connect.get CastaData vAtr-lHtr)  -1) (setq dl_Kuerzen 0.0))
			))
			
			(setq dl_hVersch 0.0)
			(if (/= tanV 0.0) (setq dl_hVersch (/  (- S_Verschiebung) tanV)))
			
			(setq dlv_HT 0.0)
			(if (/= tanV 0.0) (setq dlv_HT (/ dlv_HT  sinV)))

			(setq dl_Laenge (- dlv_HT))
			(setq dl_Laenge (+  dl_Laenge dl_Kuerzen))
			(setq dl_Laenge (+ dl_Laenge  dl_hVersch))
			
			(if (= HT_QsTyp "U") (progn
				(setq h_HT (Traeger.get HTrg h))
				(setq dl_H_HT (/ (* 0.5  h_HT) cosV))
				(setq dl_Laenge (- dl_Laenge dl_H_HT))
			))
			
			
			(print  tanV)
			(print  dl_AT_Breite)
			(print  dl_Kuerzen)
			(print  dl_Laenge)
	))

	(if (=  Ht_Winkel 90.0) (progn
		(if (= HT_QsTyp "U") (progn
				(setq h_HT (Traeger.get HTrg h))
				(setq dl_H_HT (* 0.5  h_HT) )
				(setq dl_Laenge (- dl_Laenge dl_H_HT))
		))
	))

	
	
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
			(setq trgEnde (Traeger.get Tr_ID links))
			(TrEnde.set  trgEnde (delta_L dl_Laenge))
	
	))
	(if (= (Connect.get CastaData  rechtesEnde) 1) (progn
			(setq trgEnde (Traeger.get Tr_ID rechts))
			(TrEnde.set  trgEnde (delta_L dl_Laenge))
	))

	(print "-----------------------------------")
	; (Connect.showAttributes CastaData)
	
)

(defun Lochbild_justieren ()
	; verfgbarer Abstand ist die geschnittene HT-Hhe
	; abzglich des Dreiecks durch die Winkelbreite.
	; Auf der einen Seite ist diese bereits bercksichtigt, (sofern am AT-Ende angeschlossen wird
	(setq h_HT	(Traeger.get HTrg h))
	(setq dl_Dreieck 0.0)
	(if (/= HT_Winkel 90.0)   (setq dl_Dreieck (/ SchenkelBreite_anlieg tanV)))
	
	(setq h_Gesamt  h_HT)
	(if (<  sinV 0.0)  (setq h_Gesamt (/ (- h_HT) sinV)))
	(if (>  sinV 0.0) 	(setq h_Gesamt (/     h_HT  sinV)))
	(if (> tanV 0.0)  (progn
		(setq  h_Gesamt (- h_Gesamt dl_Dreieck))
	))
	(if (< tanV 0.0)  (progn
		(setq  h_Gesamt (+ h_Gesamt dl_Dreieck))
	))

	
	(setq e_Abstand (/  h_Gesamt 4))
	(setq e0_Neu  e_Abstand)
	(print  e_Abstand)

	(Lochbild.set  L_Lochb (e0  e_Abstand) (e1 (* 2 e_Abstand)) (e2 0))

;	(Lochbild.set  L_Lochb (e0  0) (e1 h_Gesamt))
;	(print  e0_Neu)
;	(Lochbild.set  L_Lochb (e0  0))
;	(Lochbild.set  L_Lochb (e1  20) (e2 80))
;	(Lochbild.set  L_Lochb (e1  h_Gesamt) (e2 0))


	; ---------------------- sollte weg knnen
	(if (= 1 2) (progn
		(setq  Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil  L_Lochb))

		(if (= (Connect.get CastaData linkesEnde) 1) (progn
				(setq trgEnde (Traeger.get Tr_ID links))
				(setq delta_L (TrEnde.get  trgEnde delta_L))
				(setq  e0_Neu (- delta_L))
		))
		(if (= (Connect.get CastaData  rechtesEnde) 1) (progn
				(setq trgEnde (Traeger.get Tr_ID rechts))
				(setq delta_L (TrEnde.get  trgEnde delta_L))
				(setq  e0_Neu delta_L)
		))

		(setq  Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil  L_Lochb))
		(setq xPos_Lchb (Anbauteil.get  Abtl_Lchb_AT xPos))
		(print  xPos_Lchb)
		(setq  Ht_Winkel (- 90.0 Ht_Winkel))
		(Anbauteil.set  Abtl_Lchb_AT 	
								(delta_V	delta_L)
		)
	))

	
)