; $	HT	QT(IUK)	 	AF(FS)		P(EZ)
; $	AT	QT(L) 		AF(FS)		P(EZ)
; $	AE	V(-)		H(-)			R(-)

(defun load-modules ()
	(print "Module einladen")
)

(defun init-connection ()
	(print "*clear*")
	(print "Connection erstellen")
	(Connect.showAttributes CastaData)
	
	(analysiere_Lage) ; liefer kurzer_Schenkel / langer_Schenkel als Variable (0/1)
	(initialisiere_Geometrie)		; Ht_Winkel, S_Verschiebung berechnen
	
	(erzeugeFahne)
	(FahnenPosition_lokal)
	(create_FahnenblechLochbild_HT)
	(create_WinkelLochbild_AT)
	(WnklEndeAnpassen)
	
	(SchraubenPosLnge)
	
	
	; (Lochbild.set Fahnenlochbild (e "0 25 75 0 0 0"))
	; (setq abtl_FahnenLB (Traeger.get TR_ID ABTeil Fahnenlochbild))
	; (setq FBl_Winkel (Anbauteil.get abtl_FahnenLB Winkel))
	; (setq SRicht     (Anbauteil.get abtl_FahnenLB SeitRicht))
	; (AlertBox FBl_Winkel) (AlertBox SRicht)
	; (Anbauteil.set abtl_FahnenLB (SeitRicht -1))
	; (Lochbild.set Fahnenlochbild (e "0 20 80 0 0 0"))	; Testen Lochbildausrichtung

	
	
)
(defun cb_Fahnenblech (zp)
	(if (= zp 0) (progn
		(setq dpAlt (Blech.get Fahnenblech dp))
	))
	(if (= zp 1) (progn
		(setq dpNeu (Blech.get Fahnenblech dp))
		(if (/= dpAlt dpNeu) (progn
			(FahnenPosition_lokal)
			(SchraubenPosLnge)
		))
	))

)
(defun analysiere_Lage ()
   ; Kontaktflächen - langer-Schenkel des AT an der Fläche des HT
   ; oder kurzer Schenkel des AT  an der Fläche des HT
	(setq  kurzer_Schenkel 0  langer_Schenkel 0)
   (if (=  (Connect.get CastaData satr-shtr)   1) (setq  langer_Schenkel 1))
   (if (=  (Connect.get CastaData satr-shtr)  -1) (setq  langer_Schenkel 1))
   (if (=  (Connect.get CastaData vatr-shtr)   1) (setq  kurzer_Schenkel 1))
   (if (=  (Connect.get CastaData vatr-shtr)  -1) (setq  kurzer_Schenkel 1))

	;(AlertBox langer_Schenkel) (AlertBox kurzer_Schenkel)

   (setq AnschlussMoeglich 0)
   (if (=  (Connect.get CastaData at-von-oben)  1) (progn
		(print "Branch -1-   (at-von-oben)")	; ist derzeit nicht als Anschluss erlaubt
   ))
   (if (=  (Connect.get CastaData at-von-unten)  1) (progn
		(print "Branch -2-   (at-von-unten)")
		(setq AnschlussMoeglich 1)				; nur bei AT von unten ist derzeit der Anschluss möglich
   ))

   ; rechts vorbei oder links vorbei
	(setq qsForm_HT (Traeger.get HTrg qsForm))
	(setq b_HT  (Traeger.get HTrg b))
	(setq dlr_HT (Traeger.get HTrg delta_LR))
	
	(setq b_HT_eff b_HT)
	(if (= qsForm_HT "I") (setq b_HT_eff (* 0.5 b_HT)))
	(if (= qsForm_HT "K") (setq b_HT_eff (* 0.5 b_HT)))
	(if (= qsForm_HT "U") (progn
		(if (=  (Connect.get CastaData vatr-shtr)  1) (setq b_HT_eff 0.0))
		(if (=  (Connect.get CastaData satr-shtr) -1) (setq b_HT_eff 0.0))
	))
	
	(setq amHT_rechts_vorbei 0  amHT_links_vorbei 0)
	(setq spaltBreite 0.0)
	(if (= langer_Schenkel 1) (progn
		(setq dlr_AT (Traeger.get Tr_ID delta_LR))
		(if (=  (Connect.get CastaData satr-shtr)  1) (progn
			(setq spaltBreite (- dlr_AT b_HT_eff dlr_HT))
			(if (> spaltBreite 0.0) (setq amHT_rechts_vorbei 1))
		))
		(if (=  (Connect.get CastaData satr-shtr)  -1) (progn
			(setq spaltBreite (- dlr_AT b_HT_eff (- dlr_HT)))
			(if (> spaltBreite 0.0) (setq amHT_links_vorbei 1))
		))
	))
		
	(if (= kurzer_Schenkel 1) (progn
		(setq dv_AT (Traeger.get Tr_ID delta_V))
		(if (=  (Connect.get CastaData vatr-shtr) -1) (progn
			(setq spaltBreite (- (- dv_AT) b_HT_eff dlr_HT))
			(if (> spaltBreite 0.0) (setq amHT_rechts_vorbei 1))
		))
		(if (=  (Connect.get CastaData vatr-shtr) 1) (progn
			(setq spaltBreite (- (- dv_AT) b_HT_eff (- dlr_HT)))
			(if (> spaltBreite 0.0) (setq amHT_links_vorbei 1))
		))
	))

	(if (= kurzer_Schenkel 1) (progn
		(if (= amHT_links_vorbei  1) (print "Kurzer Schenkel am HT links vorbei"))
		(if (= amHT_rechts_vorbei 1) (print "Kurzer Schenkel am HT rechts vorbei"))
	))
	(if (= langer_Schenkel 1) (progn
		(if (= amHT_links_vorbei  1) (print "Langer Schenkel am HT links vorbei"))
		(if (= amHT_rechts_vorbei 1) (print "Langer Schenkel am HT rechts vorbei"))
	))
	(print spaltBreite)
	
	(if (= qsForm_HT "U") (progn
		(if (= kurzer_Schenkel 0) (if (= langer_Schenkel 0) (setq AnschlussMoeglich 0)))
		(if (= amHT_links_vorbei 1) (setq AnschlussMoeglich 0))
	))
   
)
(defun initialisiere_Geometrie ()
	(setq Ht_Winkel 0.0)
	(setq S_Verschiebung 0.0)
	(setq SchenkelBreite_anlieg 0.0)
	(setq WinkelSwitch 0)
   
	(if (=  langer_Schenkel 1) (progn
			(print "langer Schenkel")
			(setq Ht_Winkel (Connect.get CastaData  v-atrgewnkl_flansch))
			(setq S_Verschiebung (Traeger.get Tr_ID delta_V))
			(print S_Verschiebung)
			(setq  SchenkelBreite_anlieg (Traeger.get Tr_ID h))
			
			(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq Ht_Winkel (- 180.0 Ht_Winkel)))
			(if (= (Connect.get CastaData vAtr-lHtr) -1) (setq Ht_Winkel (- Ht_Winkel 180.0)))
			
			; (if (< Ht_Winkel 0.0) (Alertbox "Ht_Winkel ist kleiner 0 - wird umgeswitcht"))
			(if (< Ht_Winkel 0.0) (setq WinkelSwitch 1))
			(if (< Ht_Winkel 0.0) (setq Ht_Winkel (+ Ht_Winkel 180.0)))
	))

	(if (=  kurzer_Schenkel  1) (progn
			(print "kurzer Schenkel")
			(setq Ht_Winkel (Connect.get CastaData  h-atrgewnkl_flansch))
			(setq S_Verschiebung (Traeger.get Tr_ID delta_LR))
			(print S_Verschiebung)
			(setq  SchenkelBreite_anlieg (Traeger.get Tr_ID b))

			(if (= (Connect.get CastaData sAtr-lHtr)  1) (setq Ht_Winkel (- 180.0 Ht_Winkel)))
			(if (= (Connect.get CastaData sAtr-lHtr) -1) (setq Ht_Winkel (- Ht_Winkel 180.0)))

			; (if (< Ht_Winkel 0.0) (Alertbox "Ht_Winkel ist kleiner 0 - wird umgeswitcht"))
			(if (< Ht_Winkel 0.0) (setq WinkelSwitch 1))
			(if (< Ht_Winkel 0.0) (setq Ht_Winkel (+ Ht_Winkel 180.0)))

	))
	(setq  S_Verschiebung (* 1.0 S_Verschiebung))

	(setq sinV (sin (* PI (/ Ht_Winkel 180.0))))
	(setq cosV (cos (* PI (/ Ht_Winkel 180.0))))
	(setq tanV (tan (* PI (/ Ht_Winkel 180.0))))
	

	(if (< Ht_Winkel 0.0) (setq sinV (- sinV)))
	(if (< Ht_Winkel 0.0) (setq cosV (- cosV)))
	(if (= WinkelSwitch 1) (progn
		(setq sinV (- sinV))
		(setq cosV (- cosV))
	))

	
    (print "Eingangswerte --------------------------- ")
	(print  S_Verschiebung)
	(print  SchenkelBreite_anlieg)

	; Bei U-Profilen muss die Ablängung und Schraubenlage korrigiert werden
	(setq HT_QsTyp (Traeger.get HTrg qsForm))
	
	; Systemlinienabstand - eigentlich Abstand zwischen den Mittellinien bze. Kantenlinien bei U-/L-Profilen
	(setq	dlr_AT (Traeger.get Tr_ID delta_LR)
			dv_AT (Traeger.get Tr_ID delta_V)
	)
	(setq	dlr_HT (Traeger.get HTrg delta_LR))
	
	(if (=  (Connect.get CastaData vatr-shtr) -1) (setq Dist_SysLines (- (+ dv_AT  dlr_HT)))) ; --OK--
	(if (=  (Connect.get CastaData vatr-shtr)  1) (setq Dist_SysLines (- (- dv_AT  dlr_HT)))) ; --OK--
	(if (=  (Connect.get CastaData satr-shtr) -1) (setq Dist_SysLines    (+ dlr_AT dlr_HT)))  ; --OK--
	(if (=  (Connect.get CastaData satr-shtr)  1) (setq Dist_SysLines    (- dlr_AT dlr_HT)))  ; --OK--
	
	
	(setq LaufRichtung 0)
	(setq VWnkl_Flansch (Connect.get CastaData v-atrgewnkl_flansch))
	(setq HWnkl_Flansch (Connect.get CastaData h-atrgewnkl_flansch))
	(if (> VWnkl_Flansch 90.0) (setq LaufRichtung  1))
	(if (< VWnkl_Flansch 90.0) (setq LaufRichtung -1))
	(if (> HWnkl_Flansch 90.0) (setq LaufRichtung  2))
	(if (< HWnkl_Flansch 90.0) (setq LaufRichtung -2))
	
)
(defun erzeugeFahne ()
	(setq dp_Fahne 12)
	(setq Fahnenblech (Blech.create))
	(Blech.set Fahnenblech 
			(hp 150)
			(bp 100)
			(dp dp_Fahne)
	)
	(Connect.storeAnschlObjs CastaData Fahnenblech)
	
	(setq xPos_HT (Connect.get CastaData xPos_HT))
	
	(setq abtl_fahne_winkel Ht_Winkel)
	
	(if (= (Connect.get CastaData amHtstegLinks) 1) (traeger.addabtl hTrg Fahnenblech xPos_HT abtl_fahne_winkel _fahnenblech_steg_li_))
	(if (= (Connect.get CastaData amHtstegRechts) 1) (traeger.addabtl hTrg Fahnenblech xPos_HT abtl_fahne_winkel _fahnenblech_steg_re_))
	
	(setq qsForm_HT (Traeger.get HTrg qsForm)
		  h_HT		(Traeger.get HTrg h)
		  t_HT		(Traeger.get HTrg t)
		  r_HT		(Traeger.get HTrg r)
	)
	(setq hp_Bl (- h_HT t_HT t_HT r_HT r_HT))
	(if (= qsForm_HT "U") (progn
		(if (= (Connect.get CastaData amHtstegLinks) 1) (setq hp_Bl h_HT))
	))
	
	(calc_netto_Distance)	; berechnet delta_LR_LB
	(setq bEff_Wnkl 0.0)
	(setq Fahnenbreite 0.0)
	(if (= langer_Schenkel 1) (setq bEff_Wnkl (Traeger.get Tr_ID b)))
	(if (= kurzer_Schenkel 1) (setq bEff_Wnkl (Traeger.get Tr_ID h)))
	(setq Fahnenbreite (+ delta_LR_LB bEff_Wnkl))
	
	(Blech.set Fahnenblech 
						    (hp hp_Bl)
							(bp Fahnenbreite)
	)
	(Blech.set Fahnenblech (FormFkt "cb_Fahnenblech"))

	(setq dv_HT (Traeger.get HTrg delta_V))
	(setq dv_Fahne (* cosV dv_HT))
	(if (= LaufRichtung -1) (setq dv_Fahne (- dv_Fahne)))
	(if (= LaufRichtung -2) (setq dv_Fahne (- dv_Fahne)))
	
	(setq abtl_Fahne (Traeger.get HTrg ABTeil Fahnenblech))
	(Anbauteil.set 		abtl_Fahne	(delta_V dv_Fahne))

	
)
(defun FahnenPosition_lokal ()
	(setq dp_Fahne (Blech.get Fahnenblech dp))
	
	(setq bl_Seitlich (* 0.5 dp_Fahne))
	
	(setq	dlr_AT	(Traeger.get Tr_ID delta_LR)
			dV_AT	(Traeger.get Tr_ID delta_V)
	)
	(setq dv_HT (Traeger.get HTrg delta_V))
	(setq hori_Versch (* cosV dv_HT))
	
	(if (= (Connect.get CastaData satr-lhtr)  1) (setq bl_Seitlich (+ bl_Seitlich dlr_AT)))
	(if (= (Connect.get CastaData satr-lhtr) -1) (setq bl_Seitlich (- bl_Seitlich dlr_AT)))
	(if (= (Connect.get CastaData vatr-lhtr)  1) (setq bl_Seitlich (+ bl_Seitlich dv_AT)))
	(if (= (Connect.get CastaData vatr-lhtr) -1) (setq bl_Seitlich (- bl_Seitlich dv_AT)))
	
	(if (= (Connect.get CastaData vatr-lhtr)  1) (setq bl_Seitlich (- bl_Seitlich hori_Versch)))
	(if (= (Connect.get CastaData vatr-lhtr) -1) (setq bl_Seitlich (- hori_Versch bl_Seitlich)))
	(if (= (Connect.get CastaData satr-lhtr)  1) (setq bl_Seitlich (- (- bl_Seitlich) hori_Versch)))
	(if (= (Connect.get CastaData satr-lhtr) -1) (setq bl_Seitlich (- hori_Versch (- bl_Seitlich))))

	(Blech.set Fahnenblech (xAsym bl_Seitlich))


	
)

(defun create_FahnenblechLochbild_HT ()
	(setq abtl_Fahne (Traeger.get HTrg ABTeil Fahnenblech))
	
	(setq xPos_HT (Connect.get CastaData xPos_HT))
	(setq LB_FahnenWinkel 180.0)
;	(if (= (Connect.get CastaData vatr-lhtr) -1) (setq LB_FahnenWinkel 180.0))
	
	(setq Fahnenlochbild (Lochbild.create))
	(Traeger.addabtl Htrg Fahnenlochbild xPos_HT   LB_FahnenWinkel _fahnblLochbild_ abtl_Fahne)

	; berechnet delta_LR_LB
	(calc_netto_Distance)
	
	(setq abtl_FLochbild (Traeger.get HTrg ABTeil Fahnenlochbild))
	(Anbauteil.set abtl_FLochbild 	(Master 1)
									(delta_LR delta_LR_LB)
									(SeitRicht 1)
	)
	(Lochbild.set	Fahnenlochbild (dlr_Coupon 0.0))

	(setq hp_FBl (Blech.get Fahnenblech hp))
	(setq hp4 (* 0.25 hp_FBl))

	
	(setq b_Eff 0)
	(if (= langer_Schenkel 1) (setq b_Eff (Traeger.get Tr_ID b)))
	(if (= kurzer_Schenkel 1) (setq b_Eff (Traeger.get Tr_ID h)))

	(setq dv_HT (Traeger.get HTrg delta_V))
	(setq e0_dv (* cosV dv_HT))
	(if (< cosV 0.0) (setq e0_dv (- e0_dv)))
	
	(Lochbild.set Fahnenlochbild (w "0 0")					; hier Lochbildabmessungen festlegen
								 (w0 (* 0.5 b_Eff))
								 (e "0 0 0 0 0 0")
								 (e0 (- e0_dv hp4))
								 (e1 (* 2 hp4))
								 (S_Bez "M16")
								 (Guete "10.9")
	)
	(if (< hp4 32) 
		(Lochbild.set Fahnenlochbild (S_Bez "M12"))
		(if (> hp4 40) (Lochbild.set Fahnenlochbild (S_Bez "M20")))
	)
	
	(Connect.storeAnschlObjs CastaData Fahnenlochbild)
	

)
(defun create_WinkelLochbild_AT ()
	(setq xPos_AT (Connect.get CastaData xPos_AT))

	(if (=  langer_Schenkel 1) (progn
		(Traeger.addabtl Tr_ID Fahnenlochbild xPos_AT 0.0 _flanschlochbild_uf_)
	))
	(if (=  kurzer_Schenkel 1) (progn
		(Traeger.addabtl Tr_ID Fahnenlochbild xPos_AT 0.0 _steglochbild_system_)
	))

	(if (=  (Connect.get CastaData amAtUnterflansch) 2) (progn
		(traeger.addabtl Tr_ID L_Lochb xPos_AT 0.0 _flanschlochbild_uf_)
		; hier dlr_Coupon zurückstellen, da das ganze Lochbild verschoben wird und nicht nur
		; das Winkel-Lochbild über das Anbauteil
	))
	(if (=  (Connect.get CastaData amAtSteg)  2) (progn
		(traeger.addabtl Tr_ID L_Lochb xPos_AT 0.0 _steglochbild_system_)
	))

	; Richtung und Winkel
	(setq SRichtung 1)
	(setq RWinkel_LB_AT 180.0)
	(if (=  (Connect.get CastaData vAtr-sHtr)  -1) (setq SRichtung -1)) ; --OK--
	(if (=  (Connect.get CastaData vAtr-sHtr)   1) (setq SRichtung  1)) ; --OK--
	(if (=  (Connect.get CastaData sAtr-sHtr)  -1) (setq SRichtung -1)) ; --OK--
	(if (=  (Connect.get CastaData sAtr-sHtr)   1) (setq SRichtung -1)) ; --OK--
	
	; von unten ist der Standardfall - daher wird hier nur umgeswitcht, wenn der AT von oben kommt.
	(if (=  (Connect.get CastaData at-von-oben)  1) (progn
		(setq SRichtung (- SRichtung))
		(setq RWinkel_LB_AT 0.0)
	))

	; vertikale Versatz des HT wird im AT verankert
	(setq delta_V_HT (Traeger.get HTrg delta_V))
	(setq delta_V_HT (* sinV delta_V_HT))
	(if (< sinV 0.0) (setq delta_V_HT (- delta_V_HT)))
	
	
	(setq abtl_LLochbild_AT (Traeger.get TR_ID ABTeil Fahnenlochbild))
	(Anbauteil.set abtl_LLochbild_AT 	(Master 0)
										(Winkel 		RWinkel_LB_AT)
										(SeitRicht		SRichtung)
										(delta_V		delta_V_HT)
	)
	
)


(defun calc_netto_Distance ()
	(setq delta_LR_LB Dist_SysLines)
	(setq qsForm_HT (Traeger.get HTrg qsForm)
		  b_HT		(Traeger.get HTrg b)		; wird bei Kastenprofilen ausschlaggebend
		  s_HT		(Traeger.get HTrg s)
	)
	(if (= qsForm_HT "I") (setq delta_LR_LB (- Dist_SysLines (* 0.5 s_HT))))
	(if (= qsForm_HT "K") (setq delta_LR_LB (- Dist_SysLines (* 0.5 b_HT))))
	(if (= qsForm_HT "U") (progn
		(if (= (Connect.get CastaData amHtstegLinks)  1) (setq delta_LR_LB Dist_SysLines))
		(if (= (Connect.get CastaData amHtstegRechts) 1) (setq delta_LR_LB (- Dist_SysLines s_HT)))
	))
)
(defun WnklEndeAnpassen ()
	(setq 	h_HT	(Traeger.get HTrg h)
			dv_HT	(Traeger.get HTrg delta_V)
	)
	
	(setq	hp		(Blech.get Fahnenblech hp))
	(setq	h_Vorh	hp)

	
	(setq	dl_AT	0.0)
	(if (= (Connect.get CastaData at-von-oben)  1) (setq	dl_AT	(- (+ (* 0.5 h_Vorh) dv_HT))))
	(if (= (Connect.get CastaData at-von-unten) 1) (setq	dl_AT	(- (+ (* 0.5 h_Vorh) dv_HT))))

	(setq dl_AT (/ dl_AT sinV))
	(if (< sinV 0.0) (setq dl_AT (- dl_AT)))
	
	(if (= (Connect.get CastaData linkesEnde)  1) (progn
		(print "linkes Ende anpassen")
		(setq tEnde (Traeger.get Tr_ID links))
		(TrEnde.set tEnde (delta_L dl_AT))
	))
	(if (= (Connect.get CastaData rechtesEnde)  1) (progn
		(print "rechtes Ende anpassen")
		(setq tEnde (Traeger.get Tr_ID rechts))
		(TrEnde.set tEnde (delta_L dl_AT))
	))


)
(defun SchraubenPosLnge ()

	(setq	dp_Fahne 	(Blech.get Fahnenblech dp)
			bl_SeiteV	(Blech.get Fahnenblech xAsym)
	)
	(setq t_AT		(Traeger.get Tr_ID t))

	(setq dxs_Kopf  (* 0.5 dp_Fahne))

	
	(setq abtl_Lb_HT (Traeger.get HTrg ABTeil Fahnenlochbild))
	(setq delta_SX_LB (Anbauteil.get abtl_Lb_HT delta_SX))

	(Lochbild.set	Fahnenlochbild	
				(dxSKopf dxs_Kopf)
				(KlemmL	(+ dp_Fahne t_AT))
	)
	(Anbauteil.set abtl_Lb_HT (delta_SX bl_SeiteV))

	(setq	SRichtungAendern 0)
	(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq	SRichtungAendern 1))
	(if (= (Connect.get CastaData sAtr-lHtr) -1) (setq	SRichtungAendern 1))
	(if (= SRichtungAendern 1) (progn
		(Lochbild.set	Fahnenlochbild 
				(Schr_Richt 	-1)
				(dxSKopf 		(- dxs_Kopf))
		)
	))
	
	
)
