; $	G(62)	HT	 QT(L)	 	AF(S)		P(EZ)
; $	G(62)	AT	 QT(L) 		AF(S)		P(EZ)
; $	G(62)	AE	 V(-)		H(-)		R(-)
; $			HT	QT(FL)		AF(FS)		P(ZE)
; $			AT	QT(L)		AF(F)		P(ZE)
; $			AE	V(-)		H(-)		R(-)

(defun load-modules ()
	(load "mod-endinit-trg-auf-trg")
)

(defun init-connection ()
	(print "*clear*")
	(print "Anschluss fr kreuzende Profile")
	(connect.showattributes CastaData)
	(print "---------------------- +++ ------------------------------ +++ --------------------")
	
	(if (= (Connect.get CastaData amatunterflansch) 1) (if (= (Connect.get CastaData amhtunterflansch) 1) (progn
		(createConn_Flansch_an_Flansch)
	)))
	(if (= (Connect.get CastaData amAtSteg) 1) (if (= (Connect.get CastaData amHtSteg) 1) (progn
		(createConn_Steg_an_Steg)
	)))
	(if (= (Connect.get CastaData amatunterflansch) 1) (if (= (Connect.get CastaData amhtsteglinks) 1) (progn
		(createConn_Steg_an_Flansch)
	)))
	
)
(defun setConnection ()
	(print "Anschluss durchfhren")
)
(defun createConn_Steg_an_Steg ()
	(print "Anschluss Steg-an-Steg")
	(setq xPos_AT (Connect.get CastaData xPos_AT))
	(setq xPos_HT (Connect.get CastaData xPos_HT))
	
	(setq Lchb_ID (lochbild.create))

	; -----------------------------
	(setq s_HT (Traeger.get HTrg  s)
		  s_AT (Traeger.get Tr_ID s)
		  KlemmLaenge (+ s_HT s_AT)
	)

	(initLochbild_StV Lchb_ID KlemmLaenge)
	(Connect.storeAnschlObjs CastaData Lchb_ID)

	(setq HT_LchbWinkel 0.0)
	(setq AT_LchbWinkel (Connect.get CastaData V-atrgewnkl_Flansch))
	(setq AT_LchbWinkel_Test (Connect.get CastaData  trg_hwinkel ))
	(print AT_LchbWinkel)
	(if (= (Connect.get CastaData at-von-oben) 1) (progn
		(setq HT_LchbWinkel 180.0)
		(setq AT_LchbWinkel (- 180.0 AT_LchbWinkel))
	))
	(if (= (Connect.get CastaData at-von-unten) 1) (progn
		(setq HT_LchbWinkel 0.0)
	))
	
	(traeger.addabtl Tr_ID Lchb_ID xPos_AT AT_LchbWinkel   _steglochbild_system_)
	(traeger.addabtl HTrg Lchb_ID  xPos_HT HT_LchbWinkel   _steglochbild_system_)
	
	(setq Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil Lchb_ID))
	(setq Abtl_Lchb_HT (Traeger.get HTrg  ABTeil Lchb_ID))
	
	(Anbauteil.set Abtl_Lchb_AT (Master 1)) 
	(Anbauteil.set Abtl_Lchb_HT (Master 0))
	
;	(Anbauteil.set Abtl_Lchb_AT (SeitRicht -1))
	; -------------------------------
	(setq sinW (sin (/ (* PI AT_LchbWinkel) 180.0)))
	(setq cosW (cos (/ (* PI AT_LchbWinkel) 180.0)))
	(setq tanW (tan (/ (* PI AT_LchbWinkel) 180.0)))
	(setq h_HT 		(Traeger.get HTrg h)
		  h_HT_2	(* 0.5 h_HT)
		  dv_HT	(Traeger.get HTrg delta_V)
		  dv_HT	(* 1.0 dv_HT)
	)
	(setq h_AT 		(Traeger.get Tr_ID h)
		  h_AT_2	(* 0.5 h_AT)
		  dv_AT		(Traeger.get Tr_ID delta_V)
		  dv_AT		(* 1.0 dv_AT)
	)

	(setq dv_Lchb  0.0  dlr_Lchb 0.0)
	(if (= (Connect.get CastaData at-von-oben) 1) (progn
		(print "von-oben")
		(setq dv_Anteil_HT (/ h_HT_2 tanW))
		(setq dv_Anteil_HT (- dv_Anteil_HT (/ dv_HT tanW)))
		(setq dv_Anteil_HT (+ dv_Anteil_HT (/ dv_AT sinW)))

		(setq dv_Anteil_AT (/ h_AT_2 sinW))
		(setq dv_Lchb   (- dv_Anteil_HT dv_Anteil_AT))
		(setq dlr_Lchb  h_HT_2)

		(setq dv_HT (- dv_HT))
		(setq dlr_Ant_AT (*   dv_AT  cosW))
		(setq dv_Ant_AT  (*   dv_AT  sinW))
	))
	(if (= (Connect.get CastaData at-von-unten) 1) (progn
		(print "von-unten")
		(setq dv_Anteil_HT (/ h_HT_2 tanW))
		(setq dv_Anteil_HT (- dv_Anteil_HT (/ dv_HT tanW)))
		(setq dv_Anteil_HT (- dv_Anteil_HT (/ dv_AT sinW)))

		(setq dv_Anteil_AT (/ h_AT_2 sinW))
		(setq dv_Lchb   (- dv_Anteil_HT dv_Anteil_AT))
		(setq dv_Lchb   (- (- dv_Anteil_AT) dv_Anteil_HT))
		(setq dlr_Lchb  (- h_HT_2))

		(setq dlr_Ant_AT (*    dv_AT  cosW))
		(setq dv_Ant_AT  (*    dv_AT  sinW))
	))

	(Anbauteil.set Abtl_Lchb_HT (delta_LR (- dlr_Lchb)))
	(Anbauteil.set Abtl_Lchb_AT (delta_LR (+  dlr_Lchb dv_HT dlr_Ant_AT)))
	
	(Anbauteil.set Abtl_Lchb_HT (delta_V   (- dv_Lchb)))
	(Anbauteil.set Abtl_Lchb_AT (delta_V   (- dv_Ant_AT dv_Lchb)))
	

)

(defun initLochbild_StV (Lchb_ID KlemmLaenge)
	(Lochbild.set Lchb_ID
		(S_Bez "M16")
		(Guete "4.6")
		(e "0 0 0 0 0 0")
		(w "0 0 0 0")
		(LB_Art 2)
		(KlemmL KlemmLaenge)
	)
	; (Lochbild.set Lchb_ID (e "0 15 65 0 0 0"))
)
; -----------------------------------------------------------------------------------------------
(defun initLochbild_FlV (Lchb_ID KlemmLaenge)
	(setq AT_LchbWinkel (Connect.get CastaData h-atrgewnkl_steg))
	(setq AT_LchbWinkel (- AT_LchbWinkel 90.0))
	(setq sin_AW (sin (/ (* PI AT_LchbWinkel) 180.0)))
	(setq cos_AW (cos (/ (* PI AT_LchbWinkel) 180.0)))
	(setq tan_AW (tan (/ (* PI AT_LchbWinkel) 180.0)))
	(if (< tan_AW 0.0) (setq tan_AW (- tan_AW)))
	
	(Lochbild.set Lchb_ID
		(S_Bez "M16")
		(Guete "4.6")
		(e "0 0 0 0 0 0")
		(w "0 0 0 0")
		(LB_Art 2)
		(KlemmL KlemmLaenge)
	)

	; (Lochbild.set Lchb_ID (e "0 15 65 0 0 0"))
)
(defun dummyFkt ()	
	(setq b_HT (traeger.get HTrg b)
		  s_HT (traeger.get HTrg s)
	)
	(setq w0 (+ (/ (- b_HT s_HT) 2) s_HT))
;	(Lochbild.set Lchb_ID (w0 w0))

	(setq b_AT (traeger.get Tr_ID b)
		  s_AT (traeger.get Tr_ID s)
	)
	(setq ev0 (/ (- (* 1.0 b_AT) s_HT) 2.0))
	(if (= (Connect.get CastaData satr-lhtr-ex) 1) (setq ev0 (/ (+ (* 1.0 b_AT) s_HT) 2.0)))
	(setq d_e0 (* (* 1.0 w0) tan_AW))
	(print ev0)
	
	(setq e0 (- (/ ev0 cos_AW) d_e0))
	(if (= (Connect.get CastaData satr-lhtr-ex) -1) (setq e0 (- e0)))


;	(Lochbild.set Lchb_ID (e0  e0))

	(Lochbild.set Lchb_ID (klemmL (+ s_HT s_At)))
	
	
)

(defun createConn_Flansch_an_Flansch ()
	(print "Anschluss Flansch-an-Flansch")
	(setq xPos_AT (Connect.get CastaData xPos_AT))
	(setq xPos_HT (Connect.get CastaData xPos_HT))

	; -----------------------------
	(setq s_HT (Traeger.get HTrg  s)
		  s_AT (Traeger.get Tr_ID s)
		  KlemmLaenge (+ s_HT s_AT)
	)

	
	(setq Lchb_ID (lochbild.create))
	(initLochbild_FlV Lchb_ID KlemmLaenge)
	(Connect.storeAnschlObjs CastaData Lchb_ID)

	(setq HT_LchbWinkel 0.0)
	(setq AT_LchbWinkel (Connect.get CastaData h-atrgewnkl_steg))
	(print AT_LchbWinkel)
	
	(if (= (Connect.get CastaData at-von-rechts) 1) (progn
		(if (>= AT_LchbWinkel 90.0) (setq AT_LchbWinkel (-  AT_LchbWinkel 180.0)))
		(setq HT_LchbWinkel 180.0)
;		(AlertBox "at-von-rechts") (ALertBox AT_LchbWinkel) 
	))
	(if (= (Connect.get CastaData at-von-links) 1) (progn
		(if (<= AT_LchbWinkel 90.0) (setq AT_LchbWinkel (-  AT_LchbWinkel)))
		(setq HT_LchbWinkel 0.0)
;		(AlertBox "at-von-links") (ALertBox AT_LchbWinkel) 
	))
	
	(traeger.addabtl Tr_ID Lchb_ID xPos_AT AT_LchbWinkel	 _flanschlochbild_uf_)
	(traeger.addabtl HTrg Lchb_ID  xPos_HT HT_LchbWinkel     _flanschlochbild_uf_)
	
	(setq Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil Lchb_ID))
	(setq Abtl_Lchb_HT (Traeger.get HTrg  ABTeil Lchb_ID))
	
	(Anbauteil.set Abtl_Lchb_AT (Master 1) (SeitRicht -1))
	(Anbauteil.set Abtl_Lchb_HT (Master 0))
	
	; -------------------------------
	(setq sinW (sin (/ (* PI AT_LchbWinkel) 180.0)))
	(setq cosW (cos (/ (* PI AT_LchbWinkel) 180.0)))
	(setq tanW (tan (/ (* PI AT_LchbWinkel) 180.0)))
	(setq b_HT 		(Traeger.get HTrg b)
		  b_HT_2	(* 0.5 b_HT)
		  dlr_HT	(Traeger.get HTrg delta_LR)
		  dlr_HT	(* 1.0 dlr_HT)
	)
	(setq b_AT 		(Traeger.get Tr_ID b)
		  b_AT_2	(* 0.5 b_AT)
		  dlr_AT	(Traeger.get Tr_ID delta_LR)
		  dlr_AT	(* 1.0 dlr_AT)
	)

	(setq dv_Lchb  0.0  dlr_Lchb 0.0)
	(if (= (Connect.get CastaData at-von-links) 1) (progn
		(print "von-links")
		(setq dv_Anteil_HT (/ b_HT_2 tanW))
		(setq dv_Anteil_HT (+ dv_Anteil_HT (/ dlr_HT tanW)))
		(setq dv_Anteil_HT (+ dv_Anteil_HT (/ dlr_AT sinW)))
		
		(setq dv_Anteil_AT (- (/ b_AT_2 sinW)))
		(setq dv_Lchb   (- dv_Anteil_HT dv_Anteil_AT))
		(setq dlr_Lchb  b_HT_2)
		
		(setq dlr_Ant_AT (*    dlr_AT  cosW))
		(setq dv_Ant_AT  (*    dlr_AT  sinW))
	))
	(if (= (Connect.get CastaData at-von-rechts) 1) (progn
		(print "von-rechts")
		(setq dv_Anteil_HT (/ b_HT_2 tanW))
		(setq dv_Anteil_HT (+ dv_Anteil_HT (/ dlr_HT tanW)))
		(setq dv_Anteil_HT (- dv_Anteil_HT (/ dlr_AT sinW)))

		(setq dv_Anteil_AT (- (/ b_AT_2 sinW)))
		(setq dv_Lchb   (- dv_Anteil_HT dv_Anteil_AT))
		(setq dv_Lchb   (- (- dv_Anteil_AT) dv_Anteil_HT))
		(setq dlr_Lchb  (- b_HT_2))
		
		(setq dlr_Ant_AT (*    dlr_AT  cosW))
		(setq dv_Ant_AT  (*    dlr_AT sinW))
		(setq dlr_HT (- dlr_HT))
	))

	(Anbauteil.set Abtl_Lchb_HT (delta_LR (- dlr_Lchb)))
	(Anbauteil.set Abtl_Lchb_AT (delta_LR  (+  dlr_Lchb dlr_HT dlr_Ant_AT)))
	
	(Anbauteil.set Abtl_Lchb_HT (delta_V   (- dv_Lchb)))
	(Anbauteil.set Abtl_Lchb_AT (delta_V   (- dv_Ant_AT dv_Lchb)))
	
	(if (= (Connect.get CastaData satr-shtr) 1) (progn
		(print "..................... testen hier .....................")
		(print dlr_Lchb)
		(print dlr_HT)
		(print dlr_Ant_AT)
		(print dv_Ant_AT)
		(print dv_Lchb)
		
		; (setq dlr_Lchb (- dlr_Lchb))
		; (setq dv_Lchb (- dv_Lchb))
		(Anbauteil.set Abtl_Lchb_AT (delta_LR  (+  dlr_Lchb dlr_HT dlr_Ant_AT)))
		(Anbauteil.set Abtl_Lchb_AT (delta_V   (-  dv_Ant_AT dv_Lchb)))
	))
	
)

(defun createConn_Steg_an_Flansch ()
	; HT - Steg wird angeschlossen an AT - Flanschh
	(print "Anschluss Steg-an-Flansch")

	(setq xPos_AT (Connect.get CastaData xPos_AT))
	(setq xPos_HT (Connect.get CastaData xPos_HT))

	; -----------------------------
	(setq s_HT (Traeger.get HTrg  s)
		  s_AT (Traeger.get Tr_ID s)
		  KlemmLaenge (+ s_HT s_AT)
	)
	
	(setq Lchb_ID (lochbild.create))
	(initLochbild_FlV Lchb_ID KlemmLaenge)
	(Connect.storeAnschlObjs CastaData Lchb_ID)

;	Zum Testen
;	(Lochbild.set Lchb_ID (e "0 20 80 0 0 0"))
;	(Lochbild.set Lchb_ID (w "10 40"))
;	(Lochbild.set Lchb_ID (LB_Art -2))
	
	(setq	HT_LchbWinkel 0.0
			HT_Seitricht 0
			AT_LchbWinkel 0.0
			AT_Seitricht 0
			Fakt_Seitl   1.0
	)
	
	(setq HT_Wnkl		(Connect.get CastaData h-atrgewnkl_flansch))
	
	(if (= (Connect.get CastaData at-von-unten) 1) (progn
		(setq AT_LchbWinkel 0.0)
		(setq HT_LchbWinkel (- 180.0 HT_Wnkl))
		(setq HT_Seitricht -1)
		(setq Fakt_Seitl 1.0)
		
	))
	(if (= (Connect.get CastaData at-von-oben)  1) (progn
		(setq AT_LchbWinkel 180.0)
		(setq HT_LchbWinkel HT_Wnkl)
		(setq AT_Seitricht -1)
		(setq Fakt_Seitl -1.0)
	))
	; berschreibt den HT-Winkel, weil der einen anderen Wert erhlt am Trgerende
	; als zwischendrin
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
		(setq HT_LchbWinkel (+ HT_Wnkl 0.0))
	))

	(setq local_LchbWnk (- HT_LchbWinkel 90.0))
	(setq sinW (sin (/ (* PI local_LchbWnk) 180.0)))
	(setq cosW (cos (/ (* PI local_LchbWnk) 180.0)))
	(setq tanW (tan (/ (* PI local_LchbWnk) 180.0)))
	(print local_LchbWnk)

	; Verschiebungen initialisieren
	(setq dLb_Seitlich 0.0)
	(setq dLb_Vertikal 0.0)
	; Verschiebung durch Haupttrger	-------------------------
	(setq dv_HT (Traeger.get HTrg delta_V))
	(setq dLb_Seitlich (- dLb_Seitlich (* dv_HT sinW)))
	(setq dLb_Vertikal (+ dLb_Vertikal (* dv_HT cosW)))

	; Verschiebung durch Anschlusstrger	-------------------------
	(setq dlr_AT (Traeger.get Tr_ID delta_LR))
	(setq dLb_Seitlich (+ dLb_Seitlich (* Fakt_Seitl dlr_AT)))
	

	
	(traeger.addabtl Tr_ID Lchb_ID xPos_AT AT_LchbWinkel	 _flanschlochbild_uf_)
	(traeger.addabtl HTrg Lchb_ID  xPos_HT HT_LchbWinkel   _steglochbild_system_)

	(setq Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil Lchb_ID))
	(setq Abtl_Lchb_HT (Traeger.get HTrg ABTeil Lchb_ID))
	(Anbauteil.set Abtl_Lchb_AT (Master 0))
	(Anbauteil.set Abtl_Lchb_HT (Master 1))

	(Anbauteil.set Abtl_Lchb_HT (delta_LR dLb_Seitlich) (delta_V dLb_Vertikal) (SeitRicht HT_Seitricht))
	(Anbauteil.set Abtl_Lchb_AT (SeitRicht AT_Seitricht))
	
	(setq b_AT 		(Traeger.get Tr_ID b)
		  t_AT 		(Traeger.get Tr_ID t)
		  dlr_AT	(Traeger.get Tr_ID delta_LR)
	)
	(setq dv_HT (Traeger.get HTrg delta_V))

	; AT krzen
	(setq tEndeTrimm_Val 0.0)
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
		(if (= (Connect.get CastaData at-von-unten) 1) (progn
			(setq dl_v_AT (* tanw (+ b_AT dlr_AT)))
			(setq dl_v_AT_aus_HT (/ (- dv_HT) cosW))
			(setq dl_v_AT (+ dl_v_AT dl_v_AT_aus_HT))
			
			(setq tE_Trg (Traeger.get Tr_ID links))
			(TrEnde.set tE_Trg (delta_L 0.0))
			(TrEnde.ptrim tE_Trg dl_v_AT)
			(setq tEndeTrimm_Val dl_v_AT)
		))
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(if (= (Connect.get CastaData at-von-oben) 1) (progn
			(setq dl_v_AT (* tanw (- dlr_AT)))
			(setq dl_v_AT_aus_HT (/ (- dv_HT) cosW))
			(setq dl_v_AT (+ dl_v_AT dl_v_AT_aus_HT))
			
			(setq tE_Trg (Traeger.get Tr_ID rechts))
			(TrEnde.set tE_Trg (delta_L 0.0))
			(TrEnde.ptrim tE_Trg dl_v_AT)
			(setq tEndeTrimm_Val dl_v_AT)
		))
	))
	
	; Lochbild einstellen
	(setq w0 (+ (/ b_AT 2) (/ t_AT 2)))
	(Lochbild.set Lchb_ID (e "0 0 0 0 0 0"))
	(Lochbild.set Lchb_ID (w0 w0) (w1 0))
	
	(setq e0 (+ tEndeTrimm_Val 32))
	(Lochbild.set Lchb_ID (e0 e0) (e1 80))
)










; --------------------------------------------------------------

