; $	HT	QT(F)		AF(F)		P(EZ)
; $	AT	QT(KR)		AF(K)		P(E)
; $	AE	V(-)		H(-)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;	letzte nderung: 	13.04.2006
;	letzte Prfung:		13.04.2006
;	
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (load "mod-endinit-uz-stzsteg")
   (load "mod-multiconnect-stz-steg")
   (load "mod-add-schweiss-querschn")
)

(defun init-connection ()
	(print "*clear*")
	(print "Initialisieren ANSCHLUSS")
	(connect.showattributes CastaData)
	
	(checkPosition)
  (if (= isInside 1) (progn
	  (TraegerEndeMerken)
  	  (init-traegerenden 0)
	  (HT_Flach_Anpassen)
	  (AT_Ende_Anpassen)
	)
	(progn
  		(alertBox "Anschluss ist nicht mglich!"  "Connection_Not_Possible")
  ))
  				
  
)

; ----------------------------------------------------------------------------------------
; Prft, ob der Steg des AT in den HC-Berech des HT liegt
; ----------------------------------------------------------------------------------------
(defun checkPosition ()
	(print "------------------------------------------------------------")
	(print "BERPRFE AT POSITION")
	(print "------------------------------------------------------------")
	
	(setq	hc_ht 		(Traeger.get Htrg hc)
		delta_v_ht	(Traeger.get Htrg delta_v)
	)
	
	(setq	delta_lr_at	(Traeger.get Tr_ID delta_lr)
		s_at		(Traeger.get Tr_ID s)
	)
	
	; obere und untere Ausrundung des HT
	(setq ausrO_ht (- delta_v_ht (* 0.5 hc_ht)))
	(setq ausrU_ht (+ ausrO_ht hc_ht))
	(print ausrO_ht)
	(print ausrU_ht)
	(print delta_lr_at)
		
	(if (= (Connect.get CastaData satr-vhtr) 1)
		(progn
			(if (> delta_lr_at ausrU_ht)
				(progn
					(setq isInside 0)
				)
				(progn
					(if (< delta_lr_at ausrO_ht)
						(setq isInside 0)
						(setq isInside 1)
					)
				)
			)
		)
	)
	(if (= (Connect.get CastaData satr-vhtr) -1)
		(progn
			(if (> delta_lr_at (- ausrO_ht))
				(progn
					(setq isInside 0)
				)
				(progn
					(if (< delta_lr_at (- ausrU_ht))
						(setq isInside 0)
						(setq isInside 1)
					)
				)
			)
		)
	)
	
	(if (= isInside 0)
		(print "AUSSERHALB")
		(print "INNERHALB")
	)
)



(defun SchweissProfil_Einsetzen ()

;	(print "*clear*")

	; Anschlussdaten ...
	; X-Position
	(setq xPos_ht		(Connect.get CastaData xPos_ht))
	; Rotationswinkel des AT
	(setq rWinkel 0.0)
	(setq rWinkel_AT	(Connect.get CastaData r-atrgewnkl_steg ))

	(if (= (Connect.get CastaData linkesEnde)  1) (progn
	    (if (= (Connect.get CastaData amHtStegLinks)   1) (setq rWinkel    (- rWinkel_AT 90.0)))
	    (if (= (Connect.get CastaData amHtStegRechts)  1) (setq rWinkel (- (- rWinkel_AT 90.0))))
	))
	(if (= (Connect.get CastaData rechtesEnde)  1) (progn
	    (if (= (Connect.get CastaData amHtStegLinks)   1) (setq rWinkel (- (- rWinkel_AT 90.0))))
	    (if (= (Connect.get CastaData amHtStegRechts)  1) (setq rWinkel    (- rWinkel_AT 90.0)))
	))

	(print "----------------") (print rWinkel)

	(setq rWinkel_Abtl rWinkel)
	(if (= (Connect.get CastaData linkesEnde)     1) (progn
		(if (= (Connect.get CastaData satr-lhtr-ex)     1)  (setq rWinkel_Abtl (- rWinkel)))
	))
	(if (= (Connect.get CastaData rechtesEnde)     1) (progn
		(if (= (Connect.get CastaData satr-lhtr-ex)    -1) (setq rWinkel_Abtl (- rWinkel)))
	))
	(if (= (Connect.get CastaData amHtStegLinks)   1) (setq rWinkel_Abtl    (- rWinkel_Abtl)))
	
	(if (< rWinkel_Abtl 0.0) (setq rWinkel_Abtl (+ 180.0 rWinkel_Abtl)))
	(if (= (Connect.get CastaData vatr-lhtr)     1)  (setq rWinkel_Abtl (+ rWinkel_Abtl 180.0)))
	

	(if (= (Connect.get CastaData amHtStegLinks)  1) (Traeger.addJoinProfil HTrg Tr_ID xPos_ht rWinkel_Abtl _steg_links_))
	(if (= (Connect.get CastaData amHtStegRechts) 1) (Traeger.addJoinProfil HTrg Tr_ID xPos_ht rWinkel_Abtl _steg_rechts_))
	
	; Anbauteil ermitteln
	(setq abtl_Trg (Traeger.get HTrg abTeil Tr_ID))
	(if (= (Connect.get CastaData linkesEnde)     1) (Anbauteil.set abtl_Trg (addflag  _endelinks_)))
	(if (= (Connect.get CastaData rechtesEnde)    1) (Anbauteil.set abtl_Trg (addflag _enderechts_)))
	(if (= (Connect.get CastaData amHtStegLinks)  1) (Anbauteil.set abtl_Trg (addflag _steg_links_)))
	(if (= (Connect.get CastaData amHtStegRechts) 1) (Anbauteil.set abtl_Trg (addflag _steg_rechts_)))

	
	(setq	dv_HT 	(Traeger.get HTrg delta_V))
	(setq	dv_AT 	(Traeger.get Tr_ID delta_V)
		dlr_AT	(Traeger.get Tr_ID delta_LR)
	)

	(print "Eingangswerte: -----------------------------------------")
	(print dv_HT)
	(print dv_AT)
	(print dlr_AT)


	(print rWinkel_AT)
	(print rWinkel_Abtl)
	(print rWinkel)
	(setq sinWnk  (sin (* PI (/ rWinkel 180.0))))
	(setq cosWnk  (cos (* PI (/ rWinkel 180.0))))
	
	(print sinWnk)
	(print cosWnk)


	(setq delta_V_Abtl dv_AT)
	
	(setq delta_LR_Abtl dlr_AT)
	(if (= (Connect.get CastaData satr-lhtr-ex)    -1)  (setq delta_LR_Abtl (- dlr_AT)))


	(setq delta_V_Abtl_Set  (- (* cosWnk delta_V_Abtl)  (* sinWnk delta_LR_Abtl)))
	(setq delta_LR_Abtl_Set (+ (* cosWnk delta_LR_Abtl) (* sinWnk delta_V_Abtl)))

	(if (= (Connect.get CastaData amHtStegRechts)  1) (setq dv_HT    (- dv_HT)))
	(if (= (Connect.get CastaData linkesEnde)  1) (progn
	    (if (= (Connect.get CastaData satr-lhtr-ex)  1) (setq delta_V_Abtl_Set (- delta_V_Abtl_Set dv_HT)))
	    (if (= (Connect.get CastaData satr-lhtr-ex) -1) (setq delta_V_Abtl_Set (+ delta_V_Abtl_Set dv_HT)))
	))
	(if (= (Connect.get CastaData rechtesEnde)  1) (progn
	    (if (= (Connect.get CastaData satr-lhtr-ex)  1) (setq delta_V_Abtl_Set (+ delta_V_Abtl_Set dv_HT)))
	    (if (= (Connect.get CastaData satr-lhtr-ex) -1) (setq delta_V_Abtl_Set (- delta_V_Abtl_Set dv_HT)))
	))



	(if (= (Connect.get CastaData rechtesEnde)   1) (progn
		(if (= (Connect.get CastaData satr-lhtr-ex)    -1)  (setq delta_V_Abtl_Set (- delta_V_Abtl_Set)))
		(if (= (Connect.get CastaData satr-lhtr-ex)  0) (progn
		    (if (= (Connect.get CastaData satr-vhtr)  1) (setq delta_V_Abtl_Set (- delta_V_Abtl_Set dv_HT)))
		    (if (= (Connect.get CastaData satr-vhtr) -1) (setq delta_V_Abtl_Set (+ delta_V_Abtl_Set dv_HT)))
		))
	))
	(if (= (Connect.get CastaData linkesEnde)   1) (progn
		(if (= (Connect.get CastaData satr-lhtr-ex)     1)  (setq delta_V_Abtl_Set (- delta_V_Abtl_Set)))
		(if (= (Connect.get CastaData satr-lhtr-ex)  0) (progn
		    (if (= (Connect.get CastaData satr-vhtr)  1) (setq delta_V_Abtl_Set (+ delta_V_Abtl_Set dv_HT)))
		    (if (= (Connect.get CastaData satr-vhtr) -1) (setq delta_V_Abtl_Set (- delta_V_Abtl_Set dv_HT)))
		))
	))
	(if (/= (Connect.get CastaData satr-lhtr-ex)  0) (progn
		(if (= (Connect.get CastaData amHtStegRechts)   1) (setq delta_V_Abtl_Set (- delta_V_Abtl_Set)))
	))
	



	(Anbauteil.set abtl_Trg (delta_V  (- delta_V_Abtl_Set)))
	(Anbauteil.set abtl_Trg (delta_LR delta_LR_Abtl_Set))
	
	
	(print delta_V_Abtl_Set)
	(print delta_LR_Abtl_Set)

	(print (Connect.get CastaData satr-lhtr-ex))


)  	
(defun TraegerEndeMerken ()

	(setq EWnkl_Original 90.0)
	(setq delta_L_Original	0.0)
	(if (= (Connect.get CastaData linkesEnde)  1) (progn
		(setq tEnd (Traeger.get TR_ID links))
		(setq EWnkl_Original 	(TrEnde.get tEnd V_Winkel))
		(setq delta_L_Original	(TrEnde.get tEnd delta_L))
	))
	(if (= (Connect.get CastaData rechtesEnde)  1) (progn
		(setq tEnd (Traeger.get TR_ID rechts))
		(setq EWnkl_Original (TrEnde.get tEnd V_Winkel))
		(setq delta_L_Original	(TrEnde.get tEnd delta_L))
	))

)

(defun HT_Flach_Anpassen ()

	(setq EWnkl 90.0)
	(if (= (Connect.get CastaData linkesEnde)  1) (progn
		(setq tEnd (Traeger.get TR_ID links))
		(setq EWnkl (TrEnde.get tEnd V_Winkel))
	))
	(if (= (Connect.get CastaData rechtesEnde)  1) (progn
		(setq tEnd (Traeger.get TR_ID rechts))
		(setq EWnkl (TrEnde.get tEnd V_Winkel))
	))

	(setq lng_HT (Traeger.get HTrg Laenge))
	(print lng_HT)
	
	(if (/= EWnkl 90.0) (progn
		(setq tanW (tan (/ (* PI EWnkl) 180.0)))
		(setq xVoute (/ lng_HT tanW))
		(if (< xVoute 0.0) (setq xVoute (- xVoute)))
		
		(if (= (Connect.get CastaData amHtStegRechts) 1) (progn
			; (AlertBox "amHtStegRechts") (AlertBox lng_HT) (AlertBox xVoute)
			(setq tEnd_HT (Traeger.get HTrg  links))
			(TrEnde.set tEnd_HT (l_voute_unten lng_HT) (h_voute_unten xVoute))
		))
		(if (= (Connect.get CastaData amHtStegLinks) 1) (progn
			; (AlertBox "amHtStegRechts") (AlertBox lng_HT) (AlertBox xVoute)
			(setq tEnd_HT (Traeger.get HTrg  links))
			(TrEnde.set tEnd_HT (l_voute_oben lng_HT) (h_voute_oben xVoute))
		))
		(print xVoute)
	
	))
)
(defun AT_Ende_Anpassen ()

	(setq Flag_Ausfuehren 0)
	(if (= delta_L_Original 0.0)  (setq Flag_Ausfuehren 1))
	(if (/= delta_L_Original 0.0) (setq Flag_Ausfuehren 2))

	(setq tEnd nil)
	(if (> Flag_Ausfuehren 0) (progn
		(if (= (Connect.get CastaData linkesEnde)  1) (progn
			(setq tEnd (Traeger.get TR_ID links))
		))
		(if (= (Connect.get CastaData rechtesEnde)  1) (progn
			(setq tEnd (Traeger.get TR_ID rechts))
		))
	))

	(if (= Flag_Ausfuehren 1) (progn
		(if tEnd (progn
			(setq b_HT (Traeger.get HTrg b))
			(TrEnde.set tEnd (delta_L (* 0.4 b_HT)))
			(TrEnde.set tEnd (V_Winkel EWnkl_Original))
		))
	
	))
	(if (= Flag_Ausfuehren 2) (progn
		(if tEnd (progn
			(setq b_HT (Traeger.get HTrg b))
			(TrEnde.set tEnd (delta_L delta_L_Original))
			(TrEnde.set tEnd (V_Winkel EWnkl_Original))
		))
	
	))
)