; $	HT	QT(F)		AF(F)		P(EZ)
; $	AT	QT(KR)		AF(K)		P(E)
; $	AE	V(-)		H(-)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;	letzte nderung: 	13.04.2006
;	letzte Prfung:		13.04.2006
;	
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (load "mod-endinit-uz-stzsteg")
   (load "mod-multiconnect-stz-steg")
   (load "mod-add-schweiss-querschn")
)

(defun init-connection ()
	(print "*clear*")
	(print "Initialisieren ANSCHLUSS")
	(connect.showattributes CastaData)
	
	(checkPosition)
  (if (= isInside 1) (progn
  	  (init-traegerenden 0)
	  (anpassenAnFlachstahlbreite)
  	  ; (SchweissProfil_Einsetzen_St)	; wird hier nicht vorgesehen
	  (sucheKopfPlatte)
	  (if abtl_Found_Kpl (addStiffeners))
  		
  	  ; berprfung der Umgebung auf Anbauteile
	  (setq anzAnschl (Connect.get CastaData anz_weitere_anschl))
	  (print anzAnschl)
	  (if (> anzAnschl 0)	(checkEnv))
	)
	(progn
  		(alertBox "Anschluss ist nicht mglich!"  "Connection_Not_Possible")
  ))
  				
  
)

; ----------------------------------------------------------------------------------------
; Prft, ob der Steg des AT in den HC-Berech des HT liegt
; ----------------------------------------------------------------------------------------
(defun checkPosition ()
	(print "------------------------------------------------------------")
	(print "BERPRFE AT POSITION")
	(print "------------------------------------------------------------")
	
	(setq	hc_ht 		(Traeger.get Htrg hc)
		delta_v_ht	(Traeger.get Htrg delta_v)
	)
	
	(setq	delta_lr_at	(Traeger.get Tr_ID delta_lr)
		s_at		(Traeger.get Tr_ID s)
	)
	
	; obere und untere Ausrundung des HT
	(setq ausrO_ht (- delta_v_ht (* 0.5 hc_ht)))
	(setq ausrU_ht (+ ausrO_ht hc_ht))
	(print ausrO_ht)
	(print ausrU_ht)
	(print delta_lr_at)
		
	(if (= (Connect.get CastaData satr-vhtr) 1)
		(progn
			(if (> delta_lr_at ausrU_ht)
				(progn
					(setq isInside 0)
				)
				(progn
					(if (< delta_lr_at ausrO_ht)
						(setq isInside 0)
						(setq isInside 1)
					)
				)
			)
		)
	)
	(if (= (Connect.get CastaData satr-vhtr) -1)
		(progn
			(if (> delta_lr_at (- ausrO_ht))
				(progn
					(setq isInside 0)
				)
				(progn
					(if (< delta_lr_at (- ausrU_ht))
						(setq isInside 0)
						(setq isInside 1)
					)
				)
			)
		)
	)
	
	(if (= isInside 0)
		(print "AUSSERHALB")
		(print "INNERHALB")
	)
)



(defun SchweissProfil_Einsetzen ()

;	(print "*clear*")

	; Anschlussdaten ...
	; X-Position
	(setq xPos_ht		(Connect.get CastaData xPos_ht))
	; Rotationswinkel des AT
	(setq rWinkel 0.0)
	(setq rWinkel_AT	(Connect.get CastaData r-atrgewnkl_steg ))

	(if (= (Connect.get CastaData linkesEnde)  1) (progn
	    (if (= (Connect.get CastaData amHtStegLinks)   1) (setq rWinkel    (- rWinkel_AT 90.0)))
	    (if (= (Connect.get CastaData amHtStegRechts)  1) (setq rWinkel (- (- rWinkel_AT 90.0))))
	))
	(if (= (Connect.get CastaData rechtesEnde)  1) (progn
	    (if (= (Connect.get CastaData amHtStegLinks)   1) (setq rWinkel (- (- rWinkel_AT 90.0))))
	    (if (= (Connect.get CastaData amHtStegRechts)  1) (setq rWinkel    (- rWinkel_AT 90.0)))
	))

	(print "----------------") (print rWinkel)

	(setq rWinkel_Abtl rWinkel)
	(if (= (Connect.get CastaData linkesEnde)     1) (progn
		(if (= (Connect.get CastaData satr-lhtr-ex)     1)  (setq rWinkel_Abtl (- rWinkel)))
	))
	(if (= (Connect.get CastaData rechtesEnde)     1) (progn
		(if (= (Connect.get CastaData satr-lhtr-ex)    -1) (setq rWinkel_Abtl (- rWinkel)))
	))
	(if (= (Connect.get CastaData amHtStegLinks)   1) (setq rWinkel_Abtl    (- rWinkel_Abtl)))
	
	(if (< rWinkel_Abtl 0.0) (setq rWinkel_Abtl (+ 180.0 rWinkel_Abtl)))
	(if (= (Connect.get CastaData vatr-lhtr)     1)  (setq rWinkel_Abtl (+ rWinkel_Abtl 180.0)))
	

	(if (= (Connect.get CastaData amHtStegLinks)  1) (Traeger.addJoinProfil HTrg Tr_ID xPos_ht rWinkel_Abtl _steg_links_))
	(if (= (Connect.get CastaData amHtStegRechts) 1) (Traeger.addJoinProfil HTrg Tr_ID xPos_ht rWinkel_Abtl _steg_rechts_))
	
	; Anbauteil ermitteln
	(setq abtl_Trg (Traeger.get HTrg abTeil Tr_ID))
	(if (= (Connect.get CastaData linkesEnde)     1) (Anbauteil.set abtl_Trg (addflag  _endelinks_)))
	(if (= (Connect.get CastaData rechtesEnde)    1) (Anbauteil.set abtl_Trg (addflag _enderechts_)))
	(if (= (Connect.get CastaData amHtStegLinks)  1) (Anbauteil.set abtl_Trg (addflag _steg_links_)))
	(if (= (Connect.get CastaData amHtStegRechts) 1) (Anbauteil.set abtl_Trg (addflag _steg_rechts_)))

	
	(setq	dv_HT 	(Traeger.get HTrg delta_V))
	(setq	dv_AT 	(Traeger.get Tr_ID delta_V)
		dlr_AT	(Traeger.get Tr_ID delta_LR)
	)

	(print "Eingangswerte: -----------------------------------------")
	(print dv_HT)
	(print dv_AT)
	(print dlr_AT)


	(print rWinkel_AT)
	(print rWinkel_Abtl)
	(print rWinkel)
	(setq sinWnk  (sin (* PI (/ rWinkel 180.0))))
	(setq cosWnk  (cos (* PI (/ rWinkel 180.0))))
	
	(print sinWnk)
	(print cosWnk)


	(setq delta_V_Abtl dv_AT)
	
	(setq delta_LR_Abtl dlr_AT)
	(if (= (Connect.get CastaData satr-lhtr-ex)    -1)  (setq delta_LR_Abtl (- dlr_AT)))


	(setq delta_V_Abtl_Set  (- (* cosWnk delta_V_Abtl)  (* sinWnk delta_LR_Abtl)))
	(setq delta_LR_Abtl_Set (+ (* cosWnk delta_LR_Abtl) (* sinWnk delta_V_Abtl)))

	(if (= (Connect.get CastaData amHtStegRechts)  1) (setq dv_HT    (- dv_HT)))
	(if (= (Connect.get CastaData linkesEnde)  1) (progn
	    (if (= (Connect.get CastaData satr-lhtr-ex)  1) (setq delta_V_Abtl_Set (- delta_V_Abtl_Set dv_HT)))
	    (if (= (Connect.get CastaData satr-lhtr-ex) -1) (setq delta_V_Abtl_Set (+ delta_V_Abtl_Set dv_HT)))
	))
	(if (= (Connect.get CastaData rechtesEnde)  1) (progn
	    (if (= (Connect.get CastaData satr-lhtr-ex)  1) (setq delta_V_Abtl_Set (+ delta_V_Abtl_Set dv_HT)))
	    (if (= (Connect.get CastaData satr-lhtr-ex) -1) (setq delta_V_Abtl_Set (- delta_V_Abtl_Set dv_HT)))
	))



	(if (= (Connect.get CastaData rechtesEnde)   1) (progn
		(if (= (Connect.get CastaData satr-lhtr-ex)    -1)  (setq delta_V_Abtl_Set (- delta_V_Abtl_Set)))
		(if (= (Connect.get CastaData satr-lhtr-ex)  0) (progn
		    (if (= (Connect.get CastaData satr-vhtr)  1) (setq delta_V_Abtl_Set (- delta_V_Abtl_Set dv_HT)))
		    (if (= (Connect.get CastaData satr-vhtr) -1) (setq delta_V_Abtl_Set (+ delta_V_Abtl_Set dv_HT)))
		))
	))
	(if (= (Connect.get CastaData linkesEnde)   1) (progn
		(if (= (Connect.get CastaData satr-lhtr-ex)     1)  (setq delta_V_Abtl_Set (- delta_V_Abtl_Set)))
		(if (= (Connect.get CastaData satr-lhtr-ex)  0) (progn
		    (if (= (Connect.get CastaData satr-vhtr)  1) (setq delta_V_Abtl_Set (+ delta_V_Abtl_Set dv_HT)))
		    (if (= (Connect.get CastaData satr-vhtr) -1) (setq delta_V_Abtl_Set (- delta_V_Abtl_Set dv_HT)))
		))
	))
	(if (/= (Connect.get CastaData satr-lhtr-ex)  0) (progn
		(if (= (Connect.get CastaData amHtStegRechts)   1) (setq delta_V_Abtl_Set (- delta_V_Abtl_Set)))
	))
	



	(Anbauteil.set abtl_Trg (delta_V  (- delta_V_Abtl_Set)))
	(Anbauteil.set abtl_Trg (delta_LR delta_LR_Abtl_Set))
	
	
	(print delta_V_Abtl_Set)
	(print delta_LR_Abtl_Set)

	(print (Connect.get CastaData satr-lhtr-ex))


)  	
(defun anpassenAnFlachstahlbreite ()
	(setq	b_HT		(Traeger.get HTrg b)
			dlr_HT		(Traeger.get HTrg delta_LR)
			h_AT		(Traeger.get Tr_ID h)
			dv_AT		(Traeger.get Tr_ID delta_V)
	)
	(setq TEnd_AT nil)
	(if (= (Connect.get CastaData linkesEnde)   1)     (setq TEnd_AT (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde)  1)     (setq TEnd_AT (Traeger.get Tr_ID rechts)))
	(if (= (Connect.get CastaData anHTlinkesEnde)   1) (setq TEnd_HT (Traeger.get HTrg links)))
	(if (= (Connect.get CastaData anHTrechtesEnde)  1) (setq TEnd_HT (Traeger.get HTrg rechts)))
	
	(if TEnd_AT (if TEnd_HT (progn
		(setq EWnkl (TrEnde.get TEnd_AT V_Winkel))
		
		; Sonderfall
		(if (= (Connect.get CastaData amhtstegrechts) 1) (progn
			(if (= (Connect.get CastaData linkesEnde) 1) (setq EWnkl (- 90.0 (- EWnkl 90.0))))
		))
		(if (= (Connect.get CastaData amhtsteglinks) 1) (progn
			(if (= (Connect.get CastaData rechtesEnde) 1) (setq EWnkl (- 90.0 (- EWnkl 90.0))))
		))
		; 

		(setq sinW (sin (/ (* PI EWnkl) 180.0)))
		(setq cosW (cos (/ (* PI EWnkl) 180.0)))
		(setq tanW (tan (/ (* PI EWnkl) 180.0)))
		
		
		(setq Ablng (/ b_HT sinW))
		(setq curr_DL (TrEnde.get TEnd_AT delta_L))
		(setq new_DL (- curr_DL Ablng))
		(TrEnde.set TEnd_AT (delta_L new_DL))

		(setq massg_Brt (- b_HT (* 2.0 (- (* 0.5 b_HT) dlr_HT))))
		; (setq massg_Brt (* 1.0 b_HT))
		(setq AbLng_Fl (* 0.5 (/ massg_Brt tanW)))

		; (setq AbLng_Fl 0.0)
		(setq Anteil_AT (- (* 0.5 h_AT) dv_AT))
		(setq dl_AntAt (/ Anteil_AT sinW))
		
		(setq AbLng_Fl (- AbLng_Fl dl_AntAt))
		
		(TrEnde.set TEnd_HT (delta_L AbLng_Fl))
		
		(TrEnde.set TEnd_HT (H_Winkel EWnkl))

		; (TrEnde.set TEnd_HT (H_Winkel 90.0))
		; (TrEnde.set TEnd_HT (delta_L 0.0))


	)))

)

(defun addStiffeners__X ()
)

(defun addStiffeners ()
	(setq	b_AT	(Traeger.get Tr_ID b)
			t_HT	(Traeger.get HTrg t)
			l_HT	(Traeger.get HTrg Laenge)
			dlr_HT	(Traeger.get HTrg delta_LR)
			h_AT	(Traeger.get Tr_ID h)
			dv_AT	(Traeger.get Tr_ID delta_V)
	)

	(setq KopfPl (Anbauteil.get abtl_Found_Kpl objekt Blech))
	(setq xAsym_KPL (Blech.get KopfPl xAsym))

	(setq dKpl 0.0)
	(if (= (Connect.get CastaData anHTlinkesEnde)   1) (progn
		(setq TEnd_HT 		(Traeger.get HTrg links))
		(setq TEnd_HT_Kpl	(Traeger.get HTrg rechts))
		(setq dKpl (TrEnde.get TEnd_HT_Kpl delta_L))
	))
	(if (= (Connect.get CastaData anHTrechtesEnde)  1) (progn
		(setq TEnd_HT (Traeger.get HTrg rechts))
		(setq TEnd_HT_Kpl	(Traeger.get HTrg links))
		(setq dKpl (TrEnde.get TEnd_HT_Kpl delta_L))
	))
	(setq EWnkl (TrEnde.get TEnd_HT H_Winkel))
	(setq sinW (sin (/ (* PI EWnkl) 180.0)))
	(setq cosW (cos (/ (* PI EWnkl) 180.0)))
	(setq tanW (tan (/ (* PI EWnkl) 180.0)))
	
	(setq dl_HT_Anschl (TrEnde.get TEnd_HT delta_L))
	(setq b_Rel (- (* 0.5 b_HT) dlr_HT))
	(if (< dlr_HT 0.0) (setq b_Rel (- (* 0.5 b_HT) dlr_HT)))
	
	(setq b_Rel  (+ xAsym_KPL (* 0.5 b_HT)))
	(if (< xAsym_KPL 0.0) (setq b_Rel (+ (* -0.5 b_HT) xAsym_KPL)))

	(setq h_Rel  (/ b_Rel tanW))
	
	(setq Anteil_AT (+ (* 0.5 h_AT) dv_AT))
	(setq Anteil_AT h_AT)
	(setq dl_AntAt (/ Anteil_AT sinW))
	(print "-------------- hp Blech ausrechnen ----------")
	(print Anteil_AT) (print dl_AntAt)
	(print h_Rel)

	(setq h_Rel (+ h_Rel dl_AntAt))
	(print h_Rel)

	; man knnte auch bei nicht mittig angesetzten Flachstahl verschieden Blechdicken vorsehen
	(setq bp_Fbl (* 0.5 (- b_AT t_HT)))
	(setq hp_Fbl (- l_HT h_Rel))
	(setq dOK_Fbl 	(* -0.5 hp_Fbl))
	(setq dOK_Fbl (- dOK_Fbl dKpl))
	(setq xAsym_Fbl (- dlr_HT))

	(setq xAsym_Fbl xAsym_KPL)
	
	(setq bp_Fbl (+ bp_Fbl 10))
	
	; (setq b_HT (Traeger.get HTrg b))
	; (setq xAsym_Fbl (* 0.5 b_HT))
	
	(setq bl_OF (blech.create))
	(setq bl_UF (blech.create))
	(blech.set bl_OF (dp 10) (bp bp_Fbl) (hp hp_Fbl) (dOK dOK_Fbl) (xAsym xAsym_Fbl))
	(blech.set bl_UF (dp 10) (bp bp_Fbl) (hp hp_Fbl) (dOK dOK_Fbl) (xAsym xAsym_Fbl))
	
	
	
	(Traeger.addabtl HTrg bl_OF 0.0 0.0 _fahnenblech_of_)
	(Traeger.addabtl HTrg bl_UF 0.0 0.0 _fahnenblech_uf_)
	
	(Connect.storeAnschlObjs CastaData bl_OF bl_UF)

)



(defun sucheKopfPlatte ()

  (setq xPos_HT (Connect.get CastaData xPos_HT))
  (setq gesKnoBlTyp 0) ; auf unknown setzen
  (if (= (connect.get CastaData linkesEnde)  1) (setq gesLchbTyp _kpllochbildlinks_))
  (if (= (connect.get CastaData rechtesEnde) 1) (setq gesLchbTyp _kpllochbildrechts_))

  ; wie suchen die gegenberliegende Kopfplatte, um die Position fr die Steifen zu ermitteln
  (if (= (connect.get CastaData anhtlinkesende)  1) (setq gesBlTyp   _kopfplatterechts_))
  (if (= (connect.get CastaData anhtrechtesende) 1) (setq gesBlTyp   _kopfplattelinks_))

	(setq abtl_Found_Kpl nil)
	(setq abtl_KopfPl (Traeger.get HTrg firstAbtl kopfplatte))
	(while abtl_KopfPl
		; (AlertBox "Element am HTrg gefunden")
		(setq sType     (Anbauteil.get abtl_KopfPl is_type gesBlTyp))
		(if (= sType 1) (progn
			(setq abtl_Found_Kpl abtl_KopfPl)
			(print sType)
		))
		(setq abtl_KopfPl (Traeger.get Htrg nextAbtl kopfplatte))
	)

)
