; $	HT	QT(KIU)		AF(FSK)		P(ZE)
; $	AT	QT(K)		AF(FK)		P(ZE)
; $ 	AE	V(0)		H(90)			R(-)

(defun load-modules ()
	(load "mod-endinit-trg-auf-trg")
)

(defun init-connection ()
	
	(connect.showattributes CastaData)
	(setq LB_DEBUG 0)
	
	(setq connected 0)
	(if (= 1 1)	(progn
		(if (= (Connect.get CastaData vatr-vhtr)  1) (progn
			(init-traegerenden)
			(setConnection)
			(setq connected 1)
		))
		(if (= (Connect.get CastaData vatr-vhtr) -1) (progn
			(init-traegerenden)
			(setConnection)
			(setq connected 1)
		))
		(if (= connected 0) (progn
			(alertbox "Der Anschluss ist z.Z. in dieser Kombination nicht mglich.\n\nBitte rotieren Sie die Trger so, dass die hellen bzw. dunklen Flanschseiten\nin eine Richtung zeigen und tauschen Sie, falls ntig, die Orientierung eines Trgers."  "ERR_BeamRoation_Not_Functional")
		))
	))

	(if (= 1 2)	(progn
	    (Lochbild.set fllochbild
		(e       	"0 25 75 0 0 0")
		(LB_Art		2)
	    )
	))

	
)



(defun setConnection ()
	
	; Abstand zwischen den Trgern berechnen
	; ---------------------------------------------
	(calcLichtenAbst) ; -> lichterAbst
	
	(if (>= lichterAbst 4.0)	(progn

		(setq FlanschLasche (Blech.create))
		(Connect.storeAnschlObjs CastaData FlanschLasche)
		(print "FlanschLasche-Objekt wurde erzeugt!")
			
		(createFlanschLasche FlanschLasche lichterAbst)

		(setq fllochbild (Lochbild.create))
		(Connect.storeAnschlObjs CastaData fllochbild)
	
		(createFlanschLochbild fllochbild lichterAbst)
	))
	(if (< lichterAbst 4.0) (AlertBox "Der lichte Abstand muss mindestens 4.00 mm betragen!" "GapMinWidth_4mm"))
	
	
	
	; TEST
	; ******************************************************************
(if (= LB_DEBUG 1) (progn
	(setq lbdummy (Lochbild.create))
	(Lochbild.copy lbdummy fllochbild)
	
	; Anbauteil dem At hinzufgen
	(if (= (Connect.get CastaData amAtOberflansch) 1)
		(traeger.addabtl Tr_ID lbdummy xPos_at 0.0 _flanschlochbild_of_)	
	)
	(if (= (Connect.get CastaData amAtUnterflansch) 1)
		(traeger.addabtl Tr_ID lbdummy xPos_at 0.0 _flanschlochbild_uf_)
	)
	
	
	(setq AT_ABTeil_dummy (Traeger.get Tr_ID AbTeil lbdummy))
	(Anbauteil.set AT_ABTeil_dummy 	(winkel   winkel_abteil_at)
					(delta_lr		delta_lr_abtl_at)
					(Master    1)
	)
	
	(Connect.storeAnschlObjs CastaData lbdummy)
))
	; ******************************************************************

	(if (= 2 4) (progn
		(setq AT_ABTeil_Lchb (Traeger.get Tr_ID AbTeil fllochbild))
		(setq HT_ABTeil_Lchb (Traeger.get HTrg  AbTeil fllochbild))
		(Anbauteil.set AT_ABTeil_Lchb  (Master    0))
		(Anbauteil.set HT_ABTeil_Lchb  (Master    1))
	))



)



(defun calcAndSetLochbildDaten (Lchb_ID ABST)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")

	(Lochbild.set Lchb_ID
		(S_Bez 		"M12")
		(Guete   	"4.6")
		(e       	"0 0 0 0 0 0")
		(w       	"80  0")
	)
	
	(setq	t_at 	(Traeger.get Tr_ID t)
		b_at	(Traeger.get Tr_ID b)
		s_at	(Traeger.get Tr_ID s)
		r_at	(Traeger.get Tr_ID r)
	)
	
	(setq	t_ht	(Traeger.get Htrg t)
		b_ht	(Traeger.get Htrg b)
		s_ht	(Traeger.get Htrg s)
		r_ht	(Traeger.get Htrg r)
	)
	
	
	
	(setq abzug_at (+ s_at (* 2 r_at)))
	(setq rest_at (- b_at abzug_at))
	
	(setq abzug_ht (+ s_ht (* 2 r_ht)))
	(setq rest_ht (- b_ht abzug_ht))
		
	(setq e1 (+ (* 0.5 rest_at) abzug_at))
	(print e1)
	(setq e1rund (runde e1 auf 5))
	(print e1rund)
	(setq e0 (- (* 0.5 e1)))
	(print e0)
	(setq e0rund (runde e0 auf 5))
	(print e0rund)
	(setq w0 (+ (* 0.5 rest_ht) abzug_ht))
	(print w0)
	(setq w0rund (runde w0 auf 5))
	(print w0rund)
	
	(setq ds 12)				; zentral setzen?
	(setq b_AT (Traeger.get Tr_ID b))
	(setq e1 (+ b_AT (* 4 ds)))
	(setq e0 (- (* -2 ds) (* 0.5 b_AT)))
	
	; dxSKopf
	(setq dxSKopf ABST)

	(Lochbild.set Lchb_ID	(e0		e0)
				(e1		e1)
				(w0		w0) 	
				(klemml 	(+ t_ht ABST))
				(dxSKopf	dxSKopf)
	)
	
	(if (= LB_DEBUG 1)
		(Lochbild.set Lchb_ID	(e2 200))
	)
	
	(if (= 1 1)	(progn
	; ---- an Trgerenden halbe Lochbilder einbauen mit LB_Art 2 - oder -2
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(Lochbild.set Lchb_ID (Lb_Art -2))	)
							(if (= (Connect.get CastaData satr-lhtr) -1)	(Lochbild.set Lchb_ID (Lb_Art  2))	)
						)
					)
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(Lochbild.set Lchb_ID (Lb_Art  2))	)
							(if (= (Connect.get CastaData satr-lhtr) -1)	(Lochbild.set Lchb_ID (Lb_Art -2))	)
						)
					)
				)
			)
			(if (= (Connect.get CastaData amAtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(Lochbild.set Lchb_ID (Lb_Art  2))	)
							(if (= (Connect.get CastaData satr-lhtr) -1)	(Lochbild.set Lchb_ID (Lb_Art -2))	)
						)
					)
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(Lochbild.set Lchb_ID (Lb_Art -2))	)
							(if (= (Connect.get CastaData satr-lhtr) -1)	(Lochbild.set Lchb_ID (Lb_Art  2))	)
						)
					)
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(Lochbild.set Lchb_ID (Lb_Art  2))	)
							(if (= (Connect.get CastaData satr-lhtr) -1)	(Lochbild.set Lchb_ID (Lb_Art -2))	)
						)
					)
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(Lochbild.set Lchb_ID (Lb_Art -2))	)
							(if (= (Connect.get CastaData satr-lhtr) -1)	(Lochbild.set Lchb_ID (Lb_Art  2))	)
						)
					)
				)
			)
			(if (= (Connect.get CastaData amAtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(Lochbild.set Lchb_ID (Lb_Art -2))	)
							(if (= (Connect.get CastaData satr-lhtr) -1)	(Lochbild.set Lchb_ID (Lb_Art  2))	)
						)
					)
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(Lochbild.set Lchb_ID (Lb_Art  2))	)
							(if (= (Connect.get CastaData satr-lhtr) -1)	(Lochbild.set Lchb_ID (Lb_Art -2))	)
						)
					)
				)
			)
		)
	)
	
	(setq lb_art (Lochbild.get Lchb_ID Lb_Art))
	(print lb_art)
	
	))
	(print "<-----------------------------------------------------------")
)




(defun createFlanschLochbild (Lchb_ID ABST)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE FLANSCHLOCHBILD")
	
	(calcAndSetLochbildDaten Lchb_ID ABST)
	
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	(setq xPos_at (Connect.get CastaData xPos_at))
	
	(print xPos_ht)
	(print xPos_at)
		
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _flanschlochbild_of_)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _flanschlochbild_uf_)
	)
	
	(if (= (Connect.get CastaData amAtOberflansch) 1)
		(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _flanschlochbild_of_)
	)
	(if (= (Connect.get CastaData amAtUnterflansch) 1)
		(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _flanschlochbild_uf_)
	)

	; Winkel Anbauteil AT
	; --------------------------
	(setq winkel_abteil_at 0.0)
	
	(if (= (Connect.get CastaData amHtOberflansch)	1)
		(progn
			(if (= (Connect.get CastaData amATOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_at  90.0)	)
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_at 90.0)	)
				)
			)
			(if (= (Connect.get CastaData amATUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_at 270.0)	)
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_at  90.0)	)
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch)	1)
		(progn
			(if (= (Connect.get CastaData amATOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_at 270.0)	)
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_at  90.0)	)
				)
			)
			(if (= (Connect.get CastaData amATUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_at  90.0)	)
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_at 270.0)	)
				)
			)
		)
	)
	
	(if (= (Connect.get CastaData amATFlansch) 1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_ht 0.0)	)
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_ht 0.0)		)
		)
	)
	
	
	; Anbauteil delta_lr AT
	; --------------------------
	(setq delta_lr_ht (Traeger.get Htrg delta_lr))
	
	(setq delta_lr_abtl_at 0.0)
	
	(if (= (Connect.get CastaData AnschlZwAtEnden) 1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_abtl_at (- delta_lr_abtl_at delta_lr_ht))	)
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_abtl_at (- delta_lr_abtl_at delta_lr_ht))	)
		)
	)
	
	(if (= (Connect.get CastaData AnschlZwAtEnden) 0)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_abtl_at (- delta_lr_abtl_at delta_lr_ht))	)
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_abtl_at (- delta_lr_abtl_at delta_lr_ht))	)
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_abtl_at (- delta_lr_abtl_at delta_lr_ht))	)
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_abtl_at (- delta_lr_abtl_at delta_lr_ht))	)
				)
			)
		)
	)
	
	; Anbauteil delta_lr HT
	; --------------------------
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	
	(setq delta_v_abtl_ht 0.0)
	
	(if (= (Connect.get CastaData AnschlZwAtEnden) 1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_lr_at))	)
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht delta_lr_at))	)
		)
	)
	
	(if (= (Connect.get CastaData AnschlZwAtEnden) 0)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_lr_at))	)
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht delta_lr_at))	)
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_lr_at))	)
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht delta_lr_at))	)
				)
			)
		)
	)
			
	; Korrektur, wenn Anschluss aus der anderen Richtung (vormals unten, da fr oben ausgelegt)
	; erzeugt wird (Jan 2015)		
	(if (= (Connect.get CastaData vatr-vhtr) -1) (progn
		(if (> winkel_abteil_ht 180.0) 
			(setq winkel_abteil_ht (- winkel_abteil_ht 180.0))
			(setq winkel_abteil_ht (+ winkel_abteil_ht 180.0))
		)
		(setq 	delta_v_abtl_ht (- delta_v_abtl_ht))
		
		(setq lbArt (Lochbild.get fllochbild LB_Art))
		(if (= lbArt  2) (Lochbild.set fllochbild (LB_Art -2)))
		(if (= lbArt -2) (Lochbild.set fllochbild (LB_Art  2)))
	))
	
	
	; HT-Anbauteil Werte setzen
	(setq HT_ABTeil (Traeger.get Htrg AbTeil Lchb_ID))
	(Anbauteil.set HT_ABTeil 	(winkel   winkel_abteil_ht)
				 	(Master   1)
				 	(delta_v  delta_v_abtl_ht)
	)
	
	; AT-Anbauteil Werte setzen
	(setq AT_ABTeil (Traeger.get Tr_ID AbTeil Lchb_ID))
	(Anbauteil.set AT_ABTeil 	(winkel  	winkel_abteil_at)
					(delta_lr	delta_lr_abtl_at) 
				 	(Master  	0)
	)

	(if (= (Connect.get CastaData vatr-vhtr) -1)	(Anbauteil.set AT_ABTeil 	(SeitRicht  -1)))
	
	(setq qsForm_HT (Traeger.get HTrg qsForm))
	(if (= qsForm_HT "K") (progn
		(Lochbild.set fllochbild (Montage 7))
		(setq AT_ABTeil_Lchb (Traeger.get Tr_ID AbTeil fllochbild))
		(setq HT_ABTeil_Lchb (Traeger.get HTrg  AbTeil fllochbild))
		(Anbauteil.set AT_ABTeil_Lchb  (Master    1))
		(Anbauteil.set HT_ABTeil_Lchb  (Master    0))
		(setq curr_dxsKopf (Lochbild.get fllochbild dxSKopf))
		(setq dp (Blech.get FlanschLasche dp))
		(Lochbild.set  fllochbild (dxSKopf (- curr_dxsKopf dp)))
	))
	
	(print "<-----------------------------------------------------------")
;	...........................................................
)


(defun calcLichtenAbst ()
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "BERECHNE LICHTEN ABSTAND DER TRGER")
	(setq delta_v_at 	(Traeger.get Tr_ID delta_v)
				h_at				(Traeger.get Tr_ID h)
	)
	
	(setq delta_v_ht	(Traeger.get Htrg delta_v)
				h_ht				(Traeger.get Htrg h)
	)
	
	(setq h_at_halb	(* 0.5 h_at))
	(setq h_ht_halb	(* 0.5 h_ht))
	
	(print delta_v_ht)
	(print h_ht_halb)
	(print delta_v_at)
	(print h_at_halb)
	
	(setq pos_ht 0.0)
	(setq pos_at 0.0)
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)		(setq pos_ht (- delta_v_ht h_ht_halb)))
	(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq pos_ht (+ delta_v_ht h_ht_halb)))
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1)		(setq pos_at	(- (- delta_v_at h_at_halb)))	)
			(if (= (Connect.get CastaData amAtUnterflansch) 1)	(setq pos_at	(+ delta_v_at h_at_halb))	)
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1)		(setq pos_at	(- delta_v_at h_at_halb))	)
			(if (= (Connect.get CastaData amAtUnterflansch) 1)	(setq pos_at	(- (- delta_v_at) h_at_halb))	)
		)
	)
	
	
	(print pos_ht)
	(print pos_at)
	
	(setq lichterAbst 0.0)
	
	(if (/= pos_at pos_ht)
		(setq lichterAbst (- pos_at pos_ht))
	)
	
	(print lichterAbst)
	
	(if (< lichterAbst 0.0)
		(setq lichterAbst (- lichterAbst))
	)
	(print lichterAbst)
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)




(defun calcFlanschLasche (BLECH_ID ABST)
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "BERECHNE FlanschLascheDATEN")
	(setq	b_at		(Traeger.get Tr_ID b))
	
	(setq	b_ht		(Traeger.get Htrg b)
		s_ht		(Traeger.get Htrg s)
	)
	
	(setq	ds	12)		; Schraubendurchmesser
	
	; FlanschLaschedicke
	(setq dp_FlBlch ABST)
	
	; Breite
	(setq bp_FlBlch (+ b_at (* 8 ds)))
	
	; Hhe	
	(if (= (Connect.get CastaData anschlZwAtEnden) 0)
		(progn
			;(if (= (Connect.get CastaData linkesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID links)))
			;(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID rechts)))
			
			;(setq delta_l_atende (TrEnde.get AT_Ende delta_l))
			;(print delta_l_atende)
			
			(setq hp_FlBlch (- (* 0.5 b_ht) (* 0.5 s_ht)))
		)
		(progn
			(setq hp_FlBlch b_ht)
		)
	)
	
	(Blech.set BLECH_ID 	(hp hp_FlBlch)
				(bp bp_FlBlch)
				(dp dp_FlBlch)
	)
	
	
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)



(defun createFlanschLasche (BLECH_ID ABST)
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "ERZEUGE FlanschLasche")
	(calcFlanschLasche BLECH_ID ABST)
	
	(setq	delta_lr_ht 	(Traeger.get Htrg delta_lr)
		s_ht		(Traeger.get Htrg s)
	)
	
	(setq xPos_at	(Connect.get CastaData xPos_at))
	
	(setq hp_FlBlch (Blech.get BLECH_ID hp))
	
	; Beim Anschluss mit AT-Enden
	(if (= (Connect.get CastaData anschlZwAtEnden) 0)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (+ xPos_at (* 0.5 hp_FlBlch) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (+ xPos_at (* 0.5 hp_FlBlch) (* 0.5 s_ht))))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (- xPos_at (* 0.5 hp_FlBlch) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (- xPos_at (* 0.5 hp_FlBlch) (* 0.5 s_ht))))
				)
			)
		)
	)
	
	; Anteil delta_lr HT
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (- xPos_at delta_lr_ht)))
				)
			)
			(if (= (Connect.get CastaData amAtUnterflansch) 1)	
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (- xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (- xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
				)
			)
			(if (= (Connect.get CastaData amAtUnterflansch) 1)	
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (- xPos_at delta_lr_ht)))
				)
			)
		)
	)
	;(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (- xPos_at delta_lr_ht)))
	;(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
		
		
	(if (= (Connect.get CastaData amATUnterflansch) 1)	(Traeger.addabtl Tr_ID BLECH_ID xPos_at 0.0 _lasche_uf_))
	(if (= (Connect.get CastaData amATOberflansch) 1)	(Traeger.addabtl Tr_ID BLECH_ID xPos_at 0.0 _lasche_of_))
	
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)



