; $	HT	QT(IU)	 	AF(FS)		P(EZ)
; $	AT	QT(R) 		AF(FS)		P(EZ)
; $	AE	V(-)		H(-)			R(-)

;	Bedingngen: Rohrpfosten sollte nur seitlich verschoben sein, also nicht 90 zur Trgerachsel liegen.

(defun load-modules ()
	(print "Module einladen")
)

(defun init-connection ()
	(print "*clear*")
	(print "Connection erstellen")
	
	(Connect.showAttributes CastaData)

	; Einstellungen ...
	(setq LB_Master_AT  0)
	(setq LB_Master_HT  1)
	
	(setq Anschluss_Erzeugen 1)
	(if (/= (Connect.get CastaData satr-lhtr-ex) 0) (setq Anschluss_Erzeugen 0))
	
	(if (= Anschluss_Erzeugen 1) (progn
		(createConnection)
	))
	
	(if (= Anschluss_Erzeugen 0) (progn
		(alertBox "Anschluss noch nicht mglich."  "Connection_Not_Possible_Yet")
	))
	
	
)
(defun createConnection ()

	(init_Geometry)						; Geometrie initialisieren - Winkel uind Winkelfunktionswerte

	(create_Objects)					; Objekte erzeugen  Bl_Fahne, Bl_Kontaktplatte, Lb_Lochbild
	(optimiereBlech)						; Blech vorbesetzen
	(addFahnenBlech  Bl_Fahne)		; Fahnenbleche
	(addK_Platte Bl_Kontaktplatte)	; Kontaktplatte vorne and Fahnenblech setzen
	(add_Lochbild_Rohr)				; Lochbild im AT einbauen
	(add_Lochbild_HT)					; Lochbild im HT einbauen
	
	(LochbildEinstellungen)			; dxSKopf, Klemmlnge, Schraubenverteilungen
	(Blechlage_optimieren)			; vertikale Lage

	(AT_EndLaenge)					; Rohr-Endlnge anpassen

)

; -------------------------------------------------------------------------------------------------------
; ----- 
; -------------------------------------------------------------------------------------------------------
(defun init_Geometry ()
	(setq Ht_Winkel (Connect.get CastaData  v-atrgewnkl_flansch))
	
	(setq sinV (sin (* PI (/ Ht_Winkel 180.0))))
	(setq cosV (cos (* PI (/ Ht_Winkel 180.0))))
	(setq tanV (tan (* PI (/ Ht_Winkel 180.0))))

	(setq links_vorbei 0)
	(setq rechts_vorbei 0)
	(setq 	dlr_HT	(Traeger.get HTrg delta_LR)
				dlr_AT	(Traeger.get Tr_ID delta_LR)
				b_AT	(Traeger.get Tr_ID b)
				s_HT		(Traeger.get HTrg s)
	)
	(setq  Achs_Abstand 0.0)
	(if (= (Connect.get CastaData satr-shtr)  1) 	(setq Achs_Abstand (-  dlr_AT dlr_HT)))
	(if (= (Connect.get CastaData satr-shtr) -1) 	(setq Achs_Abstand (+  dlr_AT dlr_HT)))
	
	(if (> Achs_Abstand 0) (progn
		(if (= (Connect.get CastaData satr-shtr)  1) 	(setq rechts_vorbei 1))
		(if (= (Connect.get CastaData satr-shtr) -1) 	(setq links_vorbei 1))
	))
	(if (< Achs_Abstand 0) (progn
		(if (= (Connect.get CastaData satr-shtr)  1) 	(setq links_vorbei 1))
		(if (= (Connect.get CastaData satr-shtr) -1) 	(setq rechts_vorbei 1))
		(setq Achs_Abstand (- Achs_Abstand))
	))

	(setq an_AT_links    0)
	(setq an_AT_rechts 0)
	(if (= links_vorbei 1) (progn
		(if (= (Connect.get CastaData satr-shtr)  1) 	(setq an_AT_rechts    1))
		(if (= (Connect.get CastaData satr-shtr) -1) 	(setq an_AT_links 1))
	))
	(if (= rechts_vorbei 1) (progn
		(if (= (Connect.get CastaData satr-shtr)  1) 	(setq an_AT_links  1))
		(if (= (Connect.get CastaData satr-shtr) -1) 	(setq an_AT_rechts     1))
	))
	
	(setq h_HT 	(Traeger.get HTrg h)
			 dv_HT 	(Traeger.get HTrg delta_V)
	)
	; Achsenlnge berechnen, von dieser relativ aus die brigen Werte
	(setq AchsenLaenge 	(+ (* 0.5 h_HT) dv_HT))
	(setq AchsenLaenge 	(/ (* 1.0  AchsenLaenge) sinV))

)
; -------------------------------------------------------------------------------------------------------
(defun create_Objects ()
	(setq Bl_Fahne_Rohr (Blech.create))
	(Blech.set  Bl_Fahne_Rohr (hp 200) (bp 100) (dp 10))

	(setq Bl_Kontaktplatte (Blech.create))
	(Blech.set  Bl_Kontaktplatte (hp 200) (bp 180) (dp 10))

	(setq Lb_Lochbild (Lochbild.create))
	(Lochbild.set  Lb_Lochbild 
			(S_Bez		"M12")
			(Guete   "4.6")
			(e			"0  20 80 0 0 0")
			(LB_Art  0)
			(w		"30 0")
	)

	(Connect.storeAnschlObjs CastaData Bl_Fahne_Rohr  Bl_Kontaktplatte Lb_Lochbild)
;	(Connect.storeAnschlObjs CastaData Bl_Fahne_Rohr Bl_Kontaktplatte)

)
; -------------------------------------------------------------------------------------------------------
(defun AT_EndLaenge ()
	(setq h_HT 	(Traeger.get HTrg h)
			 dv_HT 	(Traeger.get HTrg delta_V)
	)
	(setq dl_EndLaenge (+ (* 0.5 h_HT) dv_HT))
	(setq  dl_EndLaenge (/ dl_EndLaenge sinV))

	; Wenn Bleche schon berechnet wurden, dann hier an der Unterkante des Blechs orientieren
	(if (= 1 1) (progn
		(setq dOK_Kp  	(Blech.get Bl_Kontaktplatte dOK)
				  hp_Kp		(Blech.get Bl_Kontaktplatte hp)
		)
		(setq dl_EndLaenge (+ dOK_Kp (* 0.5 hp_Kp) 10.0))
	))
	
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
			(setq tEnde (Traeger.get Tr_ID links))
			(TrEnde.set tEnde (delta_L (- dl_EndLaenge)))
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
			(setq tEnde (Traeger.get Tr_ID rechts))
			(TrEnde.set tEnde (delta_L (- dl_EndLaenge)))
	))
	
	
)
; -------------------------------------------------------------------------------------------------------
(defun addFahnenBlech  (Blech_ID)

	(setq h_HT 	(Traeger.get HTrg h)
			 dv_HT 	(Traeger.get HTrg delta_V)
	)
	; Achsenlnge berechnen, von dieser relativ aus die brigen Werte
	(setq h_HT2_schraeg (/  (* 0.5 h_HT) sinV))

	; Breite berechnen - Abstand zwischen HT und AT
	(setq 	dlr_HT	(Traeger.get HTrg delta_LR)
				dlr_AT	(Traeger.get Tr_ID delta_LR)
				b_AT	(Traeger.get Tr_ID b)
				s_HT		(Traeger.get HTrg s)
				b_HT		(Traeger.get HTrg b)
	)
	(print links_vorbei)
	(print rechts_vorbei)

	(setq bp_Fahne (- Achs_Abstand (* 0.5 b_AT))) 

	(setq  qsForm_HT (Traeger.get HTrg qsForm))
	(if (= qsForm_HT "U") (progn
		(if  (= rechts_vorbei 1)  (setq bp_Fahne (- bp_Fahne s_HT)))
	))
	(if (= qsForm_HT "I") (progn
		(setq bp_Fahne (- bp_Fahne (* 0.5 s_HT)))
	))
	(if (= qsForm_HT "K") (progn
		(setq bp_Fahne (- bp_Fahne (* 0.5 b_HT)))
	))
	(setq dp_KPLatte (Blech.get  Bl_Kontaktplatte dp))
	(setq  bp_Fahne (- bp_Fahne dp_KPLatte))

	; Blech mittig vertkal einsetzen
	(setq d_BlOK    		(- AchsenLaenge  h_HT2_schraeg))
	; (setq d_BlOK    		(* 0.5 AchsenLaenge))						; zur Kontrolle, reicht dann von UK bis zum Systempunkt
	; (Blech.set  Blech_ID	(hp AchsenLaenge))						; wenn diese beiden Zeilen aktiv sin
													
	; wenn aber  die Profilhhe etwas grer ausfllt, dann das Blech nach oben setzen.
	; (setq d_OK_opt		(Blech.get  Blech_ID dOK))
	; (if (> (- d_BlOK d_OK_opt) 20) (setq d_BlOK d_OK_opt))
	
	(Blech.set  Blech_ID	
									(bp bp_Fahne)
									(dOK d_BlOK)
	)


	(setq xPos_AT (Connect.get CastaData xPos_AT))
	
	(if (= an_AT_links 1)    (traeger.addabtl Tr_ID Blech_ID xPos_AT 0.0 _fahnenblech_steg_li_))
	(if (= an_AT_rechts 1) (traeger.addabtl Tr_ID Blech_ID xPos_AT 0.0 _fahnenblech_steg_re_))

)
; ---------------------------------------------------------------------------------------
(defun addK_Platte (Blech_ID)

	(setq rWinkel 0.0)
	(if (= (Connect.get CastaData at-von-unten) 1) (setq  rWinkel 180.0))

	(setq xPos_AT (Connect.get CastaData xPos_AT))
	(if (= an_AT_links 1)    (traeger.addabtl Tr_ID Blech_ID xPos_AT rWinkel _lasche_steg_li_))
	(if (= an_AT_rechts 1) (traeger.addabtl Tr_ID Blech_ID xPos_AT rWinkel _lasche_steg_re_))
	
	; Oberkante wird vom Fahnenblech bernommen.
	(setq dOK_Fahne (Blech.get  Bl_Fahne_Rohr dOK)
			 bp_Fahne   (Blech.get  Bl_Fahne_Rohr bp)
	)
	(Blech.set  Blech_ID (dOK  dOK_Fahne)
								 (delta_y bp_Fahne)
	)


)
; -------------------------------------------------------------------------------------------------------
(defun add_Lochbild_Rohr ()
	; _couponlochbild_links_		_couponlochbild_rechts_
	(setq rWinkel 0.0)
	(if (= (Connect.get CastaData at-von-unten) 1) (setq  rWinkel 180.0))
	(setq xPos_AT (Connect.get CastaData xPos_AT))

	(if (= an_AT_links 1)    (traeger.addabtl Tr_ID Lb_Lochbild xPos_AT rWinkel _steglochbild_system_))
	(if (= an_AT_rechts 1) (traeger.addabtl Tr_ID Lb_Lochbild xPos_AT rWinkel _steglochbild_system_))

	;  setVariableInt("_steg_links_"				, 	AB_STEG_LINKS);
	;  setVariableInt("_steg_rechts_"			, 	AB_STEG_RECHTS);

	
	(setq abtl_Lchb_AT (traeger.get Tr_ID ABTeil  Lb_Lochbild))
	(Anbauteil.set  abtl_Lchb_AT (Master LB_Master_AT))
	(if (= an_AT_links 1)    (Anbauteil.set  abtl_Lchb_AT (switch_on 	_steg_links_)))
	(if (= an_AT_rechts 1) (Anbauteil.set  abtl_Lchb_AT (switch_on 	_steg_rechts_)))
	
	(setq dOK_Fahne (Blech.get  Bl_Fahne_Rohr dOK)
			 bp_Fahne   (Blech.get  Bl_Fahne_Rohr bp)
			 dp_Apl		 (Blech.get   Bl_Kontaktplatte  dp)
	)
	(setq b_AT		(Traeger.get  Tr_ID b)
			 s_HT		(Traeger.get HTrg s)
	)
	(setq s_Abstand 0.0)
	(if (= (Connect.get CastaData  satr-shtr)  -1) (progn
		(if (= links_vorbei 1) 	(setq s_Abstand (- (+ (* 0.5 b_AT) bp_Fahne  s_HT dp_Apl))))
		(if (= rechts_vorbei 1) 	(setq s_Abstand (+ (* 0.5 b_AT) bp_Fahne)))
		(Anbauteil.set  abtl_Lchb_AT (SeitRicht  -1))
	))
	(if (= (Connect.get CastaData  satr-shtr)  1) (progn
		(if (= links_vorbei 1) 	(setq s_Abstand (+ (* 0.5 b_AT) bp_Fahne)))
		(if (= rechts_vorbei 1) 	(setq s_Abstand (- (+ (* 0.5 b_AT) bp_Fahne  s_HT dp_Apl))))
	))


	(Anbauteil.set  abtl_Lchb_AT (Delta_SX  s_Abstand))
	
)
; -------------------------------------------------------------------------------------------------------
(defun	add_Lochbild_HT ()
	(setq xPos_HT (Connect.get CastaData xPos_HT))
	(setq rWinkel 0.0)
	(setq dlV_HT		(Traeger.get HTrg delta_V))
	(setq dp_Apl		(Blech.get   Bl_Kontaktplatte dp))

	(traeger.addabtl HTrg  Lb_Lochbild xPos_HT rWinkel _steglochbild_system_)

	(setq abtl_Lchb_HT (traeger.get HTrg ABTeil  Lb_Lochbild))
	(Anbauteil.set  abtl_Lchb_HT (Master  LB_Master_HT))

	(setq dx_SKopf  0.0)
	(if (= links_vorbei 1) 		(setq dx_SKopf  dp_Apl))
	(Lochbild.set  Lb_Lochbild (dxSKopf  dx_SKopf))

	(setq lbWinkel 0.0)
	
	(if (= (Connect.get CastaData  satr-shtr)  1) (setq  lbWinkel  (- HT_Winkel)))
	(if (= (Connect.get CastaData  satr-shtr) -1) (setq  lbWinkel  (+ HT_Winkel  180.0)))

	; wenn at-von-oben, dann Winkel umdrehen
;	(if (= (Connect.get CastaData  at-von-oben)  1) (setq  lbWinkel  (+ lbWinkel 180.0)))
	

	(setq lb_SeitVersch (* dlV_HT cosV))
	(setq lb_VertVersch (- (* dlV_HT sinV)))
	(if (= (Connect.get CastaData  satr-shtr)  -1) (progn
		(setq lb_SeitVersch (* (- dlV_HT)  cosV))
	))


	
	(Anbauteil.set  abtl_Lchb_HT (Winkel  lbWinkel))

	(Anbauteil.set  abtl_Lchb_HT 
			(delta_LR  lb_SeitVersch)
			(delta_V  lb_VertVersch)
	)
	
)
; -------------------------------------------------------------------------------------------------------
(defun LochbildEinstellungen ()
	(setq s_HT 	(Traeger.get HTrg s)
			 dp_Apl (Blech.get  Bl_Kontaktplatte dp)
	)
	(setq KlemmLaenge (+ s_HT dp_Apl))
	
	(Lochbild.set  Lb_Lochbild (klemml  KlemmLaenge))
	
	(setq dOK_Bl 	(Blech.get Bl_Kontaktplatte dOK)
			 hp_Bl		(Blech.get Bl_Kontaktplatte hp)
	)
	(setq sd (Lochbild.get Lb_Lochbild sdurchm))
	(setq  e_Oben (runde (*  2.0 sd) auf 5))
	(setq  e0_lb  (- (+ e_Oben dOK_Bl) (* 0.5 hp_Bl))
			  e1_lb  (-  hp_Bl e_Oben e_Oben)
			  w0_lb (runde (* 4.0 sd) auf 10)
	)
	
	(print "-----------------------------------")
	(print  e_Oben) (print dOK_Bl) (print e0_lb)
	(print "-----------------------------------")
	
	(Lochbild.set  Lb_Lochbild (e "0 0 0 0 0 0")
										 (e0  e0_lb)
										 (e1  e1_lb)
										 (w0 w0_lb)
	)
	

)
; -------------------------------------------------------------------------------------------------------
(defun optimiereBlech ()
	; verfgbare Hhe bestimmen
	(setq qsType_HT (Traeger.get HTrg qsForm))
	(setq h_HT		(Traeger.get HTrg h)
			  t_HT		(Traeger.get HTrg t)
			  r_HT		(Traeger.get hTrg r)
			  hRand		(-  (* 0.5 h_HT)  t_HT r_HT)
			  hc_HT     0.0
	)
	
	(if (= qsType_HT "I")  (setq hc_HT  (Traeger.get HTrg hc)))
	(if (= qsType_HT "U")  (setq hc_HT  (Traeger.get HTrg hc)))
	
	(setq  h_HT_verf  h_HT)
	(if (> hc_HT 0.0) (progn
		(setq  hRand (*  0.5 (- h_HT  hc_HT)))
		(setq  h_HT_verf  hc_HT)
	))
	
	(setq tan_Alfa tanV)
	(setq cos_Alfa cosV)
	(if (<  tan_Alfa 0.0) (setq tan_Alfa (- tan_Alfa)))
	(if (<  cos_Alfa 0.0) (setq cos_Alfa (- cos_Alfa)))
	

	(setq sd (Lochbild.get Lb_Lochbild sdurchm))
	(setq bp_Opt (runde (* 8.0 sd) auf 10))
	
	
	
	(setq h_Max  h_HT_verf)		; bei 90 Winkel passt das dann schon

	(print  h_HT_verf)
	
	(print  bp_Opt)
	(print  h_Max)
	
	(if (/= HT_Winkel 90.0) (progn
		(setq  h_HT_verf (/ h_HT_verf cos_Alfa))
		(setq h_Max (- h_HT_verf  (/ bp_Opt tan_Alfa)))		 ;  bp_Opt /  tanV
		(setq hRand (/ hRand tan_Alfa))
	))

	(print  h_HT_verf)
	(print  h_Max)
	(setq  Optimale_Abm 0)
	
	(if (> h_Max  bp_Opt) (progn
			(setq  dOK_Optimal (+ hRand  (* 0.5 bp_Opt)))
			(Blech.set Bl_Kontaktplatte
					(bp bp_Opt)
					(hp bp_Opt)
					(dOK   dOK_Optimal)
			)
			(Blech.set  Bl_Fahne_Rohr
					(hp bp_Opt)
					(dOK   dOK_Optimal)
			)
			(setq  Optimale_Abm 1)
	  )
	  (progn
			(setq  dOK_Optimal (+ hRand  (* 0.5 bp_Opt)))
			(Blech.set Bl_Kontaktplatte
					(bp bp_Opt)
					(hp h_Max)
					(dOK   dOK_Optimal)
			)
			(Blech.set  Bl_Fahne_Rohr
					(hp h_Max)
					(dOK   dOK_Optimal)
			)
	))

;	(if (= Optimale_Abm 1) (progn
;		(AlertBox  Optimale_Abm)
;		(Blech.set  Bl_Fahne_Rohr			(dOK 0.0))
;		(Blech.set  Bl_Kontaktplatte (dOK 100.0))
;	))
	
;	(setq hp_Test (Blech.get Bl_Fahne_Rohr hp)) (print  hp_Test)
;	(setq hp_Test (Blech.get Bl_Kontaktplatte hp)) (print  hp_Test)
	
)
(defun 	Blechlage_optimieren ()

	(setq sin_Alfa sinV)
	(setq cos_Alfa cosV)
	(setq tan_Alfa tanV)
	(if (<  sin_Alfa 0.0) (setq sin_Alfa (- sin_Alfa)))
	(if (<  cos_Alfa 0.0) (setq cos_Alfa (- cos_Alfa)))
	(if (<  tan_Alfa 0.0) (setq tan_Alfa (- tan_Alfa)))

	(setq qsType_HT (Traeger.get HTrg qsForm))
	(setq h_HT		(Traeger.get HTrg h)
			  t_HT		(Traeger.get HTrg t)
			  r_HT		(Traeger.get hTrg r)
			  hRand		(-  (* 0.5 h_HT)  t_HT r_HT)			; Vorgabe hRan
			  hc_HT     0.0												; default, falls nicht angegeben
			  hGesamt  h_HT											; default, falls Winkel nicht passt
			  dOK_erf_bp		0.0										; horizontal ist dieser Wert nicht erforderlich
	)
	
	(if (= qsType_HT "I")  (setq hc_HT  (Traeger.get HTrg hc)))
	(if (= qsType_HT "U")  (setq hc_HT  (Traeger.get HTrg hc)))
	
	(setq  h_HT_verf  h_HT)
	(if (> hc_HT 0.0) (progn
		(setq  hRand (*  0.5 (- h_HT  hc_HT)))
		(setq  h_HT_verf  hc_HT)
	))

	
	(setq bp_Vorh   (Blech.get  Bl_Kontaktplatte bp))
	(setq hp_Vorh   (Blech.get  Bl_Kontaktplatte hp))
	(setq dOK_Vorh (Blech.get  Bl_Kontaktplatte dOK))

	; ---- jetzt Winkel checken, damit
	(if (/= HT_Winkel 90.0) (progn
		(setq hGesamt (/  h_HT sinV))
		(setq  h_HT_verf (/ h_HT_verf sinV))
		(setq dOK_erf_bp (/ (* 0.5 bp_Vorh) tan_Alfa))
		(setq hRand (/ hRand sin_Alfa))
	))

	(setq h_HT_erf  (+ (* sin_Alfa hp_Vorh) (* cos_Alfa bp_Vorh)))
	(print  h_HT_erf)
	
	(print "-------------------------------- Blechlage_optimieren")
	(print AchsenLaenge)
	(print  hGesamt)
	(print h_HT_verf)
	(print  dOK_Vorh)
	
	(setq w_OK (+ (- AchsenLaenge  hGesamt)  (* 0.5 hp_Vorh)))
	(setq w_OK (+   w_OK dOK_erf_bp  hRand))

	(setq dOK_diff (- dOK_Vorh w_OK))

	; irgendwann ist es sinnvoll, die Platte lieber mittig zu platzieren
	(if (>  dOK_diff 25.0) (progn
		(Blech.set  Bl_Kontaktplatte (dOK  w_OK))
		(Blech.set  Bl_Fahne_Rohr			(dOK w_OK))
		
		(if (= (Connect.get CastaData at-von-oben) 1) (progn
			 (Blech.set  Bl_Fahne_Rohr			(dOK (-  w_OK)))
		))
		
		
		(setq e0 (Lochbild.get  Lb_Lochbild e0))				(print e0)
		(setq e0 (- e0 (- dOK_Vorh  w_OK)))					(print e0)
		(Lochbild.set  Lb_Lochbild	(e0 e0))
;		(Lochbild.set  Lb_Lochbild	(e0 (- e0 25))  (e1 20) (e2 75))
	))
;		(Blech.set  Bl_Fahne_Rohr			(dOK 0.0))
;		(Blech.set  Bl_Kontaktplatte (dOK  0.0))
	(if (<=  dOK_diff 25.0) (progn
		(Blech.set  Bl_Kontaktplatte (dOK  w_OK))
		(Blech.set  Bl_Fahne_Rohr			(dOK w_OK))
		
		(if (= (Connect.get CastaData at-von-oben) 1) (progn
			 (Blech.set  Bl_Fahne_Rohr			(dOK (-  w_OK)))
		))
		
		
		(setq e0 (Lochbild.get  Lb_Lochbild e0))				(print e0)
		(setq e0 (- e0 (- dOK_Vorh  w_OK)))					(print e0)
		(Lochbild.set  Lb_Lochbild	(e0 e0))
		
		(if (>  h_HT_erf  h_HT_verf) (progn
			(Blech.set  Bl_Kontaktplatte  (bp  (+ 5.0 (*  0.5 bp_Vorh)))
													(xAsym  (- (* 0.25 bp_Vorh) 5))
			)
			(if (= (Connect.get CastaData  at-von-unten) 1) (progn
				(if (= (Connect.get CastaData vAtr-lHtr) 1)  			(Blech.set  Bl_Kontaktplatte  (xAsym  (- (- (* 0.25 bp_Vorh) 5)))))
			))
			(if (= (Connect.get CastaData  at-von-oben) 1) (progn
				(if (= (Connect.get CastaData vAtr-lHtr)  -1)  			(Blech.set  Bl_Kontaktplatte  (xAsym  (- (- (* 0.25 bp_Vorh) 5)))))
			))
			(Lochbild.set  Lb_Lochbild	(LB_Art 2))
		))
	))

	(setq e1_vorh (Lochbild.get   Lb_Lochbild e1))
	(setq sd (Lochbild.get Lb_Lochbild sdurchm))
	(if (< e1_vorh (* 2.5 sd)) (progn
		(setq e0_vorh (Lochbild.get   Lb_Lochbild e0))
		(setq e0_neu (+ e0_vorh (* 0.5 e1_vorh)))
		(Lochbild.set  Lb_Lochbild (e0 e0_neu) (e1 0))
	))
	

)
