; $ G(20)	HT	QT(IUKR)	AF(FS)		P(EZ)
; $ G(20)	AT	QT(L)		AF(FS)		P(E)
; $ G(20)	AE	V(-)		H(-)		R(-)
; $		HT	QT(FIUKR)		AF(FS)		P(EZ)
; $ 	AT	QT(RK)			AF(K)		P(E)
; $		AE	V(-)			H(-)		R(-)

(defun load-modules ()
  ; Profil prfen
  (setq qsform_at (Traeger.get Tr_ID qsform))
  (print qsform_at)
  
;  (setq AnschlTyp (Connect.get CastaData Anschlusstyp))
;  (AlertBox AnschlTyp)
  
  (if (= (Connect.get CastaData Anschlusstyp) 20) (progn
	  (if (= qsform_at "L")	(load "mod-calc-windverband_krz_L"))
	)
	(progn
	  (if (= qsform_at "R") (load "mod-calc-schwertrund_KR"  "Connection_Not_Possible_Yet"))
	  (if (= qsform_at "K") (load "mod-calc-schwertrund_KR"  "Connection_Not_Possible_Yet"))
	)
  )  
  
  (load "mod-lochbild")
)

(defun init-connection ()

  (print "*clear*")
  (print "********************************************************************")
  (print "in init-connection - stz_Windverb_standard");
   
  (connect.ShowAttributes CastaData)

  ; neu eingebaut - Sept 2011 
  (setq AnschlussAusfuehren 1)
  (setq qsform_Ht (Traeger.get HTrg qsform))
  (if (= qsform_Ht "R") (Untersuchung_AnschlMoegl))
  
  (if (= AnschlussAusfuehren 1) (progn
	  (setq b_at (Traeger.get Tr_ID b))
	  (setq l_schr 0);200)
	  (setq parallel_abstand_stz 30)
		(setq parallel_abstand_trgEnde 30)
	  (setq rand_abst (* 0.5 b_at))
		
		(setq STD 1)
		(if (= qsform_at "R") (progn
			(rProf)
		))
		(if (= qsform_at "K") (progn
			(rProf)
		))
	  (if (= qsform_Ht "R") (Untersuchung_Knbl_Aussmitte))
	  
	; ------------- Test-Szenario
	(if (= 1 2) (progn
		; (print "*clear*")
	  	(setq AbtlKnoBlLchbAT    (Traeger.get Tr_ID AbTeil knblLochbild))
	  	(setq AbtlKnoBlLchbHT    (Traeger.get HTrg  AbTeil knblLochbild))
	  	
	  	(Anbauteil.set AbtlKnoBlLchbAT (Master 0))
	  	(Anbauteil.set AbtlKnoBlLchbHT (Master 1))
	 	
	  	; (Lochbild.set knblLochbild (delta_w    20))
	 	; (Lochbild.set knblLochbild (w0         10))
	 	; (Lochbild.set knblLochbild (e1         100) (e2 20))
	 	(Lochbild.set knblLochbild (e0 0) (e1         20) (e2 100))
	  	; (Lochbild.set knblLochbild (lb_art 0))
	
		(setq Lb_dOK (Lochbild.get knblLochbild dOK))
	
		(setq dv_AT (Anbauteil.get AbtlKnoBlLchbAT delta_V))
		
		(setq dv_AT (- Lb_dOK))
		; (Anbauteil.set AbtlKnoBlLchbAT (delta_V dv_AT))
		(print Lb_dOK)
		(print dv_AT)
	
	
		(print "Check-Seitenrichtungen")  	
	  	(setq SeitRichtung_AT (Anbauteil.get AbtlKnoBlLchbAT SeitRicht))
	  	(print SeitRichtung_AT)
	  	(setq SeitRichtung_HT (Anbauteil.get AbtlKnoBlLchbHT SeitRicht))
	  	(print SeitRichtung_HT)
	  	
	 ; 	(Anbauteil.set AbtlKnoBlLchbHT (SeitRicht  -1))
	
		(setq LB_Art (Lochbild.get knblLochbild LB_Art))
		(print LB_Art)
	))	  
  ))

)
; --- ergnzt Sept. 2011 fr Anschlsse an Rohre als Haupttrger
(defun Untersuchung_AnschlMoegl ()
    (if (= (Connect.get CastaData amHtSteg) 1) (progn
	(setq EbenenWinkel (Connect.get CastaData afl_VWinkel))
	(setq EbenenWinkel (runde EbenenWinkel auf 0))

	(setq AnschlussAusfuehren 0)
	(if (= EbenenWinkel  90.0) (setq AnschlussAusfuehren 1))
	(if (= EbenenWinkel 180.0) (setq AnschlussAusfuehren 1))
    ))
    (if (= (Connect.get CastaData amHtFlansch) 1) (progn
	(setq EbenenWinkel (Connect.get CastaData afl_HWinkel))
	(setq EbenenWinkel (runde EbenenWinkel auf 0))

	(setq AnschlussAusfuehren 0)
	(if (= EbenenWinkel   0.0) (setq AnschlussAusfuehren 1))
	(if (= EbenenWinkel 180.0) (setq AnschlussAusfuehren 1))
    ))
    (if (= AnschlussAusfuehren 0) (AlertBox "Anschluss wird nicht erstellt!\nDer Winkel in der Windverbandsebene ist unpassend." "ERR_AngleInPlaneProblem"))
)
(defun Untersuchung_Knbl_Aussmitte ()
   (if (objExist knotenBlech) (progn
     (setq	h_HT	(Traeger.get HTrg h)
		r	(/ h_HT 2.0)
		a	(Blech.get knotenBlech delta_LR)
		dp	(Blech.get knotenBlech dp)
		a1	(- a (* 0.5 dp))
		a2	(+ a (* 0.5 dp))
      )
      (setq	x1	(- r (sqrt (- (* r r) (* a1 a1)))))
      (setq	x2	(- r (sqrt (- (* r r) (* a2 a2)))))
      
      (if (< x1 x2) (progn
          (if (>= x1 1.0) (WarnMeldung_Ausmitte x2))
      ))
      (if (< x2 x1) (progn
          (if (>= x2 1.0) (WarnMeldung_Ausmitte x1))
      ))
   ))
)
(defun WarnMeldung_Ausmitte (klaffende_Fuge)
  (alertBox "Achtung!!\n\nDurch die ausmittige Lage des Knotenblechs ist ein Spalt von 1mm der nahen Kante zu verzeichnen!\nBitte beachten Sie die klaffende Fuge - durch Schweinaht zu verschlieen." "NOTE_GapToClose")
  (alertBox klaffende_Fuge)
)

; ----------------------------------------------------------------------------------------
(defun rProf ()
	
	(setq delta_v_at 	(Traeger.get Tr_ID delta_v))
	(setq delta_lr_at	(Traeger.get Tr_ID delta_lr))
	
	(if (= (Connect.get CastaData satr-lhtr) 0)
		(progn
			; (Traeger.set Tr_ID (r_winkel 90.0))
			(alertBox "Die Orientierung des Anschlusstrgers muss angepasst werden - bitte in die Ebene rotieren!" "ERR_Rotate_AT_90")
		)
		(progn
			(if (= (Connect.get CastaData amHtFlansch) 1)
				(progn
					(if (/= (Connect.get CastaData satr-vhtr) 0)
						(progn
							(if (/= (Connect.get CastaData vatr-shtr) 0)
								(progn 
									(init-windverband)
									; CALLBACKS
									(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
									(Blech.set augenBlech 	(formFkt "cb_augenBlech_1"))
									(Blech.set augenBlech_2	(formFkt "cb_augenBlech_2"))
									(Blech.set blKopfpl		(formFkt "cb_kopfpl"))
								)
								(alertBox "Bitte passen Sie die rel. Lage des Anschlusstrgers dem Haupttrger an." "ModifyRelativePos_AT_HT")
							)
						)
						(progn
							(if (/= (Connect.get CastaData vatr-shtr) 0)
								(progn 
									(init-windverband)
									; CALLBACKS
									(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
									(Blech.set augenBlech 	(formFkt "cb_augenBlech_1"))
									(Blech.set augenBlech_2	(formFkt "cb_augenBlech_2"))
									(Blech.set blKopfpl		(formFkt "cb_kopfpl"))
								)
								(alertBox "Bitte passen Sie die rel. Lage des Anschlusstrgers dem Haupttrger an." "ModifyRelativePos_AT_HT")
							)
						)
					)
				)
			)
			(if (= (Connect.get CastaData amHtSteg) 1)
				(progn
					(if (/= (Connect.get CastaData vatr-vhtr) 0)
						(progn
							(init-windverband)
							; CALLBACKS
							(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
							(Blech.set augenBlech 	(formFkt "cb_augenBlech_1"))
							(Blech.set augenBlech_2	(formFkt "cb_augenBlech_2"))
							(Blech.set blKopfpl		(formFkt "cb_kopfpl"))
						)
					)
				)
			)
		)
	)

	
)


; ----------------------------------------------------------------------------------------
; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Knotenblech am HT
; ----------------------------------------------------------------------------------------
(defun cb_knotenBlech (zp)
	(print "in Callback-Funktion cb_knotenBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get knotenBlech dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get knotenBlech dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
					(setq	dpDiff		(- dpNeu dpAlt))
					(setq	alteKlemml 	(Lochbild.get knblLochbild Klemml)
						altesDxSKopf	(Lochbild.get knblLochbild dxSKopf)
					)
					
					(setq delta_lr_Alt 	(Blech.get knotenBlech delta_lr))
					
					(setq delta_v_at_alt	(Traeger.get Tr_ID delta_v)
								delta_lr_at_alt	(Traeger.get Tr_ID delta_lr)
					)
					(print delta_v_at_alt)
					(print delta_lr_at_alt)
					
					(setq qsform_at (Traeger.get Tr_ID qsform))
					
					; Flachstahl
					; --------------------------------------
					(if (= qsform_at "F") (progn
							(print "Flachstahl-Profil")
							(Lochbild.set knblLochbild 	(Klemml 	(+ alteKlemml dpDiff)))
							
							(if (= (Connect.get CastaData satr-lhtr)  1)
								(progn
									(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
								)
							)
							(if (= (Connect.get CastaData satr-lhtr) -1)	
								(progn
									(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
									(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
								)
							)
					))
					
					; Rundstahl
					; --------------------------------------
					(if (= qsform_at "R") (progn
							(print "Rundstahl-Profil")
							(Lochbild.set knblLochbild 	(Klemml 	(+ alteKlemml dpDiff))
											;(dxsKopf	(+ altesDxSKopf (* 0.5 dpDiff)))
							)
							(setq satr-lhtr (Connect.get CastaData satr-lhtr))
							
							(if (= (Connect.get CastaData satr-lhtr)  1)
								(progn
									(Blech.set knotenBlech 		(delta_lr   (- delta_lr_alt (* 0.5 dpDiff))))
									(Lochbild.set knblLochbild 	(dxsKopf    (+ altesDxSKopf (* 1.0 dpDiff))))
									;(Traeger.set Tr_ID (delta_v (+ delta_v_at_alt (* 0.5 dpDiff))))
								)
							)
							(if (= (Connect.get CastaData satr-lhtr) -1)	
								(progn
									(Blech.set knotenBlech		(delta_lr   (+ delta_lr_alt (* 0.5 dpDiff))))
									; (Lochbild.set knblLochbild 	(dxsKopf    (- altesDxSKopf dpDiff)))
								)
							)
					))
					(if (= qsform_at "K") (progn
						(print "Rechteck - oder Quadratrohr")
						(setq dy (Blech.get augenBlech delta_y)) 
						(Blech.set augenBlech (delta_y (- dy (* 0.5 dpDiff))))

						(setq dy (Blech.get augenBlech_2 delta_y))
						(Blech.set augenBlech_2 (delta_y (+ dy (* 0.5 dpDiff))))

						(setq alteKlemml (Lochbild.get knblLochbild Klemml))
						(Lochbild.set knblLochbild 	(Klemml 	(+ alteKlemml dpDiff)))

						(setq dxs (Lochbild.get knblLochbild dxSKopf))
						(setq dxS (+ dxs (* 0.5 dpDiff)))
						(Lochbild.set knblLochbild 	(dxSKopf 	dxS))
					))
					; ------------------------------------					
	    ))
	))
)
; ----------------------------------------------------------------------------------------
; Callback fr die Augenlasche bei Rundprofilen
; ----------------------------------------------------------------------------------------
(defun cb_kopfpl (zp)
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get blKopfpl dp))
	))
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get blKopfpl dp))

		(if (/= dpAlt dpNeu) (progn
			(setq lSchl (Blech.get augenBlech lSchlitz))
			(setq lSchl (-  lSchl (- dpNeu dpAlt)))
			(Blech.set augenBlech (lSchlitz lSchl))
			(Blech.set augenBlech_2 (lSchlitz lSchl))
			
			; (setq hp_Ab (Blech.get augenBlech hp))
			; (Blech.set augenBlech   (hp (+ hp_Ab (* 0.5 (- dpNeu dpAlt)))))
			; (Blech.set augenBlech_2 (hp (+ hp_Ab (* 0.5 (- dpNeu dpAlt)))))
		))
		
	))
)

; ----------------------------------------------------------------------------------------
; Callback fr die Augenlasche bei Rundprofilen
; ----------------------------------------------------------------------------------------
(defun cb_augenBlech_1 (zp)

	(if (= zp 0) (progn
		(setq dpAlt (Blech.get augenBlech dp))
		(setq hpAlt (Blech.get augenBlech hp))
		(setq dy_Alt (Blech.get augenBlech delta_y))
	))
	(if (= zp 1) (progn
		(setq dpNeu (Blech.get augenBlech dp))
		(setq hpNeu (Blech.get augenBlech hp))
		(setq dy_Neu (Blech.get augenBlech delta_y))
		
		(if (/= dpAlt dpNeu) (progn
			(setq dpDiff (- dpNeu dpAlt))
			
			(setq Klemmlaenge 	(Lochbild.get knblLochbild Klemml)
				  dxs			(Lochbild.get knblLochbild dxsKopf)
			)
			(Lochbild.set knblLochbild (Klemml  (+ Klemmlaenge dpDiff)))
			(Lochbild.set knblLochbild (dxsKopf (+ dxs (* 0.5 dpDiff))))
			
			(Blech.set augenBlech_2 (dp dpNeu))
			(setq dy (Blech.get augenBlech delta_y))
			(Blech.set augenBlech (delta_y (- dy (* 0.25 dpDiff))))
			(setq dy (Blech.get augenBlech_2 delta_y))
			(Blech.set augenBlech_2 (delta_y (+ dy (* 0.25 dpDiff))))
			
		))
		(if (/= dy_Alt dy_Neu) (progn
			(setq dy_Diff (- dy_Neu dy_Alt))
			(setq dy_Diff (- dy_Diff))			; weil es in die andere Richtung geht
			(setq Klemmlaenge 	(Lochbild.get knblLochbild Klemml)
				  dxs			(Lochbild.get knblLochbild dxsKopf)
			)
			(Lochbild.set knblLochbild (Klemml  (+ Klemmlaenge dy_Diff)))
			(Lochbild.set knblLochbild (dxsKopf (+ dxs (* 0.5 dy_Diff))))

			(setq dy (Blech.get augenBlech_2 delta_y))
			(Blech.set augenBlech_2 (delta_y (+ dy (* 0.5 dy_Diff))))
		))
		(if (/= hpAlt dpNeu) (progn
			(setq hpDiff (- hpNeu hpAlt))
			(Blech.set augenBlech_2 (hp hpNeu))
			
			(if (= (Connect.get CastaData linkesEnde) 1) (progn
				(setq tEnde (Traeger.get Tr_ID links))
				(TrEnde.ptrim tEnde (* 0.5 hpDiff))
			))
			(if (= (Connect.get CastaData rechtesEnde) 1) (progn
				(setq tEnde (Traeger.get Tr_ID rechts))
				(TrEnde.ptrim tEnde (* 0.5 hpDiff))
			))
			
		))

	))

)
(defun cb_augenBlech_2 (zp)
	(if (= zp 0) (progn
		(setq dpAlt  (Blech.get augenBlech_2 dp))
		(setq hpAlt (Blech.get augenBlech_2 hp))
		(setq dy_Alt (Blech.get augenBlech_2 delta_y))
	))
	(if (= zp 1) (progn
		(setq dpNeu (Blech.get augenBlech_2 dp))
		(setq hpNeu (Blech.get augenBlech_2 hp))
		(setq dy_Neu (Blech.get augenBlech_2 delta_y))
		
		(if (/= dpAlt dpNeu) (progn
			(setq dpDiff (- dpNeu dpAlt))
			
			(setq Klemmlaenge 	(Lochbild.get knblLochbild Klemml)
				  dxs			(Lochbild.get knblLochbild dxsKopf)
			)
			(Lochbild.set knblLochbild (Klemml  (+ Klemmlaenge dpDiff)))
			(Lochbild.set knblLochbild (dxsKopf (+ dxs (* 0.5 dpDiff))))
			
			(Blech.set augenBlech (dp dpNeu))
			(setq dy (Blech.get augenBlech_2 delta_y))
			(Blech.set augenBlech_2 (delta_y (+ dy (* 0.25 dpDiff))))
			(setq dy (Blech.get augenBlech delta_y))
			(Blech.set augenBlech (delta_y (- dy (* 0.25 dpDiff))))
			
		))
		(if (/= dy_Alt dy_Neu) (progn
			(setq dy_Diff (- dy_Neu dy_Alt))
			; (setq dy_Diff (- dy_Diff))			; weil es in die andere Richtung geht
			(setq Klemmlaenge 	(Lochbild.get knblLochbild Klemml)
				  dxs			(Lochbild.get knblLochbild dxsKopf)
			)
			(Lochbild.set knblLochbild (Klemml  (+ Klemmlaenge dy_Diff)))
			(Lochbild.set knblLochbild (dxsKopf (+ dxs (* 0.5 dy_Diff))))

			(setq dy (Blech.get augenBlech delta_y))
			(Blech.set augenBlech (delta_y (- dy (* 0.5 dy_Diff))))
		))
		(if (/= hpAlt dpNeu) (progn
			(setq hpDiff (- hpNeu hpAlt))
			(Blech.set augenBlech (hp hpNeu))
		))
	))
)
(defun cb_augenBlech_alt (zp)
	(print "===========================================================================================================")
	(print "in Callback-Funktion cb_augenBlech")
	
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get augenBlech dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get augenBlech dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
					(setq dpDiff (- dpNeu dpAlt))
					(setq alteKlemml 		(Lochbild.get knblLochbild Klemml)
								altesDxSKopf	(Lochbild.get knblLochbild dxSKopf)
					)
					(print alteKlemml)
					(print altesDxSKopf)
					
					(setq delta_lr_Alt 	(Blech.get knotenBlech delta_lr))
					(print delta_lr_Alt)
					
					(setq qsform_at (Traeger.get Tr_ID qsform))
					
					(setq neueKlemml (+ alteKlemml dpDiff))
					(print neueKlemml)
					(setq neuesDxsKopf (+ altesDxSKopf (* 0.5 dpDiff)))
					(print neuesDxsKopf)
					
					(Lochbild.set knblLochbild 	(Klemml 	neueKlemml)
									(dxsKopf	neuesDxsKopf)
					)
						
					; neue Funktion					
			    		(calc_Rundr_delta_LR dpDiff)
	    ))
	))
	
	(print "===========================================================================================================")
)

(defun calc_Rundr_delta_LR (dpDiff)

    (if (= (Connect.get CastaData amHtFlansch)  1) (progn
        (if (= (Connect.get CastaData satr-lhtr)  1) (progn
		(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
	))
	(if (= (Connect.get CastaData satr-lhtr) -1) (progn
		(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
	))
    ))
    (if (= (Connect.get CastaData amHtSteg)  1) (progn
	(if (= (Connect.get CastaData amHtStegLinks)  1) (progn
            (if (= (Connect.get CastaData linkesEnde) 1) (progn
	            (if (= (Connect.get CastaData vatr-vhtr) -1) (progn
			(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
		    ))
		    (if (= (Connect.get CastaData vatr-vhtr)  1) (progn
			(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
		    ))
            ))
            (if (= (Connect.get CastaData rechtesEnde) 1) (progn
	            (if (= (Connect.get CastaData vatr-vhtr)  1) (progn
			(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
		    ))
		    (if (= (Connect.get CastaData vatr-vhtr) -1) (progn
			(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
		    ))
	    ))
	))
	(if (= (Connect.get CastaData amHtStegRechts)  1) (progn
            (if (= (Connect.get CastaData linkesEnde) 1) (progn
	            (if (= (Connect.get CastaData vatr-vhtr)  1) (progn
			(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
		    ))
		    (if (= (Connect.get CastaData vatr-vhtr) -1) (progn
			(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
		    ))
            ))
            (if (= (Connect.get CastaData rechtesEnde) 1) (progn
	            (if (= (Connect.get CastaData vatr-vhtr) -1) (progn
			(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
		    ))
		    (if (= (Connect.get CastaData vatr-vhtr)  1) (progn
			(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
		    ))
	    ))
	))

    ))
)



