; $	HT	QT(IU)	AF(K)		P(E)
; $	AT	QT(IU)	AF(K)		P(E)
; $	AE	V(-)		H(90)		R(-)


; ----------------------------------------------------------------------------------------
;	Einbindung externer Module
; ----------------------------------------------------------------------------------------
(defun load-modules ()
   (load "mod-endinit-vertikalStoss")
   (load "mod-utils")
   (load "mod-lochbild")
)

; ----------------------------------------------------------------------------------------
; Initialisierung des Anschlusses -> Einstiegspunkt
;
; Hier knnen vorab Prfungen vorgenommen werden
; ----------------------------------------------------------------------------------------
(defun init-connection ()

 (print "*clear*")

 (setq rWinkel (Connect.get CastaData r-atrgewnkl_kopf)
       delta_v_at (Traeger.get Tr_ID delta_v)
       delta_v_ht (Traeger.get HTrg  delta_v)
 )
 (setq berechnen 1)
 (if (>= rWinkel 360.0) (setq rWinkel (- rWinkel 360.0)))
 (if (/= delta_v_at 0) (progn
     (if (> rWinkel  10.0) (setq berechnen 0))
     (if (< rWinkel -10.0) (setq berechnen 0))
 ))
 (if (/= delta_v_ht 0) (progn
     (if (> rWinkel  10.0) (setq berechnen 0))
     (if (< rWinkel -10.0) (setq berechnen 0))
 ))
 
 ; (sucheKopfPlatte)   ;; Testen, was dies Funtkion bezweckt - Feb 2019

; (setq berechnen 1)

 (if (= berechnen 1) (progn


   (getCurrTrgVerlaengerung) ; speichert nur den Wert, wenn er negativ ist. Variable TrgEndeVerlaengerung

    ; auf vorhandenen Anschluss prfen
	; ----------------------------------------------
	(resetEnden)
	
	; wenn kein Anschluss vorhanden ist, dann anschliessen sonst nicht.
	(if (= (Connect.get CastaData anz_weitere_anschl) 0)
		(progn
			(print "Es ist kein Anschluss an diesem Knotenpunkt vorhanden.")
			(setConnection)
		)
		(progn
			(AlertBox "An diesem Knotenpunkt ist bereits ein Anschluss vorhanden.\nBitte beachten, dass die Trgerlngen sich ndern!"  "NOTE_LengthOfBeamsChanging")
			(setConnection)
		)
	)
   )
   (progn
   	(alertBox "
Wenn einer der beiden anzuschlieenden Trger um die Lngsachse gedreht ist,\n
und bei einem der beiden Trger gleichzeitig eine Vertikalverschiebung vorliegt,\n
kann kein Anschluss per Kopfplattensto von diesem Makro angebracht werden."  "ERR_LocalRot_and_Offset")
   ))

; (print "*clear*")
; (connect.ShowAttributes CastaData)

)

; ----------------------------------------------------------------------------------------
; Erzeugung des Anschlusses
; ----------------------------------------------------------------------------------------
(defun setConnection ()
	(print "ERZEUGE STOSS MIT BNDIGEN KOPFPLATTEN");

	; Lochbild Kontrolle
	(setq LB_DEBUG 0)
	
	; CastaData Attribute in Konsole ausgeben
  ; (connect.ShowAttributes CastaData)

	; Funktion aus externem Modul -> Hier werden die Trgerenden aneinander angepasst
  (init-traegerenden)				

		
	; Erzeugen der Anbauteile
  (setq kplLochbild (Lochbild.create))
  (setq kplHtrg     (Blech.create))
  (setq kplTrg      (Blech.create))
    
  ; Anbauteile in Connect-Objekt speichern
  (Connect.storeAnschlObjs CastaData kplLochbild kplHtrg kplTrg)
    
  ; Dicke der Kopfplatten berechnen
  (setDpKopfplatten kplHtrg kplTrg)
    
  (setq dp (Blech.get kplHtrg dp))
  (setq dp (* 1.0 dp))  
  ; relative Abstnde der Flanschkanten untereinander berechnen
  ;(berechneTraegerUnterschiede)
  (berechneTraegerKanten_2 kplHtrg kplTrg)
    
  ; berstand der Kopfplatten
  (setq ueberstand 5.0)
    
  ; Berechnung des Lochbildes
  (calcAndSetLochbildDaten_1 kplLochbild kplHtrg kplTrg)
       
  ; Berechnung der Kopfplatten
  (if (= (connect.get CastaData linkesEnde) 1)
     (createBuendigeKpl Tr_ID kplTrg kplLochbild dp ueberstand 1)
  )
  (if (= (connect.get CastaData rechtesEnde) 1)
     (createBuendigeKpl Tr_ID kplTrg kplLochbild dp ueberstand -1)
  )

  (if (= (connect.get CastaData anHtLinkesEnde) 1) 
     (createBuendigeKpl HTrg kplHTrg kplLochbild dp ueberstand  1)
  )
  (if (= (connect.get CastaData anHtRechtesEnde) 1) 
     (createBuendigeKpl HTrg kplHTrg kplLochbild dp ueberstand -1)
  )

  ; beide Kopfplatten aneinander anpassen
  (kopfplCorrection ueberstand)
    
  ; beide Lochbildanbauteile aneinander anpassen
	(anbauteilKorrektur Abtl_KplLchb_at kplTrg antw)

;  Rotation einbauen
  (setq rWinkel (Connect.get CastaData r-atrgewnkl_kopf))
  (if (>= rWinkel 360.0) (setq rWinkel (- rWinkel 360.0)))
  (print rWinkel)
  (if (> rWinkel  90.0) 
     (berechneRotation)
     (if (< rWinkel -90.0)
          (berechneRotation)
          (seitliche_Verschiebung)
     )
  )
 
   ;; Nov-2008 - AF - hier jetzt untergebracht, weil in der Funktion kein Anbauteil
   ;; im HTrg eingebaut war und Stahl-3D dann auf einen Fehler auflief.
    (setq Abtl_KplLchb (traeger.get Htrg ABTeil kplLochbild))
    (if (objexist Abtl_KplLchb) (Anbauteil.set Abtl_KplLchb 		(Master 1)))

    (setq Abtl_KplLchb_at (traeger.get Tr_ID ABTeil kplLochbild))
    (if (objexist Abtl_KplLchb_at) (Anbauteil.set Abtl_KplLchb_at 	(Master 0)))

	
    (if (> TrgEndeVerlaengerung 0.0) (setLaengsVerschiebung))

	
 
  (if (= 1 2) (progn
	(setq dv_Vorh_AT (Anbauteil.get Abtl_KplLchb_at delta_V))
	(AlertBox dv_Vorh_AT)
  ))
    
  (if (= 1 2) (progn
      (Lochbild.set kplLochbild (e "0 50 150 0 0 0"))
      (Lochbild.set kplLochbild (w "10 100"))
      (Lochbild.set kplLochbild (LB_Art 2))
      (Anbauteil.set Abtl_KplLchb 		(Master 0))
      (Anbauteil.set Abtl_KplLchb_at 		(Master 1))
      (setq dlr_AT (Anbauteil.get Abtl_KplLchb_at delta_lr))
      (setq dlr_HT (Anbauteil.get Abtl_KplLchb    delta_lr))
      (print dlr_HT)
      (print dlr_AT)
;      (Anbauteil.set Abtl_KplLchb_at (delta_lr 0))
      (setq seitricht_AT (Anbauteil.get Abtl_KplLchb_at SeitRicht))
      (setq seitricht_HT (Anbauteil.get Abtl_KplLchb    SeitRicht))
      (print seitricht_HT)
      (print seitricht_AT)
;      (Anbauteil.set Abtl_KplLchb_at (SeitRicht 0))
  ))
    
    
;    (TesteUnterflanschLochbild)
    
  ; CALLBACKS
  (Blech.set kplHtrg 	(formFkt "cb_kplHtrg"))
  (Blech.set kplTrg 	(formFkt "cb_kplTrg"))

)

; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am HT
; ----------------------------------------------------------------------------------------
(defun cb_kplHtrg (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get kplHtrg dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get kplHtrg dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get kplLochbild Klemml))
	       
	       (Lochbild.set kplLochbild 	(Klemml (+ alteKlemml dpDiff)))
	    ))
		(setq CopyMode (Connect.get CastaData CopyMode))
    	(cbHelp_BlechLchbAnpassen kplHtrg kplTrg Tr_ID)
	    
	))
)
(defun cbHelp_BlechLchbAnpassen (bl_Source bl_Target trg_Target)

    ; zentrale Option - einstellbar machen in Zukunft
    (setq FirstPunktSymmetrie	0)  ; Wenn man es auf 1 setzt, wird die andere Kpl angepasst
    (loadConfig "makro_defaults.lsp")		; zentrale Config-Datei mit Defaults
    
    (if (> FirstPunktSymmetrie 0) (progn

	    (setq	hp_Source  (Blech.get bl_Source hp)
	    		bp_Source  (Blech.get bl_Source bp)
	    		dOK_Source (Blech.get bl_Source dOK)
	    		dp_Source  (Blech.get bl_Source dp)
	    )
	    (setq dp_Target (Blech.get bl_Target dp))
	    
	    (if (/= dp_Source dp_Target) (progn
	       (setq dpDiff (- dp_Source dp_Target))
	       (setq alteKlemml (Lochbild.get kplLochbild Klemml))
	       (Lochbild.set kplLochbild 	(Klemml (+ alteKlemml dpDiff)))
	    ))
	    
	    (Blech.set bl_Target (hp hp_Source) (bp bp_Source) (dp dp_Source) (dOK dOK_Source))
	    
	    (setq pBez (Traeger.get  trg_Target Profil))
	    (if (= trg_Target Tr_ID) (progn
	    	(print "wszTrg - Ende anpassen")
	    	(if (= (Connect.get CastaData linkesEnde)  1) (setq trgEnde (Traeger.get Tr_ID links)))
	    	(if (= (Connect.get CastaData rechtesEnde) 1) (setq trgEnde (Traeger.get Tr_ID rechts)))
	    ))
	    (if (= trg_Target HTrg) (progn
	    	(print "HTrg - Ende anpassen")
	    	(if (= (Connect.get CastaData anHTlinkesEnde)  1) (setq trgEnde (Traeger.get HTrg links)))
	    	(if (= (Connect.get CastaData anHTrechtesEnde) 1) (setq trgEnde (Traeger.get HTrg rechts)))
	    ))
	    (TrEnde.ptrim trgEnde (- dp_Source dp_Target))
    ))
)



; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am AT
; ----------------------------------------------------------------------------------------
(defun cb_kplTrg (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get kplTrg dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get kplTrg dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get kplLochbild Klemml))
	       
	       (Lochbild.set kplLochbild 	(Klemml (+ alteKlemml dpDiff))
	       														;(DxSKopf (+ altesDxS dpDiff))
	       )
	    ))

    	    (cbHelp_BlechLchbAnpassen kpltrg kplHTrg HTrg)

	))
)

; ----------------------------------------------------------------------------------------
; HILFSFUNKTIONEN
; ----------------------------------------------------------------------------------------

; ----------------------------------------------------------------------------------------
; Die Position des Lochbildanbauteils des AT wird dem Lochbild des HT angepasst
; ----------------------------------------------------------------------------------------
(defun anbauteilKorrektur (ABTL BLECHID antw_ht)
	
	(print "Berechne OK-Versatz des Lochbilds am AT")
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID links))
		(setq AtEnde (Traeger.get Tr_ID rechts))
	)
;	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
;		(setq AtEnde (Traeger.get HTrg links))
;		(setq AtEnde (Traeger.get HTrg rechts))
;	)


	(setq dp_blech (Blech.get BLECHID dp))
	
	(setq vwnkl_at (TrEnde.get AtEnde v_winkel))
	
	(if (>= vwnkl_at 90.0)
		(setq wnkl_at (- vwnkl_at 90.0))
		(setq wnkl_at (- 90.0 vwnkl_at))
	)
	(print wnkl_at)
	
	(setq tanW_at (tan (/ (* PI wnkl_at) 180.0)))
	(print tanW_at)
	
	(setq antW_At (* dp_blech tanW_at))
	(print antW_At)
	(print diff_oben)
	(print oKante_at)
	(print oKante_ht)
	(if (> oKante_at oKante_ht)
		(setq delta_v_abtl (- (+ (- diff_oben) antW_At) antw_ht) )
		(setq delta_v_abtl (- (+ diff_oben antW_At) antw_ht))
	)
	(print delta_v_abtl)
		
	(Anbauteil.set ABTL (delta_v  delta_v_abtl))
	
	(if (= LB_DEBUG 1)
		(progn
			(Anbauteil.set AT_ABTeil_dummy 	(delta_v  delta_v_abtl))
		)
	)


	
  (if (= (connect.get CastaData linkesEnde) 1) (progn
      (if (= (connect.get CastaData anHtLinkesEnde) 1) (progn
          (Anbauteil.set ABTL (SeitRicht -1))
      ))
  ))
  (if (= (connect.get CastaData rechtesEnde) 1) (progn
      (if (= (connect.get CastaData anHtRechtesEnde) 1)  (progn
          (Anbauteil.set ABTL (SeitRicht -1))
      ))
  ))


)

; ----------------------------------------------------------------------------------------
; erzeugt die Kopfplatten
; ---------------------------------------------------------------------------------------- 
(defun createBuendigeKpl (Trg blKopfpl lchbKpl dp ueb li_re)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE KOPFPLATTEN")
	(print ueb)
	
    (if (= li_re  1) (setq TrgEnde (Traeger.get Trg links)))
    (if (= li_re -1) (setq TrgEnde (Traeger.get Trg rechts)))
    
    ;(setq ueb 5)	;; nur zum Testen - Kopfplattenposition zum Traeger
    
    (setq EWnkl  (TrEnde.get TrgEnde V_Winkel)
          alfa   (- EWnkl 90.0)
          hProf  (Traeger.get Trg h)
          cosW   (cos (* PI (/ alfa 180.0)))
          hNetto hProf
    )
    
    (setq b_ht (Traeger.get Htrg b))
    
    (setq b_at (Traeger.get Tr_ID b))
    
    (setq vscherl (TrEnde.get TrgEnde vscherl))
    (setq hNetto vscherl)
    ;(if (/= cosW 0) (setq hNetto (/ hProf cosW)))

    (setq  hp     (+ hNetto ueb ueb))

		; Durchmesser ds der Schrauben
    (setq w0_lb (Lochbild.get lchbKpl w0))
    (print w0_lb)
    
    (setq breite_kpl (+ (* 2.0 e_min) w0_lb))
    (print breite_kpl)
		
    (if (< b_at b_ht)
    	(setq b_mass b_ht)
    	(setq b_mass b_at)
    )
    (print b_mass)
		
    (if (> b_mass breite_kpl)
    	(setq bp_kpl b_mass)
    	(setq bp_kpl breite_kpl)
    )
    
		(print dp)
		(print bp_kpl)
		(print hp)
		
    (Blech.set blKopfpl	(dp    dp)
         		(bp    bp_kpl)
         		(hp    hp)
         		(dOK   (- ueb))
         		;(dOK   (- 40))
    )

    
    (if (= li_re  1) (traeger.addabtl Trg blKopfpl 0.0 0.0 _kopfplattelinks_))
    (if (= li_re -1) (traeger.addabtl Trg blKopfpl 0.0 0.0 _kopfplatterechts_))

    (if (= li_re  1) (traeger.addabtl Trg lchbKpl 0.0 0.0 _kpllochbildlinks_))
    (if (= li_re -1) (traeger.addabtl Trg lchbKpl 0.0 0.0 _kpllochbildrechts_))
    
    (setq Abtl_KplLchb_at (traeger.get Tr_ID ABTeil lchbKpl))

    ;; seitliche Verschiebung des Lochbilds eingebaut AF
    (setq	delta_lr_at	(Traeger.get Tr_ID delta_lr)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
    )
    ; Anschlusstrger seitliche Lochildverschiebung
    (print delta_lr_ht)
    (print delta_lr_at)
;    (Anbauteil.set Abtl_KplLchb_at (delta_LR (* 1.0 (- delta_lr_at delta_lr_ht))))
   
	 
		; **************************************************************************************
		; Lochbild Test
		; **************************************************************************************
		(if (= LB_DEBUG 1) (progn
			(print "LB_DEBUG in createBuendigeKpl")
			(setq dummy (Lochbild.create))
			(Lochbild.copy dummy lchbKpl)
			
			(if (= (Connect.get CastaData linkesEnde) 1)
				(Traeger.addAbtl Tr_ID dummy 0.0 0.0 _kpllochbildlinks_)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(Traeger.addAbtl Tr_ID dummy 0.0 0.0 _kpllochbildrechts_)
			)
		
		
			(setq AT_ABTeil_dummy (Traeger.get Tr_ID AbTeil dummy))
			(Anbauteil.set AT_ABTeil_dummy 	(Master    1)
			)
		
			(Connect.storeAnschlObjs CastaData dummy)
		))
		; **************************************************************************************
	 
   	(print dp)
    ;(TrEnde.set TrgEnde (delta_l 0)) 
    (TrEnde.pTrim TrgEnde dp)
	(print "<-----------------------------------------------------------")
)

; ----------------------------------------------------------------------------------------
; Berechnet die Lochbilddaten
; ---------------------------------------------------------------------------------------- 
(defun calcAndSetLochbildDaten_1 (Lchb_ID BlechHT BlechAT)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID 
		(S_Bez   "M20")
		(Guete   "4.6")
		(e       "-1 1 0 0 0 0")
		(w       "80  0")
	)
	
	(setq	delta_v_at 	(Traeger.get Tr_ID delta_v)
		r_winkel_at	(Traeger.get Tr_ID r_winkel)
		h_at		(Traeger.get Tr_ID h)
		b_at		(Traeger.get Tr_ID b)
	)
	
	(setq	delta_v_ht 	(Traeger.get Htrg delta_v)
		r_winkel_ht	(Traeger.get Htrg r_winkel)
		h_ht		(Traeger.get Htrg h)
		b_ht		(Traeger.get Htrg b)
	)
	
	(setq dp_blechHT (Blech.get BlechHT dp))
	(setq dp_blechAT (Blech.get BlechAT dp))
	
	; Schraubengre ermitteln
	(if (> dp_blechHT dp_blechAT)
		(setq min_blech dp_blechAT)
		(setq min_blech dp_blechHT)
	)
	(calcSchraube min_blech) ; -> S_Bez
	
	; Schraubengre setzen
	(Lochbild.set Lchb_ID (S_Bez S_Bez))
	 
	; min. Rand- /Lochabstnde 
	(calcMinRandLochAbst Lchb_ID) ; -> e_min, e1_min, e_min_rund, e1_min_rund, h_min
	
	; magebenden Trger ermitteln (hier der kleinere)
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq TrgEnde_AT (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq TrgEnde_AT (Traeger.get Tr_ID rechts)))
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)	(setq TrgEnde_HT (Traeger.get Htrg links)))
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)	(setq TrgEnde_HT (Traeger.get Htrg rechts)))
	
	(setq vscherl_at (TrEnde.get TrgEnde_AT vscherl))
	(setq vscherl_ht (TrEnde.get TrgEnde_HT vscherl))
	
	(setq vscherl_at_halb (* 0.5 vscherl_at))
	(setq vscherl_ht_halb (* 0.5 vscherl_ht))
	
	(setq vwnkl_ht				(TrEnde.get TrgEnde_HT v_winkel))
	(print vwnkl_ht)
	(if (> vwnkl_ht 90.0)
		(setq wnkl_ht (- vwnkl_ht 90.0))
		(setq wnkl_ht (- 90.0 vwnkl_ht))
	)
	(print wnkl_ht)
	
	(setq tanW_ht (tan (/ (* PI wnkl_ht) 180.0)))
	(print tanW_ht)
	
	; Anteil Neigung 
	(setq antW (* dp_blechHT tanW_ht))
	(print antW)
	
	
	(if (< vscherl_at vscherl_ht)
		(progn
			(setq massTrg Tr_ID)
			(setq h_prof_mass vscherl_at)
			(setq h_prof vscherl_ht)
		)
		(progn
			(setq massTrg Htrg)
			(setq h_prof_mass vscherl_ht)
			(setq h_prof vscherl_at)
		)
	)
					
	(calc_Anz_Schr Lchb_ID massTrg)
	
	
	;(setq ueb 5)	;; nur zum Testen - Kopfplattenposition zum Traeger
	
	(if (= ANZ_SCHR 4)
		(setq massAbstand (* 0.25 minDiff))
		(setq massAbstand (* 0.5 minDiff))
	)
	
	;(setq viertel (* 0.25 h_prof_mass))
	;(print viertel)
	(setq viertel massAbstand)
	(print viertel)
	
	
	
	
	; e0 hngt vom kleineren Trger ab. Daher Unterscheidung.
	
	;(if (= (Connect.get CastaData satr-shtr)  1)
	;	(progn
	;		(if (= (Connect.get CastaData vatr-vhtr)  1)
	;			(progn
	;				(if (> oKante_ht oKante_at)
	;					(setq e0 (+ viertel antW))
	;					(setq e0 (+ viertel diff_oben antW))
	;				)
	;			)
	;		)
	;		(if (= (Connect.get CastaData vatr-vhtr) -1)
	;			(progn
	;				(if (> oKante_ht oKante_at)
	;					(setq e0 (+ viertel antW))
	;					(setq e0 (+ viertel diff_unten antW))
	;				)
	;		)
	;		)
	;	)
	;)
	;(if (= (Connect.get CastaData satr-shtr) -1)
	;	(progn
	;		(if (= (Connect.get CastaData vatr-vhtr)  1)
	;			(progn
	;				(if (> oKante_ht oKante_at)
	;					(setq e0 (+ viertel antW))
	;					(setq e0 (+ viertel diff_oben antW))
	;				)
	;			)
	;		)
	;		(if (= (Connect.get CastaData vatr-vhtr) -1)
	;			(progn
	;				(if (> oKante_ht oKante_at)
	;					(setq e0 (+ viertel antW))
	;					(setq e0 (+ viertel diff_oben antW))
	;				)
	;			)
	;		)
	;	)
	;)
	
	(if (> oKante_ht oKante_at)
		(setq e0 (+ viertel antW))
		(setq e0 (+ viertel diff_oben antW))
	)
	
	;(setq e0rund (runde e0 auf 5))
	(print e0)
	
	; e1
	(if (= ANZ_SCHR 4)
		(progn
			(setq e1 (* 2 viertel))
			(print e1)
		)
		(progn
			(setq e1 0)
			(print e1)
		)
	)
	
	; w0
	(setq s_ht (Traeger.get Htrg s))
	(setq s_at (Traeger.get Tr_ID s))
	
	(if (> s_ht s_at)
		(setq s_mass s_ht)
		(setq s_mass s_at)
	)
	(setq min_w0 (+ s_mass (* 2.0 e_min)))
	(print min_w0)
	
	(if (> b_ht b_at)
		(setq b_mass b_ht)
		(setq b_mass b_at)
	)
	(setq w0_default (* 0.5 (- b_mass s_mass)))
	(print w0_default)
	
	(if (< w0_default min_w0)
		(setq w0 min_w0)
		(setq w0 w0_default)
	)
	(print w0)
	
	(Lochbild.set Lchb_ID	(e0 		e0) 
				(e1 		e1) 
				(w0 		w0)
				(klemml (+ dp_blechHT dp_blechAT))
	)
	
	(if (= LB_DEBUG 1)
		(progn
			(if (= e1 0.0)
				(Lochbild.set Lchb_ID (e1 300))
				(Lochbild.set Lchb_ID (e2 300))
			)
		)
	)
	
	(print "<-----------------------------------------------------------")
)

; ----------------------------------------------------------------------------------------
; Passt die Kopfplatten einander an
; ---------------------------------------------------------------------------------------- 
(defun kopfplCorrection (ueberstand)
	(print ">-----------------------------------------------------------")
	(print "KORREGIERE KOPFPLATTEN")
	; hier wird die Gre des kleineren Blechs an das grere Blech angepasst 
	
	; Korrektur der Kopfplattenhhe, so dass zu beiden Flanschseiten der Traeger
	; mindestens der gewollte berstand entsteht.
	(setq hp_blech_korregiert (+ maxDiff ueberstand ueberstand))
	(print hp_blech_korregiert)
	;(setq hp_blech_korregiert (runde hp_blech_korregiert auf 5))
	;(print hp_blech_korregiert)
	
	; Blechhhen 
	(Blech.set kplHtrg 	(hp hp_blech_korregiert))
	(Blech.set kplTrg 	(hp hp_blech_korregiert))
	
	(print oKante_ht)
	(print oKante_at)
	
	; Magebenden Trger ermitteln, bei dem dok angesetzt wird.
	(if (<= oKante_ht oKante_at) ; wenn die Oberkante des AT niedriger liegt als die des HT
		(progn
			(print "AT mu verschoben werden.")
			(setq dok_blech (Blech.get kplTrg dok))
			(print dok_blech)
			(print rwinkel_at)
			(print rwinkel_ht_rot)
			
			(if (= rwinkel_at rwinkel_ht_rot)
				(progn
					(setq dok_neu (- dok_blech diff_unten))
				)
				(progn
					(setq dok_neu (- dok_blech diff_oben))
				)
			)	
			(print dok_neu)
			(Blech.set kplTrg (dok dok_neu))
		)
		(progn
			(print "HT mu verschoben werden.")
			(setq dok_blech (Blech.get kplHtrg dok))
			(print dok_blech)
			(Blech.set kplHtrg (dok (- dok_blech diff_oben)))
		)
	)
	    	
  (print "<-----------------------------------------------------------")
)


; ----------------------------------------------------------------------------------------
; Berechnet folgende Werte bei unterschiedlichen Trgern
;
; Die Werte beziehen sich auf die Achse der Kontaktflche, also entlang der Schnittflche
;
;	diff_oben:		Abstand der oberen Flanschkanten zueinander
;	diff_unten:		Abstand der unteren Flanschkanten zueinander
;	maxDiff:			Maximale Ausdehnung von obersten zur untersten Flanschkante
; max_oKante:		Maximalwert fr den obersten Flansch
; max_uKante:		Maximalwert fr den untersten Flansch
;	oKante_ht
; oKante_at
; uKante_ht
; uKante_at
;
; ----------------------------------------------------------------------------------------
(defun berechneTraegerUnterschiede ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE TRGERUNTERSCHIEDE")
	
	(setq h_kpl_ht 	(Blech.get kplHtrg hp)
				dp_kpl_ht	(Blech.get kplHtrg dp)
	)
	(setq h_kpl_at 	(Blech.get kplTrg hp)
				dp_kpl_at	(Blech.get kplTrg dp)
	)
	
	(setq h_ht 				(Traeger.get Htrg h)
				delta_v_ht	(Traeger.get Htrg delta_v)
				rwinkel_ht	(Traeger.get Htrg r_winkel)
	)
	
	(setq h_at				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
				rwinkel_at	(Traeger.get Tr_ID r_winkel)
	)
	
	(setq rwinkel_ht_rot (+ rwinkel_ht 180.0))
	
	(if (= rwinkel_at rwinkel_ht_rot)
		(setq delta_v_at (- delta_v_at))
	)
	
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq TrgEnde_AT (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq TrgEnde_AT (Traeger.get Tr_ID rechts)))
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)	(setq TrgEnde_HT (Traeger.get Htrg links)))
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)	(setq TrgEnde_HT (Traeger.get Htrg rechts)))
	
	(setq vscherl_at 	(TrEnde.get TrgEnde_AT vscherl)		
				vwinkel_at	(TrEnde.get TrgEnde_AT v_winkel)
	)
	(setq vscherl_ht 	(TrEnde.get TrgEnde_HT vscherl)
				vwinkel_ht	(TrEnde.get TrgEnde_HT v_winkel)
	)
	
	(print vscherl_at)
	(print vscherl_ht)
	
	(print vwinkel_at)
	(print vwinkel_ht)
	
	(setq winkel_ht (- 90.0 vwinkel_ht))
	(setq winkel_at (- vwinkel_at 90.0))
	
	(print winkel_at)
	(print winkel_ht)
	
	(if (< winkel_ht 0.0)
		(setq winkel_ht (- winkel_ht))
	)
	(if (< winkel_at 0.0)
		(setq winkel_at (- winkel_at))
	)
	(print winkel_at)
	(print winkel_ht)
	
	(setq tanVW_at	(tan (/ (* PI winkel_at) 180.0)))
	(setq tanVW_ht	(tan (/ (* PI winkel_ht) 180.0)))
	(setq cosVW_at	(cos (/ (* PI winkel_at) 180.0)))
	(setq cosVW_ht	(cos (/ (* PI winkel_ht) 180.0)))
	(print tanVW_ht)
	(print tanVW_at)
	(print cosVW_ht)
	(print cosVW_at)
	
	(print dp_kpl_ht)
	(print dp_kpl_at)
	
	; Anteil der Kopfplattendicke
	(setq anteil_kpl_ht (* dp_kpl_ht tanVW_ht))
	(setq anteil_kpl_at (* dp_kpl_at tanVW_at))
	
	(print anteil_kpl_ht)
	(print anteil_kpl_at)
		
	(if (< vscherl_at vscherl_ht)
		(progn
			(setq h_prof_mass vscherl_ht)			
			(setq h_prof vscherl_at)
			(setq isHtrg 1)
			(Blech.set kplTrg (hp h_kpl_ht))
		)
		(progn
			(setq h_prof_mass vscherl_at)
			(setq h_prof vscherl_ht)
			(setq isHtrg 0)
			(Blech.set kplHtrg (hp h_kpl_at))
		)
	)
	
	
	(setq vscherl_at_halb (* 0.5 vscherl_at))
	(setq vscherl_ht_halb (* 0.5 vscherl_ht))
	
	(setq delta_v_ht_scher (/ delta_v_ht cosVW_ht))
	(setq delta_v_at_scher (/ delta_v_at cosVW_at))
	
	(print delta_v_ht_scher)
	(print delta_v_at_scher)
	
	; Oberkante der Trger
	(setq oKante_ht (- delta_v_ht_scher vscherl_ht_halb))				(print oKante_ht)
	(setq uKante_ht (+ oKante_ht vscherl_ht))										(print uKante_ht)
	(setq oKante_at	(- delta_v_at_scher vscherl_at_halb))				(print oKante_at)
	(setq uKante_at (+ oKante_at vscherl_at))										(print uKante_at)
		
	(print "-----------------------------------")
	
	; Anteil der Kopfplatte hinzurechnen
	(setq oKante_ht (+ oKante_ht anteil_kpl_ht))								(print oKante_ht)
	(setq uKante_ht (+ uKante_ht anteil_kpl_ht))								(print uKante_ht)
	(setq oKante_at	(+ oKante_at anteil_kpl_at))								(print oKante_at)
	(setq uKante_at (+ uKante_at anteil_kpl_at))								(print uKante_at)
	
	; Differenz oben
	(if (< oKante_ht oKante_at)
		(setq diff_oben (- oKante_at oKante_ht))
		(setq diff_oben (- oKante_ht oKante_at))
	)
	(print diff_oben)
	
  ; Differenz unten
	(if (< uKante_ht uKante_at)
		(setq diff_unten (- uKante_at uKante_ht))
		(setq diff_unten (- uKante_ht uKante_at))
	)
	(print diff_unten)
	
	; Maximal- / Minimalwerte ermitteln (okante / ukante)
	(if (<= oKante_ht oKante_at)
		(progn
			(setq max_oKante oKante_ht)
			(setq min_oKante oKante_at)
		)
		(progn
			(setq max_oKante oKante_at)
			(setq min_oKante oKante_ht)
		)
	)
	(if (>= uKante_ht uKante_at)
		(progn
			(setq max_uKante uKante_ht)
			(setq min_uKante uKante_at)
		)
		(progn
			(setq max_uKante uKante_at)
			(setq min_uKante uKante_ht)
		)
	)
	(print max_oKante)
	(print max_uKante)
	(print min_oKante)
	(print min_uKante)
		
	(setq maxDiff (- max_oKante max_uKante))
	(setq minDiff (- min_oKante min_uKante))
	(print maxDiff)
	(print minDiff)
	
	(if (< maxDiff 0.0)
		(setq maxDiff (- maxDiff))
	)
	(if (< minDiff 0.0)
		(setq minDiff (- minDiff))
	)
	(print maxDiff)
	(print minDiff)
	(print "<-----------------------------------------------------------")
)

; ----------------------------------------------------------------------------------------
; SETZT DIE DICKE DER KOPFPLATTEN
; ----------------------------------------------------------------------------------------
(defun setDpKopfplatten (kpl_ht kpl_at)
	(print "SETZTE DIE DICKE DER KOPFPLATTEN")
	
	; Ermittlung der Flanschdicken
	(setq t_at (Traeger.get Tr_ID t))
	(setq t_ht (Traeger.get Htrg t))
	
	; Aufrunden
	(setq t_at_rund (runde t_at auf 5))
	(setq t_ht_rund (runde t_ht auf 5))
	
	(if (>= t_ht t_at)
		(setq dp_kpl t_ht_rund)
		(setq dp_kpl t_at_rund)
	)
	
	(print dp_kpl)
	
	(Blech.set kpl_ht (dp dp_kpl))
	(Blech.set kpl_at (dp dp_kpl))
		 
)

(defun testen ()
	(print "Test-Funktion")
	
	
)
; -----------------------------------------------------------------------
(defun berechneRotation ()

    (print  "Berechne Rotation")
 
    ; neue Lsung - AF - 2009
    (setq Abtl_KplLchb_ht (traeger.get Htrg ABTeil kplLochbild))
    (setq dv_AF (Anbauteil.get   Abtl_KplLchb_ht delta_v))
    (Anbauteil.set Abtl_KplLchb_ht (switch_on _unterflansch_))

;    (setq dv uKante_at)

; ...................... AF
    (Anbauteil.set Abtl_KplLchb_ht (delta_v (- dv_AF)))


 	(print "Kantendaten ..........................")
	(print oKante_ht)
	(print uKante_ht)
	(print oKante_at)
	(print uKante_at)
)

(defun seitliche_Verschiebung ()

; -------------- Lsung DM - 
(if (= 1 1) (progn 
 (setq rWinkel (Connect.get CastaData r-atrgewnkl_kopf))
 (print rWinkel)
 
 (setq abtl_KplLchb_AT (Traeger.get Tr_ID ABTeil kplLochbild))
 (Anbauteil.Set abtl_KplLchb_AT (kplrwnkl (- rWinkel)))
 (print abtl_KplLchb_AT)
 
; (Lochbild.set kplLochbild (e0 0) (e1 100) (e2 20) (w0 30))
 
 (setq h_AT 	  (Traeger.get Tr_ID  h)
       dv_AT      (Traeger.get Tr_ID  delta_V)
       dlr_AT     (Traeger.get Tr_ID  delta_LR)
       h_HT 	  (Traeger.get HTrg   h)
       dv_HT      (Traeger.get HTrg   delta_V)
       dlr_HT     (Traeger.get HTrg   delta_LR)
       h_AT_Halbe (* 0.5 h_AT)
       cosWnkl    (cos (/ (* rWinkel PI) 180.0))
       sinWnkl    (sin (/ (* rWinkel PI) 180.0))
 )
 (if (= (Connect.get CastaData linkesEnde) 1) (progn
	(setq tEnde (Traeger.get Tr_ID links))
	(setq h_AT  (TrEnde.get tEnde vscherl))
	(setq e_VWnkl_AT (TrEnde.get tEnde V_Winkel))
 ))
 (if (= (Connect.get CastaData rechtesEnde) 1) (progn
	(setq tEnde (Traeger.get Tr_ID rechts))
	(setq h_AT (TrEnde.get tEnde vscherl))
	(setq e_VWnkl_AT (TrEnde.get tEnde V_Winkel))
 ))
 (print sinWnkl)
 (print cosWnkl)

 (setq 	dl_LR  (*  (- h_AT_Halbe dv_AT) sinWnkl)
		dl_DV  (-  (- h_AT_Halbe dv_AT) 	(*  (- h_AT_Halbe dv_AT) cosWnkl))
 )
 
 (setq  vorh_Dlr (Anbauteil.Get abtl_KplLchb_AT delta_lr)
 	vorh_DV  (Anbauteil.Get abtl_KplLchb_AT delta_V)
 )
 (print vorh_Dlr)
 (setq vorh_Dlr (+ vorh_Dlr (* 1.0 dlr_HT)))

 
 
 
 (setq vorh_DV (- (* 0.5 h_AT) (* 0.5 h_HT) dv_AT (- dv_HT)))

 (print vorh_Dlr)
 (print vorh_DV)
 
 (setq dlr_Diff (- (+ dlr_HT dlr_AT)))
  (if (= (Connect.get CastaData rechtesEnde) 1) 
    (if (= (Connect.get CastaData anHtLinkesEnde) 1) 
      (setq 
			dlr_Diff        (- (- dlr_HT dlr_AT))
       )
    )
  )
  (if (= (Connect.get CastaData linkesEnde) 1) 
    (if (= (Connect.get CastaData anHtRechtesEnde) 1) 
      (setq 
			dlr_Diff        (- (- dlr_HT dlr_AT))
       )
    )
  )
    (print "----------------------------------------------------------------------- nderung")	

    (print dlr_HT)
    (print dlr_AT)
    (print dlr_Diff)

    (setq dlr_HT_Anteil_H (* dlr_Diff sinWnkl))
    (setq dlr_HT_Anteil_V (* dlr_Diff cosWnkl))
    
    (print dlr_HT_Anteil_H)
    (print dlr_HT_Anteil_V)

; nderung April 2010
; in der alten Version wurde der Anteil des AT nicht bercksichtigt.
; (setq dlr_HT_Anteil_H (* dlr_HT sinWnkl))
; (setq dlr_HT_Anteil_V (* dlr_HT cosWnkl))

  (setq	dlr_AT     (Traeger.get Tr_ID  delta_LR)
		dlr_HT     (Traeger.get HTrg   delta_LR)
  )


  ; Vorgabe - gehen in unterschiedliche Richtungen
  (setq   vorh_Dlr  (+ dlr_HT dlr_AT))
  (setq   vorh_Dlr2  (+ dlr_HT dlr_AT))

  (if (= (Connect.get CastaData rechtesEnde) 1) 
    (if (= (Connect.get CastaData anHtLinkesEnde) 1) 
      (setq 
  	  dlr_HT_Anteil_H (- dlr_HT_Anteil_H)
  	  dlr_HT_Anteil_V (- dlr_HT_Anteil_V)
  	  vorh_Dlr        (- (- dlr_HT dlr_AT))
       )
    )
  )
  (if (= (Connect.get CastaData linkesEnde) 1) 
    (if (= (Connect.get CastaData anHtRechtesEnde) 1) 
      (setq 
  	  dlr_HT_Anteil_H (- dlr_HT_Anteil_H)
  	  dlr_HT_Anteil_V (- dlr_HT_Anteil_V)
  	  vorh_Dlr2       (- (- dlr_HT dlr_AT))
       )
    )
  )
    (print sinWnkl)
    (print vorh_DV)
    (print dl_LR)
    (print vorh_Dlr)
    (print dlr_HT_Anteil_V)
    (print vorh_Dlr2)


    (print "----------------------------------------------------------------------- Ende nderung")	
;  (setq dlr_HT_Anteil_H 100)

   (setq  vorh_DV (- vorh_DV))
	
  (Anbauteil.Set abtl_KplLchb_AT 
 		(delta_V  (+ dl_DV  (* vorh_DV cosWnkl) dlr_HT_Anteil_H))
 		(delta_LR (- (* vorh_DV sinWnkl) dl_LR  dlr_HT_Anteil_V))
  )

  (setq Abtl_KplLchb_Ht (traeger.get HTrg ABTeil kplLochbild))
  
  (setq dv_Ant_H_AT (/ (- h_AT h_HT) 2.0))

  (setq sin_EW (sin (/ (* PI e_VWnkl_AT) 180.0)))
  (setq dv_Ant_dv_AT (/ (* -1.0 dv_AT) sin_EW))
  
  (setq delta_V_Ges (+ dv_Ant_H_AT dv_HT dv_Ant_dv_AT))
  
  (Anbauteil.Set abtl_KplLchb_AT  (delta_V delta_V_Ges))
  (Anbauteil.Set abtl_KplLchb_HT  (delta_V 0.0))


))

 
)

(defun TesteUnterflanschLochbild ()

    (setq Abtl_KplLchb_ht (traeger.get Htrg ABTeil kplLochbild))
    (Anbauteil.set Abtl_KplLchb_ht (switch_on _unterflansch_))
    (Anbauteil.set Abtl_KplLchb_ht (delta_V 100))


    (setq Abtl_KplLchb_at (traeger.get Tr_ID ABTeil kplLochbild))
    (Anbauteil.set Abtl_KplLchb_at (switch_on _unterflansch_))
    (Anbauteil.set Abtl_KplLchb_at (delta_V 100))


)

(defun sucheKopfPlatte ()

  (setq xPos_HT (Connect.get CastaData xPos_HT))
  (setq gesKnoBlTyp 0) ; auf unknown setzen
  (if (= (connect.get CastaData linkesEnde)  1) (setq gesLchbTyp _kpllochbildlinks_))
  (if (= (connect.get CastaData rechtesEnde) 1) (setq gesLchbTyp _kpllochbildrechts_))

  (if (= (connect.get CastaData anhtlinkesende)  1) (setq gesBlTyp   _kopfplattelinks_))
  (if (= (connect.get CastaData anhtrechtesende) 1) (setq gesBlTyp   _kopfplatterechts_))


  (setq abtl_KnoBl (Traeger.get HTrg firstAbtl kopfplatte))
  (while abtl_KnoBl
	; (AlertBox "Element am HTrg gefunden")
  	(setq sType     (Anbauteil.get abtl_KnoBl is_type gesBlTyp))
  	(if (= sType 1) (progn
	    (AlertBox "Kopfplatte gefunden -----------------------------------------------------")
	    (print sType)
	))
  	(setq abtl_KnoBl (Traeger.get Htrg nextAbtl kopfplatte))
  )
  
  (if (= (connect.get CastaData linkesEnde)  1) (setq gesBlTyp   _kopfplattelinks_))
  (if (= (connect.get CastaData rechtesEnde) 1) (setq gesBlTyp   _kopfplatterechts_))
  (setq abtl_KnoBl (Traeger.get Tr_ID firstAbtl kopfplatte))
  (while abtl_KnoBl
	; (AlertBox "Element am Tr_ID gefunden")
  	(setq sType     (Anbauteil.get abtl_KnoBl is_type gesBlTyp))
  	(if (= sType 1) (progn
	    (AlertBox "Kopfplatte gefunden -----------------------------------------------------")
	    (print sType)
	))
  	(setq abtl_KnoBl (Traeger.get Htrg nextAbtl kopfplatte))
  )

)

(defun getCurrTrgVerlaengerung ()
	(setq dL 0.0)
	(setq TrgEndeVerlaengerung 0.0)
	(if (= (Connect.get CastaData anHtlinkesende) 1) (progn
		(setq TEnd (Traeger.get HTrg links))
		(setq dL (TrEnde.get TEnd delta_L))
	))
	(if (= (Connect.get CastaData anHtrechtesende) 1) (progn
		(setq TEnd (Traeger.get HTrg rechts))
		(setq dL (TrEnde.get TEnd delta_L))
	))
	(if (< dL 0.0) (setq TrgEndeVerlaengerung (- dL)))
)
(defun setLaengsVerschiebung ()

	(setq e_VWnkl_AT 90.0)
	(setq TEnd_AT nil)
	(setq abtl_KplLchb_AT (Traeger.get Tr_ID ABTeil kplLochbild))
	(if (= (Connect.get CastaData linkesende) 1)  (setq TEnd_AT (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesende) 1) (setq TEnd_AT (Traeger.get Tr_ID rechts)))

	(if (= (Connect.get CastaData anHtlinkesende) 1)  (setq TEnd_HT (Traeger.get HTrg links)))
	(if (= (Connect.get CastaData anHtrechtesende) 1) (setq TEnd_HT (Traeger.get HTrg rechts)))
	
	(if (objexist TEnd_AT) (setq e_VWnkl_AT (TrEnde.get TEnd_AT V_Winkel)))

	(setq sin_EW (sin (/ (* PI e_VWnkl_AT) 180.0)))
	(setq tan_EW (tan (/ (* PI e_VWnkl_AT) 180.0)))
	
	(if (/= sin_EW 0.0) (progn
		(setq dl_AT (/ TrgEndeVerlaengerung sin_EW))
		(setq dl_HT (- TrgEndeVerlaengerung))
		
		(setq dl_AT_Curr (TrEnde.get TEnd_AT delta_L))
		(setq dl_HT_Curr (TrEnde.get TEnd_HT delta_L))
		
		(setq dl_AT (+ dl_AT dl_AT_Curr))
		(setq dl_HT (+ dl_HT dl_HT_Curr))
	
		(TrEnde.set TEnd_AT (delta_L dl_AT))
		(TrEnde.set TEnd_HT (delta_L dl_HT))
	
		(setq Faktor 1.0)
		(if (= (Connect.get CastaData rechtesende) 1) (setq Faktor -1.0))
	
		(setq curr_DV_Lchb_AT (Anbauteil.get abtl_KplLchb_AT delta_V))
		(setq add_DV_Lchb_AT (/ (* Faktor TrgEndeVerlaengerung) tan_EW))
		(setq new_DV_Lchb_AT (+ curr_DV_Lchb_AT add_DV_Lchb_AT))
		(Anbauteil.set abtl_KplLchb_AT (delta_V new_DV_Lchb_AT))
	
		(if (> add_DV_Lchb_AT 0) (progn
			(setq curr_HP_AT (Blech.get kplTrg hp))
			(Blech.set kplTrg (hp (+ curr_HP_AT add_DV_Lchb_AT)))
		))
	
	))
	

)

