; $ G(24)  HT	QT(U)	 	AF(F)		P(EZ)
; $ G(24)  AT	QT(K) 		AF(K)		P(E)
; $ G(24)  AE	V(-)		H(90)		R(0)
; $ G(30) HT		QT(U)	AF(F)		P(EZ)
; $ G(30) AT		QT(IUKR)	AF(K)		P(E)
; $ G(30) AE		V(90)		H(-)		R(0-1)
; $ 	  HT		QT(U)	AF(F)		P(EZ)
; $ 	  AT		QT(IUKR)	AF(K)		P(E)
; $ 	  AE		V(-)		H(-)		R(0-10 170-180)

(defun load-modules ()
	(load "mod-endinit-uz_auf_stzKopf")
	
	(setq vWinkel_trg 	(Connect.get CastaData trg_vwinkel))
	(print vWinkel_trg)
	
	(if (>= vWinkel_trg 0.0)
		(progn
			(setq at_is_stz 0)
		)
	)
	(if (> vWinkel_trg 75.0)
		(progn
			(setq at_is_stz 1)
		)
	)
	(if (>= vWinkel_trg 105.0)
		(progn
			(setq at_is_stz 0)
		)
	)
	(if (> vWinkel_trg 255.0)
		(progn
			(setq at_is_stz 1)
		)
	)
	(if (> vWinkel_trg 285.0)
		(progn
			(setq at_is_stz 0)
		)
	)
	
	(print at_is_stz)
	
	;AT ist die Sttze
	(if (= at_is_stz 1) (progn
		(print "AT IST STTZE")
   		(load "uz_auf_AtstzKopf")
   		(load "mod-multiconnect-stz-flansch")
   	))

	;HT ist die Sttze
	(if (= at_is_stz 0) (progn
  	    (print "HT IST STTZE")
   	    (load "uz_auf_HtStzKopf")
   	    (load "mod-multiconnect-stz-flansch")
	))
)

(defun init-connection ()
	(init-traegerenden)
	
;	(calcConnection)
	(calcConnection_Multiple)

    (if (= 1 2) (progn
		(Lochbild.set lochb (LB_Art 2)
				    (e "0 30 80 0 0 0")
		)
    	(setq Abtl_Lchb_HT (Traeger.get HTrg  ABTeil lochb))
    	(setq Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil lochb))
    	(Anbauteil.set Abtl_Lchb_HT (Master 0))
    	(Anbauteil.set Abtl_Lchb_AT (Master 1))
    )) 

	(setq dp (Blech.get blKpl dp))
	(SchraubenLaengenAnpassen dp 0)
	
	; CALLBACKS
	(Blech.set blKpl (formFkt "cb_blKpl"))
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am HT
; ----------------------------------------------------------------------------------------
(defun cb_blKpl (zp)
	(if (= zp 0) (print "*clear*"))
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get blKpl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get blKpl dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
			(print "Anpassen Schraubenlngen an Kopfplatte")
	       (setq dpDiff (- dpNeu dpAlt))
	       (SchraubenLaengenAnpassen dpNeu dpDiff)
	    ))
	))
)

(defun  AT_Lochbild_dlr_aus_dp (Lchb_ID dp)
	(setq rWnkl (Connect.get CastaData r-atrgewnkl_kopf))
	
	(if (/= rWnkl 180.0) (progn
		(if (= dp 0) (setq dp (Blech.get  blKpl dp)))
		
		(setq dp (* 1.0 dp))
		(setq bl_Wnkl (- 180.0  rWnkl))

		(print bl_Wnkl)
		
		;(if (> rWinkel_UZ 270.0) 
		;		(setq rWinkel_UZ (- 360.0  rWinkel_UZ))
		;		(setq  rWinkel_UZ (- rWinkel_UZ 180.0))
		;)

		(setq tanW (tan (/ (* PI  bl_Wnkl) 180.0)))
		
		(setq dlr_Bl (* tanW dp))
		(print  dlr_Bl)
		(setq Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil Lchb_ID))
		
		(setq dlr_Lchb (Anbauteil.get Abtl_Lchb_AT delta_LR))
		(print  dlr_Lchb)
		(setq  dlr_Lchb (+ dlr_Lchb dlr_Bl))
		(Anbauteil.set Abtl_Lchb_AT (delta_LR  dlr_Lchb))
	))

)


(defun SchraubenLaengenAnpassen (dp dpDiff)
	(print "in SchraubenLaengenAnpassen")
	(setq t_HT (Traeger.get HTrg t))
	(setq xPos 0.0)
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
		(setq tEnd (Traeger.get Tr_ID links))
		(setq xPos (TrEnde.get tEnd delta_L))
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(setq tEnd (Traeger.get Tr_ID rechts))
		(setq trgLaenge (Traeger.get Tr_ID sysLng))
		(setq deltaL (TrEnde.get tEnd delta_L))
		(setq xPos (- trgLaenge deltaL))
	))
	(print xPos)

	(print "Lochbilder suchen")
	(setq gefundenesLchb 0)
	(setq abtlLchb (Traeger.get Tr_ID firstAbtl lochbild (- xPos 5.0) (+ xPos 5.0)))
	(while abtlLchb 
		(setq gefundenesLchb (+ gefundenesLchb 1)) (print gefundenesLchb)
		(setq kplLchb (Anbauteil.get abtlLchb Objekt Lochbild))
		(setq dxsKopf_alt	(Lochbild.get kplLchb dxSKopf))
		
		(setq dxsKopf_Neu dp)
	    (Lochbild.set kplLchb 	(Klemml (+ t_HT dp))
								(dxSKopf dxsKopf_Neu)
	    )
       (AT_Lochbild_dlr_aus_dp kplLchb dpDiff)
		
		(setq abtlLchb (Traeger.get Tr_ID nextAbtl lochbild))
	)
	(print "Lochbilder gendert") (print "--  --  --  --  --")
)

