; $	HT	QT(Z)		AF(SK)		P(EZ)
; $ AT	QT(IUKRSTL)	AF(K)		P(E)
; $	AE	V(-)		H(-)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
; Nicht mehr fr QR/RR/Kastenprofile  im Einsatz. Entsprechende Teile knnen heraus genommen werden.
; Sept. 2015
;	
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (load "mod-endinit-uz-uzsteg")	
   (load "mod-lochbild")
   ;(load "mod-multiconnect-stz-steg")
   (load "mod-messages")
)



(defun init-connection ()

(print "*clear*")
(Connect.showAttributes CastaData)

	(if (= (Connect.get CastaData amHTSteg) 1) (progn
	
		(init-traegerenden)
		;(korrAtEnde abstandZumSteg)
		
		(setq LB_DEBUG 0)

		(setq StegLochb_Versch_AltesLB 0.0)
		; Testen, ob Makro geeignet - doppelt schrg und Verschiebungen ausschlieen
		(testeAnschluss)	; erzeugte Variable: RunMakro
		(setConnection)
		(if (= RunMakro 0)  (AlertBox "Achtung!\nBei dieser Konstellation besteht die Gefahr,\ndass die Schrauben nicht passen." "Bolts_May_Not_Fit"))
		
	    (if (= 1 2) (progn
			(setq AnschlussArt (Connect.get CastaData AnschlussArt))
			(print AnschlussArt)
			(setq AnschlussTyp (Connect.get CastaData AnschlussTyp))
			(print  AnschlussTyp)
	    ))
	    (if (= 1 2) (progn
	    	(Lochbild.set kpl_lochbild (e "0 20 100 0 0 0") (LB_Art 2))
	    ))

	    (if (= 1 2) (progn
	    	(setq trgGegen (Connect.get CastaData trg_steg_gegen))
	    	(print trgGegen)
    		(if (= (Connect.get CastaData exist_steglchb) 1) (progn
		 	(setq StegLchb (Connect.get CastaData StegLchb_Gegen))
		    	(if trgGegen (progn
			    	(setq Abtl_AT       (Traeger.get Tr_ID    AbTeil StegLchb))
			    	(setq Abtl_HT       (Traeger.get HTrg     AbTeil StegLchb))
			    	(setq Abtl_AT_Gegen (Traeger.get trgGegen AbTeil StegLchb))
			    	
			    	(Anbauteil.set Abtl_HT		(Master 0))
			    	(Anbauteil.set Abtl_AT		(Master 1))
			    	(Anbauteil.set Abtl_AT_Gegen	(Master 0))
			))
			(setq StegLchb nil) ; 
		))
	    ))


	    (if (= LB_DEBUG 1) (progn
	    	(if (existObj lbdummy) 	(Connect.storeAnschlObjs CastaData lbdummy))
	    ))
	  ); progn
		(AlertBox "Dieses Makro kann nur fr Anschlsse am Steg eingesetzt werden!" "Macro_Just_For_WebConnections")
	)


)
(defun testeAnschluss ()
	(setq RunMakro      1)
	(setq SpezLchb_Flag 0)


	(if (= (Connect.get CastaData linkesEnde)  1) (setq AT_Ende   (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1) (setq AT_Ende   (Traeger.get Tr_ID rechts)))
	(setq VWinkel_E (TrEnde.get AT_Ende V_Winkel))
	(setq HWinkel_E (TrEnde.get AT_Ende H_Winkel))

	(if (/= VWinkel_E 90.0) (progn
	     (if (/= HWinkel_E 90.0) (progn
	         (setq delta_LR_HT (Traeger.get HTrg  delta_LR)
	               delta_LR_AT (Traeger.get Tr_ID delta_LR)
	               delta_V_AT  (Traeger.get Tr_ID delta_V)
	         )
	         (if (/= delta_LR_HT 0.0) (setq RunMakro 0))
	         (if (/= delta_LR_AT 0.0) (setq RunMakro 0))
	         (if (/= delta_V_AT  0.0) (setq RunMakro 0))
	     ))
	))

	(if (= (Connect.get CastaData exist_steglchb) 1) (progn
	    (setq kpl_lochbild (Connect.get CastaData StegLchb_Gegen))
	    (setq ABTeilVorhanden (Traeger.get Htrg ABTeil kpl_lochbild))

	    (if ABTeilVorhanden (progn
		(setq Steg_LB 	  131072)	; auf OK bezogen
		(setq isType_1 (Anbauteil.get ABTeilVorhanden is_type Steg_LB))
		
		
		(if (= isType_1 1) (progn
		    ; (print  "Bei diesem Steglochbild ist ein Gegenanschluss nicht mglich")
		    (setq SpezLchb_Flag 1)
		    (setq h_Ht    (Traeger.get HTrg  h))
		    (setq h_At    (Traeger.get Tr_ID h))
		    (setq dv_At   (Traeger.get Tr_ID delta_V))
		    (setq dv_Ht   (Traeger.get HTrg  delta_V))

		    (setq StegLochb_Versch_AltesLB (- (/ h_Ht 2.0) (/ h_AT 2.0) (- dv_AT)))	; gilt aber nur, wenn Lchb senkrecht
		    (setq StegLochb_Versch_AltesLB (- (/ h_At 2.0) (/ h_Ht 2.0) dv_AT))	; gilt aber nur, wenn Lchb senkrecht

	
		    (setq dv_Vorh_Gegen (Anbauteil.get ABTeilVorhanden delta_V))
		    (setq StegLochb_Versch_AltesLB 0.0)
		    (setq StegLochb_Versch_AltesLB (- StegLochb_Versch_AltesLB dv_Vorh_Gegen))
		    (setq StegLochb_Versch_AltesLB (- StegLochb_Versch_AltesLB  (/ h_AT 2.0)))
		    (setq StegLochb_Versch_AltesLB (+ StegLochb_Versch_AltesLB  (/ h_HT 2.0)))
		    (setq StegLochb_Versch_AltesLB (+ StegLochb_Versch_AltesLB  dv_At))
		    (setq StegLochb_Versch_AltesLB (- StegLochb_Versch_AltesLB  dv_Ht))

		    
		    (setq RunMakro 0)
		))
	    ))


	))


)

(defun setConnection ()
	; Objekte erzeugen
	(setq kpl_blech (Blech.create))
	(Connect.storeAnschlObjs CastaData kpl_blech)


;	Schrauben bei Kastenprofilen werden zwar erzeugt aber nicht eingebaut.	
	(setq qsform_ht	(Traeger.get Htrg qsform))
	(if (= qsform_ht "K") 
		(setq kpl_lochbild (Lochbild.create))
		(progn
		    (if (= (Connect.get CastaData exist_steglchb) 1)
			(progn
				(setq kpl_lochbild (Connect.get CastaData steglchb_gegen))
			)
			(progn
				(setq kpl_lochbild (Lochbild.create))
			)
		    )
		    (Connect.storeAnschlObjs CastaData kpl_lochbild)
		)
	)

; )
; (defun HierWeiter ()	
	
	; Blechdicke berechnen
	(calcAndSetKplThickness)
	
	;Schraubengre anhand der min. Blechdicke bestimmen(grobe Anhaltswerte)
	(setq min_blech_dp 10)
	(setq akt_kpl_dp (Blech.get kpl_blech dp))
	(setq s_ht (Traeger.get Htrg s))
	(if (< s_ht akt_kpl_dp)
		(setq min_blech_dp s_ht)
		(setq min_blech_dp akt_kpl_dp)
	)
	(if (= min_blech_dp 0) (setq min_blech_dp 6))
	(print min_blech_dp)
	(setq S_Bez "M12")	; sicherheitshalber initialisieren
        (if (= (Connect.get CastaData exist_steglchb) 0) (calcSchraube min_blech_dp)) ; -> S_Bez
        (if (= (Connect.get CastaData exist_steglchb) 1) (setq S_Bez (Lochbild.get kpl_lochbild S_Bez))) ; -> S_Bez
	
	; Schraubengre dem Lochbild hinzufgen
	(Lochbild.set kpl_lochbild (S_Bez S_Bez))
	
	; min. Rand- / Lochabstnde berechnen
	(calcMinRandLochAbst kpl_lochbild) ; -> e_min, e1_min, e_min_rund, e1_min_rund, h_min
	
	; Kopfplatte berechnen
	(calcAndSetKplDaten)
	
	;Einbauposition prfen
	(checkPosition kpl_blech)
	
	(setq BlAbm_Korrigiert 0)
	(if (> Warn_BlechAusrundKoll 0) (progn
		(setq BlAbm_Korrigiert 1)
		(korrigiereBlechAbmessungen)
	))
	
	; Anbauteil Kopfplatte hinzufgen
	(setKplAbtl)
	
	(if (= Warn_BlechAusrundKoll 1)
		(alertBox "Die Kopfplatte reicht in die untere Ausrundung den Haupttrgers.\nBitte korrigieren Sie die Positionierung der Trger oder passen Sie die Kopfplatte an!" "Headplate_To_Fit_FilletBottom")
	)
	(if (= Warn_BlechAusrundKoll 2)
		(alertBox "Die Kopfplatte reicht in die obere Ausrundung den Haupttrgers.\nBitte korrigieren Sie die Positionierung der Trger oder passen Sie die Kopfplatte an!"  "Headplate_To_Fit_FilletTop")
	)

	; QR als Haupttrger ist momentan ausgeklammert
	(if (= qsform_ht "K") (progn
	    (AlertBox "QR als Haupttrger sollte derzeit nicht angeboten werden.\nBitte dem Support melden!" "ERR_QR_not_allowed")

	    (calcAndSetLochbildDaten kpl_lochbild kpl_blech)
	    ; Lochbildanbauteile hinzufgen
	    (setLochbildAbtl kpl_lochbild kpl_blech)
	    (Connect.storeAnschlObjs CastaData kpl_lochbild)
	))


	(if (/= qsform_ht "K") (progn
	    ; Auf gegenberliegenden Anschluss prfen
	
	    (if (= (Connect.get CastaData exist_steglchb) 1)
		(progn
			(getExistingLochbild)
			(moveExistingLochbild)
		)
		(progn
  		; Lochbilddaten berechnen
			(calcAndSetLochbildDaten kpl_lochbild kpl_blech)
			
			; Lochbildanbauteile hinzufgen
			(setLochbildAbtl kpl_lochbild kpl_blech)
		)
  	    )
	))

	; Konterblech hinzufgen, sofern kein durchgngiger Anschluss
	; erst hier, damit die Schraubenlngen dann durch das zustzliche Blech
	; korrekt angepasst werden
	(createKonterPlate)
	
	; korrigiere Stz-Ende
	(if (= (Connect.get CastaData anz_weitere_anschl) 0)
		(if (= (Connect.get CastaData anschlzwhtenden) 0)
			(korrigiereStzEnde)
		)
	)
	
	(if (= SpezLchb_Flag 1) (progn
	    (setq Abtl_LB_AT (Traeger.get Tr_ID ABTeil kpl_lochbild))
	    (setq dv_Vorh (Anbauteil.get Abtl_LB_AT delta_V))
	    (Anbauteil.set Abtl_LB_AT (delta_V (- StegLochb_Versch_AltesLB)))
	))
	
	; Wenn die Schrauben neben das Profil gesetzt werden sollen
	(if (= BlAbm_Korrigiert 1) 	(korrigiereSchraubenPositionen))

	; Test-Lochbild asymmetrisch	
	; (Lochbild.set kpl_lochbild (e "0 30 100 0 0 0") (w0 0) (LB_Art 2))
	
	; Callbacks
  (Blech.set kpl_blech (formFkt "cb_kplblech"))
  
  
      (if (= 1 2) (progn
	    (if (= (Connect.get CastaData exist_steglchb) 1) (progn
	    	(setq Abtl_LB_AT (Traeger.get Tr_ID ABTeil kpl_lochbild))
	    	(setq delta_LT_Abtl (Anbauteil.get Abtl_LB_AT delta_LR))
	    	(Anbauteil.set Abtl_LB_AT (delta_LR (- delta_LT_Abtl)))
	    ))
      ))
  
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr die Kopfplatte
; ----------------------------------------------------------------------------------------
(defun cb_kplblech (zp)
	(print "in Callback-Funktion cb_KplBlech")

	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get kpl_blech dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get kpl_blech dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	        (setq tmpLchb_Flag 0)
	        (if kpl_lochbild
	           (print "kpl_Lochbild definiert")
	           (progn
	              (print "kpl_lochbild ist nicht definiert")
		      (if (= (Connect.get CastaData exist_steglchb) 1) (progn
	    		  (setq kpl_lochbild (Connect.get CastaData StegLchb_Gegen))
	    		  (setq tmpLchb_Flag 1)
	    	      ))
	    	   )
	       )
	       
	       (if kpl_lochbild (progn
		       (setq dpDiff (- dpNeu dpAlt))
		       (setq alteKlemml 	(Lochbild.get kpl_lochbild Klemml))
		       (setq altesDxSKopf (Lochbild.get kpl_lochbild dxSKopf))
		       (print alteKlemml)
		       (print altesDxSKopf)
		       (setq klemml_neu (+ alteKlemml dpDiff))
		       (print klemml_neu)
		       (print dpDiff)
		       
		       (Lochbild.set kpl_lochbild 	(Klemml  klemml_neu))


		       
		       (if (= (Connect.get CastaData amHtStegLinks) 1)
		       	(progn
		       		(setq dxsKopf_neu (+ altesDxSKopf dpDiff))
		       		(print dxsKopf_neu)
		       		
		       		(Lochbild.set kpl_lochbild (dxSKopf dxsKopf_neu))	 
		       	)      	
		       )
			(cbDeltaLR kpl_lochbild dpDiff)
		   )
		   (progn
				(AlertBox "Klemmlnge konnte nicht gendert werden" "No_Change_of_ClampingLength")
		   )	
		)
		(if (= tmpLchb_Flag 1) (setq kpl_lochbild nil))
	    ))
	))
)
(defun cb_konterplate (zp)
	(print "in Callback-Funktion cb_konterplate")

	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get KonterPlate dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get KonterPlate dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	        (setq tmpLchb_Flag 0)
	        (if KonterPlate
	           (print "KonterPlate definiert")
	           (progn
	              (print "KonterPlate ist nicht definiert")
				  (if (= (Connect.get CastaData exist_steglchb) 1) (progn
	    		    (setq kpl_lochbild (Connect.get CastaData StegLchb_Gegen))
	    		    (setq tmpLchb_Flag 1)
	    	      ))
	    	   )
	       )
	       
	       (if kpl_lochbild (progn
		       (setq dpDiff (- dpNeu dpAlt))
		       (setq alteKlemml 	(Lochbild.get kpl_lochbild Klemml))
		       (setq altesDxSKopf (Lochbild.get kpl_lochbild dxSKopf))
		       (print alteKlemml)
		       (print altesDxSKopf)
		       (setq klemml_neu (+ alteKlemml dpDiff))
		       (print klemml_neu)
		       (print dpDiff)
		       
		       (Lochbild.set kpl_lochbild 	(Klemml  klemml_neu))


		       
		       (if (= (Connect.get CastaData amHtStegRechts) 1)
		       	(progn
		       		(setq dxsKopf_neu (+ altesDxSKopf dpDiff))
		       		(print dxsKopf_neu)
		       		
		       		(Lochbild.set kpl_lochbild (dxSKopf dxsKopf_neu))	 
		       	)      	
		       )
			   (cbDeltaLR kpl_lochbild dpDiff)
		   )
		   (progn
				(AlertBox "Klemmlnge konnte nicht gendert werden" "No_Change_of_ClampingLength")
		   )	
		)
		(if (= tmpLchb_Flag 1) (setq kpl_lochbild nil))
	    ))
	))
)


; ---------------------------------------------------------------------
; Korrigiert die delta_lr Verschiebung des LB-ABTL bei einem Aufruf
; der Callbackfunktion (Dickennderung des Bleches)
; ---------------------------------------------------------------------
(defun cbDeltaLR (KPL_LB DP_DIFF)
	(print ">------------------------------------------------------------------------------")
	(print "Anbauteil Korrektur wegen Callback-Funktion")
	
	; Anbauteil des HT-LB
	(setq ht_lb_abtl (Traeger.get Htrg Abteil KPL_LB))
				 
	; delta_lr Verschiebung des Anbauteils
	(setq delta_lr_abtl_alt (Anbauteil.get ht_lb_abtl delta_lr))
	(print delta_lr_abtl_alt)
	
	; Wert, um den das Anbauteil korrigiert wird (erstmal auf 0.0) 
	(setq delta_lr_abtl_neu 0.0)
	
	; Winkel des AT zum HT in horizontaler Richtung
	(setq h_wnkl_steg_at (Connect.get CastaData h-atrgewnkl_steg))
	(print h_wnkl_steg_at)
	
	(setq tanHW (tan (/ (* PI h_wnkl_steg_at) 180.0)))
	(print tanHW)
	
	(if (/= tanHW 0.0)
		(setq delta_lr_abtl_korr (/ DP_DIFF tanHW))
	)
	(print delta_lr_abtl_korr)
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq delta_lr_abtl_neu (- delta_lr_abtl_alt delta_lr_abtl_korr)))
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq delta_lr_abtl_neu (+ delta_lr_abtl_alt delta_lr_abtl_korr)))

	; Anbauteil korrigieren
	(print delta_lr_abtl_neu)
	(Anbauteil.set ht_lb_abtl (delta_lr delta_lr_abtl_neu))
	
	(print "<------------------------------------------------------------------------------")
)



; ****************************************************************************************
; HILFSFUNKTIONEN
; ****************************************************************************************

; ----------------------------------------------------------------------------------------
; Berechnet die Kopfplattendicke
; ----------------------------------------------------------------------------------------
(defun calcAndSetKplThickness ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE KOPFPLATTEN-DICKE")
	(print "------------------------------------------------------------")
	(setq t_ht (Traeger.get Htrg t))
	(setq t_at (Traeger.get Tr_ID t))
	
	(setq dp_kpl (runde t_at auf 5.0))
	(if (<=  dp_kpl  2.0) (setq dp_kpl 6.0))

;	(setq dp_kpl 20)	; AF-spez	
	(Blech.set kpl_blech (dp dp_kpl))
	(print "<-----------------------------------------------------------")
)


; ----------------------------------------------------------------------------------------
; Berechnet die Kopfplattendaten
; ----------------------------------------------------------------------------------------
(defun calcAndSetKplDaten ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE KOPFPLATTEN-DATEN")
	(print "------------------------------------------------------------")
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID rechts)))

;	(TrEnde.set AT_Ende (xAkl 0) (zAkl 0)) ; AF-spez

	
	(setq	vscherl_at	(TrEnde.get AT_Ende vscherl)
		hscherl_at	(TrEnde.get AT_Ende hscherl)
	)
	
	(setq	b_at 		(Traeger.get Tr_ID b)
		qsform_at	(Traeger.get Tr_ID qsform)
	)
	
	(setq abst_zum_rand e_min_rund)
	(setq abst_zum_trg (* 0.5 e_min_rund))
	(if (= qsform_at "R")
		(setq abst_zum_trg (* 0.25 e_min_rund))
	)
	
	(setq rand (+ abst_zum_rand abst_zum_trg))
	; Kopfplattenhhe
	(setq kpl_hp (+ vscherl_at (* 2.0 rand)))
	(print kpl_hp)
	
	; Kopfplattenbreite
	(setq kpl_bp (+ hscherl_at (* 2.0 rand)))
	(print kpl_bp)
	
	; Dok
	(setq kpl_dok (- rand))
	(print kpl_dok)


;	(setq kpl_hp  210)	; AF-spez	
;	(setq kpl_dok -4.5)	; AF-spez	
;	(setq kpl_bp  260)	; AF-spez	
;	(Blech.set kpl_blech 	(xAsym	10))  ; AF-spez

	
	(Blech.set kpl_blech 	(hp	kpl_hp)
				(bp 	kpl_bp)
				(dok 	kpl_dok)
	)
	(print "<-----------------------------------------------------------")	
)		


; ----------------------------------------------------------------------------------------
; Hinzufgen des Kopfplatten-Anbauteils
; ----------------------------------------------------------------------------------------
(defun setKplAbtl ()
	(print ">-----------------------------------------------------------")
	(print "FGE KOPFPLATTEN-ANBAUTEIL HINZU")
	(print "------------------------------------------------------------")
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	
	(setq kpl_dp (Blech.get kpl_blech dp))
	
	(setq xPos_abtl	xPos_ht)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(setq AT_Ende (Traeger.get Tr_ID links))
			(Traeger.addAbtl Tr_ID kpl_blech xPos_abtl 0.0 _kopfplattelinks_)
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(setq AT_Ende (Traeger.get Tr_ID rechts))
			(Traeger.addAbtl Tr_ID kpl_blech xPos_abtl 0.0 _kopfplatterechts_)
		)
	)
	
	(TrEnde.pTrim AT_Ende kpl_dp)
	
	(print "<-----------------------------------------------------------")	
)

; ----------------------------------------------------------------------------------------
; Berechnet die Lochbilddaten
; ----------------------------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lochb_ID Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(print "------------------------------------------------------------")
	(Lochbild.set Lochb_ID 	(Guete  "4.6")
				(Anz_S  4)
	)
	
	(setq	kpl_hp 		(Blech.get Blech_ID hp)
		kpl_bp 		(Blech.get Blech_ID bp)
		kpl_dok 	(Blech.get Blech_ID dok)
		kpl_dp		(Blech.get Blech_ID dp)
	)	
	(setq 	s_ht		(Traeger.get Htrg s)
		qsform_ht	(Traeger.get Htrg qsform)
	)
	(setq 	s_ht_halb 	(* 0.5 s_ht))
	
	; e0
	(setq e0_lb (- abst_zum_trg))
	(print e0_lb)
	; e1
	(setq e1_lb (- kpl_hp (* 2.0 e_min_rund)))
	
	; w0
	(setq w0_lb (- kpl_bp (* 2.0 e_min_rund)))
	 
		
	; klemml
	(setq klemml_lb (+ s_ht kpl_dp))
	(print klemml_lb)
	
	; dxskopf
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(setq dxskopf_lb (+ kpl_dp s_ht_halb))
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(setq dxskopf_lb s_ht_halb)
	)
	
	(if (= qsform_ht "U")	
		(progn
			(if (= (Connect.get CastaData amHtStegLinks) 1) (setq dxskopf_lb kpl_dp))
			(if (= (Connect.get CastaData amHtStegRechts) 1) (setq dxskopf_lb 0.0))
		)
	)
	
	(print dxskopf_lb)
	
;	(setq e0_lb   50)	; AF-spez	
;	(setq e1_lb  100)	; AF-spez	
;	(setq w0_lb  180)	; AF-spez	
;	(Lochbild.set Lochb_ID 	(S_Bez		"M20") (Guete  "10.9"))  ; AF-spez

	
	(Lochbild.set Lochb_ID 	(e0		e0_lb)
				(e1		e1_lb)
				(w0		w0_lb)
				(klemml		klemml_lb)
				(dxsKopf	dxskopf_lb)
	)
	
	(if (= LB_DEBUG 1)
		(Lochbild.set Lochb_ID (e2 	300))
	)
	(print "<-----------------------------------------------------------")	
)


; ----------------------------------------------------------------------------------------
; Hinzufgen der Lochbild-Anbauteile
; ----------------------------------------------------------------------------------------
(defun setLochbildAbtl (Lochb_ID Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "FGE LOCHBILD-ANBAUTEILE HINZU")
	(print "------------------------------------------------------------")
	
	; AT
	; ######################################################################################
	(if (= (Connect.get CastaData linkesEnde) 1)
		(Traeger.addAbtl Tr_ID Lochb_ID 0.0 0.0 _kpllochbildlinks_)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(Traeger.addAbtl Tr_ID Lochb_ID 0.0 0.0 _kpllochbildrechts_)
	)
	
	(setq delta_v_abtl_at 0)
	
	(setq kpl_dp (Blech.get Blech_ID dp))
(setq kpl_dp 0.0)
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	
	(setq tanW (tan (/ (* PI at_winkel) 180.0)))
	(setq sinW (sin (/ (* PI at_winkel) 180.0)))
	
	(setq anteil_hneigung (/ (* 1.0 kpl_dp) tanW))
	
	(setq delta_v_abtl_at 0.0)
;	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_at (- anteil_hneigung)))
;	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_at    anteil_hneigung))
	
	
	; HT
	; ######################################################################################
	(setq rwinkel_at		(Traeger.get Tr_ID r_winkel))
	
	(setq	xPos_ht 	(Connect.get CastaData xPos_ht)
		vwinkel_uz	(Connect.get CastaData hpttrg_vwinkel)
		r_winkel_steg	(Connect.get CastaData r-atrgewnkl_steg)
	)
	; AF-2012-04-23 - Winkel nicht korrekt
;	(if (= (Connect.get CastaData vAtr-lHtr) 1) (setq r_winkel_steg (- 180.0 r_winkel_steg)))
	
	(setq delta_v_abtl_ht 0.0)
	(setq delta_lr_abtl_ht 0.0)
		
;    (print "Hier geht es jetzt los !!!")
;    (Connect.ShowAttributes CastaData)

	
	; Differnzwinkel zwischen HT-Neigung und AT-Rotation berechnen
	; ---------------------------------------------
	(print "---- Differenzwinkel ----")
	(print vwinkel_uz)
	(print rwinkel_at)
	(print r_winkel_steg)
	
	(setq diffWinkel 0.0)
	
;	(if (!= (Connect.get CastaData vatr-vhtr)  0) (progn 
		(if (= (Connect.get CastaData amHtStegRechts) 1) (progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (+ (- r_winkel_steg 90.0)))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (- (- r_winkel_steg 90.0)))
			)
		))
		(if (= (Connect.get CastaData amHtStegLinks) 1)	(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (- (- r_winkel_steg 90.0)))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (+ (- r_winkel_steg 90.0)))
			)
		))
;	))
	; AF-2012-04-23 - Winkel nicht korrekt
	(setq htVWinkel (Connect.get CastaData hpttrg_vwinkel))
;	(if (> htVWinkel 180.0) (setq diffWinkel (- 180.0 diffWinkel)))
	
	(print diffWinkel)
	
	(setq sinW (sin (/ (* PI diffWinkel) 180.0)))
	(setq cosW (cos (/ (* PI diffWinkel) 180.0)))
	(setq tanW (tan (/ (* PI diffWinkel) 180.0)))

	; Winkel des Anbauteils
	; ----------------------------------------------
	(setq abtl_winkel_ht 0.0)
	(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq abtl_winkel_ht  90.0)	)
	(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq abtl_winkel_ht 270.0)	)
	(if (= (Connect.get CastaData vatr-vhtr)  0)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq abtl_winkel_ht 180.0)	)
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq abtl_winkel_ht 180.0)	)
		)
	)


	(print "Winkel nach dem generellen Ausrichten")
	(print abtl_winkel_ht)
	
	(print "Differenzwinkel mitbetrachtet")
	(if (= (Connect.get CastaData vatr-vhtr)  0)
		(setq abtl_winkel_ht (- abtl_winkel_ht (- 90.0 diffWinkel)))
		(setq abtl_winkel_ht (- abtl_winkel_ht         diffWinkel))
	)
	(print abtl_winkel_ht)
	
	(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq abtl_winkel_ht (- 180.0 abtl_winkel_ht)))
	(print abtl_winkel_ht)
	
; ---------------------------------------
	(setq abtl_winkel_ht 0.0)
	(setq 	r_wkl_steg	(Connect.get CastaData r-atrgewnkl_steg))
	
	
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
		(if (= (Connect.get CastaData sAtr-lHtr-ex)  1) (setq abtl_winkel_ht (+  180.0  r_wkl_steg)))
		(if (= (Connect.get CastaData sAtr-lHtr-ex) -1) (setq abtl_winkel_ht (-  180.0  r_wkl_steg)))
		(if (= (Connect.get CastaData sAtr-lHtr-ex)   0) (progn
		    (if (= (Connect.get CastaData vAtr-lHtr) -1)
		    	(setq abtl_winkel_ht    (-  180.0  r_wkl_steg))
		    	(setq abtl_winkel_ht    (+  180.0  r_wkl_steg))
		    )
		))
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(if (= (Connect.get CastaData sAtr-lHtr-ex)   1) (setq abtl_winkel_ht    r_wkl_steg))
		(if (= (Connect.get CastaData sAtr-lHtr-ex)  -1) (setq abtl_winkel_ht (- r_wkl_steg)))
		(if (= (Connect.get CastaData sAtr-lHtr-ex)   0) (progn
		    (if (= (Connect.get CastaData vAtr-lHtr) -1)
		    	(setq abtl_winkel_ht    r_wkl_steg) 
		    	(setq abtl_winkel_ht (- r_wkl_steg))
		    )
		))
	))


	(if (= (Connect.get CastaData amhtstegrechts ) 1)	(setq abtl_winkel_ht    (- abtl_winkel_ht 180.0)))


	(setq delta_L_AT 0.0)
	(setq EVWnkl_AT  0.0)
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
		(setq	TrgEnde_AT (Traeger.get Tr_ID links))
		(setq	delta_L_AT (TrEnde.get TrgEnde_AT delta_L)
			EVWnkl_AT  (TrEnde.get TrgEnde_AT V_Winkel)
		)
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(setq TrgEnde_AT (Traeger.get Tr_ID rechts))
		(setq delta_L_AT (TrEnde.get TrgEnde_AT delta_L)
			EVWnkl_AT  (TrEnde.get TrgEnde_AT V_Winkel)
		)
	))

	; ----------------------------------------------
	; delta_v Anbauteil HT
	; ----------------------------------------------
	
	; Anteil AT-Hhe
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(if (= (Connect.get CastaData linkesEnde) 1)		(setq AT_Ende (Traeger.get Tr_ID links)))
		(if (= (Connect.get CastaData rechtesEnde) 1)		(setq AT_Ende (Traeger.get Tr_ID rechts)))
		
		(setq vscherl_at	(TrEnde.get AT_Ende vscherl))
		(setq vscherl_at_halb (* 0.5 vscherl_at))
		
		(setq delta_v_abtl_ht (- vscherl_at_halb))
		(print "Erste Berechnung ............")
		(print delta_v_abtl_ht)
		(setq delta_v_abtl_ht 0.0)
	; ----------------------------------------------
	))
	; ----------------------------------------------

	; Anteil AT-Neigung (horizontal)
	; ----------------------------------------------
    (if (= 1 1)	(progn
	; ----------------------------------------------
	(setq	s_ht 		(Traeger.get Htrg s)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(setq kpl_dp (Blech.get Blech_ID dp))
	(setq kpl_dp (* 1.0 kpl_dp))
; (setq kpl_dp 0.0)
; (setq s_ht   0.0)
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	
	(setq tanW (tan (/ (* PI at_winkel) 180.0)))
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq abst (+ (* 0.5 s_ht) kpl_dp (- delta_lr_ht))))
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq abst (+ (* 0.5 s_ht) kpl_dp delta_lr_ht)))
	
;	(setq anteil_hneigung (/ abst tanW))
	(setq anteil_hneigung 0.0)
	
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
		(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_hneigung)))
		(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_hneigung)))
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_hneigung)))
		(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_hneigung)))
	))

	(setq tanW (tan (/ (* PI EVWnkl_AT) 180.0)))
;	(setq anteil_vneigung (/ (+ delta_lr_ht (* 0.5 s_ht)) tanW))
	(setq anteil_vneigung (/ (- abst kpl_dp) tanW))
	
	(print "vorher ..... delta_v_abtl_ht")
	(print delta_v_abtl_ht)
	(print delta_L_AT)
	(print EVWnkl_AT)
	(setq cosW (cos (* PI (/ EVWnkl_AT 180.0))))
	
	
	(if (= (Connect.get CastaData linkesEnde) 1)  (progn
		(if (/= cosW 0.0) (setq delta_L_AT (- delta_L_AT (/ (* 1.0 kpl_dp) cosW))))
;		(setq delta_v_abtl_ht (- delta_v_abtl_ht (* cosW delta_L_AT)))
		(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_vneigung))
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(if (/= cosW 0.0) (setq delta_L_AT (- delta_L_AT (/ (* 1.0 kpl_dp) cosW))))
;		(setq delta_v_abtl_ht (+ delta_v_abtl_ht (* cosW delta_L_AT)))
		(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_vneigung))
	))
	

	(print delta_L_AT)
	(print (* cosW delta_L_AT))
	(print "nachher ..... delta_v_abtl_ht")
	(print delta_v_abtl_ht)
;	(setq  delta_v_abtl_ht 0.0)
	
;;;	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_hneigung)))
;;;	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_hneigung)))
	
	; ----------------------------------------------
    ))
	; ----------------------------------------------	
		
	; Anteil AT-Neigung (vertikal)
	; ----------------------------------------------
    (if (= 1 2)	(progn
	; ----------------------------------------------
	(setq	s_ht 		(Traeger.get Htrg s)
		delta_v_ht	(Traeger.get Htrg delta_v)
	)
	
	(setq tRechts   (Traeger.get Tr_ID rechts))
	(setq VWinkel_E (TrEnde.get tRechts V_Winkel))
	(setq HWinkel_E (TrEnde.get tRechts H_Winkel))
	
	(setq kpl_dp (Blech.get Blech_ID dp))
	(setq kpl_dp (* 1.0 kpl_dp))			;; AF 08-2009 --- dp sollte nicht bercksichtigt werden
	
	(setq at_qwinkel (Connect.get CastaData v-atrgewnkl_steg))
	(if (/= at_qwinkel 90.0) (progn
		;; AF - Meldung eingesetzt, da aus Zeitgrnden Code von DM nicht komplett nachvollzogen werden konnte
		;; muss noch einmal komplett durchgesehen werden.
		(alertBox "Bei dieser Winkelkonstellation gibt es derzeit Abweichungen der Schrauben im Trgersteg!" "WRN_OffsetDiscrepancy_Web")
	))
	
	(setq tanQW (tan (/ (* PI at_qwinkel) 180.0)))
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq abstQ (+ (* 0.5 s_ht) kpl_dp (- delta_v_ht))))
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq abstQ (+ (* 0.5 s_ht) kpl_dp delta_v_ht)))
	
	(setq anteil_qneigung (/ abstQ tanQW))
	
;	(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_qneigung)))
;	(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_qneigung)))
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_qneigung)))
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_qneigung)))
	; ----------------------------------------------
	(setq  delta_lr_abtl_ht (- delta_lr_abtl_ht))
	; (setq delta_lr_abtl_ht 0.0)

    ))
	; ----------------------------------------------	
;#################################################################
    ; seitlicher Versatz aus Haupttrger - Steg, delta_LR und Kopfplattendicke
    (Connect.showAttributes CastaData)
    (if (= 2 2) (progn
	(if (= (Connect.get CastaData linkesEnde)  1) (setq AT_Ende   (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1) (setq AT_Ende   (Traeger.get Tr_ID rechts)))
	(setq VWinkel_E (TrEnde.get AT_Ende V_Winkel))
	(setq HWinkel_E (TrEnde.get AT_Ende H_Winkel))
	
	(setq	s_ht 		(Traeger.get Htrg s)
		dlr_HT		(Traeger.get Htrg delta_LR)
		kpl_dp		(Blech.get Blech_ID dp)
		kpl_dp 		(* 1.0 kpl_dp)
	)

	(setq cosw_VWnkl (cos (/ (* PI VWinkel_E) 180.0)))
	(setq cosw_HWnkl (cos (/ (* PI HWinkel_E) 180.0)))

	(setq tanw_VWnkl (tan (/ (* PI VWinkel_E) 180.0)))
	(setq sinw_VWnkl (sin (/ (* PI VWinkel_E) 180.0)))
	(setq dlV_Local  (* cosw_VWnkl (+ (* (- sinw_VWnkl) kpl_dp) (* 0.5 s_ht))))
	(setq delta_v_abtl_ht (- delta_v_abtl_ht dlV_Local))

	(setq Abstand (+ kpl_dp (* 0.5 s_ht)))
	(if (= (Connect.get CastaData amhtsteglinks )  1) (setq Abstand (- Abstand dlr_HT)))
	(if (= (Connect.get CastaData amhtstegrechts ) 1) (setq Abstand (+ Abstand dlr_HT)))
	
	
	(setq tanw_HWnkl (tan (/ (* PI (- HWinkel_E 90.0)) 180.0)))
	(setq dlH_Local  (* tanw_HWnkl 	Abstand))

	(if (= (Connect.get CastaData amhtstegrechts ) 1) (setq dlH_Local (- dlH_Local)))

	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht dlH_Local))
	
    ))
;#################################################################

	; TRAEGERVERSCHIEBUNGEN
	; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		
	; Anteil delta_v Verschiebung HT
	; ----------------------------------------------
    (if (= 1 1)	(progn
	; ----------------------------------------------
	(setq delta_v_ht (Traeger.get Htrg delta_v))


									; 	Winkel war nicht bercksichtigt
									; AF -  04-2012 Winkeldeutung verbessert
									; AF -	11-2012 Winkel nochmals korrigiert.
	(print delta_v_abtl_ht)
	
;	11-2012 AF - herausgenommen und mit neuem Winkel korrigiert
;	(setq cosWLokal (cos (/ (* PI (+ abtl_winkel_ht 90.0)) 180.0))) ; neue Winkelberechnung
	(setq WLokal (- abtl_winkel_ht 90.0))
	(setq cosWLokal (cos (/ (* PI WLokal) 180.0))) ; neue Winkelberechnung
	
	(setq anteil_delta_v_ht (* delta_v_ht cosWLokal))		; AF - 	04-2012 gendert
	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_ht))
	

									; AF - Ende nderung

	(setq anteil_delta_v_ht (* delta_v_ht    sinW))	
	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_delta_v_ht))
	; ----------------------------------------------
    ))

	; ----------------------------------------------

	; Anteil delta_v Verschiebung AT
	; ----------------------------------------------
    (if (= 1 1)	(progn
	; ----------------------------------------------
	(setq delta_v_at (Traeger.get Tr_ID delta_v))
	; Sinus neu berechnen - Endwinkel des Profils wurde jetzt herangezogen
	(setq sinW (sin (* PI (/ EVWnkl_AT 180.0))))
	
	(if (/= sinW 0.0)
		(setq anteil_delta_v_at (/ (* 1.0 delta_v_at) sinW))
		(setq anteil_delta_v_at delta_v_at)
	)
	
	; AF - 08-2009 gendert - herauskommentiert ...

	; AF - 04-2012 komplett gendert - Winkeldefinition verbessert
	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_at))
	
	(print "nach der Berechnung - delta_V AT bercksichtigt...")
	(print delta_v_abtl_ht)
	; ----------------------------------------------
    ))
	; ----------------------------------------------
	

	; Anteil delta_lr Verschiebung AT
	; ----------------------------------------------
    (if (= 1 1)	(progn
	; ----------------------------------------------
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	(print delta_lr_at)
	(print sinW)
	
	(if (/= sinW 0.0)
		(setq anteil_delta_lr_at (/ delta_lr_at sinW))
		(setq anteil_delta_lr_at 0)
	)
	(setq anteil_delta_lr_at delta_lr_at)
	(print "Versuch 1") (print anteil_delta_lr_at)

	(if (= (Connect.get CastaData linkesEnde)  1) (setq AT_Ende   (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1) (setq AT_Ende   (Traeger.get Tr_ID rechts)))
	(setq VWinkel_E (TrEnde.get AT_Ende V_Winkel))
	(setq HWinkel_E (TrEnde.get AT_Ende H_Winkel))

	(setq cosW_EH (cos (* PI (/ (- HWinkel_E 90.0) 180.0))))
	(print HWinkel_E)
	(print cosW_EH)
	(if (/= cosW_EH 0.0)
		(setq anteil_delta_lr_at (/ delta_lr_at cosW_EH))
		(setq anteil_delta_lr_at 0)
	)
	(print "Versuch 2") (print anteil_delta_lr_at)
								; AF - 08-2009 Korrektur Beginn
;AF	(if (= (Connect.get CastaData vatr-vhtr) -1)
;		(progn
;			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_delta_lr_at)))
;			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_delta_lr_at)))
;		)
;	)
;	(if (= (Connect.get CastaData vatr-vhtr)  1)
;		(progn
;			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_delta_lr_at)))
;			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_delta_lr_at)))
;		)
;AF	)
								; AF - 08-2009 Korrektur Ende Herauskommentierung

	; AF - 04-2012 erneute Korrektur, weil der RWinkel-AT untersucht und ggflls. umgedreht wurde.
;	(setq delta_lr_abtl_ht 0.0)
	
	(if (= (Connect.get CastaData amHtStegLinks)  1) (progn
		(if (= (Connect.get CastaData rechtesEnde)  1) 	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_delta_lr_at)))
		(if (= (Connect.get CastaData linkesEnde)   1) 	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_delta_lr_at)))
	))
	(if (= (Connect.get CastaData amHtStegRechts)  1) (progn
		(if (= (Connect.get CastaData rechtesEnde)  1) 	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_delta_lr_at)))
		(if (= (Connect.get CastaData linkesEnde)   1) 	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_delta_lr_at)))
	))
								; AF - 03-2012 Korrektur Ende Einfgung
	; ----------------------------------------------
    ))
	; ----------------------------------------------
	

    (if (= 1 1) (progn
    	(setq rWinkel_Steg (Connect.get CastaData r-atrgewnkl_steg))
	(setq trRWinkel (Traeger.get Tr_ID R_Winkel))
	(setq rWinkel_Steg trRWinkel)

    	(setq sinWR (sin (* PI (/ rWinkel_Steg 180.0))))
    	(setq cosWR (cos (* PI (/ rWinkel_Steg 180.0))))

    	
    	(setq vAbtl_HT  delta_v_abtl_ht)
    	(setq lrAbtl_HT delta_lr_abtl_ht)

	(print vAbtl_HT)
	(print lrAbtl_HT)
	
;	(setq delta_v_abtl_ht  0.0)
;	(setq delta_lr_abtl_ht 0.0)

;	11-2012 Korrektur AF    - ganz wieder herausgenommen - Winkel wird vorher schon bercksichtigt.	
;	(setq delta_v_abtl_ht  (+ (* cosWR (+ vAbtl_HT)) (* sinWR (- lrAbtl_HT))))
;	(setq delta_v_abtl_ht  (+ (* sinWR (+ vAbtl_HT)) (* cosWR (- lrAbtl_HT))))


	(print  delta_v_abtl_ht)
	(print  delta_lr_abtl_ht)

	(print sinWR) (print cosWR)
    	
    ))
    ; Das muss jetzt hier erfolgen ...
    (setq delta_v_abtl_ht (- delta_v_abtl_ht vscherl_at_halb))


	
	(print "Werte, die endltig eingesetzt werden .............................................")
	(print  delta_v_abtl_ht)
	(print  delta_lr_abtl_ht)
	

	
	(Traeger.addAbtl Htrg Lochb_ID xPos_ht abtl_winkel_ht _steglochbild_system_)
	
	(setq lb_abtl_at (Traeger.get Tr_ID Abteil Lochb_ID))
	(setq lb_abtl_ht (Traeger.get Htrg Abteil Lochb_ID))
	
	(Anbauteil.set lb_abtl_at	(Master 	0)
					(delta_v 	delta_v_abtl_at)
	)
	(Anbauteil.set lb_abtl_ht	(Master 	1)
					(delta_v 	delta_v_abtl_ht)
					(delta_lr	delta_lr_abtl_ht)
	)

	; AF - 04-2012 -	Fr asymmetrische Lochbilder Richtung anpassen
	;			Bei Gegenanschlssen aber kritisch - nochmal berarbeiten
	(if (= (Connect.get CastaData amHTStegLinks) 1) (progn
	        (if (= (Connect.get CastaData RechtesEnde) 1) (progn
			(Anbauteil.set lb_abtl_ht	(SeitRicht 	-1))
	        ))
	))
	(if (= (Connect.get CastaData amHTStegRechts) 1) (progn
	        (if (= (Connect.get CastaData LinkesEnde) 1) (progn
			(Anbauteil.set lb_abtl_ht	(SeitRicht 	-1))
	        ))
	))

	
	
	(if (= qsform_ht "K") (progn
	    (setq abst_Achse (Traeger.get HTrg b)
	          abst_Achse (/ abst_Achse 2.0)
	    )
	    (if (= (Connect.get CastaData amHTStegLinks) 1) (setq abst_Achse (- abst_Achse)))
	    (Anbauteil.set lb_abtl_ht	(delta_sx 	abst_Achse)
	    				(Master 	0)
	    )
	    (Anbauteil.set lb_abtl_at	(Master 	1))
	    (Lochbild.set Lochb_ID 	(dxsKopf	0))
	))
	    
	
	; LOCHBILD-TEST
	; --------------------------------------------------------------------------------------
	(if (= LB_DEBUG 1)
		(progn
			
			(setq lbdummy (Lochbild.create))
			(Lochbild.copy lbdummy Lochb_ID)
			
			(if (= (connect.get CastaData LinkesEnde) 1) (traeger.addabtl Tr_ID lbdummy 0.0 0.0 _kpllochbildlinks_))
			(if (= (connect.get CastaData RechtesEnde) 1) (traeger.addabtl Tr_ID lbdummy 0.0 0.0 _kpllochbildrechts_))
			
			(setq abtl_lb_at_dummy (Traeger.get Tr_ID Abteil lbdummy))
			(Anbauteil.set abtl_lb_at_dummy (Master 1)
							(delta_v delta_v_abtl_at)
			)
			
		)
	)
	; --------------------------------------------------------------------------------------
	

	(print "<-----------------------------------------------------------")	
)





; ----------------------------------------------------------------------------------------
; Verlngert bzw. Verkrzt das Sttzenende
; ----------------------------------------------------------------------------------------
(defun korrigiereStzEnde ()
	(print ">-----------------------------------------------------------")
	(print "KORRIGIERE STZ-ENDE")
	(print "------------------------------------------------------------")

	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(progn
			(setq delta_l_stz (- rand))
			(setq HT_Ende (Traeger.get Htrg links))
		)
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(progn
			(setq delta_l_stz (- rand))
			(setq HT_Ende (Traeger.get Htrg rechts))
		)
	)


	(setq delta_lr (Traeger.get Tr_ID delta_lr))
	(setq bp       (Blech.get   kpl_blech   bp))
	(if (= (Connect.get CastaData sATr-lHTr) -1) (progn
	      (setq delta_L_UZ (- (* 0.5 bp) delta_lr))
	      (print delta_L_UZ)
	      (TrEnde.set HT_Ende (delta_l (- delta_L_UZ)))
	))
	(if (= (Connect.get CastaData sATr-lHTr)  1) (progn
	      (setq delta_L_UZ (+ (* 0.5 bp) delta_lr))
	      (print delta_L_UZ)
	      (TrEnde.set HT_Ende (delta_l (- delta_L_UZ)))
	))


	
	(if (= (Connect.get CastaData sATr-lHTr) 0) (progn
		(setq delta_l_alt (TrEnde.get Ht_Ende delta_l))
		(print delta_l_alt)
		(print rand)
	
		(setq delta_l_stz (- delta_l_alt rand))
	
		(TrEnde.set HT_Ende (delta_l delta_l_stz))
	))
	(print "<-----------------------------------------------------------")	
)

; ----------------------------------------------------------------------------------------
; bernimmt das gegenberliegende Lochbild
; ----------------------------------------------------------------------------------------
(defun getExistingLochbild ()
; ---------------------------------------------------------------------
	(setq copyMode (Connect.get CastaData CopyMode))

(if (= copyMode 0)
(alertBox "
Auf der gegenberliegenden Seite ist bereits ein Anschluss vorhanden.\n
Nehmen Sie nderungen ggf. manuell vor.\n
\n
Kontrollieren Sie bitte auch den Rotationswinkel der anschlieenden Trger!\n
Unterschiedliche Rotationswinkel fhren zu fehlerhaften Werkstattzeichnungen.
"
"NOTE_OppositeConnectionFound_RotAngle")
)
; ---------------------------------------------------------------------
	
	(print ">-----------------------------------------------------------")
	(print "BERNEHME LOCHBILD")
	
	(setq dp_kpl (Blech.get kpl_blech dp))
	(print dp_kpl)

	(setq delta_w (Lochbild.get kpl_lochbild delta_w))
	(if (/= delta_w 0) (progn
		 (if (= copyMode 0)
	         (alertBox "
Bei diesem Gegenanschluss liegt bereits ein asymmetrisches Lochbild vor.\nLochbild wird symmetrisch gestaltet.\n
\n
Bitte korrigieren Sie ggflls. die Kopfplatten an den Trgerenden der beiden Anschlsse!
"
"NOTE_OppositeSideConnection_symmetrical_Holepattern")
         )
	     (Lochbild.set lchbBlech (delta_w 0))
	))
			
	(setq klemml_alt 	(Lochbild.get kpl_lochbild klemml))
	(setq dxskopf_alt	(Lochbild.get kpl_lochbild dxsKopf))
	(print klemml_alt)
	(print dxskopf_alt)
			
	(setq klemml_neu 	(+ klemml_alt dp_kpl))
	(setq dxskopf_neu (+ dxskopf_alt dp_kpl))
	(print klemml_neu)
	(print dxskopf_neu)
			
	(Lochbild.set kpl_lochbild (klemml klemml_neu))									
				
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(Lochbild.set kpl_lochbild (dxsKopf dxskopf_neu))
	)
	
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(traeger.addabtl tr_id kpl_lochbild 0.0 0.0 _kpllochbildrechts_)
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
		(traeger.addabtl tr_id kpl_lochbild 0.0 0.0 _kpllochbildlinks_)
	)
			
			
	(setq	delta_v_at 	(Traeger.get Tr_ID delta_v)
		delta_v_ht 	(Traeger.get HTrg  delta_v)
		delta_lt_at	(traeger.get Tr_ID delta_lr)
	)
			
	(setq loch_at_abtl (Traeger.get Tr_ID Abteil kpl_lochbild))
	(setq loch_ht_abtl (Traeger.get Htrg  Abteil kpl_lochbild))	  
	
	(setq	delta_v_abtl_ht 	(Anbauteil.get loch_ht_abtl delta_v)
		delta_lr_abtl_ht	(Anbauteil.get loch_ht_abtl delta_lr)
		h_ht			(Traeger.get Htrg h)
	)

	(setq	delta_v_abtl_at 	(Anbauteil.get loch_at_abtl delta_v)
		delta_lr_abtl_at	(Anbauteil.get loch_at_abtl delta_lr)
		h_at			(Traeger.get Tr_ID h)
	)

	(setq	delta_v_gesamt (- (* 0.5 h_at) delta_v_at (- delta_v_ht)))
	(print	delta_v_gesamt)

	(print delta_v_abtl_at)
	(print delta_lr_abtl_at)
	(print delta_v_at)
	(print delta_v_abtl_ht)
	(print delta_lr_abtl_ht)
	
;	(setq delta_v_abtl_at_neu (- (- delta_v_at) delta_v_abtl_ht))
	(setq delta_v_abtl_at_neu (+ delta_v_gesamt delta_v_abtl_ht))
	(setq delta_v_vorhanden 0.0)

;	Korrektur Feb.2011 (AF)
;	kompletter neuer Abschnitt	
	(setq ABTeilVorhanden (Traeger.get Htrg ABTeil kpl_lochbild))
	
	(if ABTeilVorhanden 
		(progn
			(print "Anbauteil am Haupttrger gefunden.")
			; Vorbereitung Korrektur - Feb.2011 
			; Es gibt leider zwei verschiedene Steglochbildtypen
			; eines ist auf die Systemachse bezogen, das andere auf die OK des Trgers (hier des HT)
			; deswegen muss noch in einem Fall die halbe Hhe des HT bercksichtigt werden.
			(setq Steg_LB 	  131072)	; auf OK bezogen
			(setq Steg_LB_Sys 33554432)	; auf Achse bezogen (nur zur Verdeutlichung)

			(setq isType_1 (Anbauteil.get ABTeilVorhanden is_type Steg_LB))
			(setq isType_2 (Anbauteil.get ABTeilVorhanden is_type Steg_LB_Sys))

			(setq delta_v_vorhanden (Anbauteil.get ABTeilVorhanden delta_v))
			(print delta_v_vorhanden)
			
			(setq winkel_ht_lb_abtl (Anbauteil.get ABTeilVorhanden winkel))
			(setq 	r_wkl_steg	(Connect.get CastaData r-atrgewnkl_steg))
			
			(setq WinkelDiff (- winkel_ht_lb_abtl r_wkl_steg))
			(while (< WinkelDiff 0.0) (setq WinkelDiff (+ WinkelDiff 360.0)))
			
			(setq xPos_Abtl (Anbauteil.get ABTeilVorhanden xPos))
			(setq xPos_HT   (Connect.get CastaData xPos_HT))

			(setq wRes (- 180.0 winkel_ht_lb_abtl))
			(setq radWRes (* PI (/ wRes 180.0)))
			(setq cosWRes (cos radWRes))
			
; 			--------------------------------------------
;	-	-	korrigiert Feb. 2011 - (AF)
;			korrigiert Aug. 2013 - (AF)  Konstellation HT auf dem Kopf
			(if (> (Connect.get CastaData vAtr-vHtr) 0) (progn
				(setq delta_v_gesamt (+ (* 0.5 h_at) delta_v_vorhanden))
				(setq delta_v_gesamt (+ delta_v_gesamt delta_v_ht))
				(setq delta_v_gesamt (- delta_v_gesamt delta_v_at))
				
				(if (= isType_1 1) (setq delta_v_gesamt (- delta_v_gesamt (* 0.5 h_HT))))
			    )
			    (progn
				(setq delta_v_gesamt (- (* 0.5 h_at) delta_v_vorhanden))
				(setq delta_v_gesamt (- delta_v_gesamt delta_v_ht))
				(setq delta_v_gesamt (- delta_v_gesamt delta_v_at))
			
				(if (= isType_1 1) (setq delta_v_gesamt (+ delta_v_gesamt (* 0.5 h_HT))))
			))
;			(setq delta_v_gesamt (* cosWRes delta_v_gesamt))
			
;			Ende Korrektur
		)
	)
	
	
	(setq	dlr_AT	(Traeger.get TR_ID delta_LR)
		dv_AT	(Traeger.get TR_ID delta_V)
	)
	
	
	(setq delta_lr_abtl_AT 0.0)
	(if (= (Connect.get CastaData sAtr-lHtr) -1) (setq delta_lr_abtl_AT (+ dlr_AT delta_lr_abtl_HT)))
	(if (= (Connect.get CastaData sAtr-lHtr)  1) (setq delta_lr_abtl_AT (- dlr_AT delta_lr_abtl_HT)))

	(setq delta_V_abtl_AT 0.0)
        (setq h_AT_Halbe (* 0.5 h_at))
	(if (= (Connect.get CastaData vAtr-vHtr) 0) (progn
	    (if (= (Connect.get CastaData vAtr-lHtr) -1) (setq delta_V_abtl_AT (+ (+ delta_v_vorhanden h_AT_Halbe) dv_AT)))
	    (if (= (Connect.get CastaData vAtr-lHtr)  1) (setq delta_V_abtl_AT (+ (+ delta_v_vorhanden h_AT_Halbe) dv_AT)))
	))

	(setq delta_lr_abtl_AT 0.0)

	(Anbauteil.set loch_at_abtl (Master 	0)
		(delta_v 	delta_V_abtl_AT)
		(delta_lr 	delta_lr_abtl_AT)
	)				
	
	(print "<-----------------------------------------------------------")				
)


; ---------------------------------------------------------------------------------
; Korrigiert das Traegerende des AT
; ---------------------------------------------------------------------------------
(defun korrAtEnde (abst)
	; Abstnde zum Ht korrigieren
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID rechts))
	)
	
	(setq s_ht			(Traeger.get Htrg s)
				qsform_ht	(Traeger.get Htrg qsform)
	)
	
	
	
	(TrEnde.ptrim AtEnde (- abst))
			
	
)


; ----------------------------------------------------------------------------------------
; berprft, ob der Anschluss in der bestehenden Positionierung eingebaut werden kann
; ----------------------------------------------------------------------------------------
(defun checkPosition (Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "BERPRFE POSITION")
	
	(setq Warn_BlechAusrundKoll 0)
	; Oberkante HT
	(setq h_ht 				(Traeger.get Htrg h)
				r_ht				(Traeger.get Htrg r)
				t_ht				(Traeger.get Htrg t)
				s_HT		(Traeger.get Htrg s)
				hc_ht				(Traeger.get Htrg hc)
				delta_v_ht	(Traeger.get Htrg delta_v)
	)
	(setq h_ht_halb	(* 0.5 h_ht))
	
	(setq qsform_ht	(Traeger.get HTrg qsform))
	(if (= qsform_ht "Z") (progn
		; Wenn s und t gleich sind, dann ist es ein Kantprofil
		(if (= t_HT s_HT) (progn
			(setq r_ht 0)
			(setq hc_ht (- h_ht t_ht t_ht))
		))
	))

	(if (<= hc_ht 0.0) (progn
		(setq hc_ht (- h_ht t_ht t_ht))
	))
	
	(setq h_at 				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	(setq h_at_halb	(* 0.5 h_at))
	
	(setq kpl_hp			(Blech.get Blech_ID hp)
				kpl_bp			(Blech.get Blech_ID bp)
	)
	(setq kpl_hp_halb	(* 0.5 kpl_hp))
	(setq kpl_bp_halb	(* 0.5 kpl_bp))
	
	
	(setq oGrenze_ht (- delta_v_ht (- h_ht_halb r_ht t_ht)))
	(setq uGrenze_ht (+ oGrenze_ht hc_ht))
	(if (= hc_ht 0) (setq uGrenze_ht (+ oGrenze_ht (- h_ht t t))))
	(print oGrenze_ht)
	(print uGrenze_ht)
	
	(if (= (Connect.get CastaData satr-vhtr)  1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)
				(progn
					(setq oGrenze_kpl	(- delta_lr_at kpl_bp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_bp))
				)
			)
			(if (= (Connect.get CastaData vatr-lhtr) -1)
				(progn
					(setq oGrenze_kpl	(- delta_lr_at kpl_bp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_bp))
				)
			)
		)
	)
	(if (= (Connect.get CastaData satr-vhtr) -1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)
				(progn
					(setq oGrenze_kpl	(- (- delta_lr_at) kpl_bp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_bp))
				)
			)
			(if (= (Connect.get CastaData vatr-lhtr) -1)
				(progn
					(setq oGrenze_kpl	(- (- delta_lr_at) kpl_bp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_bp))
				)
			)
		)
	)
	
	(if (= (Connect.get CastaData vatr-vhtr)  1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)
				(progn
					(setq oGrenze_kpl	(- delta_v_at kpl_hp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_hp))
				)
			)
			(if (= (Connect.get CastaData satr-lhtr) -1)
				(progn
					(setq oGrenze_kpl	(- delta_v_at kpl_hp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_hp))
				)
			)
		)
	)
		(if (= (Connect.get CastaData vatr-vhtr) -1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)
				(progn
					(setq oGrenze_kpl	(- (- delta_v_at) kpl_hp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_hp))
				)
			)
			(if (= (Connect.get CastaData satr-lhtr) -1)
				(progn
					(setq oGrenze_kpl	(- (- delta_v_at) kpl_hp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_hp))
				)
			)
		)
	)
	(print oGrenze_kpl)
	(print uGrenze_kpl)
	
	(if (>= oGrenze_kpl oGrenze_ht)
		(progn
			(if (<= uGrenze_kpl uGrenze_ht)
				(progn
					(print "OK")
				)
				(progn
					(setq Warn_BlechAusrundKoll 1)
				)
			)
		)
		(progn
			(setq Warn_BlechAusrundKoll 2)
		)
	)
	
	(print "<-----------------------------------------------------------")
)

(defun	AnschlussWinkel ()
	

	(setq ABTeilVorhanden 	(Traeger.get Htrg ABTeil kpl_lochbild))
	(setq Trg_Gegen_Anschl  (Connect.get CastaData   trg_steg_gegen))
	
	(setq isKplLchbLi 0  isKplLchbRe 0)
	
	(if Trg_Gegen_Anschl (progn
	   (setq AbtlLchbGegen (Traeger.get Trg_Gegen_Anschl ABTeil kpl_lochbild))
	   (if AbtlLchbGegen (progn
	   	(setq isKplLchbLi (Anbauteil.get AbtlLchbGegen is_type _kpllochbildlinks_))
	   	(setq isKplLchbRe (Anbauteil.get AbtlLchbGegen is_type _kpllochbildrechts_))
	   ))
	))
	(setq WinkelPasst 0)
	(if ABTeilVorhanden (progn
		(setq	eHT_Lchb_Winkel (Anbauteil.get ABTeilVorhanden Winkel)
			sri_Lchb_Vorh	(Anbauteil.get ABTeilVorhanden SeitRicht)

		)
		(setq	AT_Winkel (Connect.get CastaData  r-atrgewnkl_steg))

			(print "Winkel zu Beginn -------------")
			(print eHT_Lchb_Winkel)
			(print AT_Winkel)

;			(if (= sri_Lchb_Vorh -1) (setq eHT_Lchb_Winkel (- 180.0 eHT_Lchb_Winkel)))
			(setq LochbildWinkel_Plus_180 0)

		; Trgerrichtung bestimmen - gleichlufig oder gegenlufig
		(setq TrgRichtung_ATs 0)
		(setq GleichLaeufig 1)
		(setq GegenLaeufig  2)

	        (print isKplLchbLi)
	        (print isKplLchbRe)

		(if (= (Connect.get CastaData linkesEnde)  1) (progn
		    (print "linkes Ende")
		    (if (= isKplLchbLi 1) (setq TrgRichtung_ATs GegenLaeufig))
		    (if (= isKplLchbRe 1) (setq TrgRichtung_ATs GleichLaeufig))
		))
		(if (= (Connect.get CastaData rechtesEnde) 1) (progn
		    (print "rechtes Ende")
		    (if (= isKplLchbLi 1) (setq TrgRichtung_ATs GleichLaeufig))
		    (if (= isKplLchbRe 1) (setq TrgRichtung_ATs GegenLaeufig))
		))


		(if (= (Connect.get CastaData at-von-links)  1) (print "at-von-links  ------"))
		(if (= (Connect.get CastaData at-von-rechts) 1) (print "at-von-rechts ------"))

		
		(if (>= eHT_Lchb_Winkel 360.0) (setq eHT_Lchb_Winkel (- eHT_Lchb_Winkel 360.0)))
		
		(setq resWinkel (- eHT_Lchb_Winkel))
		(if (= (Connect.get CastaData at-von-rechts) 1) 
			(setq resWinkel (- eHT_Lchb_Winkel 180.0))
		)


		(setq diffWnkl (- AT_Winkel resWinkel))
		(print diffWnkl)
		(if (> diffWnkl  359.9) (setq diffWnkl (- diffWnkl 360.0)))
		(if (< diffWnkl -359.9) (setq diffWnkl (+ diffWnkl 360.0)))

			(print "Winkel korrigiert -------------")
			(print eHT_Lchb_Winkel)
			(print AT_Winkel)
			(print "Differenzwinkel -------------")
			(print resWinkel)
			(print diffWnkl)
		
		(if (< diffWnkl 0.1) (progn (if (> diffWnkl -0.1) (setq WinkelPasst 1))))
		
		(if (= WinkelPasst 0) (progn
		     (if (< diffWnkl 0.0)   (setq diffWnkl (+ diffWnkl 360.0)))
		     (if (< diffWnkl 180.1) (progn (if (> diffWnkl 179.9) (setq WinkelPasst 2))))
		))
	))

)


(defun moveExistingLochbild ()
;	Korrektur Nov.2014 (AF)
;	kompletter neuer Abschnitt	

	(setq ABTeilVorhanden 	(Traeger.get Htrg ABTeil kpl_lochbild))
	(setq loch_at_abtl 	(Traeger.get Tr_ID Abteil kpl_lochbild))
	(setq loch_ht_abtl 	(Traeger.get Htrg  Abteil kpl_lochbild))	  


	(AnschlussWinkel)	; bestimmt Flag namen WinkelPasst
	(if (= WinkelPasst 0) 	(print "Winkel passt NICHT !!!"))
	(if (= WinkelPasst 1) 	(print "Winkel passt"))
	(if (= WinkelPasst 2) 	(print "Winkel passt, aber Vertikalrichtung tauschen"))


	(setq 	dv_AT 	(Traeger.get Tr_ID delta_V)
		dlr_AT	(Traeger.get Tr_ID delta_LR)
		h_AT	(Traeger.get Tr_ID h)
	)
	(setq	dv_Lchb_Vorh	(Anbauteil.get ABTeilVorhanden delta_V)
		dlr_Lchb_Vorh	(Anbauteil.get ABTeilVorhanden delta_LR)
		sri_Lchb_Vorh	(Anbauteil.get ABTeilVorhanden SeitRicht)
	)

	(print dv_Lchb_Vorh)
	(print dlr_Lchb_Vorh)
	(print sri_Lchb_Vorh)

	(setq rWnkl 0.0)	; zur Sicherheit ...
	(setq AbtlLchb_HT 	(Traeger.get Htrg ABTeil kpl_lochbild))
	(if AbtlLchb_HT (progn
		(setq rWnkl (Anbauteil.get AbtlLchb_HT Winkel))
	))


	(if (= (Connect.get CastaData linkesEnde)  1) (setq AT_Ende   (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1) (setq AT_Ende   (Traeger.get Tr_ID rechts)))
	(setq HWinkel_E (TrEnde.get AT_Ende H_Winkel))
	(setq cosWnkl (cos (/ (* PI (- HWinkel_E 90.0)) 180.0)))
	(print dlr_AT)
	(setq dlr_AT (* 1.0 dlr_AT cosWnkl))
	(print dlr_AT)

	(if (= WinkelPasst 0) (AlertBox "Winkel passt nicht" "ERR_Angle_Not_Possible"))

	(if (> WinkelPasst 0) 	(progn
		(print "Im Bereich Winkel passt (1)")
		
		(setq sri_Lchb_AT 0)

		; Seitenrichtung festlegen	UND
		; Horizontalversatz festlegen
		(print dlr_Lchb_Vorh)
		(setq dLR_Lchb_AT (+ dlr_AT dlr_Lchb_Vorh))
		(if (= (Connect.get CastaData amHtStegLinks) 1) (progn
		    	(print "am HT Steg links")
			(if (= (Connect.get CastaData linkesEnde) 1) (progn
				(print "linkesEnde  am HT-Steg-links")
				(if (=  sri_Lchb_Vorh -1) (setq sri_Lchb_AT -1))  ; OK
				(if (>= sri_Lchb_Vorh  0) (setq sri_Lchb_AT  1))  ; OK

				(setq dLR_Lchb_AT (- dlr_AT dlr_Lchb_Vorh))	  ; OK
			))
			(if (= (Connect.get CastaData rechtesEnde) 1) (progn
				(print "rechtesEnde am HT-Steg-links")
				(if (=  sri_Lchb_Vorh -1) (setq sri_Lchb_AT  1))
				(if (>= sri_Lchb_Vorh  0) (setq sri_Lchb_AT -1))

				(setq dLR_Lchb_AT (- (+ dlr_AT dlr_Lchb_Vorh)))	  ; OK	(neu)
			))
		))
		(if (= (Connect.get CastaData amHtStegRechts) 1) (progn
			(if (= (Connect.get CastaData linkesEnde) 1) (progn
				(print "linkesEnde  am HT-Steg-rechts")
				(if (=  sri_Lchb_Vorh -1) (setq sri_Lchb_AT  1))
				(if (>= sri_Lchb_Vorh  0) (setq sri_Lchb_AT -1))
				
				(setq dLR_Lchb_AT (- (+ dlr_AT dlr_Lchb_Vorh)))	  ; OK  (neu)
			))
			(if (= (Connect.get CastaData rechtesEnde) 1) (progn
				(print "rechtesEnde am HT-Steg-rechts")
				(if (=  sri_Lchb_Vorh -1) (setq sri_Lchb_AT -1))  ; OK
				(if (>= sri_Lchb_Vorh  0) (setq sri_Lchb_AT  1))  ; OK

				(setq dLR_Lchb_AT (- dlr_AT dlr_Lchb_Vorh))	  ; OK
			))
		))
		
		; Vertikalversatz des HT
		(setq dv_HT (Traeger.get HTrg delta_V))
		
		
		; Vertikalversatz festlegen
		(setq dV_Lchb_AT  (+ dv_Lchb_Vorh (* 0.5 h_AT) (- dv_AT)))
		(setq sinRWnkl (sin (/ (* PI  rWnkl) 180.0)))
		(setq cosRWnkl (cos (/ (* PI  rWnkl) 180.0)))
		
		(setq dv_Antl_HT  (* sinRWnkl dv_HT))
		(setq dlr_Antl_HT (* cosRWnkl dv_HT))
		
		; durch den Winkel wird der Vertikalversatz horizontal und vertikal aufgeteilt.
		; der Winkel wurde oben ber die Lage des Lochbilds gewonnen.
		(setq dV_Lchb_AT  (- dV_Lchb_AT dv_Antl_HT))
		(setq dLR_Lchb_AT (+ dLR_Lchb_AT dlr_Antl_HT))

		(Anbauteil.set loch_at_abtl 
			(delta_V 	dv_Lchb_AT)
			(delta_LR	dLR_Lchb_AT)
			(SeitRicht	sri_Lchb_AT)
		)
	
	))

)

(defun korrigiereBlechAbmessungen ()
	(setq hp_Kpl    (Blech.get kpl_blech hp) 
		  dOK_Kpl   (Blech.get kpl_blech dOK) 
 		  bp_Kpl    (Blech.get kpl_blech bp) 
		  h_AT		(Traeger.get Tr_ID h)
	)
	(setq hDiff1 (- hp_Kpl h_AT))

	(if (> hDiff1 0) (progn
		(setq  hp_Kpl  (- hp_Kpl  (* 0.5 hDiff1)))
		(setq  dOK_Kpl (+ dOK_Kpl (* 0.25 hDiff1)))

		(Blech.set kpl_blech (dOK dOK_Kpl) (hp hp_Kpl)) 
		(checkPosition kpl_blech)
	))
	(if (> Warn_BlechAusrundKoll 0) (progn
		(setq hDiff1 (- hp_Kpl h_AT))
		(if (> hDiff1 0) (progn
			(setq  hp_Kpl  (- hp_Kpl  (* 0.5 hDiff1)))
			(setq  dOK_Kpl (+ dOK_Kpl (* 0.25 hDiff1)))
			
			(Blech.set kpl_blech (dOK dOK_Kpl) (hp hp_Kpl)) 
			(checkPosition kpl_blech)
		))
	))
	(if (> Warn_BlechAusrundKoll 0) (progn
		(setq hDiff1 (- hp_Kpl h_AT))
		(if (> hDiff1 0) (progn
			(setq  hp_Kpl  (- hp_Kpl  hDiff1))
			(setq  dOK_Kpl (+ dOK_Kpl (* 0.5 hDiff1)))
			
			(Blech.set kpl_blech (dOK dOK_Kpl) (hp hp_Kpl)) 
			(checkPosition kpl_blech)
		))
	))
)
(defun korrigiereSchraubenPositionen ()
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID rechts)))
	
	(setq	vscherl_at	(TrEnde.get AT_Ende vscherl)
		    hscherl_at	(TrEnde.get AT_Ende hscherl)
	)
	(setq dSchr    (Lochbild.get kpl_lochbild sDurchm)
	      LchSpiel (Lochbild.get kpl_lochbild blspiel)
		  vAbstMin (* 2 (+ dSchr LchSpiel))
	)
	(setq hp_Kpl    (Blech.get kpl_blech hp)
		  dOK_Kpl   (Blech.get kpl_blech dOK)
		  bp_Kpl    (Blech.get kpl_blech bp)
	)

	(setq e0_neu (+ vAbstMin dOK_Kpl))
	(setq e1_neu (- hp_Kpl vAbstMin vAbstMin))
	
	(Lochbild.set kpl_lochbild (e0 e0_neu) (e1 e1_neu))
	
	(setq qsform_at	(Traeger.get Tr_ID qsform))
	(if (= qsform_at "K") (progn
		(setq w0_vorh (Lochbild.get kpl_lochbild w0))
		(setq min_BP (+ hscherl_at (* 8.0 (+ dSchr LchSpiel))))
		(if (> min_BP bp_Kpl) (progn
			(setq bp_Neu (+ hscherl_at (* 6.0 (+ dSchr LchSpiel))))
			(setq w0_Neu (+ hscherl_at (* 4.0 (+ dSchr LchSpiel))))
			(Blech.set kpl_blech (bp min_BP))
			(Lochbild.set kpl_lochbild (w0 w0_Neu))
		))
	))
	

)


(defun createKonterPlate ()
	(if (= (Connect.get CastaData exist_steglchb) 0) (progn
		(setq konterPlate (Blech.create))
		(setq dp (Blech.get kpl_Blech dp)
			  hp (Blech.get kpl_Blech hp)
			  bp (Blech.get kpl_Blech bp)
		)
		(Blech.set konterPlate (dp dp) (hp hp) (bp bp))
		
		(Connect.storeAnschlObjs CastaData konterPlate)
		
		(setq KlemmLng    (Lochbild.get kpl_lochbild Klemml)
			  currDXSKopf (Lochbild.get kpl_lochbild dxSKopf)
		)
		(Lochbild.set kpl_lochbild (Klemml (+ KlemmLng dp)))
		
		(setq qsform_at	(Traeger.get Tr_ID qsform))
		(setq rWnkl 0.0)
		(if (= qsform_at "L") (setq rWnkl 90.0))
		
		(if (= (Connect.get CastaData amhtsteglinks) 1) (progn
			(Traeger.addAbtl HTrg konterPlate xPos_HT rWnkl _lasche_steg_re_)
		))
		(if (= (Connect.get CastaData amhtstegrechts) 1) (progn
			(Traeger.addAbtl HTrg konterPlate xPos_HT rWnkl _lasche_steg_li_)
			(Lochbild.set kpl_lochbild (dxSKopf (+ currDXSKopf dp)))
		))
		
	    (Blech.set konterPlate (formFkt "cb_konterplate"))

	))
)
