(defun load-modules ()
   (load "mod-endinit-vertikalStoss")
)


(defun init-connection ()

  (print "in init-connection - uz_uz_kpl_stoss bndige Kopfplatte");

;  (connect.ShowAttributes CastaData)

  (init-traegerenden)				; hier werden die Traegerenden gestutzt
						; eventuell spter alte Werte merken,
						; falls Ende schon bearbeitet wurde.


(if (= 1 1)
	(progn
; ---------- Kopfplatten und Lochbild hinzufgen
    (setq kplLochbild (Lochbild.create))
    (setq kplHtrg     (Blech.create))
    (setq kplTrg      (Blech.create))
    
    (Connect.storeAnschlObjs CastaData kplLochbild kplHtrg kplTrg)
    (calcAndSetLochbildDaten_1 kplLochbild kplHtrg kplTrg)
    
    (if (= (connect.get CastaData linkesEnde) 1)
        (createBuendigeKpl Tr_ID kplTrg kplLochbild 20 15 1)
    )
    (if (= (connect.get CastaData rechtesEnde) 1)
        (createBuendigeKpl Tr_ID kplTrg kplLochbild 20 15 -1)
    )

    (if (= (connect.get CastaData anHtLinkesEnde) 1) 
        (createBuendigeKpl HTrg kplHTrg kplLochbild 20 15  1)
    )
    (if (= (connect.get CastaData anHtRechtesEnde) 1) 
        (createBuendigeKpl HTrg kplHTrg kplLochbild 20 15 -1)
    )

    (Lochbild.set kplLochbild (dOK - 20))
    
    ;; **AFKorrektur**
    ; ** neu Januar 2006 **
    ; -- Master setzen - und zwar fr das Anbauteil, das das Kopfplattenlochbild
    ; am Haupttrger enthlt. Nur, wenn Kopfplattensto vorhanden
    (setq Abtl_KplLchb (traeger.get Htrg ABTeil kplLochbild))
    (Anbauteil.set Abtl_KplLchb (Master 1))

    ;; **AFKorrektur**    -- Klemmlnge fehlte
    (setq dp1 (Blech.get kplHtrg dp)
              dp2 (Blech.get kplTrg  dp)
    )
    (Lochbild.set kplLochbild (Klemml (+ dp1 dp2)))

   (setq dOK_HT (Blech.get kplHTrg dOK)
         dOK_AT (Blech.get kplTrg dOK)
   )
   (print "---------------------- Augabe dOK der Kopfplatten -----------")
   (print dOK_HT)
   (print dOK_AT)
    
  	(kopfplCorrection)
  	
  	(setq dok_HT (Blech.get kplHTrg dok))
  	(print dok_HT)
  )
)

  ; ----------- dOK der Kopfplatten ausgeben
   (setq dOK_HT (Blech.get kplHTrg dOK)
         dOK_AT (Blech.get kplTrg dOK)
   )
   (print "---------------------- Augabe dOK der Kopfplatten -----------")
   (print dOK_HT)
   (print dOK_AT)

)
; ---------------------------------------------------------------------- 
(defun createBuendigeKpl (Trg blKopfpl lchbKpl dp ueb li_re)
    (if (= li_re  1) (setq TrgEnde (Traeger.get Trg links)))
    (if (= li_re -1) (setq TrgEnde (Traeger.get Trg rechts)))
    
    ;(setq ueb 5)	;; nur zum Testen - Kopfplattenposition zum Traeger
    
    (setq EWnkl  (TrEnde.get TrgEnde V_Winkel)
          alfa   (- EWnkl 90.0)
          hProf  (Traeger.get Trg h)
          cosW   (cos (* PI (/ alfa 180.0)))
          hNetto hProf
    )
    (if (/= cosW 0) (setq hNetto (/ hProf cosW)))

    (setq  hp     (+ hNetto ueb ueb))

		; Durchmesser ds der Schrauben
    (setq d_schraube (Lochbild.get lchbKpl sdurchm))
    
    (setq breite_kpl (* 8 d_schraube))
    
    (Blech.set blKopfpl
         (dp    dp)
         (bp    breite_kpl)
         (hp    hp)
         (dOK   (- ueb))
         ;(dOK   (- 40))
    )
    
    (if (= li_re  1) (traeger.addabtl Trg blKopfpl 0.0 0.0 _kopfplattelinks_))
    (if (= li_re -1) (traeger.addabtl Trg blKopfpl 0.0 0.0 _kopfplatterechts_))

    (if (= li_re  1) (traeger.addabtl Trg lchbKpl 0.0 0.0 _kpllochbildlinks_))
    (if (= li_re -1) (traeger.addabtl Trg lchbKpl 0.0 0.0 _kpllochbildrechts_))
   
    (TrEnde.pTrim TrgEnde dp)

)
; ---------------------------------------------------------------------- 
(defun calcAndSetLochbildDaten_1 (Lchb_ID BlechHT BlechAT)
	(Lochbild.set Lchb_ID 
		(S_Bez   "M20")
		(Guete   "4.6")
		(e       "-1 1 0 0 0 0")
;		(e       "60 60 0 0 0 0")
		(w       "80  0")
		
	)
	
	;(setq ueb 5)	;; nur zum Testen - Kopfplattenposition zum Traeger
	
	(setq viertel (* 0.25 h1))
	(setq e0 viertel )
	(print e0)
	(setq e1 (* 2 viertel))
	(print e1)
	
	(setq dp_blechHT (Blech.get BlechHT dp))
	(setq dp_blechAT (Blech.get BlechAT dp))
	(Lochbild.set Lchb_ID (e0 e0) (e1 e1) (klemml (+ dp_blechHT dp_blechaT)))
)
; ---------------------------------------------------------------------- 
(defun kopfplCorrection ()
	(print "------------------- in kopfplCorrection")
	
	; hier wird die Gre des kleineren Blechs an das grere Blech angepasst 
	(setq h_kplHtrg (Blech.get kplHtrg hp))
	(setq h_kplTrg (Blech.get kplTrg hp))
	
	(if (>= h_kplHtrg h_kplTrg)
		(progn 
			(Blech.set kplTrg (hp h_kplHtrg))
			(setq isHtrg 1)
		)
		(progn
			(Blech.set kplHtrg (hp h_kplTrg))
			(setq isHtrg 0)
		)
	)
	
	(setq delta_v_trg  (Traeger.get Tr_ID delta_v))
  (setq delta_v_htrg (Traeger.get Htrg delta_v))
	
	(setq rWinkel_at (Traeger.get Tr_ID r_winkel))
  (setq rWinkel_ht (Traeger.get Htrg  r_winkel))
  (print rWinkel_at)
  (print rWinkel_ht)
    	
  ; Kopfplatte am Haupttrger ist magebend
  ;---------------------------------------------------------------------------
	(if (= isHtrg 1) 
		(progn
			(print "Platte am HT ist magebend")
			(if (= (connect.get CastaData anHtLinkesEnde) 1)
				(progn 
					(print "HT links")
        	(setq htrg_trEnde (Traeger.get HTrg links))
        	
        	(setq EWnkl  (TrEnde.get htrg_trEnde V_Winkel)
        				alfa   (- EWnkl 90.0)
        				tanW   (tan (* PI (/ alfa 180.0)))
        				cosW   (cos (* PI (/ alfa 180.0)))
  				)
  				
  				(if (= (connect.get CastaData linkesEnde) 1)
    				(progn
    					(print "AT links") 
        			(setq trg_trEnde (Traeger.get Tr_ID links))
        			(if (= rWinkel_at 0.0)
        				(progn
        					(setq EWnkl_trg  (TrEnde.get trg_trEnde V_Winkel)
        								alfa_trg   (- EWnkl_trg 90.0)
        					)
  								(print EWnkl_trg)
  							)
  						)
  						(if (= rWinkel_at 180.0)
        				(progn
        					(setq EWnkl_trg  (TrEnde.get trg_trEnde V_Winkel)
        								alfa_trg   (- 90.0 EWnkl_trg)
        					)
  								(print EWnkl_trg)
  							)
  						)
        		)
    			)
    			(if (= (connect.get CastaData rechtesEnde) 1) 
    				(progn
    					(print "AT rechts")
        			(setq trg_trEnde (Traeger.get Tr_ID rechts))
        			(if (= rWinkel_at 0.0)
        				(progn
        					(setq EWnkl_trg  (TrEnde.get trg_trEnde V_Winkel)
        								alfa_trg   (- 90.0 EWnkl_trg)
        					)
  								(print EWnkl_trg)
  							)
  						)
  						(if (= rWinkel_at 180.0)
        				(progn
        					(setq EWnkl_trg  (TrEnde.get trg_trEnde V_Winkel)
        								alfa_trg   (- EWnkl_trg 90.0)
        					)
  								(print EWnkl_trg)
  							)
  						)
        		)
    			)
    			
    			(setq tanW_trg   (tan (* PI (/ alfa_trg 180.0)))
        				cosW_trg   (cos (* PI (/ alfa_trg 180.0)))
    			)
    			
    			(setq dv_trg (/ (- delta_v_trg) cosW_trg))
    			(setq dv_htrg (/ (- delta_v_htrg) cosW))
    			
    			(setq dp_kplHtrg  (Blech.get kplHtrg dp))
					(setq dok_kplHtrg (Blech.get kplHtrg dok))
			
					(setq htrg_h (Trende.get htrg_trEnde vscherl))
					(setq trg_h  (Trende.get trg_trEnde vscherl))
	
					(setq delta_th (- (* 0.5 htrg_h) (* 0.5 trg_h))); Unterschied Haupttrger u. Anschlusstrger
					(setq diff (* tanW dp_kplHtrg))
					(setq diff_trg (* tanW_trg dp_kplHtrg))
					(setq rest (- diff (- dok_kplHtrg)))
					(setq versatz (- delta_th rest (- diff_trg) dv_trg dv_htrg))
					
					(print versatz)
					;; **AFKorrektur**
					; am linken Ende des Anschlusstrgers wird, wenn delta_v != 0 ist
					; ein falscher Wert ausgerechnet
					; versatz bitte korrigieren
					;; ***************
					(Blech.set kplTrg (dOk (- versatz)))
        )
      )
      
      ; rechts am Haupttrger
    	(if (= (connect.get CastaData anHtRechtesEnde) 1) 
    		(progn
    			(print "HT rechts")
        	(setq htrg_trEnde (Traeger.get HTrg rechts))
        
        	(setq EWnkl  (TrEnde.get htrg_trEnde V_Winkel)
        				alfa   (- 90.0 EWnkl)
        				tanW   (tan (* PI (/ alfa 180.0)))
        				cosW   (cos (* PI (/ alfa 180.0)))
  				)
  				
  				(if (= (connect.get CastaData linkesEnde) 1)
    				(progn
    					(print "AT links") 
        			(setq trg_trEnde (Traeger.get Tr_ID links))
        			
        			(if (= rWinkel_at 0.0)
        				(progn
        					(setq EWnkl_trg  (TrEnde.get trg_trEnde V_Winkel)
        								alfa_trg   (- EWnkl_trg 90.0)
        								tanW_trg   (tan (* PI (/ alfa_trg 180.0)))
        								cosW_trg   (cos (* PI (/ alfa_trg 180.0)))
  								)
  								(print EWnkl_trg)
  							)
  						)
  						(if (= rWinkel_at 180.0)
        				(progn
        					(setq EWnkl_trg  (TrEnde.get trg_trEnde V_Winkel)
        								alfa_trg   (- 90.0 EWnkl_trg)
        								tanW_trg   (tan (* PI (/ alfa_trg 180.0)))
        								cosW_trg   (cos (* PI (/ alfa_trg 180.0)))
  								)
  								(print EWnkl_trg)
  							)
  						)
  						
        		)
    			)
    			(if (= (connect.get CastaData rechtesEnde) 1) 
    				(progn
    					(print "AT rechts")
        			(setq trg_trEnde (Traeger.get Tr_ID rechts))
        			
        			(if (= rWinkel_at 0.0)
        				(progn
        					(setq EWnkl_trg  (TrEnde.get trg_trEnde V_Winkel)
        								alfa_trg   (- 90.0 EWnkl_trg)
        								tanW_trg   (tan (* PI (/ alfa_trg 180.0)))
        								cosW_trg   (cos (* PI (/ alfa_trg 180.0)))
  								)
  							)
  						)
  						(if (= rWinkel_at 180.0)
        				(progn
        					(setq EWnkl_trg  (TrEnde.get trg_trEnde V_Winkel)
        								alfa_trg   (- EWnkl_trg 90.0)
        								tanW_trg   (tan (* PI (/ alfa_trg 180.0)))
        								cosW_trg   (cos (* PI (/ alfa_trg 180.0)))
  								)
  							)
  						)
        		)
    			)
    			
    			(print alfa_trg)
    			(setq dv_trg (/ (- delta_v_trg) cosW_trg))
    			(setq dv_htrg (/ (- delta_v_htrg) cosW))
    			
    			(setq dp_kplHtrg  (Blech.get kplHtrg dp))
					(setq dok_kplHtrg (Blech.get kplHtrg dok))
			
					(setq htrg_h (Trende.get htrg_trEnde vscherl))
					(setq trg_h  (Trende.get trg_trEnde vscherl))
					
					(setq delta_th (- (* 0.5 htrg_h) (* 0.5 trg_h))); Unterschied Haupttrger u. Anschlusstrger
					(setq diff (* tanW dp_kplHtrg))
					(setq diff_trg (* tanW_trg dp_kplHtrg))
					(setq rest (- diff (- dok_kplHtrg)))
					(setq versatz (- delta_th rest (- diff_trg) dv_trg (- dv_htrg)))
					(print versatz)	
					(Blech.set kplTrg (dOk (- versatz)))	
  			)
    	)	
    	
    	
    	(if (= rWinkel_ht 180.0)
    		(progn
    			(print "HT ist gedreht")
    			
    			(setq hp (Blech.get kplTrg hp))
    			(setq r (- hp trg_h (* 2 versatz) ))
    			(print versatz)
    			(print r)
    			(if (= rWinkel_at 0.0) (Blech.set kplTrg (dOk (- (- versatz) r))))
    		)
    	)
    	(if (= rWinkel_ht 0.0)
    		(progn
    			(print "HT ist NICHT gedreht")
    			
    			(setq hp (Blech.get kplTrg hp))
    			(setq r (- hp trg_h (* 2 versatz) ))
    			(print versatz)
    			(print r)
    			(if (= rWinkel_at 180.0) 
    				(progn
    					(print "AT ist gedreht")
    					(Blech.set kplTrg (dOk (- (- versatz) r)))
    				)
    			)
    		)
    	)
		)
	)
	
	; Kopfplatte am Anschlutrger ist magebend
	;------------------------------------------------------------------------------------------------
	(if (= isHTrg 0) 
		(progn
			(print "Platte am AT ist magebend")
			(if (= (connect.get CastaData linkesEnde) 1)
				(progn 
					(print "AT links")
        	(setq trg_trEnde (Traeger.get Tr_ID links))
        	
        	(setq EWnkl  (TrEnde.get trg_trEnde V_Winkel)
        				alfa   (- EWnkl 90.0)
        				tanW   (tan (* PI (/ alfa 180.0)))
        				cosW   (cos (* PI (/ alfa 180.0)))
  				)
  				
  				(if (= (connect.get CastaData anHTLinkesEnde) 1)
    				(progn
    					(print "HT liinks") 
        			(setq htrg_trEnde (Traeger.get Htrg links))
        			(setq EWnkl_htrg  (TrEnde.get htrg_trEnde V_Winkel)
        						alfa_htrg   (- EWnkl_htrg 90.0)
        						tanW_htrg   (tan (* PI (/ alfa_htrg 180.0)))
        						cosW_htrg   (cos (* PI (/ alfa_htrg 180.0)))
  						)
        		)
    			)
    			(if (= (connect.get CastaData anHTRechtesEnde) 1) 
    				(progn
    					(print "HT rechts")
        			(setq htrg_trEnde (Traeger.get Htrg rechts))
        			(setq EWnkl_htrg  (TrEnde.get htrg_trEnde V_Winkel)
        						alfa_htrg   (- 90.0 EWnkl_htrg)
        						tanW_htrg   (tan (* PI (/ alfa_htrg 180.0)))
        						cosW_htrg   (cos (* PI (/ alfa_htrg 180.0)))
  						)
        		)
    			)
    			
    			(setq dv_trg (/ (- delta_v_trg) cosW))
    			(setq dv_htrg (/ (- delta_v_htrg) cosW_htrg))
    			
    			(setq dp_kpltrg  (Blech.get kpltrg dp))
					(setq dok_kpltrg (Blech.get kpltrg dok))
			
					(setq htrg_h (Trende.get htrg_trEnde vscherl))
					(setq trg_h  (Trende.get trg_trEnde vscherl))
	
					(setq delta_th (- (* 0.5 trg_h) (* 0.5 htrg_h))); Unterschied Haupttrger u. Anschlusstrger
					(setq diff (* tanW dp_kpltrg))
					(setq diff_htrg (* tanW_htrg dp_kpltrg))
					(setq rest (- diff (- dok_kpltrg)))
					(setq versatz (- delta_th rest (- diff_htrg) (- dv_trg) dv_htrg))
						
					(Blech.set kplHtrg (dOk (- versatz)))
        )
      )
      
      (if (= (connect.get CastaData rechtesEnde) 1)
				(progn 
					(print "AT rechts")
        	(setq trg_trEnde (Traeger.get Tr_ID rechts))
        	
        	(setq EWnkl  (TrEnde.get trg_trEnde V_Winkel)
        				alfa   (- 90.0 EWnkl)
        				tanW   (tan (* PI (/ alfa 180.0)))
        				cosW   (cos (* PI (/ alfa 180.0)))
        				sinD	 (sin (* PI (/ EWnkl 180.0)))
  				)
  				
  				(if (= (connect.get CastaData anHTLinkesEnde) 1)
    				(progn
    					(print "HT links") 
        			(setq htrg_trEnde (Traeger.get Htrg links))
        			
        			  						
  						(if (= rWinkel_ht 0.0)
        				(progn
        					(setq EWnkl_htrg  (TrEnde.get htrg_trEnde V_Winkel)
        						alfa_htrg   (- EWnkl_htrg 90.0)
        						tanW_htrg   (tan (* PI (/ alfa_htrg 180.0)))
        						cosW_htrg   (cos (* PI (/ alfa_htrg 180.0)))
  								)
  							)
  						)
  						(if (= rWinkel_ht 180.0)
        				(progn
        					(setq EWnkl_htrg  (TrEnde.get htrg_trEnde V_Winkel)
        								alfa_htrg   (- 90.0 EWnkl_htrg )
        								tanW_htrg   (tan (* PI (/ alfa_htrg 180.0)))
        								cosW_htrg   (cos (* PI (/ alfa_htrg 180.0)))
  								)
  							)
  						)
  						
  						
        		)
    			)
    			(if (= (connect.get CastaData anHTRechtesEnde) 1) 
    				(progn
    					(print "HT rechts")
        			(setq htrg_trEnde (Traeger.get Htrg rechts))
        			(setq EWnkl_htrg  (TrEnde.get htrg_trEnde V_Winkel)
        						alfa_htrg   (- 90.0 EWnkl_htrg)
        						tanW_htrg   (tan (* PI (/ alfa_htrg 180.0)))
        						cosW_htrg   (cos (* PI (/ alfa_htrg 180.0)))
  						)
        		)
    			)
    			
    			(setq dv_trg (/ (- delta_v_trg) cosW))
    			(setq dv_htrg (/ (- delta_v_htrg) cosW_htrg))
    			
    			(setq dp_kpltrg  (Blech.get kpltrg dp))
					(setq dok_kpltrg (Blech.get kpltrg dok))
			
					(setq htrg_h (Trende.get htrg_trEnde vscherl))
					(setq trg_h  (Trende.get trg_trEnde vscherl))
					
					(setq delta_th (- (* 0.5 trg_h) (* 0.5 htrg_h))); Unterschied Haupttrger u. Anschlusstrger
					(setq diff (* tanW dp_kpltrg))
					(setq diff_htrg (* tanW_htrg dp_kpltrg))
					(setq rest (- diff (- dok_kpltrg)))
					(setq versatz (- delta_th rest (- diff_htrg) (- dv_trg) dv_htrg))
						
					(Blech.set kplHtrg (dOk (- versatz)))
	
        )
      )
      
      (setq rWinkel_at (Traeger.get Tr_ID r_winkel))
      (setq rWinkel_ht (Traeger.get Htrg  r_winkel))
    	(print rWinkel_at)
    	(print rWinkel_ht)
    	(if (= rWinkel_at 180.0)
    		(progn
    			(setq hProf (Traeger.get Htrg h))
    			(setq hp (Blech.get kplHtrg hp))
    			(setq r (- hp hProf (* 2 versatz) ))
    			
    			(if (= rWinkel_ht 0.0) (Blech.set kplHtrg (dOk (- (- versatz) r))))
    			
    		)
    	)
    	(if (= rWinkel_at 0.0)
    		(progn
    			(setq hProf (Traeger.get Htrg h))
    			(setq hp (Blech.get kplHtrg hp))
    			(setq r (- hp hProf (* 2 versatz) ))
    			
    			(if (= rWinkel_ht 180.0) (Blech.set kplHtrg (dOk (- (- versatz) r))))
    		)
    	)
      
		)
	)
	
)