; $	HT	QT(IUK)		AF(SK)		P(EZ)
; $	AT	QT(IUKRSL)	AF(K)		P(E)
; $	AE	V(-)		H(-)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;	
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (load "mod-endinit-uz-stzsteg")
   (load "mod-multiconnect-stz-steg")
   (load "mod-lochbild")
   (load "mod-messages")
   (load "mod-endinit-uz-stzsteg")
)


(defun init-connection ()

	(connect.showattributes CastaData)

	(init-traegerenden 0)
	
	(setConnection)
)

(defun setConnection ()
	(print "*clear*")
	(Connect.showAttributes CastaData)
	(calc_Ausklinkung)
	
)


(defun calc_Ausklinkung ()

    (print "*clear*")
    (print "Berechnung der Ausklinkung")

    (setq	h_AT	(Traeger.get Tr_ID h)
    		t_AT	(Traeger.get Tr_ID t)
    		r_AT	(Traeger.get Tr_ID r)
    		dv_AT	(Traeger.get Tr_ID delta_V)
    )
    (setq	h_HT	(Traeger.get HTrg h)
    		t_HT	(Traeger.get HTrg t)
    		r_HT	(Traeger.get HTrg r)
    		b_HT	(Traeger.get HTrg b)
    		dv_HT	(Traeger.get HTrg delta_V)
    )

    (if (= (Connect.get CastaData linkesEnde)  1) (setq tEnde (Traeger.get Tr_ID links)))
    (if (= (Connect.get CastaData rechtesEnde) 1) (setq tEnde (Traeger.get Tr_ID rechts)))

    (if (= (Connect.get CastaData vAtr-VHtr) -1) (setq dv_AT (- dv_AT)))

    (setq zp_HT_Oben (- (* 0.5 h_HT) dv_HT t_HT r_HT))
;   (setq zp_HT_Oben (- (* 0.5 h_HT) dv_HT))				; zum Testen mit einfachen Werten
    (setq zp_AT_Oben (- (* 0.5 h_AT) dv_AT))


    (setq zp_HT_Unten (- (* 0.5 (- h_HT)) dv_HT (- t_HT) (- r_HT)))
;   (setq zp_HT_Unten (- (* 0.5 (- h_HT)) dv_HT))			; zum Testen mit einfachen Werten
    (setq zp_AT_Unten (- (* 0.5 (- h_AT)) dv_AT))

    
    (setq x_Akl   0)
    (setq z_Akl   0)
    (setq RH_Steg 0)	; Resthhe Steg
    
    (setq zp_Oben_Diff (- zp_AT_Oben zp_HT_Oben)) 
    (setq zp_Unten_Diff (- zp_HT_Unten zp_AT_Unten))
    
    (print zp_HT_Oben)
    (print zp_AT_Oben)
    (print zp_Oben_Diff)

    (print zp_HT_Unten)
    (print zp_AT_Unten)
    (print zp_Unten_Diff)

    ; U-Profile noch abfangen - entweder keine Ausklinkung oder volles b

    (setq x_Akl (* 0.5 b_HT))

    (if (= (Connect.get CastaData vAtr-VHtr)  1) (progn		; dV gleiche Richtung
	(if (> zp_Oben_Diff 0) (setq z_Akl zp_Oben_Diff))
	(if (> zp_Unten_Diff 0) (progn
	    (if (> zp_Oben_Diff 0) 
	        (setq RH_Steg (- h_AT zp_Unten_Diff zp_Oben_Diff))
	        (setq RH_Steg (- h_AT zp_Unten_Diff))
	    )
	))
    ))
    (if (= (Connect.get CastaData vAtr-VHtr) -1) (progn		; dV entgegen gesetzt
	(if (> zp_Unten_Diff 0) (setq z_Akl zp_Unten_Diff))
	(if (> zp_Oben_Diff 0) (progn
	    (if (> zp_Unten_Diff 0) 
	        (setq RH_Steg (- h_AT zp_Oben_Diff zp_Unten_Diff))
	        (setq RH_Steg (- h_AT zp_Oben_Diff))
	    )
	))
    ))
    
    (print "setzen ...") (print x_Akl) (print z_Akl) (print RH_Steg)
    (TrEnde.set tEnde (xAkl x_Akl) (zAkl z_Akl) (hsteg RH_Steg))
;    (berechneAusklinkungTrg tEnde 0)

)
