; $	HT	QT(IU)		AF(FS)		P(EZ)
; $ 	AT	QT(IUKRS)	AF(K)		P(E)
; $	AE	V(-)		H(-)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;	
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (load "mod-endinit-uz-stzflansch")		
   (load "mod-help-uz_an_stzFlansch")
   (load "mod-lochbild")
   (load "mod-multiconnect-stz-flansch")
   (load "mod-messages")
)


(defun init-connection ()

	(setq LB_DEBUG 0)
	(connect.showattributes CastaData)

	(init-traegerenden)
	
	(setConnection)
)

(defun setConnection ()
	
	; Objekte erzeugen
	(setq kpl_blech (Blech.create))
	(setq kpl_lochbild (Lochbild.create))
	(Connect.storeAnschlObjs CastaData kpl_blech kpl_lochbild)
	
	; Blechdicke berechnen
	(calcAndSetKplThickness)
	
	;Schraubengre anhand der min. Blechdicke bestimmen(grobe Anhaltswerte)
	(setq min_blech_dp 10)
	(setq akt_kpl_dp (Blech.get kpl_blech dp))
	(setq t_ht (Traeger.get Htrg t))
	(if (< t_ht akt_kpl_dp)
		(setq min_blech_dp t_ht)
		(setq min_blech_dp akt_kpl_dp)
	)
	(print min_blech_dp)
	(calcSchraube min_blech_dp) ; -> S_Bez
	
	; Schraubengre dem Lochbild hinzufgen
	(Lochbild.set kpl_lochbild (S_Bez S_Bez))
	
	; min. Rand- / Lochabstnde berechnen
	(calcMinRandLochAbst kpl_lochbild) ; -> e_min, e1_min, e_min_rund, e1_min_rund, h_min
	
	; Kopfplatte berechnen
	(calcAndSetKplDaten)
	
	;Einbauposition prfen
	(checkPosition kpl_blech)
	
	; Anbauteil Kopfplatte hinzufgen
	(setKplAbtl)
	
	; Lochbilddaten berechnen
	(calcAndSetLochbildDaten kpl_lochbild kpl_blech)
	
	; Lochbildanbauteile hinzufgen
	(setLochbildAbtl kpl_lochbild kpl_blech)
	
	; korrigiere Stz-Ende
	(if (= (Connect.get CastaData anz_weitere_anschl) 0)
		(if (= (Connect.get CastaData anschlzwhtenden) 0)
			(korrigiereStzEnde)
		)
	)
	
	; CALLBACK
  (Blech.set kpl_blech (formFkt "cb_kpl_blech"))
)



; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am AT
; ----------------------------------------------------------------------------------------
(defun cb_kpl_blech (zp)
	(print "*clear*")
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get kpl_blech dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get kpl_blech dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (print dpDiff)
	       (setq alteKlemml (Lochbild.get kpl_lochbild Klemml))
	       (setq altesDxS		(Lochbild.get kpl_lochbild dxsKopf))
	       (print altesDxS)
	       (Lochbild.set kpl_lochbild 	(Klemml (+ alteKlemml dpDiff))
	       															(DxSKopf (+ altesDxS dpDiff))
	       )
				 
				 (cbDeltaLR kpl_lochbild dpDiff)
	    ))
	))
	
)


; ---------------------------------------------------------------------
; Korrigiert die delta_lr Verschiebung des LB-ABTL bei einem Aufruf
; der Callbackfunktion (Dickennderung des Bleches)
; ---------------------------------------------------------------------
(defun cbDeltaLR (KPL_LB DP_DIFF)
	;(print "*clear*")
	(print ">------------------------------------------------------------------------------")
	(print "Anbauteil Korrektur wegen Callback-Funktion")
	
	; Anbauteil des HT-LB
	(setq ht_lb_abtl (Traeger.get Htrg Abteil KPL_LB))
				 
	; delta_lr Verschiebung des Anbauteils
	(setq delta_lr_abtl_alt (Anbauteil.get ht_lb_abtl delta_lr))
	(print delta_lr_abtl_alt)
	
	; Wert, um den das Anbauteil korrigiert wird (erstmal auf 0.0) 
	(setq delta_lr_abtl_neu 0.0)
	
	; Winkel des AT zum HT in horizontaler Richtung
	(setq h_wnkl_flansch_at (Connect.get CastaData h-atrgewnkl_flansch))
	(print h_wnkl_flansch_at)
	
	(setq tanHW (tan (/ (* PI h_wnkl_flansch_at) 180.0)))
	(print tanHW)
	
	(if (/= tanHW 0.0)
		(setq delta_lr_abtl_korr (/ (* 1.0 DP_DIFF) tanHW))
	)
	(print delta_lr_abtl_korr)
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)		(setq delta_lr_abtl_neu (+ delta_lr_abtl_alt delta_lr_abtl_korr)))
	(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq delta_lr_abtl_neu (- delta_lr_abtl_alt delta_lr_abtl_korr)))
	
	; Anbauteil korrigieren
	(print delta_lr_abtl_neu)
	(Anbauteil.set ht_lb_abtl (delta_lr delta_lr_abtl_neu))
	
	(print "<------------------------------------------------------------------------------")
)

; ****************************************************************************************
; HILFSFUNKTIONEN
; ****************************************************************************************

; ----------------------------------------------------------------------------------------
; Berechnet die Kopfplattendicke
; ----------------------------------------------------------------------------------------
(defun calcAndSetKplThickness ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE KOPFPLATTEN-DICKE")
	(print "------------------------------------------------------------")
	(setq t_ht (Traeger.get Htrg t))
	(setq t_at (Traeger.get Tr_ID t))
	
	(setq dp_kpl (runde t_at auf 5.0))
	(print dp_kpl)
	
	(Blech.set kpl_blech (dp dp_kpl))
	(print "<-----------------------------------------------------------")
)


; ----------------------------------------------------------------------------------------
; Berechnet die Kopfplattendaten
; ----------------------------------------------------------------------------------------
(defun calcAndSetKplDaten ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE KOPFPLATTEN-DATEN")
	(print "------------------------------------------------------------")
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID rechts)))
	(setq vscherl_at	(TrEnde.get AT_Ende vscherl))
	(setq hscherl_at	(TrEnde.get AT_Ende hscherl))
	
	(setq b_at 			(Traeger.get Tr_ID b)
				qsform_at	(Traeger.get Tr_ID qsform)
	)
	
	(setq abst_zum_rand e_min_rund)
	(setq abst_zum_trg (* 0.5 e_min_rund))
	(if (= qsform_at "R")
		(setq abst_zum_trg (* 0.25 e_min_rund))
	)
	
	(setq rand (+ abst_zum_rand abst_zum_trg))
	; Kopfplattenhhe
	(setq kpl_hp (+ vscherl_at (* 2.0 rand)))
	(print kpl_hp)
	
	; Kopfplattenbreite
	(setq kpl_bp (+ hscherl_at (* 2.0 rand)))
	(print kpl_bp)
	
	; Dok
	(setq kpl_dok (- rand))
	(print kpl_dok)
	
	(Blech.set kpl_blech 	(hp		kpl_hp)
												(bp 	kpl_bp)
												(dok 	kpl_dok)
	)
	(print "<-----------------------------------------------------------")	
)		


; ----------------------------------------------------------------------------------------
; Hinzufgen des Kopfplatten-Anbauteils
; ----------------------------------------------------------------------------------------
(defun setKplAbtl ()
	(print ">-----------------------------------------------------------")
	(print "FGE KOPFPLATTEN-ANBAUTEIL HINZU")
	(print "------------------------------------------------------------")
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	
	(setq kpl_dp (Blech.get kpl_blech dp))
	
	(setq xPos_abtl	xPos_ht)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(setq AT_Ende (Traeger.get Tr_ID links))
			(Traeger.addAbtl Tr_ID kpl_blech xPos_abtl 0.0 _kopfplattelinks_)
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(setq AT_Ende (Traeger.get Tr_ID rechts))
			(Traeger.addAbtl Tr_ID kpl_blech xPos_abtl 0.0 _kopfplatterechts_)
		)
	)
	
	(TrEnde.pTrim AT_Ende kpl_dp)
	
	(print "<-----------------------------------------------------------")	
)

; ----------------------------------------------------------------------------------------
; Berechnet die Lochbilddaten
; ----------------------------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lochb_ID Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(print "------------------------------------------------------------")
	(Lochbild.set Lochb_ID 	(Guete  "4.6")
													(Anz_S  4)
	)
	
	(setq kpl_hp 	(Blech.get Blech_ID hp)
				kpl_bp 	(Blech.get Blech_ID bp)
				kpl_dok (Blech.get Blech_ID dok)
				kpl_dp	(Blech.get Blech_ID dp)
	)
	
	(setq t_ht		(Traeger.get Htrg t))
	
	; e0
	(setq e0_lb (- abst_zum_trg))
	
	; e1
	(setq e1_lb (- kpl_hp (* 2.0 e_min_rund)))
	
	; w0
	(setq w0_lb (- kpl_bp (* 2.0 e_min_rund)))
	 
	; dok
	;(setq at_winkel (Connect.get CastaData at_laengswinkel))
	;(print at_winkel)
	
	;(setq tanW (tan (/ (* PI at_winkel) 180.0)))
	;(print tanW)
	
	;(setq anteil_neigung (/ kpl_dp tanW))
	;(print anteil_neigung)
	
	;(if (= (Connect.get CastaData vatr-lhtr) -1)
	;	(setq dok_lb (- anteil_neigung))
	;	(setq dok_lb anteil_neigung)
	;)
	
	
	; klemml
	(setq klemml_lb (+ t_ht kpl_dp))
	
	; dxskopf
	(setq dxskopf_lb kpl_dp)
	
	(Lochbild.set Lochb_ID 	(e0				e0_lb)
													(e1				e1_lb)
													(w0				w0_lb)
													;(dok			dok_lb)
													(klemml		klemml_lb)
													(dxsKopf	dxskopf_lb)
	)
	
	(if (= LB_DEBUG 1)
		(Lochbild.set Lochb_ID (e2 300))
	)
	
	(print "<-----------------------------------------------------------")	
)


; ----------------------------------------------------------------------------------------
; Hinzufgen der Lochbild-Anbauteile
; ----------------------------------------------------------------------------------------
(defun setLochbildAbtl (Lochb_ID Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "FGE LOCHBILD-ANBAUTEILE HINZU")
	(print "------------------------------------------------------------")
	
	; AT - ANBAUTEIL
	; ------------------------------------------------------------------
	(if (= (Connect.get CastaData linkesEnde) 1)
		(Traeger.addAbtl Tr_ID Lochb_ID 0.0 0.0 _kpllochbildlinks_)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(Traeger.addAbtl Tr_ID Lochb_ID 0.0 0.0 _kpllochbildrechts_)
	)
		
	(setq kpl_dp (Blech.get Blech_ID dp))
	(setq kpl_dp (* 1.0 kpl_dp))
	(print kpl_dp)
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	
	(setq tanW (tan (/ (* PI at_winkel) 180.0)))
		
	(setq delta_v_abtl_at 0.0)
	
	; Anteil Kopfplatte
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(setq anteil_hneigung (/ (* 1.0 kpl_dp) tanW))
		
		(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_at (- anteil_hneigung))	)
		(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_at anteil_hneigung)	)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	; HT - ANBAUTEIL
	; ------------------------------------------------------------------
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	
	(setq delta_v_abtl_ht 0.0)
	(setq delta_lr_abtl_ht 0.0)
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(setq FLANSCH _flanschlochbild_of_)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(setq FLANSCH _flanschlochbild_uf_)
	)
	
	
	; Winkel Anbauteil HT
	; ----------------------------------------------
	(setq abtl_winkel_ht 0.0)
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq abtl_winkel_ht 180.0))
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq abtl_winkel_ht   0.0))
	(if (= (Connect.get CastaData vatr-shtr) -1)	(setq abtl_winkel_ht  90.0))
	(if (= (Connect.get CastaData vatr-shtr)  1)	(setq abtl_winkel_ht 270.0))
	
	
	; Anteil AT-Neigung (vert. zum HT)
	; ----------------------------------------------
	(if (= 1 1)	(progn 
	; ----------------------------------------------
		(print "NEIGUNG VERTIK. ZUM HT")
		(setq h_ht 				(Traeger.get Htrg h)
					delta_v_ht	(Traeger.get Htrg delta_v)
		)
		(setq h_ht_halb (* 0.5 h_ht))
		
		(setq anteil_kpl_dp	(Blech.get Blech_ID dp))
		
		(if (= (Connect.get CastaData amHtOberflansch) 1)		(setq anteil_stz (- (+ h_ht_halb anteil_kpl_dp) delta_v_ht))	)
		(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq anteil_stz (+ (+ h_ht_halb anteil_kpl_dp) delta_v_ht))	)
		
		(print anteil_stz)
		
		(setq at_winkel (Connect.get CastaData at_laengswinkel))
		(print at_winkel)
		
		(setq tanW (tan (/ (* PI at_winkel) 180.0)))
		(setq sinW (sin (/ (* PI at_winkel) 180.0)))
		(print tanW)
		
		(setq anteil_neigung (/ anteil_stz tanW))
		(print anteil_neigung)
		
		(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_neigung)))
		(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_neigung)))
		(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_lr_abtl_ht anteil_neigung))
		(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_lr_abtl_ht (- anteil_neigung)))
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	; Anteil halbe AT-Hhe bzw. AT-Breite
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(if (= (Connect.get CastaData linkesEnde) 1)
			(setq AT_Ende (Traeger.get Tr_ID links))
		)
		(if (= (Connect.get CastaData rechtesEnde) 1)
			(setq AT_Ende (Traeger.get Tr_ID rechts))
		)
		
		(setq vscherl_at	(TrEnde.get AT_Ende vscherl)
					hscherl_at	(TrEnde.get AT_Ende hscherl)
		)
		(print vscherl_at)
		(print hscherl_at)
		
		(setq vscherl_at_halb (* 0.5 vscherl_at))
		(setq hscherl_at_halb (* 0.5 hscherl_at))
		(print vscherl_at_halb)
		(print hscherl_at_halb)
		
		
		(print delta_v_abtl_ht)
		
		(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_ht (- (* 1.0 delta_v_abtl_ht) vscherl_at_halb)))
		(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_ht (- (* 1.0 delta_v_abtl_ht) vscherl_at_halb)))
		(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_abtl_ht (- (* 1.0 delta_v_abtl_ht) vscherl_at_halb)))
		(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_abtl_ht (- (* 1.0 delta_v_abtl_ht) vscherl_at_halb)))
		
		(print delta_v_abtl_ht)
	; ----------------------------------------------
	))
	; ----------------------------------------------
			
	
	; Anteil AT-Neigung (horiz.)
	; ----------------------------------------------
	(if (= 1 1) (progn	
	; ----------------------------------------------
		(print "NEIGUNG HORIZ. ZUM HT")
		(setq h_ht 				(Traeger.get Htrg h)
					delta_v_ht	(Traeger.get Htrg delta_v)
		)
		(setq h_ht_halb (* 0.5 h_ht))
		
		(setq kpl_dp 			(Blech.get Blech_ID dp))
		
		(setq anteil_stz (+ (* 1.0 delta_v_ht) (+ h_ht_halb kpl_dp)))
		(print anteil_stz)
		
		(setq at_rwinkel (Connect.get CastaData at_rotawinkel))
		(print at_rwinkel)
		
		(setq tanRW (tan (/ (* PI at_rwinkel) 180.0)))
		(print tanRW)
		
		(setq anteil_hneigung (* anteil_stz tanRW))
		(print anteil_hneigung)
		
		(if (= (Connect.get CastaData rechtesEnde)  1)
			(progn
				(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_hneigung)))
				(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_hneigung)))
			)
		)
		(if (= (Connect.get CastaData linkesEnde)  1)
			(progn
				(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_hneigung)))
				(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_hneigung)))
			)
		)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	; Anteil delta_v Verschiebung AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(setq delta_v_at (Traeger.get Tr_ID delta_v))
		
		(if (/= sinW 0.0)
			(setq anteil_delta_v_at (/ delta_v_at sinW))
			(setq anteil_delta_v_at 0)
		)
			
		(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_at)))
		(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_at)))
		(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_v_at)))
		(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_v_at)))
	; ----------------------------------------------
	))
	; ----------------------------------------------

	; delta_lr Anbauteil HT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(print "ANTEIL DELTA_LR AT")
		; Anteil delta_lr Verschiebung AT
		(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
		(print delta_lr_at)
		
		(if (/= sinW 0.0)
			(setq anteil_delta_lr_at (/ delta_lr_at sinW))
			(setq anteil_delta_lr_at 0)
		)
		(print anteil_delta_lr_at)
		
		(if (= (Connect.get CastaData satr-shtr)  1)
			(progn 
				(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht delta_lr_at)))
				(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht delta_lr_at)))
			)
		)
		(if (= (Connect.get CastaData satr-shtr) -1)
			(progn 
				(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht delta_lr_at)))
				(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht delta_lr_at)))
			)
		)
		(if (= (Connect.get CastaData vatr-shtr)  1)
			(progn 
				(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_delta_lr_at)))
				(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_delta_lr_at)))
			)
		)
		(if (= (Connect.get CastaData vatr-shtr) -1)
			(progn 
				(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_delta_lr_at)))
				(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_delta_lr_at)))
			)
		)
		
	(print delta_lr_abtl_ht)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	

	


	; Anteil delta_lr Verschiebung HT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(setq delta_lr_ht (Traeger.get Htrg delta_lr))
		(print delta_lr_ht)
				
		(if (= (Connect.get CastaData satr-shtr)  1)
			(progn 
				(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht delta_lr_ht)))
				(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht delta_lr_ht)))
			)
		)
		(if (= (Connect.get CastaData satr-shtr) -1)
			(progn 
				(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht delta_lr_ht)))
				(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht delta_lr_ht)))
			)
		)
		(if (= (Connect.get CastaData vatr-shtr)  1)
			(progn 
				(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht delta_lr_ht)))
				(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht delta_lr_ht)))
			)
		)
		(if (= (Connect.get CastaData vatr-shtr) -1)
			(progn 
				(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_lr_ht)))
				(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_lr_ht)))
			)
		)
		(print delta_lr_abtl_ht)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	(Traeger.addAbtl Htrg Lochb_ID xPos_ht abtl_winkel_ht FLANSCH)
	
	(setq lb_abtl_at (Traeger.get Tr_ID Abteil Lochb_ID))
	(setq lb_abtl_ht (Traeger.get Htrg Abteil Lochb_ID))
	
	(Anbauteil.set lb_abtl_at (Master 	0)
														(delta_v  delta_v_abtl_at)
	)
	(Anbauteil.set lb_abtl_ht (Master 	1)
														(delta_v 	delta_v_abtl_ht)
														(delta_lr delta_lr_abtl_ht)
	)
	
	
	; **************************************************************************************
	; Lochbild Test
	; **************************************************************************************
	(if (= LB_DEBUG 1) (progn
		(print "LB_DEBUG")
		(setq dummy (Lochbild.create))
		(Lochbild.copy dummy Lochb_ID)
		
		(if (= (Connect.get CastaData linkesEnde) 1)
			(Traeger.addAbtl Tr_ID dummy 0.0 0.0 _kpllochbildlinks_)
		)
		(if (= (Connect.get CastaData rechtesEnde) 1)
			(Traeger.addAbtl Tr_ID dummy 0.0 0.0 _kpllochbildrechts_)
		)
	
	
		(setq AT_ABTeil_dummy (Traeger.get Tr_ID AbTeil dummy))
		(Anbauteil.set AT_ABTeil_dummy 	(delta_v		delta_v_abtl_at)
																		(Master    1)
		)
	
		(Connect.storeAnschlObjs CastaData dummy)
	))
	; **************************************************************************************
	(print "<-----------------------------------------------------------")	
)
; ----------------------------------------------------------------------------------------
; Hinzufgen der Lochbild-Anbauteile
; ----------------------------------------------------------------------------------------
(defun setLochbildAbtlBackUp (Lochb_ID Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "FGE LOCHBILD-ANBAUTEILE HINZU")
	(print "------------------------------------------------------------")
	
	; AT
	(if (= (Connect.get CastaData linkesEnde) 1)
		(Traeger.addAbtl Tr_ID Lochb_ID 0.0 0.0 _kpllochbildlinks_)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(Traeger.addAbtl Tr_ID Lochb_ID 0.0 0.0 _kpllochbildrechts_)
	)
	
	
	; HT
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(setq FLANSCH _flanschlochbild_of_)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(setq FLANSCH _flanschlochbild_uf_)
	)
	
	; winkel Anbauteil HT
	; ----------------------------------------------
	(setq abtl_winkel_ht 0.0)
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(setq abtl_winkel_ht 180.0)
	)
	(if (= (Connect.get CastaData vatr-lhtr)  1)
		(setq abtl_winkel_ht 0.0)
	)
	
	
	; delta_v Anbauteil HT
	; ----------------------------------------------
	
	; Anteil AT-Hhe
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq AT_Ende (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq AT_Ende (Traeger.get Tr_ID rechts))
	)
	(setq vscherl_at	(TrEnde.get AT_Ende vscherl))
	(setq vscherl_at_halb (* 0.5 vscherl_at))
	
	(if (= (Connect.get CastaData vatr-lhtr)  1)
		(setq delta_v_abtl_ht (- vscherl_at_halb))
	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(setq delta_v_abtl_ht (- vscherl_at_halb))
	)
	
	; Anteil delta_v Verschiebung AT
	(setq delta_v_at (Traeger.get Tr_ID delta_v))
		
	(if (= (Connect.get CastaData vatr-lhtr)  1)
		(setq delta_v_abtl_ht (- delta_v_abtl_ht delta_v_at))
	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_v_at))
	)
		
	; Anteil AT-Neigung (vert.)
	(setq h_ht 				(Traeger.get Htrg h)
				delta_v_ht	(Traeger.get Htrg delta_v)
	)
	(setq h_ht_halb (* 0.5 h_ht))
	
	(setq anteil_stz (+ delta_v_ht h_ht_halb))
	(print anteil_stz)
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	(print at_winkel)
	
	(setq tanW (tan (/ (* PI at_winkel) 180.0)))
	(print tanW)
	
	(setq anteil_neigung (/ anteil_stz tanW))
	(print anteil_neigung)
	
	(if (= (Connect.get CastaData vatr-lhtr)  1)
		(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_neigung))
	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_neigung))
	)
		
	
	; Anteil delta_lr Verschiebung AT
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	(print delta_lr_at)
		
	(if (= (Connect.get CastaData satr-shtr)  1)
		(setq delta_lr_abtl_ht (+ delta_lr_at))
	)
	(if (= (Connect.get CastaData satr-shtr) -1)
		(setq delta_lr_abtl_ht (- delta_lr_at))
	)
	(print delta_lr_abtl_ht)
	
	
	; Anteil AT-Neigung (horiz.)
	(setq h_ht 				(Traeger.get Htrg h)
				delta_v_ht	(Traeger.get Htrg delta_v)
	)
	(setq h_ht_halb (* 0.5 h_ht))
	
	(setq kpl_dp 			(Blech.get Blech_ID dp))
	
	(setq anteil_stz (+ delta_v_ht (+ h_ht_halb kpl_dp)))
	(print anteil_stz)
	
	(setq at_rwinkel (Connect.get CastaData at_rotawinkel))
	(print at_rwinkel)
	
	(setq tanRW (tan (/ (* PI at_rwinkel) 180.0)))
	(print tanRW)
	
	(setq anteil_hneigung (* anteil_stz tanRW))
	(print anteil_hneigung)
	
	(if (= (Connect.get CastaData rechtesEnde)  1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_hneigung)))
			(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_hneigung)))
		)
	)
	(if (= (Connect.get CastaData linkesEnde)  1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_hneigung)))
			(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_hneigung)))
		)
	)
	
	; Anteil delta_lr Verschiebung HT
	(setq delta_lr_ht (Traeger.get Htrg delta_lr))
	(print delta_lr_ht)
		
	(if (= (Connect.get CastaData satr-shtr)  1)
		(setq delta_lr_abtl_ht (- delta_lr_abtl_ht delta_lr_ht))
	)
	(if (= (Connect.get CastaData satr-shtr) -1)
		(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht delta_lr_ht))
	)
	(print delta_lr_abtl_ht)
	
	
	
	(Traeger.addAbtl Htrg Lochb_ID xPos_ht abtl_winkel_ht FLANSCH)
	
	(setq lb_abtl_at (Traeger.get Tr_ID Abteil Lochb_ID))
	(setq lb_abtl_ht (Traeger.get Htrg Abteil Lochb_ID))
	
	(Anbauteil.set lb_abtl_at (Master 	0))
	(Anbauteil.set lb_abtl_ht (Master 	1)
														(delta_v 	delta_v_abtl_ht)
														(delta_lr delta_lr_abtl_ht)
	)
	(print "<-----------------------------------------------------------")	
)


; ----------------------------------------------------------------------------------------
; Verlngert bzw. Verkrzt das Sttzenende
; ----------------------------------------------------------------------------------------
(defun korrigiereStzEnde ()
	(print ">-----------------------------------------------------------")
	(print "KORRIGIERE STZ-ENDE")
	(print "------------------------------------------------------------")
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(progn
			(setq delta_l_stz (- rand))
			(setq HT_Ende (Traeger.get Htrg links))
		)
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(progn
			(setq delta_l_stz (- rand))
			(setq HT_Ende (Traeger.get Htrg rechts))
		)
	)
	
	(setq delta_l_alt (TrEnde.get Ht_Ende delta_l))
	(print delta_l_alt)
	(print rand)
	
	(setq delta_l_stz (- delta_l_alt rand))
	
	(TrEnde.set HT_Ende (delta_l delta_l_stz))
	(print "<-----------------------------------------------------------")	
)


; ----------------------------------------------------------------------------------------
; berprft, ob der Anschluss in der bestehenden Positionierung eingebaut werden kann
; ----------------------------------------------------------------------------------------
(defun checkPosition (Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "BERPRFE POSITION")
	
	; Oberkante HT
	(setq b_ht 				(Traeger.get Htrg b)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	(setq b_ht_halb	(* 0.5 b_ht))
	
	(setq h_at 				(Traeger.get Tr_ID h)
				b_at				(Traeger.get Tr_ID b)
				delta_v_at	(Traeger.get Tr_ID delta_v)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	(setq h_at_halb	(* 0.5 h_at))
	(setq b_at_halb	(* 0.5 b_at))
	
	(setq kpl_hp			(Blech.get Blech_ID hp)
				kpl_bp			(Blech.get Blech_ID bp)
	)
	(setq kpl_hp_halb	(* 0.5 kpl_hp))
	(setq kpl_bp_halb	(* 0.5 kpl_bp))
	
	
	(setq rGrenze_ht (+ delta_lr_ht b_ht_halb))
	(setq lGrenze_ht (- rGrenze_ht b_ht))
	(print rGrenze_ht)
	(print lGrenze_ht)
	
	(if (= (Connect.get CastaData satr-shtr)  1)
		(progn
			(setq rGrenze_kpl	(+ delta_lr_at kpl_bp_halb))
			(setq lGrenze_kpl (- rGrenze_kpl kpl_bp))
		)
	)
	(if (= (Connect.get CastaData satr-shtr) -1)
		(progn
			(setq rGrenze_kpl	(+ (- delta_lr_at) kpl_bp_halb))
			(setq lGrenze_kpl (- rGrenze_kpl kpl_bp))
		)
	)
	(if (= (Connect.get CastaData vatr-shtr)  1)
		(progn
			(setq rGrenze_kpl	(+ delta_v_at kpl_hp_halb))
			(setq lGrenze_kpl (- rGrenze_kpl kpl_hp))
		)
	)
	(if (= (Connect.get CastaData vatr-shtr) -1)
		(progn
			(setq rGrenze_kpl	(+ (- delta_v_at) kpl_hp_halb))
			(setq lGrenze_kpl (- rGrenze_kpl kpl_hp))
		)
	)
	(print rGrenze_kpl)
	(print lGrenze_kpl)
	
	(if (>= lGrenze_kpl lGrenze_ht)
		(progn
			(if (<= rGrenze_kpl rGrenze_ht)
				(progn
					(print "OK")
				)
				(progn
					(alertBox "Die Kopfplatte reicht ber die Flanschseiten des Haupttrgers hinaus.\nBitte korrigieren Sie die Positionierung der Trger oder passen Sie die Kopfplatte an!" "NOTE_HeadplateReachesAboutFlangearea")
				)
			)
		)
		(progn
			(alertBox "Die Kopfplatte reicht ber die Flanschseiten des Haupttrgers hinaus.\nBitte korrigieren Sie die Positionierung der Trger oder passen Sie die Kopfplatte an!" "NOTE_HeadplateReachesAboutFlangearea")
		)
	)
	
	(print "<-----------------------------------------------------------")
)