; $	HT	QT(IU)		AF(S)		P(EZ)
; $	AT	QT(IUKRS)	AF(K)		P(E)
; $	AE	V(-)			H(-)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;	Sept 2011 - dieses Makro ist im Prinzip obsolet
;	wird sicherheitshalber noch vorgehalten, falls doch noch irgendwo im Einsatz
;	Fehler enthalten: AT bei einer Rotationsposition - Schrauben um 180 falsch herum gedreht
;			  genauer Ort des Fehlers hier nicht bekannt.
;	
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (load "mod-endinit-uz-stzsteg")		
   (load "mod-lochbild")
   (load "mod-multiconnect-stz-steg")
   (load "mod-messages")
)


(defun init-connection ()

	;(connect.showattributes CastaData)

	(init-traegerenden 0)
	
	(setq LB_DEBUG 0)
	
	(setConnection)

    (if (= 1 2) (progn
		(setq AnschlussArt (Connect.get CastaData AnschlussArt))
		(print AnschlussArt)
		(setq AnschlussTyp (Connect.get CastaData AnschlussTyp))
		(print AnschlussTyp)
    ))
	
    (if (= LB_DEBUG 1) (progn
		(Lochbild.set kpl_lochbild (e2 300))
		(Lochbild.copy lbdummy kpl_lochbild)
		(Connect.storeAnschlObjs CastaData lbdummy)
    ))

)

(defun setConnection ()
	
	; Objekte erzeugen
	(setq kpl_blech (Blech.create))
	(Connect.storeAnschlObjs CastaData kpl_blech)
	
	(if (= (Connect.get CastaData exist_steglchb) 1)
		(progn
			(setq kpl_lochbild (Connect.get CastaData steglchb_gegen))										
		)
		(progn
  		(setq kpl_lochbild (Lochbild.create))
  	)
  )  
  (Connect.storeAnschlObjs CastaData kpl_lochbild)
  
	; Blechdicke berechnen
	(calcAndSetKplThickness)
	
	;Schraubengre anhand der min. Blechdicke bestimmen(grobe Anhaltswerte)
	(setq min_blech_dp 10)
	(setq akt_kpl_dp (Blech.get kpl_blech dp))
	(setq s_ht (Traeger.get Htrg s))
	(if (< s_ht akt_kpl_dp)
		(setq min_blech_dp s_ht)
		(setq min_blech_dp akt_kpl_dp)
	)
	(print min_blech_dp)
	(calcSchraube min_blech_dp) ; -> S_Bez
	
	; Schraubengre dem Lochbild hinzufgen
	(Lochbild.set kpl_lochbild (S_Bez S_Bez))
	
	; min. Rand- / Lochabstnde berechnen
	(calcMinRandLochAbst kpl_lochbild) ; -> e_min, e1_min, e_min_rund, e1_min_rund, h_min
	
	; Kopfplatte berechnen
	(calcAndSetKplDaten)
	
	;Einbauposition prfen
	(checkPosition kpl_blech)
	
	; Anbauteil Kopfplatte hinzufgen
	(setKplAbtl)
	
	; Auf gegenberliegenden Anschluss prfen
	(if (= (Connect.get CastaData exist_steglchb) 1)
		(progn
			(getExistingLochbild)												
		)
		(progn
  		; Lochbilddaten berechnen
			(calcAndSetLochbildDaten kpl_lochbild kpl_blech)
			
			; Lochbildanbauteile hinzufgen
			(setLochbildAbtl kpl_lochbild kpl_blech)
  	)
  )  
	
	; korrigiere Stz-Ende
	(if (= (Connect.get CastaData anz_weitere_anschl) 0)
		(if (= (Connect.get CastaData anschlzwhtenden) 0)
			(korrigiereStzEnde)
		)
	)
	
	
	; Callbacks
  (Blech.set kpl_blech (formFkt "cb_kplblech"))
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr die Kopfplatte
; ----------------------------------------------------------------------------------------
(defun cb_kplblech (zp)
	(print "*clear*")
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get kpl_blech dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get kpl_blech dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml 	(Lochbild.get kpl_lochbild Klemml))
	       (setq altesDxSKopf (Lochbild.get kpl_lochbild dxSKopf))
	       
		      (if (= (Connect.get CastaData amHtStegLinks) 1)
		       (Lochbild.set kpl_lochbild 	(Klemml  (+ alteKlemml dpDiff))
		       															(dxSKopf (+ altesDxSKopf dpDiff))	       	
		       )
		      )
		      (if (= (Connect.get CastaData amHtStegRechts) 1)
		       (Lochbild.set kpl_lochbild 	(Klemml  (+ alteKlemml dpDiff)))
		      )
					
					(cbDeltaLR kpl_lochbild dpDiff)
	    ))
	))
)



; ---------------------------------------------------------------------
; Korrigiert die delta_lr Verschiebung des LB-ABTL bei einem Aufruf
; der Callbackfunktion (Dickennderung des Bleches)
; ---------------------------------------------------------------------
(defun cbDeltaLR (KPL_LB DP_DIFF)
	;(print "*clear*")
	(print ">------------------------------------------------------------------------------")
	(print "Anbauteil Korrektur wegen Callback-Funktion")
	
	; Anbauteil des HT-LB
	(setq ht_lb_abtl (Traeger.get Htrg Abteil KPL_LB))
				 
	; delta_lr Verschiebung des Anbauteils
	(setq delta_lr_abtl_alt (Anbauteil.get ht_lb_abtl delta_lr))
	(print delta_lr_abtl_alt)
	
	; Wert, um den das Anbauteil korrigiert wird (erstmal auf 0.0) 
	(setq delta_lr_abtl_neu 0.0)
	
	; Winkel des AT zum HT in horizontaler Richtung
	(setq h_wnkl_steg_at (Connect.get CastaData h-atrgewnkl_steg))
	(print h_wnkl_steg_at)
	
	(setq tanHW (tan (/ (* PI h_wnkl_steg_at) 180.0)))
	(print tanHW)
	
	(if (/= tanHW 0.0)
		(setq delta_lr_abtl_korr (/ DP_DIFF tanHW))
	)
	(print delta_lr_abtl_korr)
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq delta_lr_abtl_neu (- delta_lr_abtl_alt delta_lr_abtl_korr)))
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq delta_lr_abtl_neu (+ delta_lr_abtl_alt delta_lr_abtl_korr)))
	
	; Anbauteil korrigieren
	(print delta_lr_abtl_neu)
	(Anbauteil.set ht_lb_abtl (delta_lr delta_lr_abtl_neu))
	
	(print "<------------------------------------------------------------------------------")
)

; ****************************************************************************************
; HILFSFUNKTIONEN
; ****************************************************************************************

; ----------------------------------------------------------------------------------------
; Berechnet die Kopfplattendicke
; ----------------------------------------------------------------------------------------
(defun calcAndSetKplThickness ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE KOPFPLATTEN-DICKE")
	(print "------------------------------------------------------------")
	(setq t_ht (Traeger.get Htrg t))
	(setq t_at (Traeger.get Tr_ID t))
	
	(setq dp_kpl (runde t_at auf 5.0))
	(print dp_kpl)
	
	(Blech.set kpl_blech (dp dp_kpl))
	(print "<-----------------------------------------------------------")
)


; ----------------------------------------------------------------------------------------
; Berechnet die Kopfplattendaten
; ----------------------------------------------------------------------------------------
(defun calcAndSetKplDaten ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE KOPFPLATTEN-DATEN")
	(print "------------------------------------------------------------")
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID rechts)))
	(setq vscherl_at	(TrEnde.get AT_Ende vscherl))
	(setq hscherl_at	(TrEnde.get AT_Ende hscherl))
	
	(setq b_at 			(Traeger.get Tr_ID b)
				qsform_at	(Traeger.get Tr_ID qsform)
	)
	
	(setq abst_zum_rand e_min_rund)
	(setq abst_zum_trg (* 0.5 e_min_rund))
	(if (= qsform_at "R")
		(setq abst_zum_trg (* 0.25 e_min_rund))
	)
	
	(setq rand (+ abst_zum_rand abst_zum_trg))
	; Kopfplattenhhe
	(setq kpl_hp (+ vscherl_at (* 2.0 rand)))
	(print kpl_hp)
	
	; Kopfplattenbreite
	(setq kpl_bp (+ hscherl_at (* 2.0 rand)))
	(print kpl_bp)
	
	; Dok
	(setq kpl_dok (- rand))
	(print kpl_dok)
	
	(Blech.set kpl_blech 	(hp		kpl_hp)
												(bp 	kpl_bp)
												(dok 	kpl_dok)
	)
	(print "<-----------------------------------------------------------")	
)		


; ----------------------------------------------------------------------------------------
; Hinzufgen des Kopfplatten-Anbauteils
; ----------------------------------------------------------------------------------------
(defun setKplAbtl ()
	(print ">-----------------------------------------------------------")
	(print "FGE KOPFPLATTEN-ANBAUTEIL HINZU")
	(print "------------------------------------------------------------")
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	
	(setq kpl_dp (Blech.get kpl_blech dp))
	
	(setq xPos_abtl	xPos_ht)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(setq AT_Ende (Traeger.get Tr_ID links))
			(Traeger.addAbtl Tr_ID kpl_blech xPos_abtl 0.0 _kopfplattelinks_)
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(setq AT_Ende (Traeger.get Tr_ID rechts))
			(Traeger.addAbtl Tr_ID kpl_blech xPos_abtl 0.0 _kopfplatterechts_)
		)
	)
	
	(TrEnde.pTrim AT_Ende kpl_dp)
	
	(print "<-----------------------------------------------------------")	
)

; ----------------------------------------------------------------------------------------
; Berechnet die Lochbilddaten
; ----------------------------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lochb_ID Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(print "------------------------------------------------------------")
	(Lochbild.set Lochb_ID 	(Guete  "4.6")
													(Anz_S  4)
	)
	
	(setq kpl_hp 	(Blech.get Blech_ID hp)
				kpl_bp 	(Blech.get Blech_ID bp)
				kpl_dok (Blech.get Blech_ID dok)
				kpl_dp	(Blech.get Blech_ID dp)
	)
	
	(setq s_ht		(Traeger.get Htrg s))
	(setq s_ht_halb (* 0.5 s_ht))
	
	; e0
	(setq e0_lb (- abst_zum_trg))
	
	; e1
	(setq e1_lb (- kpl_hp (* 2.0 e_min_rund)))
	
	; w0
	(setq w0_lb (- kpl_bp (* 2.0 e_min_rund)))
	 	
	(print s_ht)
	(print kpl_dp)
	
	; klemml
	(setq klemml_lb (+ s_ht kpl_dp))
	(print klemml_lb)
	; dxskopf
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(setq dxskopf_lb (+ kpl_dp s_ht_halb))
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(setq dxskopf_lb s_ht_halb)
	)
	(print dxskopf_lb)
	(Lochbild.set Lochb_ID 	(e0				e0_lb)
													(e1				e1_lb)
													(w0				w0_lb)
													(klemml		klemml_lb)
													(dxsKopf	dxskopf_lb)
	)
	
	(print "<-----------------------------------------------------------")	
)


; ----------------------------------------------------------------------------------------
; Hinzufgen der Lochbild-Anbauteile
; ----------------------------------------------------------------------------------------
(defun setLochbildAbtl (Lochb_ID Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "FGE LOCHBILD-ANBAUTEILE HINZU")
	(print "------------------------------------------------------------")
	
	; AT
	(if (= (Connect.get CastaData linkesEnde) 1)
		(Traeger.addAbtl Tr_ID Lochb_ID 0.0 0.0 _kpllochbildlinks_)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(Traeger.addAbtl Tr_ID Lochb_ID 0.0 0.0 _kpllochbildrechts_)
	)
	
	(setq delta_v_abtl_at 0)
	
	(setq kpl_dp (Blech.get Blech_ID dp))
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	
	(setq tanW (tan (/ (* PI at_winkel) 180.0)))
	(setq sinW (sin (/ (* PI at_winkel) 180.0)))
	
	(setq anteil_hneigung (/ (* 1.0 kpl_dp) tanW))
		
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_at (- anteil_hneigung))	)
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_at anteil_hneigung)	)
	
	
	; HT
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	
	(setq delta_v_abtl_ht 0)
	(setq delta_lr_abtl_ht 0)
	
	; winkel Anbauteil HT
	; ----------------------------------------------
	(setq abtl_winkel_ht 0.0)
	(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq abtl_winkel_ht  90.0)	)
	(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq abtl_winkel_ht 270.0)	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq abtl_winkel_ht 180.0)	)
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq abtl_winkel_ht 	 0.0)	)
	

	; delta_v Anbauteil HT
	; ----------------------------------------------
	
	; Anteil AT-Hhe
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq AT_Ende (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq AT_Ende (Traeger.get Tr_ID rechts))
	)
	(setq vscherl_at	(TrEnde.get AT_Ende vscherl))
	(setq vscherl_at_halb (* 0.5 vscherl_at))
	
	(setq delta_v_abtl_ht (- vscherl_at_halb))


	; Anteil AT-Neigung (horizontal)
	(setq s_ht 				(Traeger.get Htrg s)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(setq kpl_dp (Blech.get Blech_ID dp))
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	
	(setq tanW (tan (/ (* PI at_winkel) 180.0)))
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq abst (+ (* 0.5 s_ht) kpl_dp (- delta_lr_ht))))
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq abst (+ (* 0.5 s_ht) kpl_dp delta_lr_ht)))
	
	(setq anteil_hneigung (/ abst tanW))
	
	(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_hneigung)))
	(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_hneigung)))
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_hneigung)))
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_hneigung)))
		
	
	; Anteil AT-Neigung (vertikal - quer zur HT-Lngsachse)
	(setq s_ht 				(Traeger.get Htrg s)
				delta_v_ht	(Traeger.get Htrg delta_v)
	)
	
	(setq kpl_dp (Blech.get Blech_ID dp))
	
	(setq at_quer_wnkl (Connect.get CastaData h-atrgewnkl_steg))
	(print at_quer_wnkl)
	
	(setq tanQW (tan (/ (* PI at_quer_wnkl) 180.0)))
	(print tanQW)
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq abstQ (+ (* 0.5 s_ht) kpl_dp (- delta_v_ht))))
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq abstQ (+ (* 0.5 s_ht) kpl_dp delta_v_ht)))
	
	(setq anteil_qneigung (/ abstQ tanQW))
	(print anteil_qneigung)
	
	(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_qneigung)))
	(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_qneigung)))
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_qneigung)))
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_qneigung)))
	
	
		
	; Anteil delta_v Verschiebung HT
	(setq delta_v_ht (Traeger.get Htrg delta_v))
	
	(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht delta_v_ht))	)
	(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_v_ht))	)
	
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht delta_v_ht))	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht delta_v_ht))	)
	
	

	; Anteil delta_v Verschiebung AT
	(setq delta_v_at (Traeger.get Tr_ID delta_v))
	
	(if (/= sinW 0.0)
		(setq anteil_delta_v_at (/ delta_v_at sinW))
		(setq anteil_delta_v_at 0)
	)
	
	
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_at))	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_at))	)
		
	(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_v_at))	)
	(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_v_at))	)
	
	
	

	; Anteil delta_lr Verschiebung AT
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	
	(if (/= sinW 0.0)
		(setq anteil_delta_lr_at (/ delta_lr_at sinW))
		(setq anteil_delta_lr_at 0)
	)
	
	(if (= (Connect.get CastaData vatr-vhtr) -1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_delta_lr_at)))
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_delta_lr_at)))
		)
	)
	(if (= (Connect.get CastaData vatr-vhtr)  1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_delta_lr_at)))
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_delta_lr_at)))
		)
	)
	
	(if (= (Connect.get CastaData satr-vhtr) -1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht delta_lr_at)))
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht delta_lr_at)))
		)
	)
	(if (= (Connect.get CastaData satr-vhtr)  1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht delta_lr_at)))
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht delta_lr_at)))
		)
	)
	
	
	(Traeger.addAbtl Htrg Lochb_ID xPos_ht abtl_winkel_ht _steglochbild_system_)
	
	(setq lb_abtl_at (Traeger.get Tr_ID Abteil Lochb_ID))
	(setq lb_abtl_ht (Traeger.get Htrg Abteil Lochb_ID))
	
	(Anbauteil.set lb_abtl_at (Master 	0)
														(delta_v 	delta_v_abtl_at)
	)
	(Anbauteil.set lb_abtl_ht (Master 	1)
														(delta_v 	delta_v_abtl_ht)
														(delta_lr delta_lr_abtl_ht)
	)
	
	
	; LOCHBILD-TEST
	; --------------------------------------------------------------------------------------
	(if (= LB_DEBUG 1)
		(progn
			
			(setq lbdummy (Lochbild.create))
			(Lochbild.copy lbdummy Lochb_ID)
			
			(if (= (connect.get CastaData LinkesEnde) 1) (traeger.addabtl Tr_ID lbdummy 0.0 0.0 _kpllochbildlinks_))
			(if (= (connect.get CastaData RechtesEnde) 1) (traeger.addabtl Tr_ID lbdummy 0.0 0.0 _kpllochbildrechts_))
			
			(setq abtl_lb_at_dummy (Traeger.get Tr_ID Abteil lbdummy))
			(Anbauteil.set abtl_lb_at_dummy (Master 1)
																			(delta_v delta_v_abtl_at)
			)
			
		)
	)
	; --------------------------------------------------------------------------------------
	(print "<-----------------------------------------------------------")	
)
; ----------------------------------------------------------------------------------------
; Hinzufgen der Lochbild-Anbauteile
; ----------------------------------------------------------------------------------------
(defun setLochbildAbtlBackUp (Lochb_ID)
	(print ">-----------------------------------------------------------")
	(print "FGE LOCHBILD-ANBAUTEILE HINZU")
	(print "------------------------------------------------------------")
	
	; AT
	(if (= (Connect.get CastaData linkesEnde) 1)
		(Traeger.addAbtl Tr_ID Lochb_ID 0.0 0.0 _kpllochbildlinks_)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(Traeger.addAbtl Tr_ID Lochb_ID 0.0 0.0 _kpllochbildrechts_)
	)
	
	
	; HT
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	
	;(if (= (Connect.get CastaData amHtOberflansch) 1)
	;	(setq FLANSCH _flanschlochbild_of_)
	;)
	;(if (= (Connect.get CastaData amHtUnterflansch) 1)
	;	(setq FLANSCH _flanschlochbild_uf_)
	;)
	
	; winkel Anbauteil HT
	; ----------------------------------------------
	(setq abtl_winkel_ht 0.0)
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(setq abtl_winkel_ht 180.0)
	)
	(if (= (Connect.get CastaData vatr-lhtr)  1)
		(setq abtl_winkel_ht 0.0)
	)
	
	
	; delta_v Anbauteil HT
	; ----------------------------------------------
	
	; Anteil AT-Hhe
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq AT_Ende (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq AT_Ende (Traeger.get Tr_ID rechts))
	)
	(setq vscherl_at	(TrEnde.get AT_Ende vscherl))
	(setq vscherl_at_halb (* 0.5 vscherl_at))
	
	(if (= (Connect.get CastaData vatr-lhtr)  1)
		(setq delta_v_abtl_ht (- vscherl_at_halb))
	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(setq delta_v_abtl_ht (- vscherl_at_halb))
	)
	
	; Anteil delta_v Verschiebung AT
	(setq delta_v_at (Traeger.get Tr_ID delta_v))
		
	(if (= (Connect.get CastaData vatr-lhtr)  1)
		(setq delta_v_abtl_ht (- delta_v_abtl_ht delta_v_at))
	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_v_at))
	)
		
	; Anteil AT-Neigung (glob. Z)

	(setq s_ht 				(Traeger.get Htrg s)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	(setq s_ht_halb (* 0.5 s_ht))
	
	(setq anteil_stz (+ delta_lr_ht s_ht_halb))
	(print anteil_stz)
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	(print at_winkel)
	
	(setq tanW (tan (/ (* PI at_winkel) 180.0)))
	(print tanW)
	
	(setq anteil_neigung (/ anteil_stz tanW))
	(print anteil_neigung)
	
	(if (= (Connect.get CastaData vatr-lhtr)  1)
		(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_neigung))
	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_neigung))
	)
	
	; Anteil delta_lr Verschiebung AT
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	(print delta_lr_at)
		
	(if (= (Connect.get CastaData satr-vhtr)  1)
		(setq delta_lr_abtl_ht (+ delta_lr_at))
	)
	(if (= (Connect.get CastaData satr-vhtr) -1)
		(setq delta_lr_abtl_ht (- delta_lr_at))
	)
	(print delta_lr_abtl_ht)
	
	
	; Anteil delta_v Verschiebung HT
	(setq delta_v_ht (Traeger.get Htrg delta_v))
	(print delta_v_ht)
		
	(if (= (Connect.get CastaData satr-vhtr)  1)
		(setq delta_lr_abtl_ht (- delta_lr_abtl_ht delta_v_ht))
	)
	(if (= (Connect.get CastaData satr-vhtr) -1)
		(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht delta_v_ht))
	)
	(print delta_lr_abtl_ht)

	
	
	(Traeger.addAbtl Htrg Lochb_ID xPos_ht abtl_winkel_ht _steglochbild_system_)
	
	(setq lb_abtl_at (Traeger.get Tr_ID Abteil Lochb_ID))
	(setq lb_abtl_ht (Traeger.get Htrg Abteil Lochb_ID))
	
	(Anbauteil.set lb_abtl_at (Master 	0))
	(Anbauteil.set lb_abtl_ht (Master 	1)
														(delta_v 	delta_v_abtl_ht)
														(delta_lr delta_lr_abtl_ht)
	)
	(print "<-----------------------------------------------------------")	
)


; ----------------------------------------------------------------------------------------
; Verlngert bzw. Verkrzt das Sttzenende
; ----------------------------------------------------------------------------------------
(defun korrigiereStzEnde ()
	(print ">-----------------------------------------------------------")
	(print "KORRIGIERE STZ-ENDE")
	(print "------------------------------------------------------------")
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(progn
			(setq delta_l_stz (- rand))
			(setq HT_Ende (Traeger.get Htrg links))
		)
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(progn
			(setq delta_l_stz (- rand))
			(setq HT_Ende (Traeger.get Htrg rechts))
		)
	)
	
	(setq delta_l_alt (TrEnde.get Ht_Ende delta_l))
	(print delta_l_alt)
	(print rand)
	
	(setq delta_l_stz (- delta_l_alt rand))
	
	(TrEnde.set HT_Ende (delta_l delta_l_stz))
	(print "<-----------------------------------------------------------")	
)

; ----------------------------------------------------------------------------------------
; bernimmt das gegenberliegende Lochbild
; ----------------------------------------------------------------------------------------
(defun getExistingLochbild ()
	(alertBox "Auf der gegenberliegenden Seite ist bereits ein Anschluss vorhanden. Nehmen Sie nderungen ggf. manuell vor." "OppositeSideConnection_Found")
	
			
	(setq dp_kpl (Blech.get kpl_blech dp))
	(print dp_kpl)
			
	(setq klemml_alt 	(Lochbild.get kpl_lochbild klemml))
	(setq dxskopf_alt	(Lochbild.get kpl_lochbild dxsKopf))
	(print klemml_alt)
	(print dxskopf_alt)
			
	(setq klemml_neu 	(+ klemml_alt dp_kpl))
	(setq dxskopf_neu (+ dxskopf_alt dp_kpl))
	(print klemml_neu)
	(print dxskopf_neu)
			
	(Lochbild.set kpl_lochbild (klemml klemml_neu)
															;(dxsKopf dxskopf_neu)
	)									
				
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(Lochbild.set kpl_lochbild (dxsKopf dxskopf_neu))
	)
	
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(traeger.addabtl tr_id kpl_lochbild 0.0 0.0 _kpllochbildrechts_)
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
		(traeger.addabtl tr_id kpl_lochbild 0.0 0.0 _kpllochbildlinks_)
	)
			
	(setq delta_v_at 	(Traeger.get Tr_ID delta_v)
				delta_lt_at	(traeger.get Tr_ID delta_lr)
	)
			
	(setq loch_at_abtl (Traeger.get Tr_ID Abteil kpl_lochbild))
		  
	(Anbauteil.set loch_at_abtl (Master 	0)
		  												(delta_v 	(- delta_v_at))
		  												;(delta_lr 40); ??? funktioniert nicht
	)							
)


; ----------------------------------------------------------------------------------------
; berprft, ob der Anschluss in der bestehenden Positionierung eingebaut werden kann
; ----------------------------------------------------------------------------------------
(defun checkPosition (Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "BERPRFE POSITION")
	
	; Oberkante HT
	(setq h_ht 				(Traeger.get Htrg h)
				r_ht				(Traeger.get Htrg r)
				t_ht				(Traeger.get Htrg t)
				hc_ht				(Traeger.get Htrg hc)
				delta_v_ht	(Traeger.get Htrg delta_v)
	)
	(setq h_ht_halb	(* 0.5 h_ht))
	
	(setq h_at 				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	(setq h_at_halb	(* 0.5 h_at))
	
	(setq kpl_hp			(Blech.get Blech_ID hp)
				kpl_bp			(Blech.get Blech_ID bp)
	)
	(setq kpl_hp_halb	(* 0.5 kpl_hp))
	(setq kpl_bp_halb	(* 0.5 kpl_bp))
	
	
	(setq oGrenze_ht (- delta_v_ht (- h_ht_halb r_ht t_ht)))
	(setq uGrenze_ht (+ oGrenze_ht hc_ht))
	(print oGrenze_ht)
	(print uGrenze_ht)
	
	(if (= (Connect.get CastaData satr-vhtr)  1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)
				(progn
					(setq oGrenze_kpl	(- delta_lr_at kpl_bp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_bp))
				)
			)
			(if (= (Connect.get CastaData vatr-lhtr) -1)
				(progn
					(setq oGrenze_kpl	(- delta_lr_at kpl_bp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_bp))
				)
			)
		)
	)
	(if (= (Connect.get CastaData satr-vhtr) -1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)
				(progn
					(setq oGrenze_kpl	(- (- delta_lr_at) kpl_bp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_bp))
				)
			)
			(if (= (Connect.get CastaData vatr-lhtr) -1)
				(progn
					(setq oGrenze_kpl	(- (- delta_lr_at) kpl_bp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_bp))
				)
			)
		)
	)
	
	(if (= (Connect.get CastaData vatr-vhtr)  1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)
				(progn
					(setq oGrenze_kpl	(- delta_v_at kpl_hp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_hp))
				)
			)
			(if (= (Connect.get CastaData satr-lhtr) -1)
				(progn
					(setq oGrenze_kpl	(- delta_v_at kpl_hp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_hp))
				)
			)
		)
	)
		(if (= (Connect.get CastaData vatr-vhtr) -1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)
				(progn
					(setq oGrenze_kpl	(- (- delta_v_at) kpl_hp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_hp))
				)
			)
			(if (= (Connect.get CastaData satr-lhtr) -1)
				(progn
					(setq oGrenze_kpl	(- (- delta_v_at) kpl_hp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_hp))
				)
			)
		)
	)

	(print oGrenze_kpl)
	(print uGrenze_kpl)

	
	(if (>= oGrenze_kpl oGrenze_ht)
		(progn
			(if (<= uGrenze_kpl uGrenze_ht)
				(progn
					(print "OK")
				)
				(progn
					(alertBox "Die Kopfplatte ragt in die untere Ausrundung den Haupttrgers.\nBitte korrigieren Sie die Positionierung der Trger oder passen Sie die Kopfplatte an!" "Headplate_To_Fit_FilletBottom")
				)
			)
		)
		(progn
			(alertBox "Die Kopfplatte ragt in die obere Ausrundung den Haupttrgers.\nBitte korrigieren Sie die Positionierung der Trger oder passen Sie die Kopfplatte an!"  "Headplate_To_Fit_FilletTop")
		)
	)
	(print "<-----------------------------------------------------------")
)