; $	HT	QT(IUK)		AF(SK)		P(EZ)
; $	AT	QT(IUKRSL)	AF(K)		P(E)
; $	AE	V(-)		H(-)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;	
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (load "mod-endinit-uz-stzsteg")
   (load "mod-multiconnect-stz-steg")
   (load "mod-lochbild")
   (load "mod-messages")
   (load "mod-add-schweiss-querschn")
)


(defun init-connection ()

	(connect.showattributes CastaData)

	(init-traegerenden 0)
	
	(setConnection)
)

(defun setConnection ()
	(print "*clear*")
	(Connect.showAttributes CastaData)
	(SchweissProfil_Einsetzen_St)
)

(defun SchweissProfil_Einsetzen ()

	; Anschlussdaten ...
	; X-Position
	(setq xPos_ht		(Connect.get CastaData xPos_ht))
	; Rotationswinkel des AT
	(setq rWinkel 0.0)
	(setq rWinkel_AT	(Connect.get CastaData r-atrgewnkl_steg ))

	(if (= (Connect.get CastaData linkesEnde)  1) (progn
	    (if (= (Connect.get CastaData amHtStegLinks)   1) (setq rWinkel    (- rWinkel_AT 90.0)))
	    (if (= (Connect.get CastaData amHtStegRechts)  1) (setq rWinkel (- (- rWinkel_AT 90.0))))
	))
	(if (= (Connect.get CastaData rechtesEnde)  1) (progn
	    (if (= (Connect.get CastaData amHtStegLinks)   1) (setq rWinkel (- (- rWinkel_AT 90.0))))
	    (if (= (Connect.get CastaData amHtStegRechts)  1) (setq rWinkel    (- rWinkel_AT 90.0)))
	))


	(if (= (Connect.get CastaData amHtStegLinks)  1) (Traeger.addJoinProfil HTrg Tr_ID xPos_ht rWinkel _steg_links_))
	(if (= (Connect.get CastaData amHtStegRechts) 1) (Traeger.addJoinProfil HTrg Tr_ID xPos_ht rWinkel _steg_rechts_))
	
	; Anbauteil ermitteln
	(setq abtl_Trg (Traeger.get HTrg abTeil Tr_ID))
	(if (= (Connect.get CastaData linkesEnde)     1) (Anbauteil.set abtl_Trg (addflag  _endelinks_)))
	(if (= (Connect.get CastaData rechtesEnde)    1) (Anbauteil.set abtl_Trg (addflag _enderechts_)))
	(if (= (Connect.get CastaData amHtStegLinks)  1) (Anbauteil.set abtl_Trg (addflag _steg_links_)))
	(if (= (Connect.get CastaData amHtStegRechts) 1) (Anbauteil.set abtl_Trg (addflag _steg_rechts_)))

	
	(setq	dv_HT 	(Traeger.get HTrg delta_V))
	(setq	dv_AT 	(Traeger.get Tr_ID delta_V)
		dlr_AT	(Traeger.get Tr_ID delta_LR)
	)

	(print rWinkel)
	(setq sinWnk  (sin (* PI (/ rWinkel 180.0))))
	(setq cosWnk  (cos (* PI (/ rWinkel 180.0))))


	(setq delta_V_Abtl (- dv_AT))
	
	

	
	(setq delta_LR_Abtl 0.0)
	(if (= (Connect.get CastaData linkesEnde)  1) (progn
	    (if (= (Connect.get CastaData amHtStegLinks)   1) (setq delta_LR_Abtl    dlr_AT))
	    (if (= (Connect.get CastaData amHtStegRechts)  1) (setq delta_LR_Abtl (- dlr_AT)))
	))
	(if (= (Connect.get CastaData rechtesEnde)  1) (progn
	    (if (= (Connect.get CastaData amHtStegLinks)   1) (setq delta_LR_Abtl (- dlr_AT)))
	    (if (= (Connect.get CastaData amHtStegRechts)  1) (setq delta_LR_Abtl    dlr_AT))
	))

	(setq delta_V_Abtl_Set  (- (* cosWnk delta_V_Abtl)  (* sinWnk delta_LR_Abtl)))
	(setq delta_LR_Abtl_Set (+ (* cosWnk delta_LR_Abtl) (* sinWnk delta_V_Abtl)))

	(setq delta_V_Abtl_Set (- delta_V_Abtl_Set dv_HT))
	(Anbauteil.set abtl_Trg (delta_V  delta_V_Abtl_Set))
	(Anbauteil.set abtl_Trg (delta_LR delta_LR_Abtl_Set))

)
