; $	HT	QT(IUK)		AF(FK)		P(EZ)
; $ 	AT	QT(IUKRSL)	AF(K)		P(E)
; $	AE	V(-)		H(-)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;	
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (load "mod-endinit-uz-uzflansch")		
   (load "mod-help-uz_an_stzFlansch")
   (load "mod-lochbild")
   (load "mod-multiconnect-stz-flansch")
   (load "mod-messages")
)


(defun init-connection ()

	(print "*clear*")

	(setq LB_DEBUG 0)
	(if (= (Connect.get CastaData amHTFlansch) 1) (progn
	
		(init-traegerenden)
		(pruefeEinachsigSchraeg)
		
		(if (= Anschluss_OK 1) 	(setConnection))
		(if (= Anschluss_OK 0) 	(AlertBox "Dieses Makro ist nicht geeignet fr zweiachsig\ngeneigte Trgerkonstellationen." "WRN_NotSuitableFor2Axis"))
	  ); progn - Ende
	  ; else-Teil
	  (AlertBox "Dieses Makro kann nur fr Anschlsse am Flansch eingesetzt werden!" "WRN_Macro_JustForFlangeConnections")
	)
	
;	(Lochbild.set kpl_lochbild (delta_w 50)
;				   (w "0 0")
;				   (e "0 20 100 0 0 0")
;				   (LB_Art 2)
;	)
;	(setq ablt_Lchb_HT (Traeger.get HTrg ABTeil kpl_lochbild))
;	(setq HT_Lchb_SeitRicht (Anbauteil.get ablt_Lchb_HT seitricht))
;	(print  HT_Lchb_SeitRicht)
;	(Anbauteil.set ablt_Lchb_HT (seitricht 1))
	
)

(defun setConnection ()

	(connect.showattributes CastaData)

	; Objekte erzeugen
	(setq kpl_blech (Blech.create))
	(setq kpl_lochbild (Lochbild.create))
	(Connect.storeAnschlObjs CastaData kpl_blech kpl_lochbild)

(debug on)	
	; Blechdicke berechnen
	(calcAndSetKplThickness)
(debug off)	
	;Schraubengre anhand der min. Blechdicke bestimmen(grobe Anhaltswerte)
	(setq min_blech_dp 10)
	(setq akt_kpl_dp (Blech.get kpl_blech dp))
	(setq t_ht (Traeger.get Htrg t))
	(if (< t_ht akt_kpl_dp)
		(setq min_blech_dp t_ht)
		(setq min_blech_dp akt_kpl_dp)
	)
	(print min_blech_dp)
	; zur Sicherheit checken, was fr eine Dicke eingestellt wurde. Denn ansonsten
	; knnte S_Bez nicht belegt sein, da abhngig von dp
	(if (< min_blech_dp 6) (setq min_blech_dp 6))
	(calcSchraube min_blech_dp) ; -> S_Bez
	
	; Schraubengre dem Lochbild hinzufgen
	(Lochbild.set kpl_lochbild (S_Bez S_Bez))
	
	; min. Rand- / Lochabstnde berechnen
	(calcMinRandLochAbst kpl_lochbild) ; -> e_min, e1_min, e_min_rund, e1_min_rund, h_min
	
	; Kopfplatte berechnen
	(calcAndSetKplDaten)
	
	;Einbauposition prfen
	(checkPosition kpl_blech)
	
	; Anbauteil Kopfplatte hinzufgen
	(setKplAbtl)
	
	; Lochbilddaten berechnen
	(calcAndSetLochbildDaten kpl_lochbild kpl_blech)
	
	; Lochbildanbauteile hinzufgen
	(setLochbildAbtl kpl_lochbild kpl_blech)
	(htLochbildVerschiebung)
	
	; korrigiere Stz-Ende
	(if (= (Connect.get CastaData anz_weitere_anschl) 0)
		(if (= (Connect.get CastaData anschlzwhtenden) 0)
			(korrigiereStzEnde)
		)
	)
	
	(setq abtl_Lchb_HT (Traeger.get HTrg ABTeil kpl_lochbild))
	(setq dvLochb (Anbauteil.get abtl_Lchb_HT delta_V))
	
	(anpassen_QRR_Profile)

	; Test-Lochbild asymmetrisch	
	; (Lochbild.set kpl_lochbild (e "0 30 100 0 0 0") (LB_Art 2))
	
	; CALLBACK
	(Blech.set kpl_blech (formFkt "cb_kpl_blech"))
)



; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am AT
; ----------------------------------------------------------------------------------------
(defun cb_kpl_blech (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get kpl_blech dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get kpl_blech dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (print dpDiff)
	       (setq alteKlemml (Lochbild.get kpl_lochbild Klemml))
	       (setq altesDxS		(Lochbild.get kpl_lochbild dxsKopf))
	       (print altesDxS)
	       (Lochbild.set kpl_lochbild 	(Klemml (+ alteKlemml dpDiff))
	       															(DxSKopf (+ altesDxS dpDiff))
	       )
				 
				 (cbDeltaLR kpl_lochbild dpDiff)
	    ))
	))
	
)



; ---------------------------------------------------------------------
; Korrigiert die delta_lr Verschiebung des LB-ABTL bei einem Aufruf
; der Callbackfunktion (Dickennderung des Bleches)
; ---------------------------------------------------------------------
(defun cbDeltaLR (KPL_LB DP_DIFF)
	;(print "*clear*")
	(print ">------------------------------------------------------------------------------")
	(print "Anbauteil Korrektur wegen Callback-Funktion")
	
	; Anbauteil des HT-LB
	(setq ht_lb_abtl (Traeger.get Htrg Abteil KPL_LB))
	
	; delta_lr / delta_v Verschiebung des Anbauteils
	(setq delta_lr_abtl_alt (Anbauteil.get ht_lb_abtl delta_lr))
	(print delta_lr_abtl_alt)
	
	
	; Wert, um den das Anbauteil korrigiert wird (erstmal auf 0.0) 
	(setq delta_lr_abtl_neu 0.0)
	
	; Winkel des AT zum HT in horizontaler Richtung
	(setq h_wnkl_flansch_at (Connect.get CastaData h-atrgewnkl_flansch))
	(print h_wnkl_flansch_at)
	
	(setq tanHW (tan (/ (* PI h_wnkl_flansch_at) 180.0)))
	(print tanHW)
	
	(if (/= tanHW 0.0)
		(setq delta_lr_abtl_korr (/ DP_DIFF tanHW))
	)
	(print delta_lr_abtl_korr)
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)		(setq delta_lr_abtl_neu (+ delta_lr_abtl_alt delta_lr_abtl_korr)))
	(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq delta_lr_abtl_neu (- delta_lr_abtl_alt delta_lr_abtl_korr)))
	
	; Anbauteil korrigieren
	(print delta_lr_abtl_neu)
	(Anbauteil.set ht_lb_abtl (delta_lr delta_lr_abtl_neu))
	(print "<------------------------------------------------------------------------------")
)



; ****************************************************************************************
; HILFSFUNKTIONEN
; ****************************************************************************************

; ----------------------------------------------------------------------------------------
; Berechnet die Kopfplattendicke
; ----------------------------------------------------------------------------------------
(defun calcAndSetKplThickness ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE KOPFPLATTEN-DICKE")
	(print "------------------------------------------------------------")
	(setq t_ht (Traeger.get Htrg t))
	(setq t_at (Traeger.get Tr_ID t))
	
	
	(setq dp_kpl (runde t_at auf 5.0))

	(if (< dp_kpl 6) (setq dp_kpl 6))
	(print dp_kpl)
	
	(Blech.set kpl_blech (dp dp_kpl))
	; (Blech.set kpl_blech (dp 30))		; zum Testen
	(print "<-----------------------------------------------------------")
)


; ----------------------------------------------------------------------------------------
; Berechnet die Kopfplattendaten
; ----------------------------------------------------------------------------------------
(defun calcAndSetKplDaten ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE KOPFPLATTEN-DATEN")
	(print "------------------------------------------------------------")
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID rechts)))
	(setq vscherl_at	(TrEnde.get AT_Ende vscherl))
	(setq hscherl_at	(TrEnde.get AT_Ende hscherl))
	
	(setq	b_at 		(Traeger.get Tr_ID b)
		qsform_at	(Traeger.get Tr_ID qsform)
	)
	
	(setq abst_zum_rand e_min_rund)
	(setq abst_zum_trg (* 0.5 e_min_rund))
	(if (= qsform_at "R")
		(setq abst_zum_trg (* 0.25 e_min_rund))
	)
	
	(setq rand (+ abst_zum_rand abst_zum_trg))
	; Kopfplattenhhe
	(setq kpl_hp (+ vscherl_at (* 2.0 rand)))
	(print kpl_hp)
	
	; Kopfplattenbreite
	(setq kpl_bp (+ hscherl_at (* 2.0 rand)))
	(print kpl_bp)
	
	; Dok
	(setq kpl_dok (- rand))
	(print kpl_dok)
	
	(Blech.set kpl_blech 	(hp		kpl_hp)
				(bp 	kpl_bp)
				(dok 	kpl_dok)
	)
	(print "<-----------------------------------------------------------")	
)		


; ----------------------------------------------------------------------------------------
; Hinzufgen des Kopfplatten-Anbauteils
; ----------------------------------------------------------------------------------------
(defun setKplAbtl ()
	(print ">-----------------------------------------------------------")
	(print "FGE KOPFPLATTEN-ANBAUTEIL HINZU")
	(print "------------------------------------------------------------")
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	
	(setq kpl_dp (Blech.get kpl_blech dp))
	
	(setq xPos_abtl	xPos_ht)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(setq AT_Ende (Traeger.get Tr_ID links))
			(Traeger.addAbtl Tr_ID kpl_blech xPos_abtl 0.0 _kopfplattelinks_)
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(setq AT_Ende (Traeger.get Tr_ID rechts))
			(Traeger.addAbtl Tr_ID kpl_blech xPos_abtl 0.0 _kopfplatterechts_)
		)
	)
	
	(TrEnde.pTrim AT_Ende kpl_dp)
	
	(print "<-----------------------------------------------------------")	
)

; ----------------------------------------------------------------------------------------
; Berechnet die Lochbilddaten
; ----------------------------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lochb_ID Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(print "------------------------------------------------------------")
	(Lochbild.set Lochb_ID 	(Guete  "4.6")
													(Anz_S  4)
	)
	
	(setq	kpl_hp 		(Blech.get Blech_ID hp)
		kpl_bp 		(Blech.get Blech_ID bp)
		kpl_dok 	(Blech.get Blech_ID dok)
		kpl_dp		(Blech.get Blech_ID dp)
	)
	
	(setq	t_ht		(Traeger.get Htrg t))
	
	; e0
	(setq e0_lb (- abst_zum_trg))
	
	; e1
	(setq e1_lb (- kpl_hp (* 2.0 e_min_rund)))
	
	; w0
	(setq w0_lb (- kpl_bp (* 2.0 e_min_rund)))
	 
	
	; klemml
	(setq klemml_lb (+ t_ht kpl_dp))
	
	; dxskopf
	(setq dxskopf_lb kpl_dp)
	
	(Lochbild.set	Lochb_ID 	(e0		e0_lb)
					(e1		e1_lb)
					(w0		w0_lb)
					(klemml		klemml_lb)
					(dxsKopf	dxskopf_lb)
	)

	(if (< e0_lb 0) (progn
	    (if (> kpl_dok -10) (progn
	    	(print "Lochbild korrigieren, weil es auerhalb des Bleches liegt")
	    	(setq	ENetto 	(Lochbild.get Lochb_ID eNetto)
	    		sD	(Lochbild.get Lochb_ID sDurchm)
	    	)
	    	(setq	h_HT	(Traeger.get HTrg h)
	    		t_HT	(Traeger.get HTrg t)
	    	)
	    	(setq	h_HT_Min (+ (* 4.0 sd) eNetto))
	    	(print h_HT_Min)
	    	(if (> h_HT_Min (- h_HT t_HT t_HT)) (progn
	    		(setq e0_lb (* 0.5 h_HT))
			(Lochbild.set	Lochb_ID 	(e0		e0_lb)
							(e1		0)
							(w0		(+ w0_lb 10))
			)
			(Blech.set Blech_ID (bp (+ kpl_bp 10)))
	    	))
	    ))
	))


	; Schrgstellungsfaktor in vertikaler Richtung - abhngig von der Dicke der
	; Kopfplatte
    	(if (= (Connect.get CastaData linkesEnde) 1)		(setq AT_Ende (Traeger.get Tr_ID links)))
    	(if (= (Connect.get CastaData rechtesEnde) 1)		(setq AT_Ende (Traeger.get Tr_ID rechts)))

    	(setq	VE_Winkel	(TrEnde.get  AT_Ende V_Winkel))
    	(print VE_Winkel)
    	(setq S_Korrektur 1)
    	(if (> VE_Winkel 80.0) (progn (if (< VE_Winkel 100.0) (setq S_Korrektur 0))))
    	(if (= S_Korrektur 1) (progn
	    (setq	dp (Blech.get kpl_blech dp) dp (* 1.0 dp))
	    (setq tanVE (tan (/ (* PI VE_Winkel) 180.0)))
	    
	    (print VE_Winkel)
	    (print dp)
	    (print tanVE)
	    (if (= (Connect.get CastaData linkesEnde)  1) (if (>  VE_Winkel 90.0)     (setq tanVE 0.0)))
	    (if (= (Connect.get CastaData rechtesEnde) 1) (if (>  VE_Winkel 90.0)     (setq tanVE 0.0)))


	    (setq e0_LB (Lochbild.get	Lochb_ID e0))
	    (setq e0_LB (- e0_LB (* dp tanVE)))
	    (Lochbild.set	Lochb_ID (e0 e0_LB))

    	))

	
	(if (= LB_DEBUG 1)	(progn
		(Lochbild.set Lochb_ID	(e2 300))
	))
	(print "<-----------------------------------------------------------")	
)


; ----------------------------------------------------------------------------------------
; Hinzufgen der Lochbild-Anbauteile
; ----------------------------------------------------------------------------------------
(defun setLochbildAbtl (Lochb_ID Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "FGE LOCHBILD-ANBAUTEILE HINZU")
	(print "------------------------------------------------------------")
	
	; AT - ANBAUTEIL
	; ------------------------------------------------------------------
	(if (= (Connect.get CastaData linkesEnde) 1)
		(Traeger.addAbtl Tr_ID Lochb_ID 0.0 0.0 _kpllochbildlinks_)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(Traeger.addAbtl Tr_ID Lochb_ID 0.0 0.0 _kpllochbildrechts_)
	)
	
	(setq delta_v_abtl_at 0)
	
	(setq kpl_dp (Blech.get Blech_ID dp))
	(print kpl_dp)
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	
	(setq tanW (tan (/ (* PI at_winkel) 180.0)))
		
	(setq anteil_hneigung (/ (* 1.0 kpl_dp) tanW))
	
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_at (- anteil_hneigung))	)
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_at anteil_hneigung)	)
	
	; HT - ANBAUTEIL
	; ------------------------------------------------------------------
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	
	(setq delta_v_abtl_ht 0)
	(setq delta_lr_abtl_ht 0)

	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(setq FLANSCH _flanschlochbild_of_)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(setq FLANSCH _flanschlochbild_uf_)
	)
		
	; Winkel
	; -------------------------
	(setq r_winkel_at_flansch (Connect.get CastaData r-atrgewnkl_flansch))
	
	(setq abtl_winkel_ht 0.0)	; Vorbelegung
	(if (= (Connect.get CastaData amHtOberflansch)  1) (progn
	     (if (= (Connect.get CastaData linkesEnde) 1) (progn
		(if (= (Connect.get CastaData satr-lhtr-ex) -1)
			(setq abtl_winkel_ht (- r_winkel_at_flansch))
			(setq abtl_winkel_ht    r_winkel_at_flansch)
		)
	     ))
	     (if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(if (= (Connect.get CastaData satr-lhtr-ex)  1)
			(setq abtl_winkel_ht (+ 180.0 r_winkel_at_flansch))
			(setq abtl_winkel_ht (- 180.0 r_winkel_at_flansch))
		)
	     ))
	))
	(if (= (Connect.get CastaData amHtUnterflansch)  1) (progn
	     (if (= (Connect.get CastaData linkesEnde) 1) (progn
	     	(if (= (Connect.get CastaData satr-lhtr-ex)  1)	
			(setq abtl_winkel_ht (+ 180.0 r_winkel_at_flansch))
			(setq abtl_winkel_ht (- 180.0 r_winkel_at_flansch))
		)
	     ))
	     (if (= (Connect.get CastaData rechtesEnde) 1) (progn
	     	(if (= (Connect.get CastaData satr-lhtr-ex)  1)	
			(setq abtl_winkel_ht    r_winkel_at_flansch)
			(setq abtl_winkel_ht (- r_winkel_at_flansch))
		)
	     ))
	))
	
	; Anteil AT-Hhe / AT-Breite
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(if (= (Connect.get CastaData linkesEnde) 1)		(setq AT_Ende (Traeger.get Tr_ID links)))
		(if (= (Connect.get CastaData rechtesEnde) 1)		(setq AT_Ende (Traeger.get Tr_ID rechts)))
		
		(setq vscherl_at	(TrEnde.get AT_Ende vscherl)
					hscherl_at	(TrEnde.get AT_Ende hscherl)
		)
		(setq vscherl_at_halb (* 0.5 vscherl_at))
		(setq hscherl_at_halb (* 0.5 hscherl_at))
		
		(setq delta_v_abtl_ht (- vscherl_at_halb))
		
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	; Anteil AT-Neigung (in HT Laengsrichtung)
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(setq h_ht 				(Traeger.get Htrg h)
					delta_v_ht	(Traeger.get Htrg delta_v)
		)
		(setq h_ht_halb (* 0.5 h_ht))
		
		(setq anteil_kpl_dp	(Blech.get Blech_ID dp))
		;(setq anteil_kpl_dp	0.0)
		
		(if (= (Connect.get CastaData amHtOberflansch) 1)		(setq anteil_uz (- (+ h_ht_halb anteil_kpl_dp) delta_v_ht))	)
		(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq anteil_uz (+ (+ h_ht_halb anteil_kpl_dp) delta_v_ht))	)
		
		(print anteil_uz)
		
		(setq v_at_winkel_flansch (Connect.get CastaData v-atrgewnkl_flansch))
		(setq h_at_winkel_flansch (Connect.get CastaData h-atrgewnkl_flansch))
		(print v_at_winkel_flansch)
		(print h_at_winkel_flansch)
		
		(if (/= (Connect.get CastaData satr-shtr) 0)	(setq at_winkel (- 180.0 v_at_winkel_flansch)))
		(if (/= (Connect.get CastaData vatr-shtr) 0)	(setq at_winkel h_at_winkel_flansch))
		(print at_winkel)
		
		(setq tanW (tan (/ (* PI at_winkel) 180.0)))
		(setq sinW (sin (/ (* PI at_winkel) 180.0)))
		(print tanW)
		
		(setq anteil_neigung (/ anteil_uz tanW))
		(print anteil_neigung)
		
		(if (/= (Connect.get CastaData satr-shtr) 0)
			(progn
				(if (= (Connect.get CastaData linkesEnde)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_neigung)))
				(if (= (Connect.get CastaData rechtesEnde)  1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_neigung)))
			)
		)
		(if (/= (Connect.get CastaData vatr-shtr) 0)
			(progn
				(if (= (Connect.get CastaData linkesEnde)  1)	(setq delta_lr_abtl_ht (+ (* 1.0 delta_lr_abtl_ht) anteil_neigung)))
				(if (= (Connect.get CastaData rechtesEnde)  1)	(setq delta_lr_abtl_ht (- (* 1.0 delta_lr_abtl_ht) anteil_neigung)))
			)
		)
		(print delta_lr_abtl_ht)
		;(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_neigung)))
		;(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_neigung)))
		;(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_lr_abtl_ht anteil_neigung))
		;(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_lr_abtl_ht (- anteil_neigung)))
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	; Anteil delta_v Verschiebung AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(setq delta_v_at (Traeger.get Tr_ID delta_v))
		
		(if (/= sinW 0.0)
			(setq anteil_delta_v_at (/ delta_v_at sinW))
			(setq anteil_delta_v_at 0)
		)
		; neu angpeasst - AF-04-2012
		(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_at))

	; ----------------------------------------------
	))
	; ----------------------------------------------

	; delta_lr Anbauteil HT
	; ----------------------------------------------
    (if (= 1 1)	(progn
	; ----------------------------------------------
	(print "ANTEIL DELTA_LR AT")
	; Anteil delta_lr Verschiebung AT
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	
;	(if (/= sinW 0.0)
;		(setq anteil_delta_lr_at (/ delta_lr_at sinW))
;		(setq anteil_delta_lr_at 0)
;	)

	; neu aufgebaut - AF 11-2012		
	(setq sinRW (sin (/ (* PI abtl_winkel_ht) 180.0)))
	(setq cosRW (cos (/ (* PI abtl_winkel_ht) 180.0)))
	
	(setq anteil_delta_lr_at (* 1.0 delta_lr_at))
;	(setq anteil_dv  (* sinRW (* 1.0 delta_lr_ht)))			; >> delta_v_abtl_ht


	(print anteil_delta_lr_at)
	(print delta_v_abtl_ht)

	; neu aufgebaut - AF -04-2012
	(if (= (Connect.get CastaData amHtOberflansch)  1) (progn
		(if (= (Connect.get CastaData linkesEnde)  1)  (setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_delta_lr_at)))
		(if (= (Connect.get CastaData rechtesEnde)  1) (setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_delta_lr_at)))
	))
	(if (= (Connect.get CastaData amHtUnterflansch)  1) (progn
		(if (= (Connect.get CastaData rechtesEnde)  1)  (setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_delta_lr_at)))
		(if (= (Connect.get CastaData linkesEnde)  1)   (setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_delta_lr_at)))
	))


	; ----------------------------------------------
    ))
	; ----------------------------------------------
	(print delta_lr_abtl_ht)

	
    (if (= 1 1) (progn	
	(print "NEIGUNG HORIZONTAL")
	; Anteil AT-Neigung (horiz.)
	(setq 	h_ht 		(Traeger.get Htrg h)
		delta_v_ht	(Traeger.get Htrg delta_v)
	)
	(setq h_ht_halb (* 0.5 h_ht))
	
	(setq kpl_dp 			(Blech.get Blech_ID dp))
	(setq kpl_dp (* 1.0 kpl_dp))
	
	(setq anteil_stz (+ (* 1.0 delta_v_ht) (+ h_ht_halb kpl_dp)))
	(print anteil_stz)
	
	(setq at_rwinkel (Connect.get CastaData at_rotawinkel))
	(print at_rwinkel)
	
	(setq tanRW (tan (/ (* PI at_rwinkel) 180.0)))
	(print tanRW)
	
	(setq anteil_hneigung (* anteil_stz tanRW))
	(print anteil_hneigung)

    (if (= 100 100) (progn ; *********************###############********************	
	(if (= (Connect.get CastaData amHtUnterflansch)  1) (progn
		(if (= (Connect.get CastaData rechtesEnde)  1)
			(progn
				(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_hneigung)))
				(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_hneigung)))
				(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_hneigung)))
				(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_hneigung)))
			)
		)
		(if (= (Connect.get CastaData linkesEnde)  1)
			(progn
				(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_hneigung)))
				(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_hneigung)))
				(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_hneigung)))
				(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_hneigung)))
			)
		)
	    ); progn
	    (progn
		(if (= (Connect.get CastaData rechtesEnde)  1)
			(progn
				(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_hneigung)))
				(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_hneigung)))
				(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_hneigung)))
				(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_hneigung)))
			)
		)
		(if (= (Connect.get CastaData linkesEnde)  1)
			(progn
				(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_hneigung)))
				(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_hneigung)))
				(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_hneigung)))
				(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_hneigung)))
			)
		)
	))
)) ; *********************###############********************	
	(print delta_v_abtl_ht)
))



	; Anteil delta_lr Verschiebung HT
	; ----------------------------------------------
	(if (= 1 1)	(progn
		; ----------------------------------------------
		(setq delta_lr_ht (Traeger.get Htrg delta_lr))
		(print delta_lr_ht)

		; neu aufgebaut - AF 04-2012		
		(setq sinRW (sin (/ (* PI abtl_winkel_ht) 180.0)))
		(setq cosRW (cos (/ (* PI abtl_winkel_ht) 180.0)))
		
		(setq anteil_dlr (* cosRW (* 1.0 delta_lr_ht)))
		(setq anteil_dv  (* sinRW (* 1.0 delta_lr_ht)))
		
		(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_dlr))
		(setq delta_v_abtl_ht  (+ delta_v_abtl_ht  anteil_dv))
	
		(print delta_lr_abtl_ht)
	; ----------------------------------------------
	))
	; ----------------------------------------------

	; Korrektur AF - Juli 2009 -----------------------
;	(if (= (Connect.get CastaData amHtOberflansch) 1) (progn
;	   (if (= (Connect.get CastaData rechtesEnde) 1) (setq delta_lr_abtl_ht (- delta_lr_abtl_ht)))
;	))
;	(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
;	   (if (= (Connect.get CastaData linkesEnde) 1) (setq delta_lr_abtl_ht (- delta_lr_abtl_ht)))
;	))
	; Korrektur AF - Juli 2009 -(Ende)-----------------
	
	(Traeger.addAbtl Htrg Lochb_ID xPos_ht abtl_winkel_ht FLANSCH)
	
	(setq lb_abtl_at (Traeger.get Tr_ID Abteil Lochb_ID))
	(setq lb_abtl_ht (Traeger.get Htrg Abteil Lochb_ID))

	
	(Anbauteil.set lb_abtl_at (Master 	0)
				(delta_v  	delta_v_abtl_at)
	)
	(Anbauteil.set lb_abtl_ht (Master 	1)
				(delta_v 	delta_v_abtl_ht)
				(delta_lr 	delta_lr_abtl_ht)
	)
	
	(HolloBolt_Test Lochb_ID)

	
	; AF - 04-2012 -	Fr asymmetrische Lochbilder Richtung anpassen
	;			Bei Gegenanschlssen aber kritisch - nochmal berarbeiten
	(if (= (Connect.get CastaData amHTUnterflansch ) 1) (progn
	        (if (= (Connect.get CastaData RechtesEnde) 1) (progn
			(Anbauteil.set lb_abtl_ht	(SeitRicht 	-1))
	        ))
	))
	(if (= (Connect.get CastaData amHTOberflansch ) 1) (progn
	        (if (= (Connect.get CastaData LinkesEnde) 1) (progn
			(Anbauteil.set lb_abtl_ht	(SeitRicht 	-1))
	        ))
	))
	
	; **************************************************************************************
	; Lochbild Test
	; **************************************************************************************
	(if (= LB_DEBUG 1) (progn
		(print "LB_DEBUG")
		(setq dummy (Lochbild.create))
		(Lochbild.copy dummy Lochb_ID)
		
		(if (= (Connect.get CastaData linkesEnde) 1)
			(Traeger.addAbtl Tr_ID dummy 0.0 0.0 _kpllochbildlinks_)
		)
		(if (= (Connect.get CastaData rechtesEnde) 1)
			(Traeger.addAbtl Tr_ID dummy 0.0 0.0 _kpllochbildrechts_)
		)
	
	
		(setq AT_ABTeil_dummy (Traeger.get Tr_ID AbTeil dummy))
		(Anbauteil.set AT_ABTeil_dummy 	(delta_v		delta_v_abtl_at)
																		(Master    1)
		)
	
		(Connect.storeAnschlObjs CastaData dummy)
	))
	; **************************************************************************************
	(print "<-----------------------------------------------------------")	
)


; ----------------------------------------------------------------------------------------
; Verlngert bzw. Verkrzt das Sttzenende
; ----------------------------------------------------------------------------------------
(defun korrigiereStzEnde ()
	(print ">-----------------------------------------------------------")
	(print "KORRIGIERE STZ-ENDE")
	(print "------------------------------------------------------------")
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(progn
			(setq delta_l_stz (- rand))
			(setq HT_Ende (Traeger.get Htrg links))
		)
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(progn
			(setq delta_l_stz (- rand))
			(setq HT_Ende (Traeger.get Htrg rechts))
		)
	)
	
	(setq delta_l_alt (TrEnde.get Ht_Ende delta_l))
	(print delta_l_alt)
	(print rand)
	
	(setq delta_l_stz (- delta_l_alt rand))
	
	(TrEnde.set HT_Ende (delta_l delta_l_stz))
	(print "<-----------------------------------------------------------")	
)


; ----------------------------------------------------------------------------------------
; berprft, ob der Anschluss in der bestehenden Positionierung eingebaut werden kann
; ----------------------------------------------------------------------------------------
(defun checkPosition (Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "BERPRFE POSITION")
	
	; Oberkante HT
	(setq	b_ht 		(Traeger.get Htrg b)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	(setq	b_ht_halb	(* 0.5 b_ht))
	
	(setq	h_at		(Traeger.get Tr_ID h)
		b_at		(Traeger.get Tr_ID b)
		delta_v_at	(Traeger.get Tr_ID delta_v)
		delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	(setq	h_at_halb	(* 0.5 h_at))
	(setq	b_at_halb	(* 0.5 b_at))
	
	(setq	kpl_hp		(Blech.get Blech_ID hp)
				kpl_bp			(Blech.get Blech_ID bp)
	)
	(setq kpl_hp_halb	(* 0.5 kpl_hp))
	(setq kpl_bp_halb	(* 0.5 kpl_bp))
	
	
	(setq rGrenze_ht (+ delta_lr_ht b_ht_halb))
	(setq lGrenze_ht (- rGrenze_ht b_ht))
	(print rGrenze_ht)
	(print lGrenze_ht)
	
	(if (= (Connect.get CastaData satr-shtr)  1)
		(progn
			(setq rGrenze_kpl	(+ delta_lr_at kpl_bp_halb))
			(setq lGrenze_kpl (- rGrenze_kpl kpl_bp))
		)
	)
	(if (= (Connect.get CastaData satr-shtr) -1)
		(progn
			(setq rGrenze_kpl	(+ (- delta_lr_at) kpl_bp_halb))
			(setq lGrenze_kpl (- rGrenze_kpl kpl_bp))
		)
	)
	(if (= (Connect.get CastaData vatr-shtr)  1)
		(progn
			(setq rGrenze_kpl	(+ delta_v_at kpl_hp_halb))
			(setq lGrenze_kpl (- rGrenze_kpl kpl_hp))
		)
	)
	(if (= (Connect.get CastaData vatr-shtr) -1)
		(progn
			(setq rGrenze_kpl	(+ (- delta_v_at) kpl_hp_halb))
			(setq lGrenze_kpl (- rGrenze_kpl kpl_hp))
		)
	)
	(print rGrenze_kpl)
	(print lGrenze_kpl)
	
	(setq KopfplatteZuGross 0)
	
	(if (>= lGrenze_kpl lGrenze_ht)
		(progn
			(if (<= rGrenze_kpl rGrenze_ht)
				(progn
					(print "OK")
				)
				(progn
					(setq KopfplatteZuGross 1)
				)
			)
		)
		(progn
			(setq KopfplatteZuGross 1)
		)
	)
	(if (= KopfplatteZuGross 1) (progn
		(setq qTyp_HT (Traeger.get HTrg qsform))
		(if (= qTyp_HT "K") (progn
			(setq 	Bl_dOK (Blech.get Blech_ID dOK)
				Bl_hp  (Blech.get Blech_ID hp)
			)
			; man knnte noch untersuchen, wie das Blech an den HT geschweit werden soll
			(setq dOK_neu (- Bl_dOK (* 0.5 (-  b_HT Bl_hp))))
			(Blech.set Blech_ID (hp b_HT) (dOK dOK_neu))
		  )
		  (progn
		  	; debug - ersetzen durch allertbox
			(print "Die Kopfplatte reicht ber die Flanschseiten des Haupttrgers hinaus.\nBitte korrigieren Sie die Positionierung der Trger oder passen Sie die Kopfplatte an!" "NOTE_HeadplateReachesAboutFlangearea")
		))
	))
	
	(print "<-----------------------------------------------------------")
)

(defun HolloBolt_Test (Lochb_ID)
	(setq qTyp_HT (Traeger.get HTrg qsform))
	(if (= qTyp_HT "K") (progn
		(Anbauteil.set lb_abtl_at (Master 	1))
		(Anbauteil.set lb_abtl_ht (Master 	0))

		(Lochbild.set Lochb_ID 	(Montage 	7)
					(dxSKopf	0)
		)

	))
)

(defun htLochbildVerschiebung ()
;    (Lochbild.set kpl_lochbild (w "0 0") (e "0 30 120 0 0 0"))

    (if (= (Connect.get CastaData linkesEnde) 1)		(setq AT_Ende (Traeger.get Tr_ID links)))
    (if (= (Connect.get CastaData rechtesEnde) 1)		(setq AT_Ende (Traeger.get Tr_ID rechts)))

    (setq	VE_Winkel	(TrEnde.get  AT_Ende V_Winkel)
		HE_Winkel	(TrEnde.get  AT_Ende H_Winkel)
    )
    (if (= (* 1 HE_Winkel) 90) (htLochbildVerschiebung_VW AT_Ende VE_Winkel))
    (if (= (* 1 VE_Winkel) 90) (htLochbildVerschiebung_HW AT_Ende HE_Winkel))

)
; --------------------------------------------------------------------------
(defun	htLochbildVerschiebung_VW (AT_Ende  VE_Winkel)


    (setq	abtl_HT_Lochb (Traeger.get HTrg ABTeil kpl_lochbild)) ; Anbauteil ermitteln
    (setq	RWinkel_LB (Anbauteil.get abtl_HT_Lochb Winkel))

		
    (setq	vscherl_at	(TrEnde.get AT_Ende vscherl)
	  	hscherl_at	(TrEnde.get AT_Ende hscherl)
	  	vscherl_at_halb (* 0.5 vscherl_at)
	  	hscherl_at_halb (* 0.5 hscherl_at)
    )

    (setq	delta_v_At	(Traeger.get Tr_ID delta_v)
		delta_lr_At	(Traeger.get Tr_ID delta_lr)
		
		delta_v_At	(* 1.0 delta_v_At)			; in real umwandeln
		delta_lr_At	(* 1.0 delta_lr_At)
    )
    (setq	dp (Blech.get kpl_blech dp))
    (setq	delta_dp_Ges  0.0)
    (setq	delta_dp_V    0.0)
    (setq	delta_dp_H    0.0)

    (setq glVWinkel_1 (Connect.get CastaData afl_vwinkel))
    (print glVWinkel_1)
    (setq glVWinkel VE_Winkel)
    (if (> glVWinkel 90.0) (setq glVWinkel (- 180.0 glVWinkel)))


	(setq	Alfa_R	(TrEnde.get AT_Ende Alfa_R)
		Alfa_V2	(TrEnde.get AT_Ende Alfa_V2)
	)

	(print VE_Winkel)
	(print HE_Winkel)
	(print Alfa_R)
	(print Alfa_V2)

	(setq sinAR (sin (/ (* PI Alfa_R) 180.0)))
	(setq cosAR (cos (/ (* PI Alfa_R) 180.0)))

	(setq tanBe1 0)
	(if (< Alfa_V2 89.5) (setq tanBe1 1))
	(if (> Alfa_V2 90.5) (setq tanBe1 1))
	(if (> tanBe1 0) (progn
		(setq tanVEW (tan (/ (* PI Alfa_V2) 180.0)))
		(setq delta_dp_V (/ (* 1.0 dp) tanVEW))

		(setq tanVEW (tan (/ (* PI VE_Winkel) 180.0)))
;		(setq delta_dp_V (/ (* 1.0 dp) tanVEW))
	))

	(setq tanBe1 0)
	(if (< HE_Winkel 89.5) (setq tanBe1 1))
	(if (> HE_Winkel 90.5) (setq tanBe1 1))
	(if (> tanBe1 0) (progn
		(setq tanHEW (tan (/ (* PI HE_Winkel) 180.0)))
		(setq delta_dp_H (/ (* 1.0 dp) tanHEW))
	))
	
;	(setq delta_dp_H 0.0 delta_dp_V 0.0)
	
    (Anbauteil.set abtl_HT_Lochb (delta_V 0.0) (delta_LR 0.0))

    (setq delta_LR_Abtl_HT	 0.0)
    (setq delta_V_Abtl_HT 	(- vscherl_at_halb))
    (setq delta_V_Abtl_HT 	(+ delta_V_Abtl_HT delta_dp_V))
    

    (setq vVersch    0.0)
    (setq tanBe1 0)
    (if (< glVWinkel 89.5) (setq tanBe1 1))
    (if (> glVWinkel 90.5) (setq tanBe1 1))
    (if (> tanBe1 0) (progn
	(setq tanVW (tan (/ (* PI glVWinkel) 180.0)))
	(setq delta_dp_H (/ (* 1.0 dp) tanVW))
	
	(setq	h_HT 	(Traeger.get HTrg h)
		dv_HT	(Traeger.get HTrg delta_V)
	)

	(if (= (Connect.get CastaData amHtUnterFlansch) 1) (setq dv_HT (- dv_HT)))

	(setq vVersch    (/ (- (* 1.0 dv_HT) (* 0.5 h_HT)) tanVW))

    ))

    (if (= (Connect.get CastaData linkesEnde)  1) (if (=  glVWinkel VE_Winkel)     (setq vVersch (- vVersch))))
    (if (= (Connect.get CastaData rechtesEnde) 1) (if (/= glVWinkel VE_Winkel)     (setq vVersch (- vVersch))))


    (setq sinVW (sin (/ (* PI glVWinkel) 180.0)))
    (if (= (Connect.get CastaData amHtUnterFlansch) 1) (setq vVersch (- vVersch)))
    (if (= (Connect.get CastaData amHtUnterFlansch) 1) (setq delta_v_At (- delta_v_At)))
    (setq vVersch    (- vVersch (/ delta_v_At sinVW)))
    
    (setq sinLbW (sin (/ (* PI RWinkel_LB) 180.0)))
    (setq cosLbW (cos (/ (* PI RWinkel_LB) 180.0)))
    (setq tanLbW (tan (/ (* PI RWinkel_LB) 180.0)))

    (setq delta_V_Abtl_HT  (* cosLbW  delta_dp_H))

    (setq dlr_HT (Traeger.get HTrg delta_LR) dlr_HT (* 1.0 dlr_HT))
    (setq dlr_LB (*    cosLbW   dlr_HT))
    (setq dv_LB  (* (- sinLbW)  dlr_HT))


    (if (= (Connect.get CastaData linkesEnde)  1) (setq delta_LR_Abtl_HT (- delta_lr_At)))
    (if (= (Connect.get CastaData rechtesEnde) 1) (setq delta_LR_Abtl_HT    delta_lr_At))

    (if (= (Connect.get CastaData amHTOberFlansch)  1) (progn
	(setq delta_V_Abtl_HT 	(- delta_V_Abtl_HT vscherl_at_halb vVersch dv_LB))
    ))
    (if (= (Connect.get CastaData amHTUnterFlansch)  1) (progn
    	(setq delta_LR_Abtl_HT (- delta_LR_Abtl_HT))
        (setq delta_V_Abtl_HT 	(- delta_V_Abtl_HT vscherl_at_halb (- vVersch) dv_LB))
    ))


    (setq delta_LR_Abtl_HT (+ delta_LR_Abtl_HT dlr_LB))

    (Anbauteil.set abtl_HT_Lochb (delta_V	delta_V_Abtl_HT)
    				 (delta_LR	delta_LR_Abtl_HT)
    )

    (setq abtl_AT_Lochb (Traeger.get Tr_ID ABTeil kpl_lochbild))
    
    (setq delta_V_Abtl_AT (* cosAR (* cosLbW  delta_dp_H)))
    (Anbauteil.set abtl_AT_Lochb (delta_V	  delta_V_Abtl_AT))

;   ------------------ Testszenario - Datenkontrolle 
;   (Lochbild.set kpl_lochbild (LB_Art 0) (w "100 0"))
;   (Anbauteil.set abtl_AT_Lochb (Master	  1))
;   (Anbauteil.set abtl_HT_Lochb (Master	  0))
;   (Connect.showAttributes CastaData)

)
(defun pruefeEinachsigSchraeg ()
    (if (= (Connect.get CastaData linkesEnde) 1)		(setq AT_Ende (Traeger.get Tr_ID links)))
    (if (= (Connect.get CastaData rechtesEnde) 1)		(setq AT_Ende (Traeger.get Tr_ID rechts)))
    (setq	VE_Winkel	(TrEnde.get  AT_Ende V_Winkel)
		HE_Winkel	(TrEnde.get  AT_Ende H_Winkel)
    )
    (setq	VE_Winkel (* 1 VE_Winkel)
    		HE_Winkel (* 1 HE_Winkel)
    )
    (setq Anschluss_OK 0)
    (if (= VE_Winkel 90) (setq Anschluss_OK 1))
    (if (= HE_Winkel 90) (setq Anschluss_OK 1))
)

(defun	htLochbildVerschiebung_HW (AT_Ende  HE_Winkel)

    (setq	abtl_HT_Lochb (Traeger.get HTrg ABTeil kpl_lochbild)) ; Anbauteil ermitteln
    (setq	RWinkel_LB (Anbauteil.get abtl_HT_Lochb Winkel))

		
    (setq	vscherl_at	(TrEnde.get AT_Ende vscherl)
	  	hscherl_at	(TrEnde.get AT_Ende hscherl)
	  	vscherl_at_halb (* 0.5 vscherl_at)
	  	hscherl_at_halb (* 0.5 hscherl_at)
    )

    (setq	delta_v_At	(Traeger.get Tr_ID delta_v)
		delta_lr_At	(Traeger.get Tr_ID delta_lr)
		
		delta_v_At	(* 1.0 delta_v_At)			; in real umwandeln
		delta_lr_At	(* 1.0 delta_lr_At)
    )
    (setq	dp (Blech.get kpl_blech dp))

    (setq	delta_v_Ht	(Traeger.get HTrg delta_v)
		delta_lr_Ht	(Traeger.get HTrg delta_lr)
		h_HT		(Traeger.get HTrg h)
    )


    (setq glVWinkel HE_Winkel)
;    (if (> glVWinkel 90.0) (setq glVWinkel (- 180.0 glVWinkel)))


    (setq 	delta_V_Abtl_HT	 	(- vscherl_at_halb))
    (setq	delta_LR_Abtl_HT	0.0)

    (setq dp         (* 1.0 dp))
    (setq delta_v_Ht (* 1.0 delta_v_Ht))

    (print delta_v_Ht)
    (print dp)
    (print h_HT)
    (print glVWinkel)
    (print RWinkel_LB)

	(setq sinHW (sin (/ (* PI glVWinkel) 180.0)))
	(setq cosHW (cos (/ (* PI glVWinkel) 180.0)))
	(setq tanHW (tan (/ (* PI glVWinkel) 180.0)))

        ; Fall seitliche Verschiebung des AT
        (setq dlr_Anteil_AT (/  delta_lr_At sinHW))
        (if (= (Connect.get CastaData rechtesEnde)  1) (setq dlr_Anteil_AT (/  delta_lr_At (- sinHW))))

	
	(setq delta_LR_Abtl_HT (/ (+ (- (* 0.5 h_HT) delta_v_Ht) dp) tanHW))
        (setq delta_LR_Abtl_HT (- delta_LR_Abtl_HT dlr_Anteil_AT))
	; Fall am Unterflansch des Hautptrgers ....
        (if (= (Connect.get CastaData amHTUnterFlansch)  1) (progn
		(setq delta_LR_Abtl_HT (/ (+  (- (* 0.5 h_HT)) (- delta_v_Ht)  (- dp)) tanHW))
        	(setq delta_LR_Abtl_HT (+ delta_LR_Abtl_HT dlr_Anteil_AT))
	))

    ; Fall seitliche Verschiebung des Hautptrgers ....
    ; dieser Fall ist bei allen Winkeln des AT zum Ht gleich
    (setq sinLbW (sin (/ (* PI RWinkel_LB) 180.0)))
    (setq cosLbW (cos (/ (* PI RWinkel_LB) 180.0)))
    (setq tanLbW (tan (/ (* PI RWinkel_LB) 180.0)))

    (setq dlr_HT (Traeger.get HTrg delta_LR) dlr_HT (* 1.0 dlr_HT))
    (setq dlr_LB (*    cosLbW   dlr_HT))
    (setq dv_LB  (* (- sinLbW)  dlr_HT))

    (setq delta_LR_Abtl_HT (+ delta_LR_Abtl_HT dlr_LB))
    (setq delta_V_Abtl_HT  (- delta_V_Abtl_HT dv_LB))

    ; Fall: vertikale Verschiebung es AT
    (setq delta_V_Abtl_HT  (+ delta_V_Abtl_HT delta_v_At))

    (Anbauteil.set abtl_HT_Lochb (delta_V	delta_V_Abtl_HT)
    				 (delta_LR	delta_LR_Abtl_HT)
    )


    ; Verschiebung am AT - Anschlusstrger
    (setq abtl_AT_Lochb (Traeger.get Tr_ID ABTeil kpl_lochbild))
    (Anbauteil.set abtl_AT_Lochb (delta_V	  0.0))			;; muss hier korrigiert werden
    									;; weil anderswo gesetzt

;   ------------------ Testszenario - Datenkontrolle 
;   (setq wLchb (Lochbild.get kpl_lochbild w0))
;   (print wLchb)
;   (Lochbild.set kpl_lochbild (LB_Art 2) (w0 (* 0.5 wLchb)))
;   (Anbauteil.set abtl_AT_Lochb (Master	  1))
;   (Anbauteil.set abtl_HT_Lochb (Master	  0))
;   (Connect.showAttributes CastaData)


)


(defun anpassen_QRR_Profile ()

	(setq blKpl kpl_blech)
	(setq lchbKpl   kpl_lochbild)

    (setq qsType_HT (Traeger.get HTrg  qsForm))
    (setq qsType_AT (Traeger.get Tr_ID qsForm))
	
	(setq qrr_attach 0)
	(if (= qsType_HT "K") (if (= qsType_AT "K") (setq qrr_attach 1)))
	(if (= (Connect.get CastaData vatr-lhtr) 0)  (setq qrr_attach 0))
	
	(if (= qrr_attach 1) (progn
		(setq dp (Blech.get blKpl dp))
		(setq bp (Blech.get blKpl bp))
		(setq b_AT (Traeger.get Tr_ID b))
		(setq sD (Lochbild.get lchbKpl sdurchm))
	   
		(setq b_Vorh 0)
		(if (= (Connect.get CastaData amhtsteg)    1)  (setq b_Vorh (Traeger.get HTrg h)))
		(if (= (Connect.get CastaData amhtflansch) 1)  (setq b_Vorh (Traeger.get HTrg b)))

		(setq aendereBlech 0)
		(if (> b_AT (+ bp 10)) (setq aendereBlech 1))
		(if (> bp b_Vorh)      (setq aendereBlech 1))

		
		(if (= aendereBlech 1) (progn
			(setq h_AT (Traeger.get Tr_ID h))
			(setq ueberstand (* 5.0 sD))
			(setq ueberstand (runde ueberstand auf 10))
			(setq hp (+ h_AT ueberstand ueberstand))

			(Blech.set blKpl (hp hp) (dOK (- ueberstand)))
			(Lochbild.set lchbKpl 
						(e0 		(- (* 0.5 ueberstand)))
						(e1 		(+ h_AT ueberstand))
			)
		))

		(if (> bp b_Vorh) (progn
			(setq w_Neu  (- b_Vorh (* 4 sD)))
			(if (> w_Neu (* 4 sD)) (progn

				(Blech.set blKpl 		(bp b_Vorh))
			
				(Lochbild.set lchbKpl 	(w0 w_Neu))
			))
		))

		
	))

)