; $ AT	QT(F)		AF(K)		P(E)
; $	AE	V(-)		H(-)		R(0.0)

(defun load-modules ()
   (load "mod-lochbild")
	 (load "mod-utils")
)

(defun init-connection ()
	(print "*clear*")
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(connect.showattributes CastaData)
	(setq LB_DEBUG 0)
	
	;(simpleTrim) ; AF - Mrz 2008 
	
	(setConnection)
)






; ****************************************************************************************
; Erzeugt die Verbindung
; ****************************************************************************************
(defun setConnection ()
	(print ">-------------------------------------------------------------------------------")
	(print "ERZEUGE VERBINDUNG")
	
	(if (= (Connect.get CastaData linkesEnde)  1)	(setq At_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq At_Ende (Traeger.get Tr_ID rechts)))

	; Objekte erzeugen
	; ---------------------------------------------
	(setq atKpl					(Blech.Create))
	(setq kpl_lb				(Lochbild.Create))
	
	(Connect.storeAnschlObjs CastaData atKpl kpl_lb)
	
	(kuerzeAtEnde)
	
	(calcAtKpl atKpl)
	(createAtKpl atKpl)
	
	(calcKplLB kpl_lb)
	(createKplLB kpl_lb)

	(addKonsolenVerstaerkung)
	(Blech.set SchrgBlch (formFkt "cb_schrg_blech"))

)
; ****************************************************************************************
(defun cb_schrg_blech (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq hpAlt (Blech.get SchrgBlch hp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq hpNeu (Blech.get SchrgBlch hp))

		(if (/= hpAlt hpNeu) (progn
			(setq hpDiff (- hpAlt hpNeu))
			(if (= (Connect.get CastaData linkesEnde) 1) (progn
				(Blech.set SchrgBlch (dOK (* -0.5 hpNeu)))
				
				(setq Schrg_X (Blech.get SchrgBlch x4))
				(setq Schrg_X (- Schrg_X hpDiff))
				(Blech.set SchrgBlch (x4 Schrg_X))
			))
			(if (= (Connect.get CastaData rechtesEnde) 1) (progn
				(Blech.set SchrgBlch (dOK (* 0.5 hpNeu)))


				(setq Schrg_X (Blech.get SchrgBlch x1))
				(setq Schrg_X (- Schrg_X hpDiff))
				(Blech.set SchrgBlch (x1 Schrg_X))
			))
			
		))
		
	))
)

; ****************************************************************************************
; Krzt das Trgerende
; ****************************************************************************************
(defun kuerzeAtEnde ()
	(print ">-------------------------------------------------------------------------------")
	(print "KUERZE TRAEGERENDE")
	; erstmal alles zurcksetzen
	(resetAtEnde)
	
	(Connect.showAttributes CastaData)
	
	(if (= (Connect.get CastaData linkesEnde)  1)	(setq At_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq At_Ende (Traeger.get Tr_ID rechts)))

	(setq	xPos_AT (Connect.get CastaData xPos_AT)
				VWinkel (Connect.get CastaData v-atrgewnkl_steg)
				HWinkel (Connect.get CastaData h-atrgewnkl_steg)
	)
	
	(setq	xPos_AT 	(Connect.get CastaData xPos_AT)
		VWinkel 	(Connect.get CastaData v-atrgewnkl_kopf)
		HWinkel		(Connect.get CastaData h-atrgewnkl_kopf)
	)
	
	
	(setq	TrgLaenge (Traeger.get Tr_ID syslng))

	
	(if (= (Connect.get CastaData linkesEnde)  1) (setq deltaL xPos_AT))
	(if (= (Connect.get CastaData rechtesEnde) 1) (setq deltaL (- TrgLaenge xPos_AT)))
	
	(setq dl_Additional (Connect.get CastaData additional_delta_l))
	(setq deltaL (+ deltaL dl_Additional))		; neu ab Version 7.01 (Wert additional_delta_l)
	
	(TrEnde.set At_Ende	(delta_l 	 deltaL)
				(V_Winkel	 VWinkel)
				(H_Winkel	 HWinkel)
	)
	
	(print "<-------------------------------------------------------------------------------")
)

; ****************************************************************************************
; Berechnet die Kopfplatte
; ****************************************************************************************
(defun calcAtKpl (KPL_ID)
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE KOPFPLATTE")
	
	(setq	h_at 	(Traeger.get Tr_ID h)
			b_at	(Traeger.get Tr_ID b)
			t_at	(Traeger.get Tr_ID t)
	)
	
	; Hoehe
	; ---------------------------------------------
	(setq kpl_hp (- h_at t_at))
	(if (< kpl_hp 100) (setq kpl_hp 100))
	(setq kpl_hp_rund (runde kpl_hp auf 5.0))
	
	; Breite
	; ---------------------------------------------
	(setq kpl_bp b_at)
	(if (< kpl_bp 100) (setq kpl_bp 100))
	(setq kpl_bp_rund (runde kpl_bp auf 5.0))
	
	; Dicke
	; ---------------------------------------------
	(setq kpl_dp t_at)
	(setq kpl_dp_rund (runde kpl_dp auf 5.0))
	
	(setq dOK_Kpl (* 0.5 (- kpl_hp_rund h_at)))
	(setq qsForm_AT (Traeger.get Tr_ID qsForm))
	(if (= qsForm_AT "F") (progn
		(setq dOK_Kpl (* 0.5 (- kpl_hp_rund t_at)))
	))
	(setq dOK_Kpl (* -0.5 kpl_hp))

	(setq t_AT (Traeger.get Tr_ID t))
	(setq dOK_Kpl (- -70 (* 0.5 t_AT)))

	; Werte zuweisen
	; ---------------------------------------------
	(Blech.set KPL_ID	(hp 	kpl_hp_rund)
						(bp 	kpl_bp_rund)
						(dp 	kpl_dp_rund)
						(dok	dOK_Kpl)
	)
	
	(print "<-------------------------------------------------------------------------------")
)

; ****************************************************************************************
; Erzeugt die Kopfplatte
; ****************************************************************************************
(defun createAtKpl (KPL_ID)
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE KOPFPLATTE")
;	(if (= (Connect.get CastaData linkesEnde)  1)	(Traeger.addabtl Tr_ID KPL_ID 0.0 0.0 _fussplattelinks_))
;	(if (= (Connect.get CastaData rechtesEnde) 1)	(Traeger.addabtl Tr_ID KPL_ID 0.0 0.0 _fussplatterechts_))
	(if (= (Connect.get CastaData linkesEnde)  1)	(Traeger.addabtl Tr_ID KPL_ID 0.0 0.0 _kopfplattelinks_))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(Traeger.addabtl Tr_ID KPL_ID 0.0 0.0 _kopfplatterechts_))
	
	
	
	(setq kpl_dp (Blech.get KPL_ID dp))
	
	(TrEnde.ptrim At_Ende kpl_dp)
	(print "<-------------------------------------------------------------------------------")
)

; ****************************************************************************************
; Berechnet das Kopfplattenlochbild
; ****************************************************************************************
(defun calcKplLB (LCHB_ID)
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE KOPFPLATTENLOCHBILD")
	(Lochbild.set LCHB_ID (Anz_S 		4)
												(Lb_Art   0)
												(Guete   	"4.6")
												(Montage 	_AnkerSchraube_)
	)
	
	(setq h_at 	(Traeger.get Tr_ID h)
				b_at	(Traeger.get Tr_ID b)
				r_at	(Traeger.get Tr_ID r)
				s_at	(Traeger.get Tr_ID s)
	)
	
	(calcSchraube kpl_dp) ;--> S_Bez
	
	(Lochbild.set LCHB_ID (S_Bez S_Bez))
	(setq sd (Lochbild.get LCHB_ID sDurchm))
	(if (>= sd 20) (progn
		(setq S_Bez "M20")
		(Lochbild.set LCHB_ID (S_Bez S_Bez))
	))
	
	; e0
	; ---------------------------------------------
	(setq e0 (* 0.5 h_at))
	(setq e0_rund (runde e0 auf 5.0))
	
	(setq hp_Kpl (Blech.get atKpl hp))
	(if (<= hp_Kpl 100) (progn
		(setq e0_rund (* 0.5 hp_Kpl))
	))
		
	; w0
	; ---------------------------------------------
	;(setq helpVar (+ (* 2.0 r_at) (* 0.5 (- b_at s_at))))
	;(setq w0_rund (runde helpVar auf 5.0))
	(setq w0 (+ (* 0.5 (- b_at s_at)) s_at))
	(setq w0_rund (runde w0 auf 5.0))
	
	; Laenge
	; ---------------------------------------------
	(calcBohrLochTiefe) ;-->vba_min_tiefe
	
	(setq vb_tiefe (+ vba_min_tiefe kpl_dp))
	(print vb_tiefe)
	
	(setq e0_rund -35)
	
	(Lochbild.set LCHB_ID (e0 		e0_rund)
												(w0			w0_rund)
												(Laenge vb_tiefe)
												
	)
	
	(print "<-------------------------------------------------------------------------------")
)


; ****************************************************************************************
; Erzeugt das Kopfplattenlochbild
; ****************************************************************************************
(defun createKplLB (LCHB_ID)
	(print ">-------------------------------------------------------------------------------")
	(print "ERZEUGE KOPFPLATTENLOCHBILD")
	(if (= (Connect.get CastaData linkesEnde) 1)
		(Traeger.addabtl Tr_ID LCHB_ID 0.0 0.0 _kpllochbildlinks_)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(Traeger.addabtl Tr_ID LCHB_ID 0.0 0.0 _kpllochbildrechts_)
	)
		
	(setq Abtl_AnkLchb (traeger.get Tr_ID ABTeil LCHB_ID))
  (Anbauteil.set Abtl_AnkLchb (Master 1))
	(print "<-------------------------------------------------------------------------------")
)


(defun calcBohrLochTiefe ()
	(setq vba_min_tiefe 100.0)
	
	(if (= S_Bez "M8")	(setq vba_min_tiefe 80.0))
	(if (= S_Bez "M10")	(setq vba_min_tiefe 90.0))
	(if (= S_Bez "M12")	(setq vba_min_tiefe 110.0))
	(if (= S_Bez "M16")	(setq vba_min_tiefe 125.0))
	(if (= S_Bez "M20")	(setq vba_min_tiefe 170.0))
	(if (= S_Bez "M24")	(setq vba_min_tiefe 210.0))
	(if (= S_Bez "M27")	(setq vba_min_tiefe 250.0))
	(if (= S_Bez "M30")	(setq vba_min_tiefe 280.0))
)

(defun addKonsolenVerstaerkung ()
	(setq SchrgBlch (Blech.create))
	(setq t_AT (Traeger.get Tr_ID t))
	(setq NettoLng_AT (Traeger.get Tr_ID Laenge))
	; Blechdaten Versaerkungsblech
	(setq dp_SB (runde t_AT auf 5))
	(setq hp_SB 150)
	(setq bp_SB 200)
	
	
	(setq hp_SB (- NettoLng_AT 30))
	(Blech.set SchrgBlch (dp dp_SB) (hp hp_SB) (bp bp_SB))
	; Vorgaben fr die Abschrgung
	(setq Innen_S 20)
	(setq VertikalAnteil   20)
	(setq HorizontalAnteil 20)
	(setq Schrg_X (- hp_SB HorizontalAnteil))
	(setq Schrg_Y (- bp_SB VertikalAnteil))
	; Blechueberstand Kopfplatte unten
	(setq blUeberstand 25)
	
	
	(setq XPos 0.0)
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
		(setq TEnde (traeger.get TR_ID links))
		(setq deltaL_AT (TrEnde.get TEnde delta_L))
		(setq XPos deltaL_AT)
		(Blech.set SchrgBlch (dOK (* -0.5 hp_SB)))
		
		(Blech.set SchrgBlch (x2 Innen_S) (y2 Innen_S))
		(Blech.set SchrgBlch (x4 Schrg_X) (y4 Schrg_Y))
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(setq TEnde (traeger.get TR_ID rechts))
		(setq deltaL_AT (TrEnde.get TEnde delta_L))
		(setq SysLng_AT (Traeger.get Tr_ID sysLng))

		(setq XPos (- SysLng_AT deltaL_AT))
		(Blech.set SchrgBlch (dOK (* 0.5 hp_SB)))

		(Blech.set SchrgBlch (x3 Innen_S) (y3 Innen_S))
		(Blech.set SchrgBlch (x1 Schrg_X) (y1 Schrg_Y))
	))
	
	
	; _knotenblech_of_   _knotenblech_uf_
	(traeger.addabtl Tr_ID SchrgBlch XPos 0.0 _knotenblech_uf_)
	(Connect.storeAnschlObjs CastaData SchrgBlch)

	; Kopfplatte anpassen
	(setq hp_Kpl  (Blech.get atKpl hp))
	(setq dOK_Kpl (* 0.75 hp_Kpl))
	(setq dOK_Kpl (Blech.get atKpl dOK))
	(setq dOK_Kpl (- dOK_Kpl))
	(setq hp_Kpl (+ dOK_Kpl (* 0.5 t_AT) bp_SB blUeberstand))
	(Blech.set atKpl (hp hp_Kpl))
	; (Blech.set atKpl (dOK dOK_Kpl))
	

	; Lochbild anpassen
	(setq eo_Lb (Lochbild.get kpl_lb e0)
		  e1_Lb (Lochbild.get kpl_lb e1)
	)
	
	(setq eo_Lb (* -0.5 dOK_Kpl))
;	(setq eo_Lb 0)

	(setq t_AT (Traeger.get Tr_ID t))
	(setq e1_Lb (+ (* -2 eo_Lb) (* 0.5 t_AT)))

	(setq AbstOben (+ dOK_Kpl eo_Lb))
	(setq e2_Lb (- hp_Kpl AbstOben AbstOben e1_Lb))
	(Lochbild.set kpl_lb (e1 e1_Lb) (e2 e2_Lb))


)
