; $	HT	QT(IU)		AF(SK)		P(EZ)
; $ AT	QT(F)		AF(K)		P(E)
; $	AE	V(-)		H(-)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;	
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (load "mod-endinit-uz-uzsteg")	
   (load "mod-lochbild")
   ;(load "mod-multiconnect-stz-steg")
   (load "mod-messages")
)



(defun init-connection ()

;	(setq RWinkel (Traeger.get Tr_ID R_Winkel))
;	(Traeger.set Tr_ID (R_Winkel (+ RWinkel 5.0)))
;	(if (= (Connect.get CastaData sAtr-lHtr-ex)  1) (print "Richtung ist gleich"))
;	(if (= (Connect.get CastaData sAtr-lHtr-ex) -1) (print "Richtung ist nicht gleich"))
;	(if (= (Connect.get CastaData sAtr-lHtr-ex)  0) (print "Richtung undefiniert !!"))

;)
;(defun XXX ()

	(if (= (Connect.get CastaData amHTSteg) 1) (progn
	
		(init-traegerenden)
		(AtEnde_Anpassen)

		(setq LB_DEBUG 0)

		; Testen, ob Makro geeignet - doppelt schrg und Verschiebungen ausschlieen
		(testeAnschluss)	; erzeugte Variable: RunMakro
		(setConnection)
		
		(LochbildAusrichtung_am_HT)
		
		(if (= RunMakro 0)  (AlertBox "Achtung!\nBei dieser Konstellation besteht die Gefahr,\ndass die Schrauben nicht passen."  "Bolts_May_Not_Fit"))
		
		(if (= 1 2) (progn
			(Lochbild.set kpl_lochbild (e "0 30 70 0 0 0") (LB_Art 2) (w "40 0"))
		))
		
	    (if (= 1 2) (progn
			(setq AnschlussArt (Connect.get CastaData AnschlussArt))
			(print AnschlussArt)
			(setq AnschlussTyp (Connect.get CastaData AnschlussTyp))
			(print AnschlussTyp)
	    ))
	    (if (= LB_DEBUG 1) (progn
	    	(if (existObj lbdummy) 	(Connect.storeAnschlObjs CastaData lbdummy))
	    ))

		(if (= 1 2) (progn
			(Lochbild.set kpl_lochbild (LB_Art 2) (w "40 0"))
			(Lochbild.set kpl_lochbild (e1 30) (e2 70))
		
			(setq Ht_lb_abtl (Traeger.get Htrg Abteil kpl_lochbild))
			(setq At_lb_abtl (Traeger.get Tr_ID Abteil kpl_lochbild))
			
			; (setq sRicht-AT (Anbauteil.get At_lb_abtl SeitRicht))
			; (setq sRicht-HT (Anbauteil.get Ht_lb_abtl SeitRicht))
			(setq delta_V-AT (Anbauteil.get At_lb_abtl delta_V))
			(setq delta_V-HT (Anbauteil.get Ht_lb_abtl delta_V))
			
			; (AlertBox delta_V-AT) (AlertBox delta_V-HT)
		))

	  ); progn
	  (AlertBox "Dieses Makro kann nur fr Anschlsse am Steg eingesetzt werden!"  "Macro_Just_For_WebConnections")
	)


)
(defun testeAnschluss ()
	(setq RunMakro 1)
	(if (= (Connect.get CastaData linkesEnde)  1) (setq AT_Ende   (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1) (setq AT_Ende   (Traeger.get Tr_ID rechts)))
	(setq VWinkel_E (TrEnde.get AT_Ende V_Winkel))
	(setq HWinkel_E (TrEnde.get AT_Ende H_Winkel))

	(if (/= VWinkel_E 90.0) (progn
	     (if (/= HWinkel_E 90.0) (progn
	         (setq delta_LR_HT (Traeger.get HTrg  delta_LR)
	               delta_LR_AT (Traeger.get Tr_ID delta_LR)
	               delta_V_AT  (Traeger.get Tr_ID delta_V)
	         )
	         (if (/= delta_LR_HT 0.0) (setq RunMakro 0))
	         (if (/= delta_LR_AT 0.0) (setq RunMakro 0))
	         (if (/= delta_V_AT  0.0) (setq RunMakro 0))
	     ))
	))
)

(defun setConnection ()
	; Objekte erzeugen
	(setq kpl_blech (Blech.create))
	(Connect.storeAnschlObjs CastaData kpl_blech)


;	Schrauben bei Kastenprofilen werden zwar erzeugt aber nicht eingebaut.	
	(setq qsform_ht	(Traeger.get Htrg qsform))
	(setq kpl_lochbild (Lochbild.create))
	(Connect.storeAnschlObjs CastaData kpl_lochbild)
	
	
	; Blechdicke berechnen
	(calcAndSetKplThickness)
	
	;Schraubengre anhand der min. Blechdicke bestimmen(grobe Anhaltswerte)
	(setq min_blech_dp 10)
	(setq akt_kpl_dp (Blech.get kpl_blech dp))
	(setq s_ht (Traeger.get Htrg s))
	(if (< s_ht akt_kpl_dp)
		(setq min_blech_dp s_ht)
		(setq min_blech_dp akt_kpl_dp)
	)
	(print min_blech_dp)
	(calcSchraube min_blech_dp) ; -> S_Bez
	
	; Schraubengre dem Lochbild hinzufgen
	(Lochbild.set kpl_lochbild (S_Bez S_Bez))
	
	; min. Rand- / Lochabstnde berechnen
	(calcMinRandLochAbst kpl_lochbild) ; -> e_min, e1_min, e_min_rund, e1_min_rund, h_min
	
	; Kopfplatte berechnen
	(calcAndSetKplDaten)
	
	;Einbauposition prfen
	; (checkPosition kpl_blech)
	
	; Anbauteil Kopfplatte hinzufgen
	(setKplAbtl)
	
	(createCouponBlech)
	
  	; Lochbilddaten berechnen
	(calcAndSetLochbildDaten kpl_lochbild kpl_blech)
	; Lochbildanbauteile hinzufgen
	(setLochbildAbtl kpl_lochbild kpl_blech)
	
	; korrigiere Stz-Ende
	(if (= (Connect.get CastaData anz_weitere_anschl) 0)
		(if (= (Connect.get CastaData anschlzwhtenden) 0)
			(korrigiereStzEnde)
		)
	)
	
	; Test-Lochbild asymmetrisch	
	; (Lochbild.set kpl_lochbild (e "0 30 100 0 0 0") (w0 0) (LB_Art 2))
	
	; Callbacks
  (Blech.set kpl_blech 		(formFkt "cb_kplblech"))
  (Blech.set cpFrontBlech 	(formFkt "cb_couponblech"))
  
  
  
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr die Kopfplatte
; ----------------------------------------------------------------------------------------
(defun cb_kplblech (zp)
;	(print "*clear*")
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get kpl_blech dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get kpl_blech dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml 	(Lochbild.get kpl_lochbild Klemml))
	       (setq altesDxSKopf (Lochbild.get kpl_lochbild dxSKopf))
	       (print alteKlemml)
	       (print altesDxSKopf)
	       
	       (setq klemml_neu (+ alteKlemml dpDiff))
	       (print klemml_neu)
	       
	       (Lochbild.set kpl_lochbild 	(Klemml  klemml_neu))
	       
	       (if (= (Connect.get CastaData amHtStegLinks) 1)
	       	(progn
	       		(setq dxsKopf_neu (+ altesDxSKopf dpDiff))
	       		(print dxsKopf_neu)
	       		
	       		(Lochbild.set kpl_lochbild (dxSKopf dxsKopf_neu))	 
	       	)      	
	       )
				 
				 (cbDeltaLR kpl_lochbild dpDiff)
	    ))
	))
)


; ---------------------------------------------------------------------
; Korrigiert die delta_lr Verschiebung des LB-ABTL bei einem Aufruf
; der Callbackfunktion (Dickennderung des Bleches)
; ---------------------------------------------------------------------
(defun cbDeltaLR (KPL_LB DP_DIFF)
	;(print "*clear*")
	(print ">------------------------------------------------------------------------------")
	(print "Anbauteil Korrektur wegen Callback-Funktion")
	
	; Anbauteil des HT-LB
	(setq ht_lb_abtl (Traeger.get Htrg Abteil KPL_LB))
				 
	; delta_lr Verschiebung des Anbauteils
	(setq delta_lr_abtl_alt (Anbauteil.get ht_lb_abtl delta_lr))
	(print delta_lr_abtl_alt)
	
	; Wert, um den das Anbauteil korrigiert wird (erstmal auf 0.0) 
	(setq delta_lr_abtl_neu 0.0)
	
	; Winkel des AT zum HT in horizontaler Richtung
	(setq h_wnkl_steg_at (Connect.get CastaData h-atrgewnkl_steg))
	(print h_wnkl_steg_at)
	
	(setq tanHW (tan (/ (* PI h_wnkl_steg_at) 180.0)))
	(print tanHW)
	
	(if (/= tanHW 0.0)
		(setq delta_lr_abtl_korr (/ DP_DIFF tanHW))
	)
	(print delta_lr_abtl_korr)
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq delta_lr_abtl_neu (- delta_lr_abtl_alt delta_lr_abtl_korr)))
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq delta_lr_abtl_neu (+ delta_lr_abtl_alt delta_lr_abtl_korr)))
	
	; Anbauteil korrigieren
	(print delta_lr_abtl_neu)
	(Anbauteil.set ht_lb_abtl (delta_lr delta_lr_abtl_neu))
	
	(print "<------------------------------------------------------------------------------")
)
; ----------------------------------------------------------------------------------------
; Callback fr die Kopfplatte
; ----------------------------------------------------------------------------------------
(defun cb_couponblech (zp)
;	(print "*clear*")
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
		(setq dpAlt (Blech.get cpFrontBlech dp))

		(setq abtl_CpBl (Traeger.get HTrg ABTeil cpFrontBlech))
		(setq dlrCpn_Alt (Anbauteil.get abtl_CpBl delta_LR))
	))
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get cpFrontBlech dp))
		(setq abtl_CpBl (Traeger.get HTrg ABTeil cpFrontBlech))
		(setq dlrCpn_Neu (Anbauteil.get abtl_CpBl delta_LR))
		
		(if (/= dpAlt dpNeu) (progn
			(if (= (Connect.get CastaData linkesEnde) 1) (progn	
				(setq tEnde (Traeger.get Tr_ID links))
				(TrEnde.pTrim tEnde (- dpNeu dpAlt))
			))
			(if (= (Connect.get CastaData rechtesEnde) 1) (progn	
				(setq tEnde (Traeger.get Tr_ID rechts))
				(TrEnde.pTrim tEnde (- dpNeu dpAlt))
			))
			(setq dp_Kpl (Blech.get kpl_blech dp))
			(Lochbild.set kpl_lochbild (KlemmL (+ dp_Kpl dpNeu)))
		))
		(if (/= dlrCpn_Alt dlrCpn_Neu) (progn
			(if (= (Connect.get CastaData linkesEnde) 1) (progn	
				(setq tEnde (Traeger.get Tr_ID links))
				(TrEnde.pTrim tEnde (- dlrCpn_Neu dlrCpn_Alt))
			))
			(if (= (Connect.get CastaData rechtesEnde) 1) (progn	
				(setq tEnde (Traeger.get Tr_ID rechts))
				(TrEnde.pTrim tEnde (- dlrCpn_Neu dlrCpn_Alt))
			))
		))

		
		
	))
)


; ****************************************************************************************
; HILFSFUNKTIONEN
; ****************************************************************************************

; ----------------------------------------------------------------------------------------
; Berechnet die Kopfplattendicke
; ----------------------------------------------------------------------------------------
(defun calcAndSetKplThickness ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE KOPFPLATTEN-DICKE")
	(print "------------------------------------------------------------")
	(setq t_ht (Traeger.get Htrg t))
	(setq t_at (Traeger.get Tr_ID t))
	
	(setq dp_kpl (runde t_at auf 5.0))
	(print dp_kpl)
	
	(Blech.set kpl_blech (dp dp_kpl))
	(print "<-----------------------------------------------------------")
)


; ----------------------------------------------------------------------------------------
; Berechnet die Kopfplattendaten
; ----------------------------------------------------------------------------------------
(defun calcAndSetKplDaten ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE KOPFPLATTEN-DATEN")
	(print "------------------------------------------------------------")
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID rechts)))
	
	(setq	vscherl_at	(TrEnde.get AT_Ende vscherl)
			hscherl_at	(TrEnde.get AT_Ende hscherl)
	)
	
	(setq	b_at 		(Traeger.get Tr_ID b)
			t_at 		(Traeger.get Tr_ID t)
			qsform_at	(Traeger.get Tr_ID qsform)
	)
	
	(setq abst_zum_rand e_min_rund)
	(setq abst_zum_trg (* 0.5 e_min_rund))
	(if (= qsform_at "R")
		(setq abst_zum_trg (* 0.25 e_min_rund))
	)
	
	(setq rand (+ abst_zum_rand abst_zum_trg))
	; Kopfplattenhhe
	(setq kpl_hp (+ vscherl_at (* 2.0 rand)))
	(print kpl_hp)
	
	; Kopfplattenbreite
	(setq kpl_bp (+ hscherl_at (* 2.0 rand)))
	(print kpl_bp)
	
	; Dok
	(setq kpl_dok (- rand))
	(print kpl_dok)
	
	(setq kpl_hp (+ (* 8 16) t_AT))
	(setq kpl_dok (* -0.5 kpl_hp))
	
	
	(Blech.set kpl_blech 	(hp		kpl_hp)
							(bp 	kpl_bp)
							(dok 	kpl_dok)
	)
	(print "<-----------------------------------------------------------")	
)		


; ----------------------------------------------------------------------------------------
; Hinzufgen des Kopfplatten-Anbauteils
; ----------------------------------------------------------------------------------------
(defun setKplAbtl ()
	(print ">-----------------------------------------------------------")
	(print "FGE KOPFPLATTEN-ANBAUTEIL HINZU")
	(print "------------------------------------------------------------")
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	
	(setq kpl_dp (Blech.get kpl_blech dp))
	
	(setq xPos_abtl	xPos_ht)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(setq AT_Ende (Traeger.get Tr_ID links))
			(Traeger.addAbtl Tr_ID kpl_blech xPos_abtl 0.0 _kopfplattelinks_)
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(setq AT_Ende (Traeger.get Tr_ID rechts))
			(Traeger.addAbtl Tr_ID kpl_blech xPos_abtl 0.0 _kopfplatterechts_)
		)
	)
	
	(TrEnde.pTrim AT_Ende kpl_dp)
	
	(print "<-----------------------------------------------------------")

	(setq	h_HT 	(Traeger.get HTrg h)
			dv_AT	(Traeger.get HTrg delta_V)
	)
	(setq dlr_AT (Traeger.get Tr_ID delta_LR))
	(setq bp_AT (Blech.get kpl_blech bp))

	(if (> bp_AT h_HT) (Blech.set kpl_blech (bp h_HT)))

	(setq dlr_KPL dv_AT)
	(if (= (Connect.get CastaData satr-vhtr) -1) (setq dlr_KPL (- dlr_KPL)))
	(setq dlr_KPL (- dlr_KPL dlr_AT))
	(Blech.set kpl_blech (xAsym dlr_KPL))

	
	
)

; ----------------------------------------------------------------------------------------
; Berechnet die Lochbilddaten
; ----------------------------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lochb_ID Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(print "------------------------------------------------------------")
	(Lochbild.set Lochb_ID 	(Guete  "4.6")
				(Anz_S  4)
	)
	
	(setq	kpl_hp 		(Blech.get Blech_ID hp)
			kpl_bp 		(Blech.get Blech_ID bp)
			kpl_dok 	(Blech.get Blech_ID dok)
			kpl_dp		(Blech.get Blech_ID dp)
	)
	(setq	cpl_dp 		(Blech.get cpFrontBlech dp))
	(setq 	s_ht		(Traeger.get Htrg s)
			qsform_ht	(Traeger.get Htrg qsform)
	)
	(setq 	s_ht_halb 	(* 0.5 s_ht))
	
	; e0
	(setq e0_lb (- abst_zum_trg))
	(print e0_lb)
	; e1
	(setq e1_lb (- kpl_hp (* 2.0 e_min_rund)))
	
	; w0
	(setq w0_lb (- kpl_bp (* 2.0 e_min_rund)))
	 
		
	; klemml
	(setq klemml_lb (+ cpl_dp kpl_dp))
	(print klemml_lb)
	
	; dxskopf
	(setq dxskopf_lb 0.0)
	
	(if (= qsform_ht "U")	
		(progn
			(if (= (Connect.get CastaData amHtStegLinks) 1) (setq dxskopf_lb kpl_dp))
			(if (= (Connect.get CastaData amHtStegRechts) 1) (setq dxskopf_lb 0.0))
		)
	)
	
	(print dxskopf_lb)
	
	(setq hp_Bl (Blech.get cpFrontBlech hp))
	(setq b_AT	(Traeger.get Tr_ID b))
	(setq t_AT	(Traeger.get Tr_ID t))
	
	(setq e_1 (* 0.5 hp_Bl))
	(setq e_0 (- (* 0.5 (- hp_Bl e_1))   (* 0.5 b_AT)))
	(setq sd (Lochbild.get Lochb_ID sdurchm))
	(setq w_0 (+ (* 4 sd) t_AT))
	
	(Lochbild.set Lochb_ID 	(e0		e_0)
				(e1		e_1)
				(w0		w_0)
				(klemml		klemml_lb)
				(dxsKopf	dxskopf_lb)
	)
	
	(if (= LB_DEBUG 1)
		(Lochbild.set Lochb_ID (e2 	300))
	)
	(print "<-----------------------------------------------------------")	
)


; ----------------------------------------------------------------------------------------
; Hinzufgen der Lochbild-Anbauteile
; ----------------------------------------------------------------------------------------
(defun setLochbildAbtl (Lochb_ID Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "FGE LOCHBILD-ANBAUTEILE HINZU")
	(print "------------------------------------------------------------")
	
	; AT
	; ######################################################################################
	(if (= (Connect.get CastaData linkesEnde) 1)
		(Traeger.addAbtl Tr_ID Lochb_ID 0.0 0.0 _kpllochbildlinks_)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(Traeger.addAbtl Tr_ID Lochb_ID 0.0 0.0 _kpllochbildrechts_)
	)
	
	
	(setq xPos_ht (Connect.get CastaData XPos_HT))
	
	; _couponlochbild_links_
	; _couponlochbild_rechts_
	; (Traeger.addAbtl Htrg Lochb_ID xPos_ht abtl_winkel_ht _steglochbild_system_)
	(setq abtl_winkel_ht 0.0)
	
	(if (= (Connect.get CastaData amHTStegLinks) 1) (progn
		(Traeger.addAbtl Htrg Lochb_ID xPos_ht abtl_winkel_ht _couponlochbild_links_)
	))
	(if (= (Connect.get CastaData amHTStegRechts) 1) (progn
		(Traeger.addAbtl Htrg Lochb_ID xPos_ht abtl_winkel_ht _couponlochbild_rechts_)
	))
	
	(setq lb_abtl_at (Traeger.get Tr_ID Abteil Lochb_ID))
	(setq lb_abtl_ht (Traeger.get Htrg Abteil Lochb_ID))


	(setq 	b_AT 		(Traeger.get Tr_ID b)
			dlr_AT		(Traeger.get Tr_ID delta_LR)
			dv_AT		(Traeger.get Tr_ID delta_V)
	)

	(setq 	h_HT 		(Traeger.get HTrg h)
			b_HT 		(Traeger.get HTrg b)
			dv_HT		(Traeger.get HTrg delta_V)
			qsform_ht	(Traeger.get Htrg qsform)
	)
	(setq dlrCoup (* 0.5 b_HT))
	(if (= qsform_ht "U") (setq dlrCoup (* 1.0 b_HT)))
	(setq dlrCoup (+ dlrCoup 10.0))	; Plattenstrke dazu addieren
	
	
	(setq delta_v_abtl_ht (* 0.5 h_HT))
	(setq delta_v_abtl_ht (- delta_v_abtl_ht dv_HT))
	(if (= (Connect.get CastaData satr-vhtr)  1) (setq delta_v_abtl_ht (+ delta_v_abtl_ht dlr_AT)))
	(if (= (Connect.get CastaData satr-vhtr) -1) (setq delta_v_abtl_ht (- delta_v_abtl_ht dlr_AT)))
;	(setq delta_v_abtl_ht 0.0)


	(setq delta_lr_abtl_ht 0.0)
	(if (= (Connect.get CastaData vatr-lhtr)  1) (setq delta_lr_abtl_ht    dv_AT))
	(if (= (Connect.get CastaData vatr-lhtr) -1) (setq delta_lr_abtl_ht (- dv_AT)))

	
	
	(setq delta_v_abtl_at 0.0)
	; (if (= (Connect.get CastaData satr-vhtr)  1) (setq delta_v_abtl_ht  90.0))
	; (if (= (Connect.get CastaData satr-vhtr) -1) (setq delta_v_abtl_ht -90.0))
	
	(print "*clear*")
	(Connect.showAttributes CastaData)

	(if (= (Connect.get CastaData satr-vhtr)  1) (setq kplRWinkel  90.0))
	(if (= (Connect.get CastaData satr-vhtr) -1) (setq kplRWinkel -90.0))

	(if (= (Connect.get CastaData amHTStegLinks) 1) (setq dlrCoup (- dlrCoup)))
	(Lochbild.set 	Lochb_ID	(dlr_Coupon dlrCoup))
	
	(Anbauteil.set lb_abtl_at	(Master 	1)
					(delta_v 	delta_v_abtl_at)
					(KplRWnkl   kplRWinkel)
	)
	(Anbauteil.set lb_abtl_ht	(Master 	0)
					(delta_v 	delta_v_abtl_ht)
					(delta_lr	delta_lr_abtl_ht)
	)

	; AF - 04-2012 -	Fr asymmetrische Lochbilder Richtung anpassen
	;			Bei Gegenanschlssen aber kritisch - nochmal berarbeiten
	; U-Profil - amhtsteglinks = 0   ::    amhtstegrechts = 1
	(if (= (Connect.get CastaData linkesende) 1) (progn
		(Anbauteil.set lb_abtl_ht	(SeitRicht 	-1))
	))
	

	; LOCHBILD-TEST
	; --------------------------------------------------------------------------------------
	(if (= LB_DEBUG 1)
		(progn
			
			(setq lbdummy (Lochbild.create))
			(Lochbild.copy lbdummy Lochb_ID)
			
			(if (= (connect.get CastaData LinkesEnde) 1) (traeger.addabtl Tr_ID lbdummy 0.0 0.0 _kpllochbildlinks_))
			(if (= (connect.get CastaData RechtesEnde) 1) (traeger.addabtl Tr_ID lbdummy 0.0 0.0 _kpllochbildrechts_))
			
			(setq abtl_lb_at_dummy (Traeger.get Tr_ID Abteil lbdummy))
			(Anbauteil.set abtl_lb_at_dummy (Master 1)
							(delta_v delta_v_abtl_at)
			)
			
		)
	)
	; --------------------------------------------------------------------------------------
	
	(print "<-----------------------------------------------------------")	
)





; ----------------------------------------------------------------------------------------
; Verlngert bzw. Verkrzt das Sttzenende
; ----------------------------------------------------------------------------------------
(defun korrigiereStzEnde ()
	(print ">-----------------------------------------------------------")
	(print "KORRIGIERE STZ-ENDE")
	(print "------------------------------------------------------------")

	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(progn
			(setq delta_l_stz (- rand))
			(setq HT_Ende (Traeger.get Htrg links))
		)
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(progn
			(setq delta_l_stz (- rand))
			(setq HT_Ende (Traeger.get Htrg rechts))
		)
	)


	(setq delta_lr (Traeger.get Tr_ID delta_lr))
	(setq bp       (Blech.get   kpl_blech   bp))
	(if (= (Connect.get CastaData sATr-lHTr) -1) (progn
	      (setq delta_L_UZ (- (* 0.5 bp) delta_lr))
	      (print delta_L_UZ)
	      (TrEnde.set HT_Ende (delta_l (- delta_L_UZ)))
	))
	(if (= (Connect.get CastaData sATr-lHTr)  1) (progn
	      (setq delta_L_UZ (+ (* 0.5 bp) delta_lr))
	      (print delta_L_UZ)
	      (TrEnde.set HT_Ende (delta_l (- delta_L_UZ)))
	))


	
	(if (= (Connect.get CastaData sATr-lHTr) 0) (progn
		(setq delta_l_alt (TrEnde.get Ht_Ende delta_l))
		(print delta_l_alt)
		(print rand)
	
		(setq delta_l_stz (- delta_l_alt rand))
	
		(TrEnde.set HT_Ende (delta_l delta_l_stz))
	))
	(print "<-----------------------------------------------------------")	
)

; ----------------------------------------------------------------------------------------
; bernimmt das gegenberliegende Lochbild
; ----------------------------------------------------------------------------------------
(defun getExistingLochbild ()
;	(print "*clear*")
; ---------------------------------------------------------------------
(alertBox "
Auf der gegenberliegenden Seite ist bereits ein Anschluss vorhanden.\n
Nehmen Sie nderungen ggf. manuell vor.\n
\n
Kontrollieren Sie bitte auch den Rotationswinkel der anschlieenden Trger!\n
Unterschiedliche Rotationswinkel fhren zu fehlerhaften Werkstattzeichnungen.
"
"NOTE_OppositeConnectionFound_RotAngle")
; ---------------------------------------------------------------------
	
	(print ">-----------------------------------------------------------")
	(print "BERNEHME LOCHBILD")
	
	(setq dp_kpl (Blech.get kpl_blech dp))
	(print dp_kpl)

	(setq delta_w (Lochbild.get kpl_lochbild delta_w))
	(if (/= delta_w 0) (progn
	     (alertBox "
Bei diesem Gegenanschluss liegt bereits ein asymmetrisches Lochbild vor.\nLochbild wird symmetrisch gestaltet.\n
\n
Bitte korrigieren Sie ggflls. die Kopfplatten an den Trgerenden der beiden Anschlsse!
"
"NOTE_OppositeSideConnection_symmetrical_Holepattern")
	     (Lochbild.set lchbBlech (delta_w 0))
	))
			
	(setq klemml_alt 	(Lochbild.get kpl_lochbild klemml))
	(setq dxskopf_alt	(Lochbild.get kpl_lochbild dxsKopf))
	(print klemml_alt)
	(print dxskopf_alt)
			
	(setq klemml_neu 	(+ klemml_alt dp_kpl))
	(setq dxskopf_neu (+ dxskopf_alt dp_kpl))
	(print klemml_neu)
	(print dxskopf_neu)
			
	(Lochbild.set kpl_lochbild (klemml klemml_neu))									
				
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(Lochbild.set kpl_lochbild (dxsKopf dxskopf_neu))
	)
	
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(traeger.addabtl tr_id kpl_lochbild 0.0 0.0 _kpllochbildrechts_)
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
		(traeger.addabtl tr_id kpl_lochbild 0.0 0.0 _kpllochbildlinks_)
	)
			
			
	(setq	delta_v_at 	(Traeger.get Tr_ID delta_v)
		delta_v_ht 	(Traeger.get HTrg  delta_v)
		delta_lt_at	(traeger.get Tr_ID delta_lr)
	)
			
	(setq loch_at_abtl (Traeger.get Tr_ID Abteil kpl_lochbild))
	(setq loch_ht_abtl (Traeger.get Htrg  Abteil kpl_lochbild))	  
	
	(setq	delta_v_abtl_ht 	(Anbauteil.get loch_ht_abtl delta_v)
		delta_lr_abtl_ht	(Anbauteil.get loch_ht_abtl delta_lr)
		h_ht			(Traeger.get Htrg h)
	)

	(setq	delta_v_abtl_at 	(Anbauteil.get loch_at_abtl delta_v)
		delta_lr_abtl_at	(Anbauteil.get loch_at_abtl delta_lr)
		h_at			(Traeger.get Tr_ID h)
	)
	
	(setq	delta_v_gesamt (- (* 0.5 h_at) delta_v_at (- delta_v_ht)))
	(print	delta_v_gesamt)

	(print delta_v_abtl_at)
	(print delta_lr_abtl_at)
	(print delta_v_at)
	(print delta_v_abtl_ht)
	(print delta_lr_abtl_ht)
	
;	(setq delta_v_abtl_at_neu (- (- delta_v_at) delta_v_abtl_ht))
	(setq delta_v_abtl_at_neu (+ delta_v_gesamt delta_v_abtl_ht))
	(setq delta_v_vorhanden 0.0)

;	Korrektur Feb.2011 (AF)
;	kompletter neuer Abschnitt	
	(setq ABTeilVorhanden (Traeger.get Htrg ABTeil kpl_lochbild))
	
	(if ABTeilVorhanden
		(progn
			(print "Anbauteil am Haupttrger gefunden.")
			; Vorbereitung Korrektur - Feb.2011 
			; Es gibt leider zwei verschiedene Steglochbildtypen
			; eines ist auf die Systemachse bezogen, das andere auf die OK des Trgers (hier des HT)
			; deswegen muss noch in einem Fall die halbe Hhe des HT bercksichtigt werden.
			(setq Steg_LB 	  131072)	; auf OK bezogen
			(setq Steg_LB_Sys 33554432)	; auf Achse bezogen (nur zur Verdeutlichung)

			(setq isType_1 (Anbauteil.get ABTeilVorhanden is_type Steg_LB))
			(setq isType_2 (Anbauteil.get ABTeilVorhanden is_type Steg_LB_Sys))

			(setq delta_v_vorhanden (Anbauteil.get ABTeilVorhanden delta_v))
			(print delta_v_vorhanden)
			
			(setq winkel_ht_lb_abtl (Anbauteil.get ABTeilVorhanden winkel))
			(print winkel_ht_lb_abtl)
			
; 			--------------------------------------------
;	-	-	korrigiert Feb. 2011 - (AF)
;			korrigiert Aug. 2013 - (AF)  Konstellation HT auf dem Kopf
			(if (> (Connect.get CastaData vAtr-vHtr) 0) (progn
				(setq delta_v_gesamt (+ (* 0.5 h_at) delta_v_vorhanden))
				(setq delta_v_gesamt (+ delta_v_gesamt delta_v_ht))
				(setq delta_v_gesamt (- delta_v_gesamt delta_v_at))
				
				(if (= isType_1 1) (setq delta_v_gesamt (- delta_v_gesamt (* 0.5 h_HT))))
			    )
			    (progn
				(setq delta_v_gesamt (- (* 0.5 h_at) delta_v_vorhanden))
				(setq delta_v_gesamt (- delta_v_gesamt delta_v_ht))
				(setq delta_v_gesamt (- delta_v_gesamt delta_v_at))
			
				(if (= isType_1 1) (setq delta_v_gesamt (+ delta_v_gesamt (* 0.5 h_HT))))
			))
;			Ende Korrektur
		)
	)
	
	
	(setq	dlr_AT	(Traeger.get TR_ID delta_LR)
		dv_AT	(Traeger.get TR_ID delta_V)
	)
	
	(print "*clear*")
	(Connect.showAttributes CastaData)
	
	(setq delta_lr_abtl_AT 0.0)
	(if (= (Connect.get CastaData sAtr-lHtr) -1) (setq delta_lr_abtl_AT (+ dlr_AT delta_lr_abtl_HT)))
	(if (= (Connect.get CastaData sAtr-lHtr)  1) (setq delta_lr_abtl_AT (- dlr_AT delta_lr_abtl_HT)))

	(setq delta_V_abtl_AT 0.0)
	(if (= (Connect.get CastaData vAtr-vHtr) 0) (progn
	    (setq h_AT_Halbe (* 0.5 h_at))
	    (if (= (Connect.get CastaData vAtr-lHtr) -1) (setq delta_V_abtl_AT (- (+ delta_v_vorhanden h_AT_Halbe) dv_AT)))
	    (if (= (Connect.get CastaData vAtr-lHtr)  1) (setq delta_V_abtl_AT (- (+ delta_v_vorhanden h_AT_Halbe) dv_AT)))
	    
	    
	))

	(Anbauteil.set loch_at_abtl (Master 	0)
		(delta_v 	delta_V_abtl_AT)
		(delta_lr 	delta_lr_abtl_AT)
	)				
	
	(print "<-----------------------------------------------------------")				
)


; ---------------------------------------------------------------------------------
; Korrigiert das Traegerende des AT
; ---------------------------------------------------------------------------------
(defun AtEnde_Anpassen ()
	; Abstnde zum Ht korrigieren
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID rechts))
	)
	
	(setq	s_ht		(Traeger.get Htrg s)
			b_ht		(Traeger.get Htrg b)
			qsform_ht	(Traeger.get Htrg qsform)
	)
	
	(if (= qsform_ht "I") (progn
		(print "I-Profil anpassen")
		(setq bDiff (* 0.5 (- b_ht s_ht)))
		(TrEnde.pTrim AtEnde bDiff)
	))
	(if (= qsform_ht "U") (progn
       (if (= (Connect.get CastaData amHtStegRechts) 1) (progn
			(print "U-Profil anpassen")
			(setq bDiff (- b_ht s_ht))
			(TrEnde.pTrim AtEnde bDiff)
		))
	))

	(TrEnde.set AtEnde (xAkl 0) (yAkl 0) (hSteg 0))
)


; ----------------------------------------------------------------------------------------
; berprft, ob der Anschluss in der bestehenden Positionierung eingebaut werden kann
; ----------------------------------------------------------------------------------------
(defun checkPosition (Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "BERPRFE POSITION")
	
	; Oberkante HT
	(setq h_ht 				(Traeger.get Htrg h)
				r_ht				(Traeger.get Htrg r)
				t_ht				(Traeger.get Htrg t)
				hc_ht				(Traeger.get Htrg hc)
				delta_v_ht	(Traeger.get Htrg delta_v)
	)
	(setq h_ht_halb	(* 0.5 h_ht))
	
	(setq h_at 				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	(setq h_at_halb	(* 0.5 h_at))
	
	(setq kpl_hp			(Blech.get Blech_ID hp)
				kpl_bp			(Blech.get Blech_ID bp)
	)
	(setq kpl_hp_halb	(* 0.5 kpl_hp))
	(setq kpl_bp_halb	(* 0.5 kpl_bp))
	
	
	(setq oGrenze_ht (- delta_v_ht (- h_ht_halb r_ht t_ht)))
	(setq uGrenze_ht (+ oGrenze_ht hc_ht))
	(print oGrenze_ht)
	(print uGrenze_ht)
	
	(if (= (Connect.get CastaData satr-vhtr)  1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)
				(progn
					(setq oGrenze_kpl	(- delta_lr_at kpl_bp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_bp))
				)
			)
			(if (= (Connect.get CastaData vatr-lhtr) -1)
				(progn
					(setq oGrenze_kpl	(- delta_lr_at kpl_bp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_bp))
				)
			)
		)
	)
	(if (= (Connect.get CastaData satr-vhtr) -1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)
				(progn
					(setq oGrenze_kpl	(- (- delta_lr_at) kpl_bp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_bp))
				)
			)
			(if (= (Connect.get CastaData vatr-lhtr) -1)
				(progn
					(setq oGrenze_kpl	(- (- delta_lr_at) kpl_bp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_bp))
				)
			)
		)
	)
	
	(if (= (Connect.get CastaData vatr-vhtr)  1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)
				(progn
					(setq oGrenze_kpl	(- delta_v_at kpl_hp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_hp))
				)
			)
			(if (= (Connect.get CastaData satr-lhtr) -1)
				(progn
					(setq oGrenze_kpl	(- delta_v_at kpl_hp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_hp))
				)
			)
		)
	)
		(if (= (Connect.get CastaData vatr-vhtr) -1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)
				(progn
					(setq oGrenze_kpl	(- (- delta_v_at) kpl_hp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_hp))
				)
			)
			(if (= (Connect.get CastaData satr-lhtr) -1)
				(progn
					(setq oGrenze_kpl	(- (- delta_v_at) kpl_hp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_hp))
				)
			)
		)
	)
	(print oGrenze_kpl)
	(print uGrenze_kpl)
	
	(if (>= oGrenze_kpl oGrenze_ht)
		(progn
			(if (<= uGrenze_kpl uGrenze_ht)
				(progn
					(print "OK")
				)
				(progn
					(alertBox "Die Kopfplatte reicht in die untere Ausrundung den Haupttrgers.\nBitte korrigieren Sie die Positionierung der Trger oder passen Sie die Kopfplatte an!" "Headplate_To_Fit_FilletBottom")
				)
			)
		)
		(progn
			(alertBox "Die Kopfplatte reicht in die obere Ausrundung den Haupttrgers.\nBitte korrigieren Sie die Positionierung der Trger oder passen Sie die Kopfplatte an!" "Headplate_To_Fit_FilletTop")
		)
	)
	
	(print "<-----------------------------------------------------------")
)

(defun createCouponBlech ()
	; ------------------------------- Coupon-Blech - besser in eigene Routine packen
	(setq db_CoupnBl 12)
	(setq bp_CoupnBl (Blech.get kpl_blech bp))
	(setq hp_CoupnBl (Blech.get kpl_blech hp))
	
	(setq cpFrontBlech (Blech.create))
	(Blech.set cpFrontBlech (hp bp_CoupnBl) (bp hp_CoupnBl) (dp db_CoupnBl))
	(Connect.storeAnschlObjs CastaData cpFrontBlech)
	(setq xPos_HT (Connect.get CastaData xPos_HT))
	(if (= (Connect.get CastaData amHTStegLinks) 1) (progn
		(Traeger.addabtl Htrg cpFrontBlech xPos_HT 0.0 _blechcoupon_links_)
	))
	(if (= (Connect.get CastaData amHTStegRechts) 1) (progn
		(Traeger.addabtl Htrg cpFrontBlech xPos_HT 0.0 _blechcoupon_rechts_)
	))

	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID rechts))
	)

	(TrEnde.pTrim AtEnde db_CoupnBl)

	
	(setq dv_AT (Traeger.get Tr_ID delta_v))
	(if (= (Connect.get CastaData vatr-lhtr)  1) (Blech.set cpFrontBlech (xAsym    dv_AT)))
	(if (= (Connect.get CastaData vatr-lhtr) -1) (Blech.set cpFrontBlech (xAsym (- dv_AT))))


	
)
(defun LochbildAusrichtung_am_HT ()
	(setq Ht_lb_abtl (Traeger.get Htrg Abteil kpl_lochbild))
	
	(if (= (Connect.get CastaData amHtstegLinks) 1) (progn
		(if (= (Connect.get CastaData linkesEnde) 1)  (Anbauteil.set Ht_lb_abtl (SeitRicht  1)))
		(if (= (Connect.get CastaData rechtesEnde) 1) (Anbauteil.set Ht_lb_abtl (SeitRicht -1)))
	))
	(if (= (Connect.get CastaData amHtstegRechts) 1) (progn
		(if (= (Connect.get CastaData linkesEnde) 1)  (Anbauteil.set Ht_lb_abtl (SeitRicht -1)))
		(if (= (Connect.get CastaData rechtesEnde) 1) (Anbauteil.set Ht_lb_abtl (SeitRicht  1)))
	))

	(setq dv_Lb_HT (Anbauteil.get Ht_lb_abtl delta_V))
	(setq tWinkel (Connect.get CastaData  h-atrgewnkl_steg))
	(setq radTWinkel (/ (* PI tWinkel) 180.0))
	(setq cosWnkl (cos  radTWinkel))
	
	(if (= (Connect.get CastaData linkesEnde) 1)  (progn
		(setq tEnd (Traeger.get Tr_ID links))
		(setq dl_AT (TrEnde.get tEnd delta_L))
		(setq dl_DV (* dl_AT  cosWnkl))
		(if (= (Connect.get CastaData satr-vhtr) 1) (progn
			(setq dl_DV (- dl_DV))
		))
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(setq tEnd (Traeger.get Tr_ID rechts))
		(setq dl_AT (TrEnde.get tEnd delta_L))
		(setq dl_DV (* dl_AT  cosWnkl))
		(if (= (Connect.get CastaData satr-vhtr) -1) (progn
			(setq dl_DV (- dl_DV))
		))
	))
	
	(Anbauteil.set Ht_lb_abtl (delta_V  (+ dl_DV dv_Lb_HT)))
	
)
