; $	HT	QT(IU)		AF(SK)		P(EZ)
; $ AT	QT(F)		AF(K)		P(E)
; $	AE	V(-)		H(-)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;	
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (load "mod-endinit-uz-uzsteg")	
   (load "mod-lochbild")
   ;(load "mod-multiconnect-stz-steg")
   (load "mod-messages")
)



(defun init-connection ()

;	(setq RWinkel (Traeger.get Tr_ID R_Winkel))
;	(Traeger.set Tr_ID (R_Winkel (+ RWinkel 5.0)))
;	(if (= (Connect.get CastaData sAtr-lHtr-ex)  1) (print "Richtung ist gleich"))
;	(if (= (Connect.get CastaData sAtr-lHtr-ex) -1) (print "Richtung ist nicht gleich"))
;	(if (= (Connect.get CastaData sAtr-lHtr-ex)  0) (print "Richtung undefiniert !!"))

;)
;(defun XXX ()

	(if (= (Connect.get CastaData amHTSteg) 1) (progn
	
		(init-traegerenden)
		;(korrAtEnde abstandZumSteg)
		
		(setq LB_DEBUG 0)

		; Testen, ob Makro geeignet - doppelt schrg und Verschiebungen ausschlieen
		(testeAnschluss)	; erzeugte Variable: RunMakro
		(setConnection)
		(if (= RunMakro 0)  (AlertBox "Achtung!\nBei dieser Konstellation besteht die Gefahr,\ndass die Schrauben nicht passen."  "Bolts_May_Not_Fit"))

		(if (= 2 1) (progn
			(Lochbild.set kpl_lochbild (LB_Art 2) (w "40 0"))
			(Lochbild.set kpl_lochbild (e1 30) (e2 70))
		
			(setq Ht_lb_abtl (Traeger.get Htrg Abteil kpl_lochbild))
			(setq At_lb_abtl (Traeger.get Tr_ID Abteil kpl_lochbild))
			
			; (setq sRicht-AT (Anbauteil.get At_lb_abtl SeitRicht))
			; (setq sRicht-HT (Anbauteil.get Ht_lb_abtl SeitRicht))
			(setq delta_V-AT (Anbauteil.get At_lb_abtl delta_V))
			(setq delta_V-HT (Anbauteil.get Ht_lb_abtl delta_V))
			
			; (AlertBox delta_V-AT) (AlertBox delta_V-HT)
		))


		
	    (if (= 1 2) (progn
			(setq AnschlussArt (Connect.get CastaData AnschlussArt))
			(print AnschlussArt)
			(setq AnschlussTyp (Connect.get CastaData AnschlussTyp))
			(print AnschlussTyp)
	    ))
	    (if (= LB_DEBUG 1) (progn
	    	(if (existObj lbdummy) 	(Connect.storeAnschlObjs CastaData lbdummy))
	    ))
	  ); progn
	  (AlertBox "Dieses Makro kann nur fr Anschlsse am Steg eingesetzt werden!"  "Macro_Just_For_WebConnections")
	)


)
(defun testeAnschluss ()
	(setq RunMakro 1)
	(if (= (Connect.get CastaData linkesEnde)  1) (setq AT_Ende   (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1) (setq AT_Ende   (Traeger.get Tr_ID rechts)))
	(setq VWinkel_E (TrEnde.get AT_Ende V_Winkel))
	(setq HWinkel_E (TrEnde.get AT_Ende H_Winkel))

	(if (/= VWinkel_E 90.0) (progn
	     (if (/= HWinkel_E 90.0) (progn
	         (setq delta_LR_HT (Traeger.get HTrg  delta_LR)
	               delta_LR_AT (Traeger.get Tr_ID delta_LR)
	               delta_V_AT  (Traeger.get Tr_ID delta_V)
	         )
	         (if (/= delta_LR_HT 0.0) (setq RunMakro 0))
	         (if (/= delta_LR_AT 0.0) (setq RunMakro 0))
	         (if (/= delta_V_AT  0.0) (setq RunMakro 0))
	     ))
	))

)

(defun setConnection ()
	; Objekte erzeugen
	(setq kpl_blech (Blech.create))
	(Connect.storeAnschlObjs CastaData kpl_blech)

;	Schrauben bei Kastenprofilen werden zwar erzeugt aber nicht eingebaut.	
	(setq qsform_ht	(Traeger.get Htrg qsform))
	(if (= qsform_ht "K") (setq kpl_lochbild (Lochbild.create))
	(progn
	    (if (= (Connect.get CastaData exist_steglchb) 1)
		(progn
			(setq kpl_lochbild (Connect.get CastaData steglchb_gegen))
		)
		(progn
			(setq kpl_lochbild (Lochbild.create))
		)
	    )
	    (Connect.storeAnschlObjs CastaData kpl_lochbild)
	))
	
	
	; Blechdicke berechnen
	(calcAndSetKplThickness)
	
	;Schraubengre anhand der min. Blechdicke bestimmen(grobe Anhaltswerte)
	(setq min_blech_dp 10)
	(setq akt_kpl_dp (Blech.get kpl_blech dp))
	(setq s_ht (Traeger.get Htrg s))
	(if (< s_ht akt_kpl_dp)
		(setq min_blech_dp s_ht)
		(setq min_blech_dp akt_kpl_dp)
	)
	(print min_blech_dp)
	(calcSchraube min_blech_dp) ; -> S_Bez
	
	; Schraubengre dem Lochbild hinzufgen
	(Lochbild.set kpl_lochbild (S_Bez S_Bez))
	
	; min. Rand- / Lochabstnde berechnen
	(calcMinRandLochAbst kpl_lochbild) ; -> e_min, e1_min, e_min_rund, e1_min_rund, h_min
	
	; Kopfplatte berechnen
	(calcAndSetKplDaten)
	
	;Einbauposition prfen
	(checkPosition kpl_blech)
	
	; Anbauteil Kopfplatte hinzufgen
	(setKplAbtl)
	
	(if (= qsform_ht "K") (progn
	    (calcAndSetLochbildDaten kpl_lochbild kpl_blech)
			
	    ; Lochbildanbauteile hinzufgen
	    (setLochbildAbtl kpl_lochbild kpl_blech)
	    (Connect.storeAnschlObjs CastaData kpl_lochbild)
	))


	(if (/= qsform_ht "K") (progn
	    ; Auf gegenberliegenden Anschluss prfen
	
	    (if (= (Connect.get CastaData exist_steglchb) 1)
		(progn
			(getExistingLochbild)												
		)
		(progn
  		; Lochbilddaten berechnen
			(calcAndSetLochbildDaten kpl_lochbild kpl_blech)
			
			; Lochbildanbauteile hinzufgen
			(setLochbildAbtl kpl_lochbild kpl_blech)
		)
  	    )
	))
	
	; korrigiere Stz-Ende
	(if (= (Connect.get CastaData anz_weitere_anschl) 0)
		(if (= (Connect.get CastaData anschlzwhtenden) 0)
			(korrigiereStzEnde)
		)
	)
	
	; Test-Lochbild asymmetrisch	
	; (Lochbild.set kpl_lochbild (e "0 30 100 0 0 0") (w0 0) (LB_Art 2))
	
	; Callbacks
  (Blech.set kpl_blech (formFkt "cb_kplblech"))
  
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr die Kopfplatte
; ----------------------------------------------------------------------------------------
(defun cb_kplblech (zp)
;	(print "*clear*")
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get kpl_blech dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get kpl_blech dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml 	(Lochbild.get kpl_lochbild Klemml))
	       (setq altesDxSKopf (Lochbild.get kpl_lochbild dxSKopf))
	       (print alteKlemml)
	       (print altesDxSKopf)
	       
	       (setq klemml_neu (+ alteKlemml dpDiff))
	       (print klemml_neu)
	       
	       (Lochbild.set kpl_lochbild 	(Klemml  klemml_neu))
	       
	       (if (= (Connect.get CastaData amHtStegLinks) 1)
	       	(progn
	       		(setq dxsKopf_neu (+ altesDxSKopf dpDiff))
	       		(print dxsKopf_neu)
	       		
	       		(Lochbild.set kpl_lochbild (dxSKopf dxsKopf_neu))	 
	       	)      	
	       )
				 
				 (cbDeltaLR kpl_lochbild dpDiff)
	    ))
	))
)


; ---------------------------------------------------------------------
; Korrigiert die delta_lr Verschiebung des LB-ABTL bei einem Aufruf
; der Callbackfunktion (Dickennderung des Bleches)
; ---------------------------------------------------------------------
(defun cbDeltaLR (KPL_LB DP_DIFF)
	;(print "*clear*")
	(print ">------------------------------------------------------------------------------")
	(print "Anbauteil Korrektur wegen Callback-Funktion")
	
	; Anbauteil des HT-LB
	(setq ht_lb_abtl (Traeger.get Htrg Abteil KPL_LB))
				 
	; delta_lr Verschiebung des Anbauteils
	(setq delta_lr_abtl_alt (Anbauteil.get ht_lb_abtl delta_lr))
	(print delta_lr_abtl_alt)
	
	; Wert, um den das Anbauteil korrigiert wird (erstmal auf 0.0) 
	(setq delta_lr_abtl_neu 0.0)
	
	; Winkel des AT zum HT in horizontaler Richtung
	(setq h_wnkl_steg_at (Connect.get CastaData h-atrgewnkl_steg))
	(print h_wnkl_steg_at)
	
	(setq tanHW (tan (/ (* PI h_wnkl_steg_at) 180.0)))
	(print tanHW)
	
	(if (/= tanHW 0.0)
		(setq delta_lr_abtl_korr (/ DP_DIFF tanHW))
	)
	(print delta_lr_abtl_korr)
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq delta_lr_abtl_neu (- delta_lr_abtl_alt delta_lr_abtl_korr)))
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq delta_lr_abtl_neu (+ delta_lr_abtl_alt delta_lr_abtl_korr)))
	
	; Anbauteil korrigieren
	(print delta_lr_abtl_neu)
	(Anbauteil.set ht_lb_abtl (delta_lr delta_lr_abtl_neu))
	
	(print "<------------------------------------------------------------------------------")
)



; ****************************************************************************************
; HILFSFUNKTIONEN
; ****************************************************************************************

; ----------------------------------------------------------------------------------------
; Berechnet die Kopfplattendicke
; ----------------------------------------------------------------------------------------
(defun calcAndSetKplThickness ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE KOPFPLATTEN-DICKE")
	(print "------------------------------------------------------------")
	(setq t_ht (Traeger.get Htrg t))
	(setq t_at (Traeger.get Tr_ID t))
	
	(setq dp_kpl (runde t_at auf 5.0))
	(print dp_kpl)
	
	(Blech.set kpl_blech (dp dp_kpl))
	(print "<-----------------------------------------------------------")
)


; ----------------------------------------------------------------------------------------
; Berechnet die Kopfplattendaten
; ----------------------------------------------------------------------------------------
(defun calcAndSetKplDaten ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE KOPFPLATTEN-DATEN")
	(print "------------------------------------------------------------")
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID rechts)))
	
	(setq	vscherl_at	(TrEnde.get AT_Ende vscherl)
			hscherl_at	(TrEnde.get AT_Ende hscherl)
	)
	
	(setq	b_at 		(Traeger.get Tr_ID b)
			qsform_at	(Traeger.get Tr_ID qsform)
	)
	
	(setq abst_zum_rand e_min_rund)
	(setq abst_zum_trg (* 0.5 e_min_rund))
	(if (= qsform_at "R")
		(setq abst_zum_trg (* 0.25 e_min_rund))
	)
	
	(setq rand (+ abst_zum_rand abst_zum_trg))
	; Kopfplattenhhe
	(setq kpl_hp (+ vscherl_at (* 4.0 rand)))
	(print	 kpl_hp)
	
	; Kopfplattenbreite
	(setq kpl_bp (+ hscherl_at (* 2.0 rand)))
	(print kpl_bp)
	(if (> kpl_bp b_at) (setq kpl_bp b_at))
	
	; Dok
	(setq kpl_dok (- (* 2.0 rand)))
	(print  kpl_dok)
	
	(Blech.set kpl_blech 	(hp		kpl_hp)
							(bp 	kpl_bp)
							(dok 	kpl_dok)
	)
	(print "<-----------------------------------------------------------")	
)		


; ----------------------------------------------------------------------------------------
; Hinzufgen des Kopfplatten-Anbauteils
; ----------------------------------------------------------------------------------------
(defun setKplAbtl ()
	(print ">-----------------------------------------------------------")
	(print "FGE KOPFPLATTEN-ANBAUTEIL HINZU")
	(print "------------------------------------------------------------")
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	
	(setq kpl_dp (Blech.get kpl_blech dp))
	
	(setq xPos_abtl	xPos_ht)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(setq AT_Ende (Traeger.get Tr_ID links))
			(Traeger.addAbtl Tr_ID kpl_blech xPos_abtl 0.0 _kopfplattelinks_)
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(setq AT_Ende (Traeger.get Tr_ID rechts))
			(Traeger.addAbtl Tr_ID kpl_blech xPos_abtl 0.0 _kopfplatterechts_)
		)
	)
	
	(TrEnde.pTrim AT_Ende kpl_dp)
	
	(print "<-----------------------------------------------------------")	
)

; ----------------------------------------------------------------------------------------
; Berechnet die Lochbilddaten
; ----------------------------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lochb_ID Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(print "------------------------------------------------------------")
	(Lochbild.set Lochb_ID 	(Guete  "4.6")
				(Anz_S  4)
	)
	
	(setq	kpl_hp 		(Blech.get Blech_ID hp)
		kpl_bp 		(Blech.get Blech_ID bp)
		kpl_dok 	(Blech.get Blech_ID dok)
		kpl_dp		(Blech.get Blech_ID dp)
	)	
	(setq 	s_ht		(Traeger.get Htrg s)
		qsform_ht	(Traeger.get Htrg qsform)
	)
	(setq 	s_ht_halb 	(* 0.5 s_ht))
	
	; e0
	; (setq e0_lb (- abst_zum_trg))
	; (setq e0_lb (- rand))
	(setq e0_lb (runde e0_lb ab 2))
	; e1
	; (setq e1_lb (- kpl_hp (* 2.0 e_min_rund)))
	; (setq e1_lb (- kpl_hp (* 2.0 rand)))
	(setq e1_lb (* -2.0 e0_lb))

	(AlertBox e0_lb)
	(AlertBox e1_lb)
	
	; w0
	(setq w0_lb (- kpl_bp (* 2.0 e_min_rund)))
	 
		
	; klemml
	(setq klemml_lb (+ s_ht kpl_dp))
	(print klemml_lb)
	
	; dxskopf
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(setq dxskopf_lb (+ kpl_dp s_ht_halb))
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(setq dxskopf_lb s_ht_halb)
	)
	
	(if (= qsform_ht "U")	
		(progn
			(if (= (Connect.get CastaData amHtStegLinks) 1) (setq dxskopf_lb kpl_dp))
			(if (= (Connect.get CastaData amHtStegRechts) 1) (setq dxskopf_lb 0.0))
		)
	)
	
	(print dxskopf_lb)
	
	(print e0_lb)
	
	(Lochbild.set Lochb_ID 	(e0		e0_lb)
				(e1		e1_lb)
				(w0		w0_lb)
				(klemml		klemml_lb)
				(dxsKopf	dxskopf_lb)
	)
	
	(if (= LB_DEBUG 1)
		(Lochbild.set Lochb_ID (e2 	300))
	)
	(print "<-----------------------------------------------------------")	
)


; ----------------------------------------------------------------------------------------
; Hinzufgen der Lochbild-Anbauteile
; ----------------------------------------------------------------------------------------
(defun setLochbildAbtl (Lochb_ID Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "FGE LOCHBILD-ANBAUTEILE HINZU")
	(print "------------------------------------------------------------")
	
	; AT
	; ######################################################################################
	(if (= (Connect.get CastaData linkesEnde) 1)
		(Traeger.addAbtl Tr_ID Lochb_ID 0.0 0.0 _kpllochbildlinks_)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(Traeger.addAbtl Tr_ID Lochb_ID 0.0 0.0 _kpllochbildrechts_)
	)
	
	(setq delta_v_abtl_at 0)
	
	(setq kpl_dp (Blech.get Blech_ID dp))
(setq kpl_dp 0.0)
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	
	(setq tanW (tan (/ (* PI at_winkel) 180.0)))
	(setq sinW (sin (/ (* PI at_winkel) 180.0)))
	
	(setq anteil_hneigung (/ (* 1.0 kpl_dp) tanW))
	
	(setq delta_v_abtl_at 0.0)
;	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_at (- anteil_hneigung)))
;	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_at    anteil_hneigung))
	
	
	; HT
	; ######################################################################################
	(setq rwinkel_at		(Traeger.get Tr_ID r_winkel))
	
	(setq	xPos_ht 	(Connect.get CastaData xPos_ht)
		vwinkel_uz	(Connect.get CastaData hpttrg_vwinkel)
		r_winkel_steg	(Connect.get CastaData r-atrgewnkl_steg)
	)
	; AF-2012-04-23 - Winkel nicht korrekt
;	(if (= (Connect.get CastaData vAtr-lHtr) 1) (setq r_winkel_steg (- 180.0 r_winkel_steg)))
	
	(setq delta_v_abtl_ht 0.0)
	(setq delta_lr_abtl_ht 0.0)
		
    (print "*clear*")
    (print "Hier geht es jetzt los !!!")
    (Connect.ShowAttributes CastaData)

	
	; Differnzwinkel zwischen HT-Neigung und AT-Rotation berechnen
	; ---------------------------------------------
	(print "---- Differenzwinkel ----")
	(print vwinkel_uz)
	(print rwinkel_at)
	(print r_winkel_steg)
	
	(setq diffWinkel 0.0)
	
;	(if (!= (Connect.get CastaData vatr-vhtr)  0) (progn 
		(if (= (Connect.get CastaData amHtStegRechts) 1) (progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (+ (- r_winkel_steg 90.0)))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (- (- r_winkel_steg 90.0)))
			)
		))
		(if (= (Connect.get CastaData amHtStegLinks) 1)	(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (- (- r_winkel_steg 90.0)))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (+ (- r_winkel_steg 90.0)))
			)
		))
;	))
	; AF-2012-04-23 - Winkel nicht korrekt
	(setq htVWinkel (Connect.get CastaData hpttrg_vwinkel))
	(print diffWinkel)
	
	(setq sinW (sin (/ (* PI diffWinkel) 180.0)))
	(setq cosW (cos (/ (* PI diffWinkel) 180.0)))
	(setq tanW (tan (/ (* PI diffWinkel) 180.0)))

	; Winkel des Anbauteils
	; ----------------------------------------------
	(setq abtl_winkel_ht 0.0)
	(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq abtl_winkel_ht  90.0)	)
	(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq abtl_winkel_ht 270.0)	)
	(if (= (Connect.get CastaData vatr-vhtr)  0)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq abtl_winkel_ht 180.0)	)
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq abtl_winkel_ht 180.0)	)
		)
	)


	(print "Winkel nach dem generellen Ausrichten")
	(print abtl_winkel_ht)
	
	(print "Differenzwinkel mitbetrachtet")
	(if (= (Connect.get CastaData vatr-vhtr)  0)
		(setq abtl_winkel_ht (- abtl_winkel_ht (- 90.0 diffWinkel)))
		(setq abtl_winkel_ht (- abtl_winkel_ht         diffWinkel))
	)
	(print abtl_winkel_ht)
	
	(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq abtl_winkel_ht (- 180.0 abtl_winkel_ht)))
	(print abtl_winkel_ht)
	
; ---------------------------------------
	(setq abtl_winkel_ht 0.0)
	(setq 	r_wkl_steg	(Connect.get CastaData r-atrgewnkl_steg))
	
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
		(if (= (Connect.get CastaData sAtr-lHtr-ex)  1) (setq abtl_winkel_ht (+  180.0  r_wkl_steg)))
		(if (= (Connect.get CastaData sAtr-lHtr-ex) -1) (setq abtl_winkel_ht (-  180.0  r_wkl_steg)))
		(if (= (Connect.get CastaData sAtr-lHtr-ex)   0) (progn
		    (if (= (Connect.get CastaData vAtr-lHtr) -1)
		    	(setq abtl_winkel_ht    (-  180.0  r_wkl_steg))
		    	(setq abtl_winkel_ht    (+  180.0  r_wkl_steg))
		    )
		))
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(if (= (Connect.get CastaData sAtr-lHtr-ex)   1) (setq abtl_winkel_ht    r_wkl_steg))
		(if (= (Connect.get CastaData sAtr-lHtr-ex)  -1) (setq abtl_winkel_ht (- r_wkl_steg)))
		(if (= (Connect.get CastaData sAtr-lHtr-ex)   0) (progn
		    (if (= (Connect.get CastaData vAtr-lHtr) -1)
		    	(setq abtl_winkel_ht    r_wkl_steg) 
		    	(setq abtl_winkel_ht (- r_wkl_steg))
		    )
		))
	))


	(if (= (Connect.get CastaData amhtstegrechts ) 1)	(setq abtl_winkel_ht    (- abtl_winkel_ht 180.0)))


	(setq delta_L_AT 0.0)
	(setq EVWnkl_AT  0.0)
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
		(setq	TrgEnde_AT (Traeger.get Tr_ID links))
		(setq	delta_L_AT (TrEnde.get TrgEnde_AT delta_L)
			EVWnkl_AT  (TrEnde.get TrgEnde_AT V_Winkel)
		)
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(setq TrgEnde_AT (Traeger.get Tr_ID rechts))
		(setq delta_L_AT (TrEnde.get TrgEnde_AT delta_L)
			EVWnkl_AT  (TrEnde.get TrgEnde_AT V_Winkel)
		)
	))

	; ----------------------------------------------
	; delta_v Anbauteil HT
	; ----------------------------------------------
	
	; Anteil AT-Hhe
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(if (= (Connect.get CastaData linkesEnde) 1)		(setq AT_Ende (Traeger.get Tr_ID links)))
		(if (= (Connect.get CastaData rechtesEnde) 1)		(setq AT_Ende (Traeger.get Tr_ID rechts)))
		
		(setq vscherl_at	(TrEnde.get AT_Ende vscherl))
		(setq vscherl_at_halb (* 0.5 vscherl_at))
		
		(setq delta_v_abtl_ht (- vscherl_at_halb))
		(print "Erste Berechnung ............")
		(print delta_v_abtl_ht)
		(setq delta_v_abtl_ht 0.0)
	; ----------------------------------------------
	))
	; ----------------------------------------------

	; Anteil AT-Neigung (horizontal)
	; ----------------------------------------------
    (if (= 1 1)	(progn
	; ----------------------------------------------
	(setq	s_ht 		(Traeger.get Htrg s)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(setq kpl_dp (Blech.get Blech_ID dp))
	(setq kpl_dp (* 1.0 kpl_dp))
; (setq kpl_dp 0.0)
; (setq s_ht   0.0)
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	
	(setq tanW (tan (/ (* PI at_winkel) 180.0)))
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq abst (+ (* 0.5 s_ht) kpl_dp (- delta_lr_ht))))
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq abst (+ (* 0.5 s_ht) kpl_dp delta_lr_ht)))
	
;	(setq anteil_hneigung (/ abst tanW))
	(setq anteil_hneigung 0.0)
	
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
		(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_hneigung)))
		(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_hneigung)))
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_hneigung)))
		(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_hneigung)))
	))

	(setq tanW (tan (/ (* PI EVWnkl_AT) 180.0)))
;	(setq anteil_vneigung (/ (+ delta_lr_ht (* 0.5 s_ht)) tanW))
	(setq anteil_vneigung (/ (- abst kpl_dp) tanW))
	
	(print "vorher ..... delta_v_abtl_ht")
	(print delta_v_abtl_ht)
	(print delta_L_AT)
	(print EVWnkl_AT)
	(setq cosW (cos (* PI (/ EVWnkl_AT 180.0))))
	
	
	(if (= (Connect.get CastaData linkesEnde) 1)  (progn
		(if (/= cosW 0.0) (setq delta_L_AT (- delta_L_AT (/ (* 1.0 kpl_dp) cosW))))
;		(setq delta_v_abtl_ht (- delta_v_abtl_ht (* cosW delta_L_AT)))
		(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_vneigung))
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(if (/= cosW 0.0) (setq delta_L_AT (- delta_L_AT (/ (* 1.0 kpl_dp) cosW))))
;		(setq delta_v_abtl_ht (+ delta_v_abtl_ht (* cosW delta_L_AT)))
		(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_vneigung))
	))
	

	(print delta_L_AT)
	(print (* cosW delta_L_AT))
	(print "nachher ..... delta_v_abtl_ht")
	(print delta_v_abtl_ht)
	
	; ----------------------------------------------
    ))
	; ----------------------------------------------	
		
	; Anteil AT-Neigung (vertikal)
	; ----------------------------------------------
    (if (= 1 2)	(progn
	; ----------------------------------------------
	(setq	s_ht 		(Traeger.get Htrg s)
		delta_v_ht	(Traeger.get Htrg delta_v)
	)
	
	(setq tRechts   (Traeger.get Tr_ID rechts))
	(setq VWinkel_E (TrEnde.get tRechts V_Winkel))
;	(print VWinkel_E)
	(setq HWinkel_E (TrEnde.get tRechts H_Winkel))
;	(print HWinkel_E)
	
	(setq kpl_dp (Blech.get Blech_ID dp))
	(setq kpl_dp (* 1.0 kpl_dp))			;; AF 08-2009 --- dp sollte nicht bercksichtigt werden
	
	(setq at_qwinkel (Connect.get CastaData v-atrgewnkl_steg))
	(if (/= at_qwinkel 90.0) (progn
		;; AF - Meldung eingesetzt, da aus Zeitgrnden Code von DM nicht komplett nachvollzogen werden konnte
		;; muss noch einmal komplett durchgesehen werden.
		(alertBox "Bei dieser Winkelkonstellation gibt es derzeit Abweichungen der Schrauben im Trgersteg!" "WRN_OffsetDiscrepancy_Web")
	))
	
	(setq tanQW (tan (/ (* PI at_qwinkel) 180.0)))
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq abstQ (+ (* 0.5 s_ht) kpl_dp (- delta_v_ht))))
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq abstQ (+ (* 0.5 s_ht) kpl_dp delta_v_ht)))
	
	(setq anteil_qneigung (/ abstQ tanQW))
	
;	(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_qneigung)))
;	(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_qneigung)))
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_qneigung)))
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_qneigung)))
	; ----------------------------------------------
	(setq  delta_lr_abtl_ht (- delta_lr_abtl_ht))
	; (setq delta_lr_abtl_ht 0.0)

    ))
	; ----------------------------------------------	
;#################################################################
    ; seitlicher Versatz aus Haupttrger - Steg, delta_LR und Kopfplattendicke
    (if (= 2 2) (progn
	(if (= (Connect.get CastaData linkesEnde)  1) (setq AT_Ende   (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1) (setq AT_Ende   (Traeger.get Tr_ID rechts)))
	(setq VWinkel_E (TrEnde.get AT_Ende V_Winkel))
	(setq HWinkel_E (TrEnde.get AT_Ende H_Winkel))
	
	(setq	s_ht 		(Traeger.get Htrg s)
		dlr_HT		(Traeger.get Htrg delta_LR)
		kpl_dp		(Blech.get Blech_ID dp)
		kpl_dp 		(* 1.0 kpl_dp)
	)

	(setq cosw_VWnkl (cos (/ (* PI VWinkel_E) 180.0)))
	(setq cosw_HWnkl (cos (/ (* PI HWinkel_E) 180.0)))

	(setq tanw_VWnkl (tan (/ (* PI VWinkel_E) 180.0)))
	(setq sinw_VWnkl (sin (/ (* PI VWinkel_E) 180.0)))

	(setq dlV_Local  (* cosw_VWnkl (+ (* (- sinw_VWnkl) kpl_dp) (* 0.5 s_ht))))
	(setq delta_v_abtl_ht (- delta_v_abtl_ht dlV_Local))

	(setq Abstand (+ kpl_dp (* 0.5 s_ht)))
	(if (= (Connect.get CastaData amhtsteglinks )  1) (setq Abstand (- Abstand dlr_HT)))
	(if (= (Connect.get CastaData amhtstegrechts ) 1) (setq Abstand (+ Abstand dlr_HT)))
	
	
	(setq tanw_HWnkl (tan (/ (* PI (- HWinkel_E 90.0)) 180.0)))
	(setq dlH_Local  (* tanw_HWnkl 	Abstand))

	(if (= (Connect.get CastaData amhtstegrechts ) 1) (setq dlH_Local (- dlH_Local)))

	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht dlH_Local))
	
    ))
;#################################################################

	; TRAEGERVERSCHIEBUNGEN
	; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		
	; Anteil delta_v Verschiebung HT
	; ----------------------------------------------
    (if (= 1 1)	(progn
	; ----------------------------------------------
	(setq delta_v_ht (Traeger.get Htrg delta_v))


									; 	Winkel war nicht bercksichtigt
									; AF -  04-2012 Winkeldeutung verbessert
									; AF -	11-2012 Winkel nochmals korrigiert.
	(print delta_v_abtl_ht)
	
;	11-2012 AF - herausgenommen und mit neuem Winkel korrigiert
;	(setq cosWLokal (cos (/ (* PI (+ abtl_winkel_ht 90.0)) 180.0))) ; neue Winkelberechnung
	(setq WLokal (- abtl_winkel_ht 90.0))
	(setq cosWLokal (cos (/ (* PI WLokal) 180.0))) ; neue Winkelberechnung
	
	(setq anteil_delta_v_ht (* delta_v_ht cosWLokal))		; AF - 	04-2012 gendert
	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_ht))
	

									; AF - Ende nderung

	(setq anteil_delta_v_ht (* delta_v_ht    sinW))	
	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_delta_v_ht))
	; ----------------------------------------------
    ))

	; ----------------------------------------------

	; Anteil delta_v Verschiebung AT
	; ----------------------------------------------
    (if (= 1 1)	(progn
	; ----------------------------------------------
	(setq delta_v_at (Traeger.get Tr_ID delta_v))
	; Sinus neu berechnen - Endwinkel des Profils wurde jetzt herangezogen
	(setq sinW (sin (* PI (/ EVWnkl_AT 180.0))))
	
	(if (/= sinW 0.0)
		(setq anteil_delta_v_at (/ (* 1.0 delta_v_at) sinW))
		(setq anteil_delta_v_at delta_v_at)
	)
	
	; AF - 08-2009 gendert - herauskommentiert ...

	; AF - 04-2012 komplett gendert - Winkeldefinition verbessert
	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_at))
	
	(print "nach der Berechnung - delta_V AT bercksichtigt...")
	(print delta_v_abtl_ht)
	; ----------------------------------------------
    ))
	; ----------------------------------------------
	
	

; (debug on)
; (print "*clear*")

	; Anteil delta_lr Verschiebung AT
	; ----------------------------------------------
    (if (= 1 1)	(progn
	; ----------------------------------------------
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	(print delta_lr_at)
	(print sinW)
	
	(if (/= sinW 0.0)
		(setq anteil_delta_lr_at (/ delta_lr_at sinW))
		(setq anteil_delta_lr_at 0)
	)
	(setq anteil_delta_lr_at delta_lr_at)
	(print "Versuch 1") (print anteil_delta_lr_at)

	(if (= (Connect.get CastaData linkesEnde)  1) (setq AT_Ende   (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1) (setq AT_Ende   (Traeger.get Tr_ID rechts)))
	(setq VWinkel_E (TrEnde.get AT_Ende V_Winkel))
	(setq HWinkel_E (TrEnde.get AT_Ende H_Winkel))

	(setq cosW_EH (cos (* PI (/ (- HWinkel_E 90.0) 180.0))))
	(print HWinkel_E)
	(print cosW_EH)
	(if (/= cosW_EH 0.0)
		(setq anteil_delta_lr_at (/ delta_lr_at cosW_EH))
		(setq anteil_delta_lr_at 0)
	)
	(print "Versuch 2") (print anteil_delta_lr_at)
								; AF - 08-2009 Korrektur Beginn
;AF	(if (= (Connect.get CastaData vatr-vhtr) -1)
;		(progn
;			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_delta_lr_at)))
;			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_delta_lr_at)))
;		)
;	)
;	(if (= (Connect.get CastaData vatr-vhtr)  1)
;		(progn
;			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_delta_lr_at)))
;			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_delta_lr_at)))
;		)
;AF	)
								; AF - 08-2009 Korrektur Ende Herauskommentierung

	; AF - 04-2012 erneute Korrektur, weil der RWinkel-AT untersucht und ggflls. umgedreht wurde.
;	(setq delta_lr_abtl_ht 0.0)
	
	(if (= (Connect.get CastaData amHtStegLinks)  1) (progn
		(if (= (Connect.get CastaData rechtesEnde)  1) 	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_delta_lr_at)))
		(if (= (Connect.get CastaData linkesEnde)   1) 	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_delta_lr_at)))
	))
	(if (= (Connect.get CastaData amHtStegRechts)  1) (progn
		(if (= (Connect.get CastaData rechtesEnde)  1) 	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_delta_lr_at)))
		(if (= (Connect.get CastaData linkesEnde)   1) 	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_delta_lr_at)))
	))
								; AF - 03-2012 Korrektur Ende Einfgung
	; ----------------------------------------------
    ))
	; ----------------------------------------------
	
;	(print "*clear*")
;	(Connect.ShowAttributes CastaData)

    (if (= 1 1) (progn
    	(setq rWinkel_Steg (Connect.get CastaData r-atrgewnkl_steg))
	(setq trRWinkel (Traeger.get Tr_ID R_Winkel))
	(setq rWinkel_Steg trRWinkel)

    	(setq sinWR (sin (* PI (/ rWinkel_Steg 180.0))))
    	(setq cosWR (cos (* PI (/ rWinkel_Steg 180.0))))

    	
    	(setq vAbtl_HT  delta_v_abtl_ht)
    	(setq lrAbtl_HT delta_lr_abtl_ht)

	(print vAbtl_HT)
	(print lrAbtl_HT)
	
;	(setq delta_v_abtl_ht  0.0)
;	(setq delta_lr_abtl_ht 0.0)

;	11-2012 Korrektur AF    - ganz wieder herausgenommen - Winkel wird vorher schon bercksichtigt.	
;	(setq delta_v_abtl_ht  (+ (* cosWR (+ vAbtl_HT)) (* sinWR (- lrAbtl_HT))))
;	(setq delta_v_abtl_ht  (+ (* sinWR (+ vAbtl_HT)) (* cosWR (- lrAbtl_HT))))


	(print  delta_v_abtl_ht)
	(print  delta_lr_abtl_ht)

	(print sinWR) (print cosWR)
    	
    ))
    ; Das muss jetzt hier erfolgen ...
    (setq delta_v_abtl_ht (- delta_v_abtl_ht vscherl_at_halb))


	
	(print "Werte, die endltig eingesetzt werden .............................................")
	(print  delta_v_abtl_ht)
	(print  delta_lr_abtl_ht)
	

	
	(Traeger.addAbtl Htrg Lochb_ID xPos_ht abtl_winkel_ht _steglochbild_system_)
	
	(setq lb_abtl_at (Traeger.get Tr_ID Abteil Lochb_ID))
	(setq lb_abtl_ht (Traeger.get Htrg Abteil Lochb_ID))
	
	(Anbauteil.set lb_abtl_at	(Master 	0)
					(delta_v 	delta_v_abtl_at)
	)
	(Anbauteil.set lb_abtl_ht	(Master 	1)
					(delta_v 	delta_v_abtl_ht)
					(delta_lr	delta_lr_abtl_ht)
	)

	; AF - 04-2012 -	Fr asymmetrische Lochbilder Richtung anpassen
	;			Bei Gegenanschlssen aber kritisch - nochmal berarbeiten
	(if (= (Connect.get CastaData amHTStegLinks) 1) (progn
	        (if (= (Connect.get CastaData RechtesEnde) 1) (progn
			(Anbauteil.set lb_abtl_ht	(SeitRicht 	-1))
	        ))
	))
	(if (= (Connect.get CastaData amHTStegRechts) 1) (progn
	        (if (= (Connect.get CastaData LinkesEnde) 1) (progn
			(Anbauteil.set lb_abtl_ht	(SeitRicht 	-1))
	        ))
	))

	
	
	(if (= qsform_ht "K") (progn
	    (setq abst_Achse (Traeger.get HTrg b)
	          abst_Achse (/ abst_Achse 2.0)
	    )
	    (if (= (Connect.get CastaData amHTStegLinks) 1) (setq abst_Achse (- abst_Achse)))
	    (Anbauteil.set lb_abtl_ht	(delta_sx 	abst_Achse)
	    				(Master 	0)
	    )
	    (Anbauteil.set lb_abtl_at	(Master 	1))
	    (Lochbild.set Lochb_ID 	(dxsKopf	0))
	))
	    
	
	; LOCHBILD-TEST
	; --------------------------------------------------------------------------------------
	(if (= LB_DEBUG 1)
		(progn
			
			(setq lbdummy (Lochbild.create))
			(Lochbild.copy lbdummy Lochb_ID)
			
			(if (= (connect.get CastaData LinkesEnde) 1) (traeger.addabtl Tr_ID lbdummy 0.0 0.0 _kpllochbildlinks_))
			(if (= (connect.get CastaData RechtesEnde) 1) (traeger.addabtl Tr_ID lbdummy 0.0 0.0 _kpllochbildrechts_))
			
			(setq abtl_lb_at_dummy (Traeger.get Tr_ID Abteil lbdummy))
			(Anbauteil.set abtl_lb_at_dummy (Master 1)
							(delta_v delta_v_abtl_at)
			)
			
		)
	)
	; --------------------------------------------------------------------------------------
	
; (debug off)	
	(print "<-----------------------------------------------------------")	
)





; ----------------------------------------------------------------------------------------
; Verlngert bzw. Verkrzt das Sttzenende
; ----------------------------------------------------------------------------------------
(defun korrigiereStzEnde ()
	(print ">-----------------------------------------------------------")
	(print "KORRIGIERE STZ-ENDE")
	(print "------------------------------------------------------------")

	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(progn
			(setq delta_l_stz (- rand))
			(setq HT_Ende (Traeger.get Htrg links))
		)
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(progn
			(setq delta_l_stz (- rand))
			(setq HT_Ende (Traeger.get Htrg rechts))
		)
	)


	(setq delta_lr (Traeger.get Tr_ID delta_lr))
	(setq bp       (Blech.get   kpl_blech   bp))
	(if (= (Connect.get CastaData sATr-lHTr) -1) (progn
	      (setq delta_L_UZ (- (* 0.5 bp) delta_lr))
	      (print delta_L_UZ)
	      (TrEnde.set HT_Ende (delta_l (- delta_L_UZ)))
	))
	(if (= (Connect.get CastaData sATr-lHTr)  1) (progn
	      (setq delta_L_UZ (+ (* 0.5 bp) delta_lr))
	      (print delta_L_UZ)
	      (TrEnde.set HT_Ende (delta_l (- delta_L_UZ)))
	))


	
	(if (= (Connect.get CastaData sATr-lHTr) 0) (progn
		(setq delta_l_alt (TrEnde.get Ht_Ende delta_l))
		(print delta_l_alt)
		(print rand)
	
		(setq delta_l_stz (- delta_l_alt rand))
	
		(TrEnde.set HT_Ende (delta_l delta_l_stz))
	))
	(print "<-----------------------------------------------------------")	
)

; ----------------------------------------------------------------------------------------
; bernimmt das gegenberliegende Lochbild
; ----------------------------------------------------------------------------------------
(defun getExistingLochbild ()
;	(print "*clear*")
; ---------------------------------------------------------------------
(alertBox "
Auf der gegenberliegenden Seite ist bereits ein Anschluss vorhanden.\n
Nehmen Sie nderungen ggf. manuell vor.\n
\n
Kontrollieren Sie bitte auch den Rotationswinkel der anschlieenden Trger!\n
Unterschiedliche Rotationswinkel fhren zu fehlerhaften Werkstattzeichnungen.
"
"NOTE_OppositeConnectionFound_RotAngle")
; ---------------------------------------------------------------------
	
	(print ">-----------------------------------------------------------")
	(print "BERNEHME LOCHBILD")
	
	(setq dp_kpl (Blech.get kpl_blech dp))
	(print dp_kpl)

	(setq delta_w (Lochbild.get kpl_lochbild delta_w))
	(if (/= delta_w 0) (progn
	     (alertBox "
Bei diesem Gegenanschluss liegt bereits ein asymmetrisches Lochbild vor.\nLochbild wird symmetrisch gestaltet.\n
\n
Bitte korrigieren Sie ggflls. die Kopfplatten an den Trgerenden der beiden Anschlsse!
"
"NOTE_OppositeSideConnection_symmetrical_Holepattern")
	     (Lochbild.set lchbBlech (delta_w 0))
	))
			
	(setq klemml_alt 	(Lochbild.get kpl_lochbild klemml))
	(setq dxskopf_alt	(Lochbild.get kpl_lochbild dxsKopf))
	(print klemml_alt)
	(print dxskopf_alt)
			
	(setq klemml_neu 	(+ klemml_alt dp_kpl))
	(setq dxskopf_neu (+ dxskopf_alt dp_kpl))
	(print klemml_neu)
	(print dxskopf_neu)
			
	(Lochbild.set kpl_lochbild (klemml klemml_neu))									
				
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(Lochbild.set kpl_lochbild (dxsKopf dxskopf_neu))
	)
	
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(traeger.addabtl tr_id kpl_lochbild 0.0 0.0 _kpllochbildrechts_)
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
		(traeger.addabtl tr_id kpl_lochbild 0.0 0.0 _kpllochbildlinks_)
	)
			
			
	(setq	delta_v_at 	(Traeger.get Tr_ID delta_v)
		delta_v_ht 	(Traeger.get HTrg  delta_v)
		delta_lt_at	(traeger.get Tr_ID delta_lr)
	)
			
	(setq loch_at_abtl (Traeger.get Tr_ID Abteil kpl_lochbild))
	(setq loch_ht_abtl (Traeger.get Htrg  Abteil kpl_lochbild))	  
	
	(setq	delta_v_abtl_ht 	(Anbauteil.get loch_ht_abtl delta_v)
		delta_lr_abtl_ht	(Anbauteil.get loch_ht_abtl delta_lr)
		h_ht			(Traeger.get Htrg h)
	)

	(setq	delta_v_abtl_at 	(Anbauteil.get loch_at_abtl delta_v)
		delta_lr_abtl_at	(Anbauteil.get loch_at_abtl delta_lr)
		h_at			(Traeger.get Tr_ID h)
	)
	
	(setq	delta_v_gesamt (- (* 0.5 h_at) delta_v_at (- delta_v_ht)))
	(print	delta_v_gesamt)

	(print delta_v_abtl_at)
	(print delta_lr_abtl_at)
	(print delta_v_at)
	(print delta_v_abtl_ht)
	(print delta_lr_abtl_ht)
	
;	(setq delta_v_abtl_at_neu (- (- delta_v_at) delta_v_abtl_ht))
	(setq delta_v_abtl_at_neu (+ delta_v_gesamt delta_v_abtl_ht))
	(setq delta_v_vorhanden 0.0)

;	Korrektur Feb.2011 (AF)
;	kompletter neuer Abschnitt	
	(setq ABTeilVorhanden (Traeger.get Htrg ABTeil kpl_lochbild))
	
	(if ABTeilVorhanden
		(progn
			(print "Anbauteil am Haupttrger gefunden.")
			; Vorbereitung Korrektur - Feb.2011 
			; Es gibt leider zwei verschiedene Steglochbildtypen
			; eines ist auf die Systemachse bezogen, das andere auf die OK des Trgers (hier des HT)
			; deswegen muss noch in einem Fall die halbe Hhe des HT bercksichtigt werden.
			(setq Steg_LB 	  131072)	; auf OK bezogen
			(setq Steg_LB_Sys 33554432)	; auf Achse bezogen (nur zur Verdeutlichung)

			(setq isType_1 (Anbauteil.get ABTeilVorhanden is_type Steg_LB))
			(setq isType_2 (Anbauteil.get ABTeilVorhanden is_type Steg_LB_Sys))

			(setq delta_v_vorhanden (Anbauteil.get ABTeilVorhanden delta_v))
			(print delta_v_vorhanden)
			
			(setq winkel_ht_lb_abtl (Anbauteil.get ABTeilVorhanden winkel))
			(print winkel_ht_lb_abtl)
			
; 			--------------------------------------------
;	-	-	korrigiert Feb. 2011 - (AF)
;			korrigiert Aug. 2013 - (AF)  Konstellation HT auf dem Kopf
			(if (> (Connect.get CastaData vAtr-vHtr) 0) (progn
				(setq delta_v_gesamt (+ (* 0.5 h_at) delta_v_vorhanden))
				(setq delta_v_gesamt (+ delta_v_gesamt delta_v_ht))
				(setq delta_v_gesamt (- delta_v_gesamt delta_v_at))
				
				(if (= isType_1 1) (setq delta_v_gesamt (- delta_v_gesamt (* 0.5 h_HT))))
			    )
			    (progn
				(setq delta_v_gesamt (- (* 0.5 h_at) delta_v_vorhanden))
				(setq delta_v_gesamt (- delta_v_gesamt delta_v_ht))
				(setq delta_v_gesamt (- delta_v_gesamt delta_v_at))
			
				(if (= isType_1 1) (setq delta_v_gesamt (+ delta_v_gesamt (* 0.5 h_HT))))
			))
;			Ende Korrektur
		)
	)
	
	
	(setq	dlr_AT	(Traeger.get TR_ID delta_LR)
		dv_AT	(Traeger.get TR_ID delta_V)
	)
	
	(setq delta_lr_abtl_AT 0.0)
	(if (= (Connect.get CastaData sAtr-lHtr) -1) (setq delta_lr_abtl_AT (+ dlr_AT delta_lr_abtl_HT)))
	(if (= (Connect.get CastaData sAtr-lHtr)  1) (setq delta_lr_abtl_AT (- dlr_AT delta_lr_abtl_HT)))

	(setq delta_V_abtl_AT 0.0)
	(if (= (Connect.get CastaData vAtr-vHtr) 0) (progn
	    (setq h_AT_Halbe (* 0.5 h_at))
	    (if (= (Connect.get CastaData vAtr-lHtr) -1) (setq delta_V_abtl_AT (- (+ delta_v_vorhanden h_AT_Halbe) dv_AT)))
	    (if (= (Connect.get CastaData vAtr-lHtr)  1) (setq delta_V_abtl_AT (- (+ delta_v_vorhanden h_AT_Halbe) dv_AT)))
	    
	    
	))

	(Anbauteil.set loch_at_abtl (Master 	0)
		(delta_v 	delta_V_abtl_AT)
		(delta_lr 	delta_lr_abtl_AT)
	)				
	
	(print "<-----------------------------------------------------------")				
)


; ---------------------------------------------------------------------------------
; Korrigiert das Traegerende des AT
; ---------------------------------------------------------------------------------
(defun korrAtEnde (abst)
	; Abstnde zum Ht korrigieren
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID rechts))
	)
	
	(setq s_ht			(Traeger.get Htrg s)
				qsform_ht	(Traeger.get Htrg qsform)
	)
	
	
	
	(TrEnde.ptrim AtEnde (- abst))
			
	
)


; ----------------------------------------------------------------------------------------
; berprft, ob der Anschluss in der bestehenden Positionierung eingebaut werden kann
; ----------------------------------------------------------------------------------------
(defun checkPosition (Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "BERPRFE POSITION")
	
	; Oberkante HT
	(setq h_ht 				(Traeger.get Htrg h)
				r_ht				(Traeger.get Htrg r)
				t_ht				(Traeger.get Htrg t)
				hc_ht				(Traeger.get Htrg hc)
				delta_v_ht	(Traeger.get Htrg delta_v)
	)
	(setq h_ht_halb	(* 0.5 h_ht))
	
	(setq h_at 				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	(setq h_at_halb	(* 0.5 h_at))
	
	(setq kpl_hp			(Blech.get Blech_ID hp)
				kpl_bp			(Blech.get Blech_ID bp)
	)
	(setq kpl_hp_halb	(* 0.5 kpl_hp))
	(setq kpl_bp_halb	(* 0.5 kpl_bp))
	
	
	(setq oGrenze_ht (- delta_v_ht (- h_ht_halb r_ht t_ht)))
	(setq uGrenze_ht (+ oGrenze_ht hc_ht))
	(print oGrenze_ht)
	(print uGrenze_ht)
	
	(if (= (Connect.get CastaData satr-vhtr)  1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)
				(progn
					(setq oGrenze_kpl	(- delta_lr_at kpl_bp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_bp))
				)
			)
			(if (= (Connect.get CastaData vatr-lhtr) -1)
				(progn
					(setq oGrenze_kpl	(- delta_lr_at kpl_bp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_bp))
				)
			)
		)
	)
	(if (= (Connect.get CastaData satr-vhtr) -1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)
				(progn
					(setq oGrenze_kpl	(- (- delta_lr_at) kpl_bp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_bp))
				)
			)
			(if (= (Connect.get CastaData vatr-lhtr) -1)
				(progn
					(setq oGrenze_kpl	(- (- delta_lr_at) kpl_bp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_bp))
				)
			)
		)
	)
	
	(if (= (Connect.get CastaData vatr-vhtr)  1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)
				(progn
					(setq oGrenze_kpl	(- delta_v_at kpl_hp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_hp))
				)
			)
			(if (= (Connect.get CastaData satr-lhtr) -1)
				(progn
					(setq oGrenze_kpl	(- delta_v_at kpl_hp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_hp))
				)
			)
		)
	)
		(if (= (Connect.get CastaData vatr-vhtr) -1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)
				(progn
					(setq oGrenze_kpl	(- (- delta_v_at) kpl_hp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_hp))
				)
			)
			(if (= (Connect.get CastaData satr-lhtr) -1)
				(progn
					(setq oGrenze_kpl	(- (- delta_v_at) kpl_hp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_hp))
				)
			)
		)
	)
	(print oGrenze_kpl)
	(print uGrenze_kpl)
	
	
	(setq ShowWarning 1)
	(setq qsform_ht (Traeger.get HTrg qsform))
	(if (= qsform_ht "U") (if (= (Connect.get CastaData amHtSteglinks) 1) (setq ShowWarning 0)))
	
	(if (= ShowWarning 1) (progn
	  (if (>= oGrenze_kpl oGrenze_ht)
		(progn
			(if (<= uGrenze_kpl uGrenze_ht)
				(progn
					(print "OK")
				)
				(progn
					(alertBox "Die Kopfplatte reicht in die untere Ausrundung den Haupttrgers.\nBitte korrigieren Sie die Positionierung der Trger oder passen Sie die Kopfplatte an!" "Headplate_To_Fit_FilletBottom")
				)
			)
		)
		(progn
			(alertBox "Die Kopfplatte reicht in die obere Ausrundung den Haupttrgers.\nBitte korrigieren Sie die Positionierung der Trger oder passen Sie die Kopfplatte an!" "Headplate_To_Fit_FilletTop")
		)
	  )
	))
	
	(print "<-----------------------------------------------------------")
)