(defun load-modules ()
   (load "mod-endinit-stz-fund")
	 (load "mod-lochbild")
)

(defun init-connection ()
  (print "********************************************************************")
  (print "in init-connection - fundSimple1 - Sttze auf Fundament");

	;(connect.ShowAttributes CastaData)
	
  ;(print Aufl_ID)
  ;(setq dOK (koecher.get Aufl_ID delta_V))		(print dOK)	; vertikale Verschiebung
  ;(setq dLR (koecher.get Aufl_ID delta_LR))		(print dLR)	; horizontale Verschiebung
  
	(init-stzfund)
	(init-traegerende)
   
	; Fussplatte
	; ----------------------------------------------
	(setq fussPl	(Blech.create))
	(Connect.storeAnschlObjs CastaData fussPl)
	
	; Erzeugen der Fussplatte
	; ----------------------------------------------
	(createFussplatte fussPl)

	
	; Lochbild der Ankerschraube
	; ----------------------------------------------
	(setq AnkerLchb (Lochbild.create))
	(Connect.storeAnschlObjs CastaData AnkerLchb)
	
	; Erzeugen des Lochbildes
	; ----------------------------------------------
	(setAnkerlochbild  AnkerLchb fussPl)
  ;(printv)
  
  
  ; CALLBACKS
  (Blech.set fussPl (formFkt "cb_fussPl"))
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Fussplatte am HT
; ----------------------------------------------------------------------------------------
(defun cb_fussPl (zp)
	(print "in Callback-Funktion cb_fussPl")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get fussPl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get fussPl dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
		    (setq dpDiff (- dpNeu dpAlt))
		    (setq alteKlemml (Lochbild.get AnkerLchb Laenge))
		    (setq dxsKopf_alt	(Lochbild.get AnkerLchb dxSKopf))
		       
		    ; (Lochbild.set AnkerLchb 	(Laenge (+ alteKlemml dpDiff)))
		       
	    ))
	))
)

; ----------------------------------------------------------------------------------------
; ERZEUGT DIE FUSSPLATTE
; ----------------------------------------------------------------------------------------
(defun createFussplatte (fussPl)
	
	; allg. Daten holen
	; ----------------------------------------------
	(setq h_stz (Traeger.get Tr_ID h)
				b_stz	(Traeger.get Tr_ID b)
				t_stz	(Traeger.get Tr_ID t)
	)
	
	; berstand der Fussplatte an jeder Seite
	; ----------------------------------------------
	(setq ueb (runde (* 4.0 t_stz) auf 10))
	
	; Trgerende bestimmen
	; ----------------------------------------------
	(if (= (Connect.get CastaData LinkesEnde) 1)	(setq TrgEnde (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData RechtesEnde) 1)	(setq TrgEnde (Traeger.get Tr_ID rechts)))
	
	
	; Hhe der Fussplatte
	; ----------------------------------------------
	(setq hp_fpl (+ h_stz (* 2.0 ueb)))
	
	; Breite der Fussplatte
	; ----------------------------------------------
	(setq bp_fpl (+ b_stz (* 2.0 ueb)))
	
	; Dicke der Fussplatte
	; ----------------------------------------------
	(setq dp_fpl (runde (* 2.0 t_stz) auf 10))
		
	; Werte setzen
	; ----------------------------------------------
	(Blech.set fussPl (hp 	hp_fpl)
										(bp 	bp_fpl)
										(dp 	dp_fpl)										
	)
	
	; Fussplatten-Anbauteil der Sttze hinzufgen
	; ----------------------------------------------
	(if (= (Connect.get CastaData LinkesEnde) 1)
		(Traeger.addabtl Tr_ID fussPl 0.0 0.0 _fussplattelinks_)
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(Traeger.addabtl Tr_ID fussPl 0.0 0.0 _fussplatterechts_)
	)
	
	; Trgerende abtrimmen
	; ----------------------------------------------
	(TrEnde.ptrim TrgEnde dp_fpl)
)


; ----------------------------------------------------------------------------------------
; ERZEUGT DAS LOCHBILD
; ----------------------------------------------------------------------------------------
(defun setAnkerlochbild  (AnkerLchb BLECH_ID)
	(print "setze Daten fr das Ankerlochbild")
	
	(print AnkerLchb)

	(Lochbild.set AnkerLchb
		(S_Bez   "M36")
		(Guete   "4.6")
		(e       "0 0 0 0 0 0")
		(w       "200  0")
		(Laenge  350)
	)
	
	; Schraubenbezeichnung
	; ----------------------------------------------
	(setq min_blech (Blech.get BLECH_ID dp))
	(calcSchraube min_blech) -> S_Bez
	
	; Schraubenbezeichnung setzen
	; ----------------------------------------------
	(Lochbild.set AnkerLchb (S_Bez S_Bez))
	
	
	; w0 berechnen
	; ----------------------------------------------
	(setq bp_fusspl (Blech.get BLECH_ID bp))
	
	(setq w0 (* 0.5 bp_fusspl))
	(setq w0_rund w0)
	
	
	; Lochbild-Anbauteil der Sttze hinzufgen
	; ----------------------------------------------
	(if (= (Connect.get CastaData linkesEnde) 1)
		(Traeger.addabtl Tr_ID AnkerLchb 0.0 0.0 _kpllochbildlinks_)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(Traeger.addabtl Tr_ID AnkerLchb 0.0 0.0 _kpllochbildrechts_)
	)

	
  (setq Abtl_AnkLchb (traeger.get Tr_ID ABTeil AnkerLchb))
  (Anbauteil.set Abtl_AnkLchb (Master 1))

  (Lochbild.set AnkerLchb	(Lb_Art   16)
    											(anz_s 2)
    											(Montage _gebogene_ankerSchraube_)
													(w0 w0)
  )

)

