(defun load-modules ()
   (load "mod-endinit-stz-fund")
)

(defun init-connection ()
  (print "********************************************************************")
  (print "in init-connection - fundSimple1 - Sttze auf Fundament");

	(connect.ShowAttributes CastaData)
	
  ;(print Aufl_ID)
  ;(setq dOK (koecher.get Aufl_ID delta_V))		(print dOK)	; vertikale Verschiebung
  ;(setq dLR (koecher.get Aufl_ID delta_LR))		(print dLR)	; horizontale Verschiebung
  
	(init-stzfund)
	(init-traegerende)
   
	(setKonstanten)						  ; Konstanten festlegen

	(setq Stf_Variante 0)
	(checkVariante)						  ; Schrauben quadratisch oder rechteckig
	
	(setq	FlFl_Blech_links	(Blech.create))
	(setq	FlFl_Blech_rechts (Blech.create))
	
	(setq	FlK_Blech_ObenLinks		(Blech.create))
	(setq	FlK_Blech_ObenRechts		(Blech.create))
	(setq	FlK_Blech_UntenLinks		(Blech.create))
	(setq	FlK_Blech_UntenRechts	(Blech.create))

	; Grundgren einstellen, weil andere Bleche davon abhngig sind:
	(Blech.set  FlFl_Blech_links (dp 10))
	(Blech.set  FlFl_Blech_rechts (dp 10))
	
	; Fuplatte erzeugen un initialisieren
	(setq fussPl								(Blech.create))
	(createFussplatte fussPl)
	(Connect.storeAnschlObjs CastaData fussPl)

	; Lochbild auf der Fuplatte erzeugen
	(setq AnkerLchb (Lochbild.create))
	(Connect.storeAnschlObjs CastaData AnkerLchb)
	(setAnkerlochbild  AnkerLchb fussPl)
	
	; Ausstreifungsbleche auf den Flanschflchen erzeugen und initialisieren
	(if (= Stf_Variante 1) (progn
		(setq Bl_AusStf_OberFl		(Blech.create))
		(setq Bl_AusStf_UnterFl		(Blech.create))
		(createAussteifung Flansch_Flaechen Bl_AusStf_OberFl Bl_AusStf_UnterFl fussPl)
	
		(Connect.storeAnschlObjs CastaData Bl_AusStf_OberFl Bl_AusStf_UnterFl)
		(Blech.set Bl_AusStf_OberFl (formFkt "cb_FlanschMittenStfBl"))
		(Blech.set Bl_AusStf_UnterFl (formFkt "cb_FlanschMittenStfBl"))
	))
	(Connect.storeAnschlObjs CastaData FlFl_Blech_links FlFl_Blech_rechts)
	(Connect.storeAnschlObjs CastaData  FlK_Blech_UntenLinks		FlK_Blech_ObenLinks)
	(Connect.storeAnschlObjs CastaData  FlK_Blech_UntenRechts	FlK_Blech_ObenRechts)
	
	
	(createAussteifung Flansch_KantenLinks		FlK_Blech_UntenLinks		FlK_Blech_ObenLinks fussPl)
	(createAussteifung Flansch_KantenRechts	FlK_Blech_UntenRechts	FlK_Blech_ObenRechts fussPl)

	(createFlanschkantenBl flfl_Blech_links flfl_Blech_rechts fussPl)
	(move_Steifen Flansch_Aussenblech       flfl_Blech_links flfl_Blech_rechts fussPl)

  ;(printv)
  
  
  ; CALLBACKS
  (Blech.set fussPl (formFkt "cb_fussPl"))
  
  (Blech.set FlFl_Blech_links (formFkt "cb_AussenFlaechenBl"))
  (Blech.set FlFl_Blech_rechts (formFkt "cb_AussenFlaechenBl"))

  (Blech.set FlK_Blech_UntenLinks (formFkt "cb_AussenFlaechenStfBl"))
  (Blech.set FlK_Blech_ObenLinks (formFkt "cb_AussenFlaechenStfBl"))

  (Blech.set FlK_Blech_UntenRechts (formFkt "cb_AussenFlaechenStfBl"))
  (Blech.set FlK_Blech_ObenRechts  (formFkt "cb_AussenFlaechenStfBl"))
  
)
; --------------------------------------------------------------------------------------
(defun setKonstanten ()
			(setq Flansch_Flaechen			1);  Flag fr Aussteifeung and der Flanschflche oben und unten
			(setq Flansch_KantenLinks		2);  Flag fr Aussteifeung and der Flanschkante Oberflansch
			(setq Flansch_KantenRechts	3);  Flag fr Aussteifeung and der Flanschkante Unterflansch
			(setq Flansch_Aussenblech		4);  Flag Flansch-Auenblech von Flanschkante zu Flanschkante
)

; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================
(defun cb_AussenFlaechenBl (zp)

    (if (= (Connect.get CastaData CopyMode) 1) (progn
		(setq zp 100)
		(setKonstanten)
		(move_Steifen Flansch_Aussenblech       flfl_Blech_links flfl_Blech_rechts fussPl)
	))
	
	
	(if (= zp 0) (progn
		(print "cb_AussenFlaechenBl")
	    (setq dpAlt (Blech.get cb_subobjekt dp))
	    (setq hpAlt (Blech.get cb_subobjekt hp))
	    (setq bpAlt (Blech.get cb_subobjekt bp))

		; (if (= cb_Objekt  	FlFl_Blech_links) (AlertBox "FlFl_Blech_links"))
		; (if (= cb_Objekt  	FlFl_Blech_rechts) (AlertBox "FlFl_Blech_rechts"))
		; (if (= cb_subobjekt FlFl_Blech_links) (AlertBox "FlFl_Blech_links cb_subobjekt"))
		; (if (= cb_subobjekt FlFl_Blech_rechts) (AlertBox "FlFl_Blech_rechts cb_subobjekt"))
	))
	(if (= zp 1) (progn
		(setq ChangeBlech 0)
		(setKonstanten)
	
	    (setq dpNeu (Blech.get cb_subobjekt dp))
	    (setq hpNeu (Blech.get cb_subobjekt hp))
	    (setq bpNeu (Blech.get cb_subobjekt bp))

		(if (/= dpAlt dpNeu) (progn
				(if (objExist FlK_Blech_UntenLinks) (progn
					(setq xAsymAlt (Blech.get FlK_Blech_UntenLinks xAsym))
					(setq xAsymNeu (- xAsymAlt (- dpNeu dpAlt)))
					(Blech.set  FlK_Blech_UntenLinks 	 (xAsym  xAsymNeu))
				))
				(if (objExist FlK_Blech_UntenRechts) (progn
					(setq xAsymAlt (Blech.get FlK_Blech_UntenRechts xAsym))
					(setq xAsymNeu (+ xAsymAlt (- dpNeu dpAlt)))
					(Blech.set  FlK_Blech_UntenRechts (xAsym  xAsymNeu))
				))
				(if (objExist FlK_Blech_ObenLinks) (progn
					(setq xAsymAlt (Blech.get FlK_Blech_ObenLinks xAsym))
					(setq xAsymNeu (- xAsymAlt (- dpNeu dpAlt)))
					(Blech.set  FlK_Blech_ObenLinks 	 (xAsym  xAsymNeu))
				))
				(if (objExist FlK_Blech_ObenRechts) (progn
					(setq xAsymAlt (Blech.get FlK_Blech_ObenRechts xAsym))
					(setq xAsymNeu (+ xAsymAlt (- dpNeu dpAlt)))
					(Blech.set  FlK_Blech_ObenRechts (xAsym  xAsymNeu))
				))
				(setq ChangeBlech 1)
		))
		(if (/= hpAlt hpNeu) (setq ChangeBlech 1))
		(if (/= bpAlt bpNeu) (setq ChangeBlech 1))
		(if (= ChangeBlech 1) (progn
					; das jeweils andere Blech grenmig anpassen
					(setq Stf_OK 0)
					(if (objExist FlFl_Blech_links) (if (objExist FlFl_Blech_rechts) (progn
					  (setq Stf_OK 1)
					  (if (= cb_subobjekt  FlFl_Blech_links)   (Blech.set  FlFl_Blech_rechts (dp dpNeu) (hp hpNeu) (bp bpNeu)))
					  (if (= cb_subobjekt  FlFl_Blech_rechts)  (Blech.set  FlFl_Blech_links  (dp dpNeu) (hp hpNeu) (bp bpNeu)))
					)))

					(if (/= hpAlt hpNeu) (progn
						(if (= Stf_OK 1) (move_Steifen Flansch_Aussenblech       flfl_Blech_links flfl_Blech_rechts fussPl))
						(if (objExist FlFl_Blech_links)  (Adapt_Abschrg_an_Hoehe  flfl_Blech_links))
						(if (objExist FlFl_Blech_rechts) (Adapt_Abschrg_an_Hoehe  flfl_Blech_rechts))
					))
		))
	))
)
(defun cb_AussenFlaechenStfBl (zp)
 
	(AlertBox "cb_AussenFlaechenStfBl")

	(if (= (Connect.get CastaData CopyMode) 1) (progn
		(setq zp 100)
		(setKonstanten)
		(move_Steifen Flansch_KantenLinks 	FlK_Blech_UntenLinks 		FlK_Blech_ObenLinks fussPl)
		(move_Steifen Flansch_KantenRechts	FlK_Blech_UntenRechts	FlK_Blech_ObenRechts fussPl)
	))

	(if (= zp 0) (progn
		(print "cb_AussenFlaechenStfBl")
	    (setq dpAlt (Blech.get cb_subobjekt dp))
	    (setq hpAlt (Blech.get cb_subobjekt hp))
	    (setq bpAlt (Blech.get cb_subobjekt bp))
	))
	(if (= zp 1) (progn
		(setq ChangeBlech 0)
		(setKonstanten)

	    (setq dpNeu (Blech.get cb_subobjekt dp))
	    (setq hpNeu (Blech.get cb_subobjekt hp))
	    (setq bpNeu (Blech.get cb_subobjekt bp))

		(if (/= dpAlt dpNeu) (setq ChangeBlech 1))
		(if (/= hpAlt hpNeu) (setq ChangeBlech 1))
		(if (/= bpAlt bpNeu) (setq ChangeBlech 1))

		; zu ndernde Blech-Objekte
		;  FlK_Blech_UntenLinks
		;  FlK_Blech_ObenLinks
		;  FlK_Blech_UntenRechts
		;  FlK_Blech_ObenRechts

		
		(if (= ChangeBlech 1) (progn
				(if FlK_Blech_UntenLinks  (setBlechData FlK_Blech_UntenLinks  dpNeu hpNeu bpNeu))
				(if FlK_Blech_ObenLinks   (setBlechData FlK_Blech_ObenLinks   dpNeu hpNeu bpNeu))
				(if FlK_Blech_UntenRechts (setBlechData FlK_Blech_UntenRechts dpNeu hpNeu bpNeu))
				(if FlK_Blech_ObenRechts  (setBlechData FlK_Blech_ObenRechts  dpNeu hpNeu bpNeu))
				; (Blech.set  FlK_Blech_UntenLinks		(dp dpNeu) (hp hpNeu) (bp bpNeu))
				; (Blech.set  FlK_Blech_ObenLinks 		(dp dpNeu) (hp hpNeu) (bp bpNeu))
				; (Blech.set  FlK_Blech_UntenRechts 	(dp dpNeu) (hp hpNeu) (bp bpNeu))
				; (Blech.set  FlK_Blech_ObenRechts 		(dp dpNeu) (hp hpNeu) (bp bpNeu))
		
				(if FlK_Blech_UntenLinks (if FlK_Blech_ObenLinks
					(move_Steifen Flansch_KantenLinks 		FlK_Blech_UntenLinks 		FlK_Blech_ObenLinks fussPl)
				))
				(if FlK_Blech_UntenRechts (if FlK_Blech_ObenRechts
					(move_Steifen Flansch_KantenRechts	FlK_Blech_UntenRechts	FlK_Blech_ObenRechts fussPl)
				))

				(if (/= hpAlt hpNeu) (progn
						(if FlK_Blech_UntenLinks  (Adapt_Abschrg_an_Hoehe  FlK_Blech_UntenLinks))
						(if FlK_Blech_ObenLinks   (Adapt_Abschrg_an_Hoehe  FlK_Blech_ObenLinks))
						(if FlK_Blech_UntenRechts (Adapt_Abschrg_an_Hoehe  FlK_Blech_UntenRechts))
						(if FlK_Blech_ObenRechts  (Adapt_Abschrg_an_Hoehe  FlK_Blech_ObenRechts))
				))
		))
	))
)

(defun setBlechData (Bl_ID dpNeu hpNeu bpNeu)
	(if (objExist Bl_ID) (Blech.set  Bl_ID (dp dpNeu) (hp hpNeu) (bp bpNeu)))
)

(defun cb_FlanschMittenStfBl (zp)

	(AlertBox "cb_FlanschMittenStfBl")

    (if (= (Connect.get CastaData CopyMode) 1) (progn
		(setq zp 100)
		(setKonstanten)
				(move_Steifen Flansch_Aussenblech       Bl_AusStf_UnterFl Bl_AusStf_OberFl fussPl)
	))

	(if (= zp 0) (progn
	    (print  "cb_FlanschMittenStfBl")
	    (setq dpAlt (Blech.get cb_subobjekt dp))
	    (setq hpAlt (Blech.get cb_subobjekt hp))
	    (setq bpAlt (Blech.get cb_subobjekt bp))
	))
	(if (= zp 1) (progn
		(setq ChangeBlech 0)
		(setKonstanten)

	    (setq dpNeu (Blech.get cb_subobjekt dp))
	    (setq hpNeu (Blech.get cb_subobjekt hp))
	    (setq bpNeu (Blech.get cb_subobjekt bp))

		(if (/= dpAlt dpNeu) (setq ChangeBlech 1))
		(if (/= hpAlt hpNeu) (setq ChangeBlech 1))
		(if (/= bpAlt bpNeu) (setq ChangeBlech 1))
		
		(if (= ChangeBlech 1) (progn
				(if (= cb_subobjekt  Bl_AusStf_OberFl)  (Blech.set  Bl_AusStf_UnterFl (dp dpNeu) (hp hpNeu) (bp bpNeu)))
				(if (= cb_subobjekt  Bl_AusStf_UnterFl) (Blech.set  Bl_AusStf_OberFl (dp dpNeu) (hp hpNeu) (bp bpNeu)))
				
				(move_Steifen Flansch_Aussenblech       Bl_AusStf_UnterFl Bl_AusStf_OberFl fussPl)

				(if (/= hpAlt hpNeu) (progn
						(Adapt_Abschrg_an_Hoehe  Bl_AusStf_UnterFl)
						(Adapt_Abschrg_an_Hoehe  Bl_AusStf_OberFl)
				))

		))
		
	))
)
; ----------------------------------------------------------------------------------------
; Callback fr Fussplatte am HT
; ----------------------------------------------------------------------------------------
(defun cb_fussPl (zp)

;	(if (= (Connect.get CastaData CopyMode) 1) (setq zp 3)) ; Damit wird kein Callback durchlaufen, wenn kopiert wird.

	(print "in Callback-Funktion cb_fussPl")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get fussPl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get fussPl dp))
	    
	    (if (/= dpAlt dpNeu) (progn
		    (setq dpDiff (- dpNeu dpAlt))
		    (setq alteKlemml (Lochbild.get AnkerLchb Laenge))
		    (setq dxsKopf_alt	(Lochbild.get AnkerLchb dxSKopf))
		       
			(setKonstanten)						  ; Konstanten festlegen

			(setq run1 0 run2 0 run3 0)
			(if (objExist flfl_Blech_links)      (if (objExist flfl_Blech_rechts)    (setq run1 1)))
			(if (objExist FlK_Blech_UntenLinks)  (if (objExist FlK_Blech_ObenLinks)  (setq run2 1)))
			(if (objExist FlK_Blech_UntenRechts) (if (objExist FlK_Blech_ObenRechts) (setq run3 1)))
			
			;  Steifen an die Fuplatte heranschieben
			(if (= run1 1) (move_Steifen Flansch_Aussenblech	flfl_Blech_links		flfl_Blech_rechts 		fussPl))
			(if (= run2 1) (move_Steifen Flansch_KantenLinks	FlK_Blech_UntenLinks	FlK_Blech_ObenLinks 	fussPl))
			(if (= run3 1) (move_Steifen Flansch_KantenRechts	FlK_Blech_UntenRechts	FlK_Blech_ObenRechts	fussPl))
			
			;	Bl_AusStf_OberFl Bl_AusStf_UnterFl
			(if (objExist Bl_AusStf_OberFl) (progn
				(if (objExist Bl_AusStf_UnterFl) (progn
					(move_Steifen Flansch_Flaechen 			Bl_AusStf_OberFl  			Bl_AusStf_UnterFl 		fussPl)
				))
			))
		       
	    ))
	))
)
(defun cb_SteifenBl (zp)
	(if (= (Connect.get CastaData CopyMode) 1) (setq zp 3)) ; Damit wird kein Callback durchlaufen, wenn kopiert wird.
	(print "in Callback-Funktion cb_SteifenBl")
	(if (= zp 0) (progn
		(setq runCallback 0)
		(if (objExist  cb_subobjekt) (progn
			; (setq cb_Blech (Anbauteil.get cb_subobjekt objekt Blech))
			(setq cb_Blech cb_subobjekt)
			(setq runCallback 1)
		))
	))
	
	(if (= runCallback 1) (progn
		(print zp)
		;; Bei zp == 0 den alten Zustand merken. Es brauchen
		;; lediglich die Werte gemerkt werden, die andere Objekte
		;; beeinflussen
		(if (= zp 0) (progn
			; (AlertBox cb_Blech)
			(setq hpAlt (Blech.get cb_Blech hp))
		))
		;; Wenn zp == 1, dann auf genderte Werte berprfen
		;; Die nderungen knnen auch in einer Funktion erfolgen.
		;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
		;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
		;; eingeladen wird.
		(if (= zp 1) (progn
			; (AlertBox cb_Blech)
			(setq hpNeu (Blech.get cb_Blech hp))
			(if (/= hpAlt  hpNeu) (progn
				(setKonstanten)						  ; Konstanten festlegen

				(move_Steifen Flansch_Flaechen 			Bl_AusStf_OberFl  			Bl_AusStf_UnterFl 		fussPl)
				(move_Steifen Flansch_KantenLinks		FlK_Blech_UntenLinks		FlK_Blech_ObenLinks 	fussPl)
				(move_Steifen Flansch_KantenRechts	FlK_Blech_UntenRechts	FlK_Blech_ObenRechts fussPl)
				(move_Steifen Flansch_Aussenblech		flfl_Blech_links					flfl_Blech_rechts 			fussPl)
			))
		))
	))
)


; ----------------------------------------------------------------------------------------
; ERZEUGT DIE FUSSPLATTE
; ----------------------------------------------------------------------------------------
(defun createFussplatte (fussPl)
	
	(setq h_stz (Traeger.get Tr_ID h)
				b_stz	(Traeger.get Tr_ID b)
	)
	
	; berstand der Fussplatte an jeder Seite
	(setq ueb 50)
	
	(if (= (Connect.get CastaData LinkesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID rechts))
	)
	
	; Hhe, Breite, Dicke der Fussplatte
	; diese Werte werden dann aber neu gesetzt, wenn dias Lochbild anschlieend eingebaut wird
	(setq hp_fpl   h_stz)
	(setq bp_fpl   b_stz)
	(setq dp_fpl 30)
	(setq dok_fpl  0)
	
	; Platte quadratisch gestalten
	(if (< bp_fpl 	hp_fpl) (setq  bp_fpl  hp_fpl))
	
	(Blech.set fussPl (hp 	hp_fpl)
										(bp 	bp_fpl)
										(dp 	dp_fpl)										
	)
	;(Blech.set fussPl (hp 400) (bp 400) (dp 20))
	(print _fussplattelinks_)
	
	(if (= (Connect.get CastaData LinkesEnde) 1)
		(Traeger.addabtl Tr_ID fussPl 0.0 0.0 _fussplattelinks_)
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(Traeger.addabtl Tr_ID fussPl 0.0 0.0 _fussplatterechts_)
	)
	
	(TrEnde.ptrim TrgEnde dp_fpl)
				
)

(defun setAnkerlochbild  (AnkerLchb BlechID)
	(print "setze Daten fr  das Ankerlochbild")
	
	(print AnkerLchb)

	(Lochbild.set AnkerLchb
		(S_Bez   "M36")
		(Guete   "4.6")
		(e       "200 0 0 0 0 0")
		(w       "200  0")
		(Laenge  350)
	)
	
	(setq h_at 	(Traeger.get Tr_ID h)
				b_at	(Traeger.get Tr_ID b)
				s_at	(Traeger.get Tr_ID s)
				r_at	(Traeger.get Tr_ID r)
	)
	
	(setq dschr (Lochbild.get AnkerLchb sdurchm))
	(setq e_min (* 2.0 dschr))
	(setq e_min (runde e_min auf 5))
	
	(setq w0 0)
	(setq w1 (+ b_at (* 2.0 e_min)))
	
	(setq e0 0)
	(setq e1 (+ h_at (* 2.0 e_min)))
	(if (= Stf_Variante 0) (progn				; Variante 0 - 9 Schrauben
		(setq e0 (/ e1 3))
	))
	(if (= Stf_Variante 1) (progn				; Variante 1 - 16 Schrauben
		(setq e0 (/ e1 3))
		(setq w0 (/ w1 3))
	))
	
	
	(Lochbild.set AnkerLchb	(Lb_Art   32)
    											(anz_s 		4)
    											(Montage 	_AnkerSchraube_)
												(e0			e0)			(e1				e1)
    											(w0			w0)			(w1				w1)
  )


	(if (= (Connect.get CastaData linkesEnde) 1)
		(Traeger.addabtl Tr_ID AnkerLchb 0.0 0.0 _kpllochbildlinks_)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(Traeger.addabtl Tr_ID AnkerLchb 0.0 0.0 _kpllochbildrechts_)
	)

  (setq Abtl_AnkLchb (traeger.get Tr_ID ABTeil AnkerLchb))
  (Anbauteil.set Abtl_AnkLchb (Master 1))

	; Blechkorrektur
	(Blech.set BlechID (hp (+ h_at (* 4.0 e_min))))
	(Blech.set BlechID (bp (+ b_at (* 4.0 e_min))))
	
	(setq x_h_Stf  (*  0.8 h_AT))												; default-Wert Abschrgung
	(setq x_b_Stf  (- (* 2.0 e_min)  40.0))										; default-Wert Abschrgung
    
)


; ----------------------------------------------------------------------------------------
; ERZEUGT DIE AUSSTEIFUNGEN
; ----------------------------------------------------------------------------------------
(defun createAussteifung (Flag ausO ausU fpl)


	(if (= (Connect.get CastaData LinkesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID rechts))
	)
	
	(setq xPos_at (Connect.get CastaData xPos_at))
	
	(setq dp_fpl (Blech.get fpl dp))
	
	(setq	s_at (Traeger.get Tr_ID s)
				b_at (Traeger.get Tr_ID b)
	)
	
	(setq s_at_rund (runde s_at auf 5))
	
	; Default-Werte des Blechs
	(setq dp s_at_rund)
    (setq hp 300)
    (setq bp 120)
	
	(setq b_AT (Traeger.get Tr_ID b))
	(setq bp_Fusspl (Blech.get fpl bp)) 
	(setq ueb_Seite (* 0.5 (- bp_Fusspl b_AT)))

	(setq h_AT (Traeger.get Tr_ID h))
	(setq hp_Fusspl (Blech.get fpl hp)) 
	(setq ueb_ObUnt (* 0.5 (- bp_Fusspl b_AT)))	
	
	(setq bp  ueb_ObUnt)
	(setq hp h_AT)
  
  	(if (= Flag Flansch_Flaechen) 		(setq bp  (- ueb_ObUnt 10.0)))
	(if (= Flag Flansch_KantenRechts) (setq bp  (- ueb_Seite 20.0)))			; hier muss noch die Dicke des groen Blechs abgezogen werden
	(if (= Flag Flansch_KantenLinks) 	(setq bp  (- ueb_Seite 20.0)))			; hier auch

 
  (if (= (Connect.get CastaData LinkesEnde) 1)
		(progn
			(setq x1 0)
			(setq y1 0)
			(setq x4  x_h_Stf)
			(setq y4  x_b_Stf)
		)
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(progn
			(setq x1 x_h_Stf)
			(setq y1 x_b_Stf)
			(setq x4 0)
			(setq y4 0)
		)
	)

  (Blech.set ausO 	(dp dp)	 (hp hp) (bp bp))
  (Blech.set ausU 	(dp dp)	 (hp hp) (bp bp))
	
	(setq Fall_Abschrg 1)
	(if (= Flag  Flansch_KantenRechts) (setq Fall_Abschrg 2))

	
	(if (= Fall_Abschrg 1) (progn
			(Blech.set ausO 			
					(x1 x1)	(y1 y1)
      				(x4 x4)	(y4 y4)
			)
		  (Blech.set ausU 
					(x1 x1)	(y1 y1)
					(x4 x4)	(y4 y4)
		  )
	))
	(if (= Fall_Abschrg 2) (progn
			(Blech.set ausO 			
					(x2 x1)	(y2 y1)
      				(x3 x4)	(y3 y4)
			)
		  (Blech.set ausU 
					(x2 x1)	(y1 y1)
					(x3 x4)	(y3 y4)
		  )
	))


  ;; gendert 2008-09-23 - AF  
  ;; hinzugefgt - vertikaler Versatz am Fundament - wurde vorher
  ;; bei der Lage der Steifen nicht bercksichtigt.
  (setq dOK (koecher.get Aufl_ID delta_V))
  (setq dOK (- dOK))
  
  ;xPos_at
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(setq xPos_at_o (- xPos_at (* 0.5 hp) dp_fpl dOK))
			(setq xPos_at_u (- xPos_at (* 0.5 hp) dp_fpl dOK))
		)
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(setq xPos_at_o (+ xPos_at (* 0.5 hp) dp_fpl dOK))
			(setq xPos_at_u (+ xPos_at (* 0.5 hp) dp_fpl dOK))
		)
	)


	 ; je nach Flag werden unterschiedliche Verschiebungen erforderlich
	(if (= Flag Flansch_Flaechen) (progn
		(traeger.addabtl Tr_ID ausO xPos_at_o 0.0 _knotenblech_of_)  ;
		(traeger.addabtl Tr_ID ausU xPos_at_u 0.0 _knotenblech_uf_)  ;
	))
	
	(if (= Flag Flansch_KantenLinks) (progn
		; Dicke aus den Blechen FlFl_Blech_links oder FlFl_Blech_rechts
		(setq dp_grossesBlech (Blech.get FlFl_Blech_links dp))
	
		(traeger.addabtl Tr_ID ausU xPos_at_u 0.0 _lasche_uf_)  ;
		(Blech.set  ausU (xAsym (-  (+ dp_grossesBlech (* 0.5 (+ b_AT bp))))))
		(Blech.set  ausU (delta_y    (- dp)))
 
		(traeger.addabtl Tr_ID ausO xPos_at_o 0.0 _lasche_of_)  ;
		(Blech.set  ausO (xAsym (- (+ dp_grossesBlech (* 0.5 (+ b_AT bp))))))
		(Blech.set  ausO (delta_y  (- dp)))
	))
	(if (= Flag Flansch_KantenRechts) (progn
		(setq dp_grossesBlech (Blech.get FlFl_Blech_links dp))
		(traeger.addabtl Tr_ID ausU xPos_at_u 0.0 _lasche_uf_)  ;
		(Blech.set  ausU (xAsym  (+ dp_grossesBlech (* 0.5 (+ b_AT bp)))))
		(Blech.set  ausU (delta_y    (- dp)))
 
		(traeger.addabtl Tr_ID ausO xPos_at_o 0.0 _lasche_of_)  ;
		(Blech.set  ausO (xAsym  (+ dp_grossesBlech (* 0.5 (+ b_AT bp)))))
		(Blech.set  ausO (delta_y  (- dp)))
	))
	
)
; ---------------------------------------------------------------------------------------------------------
(defun move_Steifen  (Flag ausO ausU fpl)

	(setq Execute_Move 0)
	(if   (objExist  ausO) (setq  Execute_Move (+ Execute_Move 1)))
	(if   (objExist  ausU) (setq  Execute_Move (+ Execute_Move 1)))

	(if (= Execute_Move 2) (progn
	
		(if (= (Connect.get CastaData LinkesEnde) 1)
			(setq TrgEnde (Traeger.get Tr_ID links))
		)
		(if (= (Connect.get CastaData RechtesEnde) 1)
			(setq TrgEnde (Traeger.get Tr_ID rechts))
		)
		
		(setq xPos_at (Connect.get CastaData xPos_at))
		
		(setq dp_fpl 	(Blech.get fpl dp)
				 hp		0
				 bp		0
		)

		(if (= Flag Flansch_Aussenblech) (progn
			(Blech.set  ausO (dOK 0))
			(Blech.set  ausU (dOK 0))
		))
		(setq dOK (Blech.get ausO dOK))
		
		
		(setq  
				 hp		(Blech.get ausO hp)
				 bp		(Blech.get ausO bp)
		)
			
		(setq	s_at (Traeger.get Tr_ID s)
					b_at (Traeger.get Tr_ID b)
		)
		
		(setq s_at_rund (runde s_at auf 5))

	  ;xPos_at
		(if (= (Connect.get CastaData rechtesEnde) 1)
			(progn
				(setq xPos_at_o (- xPos_at (* 0.5 hp) dp_fpl dOK))
				(setq xPos_at_u (- xPos_at (* 0.5 hp) dp_fpl dOK))
			)
		)
		(if (= (Connect.get CastaData linkesEnde) 1)
			(progn
				(setq xPos_at_o (+ xPos_at (* 0.5 hp) dp_fpl dOK))
				(setq xPos_at_u (+ xPos_at (* 0.5 hp) dp_fpl dOK))
			)
		)
		
		(setq abtl_bl (Traeger.get Tr_ID ABTeil ausO))
		(Anbauteil.set abtl_bl (xPos xPos_at_o))

		(setq abtl_bl (Traeger.get Tr_ID ABTeil ausU))
		(Anbauteil.set abtl_bl (xPos xPos_at_o))
		
		;	(if (= Flag Flansch_Aussenblech) (progn
		;		(setq Dummy 1)
		;	))
	))
)
; ---------------------------------------------------------------------------------------------------------
(defun createFlanschkantenBl   (Blech_links Blech_rechts fussPl)

	(print "... in createFlanschkantenBl")

	(setq	h_AT 	(Traeger.get Tr_ID h)
			b_AT 	(Traeger.get Tr_ID b)
			s_AT 	(Traeger.get Tr_ID s)
			qt_AT	(Traeger.get Tr_ID qsForm)
	)
	
	(setq hp_fpl (Blech.get  fussPl hp))
	(setq bp_fpl (Blech.get  fussPl bp))
	
	(setq b_Blech  (- hp_fpl  20.0))				; default - Breite des Blechs - wenn Fuplatte nicht quadratisch, prfen
	(setq h_Blech h_AT)								; default - Hhe des Blechs - vertikal an der Sttze
	
	(setq dp_FPl (Blech.get fussPl dp))
	(Blech.set  Blech_links		 (bp b_Blech) (hp  h_Blech))
	(Blech.set  Blech_rechts	 (bp b_Blech) (hp  h_Blech))
	
	(Blech.set  Blech_links 	(dOK 		(+ (* 0.5 h_Blech) dp_Fpl)))
	(Blech.set  Blech_rechts 	(dOK	(+ (* 0.5 h_Blech)	dp_Fpl)))

	(Blech.set  Blech_rechts	(delta_y (* 0.5 (- b_AT s_AT))))
	(Blech.set  Blech_links		(delta_y (* 0.5 (- b_AT s_AT))))

	(if (= qt_AT "K") (progn
		(Blech.set  Blech_rechts	(delta_y 0.0))
		(Blech.set  Blech_links		(delta_y 0.0))
	))

	(Blech.set Blech_links		(x3  x_h_stf) 		(y3  x_b_stf))
	(Blech.set Blech_links		(x4  x_h_stf) 		(y4  x_b_stf))
	(Blech.set Blech_rechts 	(x3  x_h_stf) 		(y3  x_b_stf))
	(Blech.set Blech_rechts 	(x4  x_h_stf) 		(y4  x_b_stf))
	
	
  (setq xPos_at (Connect.get CastaData xPos_at))

  (traeger.addabtl Tr_ID Blech_links xPos_at	 0.0	_lasche_steg_li_)  ;
  (traeger.addabtl Tr_ID Blech_rechts xPos_at	 0.0  _lasche_steg_re_)  ;

	
)
(defun checkVariante ()
	(setq b_AT (Traeger.get Tr_ID b))
	(if (> b_AT 200) (setq Stf_Variante  1))
)
(defun Adapt_Abschrg_an_Hoehe (Bl_ID)
	(if (objExist Bl_ID) (progn
		(setq 	hp  (Blech.get Bl_ID hp)
					x1  (Blech.get Bl_ID x1)
					x2  (Blech.get Bl_ID x2)
					x3  (Blech.get Bl_ID x3)
					x4  (Blech.get Bl_ID x4)
		)
		(if (> x1 hp)  (Blech.set Bl_ID (x1 hp)))
		(if (> x2 hp)  (Blech.set Bl_ID (x2 hp)))
		(if (> x3 hp)  (Blech.set Bl_ID (x3 hp)))
		(if (> x4 hp)  (Blech.set Bl_ID (x4 hp)))
	))
)