; $	HT	QT(Z)			AF(FS)		P(EZ)
; $ 	AT	QT(S)			AF(K)			P(E)
; $	AE	V(-)			H(-)			R(-)

(defun load-modules ()
  ; Profil prfen
  (setq qsform_at (Traeger.get Tr_ID qsform))
  (print qsform_at)
  
)

(defun init-connection ()

  (print "*clear*")
  (print "********************************************************************")
  (print "in init-connection - stz_Windverb_TG-Technik");
   
  (connect.ShowAttributes CastaData)
 
  (setq RWinkelSteg (Connect.get CastaData r-atrgewnkl_steg))
  (setq erzeugeAnschluss 1)	; Einstellen, dass Anschluss erzeugt wird.
  (if (> RWinkelSteg 92.5) (setq erzeugeAnschluss 0))
  (if (< RWinkelSteg 87.5) (setq erzeugeAnschluss 0))
  
  (if (= erzeugeAnschluss 0) (progn
     (alertBox 
"Dieses Makro ist nur dann verlsslich einzusetzen,\nwenn zuvor 'relative Lage' angewandt wurde.\n
Der Windverbandsstab muss in einer Ebene mit dem Anschlussprofil liegen!\n\n
Bitte berprfen Sie das Ergebnis, da das Makro trotzdem einen Anschluss erzeugt!"  "Check_RelativPosition")
  ))
 
  (if (= erzeugeAnschluss 1) (progn
	 ; der Anschlusstrger wird genauso lang getrimmt, dass er
	 ; auf mit dem Ende in der Mittelachse des Htr liegt.
	 (trimmeAtr) ; knnte mal zentral in ein Modul aufgenommen werden
	 
	 ; als nchstes den ATr wieder so verlngern, dass die Schraube aufgeschraubt werden kann
	  
	 ; das Windverbandselement einbauen
	 ; dazu muss die X-Position berechnet werden - noch ist zu berlegen, ob man einfach die
	 ; x-Position des Anschlusses verwendet und dann eine lokale Verschiebung lngs der
	 ; HTr-Achse einsetzt. Der zu berechnende Wert ist aber derselbe.
	 (insert_SpannelementAnker)
 

	;  (setq TGBauteil (Zukaufteil.create))
	;  (Zukaufteil.set TGBauteil (SDurchm "M24"))
	;  (Zukaufteil.set TGBauteil (SDurchm 20))
	;  (Zukaufteil.set TGBauteil (SDurchm 16.0))
   ))
	
	
)
(defun trimmeAtr ()
  (setq lng_Trim 0.0)

  (if (= (Connect.get CastaData vAtr-vHtr) 0) (progn
;     (print "Behandlung ATR-Trgerende wenn Vertikalverschiebung ATr 90 zur V HTr")
     (setq WnklAlfa (Connect.get CastaData V-AtrGewnkl_Steg))
     (setq	sinAWnkl (sin (/ (* PI WnklAlfa) 180.0))
  		cosAWnkl (cos (/ (* PI WnklAlfa) 180.0))
  		tanAWnkl (tan (/ (* PI WnklAlfa) 180.0))
     )
     (setq dlr_HTr (Traeger.get HTrg  delta_LR)
     	   dv_ATr  (Traeger.get Tr_ID delta_V)
     )
     (setq tmpTrim 0.0)
     (if (/= sinAWnkl 0.0) (setq tmpTrim	 (/ dlr_HTr sinAWnkl)))
     (if (= (Connect.get CastaData amhtsteglinks)  1)  (setq lng_Trim (- lng_Trim tmpTrim)))
     (if (= (Connect.get CastaData amhtstegrechts) 1)  (setq lng_Trim (+ lng_Trim tmpTrim)))

     (setq tmpTrim 0.0)
     (if (/= tanAWnkl 0.0) (setq tmpTrim	 (/ dv_ATr  tanAWnkl)))

     (if (= (Connect.get CastaData LinkesEnde)  1) (setq lng_Trim (- lng_Trim tmpTrim)))
     (if (= (Connect.get CastaData RechtesEnde) 1) (setq lng_Trim (+ lng_Trim tmpTrim)))

  ))
  (if (= (Connect.get CastaData vAtr-lHtr) 0) (progn
;    (print "Behandlung ATR-Trgerende wenn Vertikalverschiebung ATr lngs zur Lngsachse HTr")
     (setq WnklAlfa (Connect.get CastaData H-AtrGewnkl_Steg))
     (setq	sinAWnkl (sin (/ (* PI WnklAlfa) 180.0))
  		cosAWnkl (cos (/ (* PI WnklAlfa) 180.0))
  		tanAWnkl (tan (/ (* PI WnklAlfa) 180.0))
     )
     (setq dlr_HTr (Traeger.get HTrg  delta_LR)
     	   dlr_ATr (Traeger.get Tr_ID delta_LR)
     )


     (setq tmpTrim 0.0)
     (if (/= sinAWnkl 0.0) (setq tmpTrim	 (/ dlr_HTr sinAWnkl)))
     (if (= (Connect.get CastaData amhtsteglinks)  1)  (setq lng_Trim (- lng_Trim tmpTrim)))
     (if (= (Connect.get CastaData amhtstegrechts) 1)  (setq lng_Trim (+ lng_Trim tmpTrim)))

     (setq tmpTrim 0.0)
     (if (/= tanAWnkl 0.0) (setq tmpTrim	 (/ dlr_ATr  tanAWnkl)))
    
     (if (= (Connect.get CastaData LinkesEnde)  1) (setq lng_Trim (- lng_Trim tmpTrim)))
     (if (= (Connect.get CastaData RechtesEnde) 1) (setq lng_Trim (+ lng_Trim tmpTrim)))
    
   ))

  (if (= (Connect.get CastaData linkesEnde) 1) (progn
      (setq TrgEnde (Traeger.get Tr_ID links))
      (TrEnde.set TrgEnde (Delta_L lng_Trim))
  ))
  (if (= (Connect.get CastaData rechtesEnde) 1) (progn
      (setq TrgEnde (Traeger.get Tr_ID rechts))
      (TrEnde.set TrgEnde (Delta_L lng_Trim))
  ))
  
)
(defun insert_SpannelementAnker ()
  (setq WnklAlfa 0.0)
  (setq delta_L  0.0)
  (setq HTr_deltaLR (Traeger.get HTrg delta_LR))
  (setq HTr_deltaV  (Traeger.get HTrg delta_V))
  
  (setq abtl_DeltaV 0.0)
  (setq xPos (Connect.get CastaData xpos_Ht))

  (setq qsForm_HT (Traeger.get HTrg qsForm))
  (setq h_AT (Traeger.get Tr_ID h))
  (setq s_HT (Traeger.get HTrg  s))
  (setq s_HT_Anteil (* 0.5 s_HT))
  (if (= qsForm_HT "U") (progn
		(if (= (Connect.get CastaData amhtstegLinks) 1)	(setq s_HT_Anteil s_HT))
		(if (= (Connect.get CastaData amhtstegRechts) 1)	(setq s_HT_Anteil 0.0))
  ))
(print    s_HT_Anteil)
  
  (setq StabUeberstand 200)
  (if (=  h_AT   12) (setq StabUeberstand (+ s_HT_Anteil  29  7   11   20)))
  (if (=  h_AT   14) (setq StabUeberstand (+ s_HT_Anteil  29  7   11   20)))
  (if (=  h_AT   16) (setq StabUeberstand (+ s_HT_Anteil  29  7   15   20)))
  (if (=  h_AT   18) (setq StabUeberstand (+ s_HT_Anteil  29  7   15   20)))
  (if (=  h_AT   20) (setq StabUeberstand (+ s_HT_Anteil  33  7   18   20)))

  (if (= (Connect.get CastaData linkesEnde) 1) (progn
       (setq TrgEnde (Traeger.get Tr_ID links)
             deltaL  (TrEnde.get  TrgEnde delta_L)
       )
       (TrEnde.set  TrgEnde (delta_L (- deltaL StabUeberstand)))
  ))
  (if (= (Connect.get CastaData rechtesEnde) 1) (progn
       (setq TrgEnde (Traeger.get Tr_ID rechts)
             deltaL  (TrEnde.get  TrgEnde delta_L)
       )
       (TrEnde.set  TrgEnde (delta_L (- deltaL StabUeberstand)))
  ))
  
  (setq xPos_Abtl xPos)		; zur Sicherheit initialisieren
  (setq xp_Berechnet 0)		; Testflag, ob abgehandelt

  (if (= (Connect.get CastaData vAtr-vHtr) 0) (progn
     ; (print "Behandlung ATR-Trgerende wenn Vertikalverschiebung ATr 90 zur V HTr")
     (setq xp_Berechnet 1)
     (setq	WnklAlfa (Connect.get CastaData V-AtrGewnkl_Steg)
     		sinAWnkl (sin (/ (* PI WnklAlfa) 180.0))
     		cosAWnkl (cos (/ (* PI WnklAlfa) 180.0))
     		tanAWnkl (tan (/ (* PI WnklAlfa) 180.0))
     )
     
     (setq 	dv        (Traeger.get Tr_ID delta_V)
           	ATr_Lngs  (/ dv sinAWnkl)
     )
     
     (setq xPos_Abtl xPos)
     (if (= (Connect.get CastaData vAtr-lHtr)  1)   (setq xPos_Abtl (+ xPos_Abtl ATr_Lngs)))
     (if (= (Connect.get CastaData vAtr-lHtr) -1)   (setq xPos_Abtl (- xPos_Abtl ATr_Lngs)))

     
     (setq HTrg_Dlr   (Traeger.get HTrg delta_LR)
           HTrg_Lngs  (/ HTrg_Dlr tanAWnkl)
     )
     (if (= (Connect.get CastaData amhtStegRechts) 1) (setq HTrg_Lngs (- HTrg_Lngs)))
     (if (= (Connect.get CastaData linkesEnde)  1) (progn
         (if (= (Connect.get CastaData vAtr-lHtr)  1)   (setq xPos_Abtl (+ xPos_Abtl HTrg_Lngs)))
         (if (= (Connect.get CastaData vAtr-lHtr) -1)   (setq xPos_Abtl (- xPos_Abtl HTrg_Lngs)))
     ))
     (if (= (Connect.get CastaData rechtesEnde)  1) (progn
         (if (= (Connect.get CastaData vAtr-lHtr)  1)   (setq xPos_Abtl (- xPos_Abtl HTrg_Lngs)))
         (if (= (Connect.get CastaData vAtr-lHtr) -1)   (setq xPos_Abtl (+ xPos_Abtl HTrg_Lngs)))
     ))

     ; seitliche Verschiebung des Spannelements berechnen
     ; Eingehen tut seitliche Verschiebung des AT und vertikale Verschiebung des HT
     (setq abtl_DeltaV 0.0)
     (setq Anteil_ATr    (Traeger.get Tr_ID delta_LR))
     (if (= (Connect.get CastaData sAtr-vHtr)  1)   (setq abtl_DeltaV (- Anteil_ATr  HTr_deltaV )))
     (if (= (Connect.get CastaData sAtr-vHtr) -1)   (setq abtl_DeltaV (- (+ Anteil_ATr HTr_deltaV))))


  ))
  (if (= (Connect.get CastaData vAtr-lHtr) 0) (progn
     (setq xp_Berechnet 1)
     ; (print "Behandlung ATR-Trgerende wenn Vertikalverschiebung ATr lngs zur Lngsachse HTr")
     ; Winkel und Winkelwerte
     (setq	WnklAlfa (Connect.get CastaData H-AtrGewnkl_Steg)
     		sinAWnkl (sin (/ (* PI WnklAlfa) 180.0))
     		cosAWnkl (cos (/ (* PI WnklAlfa) 180.0))
     		tanAWnkl (tan (/ (* PI WnklAlfa) 180.0))
     )
     
     ; Lngsverschiebung des Spannelements berechnen
     ; - zuerst aufgrund der seitlichen Verschiebung des AT
     (setq	dlr       (Traeger.get Tr_ID delta_LR)
           	ATr_Lngs  (/ dlr sinAWnkl)
     )
     (setq xPos_Abtl xPos)
     (if (= (Connect.get CastaData sAtr-lHtr)  1)   (setq xPos_Abtl (+ xPos_Abtl ATr_Lngs)))
     (if (= (Connect.get CastaData sAtr-lHtr) -1)   (setq xPos_Abtl (- xPos_Abtl ATr_Lngs)))

     ; dann aufgrund der seitlichen Verschiebung des HT
     (setq HTrg_Dlr   (Traeger.get HTrg delta_LR)
           HTrg_Lngs  (/ HTrg_Dlr tanAWnkl)
     )
     (if (= (Connect.get CastaData amhtStegRechts) 1) (setq HTrg_Lngs (- HTrg_Lngs)))

     (if (= (Connect.get CastaData linkesEnde)  1) (progn
         (if (= (Connect.get CastaData sAtr-lHtr)  1)   (setq xPos_Abtl (+ xPos_Abtl HTrg_Lngs)))
         (if (= (Connect.get CastaData sAtr-lHtr) -1)   (setq xPos_Abtl (- xPos_Abtl HTrg_Lngs)))
     ))
     (if (= (Connect.get CastaData rechtesEnde)  1) (progn
         (if (= (Connect.get CastaData sAtr-lHtr)  1)   (setq xPos_Abtl (- xPos_Abtl HTrg_Lngs)))
         (if (= (Connect.get CastaData sAtr-lHtr) -1)   (setq xPos_Abtl (+ xPos_Abtl HTrg_Lngs)))
     ))

     ; seitliche Verschiebung des Spannelements berechnen
     ; Eingehen tut vertikale Verschiebung des AT und vertikale Verschiebung des HT
     (setq Anteil_ATr     (Traeger.get Tr_ID delta_V))
     (if (= (Connect.get CastaData vAtr-vHtr)  1)   (setq abtl_DeltaV (- Anteil_ATr  HTr_deltaV )))
     (if (= (Connect.get CastaData vAtr-vHtr) -1)   (setq abtl_DeltaV (- (+ Anteil_ATr HTr_deltaV))))


  ))
  
  (if (= (Connect.get CastaData amhtSteglinks)  1) (setq StegSeite _steg_rechts_))
  (if (= (Connect.get CastaData amhtStegRechts) 1) (setq StegSeite _steg_links_))

  (setq xp_Berechnet 0)

  (if (= xp_Berechnet 0) (progn
      (print "Berechnung noch durchfhren --------------------------------")
      (setq h_HTrg (Traeger.get HTrg h))
      (setq abtl_DeltaV (- (* 0.5 h_HTrg)))
      (setq abtl_DeltaV (* 0.5 h_HTrg))

      (setq hWinkel (Connect.get CastaData trg_hwinkel))
      (setq hWinkel (- 180.0 hWinkel))				; im Beispiel muss 36.45 herauskommen
      (setq cosWnkl  (cos (/ (* PI hWinkel) 180.0)))
      (print hWinkel)	(print cosWnkl)

      (setq hWinkel (Connect.get CastaData r-atrgewnkl_kopf))
      (setq hWinkel (- hWinkel 90.0))				; im Beispiel muss 36.45 herauskommen
      (setq cosWnkl  (cos (/ (* PI hWinkel) 180.0)))
      (print hWinkel)	(print cosWnkl)

      (setq DivOK 1)
      (if (> cosWnkl -0.001) (if (< cosWnkl 0.001) (setq DivOK 0)))

      (if (= DivOK 1) (setq abtl_DeltaV (/ (* 0.5 h_HTrg) cosWnkl)))
      
      (if (= DivOK 0) (progn
         ; (print "Rotationswinkel des Anschlussstabs erlaubt das Anschlieen nicht!\nBitte das Ergebnis berprfen")
         (setq abtl_DeltaV 0)
      ))
      
      (print abtl_DeltaV)
      (setq abtl_DeltaV 0.0)
      (setq htr_DeltaV (Traeger.get HTrg  delta_V))
      (setq Tr_DeltaLR (Traeger.get Tr_ID delta_LR))
      (if (= (Connect.get CastaData satr-vhtr) -1) (progn
          (setq abtl_DeltaV (- abtl_DeltaV Tr_DeltaLR))
      ))
      (if (= (Connect.get CastaData satr-vhtr) 1) (progn
          (setq abtl_DeltaV (+ abtl_DeltaV Tr_DeltaLR))
      ))

      (if (= (Connect.get CastaData vatr-shtr) 0) (progn
          (setq dvHTrg (Traeger.get HTrg  delta_V))
          (setq dvATrg (Traeger.get Tr_ID delta_V))

	(if (= (Connect.get CastaData vatr-vhtr) 1) (progn
          (setq dvDiff (- dvHTrg dvATrg))
        ))
	(if (= (Connect.get CastaData vatr-vhtr) -1) (progn
          (setq dvDiff (+ dvHTrg dvATrg))
        ))


          (setq abtl_DeltaV (- abtl_DeltaV dvDiff))
      ))

      
  ))

  
 
  ; Spannelement erzeugen und einstellen fr den Stabdurchmesser
  (setq TGBauteil (Zukaufteil.create))
  (setq sd (Traeger.get Tr_ID h))
  (Zukaufteil.set TGBauteil (SDurchm sd))
  (Traeger.addAbtl HTrg TGBauteil xPos_Abtl 0.0 StegSeite)	; hinzufgen an Hauptrger
  (Connect.storeAnschlObjs CastaData TGBauteil) 		; Anschluss-Element eintragen
  (setq Abtl_Zkt (Traeger.get HTrg ABTeil TGBauteil))		; Anschluss-Element ermitteln um die 
  (Anbauteil.set Abtl_Zkt (delta_V  abtl_DeltaV))		; seitliche Verschiebung einzutragen
  
  
  ; Wegen Bevel-Clamps ist der Winkel wichtig - die Nase liegt bei einem Winkel
  ; von 0.0 Grad nher am Trgeranfang
  (setq ZKT_Winkel 0.0)
  (setq StegWinkel (Connect.get  CastaData  h-atrgewnkl_steg))
  (if (= (Connect.get  CastaData  amhtsteglinks) 1) (progn
      (if (= (Connect.get  CastaData  vAtr-vHtr) 1) (progn
	     (if (> StegWinkel 90.0) (setq ZKT_Winkel 180.0))
	  ))
      (if (= (Connect.get  CastaData  vAtr-vHtr) -1) (progn
	     (if (< StegWinkel 90.0) (setq ZKT_Winkel 180.0))
	  ))
   ))
  (if (= (Connect.get  CastaData  amhtstegRechts) 1) (progn
      (if (= (Connect.get  CastaData  vAtr-vHtr)  1) (progn
	     (if (< StegWinkel 90.0) (setq ZKT_Winkel 180.0))
	  ))
      (if (= (Connect.get  CastaData  vAtr-vHtr) -1) (progn
	     (if (> StegWinkel 90.0) (setq ZKT_Winkel 180.0))
	  ))
   ))
   (print ZKT_Winkel)
   (Anbauteil.set Abtl_Zkt (Winkel    ZKT_Winkel))
 
)
