; $	HT	QT(IU)		AF(F)		P(EZ)
; $ AT	QT(IUKR)	AF(K)		P(E)
; $	AE	V(-)			H(90)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;	
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (load "mod-endinit-uz-stzflansch")
   (load "mod-help-uz_an_stzFlansch")
)

; INITIALISIERUNGSMETHODE (START)
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun init-connection ()

	(connect.showattributes CastaData)
	
	(setq LB_DEBUG 0)
	
  (init-traegerenden)				

  (calcUzStzFlanschAbst)
  
    	
  (setq blKpl 	(blech.create))
  (setq lchbKpl (lochbild.create))
	(Connect.storeAnschlObjs CastaData blKpl lchbKpl)
	
	(if (= 1 2)	(progn
  (if (= (connect.get CastaData RechtesEnde) 1) 
  	(progn
  		(print "Anschluss rechts am Anschlusstrger")
  		
  		; Kopfplatte
			;(calcAndSetBlechdaten blKpl TrRechts)
			;(createBlechAusf_1 blKpl)
			;(traeger.addabtl tr_id blKpl 0.0 0.0 _kopfplatterechts_)

			; Lochbild
			(calcFlanschLochbildDaten lchbKpl blKpl)
			(traeger.addabtl tr_id lchbKpl 0.0 0.0 _kpllochbildrechts_)

			(createFlanschLochb lchbKpl blKpl)	
  	)
  )
  (if (= (connect.get CastaData LinkesEnde) 1) 
  	(progn
  		(print "Anschluss links am Anschlusstrger")
  		
			; Kopfplatte
			;(calcAndSetBlechdaten blKpl TrLinks)
			;(createBlechAusf_1 blKpl)
			;(traeger.addabtl tr_id blKpl 0.0 0.0 _kopfplattelinks_)

			; Lochbild
			(calcFlanschLochbildDaten lchbKpl blKpl)
			(traeger.addabtl tr_id lchbKpl 0.0 0.0 _kpllochbildlinks_)
			
			(createFlanschLochb lchbKpl blKpl)			
  	)
  )
  ))
	
	
	(createBlechAusf_1 blKpl)
	
	(calcLochbildDaten lchbKpl blKpl)
	(createLochbild lchbKpl)
	
	
  ;(korrigiereKpl blKpl lchbKpl)
  
  
	(if (= (Connect.get CastaData anz_weitere_anschl) 0) 
  	(if (= (Connect.get CastaData anschlZwHtEnden) 0)
				(eckeBegradigen)
		)
  )
  
  
  ; CALLBACK
  (Blech.set blKpl (formFkt "cb_KplBlech"))

)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am AT
; ----------------------------------------------------------------------------------------
(defun cb_KplBlech (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get blKpl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get blKpl dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get lchbKpl Klemml))
	       (setq altesDxS		(Lochbild.get lchbKpl dxsKopf))
	       
	       (Lochbild.set lchbKpl 	(Klemml (+ alteKlemml dpDiff))
	       												(DxSKopf (+ altesDxS dpDiff))
	       )
	       
	      
	    ))
	))
	
)

; ---------------------------------------------------------------------- */
; Hilfsfunktionen
; ---------------------------------------------------------------------- */

; ----------------------------------------------------------------------------------------
; ERZEUGT DIE STIRNPLATTE AUSFHRHUNG 1
; ----------------------------------------------------------------------------------------
(defun createBlechAusf_1 (BLECH_ID)
	(print "Erzeuge Strinplatte Ausfhrung 1")
	(print "------------------------------------------------------------")
	(setq blech_hp 70.0)
	(setq blech_bp 120.0)
	(setq blech_dp 10.0)
	
	; dok 
	; ----------------------------------------------
	(calcVersatz) ;-> BLECH_VERSATZ
	
	(setq dOK BLECH_VERSATZ)
	
	; Werte setzen
	; ----------------------------------------------
	(Blech.set BLECH_ID (dp blech_dp) 
											(hp blech_hp) 
											(bp blech_bp) 
											(dOK dOK)
	)
	(print "------------------------------------------------------------")
	
	(if (= (Connect.get CastaData rechtesEnde) 1)	
		(progn
			(Traeger.addabtl Tr_ID BLECH_ID 0.0 0.0 _kopfplatterechts_)
			(setq AT_Ende (Traeger.get Tr_ID rechts))
		)
	)
	(if (= (Connect.get CastaData linkesEnde) 1)	
		(progn
			(Traeger.addabtl Tr_ID BLECH_ID 0.0 0.0 _kopfplattelinks_)
			(setq AT_Ende (Traeger.get Tr_ID links))
		)
	)
	
	; TrEnde noch krzen
	; ----------------------------------------------
	(TrEnde.pTrim AT_Ende blech_dp)
	
)

; ----------------------------------------------------------------------------------------
; BERECHNET DEN VERSATZ ZWISCHEN OK-BLECH und OK-TRGER
; ----------------------------------------------------------------------------------------
(defun calcVersatz ()
	(print "Berechne Strinplattenversatz")
	(print "------------------------------------------------------------")
	(setq h_at (Traeger.get Tr_ID h))
	
	(setq BLECH_VERSATZ 0.0)
	
	(if (>= h_at 600.0)
		(setq BLECH_VERSATZ 10.0)
		(setq BLECH_VERSATZ 5.0)
	)
	
	(print "------------------------------------------------------------")
)


; ----------------------------------------------------------------------------------------
; ERZEUGT DAS LOCHBILD
; ----------------------------------------------------------------------------------------
(defun calcLochbildDaten (LCHB_ID BLECH_ID)
	(print "------------------------------------------------------------")
	(print "Berechne Lochbilddaten")
	
	(setq be0 35.0)
	(setq be1	30.0)
	
	(setq blech_dok (Blech.get BLECH_ID dok))
	
	(setq e0 (+ blech_dok be0))
	
	(setq w0 60.0)
	
	; Klemmlnge
	; ----------------------------------------------	
	(setq t_ht (Traeger.get Htrg t))
	(setq dp_blech (Blech.get BLECH_ID dp))
	(setq klemm (+ t_ht dp_blech))
	
	(Lochbild.set LCHB_ID (Guete   "4.6")
												(S_Bez "M16")
	)
	
	; Werte setzen
	; ----------------------------------------------
	(Lochbild.set LCHB_ID (e0 		e0)	
												(w0 		w0)
												(klemml klemm)	
	)
	(print "------------------------------------------------------------")
)


; ----------------------------------------------------------------------------------------
; ERZEUGT DAS LOCHBILD
; ----------------------------------------------------------------------------------------
(defun	createLochbild (LCHB_ID)
	(print "------------------------------------------------------------")
	(print "ERZEUGE FLANSCHLOCHBILD")
	
	(if (= (Connect.get CastaData linkesEnde) 1)		(Traeger.addabtl Tr_ID LCHB_ID 0.0 0.0 _kpllochbildlinks_))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(Traeger.addabtl Tr_ID LCHB_ID 0.0 0.0 _kpllochbildrechts_))
	
	
	;(setq abteil_ht (Traeger.get Htrg abteil LCHB_ID))
  (setq abteil_at (Traeger.get Tr_ID abteil LCHB_ID))
	
	;(Anbauteil.set abteil_ht 	(Master 0))
	(Anbauteil.set abteil_at 	(Master 1))
	
	(print "------------------------------------------------------------")
)


; ----------------------------------------------------------------------------------------
; ERZEUGT DAS LOCHBILD
; ----------------------------------------------------------------------------------------
(defun	createFlanschLochb (flLochbild BLECH_ID)
	(print "------------------------------------------------------------")
	(print "ERZEUGE FLANSCHLOCHBILD")
  
	; allg. Daten
	; ----------------------------------------------
  (setq xPos 					(Connect.get CastaData xPos_HT)
  			afl_vwinkel 	(Connect.get CastaData afl_vwinkel)
  			htrg_vwinkel	(Connect.get CastaData hpttrg_vwinkel)
  )
  	
  (setq hProf					(Traeger.get Htrg h)
        delta_v_ht		(Traeger.get Htrg delta_v)      
  )
	
	(setq h_at				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
				r_winkel_at (Traeger.get Tr_ID r_winkel)
	)
	
	(setq dp_blech		(Blech.get BLECH_ID dp)
				dok_blech		(Blech.get BLECH_ID dok)
	)
	
	(setq tanAW (tan (/ (* PI afl_vwinkel) 180.0)))
	(setq sinAW (sin (/ (* PI afl_vwinkel) 180.0)))
	(print tanAW)
	(print sinAW)
	
	(if (= (connect.get CastaData amHtOberFlansch) 1) 	(setq Flansch _flanschlochbild_of_))
  (if (= (connect.get CastaData amHtUnterFlansch) 1) 	(setq Flansch _flanschlochbild_uf_))
  
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq TrgEnde (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq TrgEnde (Traeger.get Tr_ID rechts)))
  
  (setq delta_lr_lb_abtl 0.0)
	(setq delta_v_lb_abtl 0.0)
	
  ; Winkel des Lochbildes festlegen
	; (abhngig von HT-Orientierung)
	; ----------------------------------------------
	(if (= 1 1) (progn
	; ----------------------------------------------
		(setq wAbtl (+ 180.0 r_winkel_at))
		(if (= (Connect.get CastaData vatr-lhtr) 1)	(setq wAbtl (+ 0.0 r_winkel_at)))
	; ----------------------------------------------
	))
	; ----------------------------------------------
	(print xPos)
	
	
	; Positionierung und Ausrichtung zum AT
	; Verschiebung auf die Hhe der AT-Oberkante
	; ----------------------------------------------
	(if (= 1 1) (progn
	; ----------------------------------------------
		(setq scherl_at (TrEnde.get TrgEnde vscherl))
		(setq delta_xPos (* 0.5 scherl_at))
		
		(if (= (Connect.get CastaData vatr-lhtr) 1)
			(setq xPos (- xPos delta_xPos))
			(setq xPos (+ xPos delta_xPos))
		)
	; ----------------------------------------------
	))
	; ----------------------------------------------
  (print xPos)
  
  
	
	; die restlichen Korrekturen aus Trgerverschiebungen zusammenfassen
	(setq xPos_korr_ges 0) ; default
	; ----------------------------------------------
	(if (= 1 1) (progn
	; ----------------------------------------------
	  ; Bercksichtigung der AT-Neigung ( -> Verschiebung der xPos)
	  (print "Bercksichtigung der AT-Neigung ( -> Verschiebung der xPos)")
		(print afl_vwinkel)
		
		(setq einbauWinkel (- 180.0 afl_vwinkel))
		(print einbauWinkel)
		
		(setq tanEW (tan (/ (* PI einbauWinkel) 180.0)))
		(print tanEW)
		
		(setq h_ht_halb (* 0.5 hProf))
		(print h_ht_halb)
		(setq anteil_neigung (/ h_ht_halb tanEW))
		(print anteil_neigung)
		
		(setq xPos_korr_ges (- (* 1.0 xPos_korr_ges) anteil_neigung))
		(print xPos_korr_ges)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	
	; Bercksichtigung der AT_Rotation
	; ----------------------------------------------
	(if (= 1 2)	(progn
	; ----------------------------------------------
	(setq h_at (Traeger.get Tr_ID h))
	
	(setq hilfsWnkl (- 90 r_winkel_at))
	
	(print r_winkel_at)
	(print hilfsWnkl)
	
	
	(setq cosRW (cos (/ (* PI hilfsWnkl) 180.0)))
	(setq sinRW (sin (/ (* PI hilfsWnkl) 180.0)))
	
	(setq h_at_halb (* 0.5 h_at))
	
	(setq ankathete (* h_at_halb cosRW))
	(setq gegenkathete (* h_at_halb sinRW))
	(print ankathete)
	(print gegenkathete)
	
	
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(progn
			(setq delta_lr_lb_abtl (- delta_lr_lb_abtl ankathete))
			(setq delta_v_lb_abtl (- delta_lr_lb_abtl (- h_at_halb gegenkathete)))
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr) 0)
		(progn
			(setq delta_lr_lb_abtl (- delta_lr_lb_abtl ankathete))
			(setq delta_v_lb_abtl (- delta_lr_lb_abtl (- h_at_halb gegenkathete)))
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr) 1)
		(progn
			(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl ankathete))
			(setq delta_v_lb_abtl (- delta_lr_lb_abtl (+ h_at_halb gegenkathete )))
		)
	)
	
	(print delta_lr_lb_abtl)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	
	; VERSCHIEBUNGEN
	; --------------------------------------------------------------------------------------
	
	; Verschiebung delta_v AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
	(setq xPos_delta_v_at_korr (/ delta_v_at sinAW))
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq xPos_korr_ges (- xPos_korr_ges xPos_delta_v_at_korr)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq xPos_korr_ges (+ xPos_korr_ges xPos_delta_v_at_korr)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq xPos_korr_ges (+ xPos_korr_ges xPos_delta_v_at_korr)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq xPos_korr_ges (- xPos_korr_ges xPos_delta_v_at_korr)))
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq xPos_korr_ges (+ xPos_korr_ges xPos_delta_v_at_korr)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq xPos_korr_ges (- xPos_korr_ges xPos_delta_v_at_korr)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq xPos_korr_ges (- xPos_korr_ges xPos_delta_v_at_korr)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq xPos_korr_ges (+ xPos_korr_ges xPos_delta_v_at_korr)))
				)
			)
		)
	)
	; ----------------------------------------------
	))
	; ----------------------------------------------

  ; Verschiebung delta_v HT
	; ----------------------------------------------
	(if (= 1 1) 	(progn
	; ----------------------------------------------
  (setq xPos_korr (/ delta_v_ht tanAW))
	(print xPos_korr)
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(setq xPos_korr_ges (- xPos_korr_ges xPos_korr))
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(setq xPos_korr_ges (+ xPos_korr_ges xPos_korr))
	) 
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	(setq xPos (+ xPos xPos_korr_ges))
	(print xPos)
	(print wAbtl)
	
	(print delta_lr_at)
	
	
	
	; Verschiebung delta_lr AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
	(if (= (Connect.get CastaData rechtesEnde) 1)
  	(progn
			(if (= (Connect.get CastaData amHTUnterflansch) 1) 	(setq delta_lr_abt_ht (- delta_lr_at)))
			(if (= (Connect.get CastaData amHTOberflansch) 1) 	(setq delta_lr_abt_ht delta_lr_at))
		)
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
  	(progn
			(if (= (Connect.get CastaData amHTUnterflansch) 1) 	(setq delta_lr_abt_ht delta_lr_at))
			(if (= (Connect.get CastaData amHTOberflansch) 1) 	(setq delta_lr_abt_ht (- delta_lr_at)))
		)
	)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	; Verschiebung delta_lr HT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
	
	(if (= (Connect.get CastaData rechtesEnde) 1)
  	(progn
			(if (= (Connect.get CastaData amHTUnterflansch) 1) 	(setq delta_lr_abt_ht (+ delta_lr_abt_ht (* 0.5 delta_lr_ht))))
			(if (= (Connect.get CastaData amHTOberflansch) 1) 	(setq delta_lr_abt_ht (- delta_lr_abt_ht (* 0.5 delta_lr_ht))))
		)
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
  	(progn
			(if (= (Connect.get CastaData amHTUnterflansch) 1) 	(setq delta_lr_abt_ht (- delta_lr_abt_ht (* 0.5 delta_lr_ht))))
			(if (= (Connect.get CastaData amHTOberflansch) 1) 	(setq delta_lr_abt_ht (+ delta_lr_abt_ht (* 0.5 delta_lr_ht))))
		)
	)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	; hinzufgen
	; ----------------------------------------------
  (Traeger.addabtl Htrg flLochbild xPos wAbtl Flansch)
  (print delta_lr_at)
  
  (setq abteil 		(Traeger.get Htrg abteil flLochbild))
  (setq abteil_at (Traeger.get Tr_ID abteil flLochbild))
  
  
  ;(Anbauteil.set abteil (delta_lr delta_lr_abt_ht))
  
  ;(Lochbild.set flLochbild (delta_w 100))
  
  (if (= 1 1) (progn
  (if (= (Connect.get CastaData rechtesEnde) 1)
  	(progn
			(if (= (Connect.get CastaData amHTUnterflansch) 1)	(Anbauteil.set abteil (SeitRicht 1)))
			(if (= (Connect.get CastaData amHTOberflansch) 1)		(Anbauteil.set abteil (SeitRicht -1)))
		)
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
  	(progn
			(if (= (Connect.get CastaData amHTUnterflansch) 1)	(Anbauteil.set abteil (SeitRicht -1)))
			(if (= (Connect.get CastaData amHTOberflansch) 1)		(Anbauteil.set abteil (SeitRicht 1)))
		)
	)
))
	
	
	(Anbauteil.set abteil 		(Master 	1)
														(delta_lr delta_lr_lb_abtl)
														(delta_v 	delta_v_lb_abtl)
	)
	(Anbauteil.set abteil_at 	(Master 0))
	
	(if (= LB_DEBUG 1)
		(progn
			(Lochbild.set flLochbild (e2 200))
			
			(setq lbDummy (Lochbild.create))
			(Lochbild.copy lbdummy flLochbild)
			
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(traeger.addabtl tr_id lbdummy 0.0 0.0 _kpllochbildrechts_)
			)
			(if (= (Connect.get CastaData linkesEnde) 1)
				(traeger.addabtl tr_id lbdummy 0.0 0.0 _kpllochbildlinks_)
			)
			
			(setq abteil_dummy (Traeger.get Tr_ID abteil lbdummy))
			(Anbauteil.set abteil_dummy 		(Master 1))
		)
	)
	(print "------------------------------------------------------------")
	
	
)

; --------------------------------------------------------------------
; Begradigt die Rahmenecke wieder
; --------------------------------------------------------------------
(defun eckeBegradigen ()
	(print ">-------------------------------------------------------------------------------")
	(print "Begradige Sttzenecke")
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(setq HtEnde (Traeger.get Htrg links))
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(setq HtEnde (Traeger.get Htrg rechts))
	)
	
	(TrEnde.set HtEnde (v_winkel 90.0))
	
	; Verlngern und an AT anpassen
	(setq h_ht				(Traeger.get Htrg h))
	(setq afl_vwinkel (Connect.get CastaData afl_vwinkel))
	(setq delta_l			(TrEnde.get HtEnde delta_l))
	
	(setq h_ht_halb (* 0.5 h_ht))
	
	(setq tanAW (tan (/ (* PI afl_vwinkel) 180.0)))
	
	(setq delta_l_korr (/ h_ht_halb tanAW))
	(print delta_l)
	(print delta_l_korr)
	
	
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(setq delta_l (+ delta_l delta_l_korr))
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(setq delta_l (- delta_l delta_l_korr))
	)	
		
	(TrEnde.set HtEnde (delta_l delta_l))
	(print "<-------------------------------------------------------------------------------")
)