; $	HT	QT(IU)	AF(F)		P(EZ) 
; $	AT	QT(IU)		AF(K)		P(E)
; $ AE	V(-)			H(-)		R(0-1)

; MODULE
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (load "mod-lochbild")
)


; INITIALISIERUNGSMETHODE (START)
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun init-connection ()

	(print "*clear*")
	
	(Connect.showAttributes CastaData)
	
	(setq LB_DEBUG 0)
	
	; Abstand vom Sttzenende zum Trgerflansch
	(setq minAbstand 50)
	
	(setq StzEndeLinks (Traeger.get Tr_ID links))
	(setq StzEndeRechts (Traeger.get Tr_ID rechts))
	
	(setq HtrgLinks 	(Traeger.get Htrg links))
	(setq HtrgRechts	(Traeger.get Htrg rechts))
	
	; Lasche erzeugen
	(setq lasche (blech.create))
	(setq lchbAtrgSteg (Lochbild.create))
	(Connect.storeAnschlObjs CastaData lasche lchbAtrgSteg)
	
    
  (setq XPos_ht (Connect.get CastaData XPos_HT))
  (setq XPos_at (Connect.get CastaData XPos_AT))
  
  
	; Anbauteil Blech
	(setAnbauteilBlech lasche)
	
	; Blechdaten berechnen
	(calcAndSetBlechdaten lasche)
	
		
	; Anbauteil Lochbild dem HT hinzufgen
	(setq AbtlFahnenBl	(Traeger.get Htrg AbTeil lasche))
	(Traeger.addabtl Htrg lchbAtrgSteg XPos_ht 0.0 _fahnblLochbild_ AbtlFahnenBl)
	(calcFahnenLochbildDaten lchbAtrgSteg lasche)
	
	; Setzt die Endgltige Hhe und Breite der Fahne
	(korrBlechdaten lasche)
	
	; Anbauteil Lochbild hinzufgen
	(setAnbauteilLochbild lchbAtrgSteg lasche)
	
	; Traegerende des HT berechnen, wenn der Anschluss an HT-Ende stattfindet
	(if (= (Connect.get CastaData anschlzwhtenden) 0)
		(progn
			(if (= (Connect.get CastaData anHtLinkesEnde) 1)
				(berechneTraegerEnde HtrgLinks)
			)
			(if (= (Connect.get CastaData anHtRechtesEnde) 1)
				(berechneTraegerEnde HtrgRechts)
			)
		)
	)
	
	(if (= 1 2) (progn
		(Lochbild.set lchbAtrgSteg (e0 40))
	))
	
	
	(checkFahnenWinkel)
	(Trg_VertikalVerschiebungen) ; Apr 2013 - wurden nicht bercksichtigt
		
	;CALLBACK
	(Blech.set lasche (formFkt "cb_Lasche"))
)



; ----------------------------------------------------------------------------------------
; CALLBACK-FUNKTIONEN
; ----------------------------------------------------------------------------------------
(defun cb_Lasche (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get lasche dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
		(setq dpNeu (Blech.get lasche dp))
	  (setq qsform_at (Traeger.get Tr_ID qsform))
	    
	  (print dpAlt) (print dpNeu)
	    
	  (if (/= dpAlt dpNeu) (progn
	  	(setq dpDiff (- dpNeu dpAlt))
	    (setq alteKlemml (Lochbild.get lchbAtrgSteg Klemml))
	    (setq altesDxS		(Lochbild.get lchbAtrgSteg dxsKopf))
	       
	    (Lochbild.set lchbAtrgSteg 	(Klemml (+ alteKlemml dpDiff)))
	    
	       
	    (if (= qsform_at "I")
	    	(progn   
			    (Lochbild.set lchbAtrgSteg 	(DxSKopf (+ altesDxS dpDiff)))
			       
			    (setq delta_lr_lasche_alt	(Blech.get lasche delta_lr))
			       
			    (setq delta_lr_lasche_neu 0)
			  	
			  	(setq delta_lr_lasche_neu (- delta_lr_lasche_alt (* 0.5 dpDiff)))
			  	
			  	(print delta_lr_lasche_neu)
			    (Blech.set lasche (delta_lr delta_lr_lasche_neu))
			  )
			)
			
	    (if (= qsform_at "U")
	    	(progn   
	    		(if (= (Connect.get CastaData satr-shtr)  1)
			    	(Lochbild.set lchbAtrgSteg 	(Klemml (+ alteKlemml dpDiff))
			       														;(DxSKopf (+ altesDxS dpDiff))
			    	)
			    )
			    (if (= (Connect.get CastaData satr-shtr) -1)
			    	(Lochbild.set lchbAtrgSteg 	(Klemml (+ alteKlemml dpDiff))
			       														(DxSKopf (+ altesDxS dpDiff))
			    	)
			    )
			     
			    (setq delta_lr_lasche_alt	(Blech.get lasche delta_lr))
			       
			    (setq delta_lr_lasche_neu 0)
			  	
			  	(if (= (Connect.get CastaData satr-shtr)  1)	
			  		(setq delta_lr_lasche_neu (+ delta_lr_lasche_alt (* 0.5 dpDiff)))
			  	)
			  	(if (= (Connect.get CastaData satr-shtr) -1)	
			  		(setq delta_lr_lasche_neu (- delta_lr_lasche_alt (* 0.5 dpDiff)))
			  	)
			  	
			  	(print delta_lr_lasche_neu)
			    (Blech.set lasche (delta_lr delta_lr_lasche_neu))
			  )
			)
			
	    ))
	))
)


; -------------------------------------------------------------
; Setzt das Anbauteil fr das Blech
; -------------------------------------------------------------
(defun setAnbauteilBlech (BLECH_ID)
	(print ">-----------------------------------------------------------")
	(print "SETZE ANBAUTEIL BLECH")
	
	(Connect.showAttributes CastaData)
	
	; xPos
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	
	; Anbauteil Fahne Rotations-Winkel 
	(setq r_winkel_at (Traeger.get Tr_ID r_winkel))
	(setq h_winkel_ht	(Connect.get CastaData hpttrg_hwinkel))
	
	(setq xxxWinkel (Connect.get CastaData  r-atrgewnkl_kopf))
	(print "------------------")
	(print xxxWinkel)
	
	(print h_winkel_ht)
	(print r_winkel_at)
	
	(setq r_winkel_blech (- h_winkel_ht r_winkel_at))
	(print r_winkel_blech)
	
	(if (= (Connect.get CastaData LinkesEnde) 1)		(setq r_winkel_blech (- r_winkel_blech))	)
	(print r_winkel_at)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(if (= (Connect.get CastaData satr-shtr) -1)	(setq r_winkel_blech r_winkel_blech))
			(if (= (Connect.get CastaData satr-shtr)  1)	(setq r_winkel_blech r_winkel_blech))
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(if (= (Connect.get CastaData satr-shtr) -1)	(setq r_winkel_blech (+ r_winkel_blech 180.0)))
			(if (= (Connect.get CastaData satr-shtr)  1)	(setq r_winkel_blech (+ r_winkel_blech 180.0)))
		)
	)
	(print r_winkel_at)
	(print r_winkel_blech)


	(setq AFL_HWinkel (Connect.get CastaData AFL_HWinkel))
	(setq r_winkel_blech (- h_winkel_ht r_winkel_at))
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(if (= AFL_HWinkel 180.0)	(setq r_winkel_blech (+ r_winkel_blech 180.0)))
		)
	)
	(if (= (Connect.get CastaData AmHTOberflansch) 1)
		(progn
			(setq r_winkel_blech (+ r_winkel_blech 180.0))
		)
	)

	; Anbauteil Lasche dem HT hinzufgen
;	(setq r_winkel_blech 180.0)
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(Traeger.addabtl Htrg BLECH_ID xPos_ht r_winkel_blech _fahnenblech_of_)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(Traeger.addabtl Htrg BLECH_ID xPos_ht r_winkel_blech _fahnenblech_uf_)
	)
	
	
	
	
	
	; delta_v Lasche
	; ******************************************************************
	
	; Anteil delta_v AT
	; --------------------------
	(setq delta_v_at (Traeger.get Tr_ID delta_v))
	(print delta_v_at)
	
	(setq delta_v_abtl_lasche delta_v_at)
;	(if (= (Connect.get CastaData satr-shtr)  1)
;		(progn
;			(if (= (Connect.get CastaData vatr-lhtr)  1) 	(setq delta_v_abtl_lasche (- delta_v_at) ))
;			(if (= (Connect.get CastaData vatr-lhtr) -1) 	(setq delta_v_abtl_lasche delta_v_at) )
;		)
;	)
;	(if (= (Connect.get CastaData satr-shtr) -1)
;		(progn
;			(if (= (Connect.get CastaData vatr-lhtr)  1) 	(setq delta_v_abtl_lasche (- delta_v_at) ))
;			(if (= (Connect.get CastaData vatr-lhtr) -1) 	(setq delta_v_abtl_lasche delta_v_at) )
;		)
;	)
;	(if (= (Connect.get CastaData satr-shtr)  0)
;		(progn
;			(if (= (Connect.get CastaData RechtesEnde) 1)	(setq delta_v_abtl_lasche delta_v_at)	)
;			(if (= (Connect.get CastaData LinkesEnde)  1)	(setq delta_v_abtl_lasche delta_v_at)			)
;		)
;	)
	
	; Anteil delta_v HT
	; --------------------------
	(setq delta_v_ht (Traeger.get Htrg delta_v))
	
	(setq VWnkl (Connect.get CastaData hpttrg_vwinkel))
	
	(if (< VWnkl 180.0) (setq HelpWnkl VWnkl))
	(if	(> VWnkl 180.0) (setq HelpWnkl (- VWnkl 360)))
	(print HelpWnkl)
	
	(setq sinW (sin (/ (* PI HelpWnkl) 180.0)))
	(print sinW)
	
	(setq anteil_delta_v_ht (* delta_v_ht sinW))
	(print anteil_delta_v_ht)


	; korrigiert im Apr. 2013 - alles viel einfacher ...
	(if (= (Connect.get CastaData vatr-lhtr) -1) (setq delta_v_abtl_lasche (+ delta_v_abtl_lasche anteil_delta_v_ht)))
	(if (= (Connect.get CastaData vatr-lhtr)  1) (setq delta_v_abtl_lasche (- delta_v_abtl_lasche anteil_delta_v_ht)))

;	(if (= (Connect.get CastaData LinkesEnde) 1)
;		(progn
;			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_lasche (+ delta_v_abtl_lasche anteil_delta_v_ht)))
;			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_lasche (- delta_v_abtl_lasche anteil_delta_v_ht)))
;			(setq delta_v_abtl_lasche (+ delta_v_abtl_lasche anteil_delta_v_ht))
;		)
;	)
;	(if (= (Connect.get CastaData RechtesEnde) 1)
;		(progn
;			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_lasche (- delta_v_abtl_lasche anteil_delta_v_ht)))
;			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_lasche (+ delta_v_abtl_lasche anteil_delta_v_ht)))
;			(setq delta_v_abtl_lasche (+ delta_v_abtl_lasche anteil_delta_v_ht))
;		)
;	)
	
	
	
	; Anteil delta_lr HT
	; --------------------------
	(setq delta_lr_ht (Traeger.get Htrg delta_lr))
	
	(setq delta_lr_abtl_lasche 0.0)
		
	;(setq delta_lr_abtl_lasche (+ delta_lr_abtl_lasche delta_lr_ht))
	
	
	; Neigung des Fahnenblechs bestimmen
	; --------------------------
	(setq nwinkel (Connect.get CastaData hpttrg_vwinkel))
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(if (= (Connect.get CastaData satr-shtr) -1)	(setq nwinkel (- nwinkel)))
			(if (= (Connect.get CastaData satr-shtr)  1)	(setq nwinkel nwinkel))
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(if (= (Connect.get CastaData satr-shtr) -1)	(setq nwinkel nwinkel))
			(if (= (Connect.get CastaData satr-shtr)  1)	(setq nwinkel (- nwinkel)))
		)
	)
	
	
	
	
	; Werte setzen
	; --------------------------
	(setq abtl_lasche (Traeger.get Htrg Abteil BLECH_ID))
	(Anbauteil.set abtl_lasche 	(delta_v 		delta_v_abtl_lasche)
					(delta_lr		delta_lr_abtl_lasche)
					(neigwnkl_q		(- nwinkel))
	)
	
	
	(print "<-----------------------------------------------------------")
)


; -------------------------------------------------------------
; Berechnet das Unterzugende
; -------------------------------------------------------------
(defun berechneTraegerEnde (TrgEnde)
	(print "BERECHNE TRGERENDE")
	(setq	h_at 		(Traeger.get Tr_ID h)
		delta_v_at 	(Traeger.get Tr_ID delta_v)
	)
	
	(setq delta_l (- (* 0.5 h_at)))
	
	; delta_v Verschiebung der Sttze
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr) -1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_l (- delta_l delta_v_at)))
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_l (+ delta_l delta_v_at)))
				)
			)
			(if (= (Connect.get CastaData satr-lhtr)  1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_l (- delta_l delta_v_at)))
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_l (+ delta_l delta_v_at)))
				)
			)
			(if (= (Connect.get CastaData satr-shtr) -1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_l (- delta_l delta_v_at)));ok
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_l (+ delta_l delta_v_at)))
				)
			)
			(if (= (Connect.get CastaData satr-shtr)  1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_l (- delta_l delta_v_at)))
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_l (+ delta_l delta_v_at)))
				)
			)
		)
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr) -1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_l (+ delta_l delta_v_at)));ok
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_l (- delta_l delta_v_at)));ok
				)
			)
			(if (= (Connect.get CastaData satr-lhtr)  1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_l (+ delta_l delta_v_at)));ok
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_l (- delta_l delta_v_at)));ok
				)
			)
			(if (= (Connect.get CastaData satr-shtr) -1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_l (+ delta_l delta_v_at)));ok
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_l (- delta_l delta_v_at)));ok
				)
			)
			(if (= (Connect.get CastaData satr-shtr)  1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_l (+ delta_l delta_v_at)));ok
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_l (- delta_l delta_v_at)));ok
				)
			)
		)
	)
	
	; am Oberflansch nochmal negieren
	
	(TrEnde.set TrgEnde (delta_l delta_l)) 
)
; -------------------------------------------------------------
; Krzt die Giebelsttze
; -------------------------------------------------------------
(defun berechneStuetzenEnde (minAbstand TrgEnde)
	(print "------------------- in berechneStuetzenEnde")
	(setq	h_htrg 		(Traeger.get Htrg h)
		delta_v_htrg	(Traeger.get Htrg delta_v)
	)
	(setq	h_trg 		(Traeger.get Tr_ID h)
		b_trg		(Traeger.get Tr_ID b)
		r_Wnkl		(Traeger.get Tr_ID r_winkel)
		delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	(setq	VWnkl		(Connect.get CastaData HptTrg_VWinkel)
		anschl_wnkl	(Connect.get CastaData at_laengswinkel)
	)
	
	(print h_htrg)
	(print h_trg)
	(print VWnkl)
	
	(if (< VWnkl 180.0) (setq HelpWnkl VWnkl))
	(if	(> VWnkl 180.0) (setq HelpWnkl (- VWnkl 360)))
	(print HelpWnkl)
	
	(setq cosW (cos (/ (* PI HelpWnkl) 180.0))
				tanW (tan (/ (* PI HelpWnkl) 180.0))
	)
	
	(print cosW)
	(print tanW)
	
	; Anteil HT (vom Systempunkt zur Flanschkante)
	; --------------------------	
	(setq anteil_h_htrg (/ (* 0.5 h_htrg) cosW))
	(print anteil_h_htrg)
		
	(setq delta_l (+ minAbstand anteil_h_htrg))
	
	
	; Anteil durch Neigung des HT
	; --------------------------
	(setq anteil_durch_neigung_ht (* (* 0.5 h_trg) tanW))
	(if (< anteil_durch_neigung_ht 0)
		(setq anteil_durch_neigung_ht (- anteil_durch_neigung_ht))
	)
	(print 	anteil_durch_neigung_ht)
	
	(setq delta_l (+ delta_l anteil_durch_neigung_ht))
	
	
	; Anteil delta_v des HT
	; --------------------------
	(setq anteil_delta_v_htrg (/ delta_v_htrg cosW))
	(print anteil_delta_v_htrg)
	
	(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq delta_l (+ delta_l anteil_delta_v_htrg)))
	(if (= (Connect.get CastaData amHtOberflansch) 1)		(setq delta_l (- delta_l anteil_delta_v_htrg)))
	
	(print delta_l)
	
	; Anteil delta_v des AT
	; --------------------------
	(setq anteil_delta_v_at (* delta_v_at tanW))
	(print anteil_delta_v_at)
	
	
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_l (- delta_l anteil_delta_v_at)))
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_l (+ delta_l anteil_delta_v_at)))
				
	
	
	(print delta_l)
	
	(TrEnde.set TrgEnde (delta_l delta_l))			
)

; -------------------------------------------------------------
; Erzeugt die Lasche
; -------------------------------------------------------------
(defun calcAndSetBlechDaten (lasche)
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE BLECHDATEN")
	(setq	hc_trg 		(Traeger.get Tr_ID hc)
		s_trg		(Traeger.get Tr_ID s)
		delta_v_trg	(Traeger.get Tr_ID delta_v)
		r_Wnkl_trg	(Traeger.get Tr_ID r_winkel)
		delta_lr_at	(Traeger.get Tr_ID delta_lr)
		qsform_at	(Traeger.get Tr_ID qsform)
		h_at		(Traeger.get Tr_ID h)
	)
	(setq	b_htrg		(Traeger.get Htrg b)
		delta_lr_htrg	(Traeger.get Htrg delta_lr)
		h_ht		(Traeger.get Htrg h)
	)
	
	(setq anschl_wnkl (Connect.get CastaData at_laengswinkel))
	(print anschl_wnkl)

		
	;Dicke
	(setq maxdp s_trg)
	
	; Anteil aus HT-Neigung der hinzuaddiert werden muss.
	(setq h_at_halb (* 0.5 h_at))
	
	(if (> anschl_wnkl 90.0)	(setq anschl_wnkl (- 180.0 anschl_wnkl)))
	(print anschl_wnkl)
	
	(setq tanAW (tan (/ (* PI anschl_wnkl) 180.0)))
	(setq sinAW (sin (/ (* PI anschl_wnkl) 180.0)))
	
	(setq anteil_ht_neigung (/ h_at_halb tanAW))
	(print anteil_ht_neigung)
	
	
	; delta_lr des Bleches
	(setq delta_lr_soll (+ (* 0.5 maxdp) (* 0.5 s_trg)))
	
	(if (= qsform_at "U")
		(progn
			(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_soll (+ (* 0.5 maxdp) s_trg)))
			(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_soll (- (+ (* 0.5 maxdp) s_trg))))
		)
	)
	
	(setq delta_lr_soll (- delta_lr_soll))
	
	
	; Anteil delta_lr HT
	(setq delta_lr_ht (Traeger.get Htrg delta_lr))
	
	(setq r_w_at			(Traeger.get Tr_ID r_winkel))
	(setq h_w_ht			(Connect.get CastaData hpttrg_hwinkel))
	
	(setq r_w_b (- h_w_ht r_w_at))
	
	(setq cosAT	(cos (/ (* PI r_w_b) 180.0)))
	(setq sinAT	(sin (/ (* PI r_w_b) 180.0)))
	
	(setq anteil_delta_lr	(* cosAT delta_lr_ht))
	(setq anteil_delta_v	(* sinAT delta_lr_ht))
	(print sinAT)
	
	; delta-LR-Verschiebung des HT 
	(if (= (Connect.get CastaData LinkesEnde) 1)  (setq delta_lr_soll (- delta_lr_soll anteil_delta_lr)))
	(if (= (Connect.get CastaData RechtesEnde) 1) (setq delta_lr_soll (+ delta_lr_soll anteil_delta_lr)))

	
	; dok Lasche
	(setq dok_lasche 0)
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq dok_lasche (+ dok_lasche anteil_delta_v)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq dok_lasche (- dok_lasche anteil_delta_v)))
	
	; Anteil aus delta_lr Verschiebung des AT
	(if (= (Connect.get CastaData LinkesEnde) 1)  (setq delta_lr_soll (+ delta_lr_soll delta_lr_at)))
	(if (= (Connect.get CastaData RechtesEnde) 1) (setq delta_lr_soll (- delta_lr_soll delta_lr_at)))

	(Blech.set lasche	(dp 		maxdp) 
				(delta_lr 	delta_lr_soll)
				(dok 		dok_lasche)
	)
	
	(print "<-------------------------------------------------------------------------------")
)


; ----------------------------------------------------------------------------
; Berechnet die Lochbilddaten des Fahnenblechlochbildes (bezogen auf AT)
; ----------------------------------------------------------------------------
(defun calcFahnenLochbildDaten (Lchb_ID BlechID)
	(print "ERZEUGE LOCHBILD")
	(print "------------------------------------------------------------")
	(Lochbild.set Lchb_ID	(Anz_S    2)
				(S_Bez   "M20")
				(Guete   "4.6")
	)
	
	
	(setq	dp_blech 	(Blech.get BlechID dp)
		hp_blech	(Blech.get BlechID hp)
		delta_lr_blech	(Blech.get BlechID delta_lr)
	)
	(setq	s_at		(Traeger.get Tr_ID s)
		h_at		(Traeger.get Tr_ID h)
		delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	(setq	h_ht		(Traeger.get Htrg h)
		delta_v_ht	(Traeger.get Htrg delta_v)
	)
	
	(if (> delta_v_ht 0.0)
		(setq delta_v_ht (- delta_v_ht))
	)
	
	; min. Loch- u. Randabstnde
	(calcMinRandLochAbst Lchb_ID)
	
	; e0
	(setq e0 (* 0.5 h_at))
	; w0
	(setq w0 e_min_rund)
	; w1
	(setq w1 (+ w0 e1_min_rund))
		
	;dxsKopf
	(setq dxSKopf	(* 0.5 dp_blech))
	
	(if (= qsform_at "U")
		(progn
			(if (= (Connect.get CastaData satr-shtr) -1) (setq dxSKopf	(* 0.5 dp_blech)))
			(if (= (Connect.get CastaData satr-shtr)  1) (setq dxSKopf	(+ (* 0.5 dp_blech) s_at)))
		)
	)
	
	(Lochbild.set Lchb_ID	(klemml 	(+ dp_blech s_at))
				(dxSKopf	dxSKopf)
				(e0 			e0)
				;(e1				500)
				(w0				w0)
				(w1				w1)
	)
	
	
	
	(print "ENDE LOCHBILD")
)

; ------------------------------------------------------------------------
; Erzeugt das Lochbild 
; ------------------------------------------------------------------------
(defun setAnbauteilLochbild (LOCHB_ID BLECH_ID)
	(print ">-----------------------------------------------------------")
	(print "SETZE ANBAUTEIL LOCHBILD")
	(setq	h_ht		(Traeger.get Htrg h)
		s_ht		(Traeger.get Htrg s)
		delta_v_ht 	(Traeger.get Htrg delta_v)
	)
	
	(setq delta_v_at	(Traeger.get Tr_ID delta_v))
	
	(setq xPos_ht 		(Connect.get CastaData xPos_ht))
	(setq xPos_at 		(Connect.get CastaData xPos_at))
	
	(setq hp_lasche		(Blech.get BLECH_ID hp))
	
		
	(if (= (Connect.get CastaData linkesende) 1)
		(progn
			(print "Sttze links")
			(berechneStuetzenEnde minAbstand StzEndeLinks)
			(Traeger.addabtl tr_id lchbAtrgSteg XPos_at 0.0 _WnklSteglochbildLinks_)
		)
	)
	(if (= (Connect.get CastaData rechtesende) 1)
		(progn
			(print "Sttze rechts")
			(berechneStuetzenEnde minAbstand StzEndeRechts)
			(Traeger.addabtl tr_id lchbAtrgSteg XPos_at 0.0 _WnklSteglochbildRechts_)
		)
	)
	
	(print "------------------------------")
	(setq lb_ht_abtl (Traeger.get Htrg Abteil LOCHB_ID))
	(setq lb_at_abtl (Traeger.get Tr_ID Abteil LOCHB_ID))
	
	
	; Neigungswinkel
	; --------------------------
	(setq nwinkel (Connect.get CastaData hpttrg_vwinkel))
	(print nwinkel)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(if (= (Connect.get CastaData satr-shtr) -1)	(setq nwinkel nwinkel))
			(if (= (Connect.get CastaData satr-shtr)  1)	(setq nwinkel (- nwinkel)))
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(if (= (Connect.get CastaData satr-shtr) -1)	(setq nwinkel (- nwinkel)))
			(if (= (Connect.get CastaData satr-shtr)  1)	(setq nwinkel nwinkel))
		)
	)
		
	
	(setq delta_lr_abtl_ht 0.0)
	
	; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	; Anbauteil HT
	; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	
	; Positionierung (zum AT)
	(setq delta_v_abtl_ht 0)
	(setq delta_v_abtl_ht (- delta_v_abtl_ht (* 0.5 h_at)))
	
	(print delta_v_abtl_ht)
	
	
	
	; Anteil minAbstand und Riegelneigung an delta_lr des LB-Anbauteils
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht minAbstand)))
		(if (= (Connect.get CastaData amHtOberflansch) 1)		(setq delta_lr_abtl_ht (- delta_lr_abtl_ht minAbstand)))
		
		(setq ht_vwinkel (Connect.get CastaData hpttrg_vwinkel))
		(setq tanHTW (tan (/ (* PI ht_vwinkel) 180.0)))
		(setq h_at_halb (* 0.5 h_trg))
		(setq anteil_durch_neigung_ht (* h_at_halb tanHTW))
		(if (< anteil_durch_neigung_ht 0.0) (setq anteil_durch_neigung_ht (- anteil_durch_neigung_ht)))
		
		(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_durch_neigung_ht)))
		(if (= (Connect.get CastaData amHtOberflansch) 1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_durch_neigung_ht))) 	
	; ----------------------------------------------
	))	
	; ----------------------------------------------
	
	
	
	; Anteil von delta_v HT (Riegel) an delta_v LB-ABTL
	; ----------------------------------------------
	(if (= 1 1)	(progn	
	; ----------------------------------------------
		(setq delta_v_ht (Traeger.get Htrg delta_v))
		(print delta_v_ht)
		(setq VWnkl (Connect.get CastaData hpttrg_vwinkel))
		(print VWnkl)
		(if (< VWnkl 180.0) (setq HelpWnkl VWnkl))
		(if	(> VWnkl 180.0) (setq HelpWnkl (- VWnkl 360.0)))
		(print HelpWnkl)
		
		(setq sinW (sin (/ (* PI HelpWnkl) 180.0)))
		(print sinW)
		
		(setq anteil_delta_v_ht (* (* 1.0 delta_v_ht) sinW))
		(print anteil_delta_v_ht)
		(setq anteil_delta_v_ht (- anteil_delta_v_ht))
		
		; korr. April 2013 - ist viel einfacher als urspr. gedacht.
		(if (= (Connect.get CastaData vatr-lhtr) -1) (setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_delta_v_ht)))
		(if (= (Connect.get CastaData vatr-lhtr)  1) (setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_ht)))
;		(if (= (Connect.get CastaData LinkesEnde) 1)
;			(progn
;				(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_ht)))
;				(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_delta_v_ht)))
;			)
;		)
;		(if (= (Connect.get CastaData RechtesEnde) 1)
;			(progn
;				(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_delta_v_ht)))
;				(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_ht)))
;			)
;		)
	; ----------------------------------------------
	))	
	; ----------------------------------------------



	; Anteil von delta_v HT (Riegel) an delta_lr LB-ABTL
	; ----------------------------------------------
	(if (= 1 1)	(progn	
	; ----------------------------------------------
		(setq delta_v_ht (Traeger.get Htrg delta_v))
		(print delta_v_ht)
		(setq VWnkl (Connect.get CastaData hpttrg_vwinkel))
		(print VWnkl)
		(if (< VWnkl 180.0) (setq HelpWnkl VWnkl))
		(if	(> VWnkl 180.0) (setq HelpWnkl (- VWnkl 360.0)))
		;(setq HelpWnkl VWnkl)
		(print HelpWnkl)
		
		(setq cosW2 (cos (/ (* PI HelpWnkl) 180.0)))
		(print cosW2)
		
		(setq help_delta_lr_ht (* (* 1.0 delta_v_ht) cosW2))
		(print help_delta_lr_ht)
		(setq help2_delta_lr_ht (/ (* 1.0 delta_v_ht) cosW2))
		(print help2_delta_lr_ht)
		
		(setq anteil_delta_lr_ht (- help2_delta_lr_ht help_delta_lr_ht))
		(print anteil_delta_lr_ht)
		
		(if (= (Connect.get CastaData LinkesEnde) 1)
			(progn
				(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_delta_lr_ht)))
				(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_delta_lr_ht)))
			)
		)
		(if (= (Connect.get CastaData RechtesEnde) 1)
			(progn
				(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_delta_lr_ht)))
				(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_delta_lr_ht)))
			)
		)
	; ----------------------------------------------
	))	
	; ----------------------------------------------



	; Anteil von delta_v AT (Sttze) an delta_v LB-ABTL
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		; Apr.2013 - geht erheblich einfacher ...
		(setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_v_at))
		
;		(if (= (Connect.get CastaData vatr-lhtr) -1) (setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_v_at)))
;		(if (= (Connect.get CastaData vatr-lhtr)  1) (setq delta_v_abtl_ht (- delta_v_abtl_ht delta_v_at)))


;		(if (= (Connect.get CastaData LinkesEnde) 1)
;			(progn
;				(if (= (Connect.get CastaData vatr-lhtr) -1) (setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_v_at)))
;				(if (= (Connect.get CastaData vatr-lhtr)  1) (setq delta_v_abtl_ht (- delta_v_abtl_ht delta_v_at)))
;			)
;		)
;		(if (= (Connect.get CastaData RechtesEnde) 1)
;			(progn
;				(if (= (Connect.get CastaData vatr-lhtr) -1) (setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_v_at)))
;				(if (= (Connect.get CastaData vatr-lhtr)  1) (setq delta_v_abtl_ht (- delta_v_abtl_ht delta_v_at)))
;			)
;		)
		(print delta_v_abtl_ht)
	; ----------------------------------------------
	))	
	; ----------------------------------------------
	
	
	
	; Anteil von delta_v AT (Sttze) an delta_lr LB-ABTL
	; ----------------------------------------------
	(if (= 1 1)	(progn	
	; ----------------------------------------------
		(setq delta_v_at (Traeger.get Tr_ID delta_v))
		(print delta_v_at)
		(setq VWnkl (Connect.get CastaData hpttrg_vwinkel))
		(print VWnkl)
		(if (< VWnkl 180.0) (setq HelpWnkl VWnkl))
		(if	(> VWnkl 180.0) (setq HelpWnkl (- VWnkl 360.0)))
		;(setq HelpWnkl VWnkl)
		(print HelpWnkl)
		
		(setq tanW3 (tan (/ (* PI HelpWnkl) 180.0)))
		(print tanW3)
				
		(setq anteil_delta_lr_at (* delta_v_at tanW3))
		(print anteil_delta_lr_at)
		
		(if (= (Connect.get CastaData LinkesEnde) 1)
			(progn
				(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_delta_lr_at)))
				(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_delta_lr_at)))
			)
		)
		(if (= (Connect.get CastaData RechtesEnde) 1)
			(progn
				(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_delta_lr_at)))
				(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_delta_lr_at)))
			)
		)
	; ----------------------------------------------
	))	
	; ----------------------------------------------
	
	
	
	(if (= 1 2)	(progn
		; Anteil delta_lr HT
		(setq delta_lr_ht (Traeger.get Htrg delta_lr))
		
		(setq r_w_at			(Traeger.get Tr_ID r_winkel))
		(setq h_w_ht			(Connect.get CastaData hpttrg_hwinkel))
		
		(setq r_w_b (- h_w_ht r_w_at))
		
		(setq cosAT	(cos (/ (* PI r_w_b) 180.0)))
		(setq sinAT	(sin (/ (* PI r_w_b) 180.0)))
		
		(setq anteil_delta_lr (* cosAT delta_lr_ht))
		(setq anteil_delta_v	(* sinAT delta_lr_ht))
		
		
		(if (= (Connect.get CastaData linkesEnde) 1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v)))
		(if (= (Connect.get CastaData rechtesEnde) 1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_delta_v)))
		
	))	
	
	
	
	; --------------------------	
	; Anbauteil HT
	; --------------------------
	(Anbauteil.set lb_ht_abtl (delta_v 	delta_v_abtl_ht)
				  (delta_lr 	delta_lr_abtl_ht)
				  (neigwnkl_q 	nwinkel)
	)
	
	
	
	
	
	; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	; Anbauteil AT
	; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	(setq delta_lr_abtl 0.0)
	
	; Anteil HT-Hhe an delta_lr LB-Anbauteil AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(setq ht_vwinkel (Connect.get CastaData hpttrg_vwinkel))
		(setq cosHTW (cos (/ (* PI ht_vwinkel) 180.0)))
		(setq h_ht_halb (* h_ht 0.5))
		
		(setq anteil_ht (/ h_ht_halb cosHTW))
			
		;(setq delta_lr_abtl (+ delta_v_ht anteil_ht))
		(setq delta_lr_abtl anteil_ht)
		(print delta_lr_abtl)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	
	; Anteil minAbstand und Riegelneigung an delta_lr des LB-Anbauteils
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(setq delta_lr_abtl (+ delta_lr_abtl minAbstand))
		
		
		(setq ht_vwinkel (Connect.get CastaData hpttrg_vwinkel))
		(setq tanHTW (tan (/ (* PI ht_vwinkel) 180.0)))
		(setq h_at_halb (* 0.5 h_trg))
		(setq anteil_durch_neigung_ht (* h_at_halb tanHTW))
		(if (< anteil_durch_neigung_ht 0.0) (setq anteil_durch_neigung_ht (- anteil_durch_neigung_ht)))
		
		(setq delta_lr_abtl (+ delta_lr_abtl anteil_durch_neigung_ht)) 	
		
	; ----------------------------------------------
	))	
	
	
	
	; ----------------------------------------------
	; Anteil delta_v des HT an delta_lr LB-Anbauteil AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ---------------------------------------------- 
		(setq ht_vwinkel (Connect.get CastaData hpttrg_vwinkel))
		(setq cosHTW (cos (/ (* PI ht_vwinkel) 180.0)))
		(setq anteil_delta_v_ht (/ delta_v_ht cosHTW))
		(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq delta_lr_abtl (+ delta_lr_abtl anteil_delta_v_ht)))
		(if (= (Connect.get CastaData amHtOberflansch) 1)		(setq delta_lr_abtl (- delta_lr_abtl anteil_delta_v_ht)))
	; ---------------------------------------------- 
	))
	; ---------------------------------------------- 
	
	
	
	; Anteil delta_v des AT an delta_lr LB-Anbauteil AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------	
		(setq anteil_delta_v_at (* delta_v_at tanW))
		(print anteil_delta_v_at)
		
		(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abtl (- delta_lr_abtl anteil_delta_v_at)))
		(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abtl (+ delta_lr_abtl anteil_delta_v_at)))
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	
	; --------------------------	
	; Anbauteil AT
	; --------------------------
	(Anbauteil.set lb_at_abtl (delta_lr (+ delta_lr_abtl)))
	
	
	
	; --------------------------	
	; Master festlegen
	; --------------------------
	(Anbauteil.set lb_ht_abtl (Master 1))
	(Anbauteil.set lb_at_abtl (Master 0))
		
	
	; LOCHBILD-TEST
	;===================================================================
	(if (= LB_DEBUG 1)
		(progn
			(setq dummy (Lochbild.create))
			(Lochbild.copy dummy lchbAtrgSteg)
						
			(if (= (Connect.get CastaData linkesende) 1)
				(Traeger.addabtl tr_id dummy XPos_at 0.0 _WnklSteglochbildLinks_)
			)
			(if (= (Connect.get CastaData rechtesende) 1)
				(Traeger.addabtl tr_id dummy XPos_at 0.0 _WnklSteglochbildRechts_)
			)
			
			(setq dummy_abtl (Traeger.get Tr_ID Abteil dummy))
			(Anbauteil.set dummy_abtl (Master 1)
																(delta_lr delta_lr_abtl)
			)
		)
	)
	;===================================================================
	(print "<-----------------------------------------------------------")
)


; ------------------------------------------------------------------------
; Setzt die endgltige Blechhhe und -breite
; ------------------------------------------------------------------------
(defun korrBlechdaten (BlechID)
	(print ">-----------------------------------------------------------")
	(print "KORRIGIERE BLECHDATEN")
	
	(setq anteil_bpBlech_halb (/ e_min_rund tanAW))
	
	(print minAbstand)
	(print anteil_bpBlech_halb)
	(print anteil_ht_neigung)
	(print e1_min_rund)
	(print e_min_rund)
	
	; korregiere Blech
	(Blech.set BlechID 	(bp (+ minAbstand anteil_bpBlech_halb anteil_ht_neigung e1_min_rund (* e_min_rund 2.0)))
											(hp (* 2.0 e_min_rund))
	)
	
	
	(setq bpbl (Blech.get BlechID bp))
	(print bpbl)
	(print "<-----------------------------------------------------------")
)
(defun checkFahnenWinkel ()

	(setq AbtlFahnenBl	(Traeger.get Htrg AbTeil lasche))
	(setq AbtlFahnenLchb	(Traeger.get Htrg AbTeil lchbAtrgSteg))
	
	(setq nWinkel_Q_Bl	(Anbauteil.get AbtlFahnenBl   neigwnkl_q))
	(setq nWinkel_Q_Lchb	(Anbauteil.get AbtlFahnenLchb neigwnkl_q))

	(setq rWinkel_Bl	(Anbauteil.get AbtlFahnenBl   Winkel))
	(setq rWinkel_Lchb	(Anbauteil.get AbtlFahnenLchb Winkel))
	
	(print nWinkel_Q_Bl)
	(print rWinkel_Bl)
	(print nWinkel_Q_Lchb)
	(print rWinkel_Lchb)
	
	(setq Wnkl_AFl (Connect.get CastaData hpttrg_vwinkel))
	(setq Wnkl_AFl (Connect.get CastaData afl_vwinkel))
	(print Wnkl_AFl)
	
	(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq nWinkel (- 90.0 Wnkl_AFl)))
	(if (= (Connect.get CastaData amHtOberflansch) 1)	(setq nWinkel (- Wnkl_AFl 90.0)))

	(if (= (Connect.get CastaData vAtr-lHtr) -1) (progn
		(Anbauteil.set AbtlFahnenBl   (Winkel 0.0))
		(Anbauteil.set AbtlFahnenLchb (Winkel 0.0))
		(Anbauteil.set AbtlFahnenBl   (neigwnkl_q nWinkel))
		(Anbauteil.set AbtlFahnenLchb (neigwnkl_q nWinkel))
	))
	(if (= (Connect.get CastaData vAtr-lHtr)  1) (progn
		(Anbauteil.set AbtlFahnenBl   (Winkel 180.0))
		(Anbauteil.set AbtlFahnenLchb (Winkel 180.0))
		(Anbauteil.set AbtlFahnenBl   (neigwnkl_q (- nWinkel)))
		(Anbauteil.set AbtlFahnenLchb (neigwnkl_q (- nWinkel)))
	))


)
(defun Trg_VertikalVerschiebungen ()
	(setq Wnkl_AFl (Connect.get CastaData afl_vwinkel))
	
	(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq nWinkel (- 90.0 Wnkl_AFl)))
	(if (= (Connect.get CastaData amHtOberflansch) 1)	(setq nWinkel (- Wnkl_AFl 90.0)))

	(setq AbtlFahnenBl	(Traeger.get Htrg AbTeil lasche))
	(setq AbtlFahnenLchb	(Traeger.get Htrg AbTeil lchbAtrgSteg))

)
