; $	HT	QT(F)		AF(S)		P(EZ)
; $ 	AT	QT(G)		AF(K)		P(E)
; $	AE	V(-)		H(-)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;	
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

; - r-atrgewnkl_flansch = 126.869898				
;
;  180.0 - w			w				180 + w			  	180 - (180 - w)

; - amhtoberflansch = 0		- amhtoberflansch = 1		- amhtoberflansch = 0		- amhtoberflansch = 1	
; - amhtunterflansch = 1          - amhtunterflansch = 0          - amhtunterflansch = 1  	- amhtunterflansch = 0
;
; - satr-shtr = -1		- satr-shtr = -1      		- satr-shtr = 1			- satr-shtr = 1 
; - satr-vhtr = 0                 - satr-vhtr = 0                 - satr-vhtr = 0                 - satr-vhtr = 0 
; - satr-lhtr = -1                - satr-lhtr = 1                 - satr-lhtr = 1                 - satr-lhtr = -1
; - vatr-shtr = -1                - vatr-shtr = -1                - vatr-shtr = 1                 - vatr-shtr = 1 
; - vatr-vhtr = 0                 - vatr-vhtr = 0                 - vatr-vhtr = 0                 - vatr-vhtr = 0 
; - vatr-lhtr = 1                 - vatr-lhtr = -1                - vatr-lhtr = -1                - vatr-lhtr = 1 


(defun load-modules ()
   (load "mod-messages")
)
(defun init-connection ()

  ; Einstellung...
  (setq dStufe 4)

  (print "*clear*")
  (setq LB_DEBUG 0)

  (connect.showattributes CastaData)

  (setq xPos_ht 	(Connect.get CastaData xPos_ht))
  (setq rWnkl		(Connect.get CastaData r-atrgewnkl_flansch))


  (setq abtl_winkel_ht rWnkl)
  (if (= (Connect.get CastaData vatr-lhtr) 1)  (setq abtl_winkel_ht  (- 180.0   rWnkl)))
  (if (= (Connect.get CastaData satr-shtr) 1)  (setq abtl_winkel_ht  (+ 180.0   abtl_winkel_ht)))
 

  ; Objekt erzeugen und in den HT einbringen
  (setq Lochb_ID (lochbild.create))
  (Traeger.addAbtl Htrg Lochb_ID xPos_ht abtl_winkel_ht _flanschlochbild_of_)

  (Connect.storeAnschlObjs CastaData Lochb_ID)


  (berechneLochbildVerschiebung)
  (setzeLochbildmasze)
  (podestSchrauben)			; wird nur bei Podesten relevant
  
  (AT_Ablaengung)

  (setq lb_abtl_ht (Traeger.get Htrg Abteil Lochb_ID))
  (Anbauteil.set lb_abtl_ht (Master 	1))

  (if (= (Connect.get CastaData amHtOberFlansch) 1) (progn
	  (Anbauteil.set lb_abtl_ht (SeitRicht -1))
  ))

  (Lochbild.set Lochb_ID (FormFkt "cb_StufenLchb_$lb"))

)
; 			--------				------------------------------
;	Lochbild-Abstände sollen bei Kopieraktionen nicht veränderbar sein
;	Wenn also eine Stufe ausgetauscht wird, sollen die Lochbildabmessungen
;	vom Makro übernommen werden.
(defun cb_StufenLchb_$lb (zp)
	(if (= (Connect.get CastaData CopyMode) 1) (progn
		(if (= zp 0) (progn
			(setq e0_alt (Lochbild.get Lochb_ID e0))
			(setq w0_alt (Lochbild.get Lochb_ID w0))
			(setq w1_alt (Lochbild.get Lochb_ID w1))
		))
		(if (= zp 1) (progn
			(Lochbild.set Lochb_ID (e0 e0_alt))
			(Lochbild.set Lochb_ID (w0 w0_alt))
			(Lochbild.set Lochb_ID (w1 w1_alt))
		))
	))
)
; 			--------				------------------------------
(defun berechneLochbildVerschiebung ()


  (setq dv_HT	(Traeger.get HTrg  delta_LR)
  	dv_AT	(Traeger.get Tr_ID delta_V)
  	dlr_AT	(Traeger.get Tr_ID delta_LR)
  )
  
  
  
  (setq rWnkl	(Connect.get CastaData R-ATrgewnkl_Flansch)
  	sinWnk	(sin (* PI (/ rWnkl 180.0)))
  	cosWnk	(cos (* PI (/ rWnkl 180.0)))
    	cosWnk	(cos (* PI (/ rWnkl 180.0)))
  )

  (setq dv_Abtl 	(* sinWnk dv_HT)
  	dlr_Abtl	(- (* cosWnk dv_HT) dlr_AT)
  	dv_Abtl		(- dv_Abtl dv_AT)
  )

  ; Fall 1 - Normalfall ...
  ; Werte sdin so wie berechnet ....

  ; Fall 2 - nur horizontal Vorzeichenwechsel
  ; kann mit Fall 3 kombiniert sein
  (if (= (Connect.get CastaData vatr-lhtr) 1)  (progn
  	(setq	dlr_Abtl (- dlr_Abtl))
  ))
  ; Fall 3 - horizontal und vertikal Vorzeichenwechsel
  ; kann mit Fall 2 kombiniert sein
  (if (= (Connect.get CastaData satr-shtr) 1)  (progn
       (setq dv_Abtl  (- dv_Abtl))
       (setq dlr_Abtl (- dlr_Abtl))
  ))

  (setq lb_abtl_ht (Traeger.get Htrg Abteil Lochb_ID))
  (Anbauteil.set lb_abtl_ht 
  			(delta_lr	dlr_Abtl)
			(delta_v	dv_Abtl)
  )


)
; 			--------				------------------------------
(defun setzeLochbildmasze ()
  (setq
	s_w1 (Traeger.get Tr_ID r)
	s_w2 (Traeger.get Tr_ID r2)
	s_e0 (Traeger.get Tr_ID hc)
	t_HT (Traeger.get HTrg  t)
		
  )
  
  (if (= (Connect.get CastaData LinkesEnde) 1) 
  	(setq	LB_Art  2)
  )
  (if (= (Connect.get CastaData RechtesEnde) 1) 
  	(setq	LB_Art -2)
  )

  ; Testprogramm
  (if (= 1 2) (progn
	  (Lochbild.set Lochb_ID (S_Bez "M12")
  				 (Guete "4.6")
  				 (w	 "0 50")
  				 (e	 "0 50 120 0 0 0")
  				 (KlemmL 20)
	  )
  ))

  (setq v_dxSKopf 0)
  (if (= (Connect.get CastaData amHtOberflansch) 1) (setq v_dxSKopf dStufe))


  (Lochbild.set Lochb_ID (S_Bez 	"M12")
  			 (Guete 	"4.6")
  			 (LB_Art	LB_Art)
  			 (w0	 	s_w1)
 			 (w1	 	(+ s_w1 s_w2))
			 (e0	 	s_e0)
  			 (KlemmL 	(+ t_HT dStufe))
  			 (dxSKopf	v_dxSKopf)
  )



  (if (= 1 2) (progn
     (Lochbild.set Lochb_ID (e	 "0 50 120 0 0 0"))
  ))



)
; 			--------				------------------------------
(defun AT_Ablaengung ()
  (setq dv_HT	(Traeger.get HTrg  delta_V)
        t_HT	(Traeger.get HTrg  t)
  )
    
  (if (= (Connect.get CastaData LinkesEnde) 1) 
  	(setq TEnde (Traeger.get Tr_ID links))
  )
  (if (= (Connect.get CastaData RechtesEnde) 1) 
  	(setq TEnde (Traeger.get Tr_ID rechts))
  )
  
  (setq Abl 0)
  (if (= (Connect.get CastaData amHtUnterFlansch) 1) (progn
  	(setq Abl (+ (* 0.5  t_Ht) dv_HT))
  ))

  (if (= (Connect.get CastaData amHtOberFlansch) 1) (progn
  	(setq Abl (- (* 0.5  t_Ht) dv_HT))
  ))

  (TrEnde.set TEnde (delta_L Abl))
    
)
; 			--------				------------------------------
(defun podestSchrauben ()

  (setq lb_abtl_ht (Traeger.get Htrg Abteil Lochb_ID))
  (if (= (Connect.get CastaData satr-shtr) 0)  (progn
	(setq rAtr_Wnkl (Connect.get CastaData r-atrgewnkl_flansch))
	(setq s_e0 		(Traeger.get Tr_ID hc)
		  b_Stf		(Traeger.get Tr_ID b)
		  dv_AT		(Traeger.get Tr_ID delta_V)
		  dlr_AT	(Traeger.get Tr_ID delta_LR)
	)
	(setq b_HT 		(Traeger.get HTrg b)
		  dlr_HT 	(Traeger.get HTrg delta_LR)
	)
	
	(setq dv_Abtl  0.0)
	(setq dlr_Abtl 0.0)

	(if (= (Connect.get CastaData satr-lhtr) 1) (progn
			(setq dlr_Abtl (- dlr_AT))
	))
	(if (= (Connect.get CastaData satr-lhtr) -1) (progn
			(setq dlr_Abtl dlr_AT)
	))

	
	(if (= rAtr_Wnkl 90.0) (progn
	
		(if (= (Connect.get CastaData vatr-shtr) -1) (progn
			(if (= (Connect.get CastaData linkesEnde) 1)  (Lochbild.set Lochb_ID (LB_Art  2)))
			(if (= (Connect.get CastaData rechtesEnde) 1) (Lochbild.set Lochb_ID (LB_Art -2)))

			(setq dv_Abtl (+ (* -0.5 b_HT) (+ dlr_HT (* 0.5 b_HT))))
		 	(setq dv_Abtl (+ dv_Abtl dv_AT))
		
		))

		(if (= (Connect.get CastaData vatr-shtr) 1) (progn
			(if (= (Connect.get CastaData linkesEnde) 1)  (Lochbild.set Lochb_ID (LB_Art -2)))
			(if (= (Connect.get CastaData rechtesEnde) 1) (Lochbild.set Lochb_ID (LB_Art  2)))
			(setq dv_Abtl (- dlr_HT (* 0.5 b_HT)))
			(setq dv_Abtl (- dv_Abtl dv_AT))
		))

		(Anbauteil.set lb_abtl_ht 
				; (switch_on -1)
				(delta_lr	dlr_Abtl)
				(delta_v	dv_Abtl)
		)
	))
  ))

)
