; $	HT	QT(I)		AF(S)		P(EZ)
; $ 	AT	QT(G)		AF(K)		P(E)
; $	AE	V(-)		H(-)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;	
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (load "mod-messages")
)
(defun init-connection ()

  ; Einstellung...
  (setq dStufe   4)
  (setq dpBlech 12)

  (print "*clear*")
  (setq LB_DEBUG 0)

  (connect.showattributes CastaData)

  (setq xPos_ht 	(Connect.get CastaData xPos_ht))
  (setq rWnkl		(Connect.get CastaData r-atrgewnkl_steg))

  (if (= (Connect.get CastaData vatr-vhtr)  1) (progn
      (if (= (Connect.get CastaData amHtStegLinks) 1) (progn
         (if (= (connect.get CastaData LinkesEnde) 1)  (setq abtl_winkel_ht   (- rWnkl 180.0)))
         (if (= (connect.get CastaData RechtesEnde) 1) (setq abtl_winkel_ht (- rWnkl)))
      ))
      (if (= (Connect.get CastaData amHtStegRechts) 1) (progn
         (if (= (connect.get CastaData LinkesEnde) 1)  (setq abtl_winkel_ht (- rWnkl)))
         (if (= (connect.get CastaData RechtesEnde) 1) (setq abtl_winkel_ht   (- rWnkl 180.0)))
      ))
  ))
  
  (if (= (Connect.get CastaData vatr-vhtr) -1) (progn
      (if (= (Connect.get CastaData amHtStegLinks) 1) (progn
         (if (= (connect.get CastaData LinkesEnde) 1)  (setq abtl_winkel_ht (- 180.0 rWnkl)))
         (if (= (connect.get CastaData RechtesEnde) 1) (setq abtl_winkel_ht   rWnkl))
      ))
      (if (= (Connect.get CastaData amHtStegRechts) 1) (progn
         (if (= (connect.get CastaData LinkesEnde) 1)  (setq abtl_winkel_ht   rWnkl))
         (if (= (connect.get CastaData RechtesEnde) 1) (setq abtl_winkel_ht (- 180.0 rWnkl)))
      ))
  )) 

  ; Objekt erzeugen und in den HT einbringen
  (setq Lochb_ID (lochbild.create))
;  (Traeger.addAbtl Htrg Lochb_ID xPos_ht abtl_winkel_ht _steglochbild_system_)

  (setq abtl_winkel_ht (+ 90.0 abtl_winkel_ht))

  (setq cpFrontBlech (Blech.create))
  (if (= (Connect.get CastaData amHtStegLinks) 1) (progn
      (Traeger.addabtl Htrg cpFrontBlech xPos_ht 0.0 _blechcoupon_links_)
      (Traeger.addAbtl Htrg Lochb_ID xPos_ht abtl_winkel_ht _couponlochbild_links_)
  ))
  (if (= (Connect.get CastaData amHtStegRechts) 1) (progn
      (Traeger.addabtl Htrg cpFrontBlech xPos_ht 0.0 _blechcoupon_rechts_)
      (Traeger.addAbtl Htrg Lochb_ID xPos_ht abtl_winkel_ht _couponlochbild_rechts_)
  ))

  (Connect.storeAnschlObjs CastaData Lochb_ID cpFrontBlech)

  (Blech.set cpFrontBlech
		(dp dpBlech)
		(hp 200)
		(bp 100)
		; (x1 40) (y1 50)
		; (x3 40) (y3 50)
  )
  ; (setq Bl_abtl_HT (Traeger.get Htrg Abteil cpFrontBlech))
  ; (Anbauteil.set Bl_abtl_HT (Winkel 30))


  (berechneLochbildVerschiebung)
  (setzeLochbildmasze)
  (AT_Ablaengung)

  (setq lb_abtl_ht (Traeger.get Htrg Abteil Lochb_ID))
  (Anbauteil.set lb_abtl_ht (Master 	1))

  (setq b_HT (Traeger.get HTrg b))

  (if (= (Connect.get CastaData amHtStegLinks) 1) (progn
	  (Anbauteil.set lb_abtl_ht (delta_sx -200))
	  (Lochbild.set Lochb_ID (dlr_coupon (- (* 0.5 b_HT))))
  ))
  (if (= (Connect.get CastaData amHtStegRechts) 1) (progn
	  (Anbauteil.set lb_abtl_ht (SeitRicht -1))
	  (Lochbild.set Lochb_ID (dlr_coupon   (* 0.5 b_HT)))
  ))

  (Lochbild.set Lochb_ID (FormFkt "cb_StufenLchb_$lb"))	

)
; 			--------				------------------------------
;	Lochbild-Abstände sollen bei Kopieraktionen nicht veränderbar sein
;	Wenn also eine Stufe ausgetauscht wird, sollen die Lochbildabmessungen
;	vom Makro übernommen werden.
(defun cb_StufenLchb_$lb (zp)
	(if (= (Connect.get CastaData CopyMode) 1) (progn
		(if (= zp 0) (progn
			(setq e0_alt (Lochbild.get Lochb_ID e0))
			(setq w0_alt (Lochbild.get Lochb_ID w0))
			(setq w1_alt (Lochbild.get Lochb_ID w1))
		))
		(if (= zp 1) (progn
			(Lochbild.set Lochb_ID (e0 e0_alt))
			(Lochbild.set Lochb_ID (w0 w0_alt))
			(Lochbild.set Lochb_ID (w1 w1_alt))
		))
	))
)
; 			--------				------------------------------
(defun berechneLochbildVerschiebung ()

  (setq 
  	h_HT	(Traeger.get HTrg  h)
  	dv_HT	(Traeger.get HTrg  delta_V)
  	dv_AT	(Traeger.get Tr_ID delta_V)
  	dlr_AT	(Traeger.get Tr_ID delta_LR)
  )
  
  
  
  (setq rWnkl	(Connect.get CastaData R-ATrgewnkl_Steg)
;  	rWnkl   (+ 90.0 rWnkl)
  	sinWnk	(sin (* PI (/ rWnkl 180.0)))
  	cosWnk	(cos (* PI (/ rWnkl 180.0)))
  )
  (setq dv_Abtl 	(* sinWnk dv_HT)
  	dlr_Abtl	(- (* cosWnk dv_HT) dlr_AT)
  	dv_Abtl		(- dv_Abtl dv_AT)
  )

  (if (= (Connect.get CastaData amHtStegLinks) 1) (progn
     (if (= (Connect.get CastaData LinkesEnde) 1) 
  	(setq	dv_Abtl  (- dv_Abtl)
  		dlr_Abtl (- dlr_Abtl)
  	)
     )
     (if (= (Connect.get CastaData RechtesEnde) 1) 
  	(setq dv_Abtl  (- dv_Abtl))
     )
  ))
  (if (= (Connect.get CastaData amHtStegRechts) 1) (progn
     (if (= (Connect.get CastaData LinkesEnde) 1) 
  	(setq	dv_Abtl  (- dv_Abtl)
  	)
     )
     (if (= (Connect.get CastaData RechtesEnde) 1) 
  	(setq	dv_Abtl  (- dv_Abtl)
  		dlr_Abtl (- dlr_Abtl)
  	)
     )
  ))

  (setq SeitenVariante 0)
  (if (= (Connect.get CastaData amHtStegRechts) 1) (if (= (Connect.get CastaData RechtesEnde) 1) (setq SeitenVariante 1)))
  (if (= (Connect.get CastaData amHtStegLinks) 1)  (if (= (Connect.get CastaData LinkesEnde)  1) (setq SeitenVariante 1)))

  (if (= (Connect.get CastaData amHtStegRechts) 1) (if (= (Connect.get CastaData LinkesEnde)   1) (setq SeitenVariante 2)))
  (if (= (Connect.get CastaData amHtStegLinks) 1)  (if (= (Connect.get CastaData RechtesEnde ) 1) (setq SeitenVariante 2)))

  (setq dv_Abtl 0.0 dlr_Abtl 0.0)

  (print "--------------------------")
  (print SeitenVariante)
  (if (= (Connect.get CastaData vatr-vhtr) -1) (progn
      (if (= SeitenVariante 1) (setq SeitenVariante 3))
      (if (= SeitenVariante 2) (setq SeitenVariante 4))
  ))
  (print SeitenVariante)
 
  (if (= SeitenVariante 1) (progn
	  (setq dv_Abtl (- (* 0.5 h_HT) dv_HT))
	  (setq dlr_Abtl (* sinWnk dlr_AT))
	  (setq dv_Abtl  (+ dv_Abtl (* cosWnk dlr_AT)))
	
	  (setq dlr_Abtl (- dlr_Abtl (* cosWnk dv_AT)))
	  (setq dv_Abtl  (+ dv_Abtl (* sinWnk dv_AT)))
  ))

  (if (= SeitenVariante 2) (progn
	  (setq dv_Abtl (- (* 0.5 h_HT) dv_HT))
	  (setq dlr_Abtl (- (* sinWnk dlr_AT)))
	  (setq dv_Abtl  (+ dv_Abtl (* cosWnk dlr_AT)))
	
	  (setq dlr_Abtl (+ dlr_Abtl (* cosWnk dv_AT)))
	  (setq dv_Abtl  (+ dv_Abtl (* sinWnk dv_AT)))
  ))

  (if (= SeitenVariante 3) (progn
	  (setq dv_Abtl (- (* 0.5 h_HT) dv_HT))
	  (setq dlr_Abtl (- (* sinWnk dlr_AT)))
	  (setq dv_Abtl  (+ dv_Abtl (* cosWnk dlr_AT)))
	
	  (setq dlr_Abtl (- dlr_Abtl (* cosWnk dv_AT)))
	  (setq dv_Abtl  (- dv_Abtl (* sinWnk dv_AT)))
  ))


  (if (= SeitenVariante 4) (progn
	  (setq dv_Abtl (- (* 0.5 h_HT) dv_HT))
	  (setq dlr_Abtl (* sinWnk dlr_AT))
	  (setq dv_Abtl  (+ dv_Abtl (* cosWnk dlr_AT)))
	
	  (setq dlr_Abtl (+ dlr_Abtl (* cosWnk dv_AT)))
	  (setq dv_Abtl  (- dv_Abtl (* sinWnk dv_AT)))
  ))


;  (if (= (Connect.get CastaData vatr-vhtr) -1) (progn
;       (setq dv_Abtl (- dv_Abtl))
;  ))


  (setq lb_abtl_ht (Traeger.get Htrg Abteil Lochb_ID))
  (Anbauteil.set lb_abtl_ht 
  			(delta_lr	dlr_Abtl)
			(delta_v	dv_Abtl)
  )


)
; 			--------				------------------------------
(defun setzeLochbildmasze ()
  (setq
	s_w1 (Traeger.get Tr_ID r)
	s_w2 (Traeger.get Tr_ID r2)
	s_e0 (Traeger.get Tr_ID hc)
	s_HT (Traeger.get HTrg  s)
		
  )
  
  (if (= (Connect.get CastaData LinkesEnde) 1) 
  	(setq	LB_Art  2)
  )
  (if (= (Connect.get CastaData RechtesEnde) 1) 
  	(setq	LB_Art -2)
  )

  ; Testprogramm
  (if (= 1 2) (progn
	  (Lochbild.set Lochb_ID (S_Bez "M12")
  				 (Guete "4.6")
  				 (w	 "0 50")
  				 (e	 "0 50 120 0 0 0")
  				 (KlemmL 20)
	  )
  ))

  (setq v_dxSKopf (+ dStufe dpBlech))
  (if (= (Connect.get CastaData amHtStegRechts) 1) (setq v_dxSKopf dpBlech))


  (Lochbild.set Lochb_ID (S_Bez 	"M12")
  			 (Guete 	"4.6")
  			 (LB_Art	LB_Art)
  			 (w0	 	s_w1)
 			 (w1	 	(+ s_w1 s_w2))
			 (e0	 	s_e0)
  			 (KlemmL 	(+ s_HT dStufe))
  			 (dxSKopf	v_dxSKopf)
  )

  (if (= 1 2) (progn
	  (Lochbild.set Lochb_ID 
  				 (w	 "0 50")
  				 (e	 "0 50 120 0 0 0")
  				 (KlemmL 20)
	  )
  ))



)
; 			--------				------------------------------
(defun AT_Ablaengung ()
  (setq dlr_HT	(Traeger.get HTrg  delta_LR)
        b_HT	(Traeger.get HTrg  b)
  )
    
  (if (= (Connect.get CastaData LinkesEnde) 1) 
  	(setq TEnde (Traeger.get Tr_ID links))
  )
  (if (= (Connect.get CastaData RechtesEnde) 1) 
  	(setq TEnde (Traeger.get Tr_ID rechts))
  )
  
  (if (= (Connect.get CastaData amHtStegLinks) 1) (progn
  	(TrEnde.set TEnde (delta_L (- (+ dpBlech (* 0.5 b_HT)) dlr_HT)))
  ))

  (if (= (Connect.get CastaData amHtStegRechts) 1) (progn
  	(TrEnde.set TEnde (delta_L (+    dpBlech (* 0.5 b_HT) dlr_HT)))
  ))
    
)
; 			--------				------------------------------
