; $	HT	QT(K)		AF(S)		P(EZ)
; $ 	AT	QT(G)		AF(K)		P(E)
; $	AE	V(-)		H(-)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;	
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (load "mod-messages")
)
(defun init-connection ()

  ; Einstellung...
  (setq dStufe 4)

  (print "*clear*")
  (setq LB_DEBUG 0)

  (connect.showattributes CastaData)

  (setq xPos_ht 	(Connect.get CastaData xPos_ht))
  (setq rWnkl		(Connect.get CastaData r-atrgewnkl_steg))

  (if (= (Connect.get CastaData vatr-vhtr)  1) (progn
      (if (= (Connect.get CastaData amHtStegLinks) 1) (progn
         (if (= (connect.get CastaData LinkesEnde) 1)  (setq abtl_winkel_ht   (- rWnkl 180.0)))
         (if (= (connect.get CastaData RechtesEnde) 1) (setq abtl_winkel_ht (- rWnkl)))
      ))
      (if (= (Connect.get CastaData amHtStegRechts) 1) (progn
         (if (= (connect.get CastaData LinkesEnde) 1)  (setq abtl_winkel_ht (- rWnkl)))
         (if (= (connect.get CastaData RechtesEnde) 1) (setq abtl_winkel_ht   (- rWnkl 180.0)))
      ))
  ))
  
  (if (= (Connect.get CastaData vatr-vhtr) -1) (progn
      (if (= (Connect.get CastaData amHtStegLinks) 1) (progn
         (if (= (connect.get CastaData LinkesEnde) 1)  (setq abtl_winkel_ht (- 180.0 rWnkl)))
         (if (= (connect.get CastaData RechtesEnde) 1) (setq abtl_winkel_ht   rWnkl))
      ))
      (if (= (Connect.get CastaData amHtStegRechts) 1) (progn
         (if (= (connect.get CastaData LinkesEnde) 1)  (setq abtl_winkel_ht   rWnkl))
         (if (= (connect.get CastaData RechtesEnde) 1) (setq abtl_winkel_ht (- 180.0 rWnkl)))
      ))
  )) 
  (if (= (Connect.get CastaData vatr-vhtr)  0) (progn
      (if (= (Connect.get CastaData vatr-lhtr) -1) (progn
  	(if (= (connect.get CastaData LinkesEnde) 1) (setq abtl_winkel_ht   (- 180.0 rWnkl)))
  	(if (= (connect.get CastaData RechtesEnde) 1) (setq abtl_winkel_ht           rWnkl))
      ))
      (if (= (Connect.get CastaData vatr-lhtr)  1) (progn
  	(if (= (connect.get CastaData LinkesEnde) 1) (setq abtl_winkel_ht   (- 180.0 rWnkl)))
  	(if (= (connect.get CastaData RechtesEnde) 1) (setq abtl_winkel_ht    rWnkl))
      ))
  ))
  

  ; Objekt erzeugen und in den HT einbringen
  (setq Lochb_ID (lochbild.create))
  (Traeger.addAbtl Htrg Lochb_ID xPos_ht abtl_winkel_ht _steglochbild_system_)
  (Connect.storeAnschlObjs CastaData Lochb_ID)


  (berechneLochbildVerschiebung)
  (setzeLochbildmasze)
  (AT_Ablaengung)

  (setq lb_abtl_ht (Traeger.get Htrg Abteil Lochb_ID))
  (Anbauteil.set lb_abtl_ht (Master 	1))

  (if (= (Connect.get CastaData amHtStegRechts) 1) (progn
	  (Anbauteil.set lb_abtl_ht (SeitRicht -1))
  ))

  	

)
; 			--------				------------------------------
(defun berechneLochbildVerschiebung ()

  (setq dv_HT	(Traeger.get HTrg  delta_V)
  	dv_AT	(Traeger.get Tr_ID delta_V)
  	dlr_AT	(Traeger.get Tr_ID delta_LR)
  )
  
  
  
  (setq rWnkl	(Connect.get CastaData R-ATrgewnkl_Steg)
  	sinWnk	(sin (* PI (/ rWnkl 180.0)))
  	cosWnk	(cos (* PI (/ rWnkl 180.0)))
    	cosWnk	(cos (* PI (/ rWnkl 180.0)))
  )
  (setq dv_Abtl 	(* sinWnk dv_HT)
  	dlr_Abtl	(- (* cosWnk dv_HT) dlr_AT)
  	dv_Abtl		(- dv_Abtl dv_AT)
  )

  (if (= (Connect.get CastaData amHtStegLinks) 1) (progn
     (if (= (Connect.get CastaData LinkesEnde) 1) 
  	(setq	dv_Abtl  (- dv_Abtl)
  		dlr_Abtl (- dlr_Abtl)
  	)
     )
     (if (= (Connect.get CastaData RechtesEnde) 1) 
  	(setq dv_Abtl  (- dv_Abtl))
     )
  ))
  (if (= (Connect.get CastaData amHtStegRechts) 1) (progn
     (if (= (Connect.get CastaData LinkesEnde) 1) 
  	(setq	dv_Abtl  (- dv_Abtl)
  	)
     )
     (if (= (Connect.get CastaData RechtesEnde) 1) 
  	(setq	dv_Abtl  (- dv_Abtl)
  		dlr_Abtl (- dlr_Abtl)
  	)
     )
  ))

  (if (= (Connect.get CastaData vatr-vhtr) -1) (progn
       (setq dv_Abtl (- dv_Abtl))
  ))


  (setq lb_abtl_ht (Traeger.get Htrg Abteil Lochb_ID))
  (Anbauteil.set lb_abtl_ht 
  			(delta_lr	dlr_Abtl)
			(delta_v	dv_Abtl)
  )


)
; 			--------				------------------------------
(defun setzeLochbildmasze ()
  (setq
	s_w1 (Traeger.get Tr_ID r)
	s_w2 (Traeger.get Tr_ID r2)
	s_e0 (Traeger.get Tr_ID hc)
	s_HT (Traeger.get HTrg  s)
	b_HT (Traeger.get HTrg  b)
  )
  
  (if (= (Connect.get CastaData LinkesEnde) 1) 
  	(setq	LB_Art  2)
  )
  (if (= (Connect.get CastaData RechtesEnde) 1) 
  	(setq	LB_Art -2)
  )

  ; Testprogramm
  (if (= 1 2) (progn
	  (Lochbild.set Lochb_ID (S_Bez "M12")
  				 (Guete "4.6")
  				 (w	 "0 50")
  				 (e	 "0 50 120 0 0 0")
  				 (KlemmL 20)
	  )
  ))

  (setq v_dxSKopf dStufe)
  (setq v_dxSKopf (- v_dxSKopf (* 0.5 b_HT)))
  (if (= (Connect.get CastaData amHtStegRechts) 1) (setq v_dxSKopf (- (+ (- dStufe) (* 0.5 b_HT)))))
  (if (= (Connect.get CastaData amHtStegLinks)  1) (setq v_dxSKopf    (+    dStufe  (* 0.5 b_HT))))

  (Lochbild.set Lochb_ID (S_Bez 	"M12")
  			 (Guete 	"4.6")
  			 (LB_Art	LB_Art)
  			 (Montage	    7)		; Hollo-Bolt-Schraube
  			 (w0	 	s_w1)
 			 (w1	 	(+ s_w1 s_w2))
			 (e0	 	s_e0)
  			 (KlemmL 	(+ s_HT dStufe))
  			 (dxSKopf	v_dxSKopf)
  )

  (if (= 1 2) (progn
	  (Lochbild.set Lochb_ID 
  				 (w	 "0 50")
  				 (e	 "0 50 120 0 0 0")
  				 (KlemmL 20)
	  )
  ))



)
; 			--------				------------------------------
(defun AT_Ablaengung ()
  (setq dlr_HT	(Traeger.get HTrg  delta_LR)
        b_HT	(Traeger.get HTrg  b)
  )
    
  (if (= (Connect.get CastaData LinkesEnde) 1) 
  	(setq TEnde (Traeger.get Tr_ID links))
  )
  (if (= (Connect.get CastaData RechtesEnde) 1) 
  	(setq TEnde (Traeger.get Tr_ID rechts))
  )
  
  (if (= (Connect.get CastaData amHtStegLinks) 1) (progn
  	(TrEnde.set TEnde (delta_L (+ (- dlr_HT) (* 0.5 b_HT))))
  ))

  (if (= (Connect.get CastaData amHtStegRechts) 1) (progn
  	(TrEnde.set TEnde (delta_L (+ dlr_HT (* 0.5 b_HT))))
  ))
    
)
; 			--------				------------------------------
